' $segment
' $linesize:132
' $title: 'RBBSSUB7.BAS 17.4/CDor, Copyright 1993 by Daniel T. Drinnon'
'  RBBS-PC Copyright 1992 by D. Thomas Mack, all rights reserved.
'
'  Name ...............: RBBSSUB7.BAS
'  First Released .....: August 1994
'  Subsequent Releases.: 
'  Copyright ..........: 1993,1994,1995,1996,1997
'  Purpose.............: Subroutines for RBBS-PC/CDor
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
'  $INCLUDE: 'RBBS-VAR.BAS'
'
' ***  WILDDOWN  -  Find matches to input for download  ***
'
' * read in the config file
'
100 SUB WILDDOWN (ZFileName$, ZMarkedFiles$, ZFastFileList$, Found) STATIC
'
    REDIM ZOutTxtAra$(99)

    Found = ZFalse

    '* "{C5Searching for Matches to {CB{ZZ {CO(<Ctrl-X> aborts{RC"
    LineNum = 945
    CRCount = 0
    GOSUB 810
    NumDots = 0
    CfgFileName$ = LEFT$(ZFastFileList$, INSTR(ZFastFileList$, ".") -1) + ".CFG"
    CLOSE 2
    CALL OpenWork (2,CfgFileName$)
    CALL ReadDir (2,1)
    MaxFiles = VAL(ZOutTxt$)
'
' * check for previously marked files
'
    IF LEN(ZMarkedFiles$) > MaxFiles * 13 THEN
       '* "{CR{CF{G4Too Many Files Already Marked!{RC"
       LineNum = 946
       CRCount = 1
       GOSUB 810
       ZFileName$ = ""
       EXIT SUB
    END IF
'
' * save the current list of marked files
'
   HoldMarkedFiles$ = ZMarkedFiles$
'
' * read in the directories from the FIDX.CFG and check Security Level
'
    Index = 1
    DO WHILE NOT EOF(2)
       CALL ReadDir (2,1)
       Level = INSTR(ZOutTxt$,",")
       IF ZUserSecLevel >= VAL(LEFT$(ZOutTxt$,Level-1)) THEN
          ZOutTxtAra$(Index) = RIGHT$(ZOutTxt$,LEN(ZOutTxt$)-Level)
          Index = Index + 1
       END IF
    LOOP
    CLOSE 2
'
' * search in the Upload and Download Directories listed in the FIDX.CFG
'
200 TotalMatch = 0
    SearchDir = 1
    ZMarkedFiles$ = ""
    DO WHILE SearchDir < Index
       GOSUB 700
       IF KillSearch THEN GOTO 400
       MatchFile$ = ""
       FILESPEC$ = ZOutTxtAra$(SearchDir) + ZFileName$
       IF SearchDir = 1 THEN
          '* "{CR{C5Searching {CBUPLOADS{RC"
          LineNum = 947
          CRCount = 0
          GOSUB 810
       END IF
       CALL MarkTime (NumDots)
       MatchFile$ = DIR$(FILESPEC$)
       IF MatchFile$ <> "" THEN
          IF INSTR(ZMarkedFiles$,MatchFile$) = 0 THEN
             ZMarkedFiles$ = ZMarkedFiles$ + MatchFile$ + CHR$(13)
             TotalMatch = TotalMatch + 1
          END IF
          MatchFile$ = DIR$
          DO WHILE MatchFile$ <> ""
             CALL MarkTime (NumDots)
             IF INSTR(ZMarkedFiles$,MatchFile$) = 0 THEN
                ZMarkedFiles$ = ZMarkedFiles$ + MatchFile$ + CHR$(13)
                TotalMatch = TotalMatch + 1
             END IF
             MatchFile$ = DIR$
             IF TotalMatch => MaxFiles THEN
                CALL QuickTPut (ZBackSpace$,0)
                '* "{CR{CF{G4Too Many Matching Files!{RC"
                LineNum = 948
                CRCount = 1
                GOSUB 810
                ZFileName$ = ""
                GOTO 400
             END IF
          LOOP
       END IF
       SearchDir = SearchDir + 1
    LOOP
    CALL QuickTPut (ZBackSpace$,0)
'
' * look in the FIDX.DEF
'
300 IF NOT ZFastFileSearch THEN GOTO 400
    CALL BreakFileName (ZFastFileList$, Drive$,Body$,Ext$,ZTrue)
    TIdxLst$ = Drive$ + Body$ + ".LST"
    CALL FindIt (TIdxLst$)
    IF ZOK THEN
       LineToRead = 1
       CALL OpenWork (11,TIdxLst$)
       IF ZErrCode <> 0 THEN
          GOTO 400
       END IF
305    CALL ReadParmsX (11,ZOutTxtAra$(),4,LineToRead)
       IF ZErrCode <> 0 AND ZOutTxtAra$(1) = "" THEN
          CLOSE 11
          GOTO 400
       END IF
       TFastFileList$ = ZOutTxtAra$(1)
       CALL BreakFileName (TFastFileList$,Drive$,Body$,Ext$,ZTrue)
       TFastTabs$ = Drive$ + Body$ + "T" + Ext$
       CALL FindIt (TFastTabs$)
       IF ZOK THEN
          CALL OpenRSeq (2,TFastTabs$, TWasX&, WasY, 72)
          FIELD 2, 72 AS IndexRec$
          GET 2, 1
          ZFastTabs$ = IndexRec$
          CLOSE 2
       ELSE
          ZFastTabs$ = ""
       END IF
       CALL BreakFileName (ZOutTxtAra$(3),Drive$,Body$,Ext$,ZTrue)
       '* "{CR{C5Searching {CB"
       LineNum = 949
       GOSUB 800
       CALL QuickTPut (Strng$ + UCASE$(Body$) + SPACE$(2),0)
       GOSUB 310
       ZOutTxtAra$(1) = ""
       GOTO 305
    ELSE
       TFastFileList$ = ZFastFileList$
       GOSUB 310
       GOTO 400
    END IF
310 CALL OpenRSeq (2,TFastFileList$,HighRec&,WasX,ZFIDXLEN)
    FIELD #2, 12 AS SearchFile$, _
               4 AS SearchPath$, _
     ZFIDXRFMLEN AS SearchDate$, _
   ZFIDXCDROMLEN AS SearchOnCD$, _
               2 AS SearchCrLf$
'
' * Set the LowRec value to 1 before checking for the tabs file low value.
'
    LowRec& = 1

'
' * See if the Tabs File exists by checking for the proper size.
'
    IF LEN(ZFastTabs$) < 72 THEN
       GOTO 350
    END IF

    FirstLetter$ = LEFT$(ZFileName$,1)
    '* "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ*?"
    LineNum = 950
    GOSUB 800
    FirstLet = INSTR(Strng$,FirstLetter$)
    IF FirstLet < 37 THEN
       IF FirstLet = 0 THEN
          LowRec& = 1
       ELSE
          LowRec& = CVI(MID$(ZFastTabs$,1+2*(FirstLet-1),2))
       END IF
       IF FirstLet < 36 THEN _
          HighRec& = CVI(MID$(ZFastTabs$,1+2*FirstLet,2))
    END IF
350 FOR Count& = LowRec& TO HighRec&
       GET 2, Count&
       GOSUB 700
       IF KillSearch THEN EXIT FOR
       CALL MarkTime (NumDots)
       FileName$ = SearchFile$
       CALL Trim (FileName$)
       CALL WildFile (ZFileName$,FileName$,DoesMatch)
       IF DoesMatch THEN
             ZMarkedFiles$ = ZMarkedFiles$ + Filename$ + CHR$(13)
             TotalMatch = TotalMatch + 1
       END IF
       IF TotalMatch => MaxFiles THEN
          CALL QuickTPut (ZBackSpace$,0)
          '* "{CR{CF{G4Too Many Matching Files!{RC"
          LineNum = 948
          CRCount = 1
          GOSUB 810
          EXIT FOR
       END IF
    NEXT Count&
    RETURN
400 CLOSE 2
    CALL QuickTPut (ZBackSpace$,0)
'
' * display number of matches found and end sub
'
600 ZFileName$ = ""
    CALL OpenWorkA (2,ZNodeWorkDrvPath$+"WILDDOWN.DEF")
    CALL PrintWorkA (2,ZMarkedFiles$)
    CLOSE #2
    '* "{CR{CB"
    LineNum = 951
    GOSUB 800
    Strng1$ = Strng$
    '* "{C2 Matches Found{RC"
    LineNum = 952
    GOSUB 800
    Strng2$ = Strng$
    CALL QuickTPut1 (Strng1$ + LTRIM$(STR$(TotalMatch)) + Strng2$)

    IF ZMarkedFIles$ <> "" THEN Found = ZTrue

    ZMarkedFiles$ = HoldMarkedFiles$
    EXIT SUB
'
' * routine to find user break
'
700 CALL FindFKey
    KillSearch = ZFalse
    IF ZKeyPressed$ = CHR$(24) THEN
       KillSearch = ZTrue
    END IF
    IF ZLocalUser THEN
       RETURN
    END IF
    IF ZCommPortStack$ <> "" THEN
       IF LEFT$(ZCommPortStack$,LEN(ZCommPortStack$)-1) = CHR$(24) THEN
          KillSearch = ZTrue
       END IF
    END IF
    CALL EofComm (Char)
    IF Char <> -1 THEN
       CALL GetCom (WasX$)
       IF WasX$ = CHR$(24) THEN
          KillSearch = ZTrue
       END IF
    END IF
    CALL FlushCom (ZCommPortStack$)
    RETURN
800 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
    RETURN
810 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZTrue,CRCount,"")
    RETURN
    END SUB
'
20096 ' $SUBTITLE: 'CheckRatio - subroutine to print ul/dl ratio'
' $PAGE
'
'  NAME    -- CheckRatio
'
'  INPUTS  --   PARAMETER                    MEANING
'               TellUser           TELL USER THEIR RATIO
'               ZDnlds             FILES DOWNLOADED
'               ZDLBytesVal!       BYTES DOWNLOADED
'               ZUplds             FILES UPLOADED
'               ZULBytesVal!       BYTES UPLOADED
'
'  OUTPUTS --   ZOK                 -1 if okay to download, 0 otherwise
'
'  PURPOSE -- To determine whether the users violated
'             their upload to download restriction
'
      SUB CheckRatio (TellUser) STATIC
      ZOK = ZTrue
      IF ZFreeDnld THEN _
         GOTO 20110
'
' Detemine method of ratio checking.  Look ahead to amount downloaded
'
      IF ZByteMethod = 1 OR ZByteMethod = 3 THEN
         '* "{SPBytes"
         LineNum = 360
         ULWork# = ZULBytesVal!
         DLWork# = ZDLBytesVal! + ZNumDnldBytes!
      END IF
      IF ZByteMethod = 0 OR ZByteMethod = 2 THEN
         '* "{SPFiles"
         LineNum = 361
         ULWork# = ZUplds
         DLWork# = ZDnlds + ZDownFiles
      END IF
      GOSUB 20108
      Method$ = Strng$
      IF ULWork# < ZInitialCredit# THEN _
         ULWork# = ZInitialCredit#
      IF ZByteMethod = 2 THEN _
         Today# = ZRatioRestrict# - ZDLToday! - ZDownFiles
      IF ZByteMethod = 3 THEN _
         Today# = ZRatioRestrict# - ZBytesToday! - ZNumDnldBytes!
'
      Ratio# = 0
      IF ULWork# > 0 THEN
         Ratio# = (DLWork# / ULWork#)
      END IF
      IF ZByteMethod > 1 THEN
         '* "{C6Today's Downloaded Files: {CF{DD{CR{CCNumber of Bytes Today: {CF{BD{RC"
         CALL FormatString (362,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
         ZSubParm = 5
         CALL TPut
         CALL SkipLine (1)
         GOTO 20100
      END IF
      WasX$ = STR$(Ratio#)
      X = INSTR(WasX$,".")
      IF X > 0 THEN _
         WasX$ = LEFT$(WasX$,X+1)
      IF ZByteMethod = 1 OR ZByteMethod = 3 THEN
         '* "{C6Bytes Downloaded: {CF{DB{CR{CCBytes Uploaded:   {CF{UB{CR{C5Today's Downloaded Files: {CF{DD{CR{C2Your Ratio{CF{BR{RC"
         LineNum = 363
      END IF
      IF ZByteMethod = 0 OR ZByteMethod = 2 THEN
         '* "{C6Files Downloaded: {CF{DL{CR{CCFiles Uploaded:   {CF{UL{CR{C5Today's Downloaded Files: {CF{DD{CR{C2Your Ratio{CF{FR{RC"
         LineNum = 364
      END IF
      GOSUB 20108
      ZOutTxt$ = Strng$
      ZSubParm = 5
      CALL TPut
'
'  CHECK TO SEE IF THE USER HAS VIOLATED THEIR UL/DL RESTRICTION
'
20100 IF NOT ZEnforceRatios OR ZRatioRestrict# <= 0 THEN _
         GOTO 20110
      IF NOT (ZRatioRestrict# > 0 AND TellUser) THEN _
         EXIT SUB
      IF ZByteMethod <= 1 THEN _
         GOTO 20105
      IF Today# < 0 THEN
         '* "{CF{G4Sorry, Daily Download limit of"
         LineNum = 365
         GOSUB 20108
         ZOutTxt$ = Strng$
         IF ZBytesToday! < 0 THEN
            ZOutTxt$ = ZOutTxt$ + STR$(ZRatioRestrict# - ZBytesToday!)
         ELSE
            ZOutTxt$ = ZOutTxt$ + STR$(ZRatioRestrict#)
         END IF
         '* "{SPReached{RC"
         LineNum = 366
         GOSUB 20108
         ZOutTxt$ = ZOutTxt$ + Method$ + Strng$
         NotOver = ZFalse
         ZNumDnldBytes! = 0
         CALL SmartPause (ZTrue)
      ELSE
         '* "{C5Download balance:{C6"
         LineNum = 367
         GOSUB 20108
         ZOutTxt$ = Strng$ + STR$(Today#) + Method$ + ZEmphasizeOff$
         NotOver = ZTrue
         CALL SmartPause (ZFalse)
      END IF
      ZSubParm = 5
      CALL TPut
      GOSUB 20106
      ZOK = NotOver
      EXIT SUB
'
20105 IF Ratio# > ZRatioRestrict# OR ULWork# = 0 THEN
         CALL PutCom (ZBellRinger$)
         NotOver = ZFalse
         '* "{CDSorry, you have EXCEEDED your DL/UL ratio of{CE"
         LineNum = 368
         GOSUB 20108
         ZOutTxt$ = Strng$ + STR$(ZRatioRestrict#) + _
                    ":1" + Method$ + ZEmphasizeOff$
         ZSubParm = 5
         CALL TPut
         ZDownFiles = 0
         GOSUB 20106
         '* "{C6Minimum upload of{CB"
         LineNum = 369
         GOSUB 20108
         ZOutTxt$ = Strng$ + _
              STR$(INT(((DLWork# - (ULWork# * ZRatioRestrict#)) _
              / ZRatioRestrict#) + 1)) + Method$
         '* "{C6 required to download{RC"
         LineNum = 370
         GOSUB 20108
         ZOutTxt$ = ZOutTxt$ + Strng$
      ELSE
         NotOver = ZTrue
         '* "{CR{CEBalance remaining before upload required:{CF"
         LineNum = 371
         GOSUB 20108
         ZOutTxt$ = Strng$ + _
                     STR$(INT((ULWork# * ZRatioRestrict#)-DLWork#)) + _
                     Method$ + ZEmphasizeOff$
      END IF
      ZSubParm = 3
      CALL TPut
      CALL SmartPause (ZFalse)
      ZOK = NotOver
      EXIT SUB
20106 FilName$ = ZHelpPath$ + "RATIO" + LTRIM$(STR$(ZUserSecLevel)) + ZHelpExtension$
      CALL FindFile (FilName$,Found)
      IF NOT Found THEN
         FilName$ = ZHelpPath$ + "RATIO" + ZHelpExtension$
      END IF
      CALL GraphicDisplayFile (FilName$)
      CALL SmartPause (ZFalse)
      RETURN
20108 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      RETURN
20110 END SUB
'
20115 ' $SUBTITLE: 'FileSystem -- subroutine for RBBS-PC's file system'
' $PAGE
'
' NAME    -- FileSystem
'
' INPUTS  --       PARAMETER                 MEANING
'             ZFileSysParm = 1  LIST THE SYSOP'S COMMENTS FILE
'                                 2  L)IST DIRECTORY COMMAND
'                                 3  D)OWNLOAD COMMAND
'                                 4  RETURN FROM EXTERNAL PROTOCOLS
'                                 5  U)PLOAD COMMAND
'                                 6  S)CAN DIRECTORY COMMAND
'                                 7  P)ERSONAL FILES COMMAND
'                                 8  N)EW FILES COMMAND
'                                 9  RETURN FROM EXTENDED DESCRIPTION
'                                 10  Batch Upload files
'
' OUTPUTS -- ZFileSysParm = 1  COMMAND PROCESSED SUCCESSFULLY
'                                2  RECYCLE TO TOP OF RBBS-PC (202)
'                                3  PROCESS NEXT COMMAND (1200)
'                                4  DENY USER ACCESS (1380)
'                                5  HANDLE EXTENDED DESCRIP. (2008)
'                                6  USER'S TIME EXCEEDED (10553)
'                                7  Carrier DROPPED (10595)
'
' PURPOSE -- To handle the RBBS-PC file system commands
'
      SUB FileSystem STATIC
      ZFF = ZFileSysParm
      ZFileSysParm = 1
      CALL SaveUserActivity("F", ZNodeRecIndex, ZFalse,WasAV)
      ZActiveFMSDir$ = ""
      ON ZFF GOSUB 20119, _  ' HANDLER TO LIST COMMENTS TO SYSOP
                  20150, _  ' L)IST DIRECTORY COMMAND HANDLER
                  20180, _  ' D)OWNLOAD COMMAND HANDLER
                  20263, _  ' RETURN FROM EXTERNAL Protocol'S
                  20400, _  ' U)PLOAD COMMAND HANDLER
                  21800, _  ' S)CAN DIRECTORY COMMAND HANDLER
                  21850, _  ' P)ERSONAL FILES COMMAND HANDLER
                  21860, _  ' N)EW FILES COMMAND HANDLER
                  20705, _  ' RETURN FROM EXTENDED DESCRIPTIONS
                  20410     ' Batch Upload files
      GOTO 21920
20119 ZErrCode = 0
      GOTO 20122
'
' *****  SCAN DIRECTORIES (PRINT TEXT)  ****
'
'  (formerly lines 7000 to 7260 in RBBS-PC.BAS CPC16-1A
20120 GOSUB 20144
      IF ZFileSysParm > 1 THEN _
         RETURN
      CALL AskMore ("",ZTrue,ZTrue,ZAnsIndex,ZFalse)
      IF ZNo THEN _
         ZErrCode = 0 : _
         RETURN
      WasPG = ZTrue
20122 CALL OpenWork (2,ZFileName$)
      IF ZErrCode = 53 THEN
         '* "Missing File {FI"
         CALL FormatString (562,ZFalse,ZTrue,2,ZFalse,0,ZOutTxt$)
         '* ". Please tell SysOp"
         LineNum = 563
         GOSUB 21915
         ZOutTxt$ = ZOutTxt$ + Strng$
         GOSUB 21650
         RETURN
      END IF
      ZJumpSupported = ZTrue
      ZJumpLast$ = ""
      LastOK = ZFalse
      ZJumpSearching = ZFalse
      MaxPrint = ZPageLength - 1
      CALL CmdStackPushPop (1)
      ZLastIndex = 0
20124 CALL CheckCarrier
      IF EOF(2) OR _
         (ZSubParm = -1 AND NOT ZLocalUser) THEN _
         GOTO 20142
20126 CALL ReadDir (2,1)
      IF LEFT$(ZOutTxt$,1) <> SPACE$(1) THEN
         ZOutTxt$ = ZDR1$ + LEFT$(ZOutTxt$,13) + _
                    ZDR2$ + MID$(ZOutTxt$,14,10) + _
                    ZDR3$ + MID$(ZOutTxt$,24,10) + _
                    ZDR4$ + MID$(ZOutTxt$,34,ZMaxDescLen) + ZEmphasizeoff$
      ELSE
         ZOutTxt$ = ZDR5$ + ZOutTxt$ + ZEmphasizeOff$
      END IF
      IF ZErrCode <> 0 THEN _
         ZWasEL = 20126 : _
         GOTO 21900
      IF LEFT$(ZOutTxt$,1) = SPACE$(1) THEN
         IF LastOK AND NOT ZExtendedOff THEN
            GOTO 20140
         ELSE
            GOTO 20124
         END IF
      END IF
      IF WasCK = 0 THEN _
         GOTO 20140
      LastOK = ZFalse
      IF ZJumpSearching THEN _
         GOTO 20129
      IF WasCK < 2 THEN _
         GOTO 20130
      IF WildSearch THEN _
         ZWasA = INSTR(ZOutTxt$,SPACE$(1)) : _
         IF ZWasA = 0 THEN _
            GOTO 20124 _
         ELSE ZWasZ$ = LEFT$(ZOutTxt$,ZWasA - 1) : _
              CALL WildFile (WasRS$,ZWasZ$,WasXXX) : _
              WasXXX = NOT WasXXX : _
              GOTO 20136
20129 ZWasZ$ = ZOutTxt$
      CALL AllCaps (ZWasZ$)
      WasXXX = (INSTR(ZWasZ$,WasRS$) = 0)
      GOTO 20136
20130 ZWasA = INSTR(9,MID$(ZOutTxt$,1,32),"/")
      IF ZWasA = 0 THEN _
         ZWasA = INSTR(9,MID$(ZOutTxt$,1,32),"-")
      IF ZWasA < 3 THEN _
         GOTO 20124
      '* "0123456789"
      LineNum = 564
      GOSUB 21915
      IF INSTR(Strng$,MID$(ZOutTxt$,ZWasA - 1,1)) = 0 THEN _
         GOTO 20124
      ZWasA = ZWasA - 2
      WasWK$ = RIGHT$(MID$(ZOutTxt$,ZWasA,8),2) + _
            LEFT$(MID$(ZOutTxt$,ZWasA,8),2) + _
            MID$(MID$(ZOutTxt$,ZWasA,8),4,2)
      IF MID$(WasWK$,3,1) = SPACE$(1) THEN _
         MID$(WasWK$,3,1) = "0"
      IF MID$(WasWK$,5,1) = SPACE$(1) THEN _
         MID$(WasWK$,5,1) = "0"
      WasXXX = (WasWK$ < WasRS$)
20136 IF WasXXX THEN _
         GOTO 20124
      IF ZJumpSearching THEN _
         WasRS$ = PrevSearch$ : _
         WasCK = PrevCK : _
         ZJumpSearching = ZFalse : _
         GOTO 20140
      IF WasPG THEN _
         WasPG = ZFalse : _
         CALL OpenWork (2,ZFileName$) : _
         ZWasQ = 0 : _
         GOTO 20124
      IF WasPG THEN _
         GOTO 20124
20140 LastOK = ZTrue
      GOSUB 21650
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZLinesPrinted > MaxPrint THEN
         ZTurboKey = -ZTurboKeyUser
         '* ",M)ark"
         LineNum = 1049
         GOSUB 21915
         CALL AskMore (Strng$,ZTrue,ZTrue,ZAnsIndex,ZFalse)
         IF ZNo THEN
            ZErrCode = 0
            RETURN
         ELSE
            Temp$ = ZUserInAra$(1)
            '* "file"
            LineNum = 1025
            GOSUB 21915
            CALL AskItems ("M",Temp$,ZTrue,Strng$,ZMarkedFiles$)
            ZUserInAra$(1) = ""
         END IF
         GOSUB 20144
      END IF
      IF ZJumpSearching THEN _
         IF LEFT$(ZOutTxt$,1) <> SPACE$(1) THEN _
            PrevSearch$ = WasRS$ : _
            PrevCK = WasCK : _
            WasCK = 2 : _
            WasRS$ = ZJumpTo$
      IF NOT ZRet THEN _
         GOTO 20124
20142 ZWasQ = 0
      CALL CmdStackPushPop (2)
      ZJumpSupported = ZFalse
      CLOSE 2
      CALL CheckCarrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7
      RETURN
20144 IF (ZWasGR > 1) AND _
         (ZDisplayOptions AND 2) > 0 THEN
         CALL QuickTPut (ZEscape$ + "[2J",0)
         CALL FMS (ZFileNameHold$,WasRS$,"",ZFalse, _
                   ZCategoryName$(),ZCategoryCode$(),ZCategoryDesc$(),_
                   WasDLF,WasCF,ZAnsIndex,ZTrue)
         CALL Line25
      END IF
      RETURN
'
' *  L - COMMAND FROM FILES MENU (LIST DIRECTORY)
'
20150 ZListDir = ZTrue
      ListNew = ZFalse
      SearchDate$ = ""
      SearchString$ = ""
      WasRS$ = ""
      ShowDirOfDir = (ZLastIndex <= ZAnsIndex) AND NOT ZExpertUser
      WasCK = 0
      ZSearchingAll = ZFalse
20155 IF ZDnldCompleted AND ZAutoEnd = 1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      IF ListNew OR ZAnsIndex > 255 THEN _
         RETURN
      CALL GetDirs (NOT ZExpertUser)
      IF ZWasQ = 0 THEN _
         RETURN
      ShowDirOfDir = ZFalse
      CALL ConvertDir (ZAnsIndex)
      WasQX = ZLastIndex
20157 CALL CheckCarrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      GOTO 20161
20159 IF ZAnsIndex < ZLastIndex THEN _
         GOTO 20155
      ZSearchingAll = ZFalse
      CALL CmdStackPushPop (1)
      ZLastIndex = 0
      IF ZNo OR InFMS OR (ZFileNameHold$ = ZDirPrefix$) THEN _
         GOTO 20155
      GOSUB 20177
      CALL QuickTPut (ZEmphasizeOff$,1)
      ZTurboKey = - ZTurboKeyUser
      '* "{C2-{C3={CEEnd list{C3={C2-{RC{CRL)ist again, V)iew, M)ark, D)nld, [Q]uit"
      LineNum = 565
      GOSUB 21915
      ZOutTxt$ = Strng$
      GOSUB 21667
      CALL AraAllCaps (ZUserInAra$(),1)
      IF ZUserInAra$(1) = "V" AND _
         ZUserSecLevel >= ZOptSec(19 - 20 * (ZMenuIndex = 6)) THEN _
         ZAnsIndex = 1 : _
         CALL GetArc (ZFalse,ZFalse) : _
         RETURN
      IF ZUserInAra$(1) = "L" THEN _
         ZUserInAra$(ZAnsIndex) = WasA1$ : _
         GOTO 20161
      Temp$ = ZUserInAra$(1)
      Temp = (ZUserInAra$(1) = "D")
      '* "file"
      LineNum = 1025
      GOSUB 21915
      CALL AskItems ("MD",Temp$,ZTrue,Strng$,ZMarkedFiles$)
      IF ZWasQ = 0 OR ZUserSecLevel < ZOptSec(19 - 20 * (ZMenuIndex = 6)) THEN _
         GOTO 20160
      IF Temp THEN _
         GOSUB 20202 _
      ELSE IF LEN(ZUserInAra$(1)) > 1 THEN _
         ZAnsIndex = 1 : _
         GOSUB 20202
20160 CALL CmdStackPushPop (2)
      RETURN
20161 IF INSTR(ZUserInAra$(ZAnsIndex),".") THEN _
         GOTO 20172
      '* "List Dir.{SP"
      LineNum = 566
      GOSUB 21915
      ZViolation$ = Strng$
      ZWasZ$ = ZUserInAra$(ZAnsIndex)
      '* "E+E-E"
      LineNum = 1067
      GOSUB 21915
      ZWasA = INSTR(Strng$,ZWasZ$)
      IF ZWasA > 0 THEN _
         IF ZWasA = 5 THEN _
            ZExtendedOff = NOT ZExtendedOff : _
            GOTO 20155 _
         ELSE ZExtendedOff = (ZWasA > 2) : _
              GOTO 20155
      CALL AllCaps(ZWasZ$)
      ZFileNameHold$ = ZWasZ$
      WasA1$ = ZWasZ$
      IF ZWasZ$ = ZDirPrefix$ THEN _
         GOTO 20164
      InFMS = ZFalse
20162 CALL CmdStackPushPop (1)         ' save dir list list processing
      IF (ZWasGR > 1) AND _
         (ZDisplayOptions AND 2) > 0 THEN
         CALL QuickTPut (ZEscape$ + "[2J",0)
         CALL Line25
      END IF

      ZFMSHeaderDisplay$ = ZWasZ$
      CALL FMS (ZWasZ$,SearchString$,SearchDate$,InFMS, _
                ZCategoryName$(),ZCategoryCode$(),ZCategoryDesc$(),_
                DnldFlag,CatFound,ZAnsIndex,ZFalse)
      WHILE DnldFlag > 0 AND ZSubParm > -1
         GOSUB 20202
         IF ZFileSysParm > 1 THEN _
            RETURN
         IF ZDnldCompleted and ZAutoEnd = 1 THEN _
            RETURN
         WasX$ = ZCategoryCode$(CatFound)
         CALL DispUpDir (WasX$,SearchString$,SearchDate$,DnldFlag,ZAnsIndex)
         CALL CheckTimeRemain (MinsRemaining)
         IF ZSubParm = -1 THEN _
            ZFileSysParm = 6 : _
            RETURN
         CALL CheckCarrier
      WEND
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      IF ZAnsIndex > 255 OR ZRet THEN _
         ZLastIndex = 0 : _
         RETURN
      CALL CmdStackPushPop (2)        ' restore dir list list processing
      ZActiveFMSDir$ = ""
      IF InFMS THEN _
         GOTO 20159
      IF ZUserSecLevel < ZMinSecToView THEN
         IF ZFileNameHold$ = ZUpldDirCheck$ THEN
            '* "Upload Directory Available to SYSOP Only"
            LineNum = 567
            GOSUB 21915
            GOSUB 21640
            ZNo = ZTrue
            GOTO 20155
         END IF
      END IF
      ZFileNameHold$ = ZUserInAra$(ZAnsIndex)
      IF ZLimitSearchToFMS THEN
         GOTO 20166
      END IF
      IF NOT ZSearchingAll THEN
         '* "ALL"
         LineNum = 450
         GOSUB 21915
         IF ZFileNameHold$ = Strng$ OR ZFileNameHold$ = "A" THEN
            ZSearchingAll = ZTrue
            GOSUB 21890
            GOTO 20157
         END IF
      END IF
      CALL BadFile (ZFileNameHold$,BadFileNameIndex)
      ON BadFileNameIndex GOTO 20163,20172,20176
20163 ZFileName$ = ZFileNameHold$
      CALL BadName (BadFileNameIndex,ZTrue)
      ON BadFileNameIndex GOTO 20164,20176
20164 IF ZFileName$ = ZUpldDirCheck$ AND _
         ZUserSecLevel >= ZMinSecToView THEN _
            ZFileName$ = ZUpldPath$ _
      ELSE ZFileName$ = ZCurDirPath$
      ZFileName$ = ZFileName$ + _
                   ZFileNameHold$ + _
                   "." + _
                   ZDirExtension$
      CALL Graphic (ZFileName$)
      IF ZOK THEN
         CALL ReadDir (2,1)
         IF ZErrCode = 0 THEN
            IF LEFT$(ZOutTxt$,4) = "\FMS" THEN
               InFMS = ZTrue
               ZActiveFMSDir$ = ZFileName$
               GOTO 20162
            ELSE
               GOTO 20167
            END IF
         END IF
      END IF
20166 ZFileName$ = ZCurDirPath$ + _
                   ZFileNameHold$ + ".MNU"
      CALL FindIt (ZFileName$)
      IF ZOK THEN _
         CALL BufFile (ZFileName$,ZAnsIndex) : _
         GOTO 20155
      IF ZAltdirExtension$ = "" THEN _
         GOTO 20172
      ZFileName$ = ZCurDirPath$ + _
                   ZFileNameHold$ + _
                   "." + _
                   ZAltdirExtension$
      CALL Graphic (ZFileName$)
      IF NOT ZOK THEN _
         GOTO 20172
20167 ZUserInAra$(0) = ZUserInAra$(ZAnsIndex)
      GOSUB 20120
      IF ZFileSysParm > 1 THEN _
         RETURN
      GOTO 20170
      CALL BufFile(ZFileName$,ZAnsIndex)
      CALL CheckCarrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
20170 IF ZAnsIndex > 255 THEN _
         ZLastIndex = 0 : _
         RETURN
      ZUserInAra$(ZAnsIndex) = ZUserInAra$(0)
      GOTO 20159
20172 IF NOT ZSearchingAll THEN
         '* "Directory {FH not found!"
         LineNum = 568
         GOSUB 21915
         ZOutTxt$ = Strng$
         GOSUB 21640
         CALL SmartPause (ZFalse)
         ZNo = ZTrue
         IF ZFileSysParm > 1 THEN
            RETURN
         END IF
      END IF
      GOTO 20155
20176 CALL SecViolation
      IF ZDenyAccess THEN _
         ZFileSysParm = 4 : _
         RETURN
      GOTO 20172
20177 ZListOnly = ZFalse
      ZExtraDnldTime = 0
      ZFreeDnld = ZFalse
      ZPersonalDnld = ZFalse
      RETURN
'
' * WildCard Download Support
'
20178 '* "Mark Files to Download ([Y],N)"
      LineNum = 569
      GOSUB 21915
      ZOutTxt$ = Strng$
      ZTurboKey = - ZTurboKeyUser
      GOSUB 21668
      IF ZNO THEN _
         CALL KillWork (ZNodeWorkDrvPath$+"WILDDOWN.DEF") : _
         GOTO 20180
      CALL OpenWork (2,ZNodeWorkDrvPath$+"WILDDOWN.DEF")
      '* "Mark{SP"
      LineNum = 570
      GOSUB 21915
      MarkStr$ = Strng$
      '* "(Y)es,[N]o,A)bort)"
      LineNum = 571
      GOSUB 21915
      AskStr$ = Strng$
      DO WHILE NOT EOF(2)
         CALL ReadDir (2,1)
         CALL Trim (ZOutTxt$)
         ZFileName$ = ZOutTxt$
         IF ZFileName$ = "" THEN EXIT DO
         ZOutTxt$ = MarkStr$ + ZFileName$ + _
                    SPACE$(13-LEN(ZFileName$)) + _
                    AskStr$
         ZTurboKey = - ZTurboKeyUser
         GOSUB 21668
         IF LEFT$(UCASE$(ZUserIn$),1) = "A" THEN _
            GOTO 20179
         IF ZYes THEN
            IF ZMarkedFiles$ = "" THEN
               ZMarkedFiles$ = ZFileName$ + CHR$(13)
            ELSE
               IF INSTR(ZMarkedFiles$,ZFileName$) = 0 THEN
                  ZMarkedFiles$ = ZMarkedFiles$ + ZFileName$ + CHR$(13)
               END IF
            END IF
         END IF
      LOOP
      CLOSE 2
      '* "{C2-{C3={CEEnd list{C3={C2-{RC"
      CALL FormatString (572,ZFalse,ZFalse,0,ZTrue,1,"")
20179 IF Found THEN
         '* "Relist Files To Mark? (Y,[N])"
         LineNum = 573
         GOSUB 21915
         ZOutTxt$ = Strng$
         ZTurboKey = - ZTurboKeyUser
         GOSUB 21668
         IF ZYES THEN _
            GOTO 20178
      END IF
      CALL KillWork (ZNodeWorkDrvPath$+"WILDDOWN.DEF")
      ZOutTxt$ = ""
      ZOK = ZFalse
      ZAutoLogoffReq = ZFalse
'
' *  D - COMMAND FROM FILES MENU (SEARCH FOR FILE TO DOWNLOAD)
'
20180 Temp$ = "D"
      NoTimeDnFlag = -1
      '* "file"
      LineNum = 1025
      GOSUB 21915
      CALL AskItems ("D",Temp$,ZFalse,Strng$,ZMarkedFiles$)
      GOSUB 20177
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZWasQ = 0 THEN _
         RETURN
20202 IF (ZTimeLock AND 2) AND (NOT TimeLockExempt) AND NOT ZHasPrivDoor THEN _
         CALL TimeLock : _
         IF NOT ZOK THEN _
            RETURN
      LastDnld = ZLastIndex
      FirstDnld = ZAnsIndex
      ZCmdTransfer$ = ""
      ZAnsIndex = ZLastIndex
      GOSUB 20470
      LastDnld = LastDnld + (WasX > 0)
      BatchBytes# = 0
      BatchBlocks# = 0
      ZDownFiles = 0
      GOSUB 21918
      ZErrCode = 0
      ZAnsIndex = FirstDnld
20203 IF ZAnsIndex > LastDnld THEN _
            GOTO 20204
         GOSUB 20470
         GOSUB 20205
         IF ReStart THEN _
            ReStart = ZFalse : _
            GOTO 20202
         ZCmdTransfer$ = ZWasFT$
         CALL Line25
         IF ZFileSysParm > 1 THEN _
            GOTO 20204
      ZAnsIndex = ZAnsIndex + 1
      GOTO 20203
20204 ZLastIndex = 0
      IF ZFileSysParm > 1 THEN _
         RETURN
      ZBatchTransfer = ZFalse
      ZCmdTransfer$ = ""
      RETURN
20205 MarkingTime = (ZAnsIndex = FirstDnld OR NOT ZConcatFIles)
      ZFileName$ = ZUserInAra$(ZAnsIndex)
      CALL AllCaps(ZFileName$)
      CALL Remove (ZFileName$,", ")
      '* "Download{SP"
      LineNum = 1068
      GOSUB 21915
      ZViolation$ = Strng$
      IF ZListOnly THEN
         CALL BreakFileName (ZFileName$,DR$,ZWasY$,WasX$,ZTrue)
         ZFileNameHold$ = ZWasY$ + WasX$
         GOTO 20235
      END IF
      ZFileNameHold$ = ZFileName$
'
' * WildCard Download Support
'
      IF INSTR(ZFileName$,"*") <> 0 THEN
         IF ZWildDownOK AND NOT ZPersonalDnld THEN
            ZLastIndex = 1
            LastDnld = 1
            CALL WildDown(ZFileName$, ZMarkedFiles$, ZFastFileList$, Found)
            IF Found THEN
               GOTO 20178
            ELSE
               GOTO 20179
            END IF
         END IF
      END IF
      TmpFileNameHold$ = ZFileNameHold$
      CALL BadFile (ZFileName$,BadFileNameIndex)
      ON BadFileNameIndex GOTO 20220,20231,20233
20210 CALL RotorsDir (ZFileName$,ZSubDir$(),ZSubDirCount + _
                      ((ZUserSecLevel < ZMinSecToView) OR _
                       NOT ZCanDnldFromUp),MarkingTime,"D")
      RETURN
20220 IF INSTR(ZFileName$,ZDefaultExtension$) = 0 THEN
         GOSUB 20210
         IF ZOK THEN
            GOTO 20235
         END IF
      END IF
      WasI = 1
20225 CALL BreakFileName (ZFileName$,DR$,WasX$,Extension$,ZFalse)
      WasJ = INSTR(Mid$(ZCompressedExt$+". ",WasI),".")
      IF WasJ = 0 THEN _
         GOTO 20231
      Check$ = MID$(ZCompressedExt$,WasI,WasJ-1)
      WasI = WasI + WasJ
      ZFileName$ = WasX$ + "." + Check$
      ZFileNameHold$ = ZFileName$
      GOSUB 20210
      IF ZOK THEN _
         GOTO 20235
      GOTO 20225
20231 TmpName$ = ZDirPath$ + ZMainFMSDir$ + ".OFL"
      CALL FindIt (TmpName$)
      IF NOT ZOK THEN
         TmpName$ = ZDirPath$ + "OFFLINE.DEF"
         CALL FindIt (TmpName$)
      END IF
      IF ZOK THEN
         HaveFile$ = ""
         FileOffLine = ZFalse
         TimeNow! = TIMER
         PrevTi! = TimeNow!
         NumDots = 0
         AlreadyPrinted = ZFalse
         WHILE NOT EOF(2) AND NOT FileOffLine
            TimeNow! = TIMER
            IF TimeNow! - PrevTi! > 0.5 THEN
               IF NOT AlreadyPrinted THEN
                  '* "{CBSearching {CEOFFLINE {CBDirectory{RC"
                  CALL FormatString (961,ZFalse,ZFalse,0,ZTrue,0,"")
                  AlreadyPrinted = ZTrue
               END IF
               CALL MarkTime (NumDots)
               PrevTi! = TimeNow!
            END IF
            LINE INPUT #2, HaveFile$
            CALL AllCaps (HaveFile$)
            StopReading = INSTR(HaveFile$,".")
            IF StopReading > 0 THEN
               HaveFile$ = Left$(HaveFile$,StopReading)
            END IF
            Search = INSTR(ZFileNameHold$,".")
            IF Search > 0 THEN
               Search$ = Left$(ZFileNameHold$,Search)
            ELSE
               Search$ = ZFileNameHold$
            END IF
            IF Search$ = HaveFile$ THEN
               FileOffLine = ZTrue
            END IF
         WEND
         CLOSE 2
         IF AlreadyPrinted THEN
            CALL QuickTPut1 (ZBackSpace$)
         END IF
      END IF
      IF FileOffLine THEN
         ZFileName$ = UCASE$(ZUserInAra$(ZAnsIndex))
         '* "The file {FI is stored OffLine!"
         CALL FormatString (1102,ZFalse,ZFalse,0,ZTrue,1,"")
         ZWasQ = 0
         GOTO 20232
      END IF
      '* "{SPnot found!"
      LineNum = 374
      GOSUB 21915
      ZOutTxt$ = TmpFileNameHold$ + Strng$
      CALL UpdtCalr (ZOutTxt$,2)
      '* "{SPCorrect name?{EX"
      LineNum = 1069
      GOSUB 21915
      ZOutTxt$ = ZOutTxt$ + Strng$
      ZSuspendAutoLogoff = ZTrue
      GOSUB 21660
      ZSuspendAutoLogoff = ZFalse
      IF ZFileSysParm > 1 THEN _
         RETURN
20232 IF ZWasQ=0 THEN _
         IF ZBatchTransfer AND ZAnsIndex >= LastDnld THEN _
            GOTO 20262 _
         ELSE ZAutoLogOffReq = ZFalse : _
              RETURN
      ZUserInAra$(ZAnsIndex) = ZUserInAra$(1)
      GOTO 20205
20233 CALL SecViolation
      IF ZDenyAccess THEN _
         ZFileSysParm = 4 : _
         RETURN
      GOTO 20231
20235 CALL BadName (BadFileNameIndex,ZTrue)
      ON BadFileNameIndex GOTO  20236,20245
20236 '* "(D) {ZZ"
      LineNum = 1070
      GOSUB 21915
      ZLine25$ = Strng$
'
' *  TEST FOR DOWNLOAD SECURITY
'
      '* "Download"
      LineNum = 1071
      GOSUB 21915
      ZViolation$ = Strng$
      CALL FilSecChk (ZViolation$, ZFileName$, ZOK)
      IF NOT ZOK THEN
         IF ZWasQ = 0 THEN
            GOTO 21700
         ELSE
            GOTO 20245
         END IF
      END IF
      IF ZErrCode = 53 THEN
         '* "Missing file{SP"
         LineNum = 376
         GOSUB 21915
         CALL UpdtCalr (Strng$ + ZFileSecFile$,2)
         GOTO 20247
      END IF
      IF ZErrCode <> 0 THEN _
         ZWasEL = 20242 : _
         GOTO 21900
      GOTO 20247
20245 '* "Download {FI"
      CALL FormatString (574,ZFalse,ZFalse,0,ZFalse,0,ZViolation$)
      CALL SecViolation
      IF ZDenyAccess THEN _
         ZFileSysParm = 4
      RETURN
20247 ZWasDF = 0
      CALL BreakFileName (ZFileName$,DR$,WasX$,Extension$,ZFalse)
      '* "...WRK.FW .ARC.EXE.COM.OBJ.WKS.LBR.ZIP.PAK.ZOO.ARJ.LZH."
      LineNum = 575
      GOSUB 21915
      IF INSTR(Strng$,"."+Extension$+".") > 2 OR _
         MID$(Extension$,2,1) = "Q" OR _
         (ZRequireNonASCII AND Extension$ = "BAS") THEN _
            ZWasDF = ZTrue
      ZOutTxt$ = ""
      IF ZBatchTransfer THEN _
         IF ZAnsIndex < LastDnld THEN _
            GOTO 20260
      CALL XferType (2,ZTrue)
      IF ZFF THEN _
         GOTO 20260
      CALL XferType (1,ZTrue)
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      IF ZWasQ = 0 THEN _
         RETURN
20260 ZTransferFunction = 1
      ZWasBatchTransfer = ZFalse
      ZUpBatchTransfer = ZFalse
      GOSUB 21790
      IF ZFileSysParm > 1 THEN _
         RETURN
      ZBatchTransfer = ZBatchProto
      IF ZBatchTransfer AND ZCmdTransfer$ = "" THEN _
         ZCmdTransfer$ = ZWasFT$
'
' *  EXTERNAL Protocol Downloads/Uploads
'
20261 IF ZReq8Bit THEN _
         IF NOT ZEightBit THEN _
            GOSUB 20318 : _
            IF ZFileSysParm > 1 THEN _
               RETURN _
            ELSE GOSUB 20992 : _
                 IF ZFileSysParm > 1 THEN _
                    RETURN
      IF ZTransferFunction = 1 THEN _
         GOSUB 20750 : _
         CLOSE 2 : _
         IF ZFileSysParm > 1 OR NOT ZOK THEN _
            RETURN
20262 IF ZBatchTransfer THEN _
         IF ZAnsIndex < LastDnld THEN _
            RETURN _
         ELSE ZBlocksInFile# = BatchBlocks# : _
              ZBytesInFile# = BatchBytes# : _
              ZNumDnldBytes! = BatchBytes# : _
              IF ZBytesInFile# < 1 THEN _
                 RETURN _
              ELSE GOSUB 20780 : _
                   IF ZFileSysParm > 1 OR NOT ZOK THEN _
                      RETURN
         IF ZAbort THEN _
            ZAbort = ZFalse : _
            ZDnldCompleted = ZFalse : _
            GOSUB 21760 : _
            RETURN
      GOSUB 20337
      CALL Transfer
20263 IF ZPrivateDoor THEN _
         ZCmdTransfer$ = ZWasFT$ : _
         CALL XferType (2,ZTrue) : _
         ZCmdTransfer$ = ""
      CALL OpenWork (2,"XFER-" + ZNodeID$ + ".DEF")
      IF ZErrCode <> 0 OR LOF(2) = 0 THEN _
         GOTO 20267
      CALL ReadParms (ZWorkAra$(), ZFailureParm, 1)
      IF ZErrCode <> 0 THEN _
         GOTO 20267
      CLOSE 2
      IF NOT ZFakeXRpt THEN
         CALL LinesInFile("XFER-" + ZNodeId$ + ".DEF", XferCount)
         IF ZAdvanceProtoWrite AND XferCount < 2 THEN
            GOTO 20264
         END IF
      END IF
      CALL CheckCarrier
      IF ZSubParm <> -1 THEN
         Call TStats
      END IF
20264 IF ZTransferFunction <> 1 THEN
         CALL KillWork ("XFER-" + ZNodeID$ + ".DEF")
      END IF
      IF ZPrivateDoor THEN _
         ZFileName$ = ZWorkAra$(1) : _
         CALL BreakFileName (ZFileName$,WasX$,ZFileNameHold$,ZWasY$,ZTrue) : _
         ZFileNameHold$ = ZFileNameHold$ + _
                           ZWasY$
      IF LEFT$(ZWorkAra$(ZFailureParm),1) = "L" THEN _
         MID$(ZWorkAra$(ZFailureParm),1,1) = ZFailureString$
      IF ZTransferFunction = 2 THEN
         IF INSTR(ZWorkAra$(ZFailureParm),ZFailureString$) <> 1 THEN
            GOTO 20700
         ELSE
            GOTO 20730
         END IF
      END IF
      IF ZTransferFunction = 1 THEN _
         ZDnldCompleted = (INSTR(ZWorkAra$(ZFailureParm),ZFailureString$) <> 1)
      GOSUB 21760
      CALL KillWork ("XFER-" + ZNodeID$ + ".DEF")
      CALL CheckCarrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7
      RETURN
'
' *  XFER FILE NOT Found
'
20267 ZWasEL = 20263
      GOTO 21900
'
20318 '* "Please Switch to N,8,1 for binary transfer"
      LineNum = 578
      GOSUB 21915
      ZOutTxt$ = Strng$
      GOSUB 21630
      IF ZFileSysParm > 1 THEN _
         RETURN
      CALL DelayTime (3)
      RETURN
'
20337 IF ZProtoMacro$ <> "" THEN _
         ZGSRAra$(1) = MID$("DU ",ZTransferFunction,1) : _
         CALL MacroExe (ZProtoMacro$)
      RETURN
'
' *  U - COMMAND FROM FILES MENU (UPLOAD)
'
20395 GOSUB 21640
      IF ZFileSysParm > 1 THEN _
         RETURN
      '* "Correct name of file to upload{EX"
      LineNum = 584
      GOSUB 21915
      ZOutTxt$ = Strng$
      GOSUB 21660
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZWasQ = 0 THEN _
         RETURN
      ZUserInAra$(ZAnsIndex) = ZUserInAra$(1)
      GOTO 20435
20400 CALL TimeBack (1)
      ZUpBatchTransfer = ZFalse
      ZWasBatchTransfer = ZFalse
      ZMplPersUpload = ZFalse
      GOSUB 20420
      ZAutoLogOffReq = 0
      FirstUpld = ZAnsIndex
      GOTO 20430
20410 CALL TimeBack (1)
      GOSUB 21917
      ZErrCode = 0
      ZUpBatchTransfer = ZTrue
      ZErrCode = 0
      ZAutoLogOffReq = 0
      IF LEN(ZUserIn$) < 3 THEN _
         CALL UploadMessage : _
         CALL Batchit : _
         FirstUpld = 2 : _
         LastUpld = ZLastIndex : _
         GOTO 20430
      FirstUpld = ZAnsIndex
      GOTO 20430
20420 CALL UploadMessage
      '* "Upload what file(s){EX"
      LineNum = 585
      GOSUB 21915
      ZOutTxt$ = Strng$
      GOSUB 21667
      RETURN
'
' *  SEARCH FOR DUPLICATE FILENAME
'
20430 ZAnsIndex = ZLastIndex
      GOSUB 20471
      ZLastIndex = ZLastIndex + (WasX > 0)
      LastUpld = ZLastIndex
      FOR ZAnsIndex = FirstUpld TO LastUpld
         IndexSave = ZAnsIndex
         GOSUB 20471
         GOSUB 20435
         FirstUpld = FirstUpld + 1
         IF ZFileSysParm > 1 THEN _
            IndexSave = LastUpld + 1
         ZAnsIndex = IndexSave
      NEXT
      ZCmdTransfer$ = ""
      RETURN
20435 ZFileNameHold$ = ZUserInAra$(ZAnsIndex)
      ExtSrch = ZFalse
      IF INSTR(ZFileNameHold$,".") = 0 THEN _
         ZFileNameHold$ = ZFileNameHold$ + "." + ZDefaultExtension$
      CALL AllCaps(ZFileNameHold$)
      ZFileName$ = ZFileNameHold$
      '* "Upload{SP"
      LineNum = 1073
      GOSUB 21915
      ZViolation$ = Strng$
      CALL NoPath (ZFileName$,BadFileNameIndex)
      IF BadFileNameIndex THEN _
         GOTO 20451
      CALL BadFile (ZFileName$,BadFileNameIndex)
      ON BadFileNameIndex GOTO 20440,20451,20515
20440 FileIsHack = ZFalse
      FileInList = ZFalse
      FileOffLine = ZFalse

      TmpName$ = "TWITLIST.DEF"
      CALL FindIt (TmpName$)
      IF ZOK THEN
         CALL OpenWork(2,TmpName$)
         IsATwit = ZFalse
         TwitName$ = ""
         WHILE NOT EOF(2) AND NOT IsATwit
            INPUT #2, TwitName$
            CALL AllCaps (TwitName$)
            IsATwit = (INSTR(ZActiveUserName$,TwitName$) > 0)
         WEND
         CLOSE 2
         IF IsATwit THEN _
            FileOffLine = ZTrue : _
            GOTO 20443
      END IF

      TmpName$ = ZDirPath$ + "HACK.DEF"
      CALL FindIt (TmpName$)
      IF ZOK THEN
         HaveFile$ = ""
         FileIsHack = ZFalse
         WHILE NOT EOF(2) AND NOT FileIsHack
           CALL ReadParmsX(2,ZOutTxtAra$(),3,1)
           IF LEFT$(ZOutTxtAra$(1),1) <> ";" THEN
              ZOutTxtAra$(1) = ZOutTxtAra$(1) + "."
              StopReading = INSTR(ZOutTxtAra$(1),".")
              ZOutTxtAra$(1) = LEFT$(ZOutTxtAra$(1),StopReading)
              Search = INSTR(ZFileNameHold$,".")
              Search$ = Left$(ZFileNameHold$,Search)
              IF Search$ = ZOutTxtAra$(1) THEN
                 FileIsHack = ZTrue
              END IF
           END IF
         WEND
         CLOSE 2
      END IF
      IF FileIsHack THEN _
         GOTO 20443

      TmpName$ = ZDirPath$+"NOTHANX.DEF"
      CALL FindIt (TmpName$)
      IF ZOK THEN
         HaveFile$ = ""
         FileInList = ZFalse
         WHILE NOT EOF(2) AND NOT FileInList
            INPUT #2, HaveFile$
            CALL AllCaps (HaveFile$)
            FileInList = (INSTR(ZFileNameHold$,HaveFile$) > 0)
         WEND
         CLOSE 2
      END IF
      IF FileInList THEN _
      GOTO 20443

      TmpName$ = ZDirPath$+"UPEXT.DEF"
      CALL FindIt (TmpName$)
      IF ZOK THEN
         Found = ZFalse
         HaveFile$ = ""
         FileInList = ZFalse
         WHILE NOT EOF(2) AND NOT Found
            INPUT #2, HaveFile$
            CALL AllCaps (HaveFile$)
            Found = (INSTR(ZFileNameHold$,HaveFile$) > 0)
         WEND
         FileInList = NOT Found
         CLOSE 2
      END IF
      IF FileInList THEN _
      GOTO 20443

      TmpName$ = ZDirPath$ + ZMainFMSDir$ + ".OFL"
      CALL FindIt (TmpName$)
      IF NOT ZOK THEN
         TmpName$ = ZDirPath$ + "OFFLINE.DEF"
         CALL FindIt (TmpName$)
      END IF
      IF ZOK THEN
         HaveFile$ = ""
         FileOffLine = ZFalse
         TimeNow! = TIMER
         PrevTi! = TimeNow!
         NumDots = 0
         AlreadyPrinted = ZFalse
         WHILE NOT EOF(2) AND NOT FileOffLine
            TimeNow! = TIMER
            IF TimeNow! - PrevTi! > 0.5 THEN
               IF NOT AlreadyPrinted THEN
                  '* "{CBSearching {CEOFFLINE {CBDirectory{RC"
                  CALL FormatString (961,ZFalse,ZFalse,0,ZTrue,0,"")
                  AlreadyPrinted = ZTrue
               END IF
               CALL MarkTime (NumDots)
               PrevTi! = TimeNow!
            END IF
            LINE INPUT #2, HaveFile$
            CALL AllCaps (HaveFile$)
            StopReading = INSTR(HaveFile$,".")
            IF StopReading > 0 THEN
               HaveFile$ = Left$(HaveFile$,StopReading)
            END IF
            Search = INSTR(ZFileNameHold$,".")
            IF Search > 0 THEN
               Search$ = Left$(ZFileNameHold$,Search)
            ELSE
               Search$ = ZFileNameHold$
            END IF
            IF Search$ = HaveFile$ THEN
               FileOffLine = ZTrue
            END IF
         WEND
         CLOSE 2
         IF AlreadyPrinted THEN
            CALL QuickTPut1 (ZBackSpace$)
         END IF
      END IF

20443 IF ZSysop THEN
         FileIsHack = ZFalse
         FileinList = ZFalse
         FileOffLine = ZFalse
      END IF
      IF FileIsHack THEN
         FileName$ = ZHelpPath$ + "HACK" + ZOutTxtAra$(3) + ".MSG"
         CALL FindFile (FileName$,ZOK)
         IF NOT ZOK THEN
            FileName$ = ZHelpPath$ + "HACK.MSG"
         END IF
         CALL GraphicDisplayFile (FileName$)
         GOTO 20453
      END IF
      IF FileInList THEN _
         CALL BufFile (ZHelpPath$+"NOTHANX.MSG",WasX) : _
         GOTO 20453
      IF FileOffLine THEN
         '* "The file {FI is stored OffLine!"
         CALL FormatString (1103,ZFalse,ZFalse,0,ZTrue,1,"")
         GOTO 20453
      END IF
      CALL CheckCarrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      PersFile$ = ZFileName$
      ZFileName$ = ZPersonalDrvPath$ + PersFile$
      Call FindFile (ZFileName$,ZOK)
      IF ZOK THEN
         GOTO 20452
      END IF
      ZFileName$ = PersFile$
      CALL RotorsDir (ZFileName$,ZSubDir$(),ZSubDirCount,ZTrue,"U")
      IF ZOK THEN _
         GOTO 20452
      IF INSTR(ZFileName$,".") = 0 THEN _
         GOTO 20475
      CALL BreakFileName (ZFileName$,DR$,WasX$,Extension$,ZFalse)
      WasI = 1
20447 WasJ = INSTR(MID$(ZCompressedExt$+". ",WasI),".")
      IF WasJ = 0 THEN _
         GOTO 20475
      Check$ = MID$(ZCompressedExt$,WasI,WasJ-1)
      WasI = WasI + WasJ
      IF Extension$ <> Check$ THEN _
      CALL RotorsDir (WasX$ + "." + Check$,ZSubDir$(),ZSubDirCount,ZTrue,"U") : _
         IF ZOK THEN _
            ExtSrch = ZTrue : _
            GOTO 20452
      GOTO 20447
20451 '* "Invalid filename <{FI>"
      LineNum = 586
      GOSUB 21915
      ZOutTxt$ = Strng$
      GOTO 20395
20452 IF ZUserSecLevel < ZOverWriteSecLevel THEN _
         GOTO 20453
      IF ExtSrch AND (WasX$ + "." + Check$) <> ZFileName$ THEN
         '* "{SPalready here, upload anyway? (Y,[N])"
         LineNum = 587
         GOSUB 21915
         ZOutTxt$ = WasX$ + "." + Check$ + Strng$
      ELSE
         '* "Overwrite file? (Y,[N])"
         LineNum = 588
         GOSUB 21915
         ZOutTxt$ = Strng$
      END IF
      GOSUB 21660
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF NOT ZYes THEN _
         GOTO 20453
      ZWasZ$ = ZFileName$
      CALL KillWork (ZFileName$)
      IF ZErrCode <> 0 AND ZErrCode <> 53 THEN
         '* "Unable to overwrite"
         LineNum = 589
         GOSUB 21915
         ZOutTxt$ = Strng$
         GOSUB 21660
         RETURN
      END IF
      GOTO 20475
20453 CLOSE 2
      IF FileIsHack OR FileInList THEN
         '* "Upload of unwanted file {FH attempted"
         CALL FormatString (590,ZFalse,ZTrue,1,ZFalse,0,"")
         IF ZUserSecLevel < ZSysopSecLevel THEN
            RETURN
         ELSE
            GOTO 20455
         END IF
      END IF
      IF ZUserSecLevel >= ZAddDirSecurity THEN _ 
         GOTO 20455 
      IF FileOffLine OR ZOK THEN
         '* "Thanks, but we already have {FH"
         CALL FormatString (591,ZFalse,ZFalse,0,ZTrue,1,"")
      END IF
      CALL SmartPause (ZFalse)
      PersFile$ = ""
      '* "Upload duplicate {FH"
      CALL FormatString (592,ZFalse,ZTrue,1,ZFalse,0,"")
      RETURN
20455 '* "Add new directory entry? (Y,[N])"
      LineNum = 593
      GOSUB 21915
      ZOutTxt$ = Strng$
      ZTurboKey = - ZTurboKeyUser
      GOSUB 21660
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF NOT ZYes THEN _
         RETURN
      GOSUB 20460
      IF WhoTo$ = "" THEN _
         RETURN
      AddingDescOnly = ZTrue
      ZWasBatchTransfer = ZFalse
      ZWasFT$ = "l"
      CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),ZLinesInMsg,1)
      GOSUB 20702
      RETURN

20460 GOSUB 21918
      WhoTo$ = ""
      '* "ALL"
      LineNum = 450
      GOSUB 21915
      IF ZUpBatchTransfer THEN
         WhoTo$ = Strng$
      END IF
      WasY$ = ZFileName$
      IF ZUserSecLevel >= ZMinSecPersUpld THEN _
         CALL SetWhoTo (ZTrue,WhoTo$,"",RcvrRecNum,Found,ZTrue) _
      ELSE WhoTo$ = Strng$
      ZFileName$ = WasY$
      RETURN

20470 ' *** CHECK FOR Protocol/Marked files IN FILE LIST ***
      WasX = 0
      ZWasZ$ = ZUserInAra$(ZAnsIndex)
      CALL UnMarkItems (ZMarkedFiles$,ZAnsIndex,LastDnld,FoundMarked,ZTrue)
      IF FoundMarked THEN _
         RETURN

20471 ZWasZ$ = ZUserInAra$(ZAnsIndex)
      CALL AllCaps(ZWasZ$)
      WasX = 0
      IF LEN (ZWasZ$) = 1 THEN _
         WasX = INSTR(ZDefaultXfer$,ZWasZ$) : _
         IF WasX > 0 THEN _
            ZAnsIndex = ZAnsIndex + 1 : _
            IndexSave = IndexSave + 1 : _
            ZCmdTransfer$ = ZWasZ$
      RETURN

20475 ZWasZ$ = ZUpldDriveFile$
      CALL FindFree
      IF VAL(ZFreeSpace$) < 4096 THEN _
         GOSUB 21895 : _
         IndexSave = ZLastIndex + 1 : _
         RETURN
      '* "Upload drive has {FM free"
      LineNum = 594
      GOSUB 21915
      ZOutTxt$ = Strng$
      GOSUB 21640
      IF ZFileSysParm > 1 THEN _
         RETURN
      GOSUB 20460
      IF ZMplPersUpload = ZTrue THEN _
         ZFileName$ = ZPersonalDrvPath$ + PersFile$
      CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),ZLinesInMsg,1)

      IF ZAbort THEN _
         ZAbort = ZFalse : _
         RETURN
      '* "(U) {FH"
      LineNum = 1074
      GOSUB 21915
      ZLine25$ = Strng$
      ZSubParm = 2
      CALL Line25
      ZOutTxt$ = ""
      ZOK = ZTrue

      IF ZUpBatchTransfer AND FirstUpld <> LastUpld THEN
         RETURN
      END IF
      CALL XferType (2,ZTrue)
      IF ZFF THEN _
         GOTO 20500
      CALL XferType (1,ZTrue)
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      IF ZWasQ = 0 THEN _
         RETURN
20500 ZTransferFunction = 2
      GOSUB 21790
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF NOT ZUpBatchTransfer THEN
         CALL AutoLogOff
      END IF
      IF ZAutoEnd = 2 THEN
         GOSUB 21917
         RETURN
      END IF
      GOTO 20261

20515 CALL SecViolation
      IF ZDenyAccess THEN _
         ZFileSysParm = 4 : _
         RETURN
      GOTO 20420
'
' *  UPDATE UPLOAD DIRECTORY
'
20700 GOSUB 21780
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZWasBatchTransfer THEN _
         CALL BatchUpload (ZDesc$,ZUCat$,2) : _
         GOTO 20703
20702 CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(), ZLinesInMsg,2)
20703 IF ZAutoEnd = 1 THEN _
         ZFileSysParm = 7: _
         ZDnldCompleted = ZTrue : _
         RETURN
      IF NOT ZGetExtDesc THEN _
         ZPrivateDoor = ZFalse : _
         GOTO 20710
      '* "Extended Description of {FH"
      LineNum = 600
      GOSUB 21915
      ZMsgHeader$ = Strng$
      ZSysopComment = ZTrue
      ZMaxMsgLines = ZMaxExtendedLines
      WasLL = ZRightMargin
      ZRightMargin = 30 + ZMaxDescLen
      IF ZRightMargin > 74 THEN _
         ZRightMargin = 74
      ZFileSysParm = 5
      RETURN
20705 ZMaxMsgLines = ZMaxMsgLinesDef
      ZRightMargin = WasLL
      CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),ZLinesInMsg,3)
20710 AddingDescOnly = ZFalse
      IF ZBytesInFile# > 0.0 THEN _
         GOTO 21770
20730 GOSUB 21780
      '* "Upload aborted"
      CALL FormatString (601,ZFalse,ZFalse,0,ZTrue,1,"")
      ZAutoLogoffReq = ZFalse
      ZWasBatchTransfer = ZFalse
      ZUpBatchTransfer = ZFalse
      LastUpld = 0
      ZPrivateDoor = ZFalse
20735 CALL KillWork (ZFileName$)
      IF ZErrCode <> 0 THEN _
         ZWasEL = 20736 : _
         GOTO 21900
      ZAnsIndex = ZLastIndex + 1
      IndexSave = ZAnsIndex
      ZLastIndex = 0
      RETURN
'
' *  CALCULATE DOWNLOAD TIME ESTIMATE
'
20750 CALL OpenRSeq (2,ZFileName$,MaxBlock&,ZWasDF,ZFLen)
      IF ZErrCode <> 0 THEN
         '* "Unable to access {FH"
         CALL FormatString (603,ZFalse,ZTrue,2,ZTrue,1,"")
         ZOK = ZFalse
         ZErrCode = 0
         ZBytesInFile# = 0
         RETURN
      END IF
      ZBytesInFile# = LOF(2)
      ZNumDnldBytes! = LOF(2)
      ZOK = ZTrue
      IF SizeOnly THEN _
         SizeOnly = ZFalse : _
         RETURN
      ZBlocksInFile# = MaxBlock&
      IF ZBatchTransfer THEN _
         BatchBlocks# =  BatchBlocks# + ZBlocksInFile# : _
         BatchBytes# = BatchBytes# + ZBytesInFile# : _
         CALL OpenWorkA (2,ZNodeWorkFile$) : _
         CALL PrintWorkA (2,ZFileName$) : _
         ZDownFiles = ZDownFiles + 1 : _
         CLOSE 2 : _
         RETURN
      ZDownFiles = 1
20780 '* "{CR{CAFile Size: {CE"
      LineNum = 604
      GOSUB 21915
      ZOutTxt$ = Strng$
      ZOK = ZTrue
      IF ZBlockSize > 0 THEN
         '* "{C2 blocks {CE"
         LineNum = 605
         GOSUB 21915
         ZOutTxt$ = ZOutTxt$ + STR$(FIX(ZBlocksInFile#)) + Strng$
      END IF
      ZBlocksInFile# = ZBlocksInFile# / _
         VAL(MID$(ZBaudRateVals$, -4 * ZCBPS, 4))
      ZBlocksInFile# = ZBlocksInFile# * ZFLen / ZSpeedFactor!
      IF (ZAnsIndex > 1 AND ZConcatFIles) THEN _
         RETURN
      '* "{C2 bytes"
      LineNum = 606
      GOSUB 21915
      ZOutTxt$ = ZOutTxt$ + STR$(ZBytesInFile#) + Strng$
      GOSUB 21650
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZBytesInFile# < 1 THEN _
         RETURN
      ZSubParm = 2
      CALL Line25
      '* "{CBEstimated Transfer Time:{CD"
      LineNum = 607
      GOSUB 21915
      Strng1$ = Strng$
      '* "{C3 mins, {CD"
      LineNum = 608
      GOSUB 21915
      Strng2$ = Strng$
      '* "{C3 secs{RC{CR"
      LineNum = 609
      GOSUB 21915
      Strng3$ = Strng$
      ZOutTxt$ = Strng1$ + STR$(INT(ZBlocksInFile# / 60)) + _
                 Strng2$ + _
                 STR$(INT(ZBlocksInFile# - (INT(ZBlocksInFile# / 60) * 60))) + _
                 Strng3$
      GOSUB 21650
      IF ZFileSysParm > 1 THEN _
         RETURN
      CALL CheckTimeRemain (MinsRemaining)
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 6 : _
         RETURN
      ZOK = ZTrue
      Temp = ZExtraDnldTime
      CALL ChkAddedTime (Temp)
      Temp = MinsRemaining + Temp
      ZWasA = INT(ZBlocksInFile# / 60) + 1
      IF ZWasA <= Temp THEN _
         GOTO 20793
      IF ZDownFiles < 2 THEN
         CALL AllCaps (ZFileNameHold$)
         '* "{FH - Not enough minutes left!  Need"
         LineNum = 610
         GOSUB 21915
         Strng1$ = Strng$
         '* "{SPhave"
         LineNum = 611
         GOSUB 21915
         Strng2$ = Strng$
         ZOutTxt$ = Strng1$ + STR$(ZWasA) + Strng2$ + STR$(Temp)
         CALL QuickTPut (ZOutTxt$,2)
         ZNonStop = ZFalse
         ZWasQ = 0
         ZDnldFlag = 0
         IF NoTimeDnFlag THEN
            CALL UpdtCalr (ZOutTxt$,2)
         END IF
         CALL SmartPause (ZFalse)
      END IF
      IF ZDownFiles < 2 THEN _
         GOTO 20791
      CALL OpenWork (2,ZNodeWorkFile$)
      WHILE NOT EOF(2) AND NoTimeDnFlag
            CALL ReadDir (2,1)
            CALL BreakFileName (ZOutTxt$,DR$,ZWasY$,WasX$,ZTrue)
            ZFileName$ = ZWasY$ + WasX$
            '* "{FI - Not enough minutes left! Need"
            LineNum = 612
            GOSUB 21915
            Strng1$ = Strng$
            '* "{SPhave"
            LineNum = 611
            GOSUB 21915
            Strng2$ = Strng$
            ZOutTxt$ = Strng1$ + STR$(ZWasA) + Strng2$ + STR$(Temp)
            CALL UpdtCalr (ZOutTxt$,2)
      WEND
      NoTimeDnFlag = 0
      CLOSE 2
      '* "Not enough minutes left! Need"
      LineNum = 613
      GOSUB 21915
      Strng1$ = Strng$
      '* "{SPhave"
      LineNum = 611
      GOSUB 21915
      Strng2$ = Strng$
      ZOutTxt$ = Strng1$ + STR$(ZWasA) + Strng2$ + STR$(Temp)
      CALL QuickTPut (ZOutTxt$,2)
      CALL SmartPause (ZFalse)
20791 IF ZDownFiles < 2 THEN _
         GOTO 20792
      ZLastIndex = 0
      '* "Edit files to download? ([Y],N)"
      LineNum = 614
      GOSUB 21915
      ZOutTxt$ = Strng$
      ZTurboKey = - ZTurboKeyUser
      GOSUB 21668
      IF ZNo THEN _
         LastDnld = 0 : _
         GOTO 20792
      Temp = 0
      CALL OpenWork (2,ZNodeWorkFile$)
      WHILE NOT EOF(2)
         CALL ReadDir (2,1)
         CALL BreakFileName (ZOutTxt$,DR$,ZWasY$,WasX$,ZTrue)
         ZFileName$ = ZWasY$ + WasX$
         '* "Download {FI? (Y,[N])"
         LineNum = 615
         GOSUB 21915
         ZOutTxt$ = Strng$
         ZTurboKey = - ZTurboKeyUser
         GOSUB 21668
         IF ZYes THEN _
            Temp = Temp + 1 : _
            ZOutTxtAra$(Temp) = ZFileName$
      WEND
      CLOSE 2
      ZAnsIndex = 1
      ReStart = (Temp > 0)
      LastDnld = Temp
      ZLastIndex = Temp
      FOR WasX = 1 TO Temp
         ZUserInAra$(WasX) = ZOutTxtAra$(WasX)
      NEXT
20792 ZOutTxt$ = ""
      ZOK = ZFalse
      ZAutoLogoffReq = ZFalse
      RETURN
20793 IF ZRatioRestrict# > 0 THEN
         GOSUB 21775
         IF ZFreeDnld = ZFalse THEN
            '* "{CORATIOS Enforced!{RC{CR{C2New statistics will be:{CR{CE-----------------------{RC"
            CALL FormatString (616,ZFalse,ZFalse,0,ZFalse,0,Strng$)
            IF ZWasGR > 0 THEN
               CALL GlobalSrchRepl (Strng$,"-",CHR$(196),ZTrue)
            END IF
            CALL QuickTPut1 (Strng$)
            CALL CheckRatio (ZTrue)
         END IF
      END IF
      IF ZBatchTransfer OR (NOT ZBatchTransfer AND ZAnsIndex >= LastDnld) THEN
         CALL AutoLogoff
         IF ZAutoEnd = 2 THEN
            GOSUB 21917
            ZOK = ZFalse
         END IF
      END IF
      RETURN
'
' *  CHANGE TO 8 BIT
'
20992 IF ZFileSysParm > 1 THEN _
         ZFileSysParm = 2 : _
         RETURN
      IF NOT ZEightBit THEN _
         PrevLineCntl = INP (ZLineCntlReg) : _
         CALL DelayTime (3) : _
         SwitchToEight = ZTrue : _
         OUT ZLineCntlReg,3
      WasSO = 0
      RETURN
'
' STANDARD ENTRY FOR RBBS-PC'S COMMON TERMINAL OUTPUT ROUTINE
'
21630 ZSubParm = 1
      GOTO 21655
21640 ZSubParm = 3
      GOTO 21655
21650 ZSubParm = 5
21655 CALL TPut
      IF ZSubParm < 0 THEN _
         ZFileSysParm = 2 : _
         RETURN
      IF ZSubParm = 8 THEN _
         GOSUB 21660
      RETURN
'
' STANDARD ENTRY FOR RBBS-PC'S COMMON TERMINAL INPUT ROUTINE
'
21660 ZSubParm = 1
      CALL TGet
21665 IF ZSubParm < 0 THEN _
         ZFileSysParm = 2
      RETURN
21667 ZStackC = ZTrue
21668 CALL PopCmdStack
      GOTO 21665
21700 ZErrCode = 0
      ZLastIndex = 0
      RETURN
'
' * UPDATE DOWNLOAD STATISTICS
'
'  (formerly lines 50600 to 50614 in RBBS-PC.BAS
21760 GOSUB 21780
      IF ZFileSysParm > 1 THEN _
         RETURN
      IF ZBatchTransfer THEN
         CALL Findit("XFER-" + ZNodeID$ + ".DEF")
         IF ZOK AND LOF(2) <> 0 THEN
            ZDownFiles = 0
            WHILE NOT EOF(2)
               LINE INPUT #2, StatusLine$
               IF INSTR("EL",LEFT$(StatusLine$,1)) = 0 THEN
                  ZDownFiles = ZDownFiles + 1
               END IF
            WEND
         ELSE
            CALL LinesInFile (ZNodeWorkFile$,ZDownFiles)
         END IF
      ELSE
         ZDownFiles = 1
      END IF
      ZMenuDownloads = ZMenuDownloads + ZDownFiles
      IF NOT ZDnldCompleted THEN
         ZAutoLogoffReq = ZFalse
         '* "{SPAborted"
         LineNum = 621
         GOSUB 21915
         ZWasDFF$ = Strng$
         GOTO 21770
      END IF
      CALL LogPDown (ZPersonalDnld,1+ZAnsIndex-FirstDnld)
      GOSUB 21775
      WasX = ((ZRatioRestrict# > 0) AND ZEnforceRatios AND ZFreeDnld)
      IF NOT WasX THEN _
         ZDnlds = ZDnlds + ZDownFiles : _
         ZGlobalDLToday! = ZGlobalDLToday! + ZDownFiles : _
         ZGlobalDnlds = ZGlobalDnlds + ZDownFiles : _
         ZDLBytesVal! = ZDLBytesVal! + ZNumDnldBytes! : _
         ZGlobalDLBytes! = ZGlobalDLBytes! + ZNumDnldBytes! : _
         ZDLToday! = ZDLToday! + ZDownFiles : _
         ZBytesToday! = ZBytesToday! + ZNumDnldBytes! : _
         ZGlobalBytesToday! = ZGlobalBytesToday! + ZNumDnldBytes!
      ZNumDnldBytes! = 0
      IF (ZAnsIndex = LastDnld OR NOT ZConcatFIles) THEN
         CALL UpdateDnlds
         '* "{CR{CEDownload(s) successful{RC"
         CALL FormatString (622,ZFalse,ZFalse,0,ZTrue,1,"")
      END IF
      IF WasX THEN
         '* "{CAbut not counted against ratios{RC"
         CALL FormatString (623,ZFalse,ZFalse,0,Ztrue,1,"")
      END IF
      IF NOT ZAutoLogOffReq THEN
         CALL SmartPause (ZFalse)
      END IF
      '* "{SPDownloaded"
      LineNum = 624
      GOSUB 21915
      ZWasDFF$ = Strng$
21770 CALL AMorPM
      IF NOT ZBatchTransfer THEN _
         ZWasQ = 1 : _
         ZUserInAra$(1) = ZFileName$ : _
         GOTO 21772
      CALL OpenWork (2,ZNodeWorkFile$)
      IF ZErrCode > 0 THEN _
         RETURN
      ZWasQ = 0
      WHILE NOT EOF(2)
         CALL ReadAny
         ZWasQ = ZWasQ + 1
         ZUserInAra$(ZWasQ) = ZOutTxt$
      WEND
21772 IF ZWasQ < 1 THEN
         ZBatchTransfer = ZFalse
         GOSUB 21918
         RETURN
      END IF
      CALL OpenWork (2,ZUserInAra$(ZWasQ))
      IF ZErrCode > 0 THEN _
         ZErrCode = 0 : _
         ZWasQ = ZWasQ - 1 : _
         GOTO 21772
      ZBytesInFile# = LOF(2)
      ZFileName$ = ZUserInAra$(ZWasQ)
      IF ZTransferFunction = 1 THEN
      CALL BreakFileName (ZFileName$,DR$,WasX$,Extension$,ZTrue)

      CALL Findit("XFER-" + ZNodeID$ + ".DEF")
      IF ZOK AND LOF(2) <> 0 THEN
         DO
            LINE INPUT #2, SearchLine$
            IF INSTR(SearchLine$,WasX$ + Extension$) THEN
               CPSStart = INSTR(UCASE$(SearchLine$),"BPS")
               IF CPSStart THEN
                  XFerCPS$ = MID$(SearchLine$,CPSStart + 3)
                  CPSEnd = INSTR(UCASE$(XFerCPS$),"CPS")
                  IF CPSEnd THEN
                     XFerCPS$ = MID$(XFerCPS$,1,CPSEnd + 3)
                  END IF
               ELSE
                  XFerCPS$ = ""
               END IF
               EXIT DO
            END IF
         LOOP UNTIL EOF(2)
      END IF

      '* "{SPat{SP"
      LineNum = 1016
      GOSUB 21915
      Strng1$ = Strng$
      '* "{SPusing{SP"
      LineNum = 1035
      GOSUB 21915
      Strng2$ = Strng$
      FileSize# = ZBytesInFile#
      IF FileSize# > 999 THEN
         WasK# = CDBL(FileSize# / 1000!)
         IF WasK# > 9999 THEN
            WasK# = 9999
         END IF
         FileSize$ = STR$(WasK#)
         IF INSTR(FileSize$,".") <> 0 THEN
            FileSize$ = LEFT$(FileSize$,INSTR(FileSize$,".") - 1)
         END IF
         FileSize$ = FileSize$ + "K"
      ELSE
         FileSize$ = LTRIM$(STR$(FileSize#))
      END IF
      ZWasZ$ = WasX$ + _
           Extension$ + _
           ZWasDFF$ + _
           Strng1$ + _
           ZTime$ + _
           Strng2$ + _
           ZWasFT$ + _
           FileSize$ + _
           XFerCPS$
         CALL UpdtCalr (ZWasZ$,2)
      END IF
      IF ZBatchTransfer THEN _
         ZWasQ = ZWasQ - 1 : _
         GOTO 21772
      RETURN
21775 TmpName$ = ZDirPath$ + "FREE.DEF"
      TempZOK = ZOK
      CALL FindIt (TmpName$)
      IF ZOK THEN
         CALL OpenWork (2, TmpName$)
         HaveFile$ = ""
         FileIsFree = ZFalse
         ZFreeDnld = ZFalse
         WHILE NOT EOF(2) AND NOT FileIsFree
            INPUT #2, FreeFileName$
            CALL AllCaps (FreeFileName$)
            FileIsFree = (INSTR(LEFT$(ZFileNameHold$,LEN(FreeFileName$)),FreeFileName$) > 0)
         WEND
         CLOSE 2
         IF FileIsFree THEN
            ZFreeDnld = ZTrue
         END IF
      END IF
      ZOK = TempZOK
      RETURN
'
'
' *****   TURN ON INTERMEDIATE ECHO   ****
'
'  (formerly line 50620 in RBBS-PC.BAS
21780 IF ZEchoer$ = "I" THEN _
         CALL SetEcho ("I")
'
' *  RESTORE COMMUNICATIONS AFTER Switch TO 8 BIT
'
'  (formerly between lines 50620 and 50630 in RBBS-PC.BAS
      IF SwitchToEight THEN _
         IF ZSwitchBack THEN _
            OUT ZLineCntlReg, PrevLineCntl : _
            CALL DelayTime (3) : _
            ZEightBit = ZFalse : _
            SwitchToEight = ZFalse
      RETURN
'
' *****  TURN OFF INTERMEDIATE ECHO  ****
'
'  (formerly line 50630 in RBBS-PC.BAS
21790 Call CheckCarrier
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7 : _
         RETURN
      IF ZEchoer$ = "I" THEN _
         CALL SetEcho ("R")
      RETURN
'
' *****   DIRECTORY SEARCH   ****
'
21800 WasCK = 2
      '* "Search string or filename (wildcards OK){EX"
      LineNum = 625
      GOSUB 21915
      ZOutTxt$ = Strng$
      ZMacroMin = 99
      GOSUB 21668
      IF ZWasQ = 0 THEN _
         RETURN
      WasRS$ = ZUserInAra$(ZAnsIndex)
      WildSearch = (INSTR(WasRS$,"*") > 0 OR INSTR(WasRS$,"?") > 0)
      CALL AllCaps (WasRS$)
      IF RIGHT$(WasRS$,1) = "*" THEN _
         IF RIGHT$(WasRS$,2) <> ".*" THEN _
            WasRS$ = WasRS$ + ".*"
      SearchString$ = WasRS$
      SearchDate$ = ""
      ZJumpSearching = ZFalse
      WasA1$ = WasRS$
      GOTO 21867
'
' *****  P - personal download  ****
'
'  (formerly lines 52950 to 52952 in RBBS-PC.BAS
21850 IF ZPersonalBegin < 1 OR ZPersonalLen < 1 THEN _
         RETURN
      IF NOT ZExpertUser THEN _
         FileName$ = ZWelcomeFileDrvPath$ + "P.MNU" : _
         CALL GraphicDisplayFile (FileName$)
      DnldFlag = 0
      ZPersonalDnld = ZTrue
      ZFMSHeaderDisplay$ = "P"
21852 ZActiveFMSDir$ = ZPersonalDir$
      CALL DispUpDir (WasX$,SearchString$,SearchDate$,DnldFlag,ZAnsIndex)
      IF ZSubParm = -1 THEN _
         ZFileSysParm = 7: _
         RETURN
      IF ZAnsIndex > ZLastIndex THEN _
         GOTO 21854
      ZConcatFIles = ZPersonalConcat
      ZStopInterrupts = ZTrue
      TimeLockExempt = ZTrue
      GOSUB 20202
      IF ZFileSysParm > 1 THEN _
         GOTO 21854
      TimeLockExempt = ZFalse
      ZConcatFIles = ZFalse
      GOTO 21852
21854 ZActiveFMSDir$ = ""
      CALL OpenFMS (LastRec&,WasL)
      RETURN
'
' *  WasN - COMMAND FROM FILES MENU (DISPLAY NEW FILES SINCE Last DIR DISPLAY)
'
21860 WasCK = 1
21862 WasA1$ = RIGHT$(ZWasLM$,4) +_
            LEFT$(ZWasLM$,2)
      '* "Files on/after MMDDYY, [S]ince ={SP"
      LineNum = 626
      GOSUB 21915
      ZOutTxt$ = Strng$ + WasA1$
      GOSUB 21668
      CALL AraAllCaps (ZUserInAra$(),ZAnsIndex)
      IF ZWasQ = 0 OR ZUserInAra$(ZAnsIndex) = "S" THEN _
         WasRS$ = ZWasLM$ : _
         GOTO 21866
      IF LEN(ZUserInAra$(ZAnsIndex)) <> 6 THEN _
         GOTO 21862
      WasA1$ = ZUserInAra$(ZAnsIndex)
      WasRS$ = RIGHT$(WasA1$,2) + _
            LEFT$(WasA1$,4)
      ListNew = ZTrue
21866 SearchDate$ = WasRS$
      SearchString$ = ""
      ZJumpSearching = ZFalse
      ZUserInAra$(ZAnsIndex) = "A"
      IF ZLastIndex < ZAnsIndex THEN ZLastIndex = ZAnsIndex
      ZEndList = ZTrue
      GOTO 21871
21867 CALL GetDirs (ZFalse)
      IF ZWasQ = 0 THEN _
         RETURN
21871 CALL ConvertDir (ZAnsIndex)
      ZListDir = ZTrue
      ListNew = ZTrue
      ZSearchingAll = ZFalse
21875 ZWasZ$ = ZUserInAra$(ZAnsIndex)
      IF NOT ZSearchingAll THEN
         '* "ALL"
         LineNum = 450
         GOSUB 21915
         IF ZWasZ$ = Strng$ THEN
            IF NOT ZLimitSearchToFMS THEN
               GOSUB 21890
            END IF
         END IF
      END IF
      WasQX = ZAnsIndex
      GOSUB 20157
      IF ZFileSysParm > 1 THEN _
         RETURN
      ZAnsIndex = ZAnsIndex + 1
      IF ZAnsIndex <= ZLastIndex THEN _
         GOTO 21875
      ListNew = ZFalse
      ZEndList = ZFalse
      SearchString$ = ""
      SearchDate$ = ""
      RETURN
21890 WasG = ZAnsIndex
      CALL GetAll (ZUserInAra$(),WasG)
      ZSearchingAll = ZTrue
      ZLastIndex = WasG
      ZAnsIndex = ZAnsIndex + 1
      RETURN
21895 '* "No room for uploads. Try tomorrow"
      CALL FormatString (627,ZFalse,ZFalse,0,ZTrue,1,"")
      RETURN
'
' *  MAIN FILE SYSTEM ERROR TRAP - ALL ERRORS PASS THROUGH THIS ROUTINE
'
21900 IF ZDebug THEN _
         ZOutTxt$ = "RBBSSUB5 DEBUG Error Trap Entry ERL=" + _
              STR$(ZWasEL) + _
              " ERR=" + _
              STR$(ZErrCode) : _
         IF ZPrinter THEN _
            CALL Printit(ZOutTxt$) _
         ELSE CALL LPrnt(ZOutTxt$,1)
      IF ZWasEL = 20126 AND ZErrCode = 53 THEN _
         GOTO 20142
      IF ZWasEL = 20242 AND ZErrCode = 62 THEN _
         CALL UpdtCalr (ZFileSecFile$ + " bad format!",2) : _
         GOTO 20247
      IF ZWasEL = 20263 THEN _
         ZOutTxt$ = "<Download aborted>" : _
         ZDnldCompleted = ZFalse : _
         GOTO 21760
      IF ZWasEL = 20736 AND ZErrCode = 53 THEN _
         GOTO 21700
      CALL LogError
      CALL QuickTPut1 (ZCallersRecord$)
      ZFileSysParm = 3
      RETURN
21915 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      RETURN
21917 CALL KillWork (ZNodeWorkDrvPath$ + "UDSC" + ZNodeID$ + ".LST")
      CALL KillWork (ZBatchWorkFile$)
      CALL KillWork (ZNodeWorkDrvPath$ + "BTUP" + ZNodeID$ + ".LST")
21918 CALL KillWork (ZNodeWorkFile$)
      RETURN
21920 END SUB
'
22005 ' $SUBTITLE: 'UpdtUpload -- Updates upload directory'
' $PAGE
'  NAME    -- UpdtUpload
'
'  INPUTS  -- PARAMETER             MEANING
'             ZFileName$
'             ZUpldDir$
'             ZFileNameHold$
'             ZShareIt
'             ZFMSDirectory$
'             ZWasQQ!
'             ZSecsUsedSession!
'
'  OUTPUTS -- ZBytesInFile#
'             ZSecsPerSession!
'
'  PURPOSE -- Upon a successful upload, add entry to the upload
'             directory and give any session time credit.
'
      SUB UpdtUpload (ZCategoryName$(1),ZCategoryCode$(1),LinesInDesc,WasFF) STATIC
      ON WasFF GOTO 22010,22024,22022
22010 ZAlreadyGiven = ZFalse
      ZAbort = ZFalse
      CALL BreakFileName (ZFileNameHold$,Pre$,Body$,Ext$,ZFalse)
      IF (ZBBSOptions AND 2048) = 0 AND Ext$ = "GIF" THEN
         GIFDimenSet = ZFalse
         DescLen = ZMaxDescLen + (5 * ZShowTimesDownloaded) - 15
         '* "{C2Dimensions will automatically be placed in description{RC"
         CALL FormatString (380,ZFalse,ZFalse,0,ZTrue,1,"")
      ELSE
         DescLen = ZMaxDescLen + (5 * ZShowTimesDownloaded)
      END IF
22011 '* "{C2Describe {CB{FH{RC"
      CALL FormatString (381,ZFalse,ZFalse,0,ZTrue,1,"")
      '* "{C2Enter {CB{G1ABORT{C2{G0 to cancel!{RC"
      CALL FormatString (382,ZFalse,ZFalse,0,ZTrue,1,"")
      '* "{CE|-----<{CCMin{CE"
      LineNum = 383
      GOSUB 22090
      Strng1$ = Strng$
      '* "----+---2+0---+---3+0---+---4+0---+-"
      LineNum = 384
      GOSUB 22090
      Strng2$ = Strng$
      '* "{CCMax{CE>{RC"
      LineNum = 385
      GOSUB 22090
      Strng3$ = Strng$
      CALL QuickTPut1 (Strng1$ + LEFT$(Strng2$,DescLen-14) + Strng3$)
      ZOutTxt$ = ""
      ZSubParm = 1
      ZParseOff = ZTrue
      CALL TGet
      CALL CheckCarrier
      IF ZSubParm = -1 THEN _
         EXIT SUB
      TempUserIn$ = ZUserIn$
      CALL AllCaps (TempUserIn$)
      '* "ABORT"
      LineNum = 386
      GOSUB 22090
      IF TempUserIn$ = Strng$ THEN
         ZAbort = ZTrue
         TempUserIn$ = ""
         EXIT SUB
      END IF
      IF LEN(ZUserIn$) > DescLen OR LEN(ZUserIn$) < 7 THEN
         '* "{CEDescription must be {CC7 {CEchars minimum,{CC"
         LineNum = 387
         GOSUB 22090
         Strng1$ = Strng$
         '* "{CE chars maximum{RC"
         LineNum = 388
         GOSUB 22090
         Strng2$ = Strng$
         CALL QuickTPut1 (Strng1$ + STR$(DescLen) + Strng2$)
         GOTO 22011
      END IF
22012 ZDesc$ = ZUserIn$
      LowerCase = ZFalse
      FOR icount = 1 TO LEN(ZDesc$)
         IF ASC(MID$(ZDesc$,icount,1)) > 90 THEN
            LowerCase = ZTrue
            EXIT FOR
         END IF
      NEXT icount
      IF NOT LowerCase THEN
         CALL NameCaps (ZDesc$)
      END IF
      IF NOT ZLimitSearchToFMS THEN
         IF ZFMSDirectory$ <> ZUpldDir$ THEN
            IF LEFT$(ZUserIn$,1) = "/" OR LEFT$(ZUserIn$,1) = "\" THEN
               GOTO 22019
            ELSE
               GOTO 22016
            END IF
         END IF
      END IF
22015 IF LEFT$(ZUserIn$,1) = "/" OR LEFT$(ZUserIn$,1) = "\" THEN
         ZUCat$ = STRING$(3,42)                              '*
         GOTO 22019
      END IF
22016 ZUCat$ = ZDefaultCatCode$
      IF ZSubParm = -1 OR ZUserSecLevel < ZSLCategorizeUplds THEN
         GOTO 22019
      END IF
      IF ZMplPersUpload = ZTrue THEN
         GOTO 22019
      END IF
22017 TempIndex = ZLastIndex
      IF NOT ZExpertUser THEN
         CALL GraphicDisplayFile (ZUpcatHelp$)
      END IF
      ZLastIndex = TempIndex
22018 '* "{C2Select Upload Category{RC D)efault, L)ist"
      CALL FormatString (389,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
      ZSubParm = 1
      CALL TGet
      CALL SkipLine (1)
      CALL AraAllCaps (ZUserInAra$(),1)
      IF ZSubParm = -1 THEN
         EXIT SUB
      END IF
      IF ZWasQ = 0 THEN
         GOTO 22018
      END IF
      IF ZUserInAra$(1) = "L" OR _
         ZUserInAra$(1) = "*" OR _
         ZUserInAra$(1) = "?" THEN
         TempIndex = ZLastIndex
         CALL GraphicDisplayFile (ZUpcatHelp$)
         ZLastIndex = TempIndex
         GOTO 22018
      END IF
      IF ZUserInAra$(1) = "D" THEN
         ZUserInAra$(1) = ZDefaultCatCode$
      END IF
      CALL SearchArray (ZUserInAra$(1),ZCategoryName$(),ZNumCategories,Found)
      IF Found > 0 THEN
         ZUCat$ = ZCategoryCode$(Found)
         IF LEN(ZUCat$) > 0 AND _
            LEN(ZUCat$) < 4 AND _
            INSTR(ZUCat$,",") = 0 THEN
            GOTO 22019
         END IF
      END IF
      ZUCat$ = ""
      IF NOT ZLimitSearchToFMS THEN
         StrewTo$ = ZDirPath$ + _
                     ZUserInAra$(1) + _
                     "." + _
                     ZDirExtension$
         CALL FindIt (StrewTo$)
         IF ZOK THEN
            GOTO 22019
         END IF
      END IF
      StrewTo$ = ""
      '* "{CBNo such category {CE{Z1!{RC"
      CALL FormatString (390,ZFalse,ZFalse,0,ZTrue,2,"")
      GOTO 22017
22019 IF ZUpBatchTransfer THEN
         CALL BatchUpLoad (ZDesc$,ZUCat$,1)
         GOTO 22020
      END IF
      IF ZMplPersUpload = ZTrue THEN
         ZMplPersUpload = ZFalse
      END IF
      IF ZUserSecLevel >= ZAskExtendedDesc AND _
         ZMaxExtendedLines > 0 AND ZSubParm <> -1 THEN
         '* "{C2Add an extended description of {CB{FH{C2?{RC (Y,[N])"
         CALL FormatString (391,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
         ZTurboKey = -ZTurboKeyUser
         ZSubParm = 1
         CALL TGet
         IF ZSubParm <> -1 THEN
            IF  ZYes THEN
               '* "{CR{RI{CE{G1 Extended Description must be entered AFTER the upload is Complete! {RC"
               CALL FormatString (392,ZFalse,ZFalse,0,Ztrue,2,"")
               CALL DelayTime (2)
               ZGetExtDesc = ZTrue
            END IF
         END IF
      END IF
22020 CALL OpenOutW (ZNodeWorkDrvPath$ + "UDSC" +ZNodeID$ +".LST")
      Print #2, ZFileName$
      Print #2, ZFileNameHold$
      Print #2, ZDesc$
      Print #2, ZUCat$
      Print #2, ZActiveFMSDir$
      Print #2, ZFMSDirectory$
      Print #2, ZAbort
      Print #2, ZGetExtDesc
      Print #2, StrewTo$
      Print #2, ZAllwaysStrewTo$
      Print #2, ZUpldDir$
      Close 2
      EXIT SUB
' *** routine AFTER the Upload is successfull and Extended = True ***
22022 GOSUB 22060
      GOTO 22032
' *** ENTRY POINT WHEN UPLOAD is Finished ***
22024 IF ZPrivateDoor THEN
          CALL OpenWork (2,ZNodeWorkDrvPath$ + "UDSC" +ZNodeID$ +".LST")
          While Not EOF(2)
             Input #2, ZFileName$
             Input #2, ZFileNameHold$
             Input #2, ZDesc$
             Input #2, ZUCat$
             Input #2, ZActiveFMSDir$
             Input #2, ZFMSDirectory$
             Input #2, ZAbort
             Input #2, ZGetExtDesc
             Input #2, StrewTo$
             Input #2, ZAllwaysStrewTo$
             InPut #2, ZUpldDir$
          WEND
       END IF
       CALL KillWork (ZNodeWorkDrvPath$ + "UDSC" +ZNodeID$ +".LST")
       IF ZErrCode > 0 THEN
          ZErrCode = 0
       END IF
       GOSUB 22038        'find uploaded file
       IF NOT ZAlreadyGiven THEN
          CALL TimeRemain (MinsRemaining)
          IF ZPrivateDoor THEN
             WasX! = ZUpldTimeFactor! * ZWasQQ!
          ELSE
             WasX! = ZUpldTimeFactor! * (ZSecsUsedSession! - ZWasQQ!)
          END IF
       END IF
       IF ZAbort = ZTrue THEN       'Corrects aborted uploads
          EXIT SUB                  'corrects aborted uploads
       END IF
       CALL BreakFileName (ZFileName$, WDR$, WZZ$, WX$, ZTrue)
       Ext$ = WX$
       CALL BreakFileName (ZFileName$,Pre$,Body$,Ext$,ZFalse)
       WasX$ = ZDiskForDos$ + "T" + Ext$ + ZDefaultBatchExt$
       CALL Graphic (WasX$)
       CALL FindIt (WasX$)
       IF ZOK THEN
          IF ZUserSecLevel >= ZAddDirSecurity AND ZAutoLogOffReq = ZFalse THEN
             '* "{C2Test {CB{FI{C2?{RC"
             CALL FormatString (393,ZFalse,ZFalse,0,ZTrue,0,"")
             ZSubParm = 1
             ZOutTxt$ = ZYesPrompt$
             ZTurboKey = -ZTurboKeyUser
             CALL TGet
             IF ZSubParm = -1 THEN
                EXIT SUB
             END IF
             IF ZNO THEN
                GOTO 22027
             END IF
          END IF
          '* "{CBTesting {CE{FH{RC"
          CALL FormatString (394,ZFalse,ZFalse,0,ZTrue,1,"")
          CALL ReadDir (2,1)
          ZGSRAra$(2) = ZNodeWorkDrvPath$ + "VCHK" + ZNodeFileID$
          IF EOF(2) THEN
             WasX$ = ZOutTxt$
             ZGSRAra$(1) = ZFileName$
          ELSE
             WasX$ = WasX$ + SPACE$(1) + ZFileName$ + SPACE$(1) + ZGSRAra$(2)
          END IF
          CALL DelayTime (2)
          CALL ShellExit (WasX$)
          CALL Line25
          CALL FindIt (ZGSRAra$(2))
          IF ZOK THEN
             IF LOF(2) > 2 THEN
                ZBytesInFile# = 0.0
                '* "Deleting BAD upload {FH"
                CALL FormatString (395,ZFalse,ZTrue,2,ZTrue,1,WasX$)
                CALL KillWork (ZGSRAra$(2))
                CALL KillWork (ZFileName$)
                ZGetExtDesc = ZFalse
                EXIT SUB
             END IF
          END IF
          GOTO 22027
       END IF

       WasX$ = ZDiskForDos$ + "TESTUP" + ZDefaultBatchExt$
       CALL Graphic (WasX$)
       CALL FindIt (WasX$)
       IF ZOK THEN
          IF (ZSysop OR ZUserSecLevel >= ZAddDirSecurity) AND ZAutoLogOffReq = ZFalse THEN
             '* "{C2Test {CB{FH{C2?{RC"
             CALL FormatString (393,ZFalse,ZFalse,0,ZTrue,0,"")
             ZSubParm = 1
             ZOutTxt$ = ZYesPrompt$
             ZTurboKey = -ZTurboKeyUser
             CALL TGet
             IF ZSubParm = -1 THEN
                EXIT SUB
             END IF
             IF ZNO THEN
                GOTO 22027
             END IF
          END IF
          '* "{CBTesting {CE{FH{RC"
          CALL FormatString (394,ZFalse,ZFalse,0,ZTrue,1,"")
          ZGSRAra$(2) = ZNodeWorkDrvPath$ + "VCHK" + ZNodeFileID$
          WasX$ = WasX$ + SPACE$(1) + ZFileName$ + " " + Pre$ + _
                  SPACE$(1) + Body$ + SPACE$(1) + Ext$ + SPACE$(1) + _
                  ZNodeID$ + SPACE$(1) + ZGSRAra$(2) + SPACE$(1) + _
                  ZComPort$ + SPACE$(1) + ZDefaultExtension$
          CALL DelayTime (2)
          CALL ShellExit (WasX$)
          CALL Line25
          CALL FindIt (ZGSRAra$(2))
          IF ZOK THEN
             IF LOF(2) > 2 THEN
                ZBytesInFile# = 0.0
                '* "Deleting BAD upload {FH"
                CALL FormatString (395,ZFalse,ZTrue,2,ZTrue,1,WasX$)
                CALL KillWork (ZGSRAra$(2))
                CALL KillWork (ZFileName$)
                ZGetExtDesc = ZFalse
                EXIT SUB
             END IF
          END IF
          GOTO 22027
       END IF
       WasX$ = ZDiskForDos$ + "C" + Ext$ + ZDefaultExtension$ + ZDefaultBatchExt$
       CALL Graphic (WasX$)
       CALL FindIt (WasX$)
       IF NOT ZOK THEN
          GOTO 22027
       END IF
       TooZip$ = ZDirPath$+"X2ZIP" + ZNodeID$ + ".LST"
       CALL FindIt (TooZip$)
       IF NOT ZOK THEN
          GOTO 22026
       END IF
       CALL OpenWork (2,TooZip$)
       WHILE NOT EOF(2)
          INPUT #2, Check$
          IF UCASE$(Check$) = "YES" THEN
             AskToConvert = Ztrue
             CLOSE 2
             GOTO 22025
          END IF
          IF WX$ = Check$ THEN
             CLOSE 2
             GOTO 22027
          END IF
       WEND
       CLOSE 2
22025 IF ZAutoEnd = 1 THEN
         IF WX$ = Check$ THEN GOTO 22027 ELSE GOTO 22026
      END IF
      IF (ZSysop OR (ZUserSecLevel > = ZAddDirSecurity AND _
      AskToConvert = ZTrue)) AND ZAutoLogOffReq = ZFalse THEN
         '* "{C2Convert or verify {CB{FH{C2?{RC"
         CALL FormatString (396,ZFalse,ZFalse,0,ZTrue,0,"")
         AskToConvert = ZFalse
         ZSubParm = 1
         ZOutTxt$ = ZYesPrompt$
         ZTurboKey = -ZTurboKeyUser
         CALL TGet
         IF ZSubParm = -1 THEN _
            EXIT SUB
         IF ZNO THEN _
            GOTO 22027
      END IF
22026 '* "{CR{CBConverting upload to {CE{DE.  Please wait!{RC"
      LineNum = 397
      IF Ext$ = ZDefaultExtension$ THEN
         '* "{CR{CBRe-Converting upload to {CE{DE.  Please wait!{RC"
         LineNum = 398
      END IF
      CALL FormatString (LineNum,ZFalse,ZFalse,0,Ztrue,1,"")
      CALL OpenWork (2,WasX$)
      CALL ReadDir (2,1)
      IF EOF(2) THEN
         WasX$ = ZOutTxt$
      END IF
      ZGSRAra$(1) = ZFileName$
      CALL BreakFileName (ZFileName$,Pre$,Body$,Ext$,ZTrue)
      ZFileNameHold$ = Body$ + "." + ZDefaultExtension$
      ZUserInAra$(0) = ZFileName$
      ZFileName$ = Pre$ + ZFileNameHold$
      CALL DelayTime (2)
      CALL ShellExit (WasX$ + SPACE$(1) + Body$ + SPACE$(1) + ZNodeID$ + _
           SPACE$(1) + Pre$)
      CALL Line25
      CALL FindIt (ZFileName$)
      IF NOT ZOK THEN
         '* "{FI < ABORTED in Cnvt >"
         CALL FormatString (399,ZFalse,ZTrue,2,ZFalse,0,"")
         ZGetExtDesc = ZFalse
         ZFileName$ = ZGSRAra$(1)
         CALL FindIt (ZFileName$)
         ZFileNameHold$ = Body$ + Ext$
         IF ZOK THEN
            ZFileName$ = ZFileNameHold$
         END IF
      END IF
22027 GOSUB 22038
      CALL CheckNovell (ZOK)
      IF ZOK <> -1 THEN
         CALL SetSharedAttr (ZFileName$, ZOK)
         IF ZOK <> 0 THEN
            '* "Error setting shared attribute"
            CALL FormatString (400,ZTrue,ZFalse,0,ZFalse,0,"")
         END IF
      END IF
      IF ZGetExtDesc THEN
         EXIT SUB
      END IF
      GOSUB 22060
22032 IF ZLogUploader = 0 THEN
         IF LEFT$(ZUserIn$,1) = "/" OR LEFT$(ZUserIn$,1) = "\" OR _
            NumPersonals > 0 THEN _
            WX$ = WX$ + "*"
            CALL AMorPM
         IF ZActiveUserName$ = ZSysopPswd1$ + SPACE$(1) + ZSysopPswd2$ THEN
            '* "Sysop"
            LineNum = 1030
            GOSUB 22090
            ULBYNAME$ = Strng$
         ELSE
            ULBYNAME$ = ZActiveUserName$
         END IF
         ULXXX$ = WZZ$+WX$+SPACE$(13-(LEN(WZZ$)+LEN(WX$)))
         UPLOADLG$ = "{C2" + ULXXX$ + _
                     "{CE" + ULBYNAME$+SPACE$(34-LEN(ULBYNAME$)) + _
                     "{C5" + DATE$ + SPACE$(3) + _
                     "{CB" + ZTime$ + " {RC"
         CALL OpenWorkA (2,ZDirPath$  + "UPLOADLG.DEF")
         CALL PrintWorkA (2,UPLOADLG$)
         CLOSE 2
      END IF
      IF ZFMSDirectory$ <> ZUpldDir$ THEN _
         IF LEFT$(ZUserIn$,1) = "/" OR LEFT$(ZUserIn$,1) = "\" THEN _
            CALL UpdtCalr (ZUserIn$,2) : _
            GOTO 22033
      IF NumPersonals <> 0 THEN _
         GOTO 22033
      IF ZPrivateDoor THEN _
         ZWasEN$ = ZUpldDoor$ _
      ELSE ZWasEN$ = ZUpldDir$
      GOSUB 22034
22033 '* "{SP>> uploaded <<{SP"
      LineNum = 401
      GOSUB 22090
      ZWasDFF$ = Strng$
      CALL BreakFileName (ZFileName$,DR$,WasX$,Extension$,ZTrue)
      '* "{SPat{SP"
      LineNum = 1016
      GOSUB 22090
      Strng1$ = Strng$
      '* "{SPusing{SP"
      LineNum = 1035
      GOSUB 22090
      Strng2$ = Strng$
      ZWasZ$ = WasX$ + _
           Extension$ + _
           ZWasDFF$ + _
           Strng1$ + _
           ZTime$ + _
           Strng2$ + _
           ZWasFT$ + _
           STR$(ZBytesInFile#)
      CALL UpdtCalr (ZWasZ$,2)
      ZUplds = ZUplds + 1
      ZGlobalUplds = ZGlobalUplds + 1
      ZULBytesVal! = ZULBytesVal! + ZBytesInFile#
      ZGlobalULBytes! = ZGlobalULBytes! + ZBytesInFile#
      IF NOT ZAlreadyGiven THEN
         CALL TimeRemain (MinsRemaining)
         MinsToAdd = WasX! / 60
         CALL ChkAddedTime (MinsToAdd)
         WasX! = MinsToAdd * 60!
         ZTimeCredits! = ZTimeCredits! + WasX!
         ZSecsPerSession! = ZSecsPerSession! + WasX!
         IF ZPrivateDoor THEN _
            WasX! = (WasX! - ZWasQQ!) / 60.0 _
         ELSE WasX! = (WasX! - ZSecsUsedSession! + ZWasQQ!)/60.0
         WasX$ = STR$(FIX(WasX!*10.0))
         WasX$ = LEFT$(WasX$,LEN(WasX$)-1) + "." + RIGHT$(WasX$,1)
         IF WasX! > 1.0 THEN
            '* "Session time increased by"
            LineNum = 402
            GOSUB 22090
            Strng1$ = Strng$
            '* "{SPminutes"
            LineNum = 403
            GOSUB 22090
            Strng2$ = Strng$
            CALL QuickTPut1 (Strng1$ + WasX$ + Strng2$)
         END IF
      END IF
      '* "{CRUpload successful, Thanks for the upload {FN!"
      CALL FormatString (404,ZFalse,ZFalse,0,ZTrue,1,"")
      ZMenuNewUpld = ZMenuNewUpld + 1
      CALL DelayTime (2)
      ZGetExtDesc = ZFalse
      CLOSE 2
      EXIT SUB
22034 '          ---[ lock file ]---
      IF ZWasEN$ = "" THEN _
         RETURN
      IF NOT ZPrivateDoor THEN
'
' * FILE_ID.DIZ file processing
'
         '* "FILE_ID.DIZ"
         LineNum = 66
         GOSUB 22090
         tempfile$ = ZNodeWorkDrvPath$ + Strng$
         CALL FindItX (tempfile$,7)
         IF ZOK THEN
            ZGetExtDesc = ZTrue
            IF ZReFormatDiz AND LEFT$(ZDesc$,1) <> "/" AND LEFT$(ZDesc$,1) <> "\" THEN
               LINE INPUT #7, ZDesc$
               CALL RemNonAlf (ZDesc$,31,127)
            ELSE
               '* "Discription within Archived File:"
                LineNum = 1167
                GOSUB 22090
                ZDesc$ = Strng$
            END IF
            ZDesc$ = LEFT$(ZDesc$,ZMaxDescLen + (5 * ZShowTimesDownloaded))
            WasLL = ZRightMargin
            ZRightMargin = 30 + ZMaxDescLen + _
                           (5 * ZShowTimesDownloaded)
            IF ZRightMargin > 74 THEN _
               ZRightMargin = 74
            LinesInDesc = 0
            WHILE NOT EOF(7) AND LinesInDesc < ZMaxExtendedLines
               LinesInDesc = LinesInDesc + 1
               LINE INPUT #7,ZOutTxtAra$(LinesInDesc)
               IF ZReFormatDiz THEN
                  CALL RemNonAlf (ZOutTxtAra$(LinesInDesc),31,127)
                  CALL Trim (ZOutTxtAra$(LinesInDesc))
                  IF LEN(ZOutTxtAra$(LinesInDesc - 1)) < (ZRightMargin - 10) AND LinesInDesc > 1 THEN
                     ZOutTxtAra$(LinesInDesc - 1) = ZOutTxtAra$(LinesInDesc - 1) + SPACE$(1) + ZOutTxtAra$(LinesInDesc)
                     ZOutTxtAra$(LinesInDesc) = ""
                     ZOutTxtAra$(LinesInDesc + 1) = ""
                     LinesInDesc = LinesInDesc - 1
                  END IF
               ELSE
                  ZOutTxtAra$(LinesInDesc) = LEFT$(ZOutTxtAra$(LinesInDesc),ZRightMargin)
               END IF
            WEND
            CLOSE 7
            IF ZReFormatDiz THEN
               CALL WordWrap (ZRightMargin,LinesInDesc,ZOutTxtAra$())
            END IF
            '* "{RI{CO Using FILE_ID.DIZ for Upload Description {RC"
            CALL FormatString (405,ZFalse,ZFalse,0,ZTrue,1,"")
            CALL KillWork (tempfile$)
            ZRightMargin = WasLL
         END IF
'
' * .GIF file processing
'
         CALL BreakFileName (ZFileName$,Pre$,Body$,Ext$,ZFalse)
         IF (ZBBSOptions AND 2048) = 0 AND Ext$ = "GIF" THEN
            GIFHeader$ = STRING$(3,42)
            numstr$ = "*"
            IF ZShareIt THEN
               OPEN ZFileName$ FOR BINARY ACCESS READ SHARED AS #7
            ELSE
               OPEN ZFileName$ FOR BINARY AS #7
            END IF
            SEEK #7, 1
            GIFHeader$ = INPUT$(6, #7)
            numstr$ = INPUT$(1,#7)
            i1 = ASC(numstr$)
            numstr$ = INPUT$(1,#7)
            i2 = ASC(numstr$)
            i2 = i2 * 256
            GIFWidth = i2 OR i1
            numstr$ = INPUT$(1,#7)
            i1 = ASC(numstr$)
            numstr$ = INPUT$(1,#7)
            i2 = ASC(numstr$)
            i2 = i2 * 256
            GIFHeight = i2 OR i1
            numstr$ = INPUT$(1,#7)
            byte1 = ASC(numstr$)
            CLOSE 7
            BitsPerPixel = byte1 AND 7
            BitsPerPixel = BitsPerPixel + 1
            GIFColors = 1
            GIFColors = GIFColors * 2^BitsPerPixel
            GIFWidth$ = STR$(GIFWidth)
            CALL Trim(GIFWidth$)
            GIFHeight$ = STR$(GIFHeight)
            CALL Trim(GIFHeight$)
            GIFColors$ = STR$(GIFColors)
            CALL Trim(GIFColors$)
            IF (GIFHeader$ = "GIF87a" OR GIFHeader$ = "GIF89a") AND NOT GIFDimenSet THEN
               ZDesc$ = "(" + GIFWidth$ + "x" + GIFHeight$ + _
                        "x" + GIFColors$ + ")" + SPACE$(1) + ZDesc$
               GIFDimenSet = ZTrue
            END IF
         END IF
      END IF
      FMSFormat = ZFalse
      CALL BreakFileName (ZWasEN$,DriveEN$,BodyEN$,ExtEN$,ZTrue)
      CALL BreakFileName (ZFMSDirectory$,DriveFMS$,BodyFMS$,ExtFMS$,ZTrue)
      IF (BodyEN$+ExtEN$ = BodyFMS$+ExtFMS$ OR ZLimitSearchToFMS _
         OR NumPersonals > 0 OR (ZPrivateDoor AND ZFMSDoor)) THEN _
         FMSFormat = ZTrue _
      ELSE CALL FindIt (ZWasEN$) : _
         IF ZOK THEN _
            CALL ReadDir (2,1) : _
            IF ZErrCode = 0 THEN _
               FMSFormat = (LEFT$(ZOutTxt$,4) = "\FMS")
      IF NOT FMSFormat THEN _
         ReadBackwards = ZFalse : _
         FixedLen = 0 : _
         ZUserIn$ = ZDesc$ : _
         GOTO 22035
      FixedLen = 34 + ZMaxDescLen + (5 * ZShowTimesDownloaded)
      IF NumPersonals > 0 THEN _
         WasX$ = "*" : _
         TempLen = ZMaxDescLen + (5 * ZShowTimesDownloaded) : _
         MaxLen = ZPersonalLen _
      ELSE MaxLen = 3 : _
         TempLen = ZMaxDescLen : _
         WasX$ = ""
      ZUCat$ = LEFT$(ZUCat$,MaxLen)
      ZUCat$ = ZUCat$ + SPACE$(MaxLen - LEN(ZUCat$))
      ZUserIn$ = ZDesc$ + _
                 SPACE$(TempLen - LEN(ZDesc$)) + _
                 ZUCat$ + WasX$
      IF ZShowTimesDownloaded AND NumPersonals = 0 THEN
         ZUserIn$ = ZDesc$ + _
                    SPACE$((ZMaxDescLen-5) - LEN(ZDesc$)) + _
                    "00000" + _
                    ZUCat$ + WasX$
      END IF
      ReadBackwards = ZTrue : _
      CALL FindIt (ZWasEN$) : _
      IF ZOK THEN _
         CALL ReadDir (2,1) : _
         IF ZErrCode = 0 THEN _
            ReadBackwards = (INSTR(ZOutTxt$," TOP ") = 0)
22035 CALL LockAppend
      IF ZErrCode <> 0 THEN _
         GOTO  22036
      IF ZAddNameToDir <> 0 THEN
         IF ReadBackwards and NumPersonals = 0 THEN
            IF ZShowTimesDownloaded THEN
               tempstr$ = SPACE$(4) + "." + SPACE$(2) + "."
            ELSE
               tempstr$ = SPACE$(2) + "."
            END IF
            '* "{SP Uploaded by {AN"
            CALL FormatString (1036,ZFalse,ZFalse,0,ZFalse,0,Strng$)
            PRINT #2, USING LEFT$("\" + _
                    SPACE$(79 - (5 * ZShowTimesDownloaded)), _
                    ZMaxDescLen + 32 + (5 * ZShowTimesDownloaded)) + _
                    "\" + tempstr$;Strng$
     '          ---[ append ]---
         END IF
         IF ZGetExtDesc THEN _
            IF ReadBackwards THEN _
               FOR WasI = LinesInDesc TO 1 STEP -1 : _
                  GOSUB 22037 : _
               NEXT
         PRINT #2,USING "\" + SPACE$(11) + "\" + _
                        STRING$(8,35) + SPACE$(2) + "&" + _
                        SPACE$(2) + "&"; _
                        ZFileNameHold$; _
                        ZBytesInFile#; _
                        ZWasZ$; _
                        ZUserIn$
         IF ZGetExtDesc THEN _
            IF NOT ReadBackwards THEN _
               FOR WasI = 1 TO LinesInDesc : _
                  GOSUB 22037 : _
               NEXT
         IF NOT ReadBackwards and NumPersonals = 0 THEN
            '* "{SP Uploaded by {AN"
            CALL FormatString (1036,ZFalse,ZFalse,0,ZFalse,0,Strng$)
            PRINT #2, using LEFT$("\" + SPACE$(79), _
                      ZMaxDescLen + 32) + "\" + SPACE$(2) + "."; _
                      Strng$
         END IF
         GOTO 22036
      END IF
      IF ZGetExtDesc THEN _
         IF ReadBackwards THEN _
            FOR WasI = LinesInDesc TO 1 STEP -1 : _
               GOSUB 22037 : _
            NEXT
      PRINT #2,USING "\" + SPACE$(11) + "\" + STRING$(8,35) + _
                     SPACE$(2) + "&" + SPACE$(2) + "&"; _
                     ZFileNameHold$; _
                     ZBytesInFile#; _
                     ZWasZ$; _
                     ZUserIn$
      IF ZGetExtDesc THEN _
         IF NOT ReadBackwards THEN _
            FOR WasI = 1 TO LinesInDesc : _
               GOSUB 22037 : _
            NEXT
22036 CALL UnLockAppend
      FixedLen = 0
      RETURN
22037 WasX$ = ZOutTxtAra$(WasI)
      CALL Trim (WasX$)
      IF WasX$ = "" THEN _
         RETURN
      IF NOT FMSFormat THEN _
         PRINT #2,SPACE$(2);ZOutTxtAra$(WasI) : _
         RETURN
      IF FixedLen > LEN(ZOutTxtAra$(WasI)) THEN
         IF ZShowTimesDownloaded AND NumPersonals = 0 THEN
            WasX$ = SPACE$(FixedLen - 1 - LEN(ZOutTxtAra$(WasI))) + _
                    SPACE$(2) + "." + SPACE$(2) + "."
         ELSE
            WasX$ = SPACE$(FixedLen - 1 - LEN(ZOutTxtAra$(WasI))) + "."
         END IF
      ELSE
         WasX$ = ""
      END IF
      IF NumPersonals = 0 THEN _
         PRINT #2, SPACE$(2);LEFT$(ZOutTxtAra$(WasI),FixedLen);WasX$ _
      ELSE _
         PRINT #2, SPACE$(2);LEFT$(ZOutTxtAra$(WasI),FixedLen);SPACE$(ZPersonalLen-2);WasX$
      RETURN
22038 CALL FindIt (ZFileName$)
      IF NOT ZOK THEN
         CALL BreakFileName (ZFileName$,TDrive$,TBody$,TExt$,ZTrue)
         SearchFile$ = TDrive$ + TBody$ + "." + ZDefaultExtension$
         CALL FindIt (SearchFile$)
         IF ZOK THEN
            ZFileName$ = SearchFile$
            ZFileNameHold$ = TBody$ + "." + ZDefaultExtension$
         END IF
      END IF
      IF NOT ZOK THEN _
         ZBytesInFile# = 0.0_
      ELSE ZBytesInFile# = LOF(2)
      IF ZBytesInFile# < 2.0 THEN _
         ZAutoLogOffReq = ZFalse : _
         EXIT SUB
      RETURN
22060 CALL FindItX (ZNodeWorkFile$,17)
      ZUserIn$ = ZDesc$
      WasX$ = DATE$
      ZWasZ$ = LEFT$(WasX$,6) + _
           RIGHT$(WasX$,2)
      ZWasEN$ = ZPersonalDir$
      NumPersonals = 0
      IF NOT ZOK THEN _
         GOTO 22081
      UserFileIndexSave = ZUserFileIndex
      UserRecordHold$ = ZUserRecord$
      '* "ALL"
      CALL FormatString (450,ZFalse,ZFalse,0,ZFalse,0,ALLStr$)
      WHILE NOT EOF(17)
         CALL ReadParmsX (17,ZWorkAra$(),2,1)
         IF LEFT$(ZWorkAra$(1),4) <> ALLStr$ + SPACE$(1) AND _
         ZWorkAra$(1) <> ALLStr$ THEN
            NumPersonals = NumPersonals + 1
            ZUCat$ = ZWorkAra$(1)
            GOSUB 22034
            RcvrRecNum = VAL (ZWorkAra$(2))
            '* "file"
            CALL FormatString (1025,ZFalse,ZFalse,0,ZFalse,0,Strng$)
            CALL SetUserFlag (RcvrRecNum,4096,Strng$)
         END IF
         IF LEFT$(ZWorkAra$(1),4) <> ALLStr$ + SPACE$(1) AND _
         ZWorkAra$(1) <> ALLStr$ THEN
            CALL CheckInt(ZWorkAra$(1))
            IF ZTestedIntValue > 0 THEN
               NumPersonals = Numpersonals + 1
               ZUCat$ = SPACE$(1) + ZWorkAra$(1)
               GOSUB 22034
            END IF
         END IF
      WEND
      CLOSE 17
      IF NumPersonals > 0 THEN _
         ZUserFileIndex = UserFileIndexSave : _
         LSET ZUserRecord$ = UserRecordHold$
22081 ZUserIn$ = ZDesc$
      WasX$ = DATE$
      ZWasZ$ = LEFT$(WasX$,6) + _
               RIGHT$(WasX$,2)
      ZWasEN$ = StrewTo$
      GOSUB 22034
      IF NumPersonals = 0 THEN
         ZWasEN$ = ZAllwaysStrewTo$
         GOSUB 22034
      ELSE
         ZWasEN$ = ""
      END IF
      RETURN
22090 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
      RETURN
      END SUB
