' $segment
' $linesize:132
' $title: 'FOSSIL.BAS, Copyright (c) 1995 by Daniel T. Drinnon'
'  RBBS-PC Copyright 1992 by D. Thomas Mack, all rights reserved.
'  Name ...............: FOSSIL.BAS
'  First Released .....: August 1, 1995
'  Copyright ..........: 1995,1996,1997
'  Purpose.............: FOSSIL Function calls for RBBS-PC CDOR
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
   DEFINT A-Z

   COMMON SHARED /Fossil/ X00Init

   TYPE RegTypeX
      ax      AS INTEGER
      bx      AS INTEGER
      cx      AS INTEGER
      dx      AS INTEGER
      bp      AS INTEGER
      si      AS INTEGER
      di      AS INTEGER
      flags   AS INTEGER
      ds      AS INTEGER
      es      AS INTEGER
   END TYPE
'
' =============================================================================
' * FOSInit - Initialze the Port
' =============================================================================
    SUB FOSinit(ComPortNum,Result)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    Result = 0
    InRegs.AX = &H1C00
    InRegs.DX = ComPortNum
    CALL InterruptX(&H14,InRegs,OutRegs)
    IF OutRegs.AX <> &H1954 THEN
       InRegs.AX = &H0400
       CALL InterruptX(&H14,InRegs,OutRegs)
       IF OutRegs.AX <> &H1954 THEN
          Result = -1
       END IF
    END IF
    X00Init = InRegs.AX
    END SUB
'
' =============================================================================
' * FOSExit - Deinitialze the Port
' =============================================================================

    SUB FOSExit(ComPortNum)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    InRegs.AX = X00Init + &H0100
    InRegs.DX = ComPortNum
    CALL InterruptX(&H14,InRegs,OutRegs)
    END SUB

' =============================================================================
' * FOSRxChar - Get Character from the Port
' =============================================================================

    SUB FOSRXChar(ComPortNum,Char)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    InRegs.AX = &H0200
    InRegs.DX = ComPortNum
    CALL InterruptX(&H14,InRegs,OutRegs)
    Char = (OutRegs.AX - INT(OutRegs.AX / 256) * 256)
    END SUB

' =============================================================================
' * FOSRead - Gets All Characters from the Port (CALLed in CONFIG only)
' =============================================================================
   SUB FOSRead(ComPortNum,FOSLen,FOSBuf$)
   FOSBuf$ = ""
   TimeNow! = TIMER
   PrevTi! = TimeNow!
   DO
      CALL FosReadAhead(ComPortNum,Char)
      IF Char <> -1 THEN
         CALL FOSRXChar(ComPortNum,Char)
         FOSBuf$ = FOSBuf$ + CHR$(Char)
         IF LEN(FOSBuf$) > FOSLen THEN
            EXIT DO
         END IF
      END IF
      TimeNow! = TIMER
   LOOP UNTIL TimeNow! - PrevTi! > 30.0 OR Char = -1
   END SUB

' =============================================================================
' * FOSReadAhead - Peek Character from the Port
' =============================================================================

    SUB FosReadAhead(ComPortNum,Char)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    InRegs.AX = &H0C00
    InRegs.DX = ComPortNum
    CALL InterruptX(&H14,InRegs,OutRegs)
    IF OutRegs.AX = &HFFFF THEN
       Char = -1
    ELSE
       Char = (OutRegs.AX - INT(OutRegs.AX / 256) * 256)
    END IF
    END SUB

' =============================================================================
' * FOSTXPurge - Purges the Transmit Buffer
' =============================================================================

    SUB FOSTXPurge(ComPortNum)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    InRegs.AX = &H0900
    InRegs.DX = ComPortNum
    CALL InterruptX(&H14,InRegs,OutRegs)
    END SUB

' =============================================================================
' * FOSRXPurge - Purges the Receive Buffer
' =============================================================================

    SUB FOSRXPurge(ComPortNum)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    InRegs.AX = &H0A00
    InRegs.DX = ComPortNum
    CALL InterruptX(&H14,InRegs,OutRegs)
    END SUB

' =============================================================================
' * FOSTXCharNW - Transmit to Buffer with no wait
' =============================================================================

    SUB FosTXCharNW(ComPortNum,Char,Result)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    InRegs.AX = &H0B00 + Char
    InRegs.DX = ComPortNum
    CALL InterruptX(&H14,InRegs,OutRegs)
    Result = OutRegs.AX
    END SUB

' =============================================================================
' * FOSWrite - Transmit to Buffer
' =============================================================================

    SUB FosWrite(ComPortNum,Bytes,Strng$)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    FOR X = 1 TO Bytes
       InRegs.AX = &H0B00 + ASC(MID$(Strng$,X,1))
       InRegs.DX = ComPortNum
       DO
          CALL InterruptX(&H14,InRegs,OutRegs)
       LOOP WHILE OutRegs.AX = 0
    NEXT
    END SUB

' =============================================================================
' * FOSDTR - Raise or Lower DTR
' =============================================================================

    SUB FosDTR(ComPortNum,State)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    InRegs.AX = &H0600 + State
    InRegs.DX = ComPortNum
    CALL InterruptX(&H14,InRegs,OutRegs)
    END SUB

' =============================================================================
' * FOSFlowCtl - Sets Flow Control
' =============================================================================
    SUB FosFlowCtl(ComPortNum,Flow)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    InRegs.AX = &H0F00 + Flow
    InRegs.DX = ComPortNum
    CALL InterruptX(&H14,InRegs,OutRegs)
    END SUB

' =============================================================================
' * FOSSpeed - Sets Port Speed, etc.
' =============================================================================
    SUB FosSpeed(ComPortNum,ComSpeed!,Parity,DataBits,StopBits)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    SELECT CASE X00Init
       CASE &H0400
          InRegs.AX = &H0000
          SELECT CASE ComSpeed!
             CASE 300!
                InRegs.AX = (InRegs.AX OR &H40)
             CASE 600!
                InRegs.AX = (InRegs.AX OR &H60)
             CASE 1200!
                InRegs.AX = (InRegs.AX OR &H80)
             CASE 2400!
                InRegs.AX = (InRegs.AX OR &HA0)
             CASE 4800!
                InRegs.AX = (InRegs.AX OR &HC0)
             CASE 9600!
                InRegs.AX = (InRegs.AX OR &HE0)
             CASE 19200!
                InRegs.AX = (InRegs.AX OR &H0)
             CASE 38400!
                InRegs.AX = (InRegs.AX OR &HE0)
             CASE ELSE
                InRegs.AX = (InRegs.AX OR &HE0)
          END SELECT
          SELECT CASE DataBits
             CASE 5
                InRegs.AX = (InRegs.AX OR &H0)
             CASE 6
                InRegs.AX = (InRegs.AX OR &H1)
             CASE 7
                InRegs.AX = (InRegs.AX OR &H2)
             CASE 8
                InRegs.AX = (InRegs.AX OR &H3)
             CASE ELSE
                InRegs.AX = (InRegs.AX OR &H3)
          END SELECT
          SELECT CASE StopBits
             CASE 1
                InRegs.AX = (InRegs.AX OR &H0)
             CASE 2
                InRegs.AX = (InRegs.AX OR &H4)
             CASE ELSE
                InRegs.AX = (InRegs.AX OR &H0)
          END SELECT
          SELECT CASE Parity
             CASE 1         ' NOT USED ODD
                InRegs.AX = (InRegs.AX OR &H8)
             CASE 2         ' NONE
                InRegs.AX = (InRegs.AX OR &H0)
             CASE 3         ' EVEN
                InRegs.AX = (InRegs.AX OR &H18)
             CASE ELSE
                InRegs.AX = (InRegs.AX OR &H0)
          END SELECT
       CASE &H1C00
          InRegs.AX = &H1E00
          InRegs.BX = &H0000
          InRegs.CX = &H0000
          SELECT CASE ComSpeed!
             CASE 300!
                InRegs.CX = (InRegs.CX OR &H0)
             CASE 600!
                InRegs.CX = (InRegs.CX OR &H1)
             CASE 1200!
                InRegs.CX = (InRegs.CX OR &H2)
             CASE 2400!
                InRegs.CX = (InRegs.CX OR &H3)
             CASE 4800!
                InRegs.CX = (InRegs.CX OR &H4)
             CASE 9600!
                InRegs.CX = (InRegs.CX OR &H5)
             CASE 19200!
                InRegs.CX = (InRegs.CX OR &H6)
             ' FOSSIL ONLY BAUD RATES
             CASE 28800!
                InRegs.CX = (InRegs.CX OR &H80)
             CASE 38400!
                InRegs.CX = (InRegs.CX OR &H81)
             CASE 57600!
                InRegs.CX = (InRegs.CX OR &H82)
             CASE 64000!                           '*** ISDN               ***
                InRegs.CX = (InRegs.CX OR &H81)
             CASE 76800!                           '*** Not Supported Yet! ***
                InRegs.CX = (InRegs.CX OR &H83)
             CASE 115200!
                InRegs.CX = (InRegs.CX OR &H84)
             CASE ELSE
                InRegs.CX = (InRegs.CX OR &H6)
          END SELECT
          SELECT CASE DataBits
             CASE 5
                InRegs.CX = (InRegs.CX OR &H0000)
             CASE 6
                InRegs.CX = (InRegs.CX OR &H0100)
             CASE 7
                InRegs.CX = (InRegs.CX OR &H0200)
             CASE 8
                InRegs.CX = (InRegs.CX OR &H0300)
             CASE ELSE
                InRegs.CX = (InRegs.CX OR &H0300)
          END SELECT
          SELECT CASE StopBits
             CASE 1
                InRegs.BX = (InRegs.BX OR &H0)
             CASE 2
                InRegs.BX = (InRegs.BX OR &H1)
             CASE ELSE
                InRegs.BX = (InRegs.BX OR &H1)
          END SELECT
          SELECT CASE Parity
             CASE 1         ' ODD
                InRegs.BX = (InRegs.BX OR &H1)
             CASE 2         ' NONE
                InRegs.BX = (InRegs.BX OR &H0)
             CASE 3         ' EVEN
                InRegs.BX = (InRegs.BX OR &H2)
             CASE ELSE
                InRegs.BX = (InRegs.BX OR &H0)
          END SELECT
       CASE ELSE
    END SELECT
    InRegs.DX = ComPortNum
    CALL InterruptX(&H14,InRegs,OutRegs)
    END SUB

' =============================================================================
' * FOSStatus - Returns Fossil Status
' =============================================================================
    SUB FosStatus(ComPortNum,Status)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    InRegs.AX = &H0300
    InRegs.DX = ComPortNum
    CALL InterruptX(&H14,InRegs,OutRegs)
    Status = OutRegs.AX
    END SUB

