' $segment
' $title: 'ANSIChat Split Screen Chat for RBBS-PC v17.4'
'          By Dan Drinnon 1:109/331
'              The Cellar Door RBBS (703) 631-9416
'             Scott McNay 1:395/11
'              Wizard's (254) 554-2146
'
'  Copyright (c) 1991,1992,1993,1994,1995,1996,1997 by Daniel T. Drinnon and Scott McNay
'  All Rights Reserved
'
'  DO NOT Distribute in Modified Form!
'
' $SUBTITLE: 'ANSIChat - ANSI Split Screen Chat Routine'
' $PAGE
'
' $INCLUDE: 'RBBS-VAR.BAS'
'
1000 SUB ANSIChat STATIC
'
     StartTime! = TIMER
     FOR count = 0 TO 7
        ForeGround(count) = count + 30
     NEXT
     LocalOut = 0
     RemoteOut = 1
     SideOut = LocalOut
     TimeChatStarted! = TIMER
     ANSIRow(LocalOut) = 2
     ANSIRow(RemoteOut) = 14
     ANSICol(LocalOut) = 1
     ANSICol(RemoteOut) = 1
     IF ZWasGR > 1 THEN
        ACColor$(LocalOut) = CHR$(27) + "[;1;32;40m"
        ACColor$(RemoteOut) = CHR$(27) + "[;1;33;40m"
     ELSE
        ACColor$(LocalOut) = ""
        ACColor$(RemoteOut) = ""
     END IF
     ForeRotate(LocalOut) = 2
     ForeHiLite(LocalOut) = 1
     ForeRotate(RemoteOut) = 3
     ForeHiLite(RemoteOut) = 1
     ZWasCM = ZTrue
     ZSubParm = 1
     HoldColorReset$ = ZColorReset$
     IF ZWasGR > 1 THEN
        '* "[;1;33;44m"
        LineNum = 978
        GOSUB 1010
        MenuColor1$ = CHR$(27) + Strng$
        '* "[;1;36;44m"
        LineNum = 979
        GOSUB 1010
        MenuColor2$ = CHR$(27) + Strng$
     ELSE
        MenuColor1$ = ""
        MenuColor2$ = ""
     END IF
     ZColorReset$ = MenuColor2$
     CALL ANSIMenu
     CALL ANSILocate (ANSIRow(LocalOut),ANSICol(LocalOut))
     CALL QuickTPut1 (ACColor$(LocalOut) + ZSysopGreeting$)
     CALL SplitScreenChat
     ZWasCM = 0
     CALL CheckTime(TimeChatStarted!,Elapsed!, 2)
     ZSecsPerSession! = ZSecsPerSession! + Elapsed!
     IF NOT ZLocalUser THEN _
        ZAutoLogoff! = TIMER + ZWaitBeforeDisconnect
     CALL ClearANSIScreen
     ZColorReset$ = HoldColorReset$
     ZoutTxt$ = ""
     '* "{CR{RCChat over.  BBS resuming"
     CALL FormatString (825,ZFalse,ZFalse,0,ZFalse,0,Strng$)
     CALL QuickTPut1 (Strng$ + ZColorReset$)
     IF Logging THEN
        CLOSE 2
     END IF
     EXIT SUB
1010 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
     RETURN
     END SUB
'
4000 SUB ANSIMenu STATIC
'
     LineBar$ = STRING$(80,177)
     IF ZWasGR = 4 THEN
        CALL BufFile (ZWelcomeFileDrvPath$ + "RIPWINCH.RIP",0)
     END IF
     CALL ClearANSIScreen
     CALL ANSILocate (1,1)
     CALL QuickTPut (MenuColor2$ + LineBar$,0)
     '* "BBS"
     LineNum = 980
     GOSUB 4010
     IF INSTR(ZRBBSName$,Strng$) <> 0 THEN
        '*  "*>>> {BN ANSI Chat <<<*"
        LineNum = 826
     ELSE
        '* "*>>> {BN RBBS ANSI Chat <<<*"
        LineNum = 827
     END IF
     CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,ZOutTxt$)
     temppos = (40 - (LEN(ZOutTxt$)/2))
     CALL ANSILocate (1,temppos)
     CALL QuickTPut (MenuColor1$ + ZOutTxt$,0)
     CALL ANSILocate (13,1)
     CALL QuickTPut (MenuColor2$ + LineBar$,0)
     CALL ANSILocate (13,3)
     '* ""
     LineNum = 981
     GOSUB 4010
     Strng1$ = Strng$
     '* ""
     LineNum = 982
     GOSUB 4010
     Strng2$ = Strng$
     CALL QuickTPut (MenuColor2$ + Strng1$ + ZSysopFullName$ + _
          SPACE$(1) + Strng2$,0)
     CALL ANSILocate (13,43)
     '* ""
     LineNum = 983
     GOSUB 4010
     Strng1$ = Strng$
     '* ""
     LineNum = 984
     GOSUB 4010
     Strng2$ = Strng$
     CALL QuickTPut (MenuColor2$ + Strng1$ + ZActiveUserName$ + Strng2$,0)
     CALL Line25
     EXIT SUB
4010 CALL FormatString (LineNum,ZFalse,ZFalse,0,ZFalse,0,Strng$)
     RETURN
     END SUB
'
5000 SUB ClearANSIScreen STATIC
'
     CALL QuickTPut (CHR$(27) + "[2J",0)
     ZSubParm = 2
     CALL Line25
     ZSubParm = 0
     CALL ANSILocate (1,1)
     END SUB
'
6000 SUB ANSILocate (ANSIRow,ANSICol) STATIC
'
     CALL QuickTPut (CHR$(27) + "[" + MID$(STR$(ANSIRow),2) + ";" + _
          MID$(STR$(ANSICol),2) + "H",0)
     END SUB
'
8000 SUB SplitScreenChat STATIC
'
8001 HoldInput$(LocalOut) = ""
     HoldInput$(RemoteOut) = ""
     MaxLen = 78
     StartRow(LocalOut) = 2
     StartRow(RemoteOut) = 14
     MaxRow(LocalOut) = 12
     MaxRow(RemoteOut) = 23
     ANSICol(LocalOut) = 1
     ANSICol(RemoteOut) = 1
     ANSIRow(LocalOut) = StartRow(LocalOut) + 1
     ANSIRow(RemoteOut) = StartRow(RemoteOut)
     WasX$(LocalOut) = ""
     WasX$(RemoteOut) = ""
     ZWaitExpired = ZFalse
'
8010 ZAutoLogoff! = TIMER + ZWaitBeforeDisconnect
     CALL CheckCarrier
     IF ZSubParm < 0 THEN _
        CALL QuickTPut1 (ZEmphasizeOff$) : _
        EXIT SUB
     CALL GiveBack
'
8020 CALL FindFKey
     TimeNow! = TIMER
     IF ZWasCM = 0 THEN _
        CALL FlushCom (ZCommPortStack$) : _
        ZKeyPressed$ = "" : _
        CALL ANSIMenu : _
        ZWasCM = ZTrue : _
        GOTO 8001
     IF TimeNow! - PrevTI! > 1.0 AND VAL(ZCBaud$) > 2400 THEN
        ElapsedTime! = TIMER
        CALL CheckTime (StartTime!,ElapsedTime!,2)
        ChatHour = ElapsedTime! / 3600
        ChatMin = (ElapsedTime! - ChatHour * 3600!) / 60
        ChatSec = ElapsedTime! - (ChatHour * 3600! + ChatMin * 60!)
        IF ChatSec < 0 THEN
           ChatSec = ChatSec + 60
           ChatMin = ChatMin - 1
        END IF
        IF ChatMin < 0 THEN
           ChatMin = ChatMin + 60
           ChatHour = ChatHour - 1
        END IF
        Hours$ = STR$(ChatHour)
        Mins$ = STR$(ChatMin)
        Secs$ = STR$(ChatSec)
        CALL Trim (Hours$)
        CALL Trim (Mins$)
        CALL Trim (Secs$)
        IF ChatHour < 10 THEN Hours$ = "0" + Hours$
        IF ChatMin < 10 THEN Mins$ = "0" + Mins$
        IF ChatSec < 10 THEN Secs$ = "0" + Secs$
        CALL ANSILocate (1,1)
        CALL QuickTPut (MenuColor1$ + Hours$ + ":" + Mins$ + ":" + Secs$,0)
        DisplayTime$ = LEFT$(TIME$,8)
        CALL ANSILocate (1,73)
        CALL QuickTPut (MenuColor1$ + DisplayTime$ + _
                        ZEmphasizeOff$,0)
        CALL ANSILocate (ANSIRow(SideOut),ANSICol(SideOut))
        PrevTI! = TimeNow!
     END IF
     SideOut = LocalOut
     WasX$(LocalOut) = ZKeyPressed$
     IF ZKeyPressed$ = ZEscape$ THEN
        CALL QuickTPut1 (ZEmphasizeOff$)
        EXIT SUB
     ELSEIF ZKeyPressed$ = CHR$(12) THEN
         IF NOT Logging THEN
            CALL SetUpLogFile
            IF ZOK THEN
               CALL SkipLine(1)
               Logging = ZTrue
            END IF
            WasX$(LocalOut) = ""
            GOTO 8520
         ELSE
            CLOSE 2
            Logging = ZFalse
         END IF
         WasX$(LocalOut) = ""
     END IF
     IF WasX$(LocalOut) <> "" THEN
        IF Logging THEN
           IF WasX$(LocalOut) = CHR$(13) THEN
              CALL PrintWorkA(2,"")
           ELSE
              CALL PrintWork(WasX$(LocalOut))
           END IF
        END IF
        GOTO 8060
     END IF
'
8030 IF ZLocalUser THEN _
        GOTO 8010
     SideOut = RemoteOut
     IF ZCommPortStack$ <> "" THEN _
        WasX$(RemoteOut) = LEFT$(ZCommPortStack$,LEN(ZCommPortStack$)-1) : _
        GOTO 9000
     CALL EofComm (Char)
     IF Char <> -1 THEN _
        GOTO 8050 _
     ELSE _
        GOTO 8010
'
8050 ZAutoLogoff! = TIMER + ZWaitBeforeDisconnect
     CALL GetCom (WasX$(RemoteOut))
     IF WasX$(RemoteOut) <> "" THEN
        IF Logging THEN
           IF WasX$(RemoteOut) = CHR$(13) THEN
              CALL PrintWorkA(2,"")
           ELSE
              CALL PrintWork(WasX$(RemoteOut))
           END IF
        END IF
     END IF
'
8060 'Control keys
     LastChar$(SideOut) = RIGHT$(LastChar$(SideOut),1) + _
                          WasX$(SideOut)
     IF WasX$(SideOut) = CHR$(8) THEN _
        GOTO 8500 _
     ELSE IF WasX$(SideOut) = CHR$(9) THEN _
        GOTO 8510 _
     ELSE IF WasX$(SideOut) = CHR$(13) THEN _
        GOTO 8520
     IF WasX$(SideOut) = CHR$(6) AND ZWasGR > 1 THEN 'CTRL-F color
        ForeRotate(SideOut) = ForeRotate(SideOut) + 1
        IF ForeRotate(SideOut) > 7 AND ForeHiLite(SideOut) = 1 THEN
           ForeHiLite(SideOut) = 0
           ForeRotate(SideOut) = 0
        END IF
        IF ForeRotate(SideOut) > 7 THEN
           ForeHiLite(SideOut) = 1
           ForeRotate(SideOut) = 0
        END IF
        hilite$ = STR$(ForeHiLite(SideOut))
        CALL Trim (hilite$)
        colorstr$ = STR$(ForeGround(ForeRotate(SideOut)))
        CALL Trim (colorstr$)
        ACColor$(SideOut) = ZEscape$ + "[" + hilite$ + ";" + colorstr$ + "m"
        GOTO 8010
     END IF
     GOTO 9000
'
8500 'BackSpace
     IF HoldInput$(SideOut) <> "" THEN _
        HoldInput$(SideOut) = LEFT$(HoldInput$(SideOut), _
                              LEN(HoldInput$(SideOut))-1)
     IF ANSICol(SideOut) > 1 THEN _
        ANSICol(SideOut) = ANSICol(SideOut) - 1 : _
        GOTO 8501
     IF ANSICol(SideOut) = 1 THEN _
        GOSUB 8502 : _
        ANSICol(SideOut) = MaxLen - 1 : _
        ANSIRow(SideOut) = ANSIRow(SideOut) - 1
     IF ANSIRow(SideOut) < StartRow(SideOut) THEN _
        ANSIRow(SideOut) = MaxRow(SideOut)
8501 GOSUB 8502
     GOTO 8010
8502 CALL ANSILocate (ANSIRow(SideOut),ANSICol(SideOut))
     tempstr$ = ACColor$(SideOut) + SPACE$(1)
     IF NOT ZLocalUser THEN _
        CALL PutCom (tempstr$)
     CALL LPrnt (tempstr$,0)
     CALL ANSILocate (ANSIRow(SideOut),ANSICol(SideOut))
     RETURN
'
8510 'TAB
     HoldInput$(SideOut) = ""
     IF ANSICol(SideOut) + 5 > MaxLen THEN _
        CALL AddRow (StartRow(SideOut),MaxRow(SideOut)) _
     ELSE _
        ANSICol(SideOut) = ANSICol(SideOut) + 5 : _
        CALL ANSILocate (ANSIRow(SideOut),ANSICol(SideOut))
     GOTO 8010
'
8520 'CR
     HoldInput$(SideOut) = ""
     CALL AddRow (StartRow(SideOut),MaxRow(SideOut))
     GOTO 8010
'
9000 'Character Placement
     IF LastChar$(SideOut) = ZEscape$ + ZEscape$ THEN _
           CALL QuickTPut1 (ZEmphasizeOff$) : _
           EXIT SUB
     HoldInput$(SideOut) = HoldInput$(SideOut) + WasX$(SideOut)
     IF WasX$(SideOut) = SPACE$(1) THEN _
        HoldInput$(SideOut) = ""
     IF ANSICol(SideOut) = MaxLen AND WasX$(SideOut) <> SPACE$(1) THEN _
        CALL ANSILocate (ANSIRow(SideOut),ANSICol(SideOut) - _
                         LEN(HoldInput$(SideOut))) : _
        CALL QuickTput(ACColor$(SideOut) + CHR$(27) + "[K", 0) : _
        CALL AddRow (StartRow(SideOut),MaxRow(SideOut)) : _
        CALL QuickTPut (HoldInput$(SideOut),0) : _
        ANSICol(SideOut) = ANSICol(SideOut) + LEN(HoldInput$(SideOut)) - 1 : _
        WasX$(SideOut) = "" : _
        HoldInput$(SideOut) = ""
     CALL ANSILocate (ANSIRow(SideOut),ANSICol(SideOut))
     IF NOT ZLocalUser THEN _
        CALL PutCom (ACColor$(SideOut) + WasX$(SideOut))
     CALL LPrnt (ACColor$(SideOut) + WasX$(SideOut),0)
     ANSICol(SideOut) = ANSICol(SideOut) + 1
     IF ANSICol(SideOut) > MaxLen THEN _
        CALL AddRow (StartRow(SideOut),MaxRow(SideOut))
     WasX$(SideOut) = ""
     GOTO 8010
     END SUB
'
10000 SUB AddRow (StartRow,MaxRow) STATIC
'
      ANSICol(SideOut) = 1
      ANSIRow(SideOut) = ANSIRow(SideOut) + 1
      IF ANSIRow(SideOut) > MaxRow THEN _
         ANSIRow(SideOut) = StartRow
      IF ANSIRow(SideOut) < MaxRow THEN _
         CALL ANSILocate (ANSIRow(SideOut) + 1,ANSICol(SideOut)) : _
         CALL QuickTput(ACColor$(SideOut) + CHR$(27) + "[K", 0)
      IF ANSIRow(SideOut) = MaxRow THEN _
         CALL ANSILocate (StartRow,ANSICol(SideOut)) : _
         CALL QuickTput(ACColor$(SideOut) + CHR$(27) + "[K", 0)
      CALL ANSILocate (ANSIRow(SideOut),ANSICol(SideOut))
      END SUB
'
