/* $Id: nlmaint.h,v 1.1.1.1 1996/10/09 11:27:09 davidn Exp $
 * NLMaint common include file
 *
 */

#ifndef _nlmaint_h
#define _nlmaint_h

#include <stdio.h>
#include <time.h>
#include "strbuf.h"		/* Strings buffer */
#include "array.h"		/* Dynamic arrays */
#include "compress.h"
#include "fidoaddr.h"
#include "checknl.h"
#include "aplydiff.h"

#define SECSPERDAY  (60L*60L*24L)
#define ENVSTRING   "NLMAINT"
#define DFLTCFG     "nlmaint.ctl"

enum _errorlevels {
    EL_PROCESSOK = 0,		/* Process mode - no errors */
    EL_PROCESSERRORS = 1,	/* Process mode - no fatal errors */
    EL_PROCESSFATAL = 2,	/* Process mode - fatal error */
    EL_TESTOK = 3,		/* Test mode - no errors */
    EL_TESTERRORS = 4,		/* Test mode - no fatal errors */
    EL_TESTFATAL = 5,		/* Test mode - fatal error */
    EL_INTERNAL = 251,		/* Aborted - Unexpected internal error */
    EL_MEMERROR = 252,		/* Aborted - Memory related error */
    EL_CMDERROR = 253,		/* Aborted - Cmdline error */
    EL_IOERROR = 254,		/* Aborted - I/O error */
    EL_CTLERROR = 255		/* Aborted - control file error */
};


/* Enumerator for days of week
 */

enum _dow {
    V_NEVER = -1,
    V_SUNDAY = 0,
    V_MONDAY,
    V_TUESDAY,
    V_WEDNESDAY,
    V_THURSDAY,
    V_FRIDAY,
    V_SATURDAY
};
/* Structure used for a FidoNet address
 */

enum _opmode {
    MODE_TEST,
    MODE_PROCESS
};
/* This enumerator is used as manifest constants for keywords
 */

enum _verbs {			/* -- Path names */
    V_MASTER,			/* MASter <directory> */
    V_UPDATE,			/* UPDate <directory> */
    V_BADFILES,			/* BADfiles <directory */
    V_OUTPATH,			/* OUTPath <directory> */
    V_ARCLIST,			/* ARCList <directory> */
    V_ARCDIFF,			/* ARCDiff <directory> */
    V_LASTDIR = V_ARCDIFF,
    V_LOGFILE,			/* LOGFile <explicit_filename> */
    V_COPYRIGHT,		/* COPyright <explicit_filename> */
    V_PROLOG,			/* PROlog <explicit_filename> */
    V_EPILOG,			/* EPIlog <explicit_filename> */
    V_COMPRESS,			/* COMPression configuration !!! */
    V_DATA,			/* DATa file */
    V_COMMENTS,			/* COMEents <explicit_filename> */
    V_FLAG,			/* FLAGs <disposition> [<extensionfile>] */
    V_UFLAG,			/* UFLAGs <disposition> [<extensionfile>] */
    V_MERGE,			/* MERge [<nodelist_name>] */
    V_LASTPATH = V_MERGE,
    /* Filenames */
    V_MESSAGES,			/* MESsages <directory_name> */
    V_OUTFILE,			/* OUTFile <filename> */
    V_OUTDIFF,			/* OUTDiff <generic_name> */
    V_BAUDRATE,			/* BAUdrate <valid_baudrates> */
    V_NAME,			/* NAMe <network_name> */
    V_PGPPASS,			/* PGP Password */
    V_ARC,			/* ARC <method>,<prefix> */
    V_DIFFARC,			/* DIFFArc <method>,<prefix> */
    V_NLPFX,			/* Nodelist prefix */
    V_NDPFX,			/* Nodediff prefix */
    V_LISTDESC,			/* Template for list description */
    V_DIFFDESC,			/* Template for diff description */
    V_BEFORE,			/* BEForeproc <cmd> */
    V_AFTER,			/* AFTerproc <cmd> */
    V_EXECSUBMIT,		/* EXECSubmit <command_template> */
    V_EXECPOST,			/* EXECPost <command_template> */
    V_PASSWORD,			/* Password to place in submittal file */
    V_STRINGS,
    V_UPLOADS,			/* UPLoads <directory> */
    V_MAILFILES,		/* MAIlfiles <directory> */
    /* -- Misc -- */
    V_MAKE,			/* MAKe <segment_type> [<number>
				 * [<source_file>]] */
    V_PUBLISH,			/* PUBlish <day_of_week> */
    V_PROCESS,			/* PROcess <day_of_week> */
    V_PRIVATE,			/* PRIvate <disposition> */
    V_MINPHONE,			/* MINphone <minimum_parts> */
    V_THRESHOLD,		/* THReshold <arc_size> [<diff_size>] */
    V_CLEANUP,			/* CLEanup */
    V_NETADDRESS,		/* NETaddress [<zone>:]<net>/<node> */
    V_SUBMIT,			/* SUBmit <address> [<flags>] */
    V_NOTIFY,			/* NOTify <type> [<flags>] */
    V_FILES,			/* FILes */
    V_LOGLEVEL,			/* LOGLevel <n> */
    V_REDUNDANT,		/* NOPHonewarn */
    V_INCLUDE,			/* INCLude filename */
    V_LISTARC,			/* LISTArc <method>,<prefix> - synonym for
				 * V_ARC */
    V_max
};
/* Enumerators for command line switches
 */

enum _switches {
    ARG_DEFAULT = 0,		/* Process if day is correct */
    ARG_PROCESS = 1,		/* Process mode */
    ARG_TEST = 2,		/* Test mode */
    ARG_MERGE = 3,		/* Merge segs with another list */
    ARG_NAME = 4,		/* Specify network name */
    ARG_SUPPRESS = 5,		/* Suppress submissions */
    ARG_FORCE = 6,		/* Force update to be sent, even if no change */
    ARG_HELP = 7,
    ARG_ALTHELP = 8
};


/* Notify types
 */

enum _notify {
    NF_NONE = 0x0001,
    NF_RECEIPT = 0x0002,	/* Notify on receipt */
    NF_ERRORSONLY = 0x0004,	/* Notify of errors only */
    NF_WARNONLY = 0x0008,
    NF_ALL = 0x0010,		/* Notify self of errors */
    /* -- special -- */
    NF_PGPSIGN = 0x0020,	/* Sign pgp */
    NF_PGPCRYPT = 0x0040,	/* Encrypt/descript pgp */
    NF_NOCRC16 = 0x0080,	/* Suppress CRC checking for submissions */
    /* -- message attributes -- */
    NF_CRASH = 0x0100,		/* Notify 'crash' attribute */
    NF_HOLD = 0x0200,		/* Notify 'hold' attribute */
    NF_IMM = 0x1000,		/* Notify 'immediate' attribute */
    NF_DIRECT = 0x2000,		/* Notify 'direct' attribute */
    NF_INTL = 0x4000,		/* Notify msg forces ^aINTL */
    NF_XFLAGS = 0x8000		/* Use ^aXFLAGS attributes */
};
/* Struct describing a submitted data file
 */

typedef struct _subfile {
    enum _nltype type;		/* Sub-file type */
    node_t number;		/* segment number */
    sofs_t name;		/* Generic name of submitted file */
    sofs_t password;		/* Password for received segments */
    unsigned notify;		/* Notify override for this node */
    ZNNP addr;			/* Submission address */
    DIFFAPP *pda;		/* Used for applying diffs */
    FILE *fbfp;			/* File descriptor for feedback file */
}   subfile;
/* NOTOOL configuration structure
 */

typedef struct nlconfig {
    strbuf strings;		/* configurations strings buffer */
    Array Files;		/* Array of files to accept */
    Array Data;			/* Data lines */
    Array Inbound;		/* Incoming directories */
    ArcInfo Arcs;		/* Archiving information */
    sofs_t str[V_STRINGS];	/* Pathnames */
    ZNNP myaddr;		/* My network address */
    ZNNP submitaddr;		/* Submit flags */
    FILE *fbfp;			/* Feedback file for local coordinator */
    time_t now;			/* Startup time (basis of all time) */
    time_t publish_time;	/* Targetted time_t for next publish */
    enum _nltype type;		/* Nodelist type */
    node_t number;		/* zone,region,net,hub number */
    enum _dow publish;		/* publication day of week */
    enum _dow process;		/* auto-process day of week */
    enum _opmode mode;		/* Operating mode */
    enum _pvt pvtdisp;		/* Handling of Pvt nodes */
    unsigned notify;		/* Notify types */
    unsigned submit;		/* Submit flags */
    int errcount;		/* Number of processing errors */
    int loglevel;		/* Logging level */
    int logformat;		/* Format type for log file */
    int target;			/* Target julian day */
    int tyear;			/* Year of publishing date */
    unsigned short phone_parts_min;	/* Min sections in phone field */
    unsigned short phone_parts_max;	/* Max sections in phone field */
    unsigned short cleanup;	/* non-zero, clean up old lists */
    unsigned char flag_handling;/* Flag handling */
    unsigned char uflag_handling;	/* User flag handling */
    unsigned char phone_handling;	/* Warn about non-redundant phone #s */
}   NLCONFIG;
#define nlstr(n,s)        sb_string(&(n)->strings,s)
#define nlstring(n,v)     nlstr(n,(n)->str[(v)])
#define nlsnull(n,v)      !((n)->str[(v)])

/* config.c */

void configure(NLCONFIG ** nlc, char const * filename);
int cmdlineverb(char const * kwd);
int controlverb(char const * kwd);
char *notify_str(char *dest, unsigned typ);
/* nodelist.c */

void move_inbound(NLCONFIG * nlc, char const * dir);
void move_updates(NLCONFIG * nlc);
int check_segment(char const * listname);
int test_segment(NLCONFIG * nlc);
int make_segment(NLCONFIG * nlc, char *targ);
int make_diff(NLCONFIG * nlc, char const * targ, char *diffname, int force);
int archive_list(NLCONFIG * nlc, char *targ, char const * destdir, char const * method, char const * pfx, int do_rm);
int find_latest(char *targ, char const * src, int type, time_t current);
int cleanup_lists(char const * dir, char const * file, char const * except, time_t current);
int copylist(char *src, char const * destdir);
/* merge.c */
int merge_list(char const * dest, char const * src, char const * tomerge, ZNNP addr);
/* template.c */

void make_template(NLCONFIG * nlc, char const * list, char const * fdif, char const * user, subfile * sf);
int exec_cmd(NLCONFIG * nlc, char const * tpl, char const * list, char const * fdif, char const * user, subfile * sf);
int update_description(NLCONFIG * nlc, char const * filesbbs, char const * tpl, char const * list, char const * fdif);
/* feedback.c */

int fb_printf(NLCONFIG * nlc, subfile * sf, unsigned types, char const * fmt,...);
void send_feedback(NLCONFIG * nlc, int nosend);
#endif
