/* $Id: strcase.c,v 1.1.1.1 1996/10/09 11:25:32 davidn Exp $
 * Case dependant string functions
 * These functions are normally implemented by DOSish compilers,
 * but are typically named something different in other environs.
 * The C standard library does not determine case specific issues,
 * so we implement these here in all environments since we desire
 * to have consistency in collating/sorting and so forth.
 *
 */

#include <string.h>
#include <ctype.h>
#include "osdep.h"

char *
strlwr(char *buf)
{
    char *p = buf;
    while (*p)
	*p = (char) tolower(*p);
    return buf;
}

char *
strupr(char *buf)
{
    char *p = buf;
    while (*p)
	*p = (char) toupper(*p);
    return buf;
}

int
stricmp(char const * s1, char const * s2)
{
    int r;
    do {
	r = toupper(*s1) - toupper(*s2);

	/*
	 * Outside of toupper() to avoid side-effects
	 */
	s1++;
	s2++;
    }
    while (r == 0 && *s1);
    return r;
}

int
strnicmp(char const * s1, char const * s2, size_t n)
{
    int r;
    do {
	if (n-- <= 0)
	    return 0;
	r = toupper(*s1) - toupper(*s2);

	/*
	 * Outside of toupper() to avoid side-effects
	 */
	s1++;
	s2++;
    }
    while (r == 0 && *s1);
    return r;
}
