/* $Id: hmem.c,v 1.1.1.1 1996/10/09 11:24:47 davidn Exp $
 * Intel 16-bit far/huge memory allocation functions
 *
 */

#include <stdlib.h>
#include <string.h>
#include "mem.h"

#ifdef __16BITSEGMENTED__
#include <malloc.h>

static unsigned
paras(lsize_t sz)
{
    lsize_t rsz = sz + 15;
    rsz -= (rsz % 16);
    return (unsigned) (rsz / 16);
}

void huge *
zhmalloc(char const * fn, lsize_t sz)
{
    void huge *p = 0L;
    if (sz) {
	unsigned np = paras(sz + 2 * sizeof(unsigned));
	unsigned huge *i = halloc(np, 16);
	if (i == 0L)
	    memfatal(memfatalcode, "allocation error [%s] %u bytes", fn, sz);
	*i++ = np;
	*i++ = MEM_MAGIC_BLOCK;
	p = i;
    }
    return p;
}

void huge *
zhrealloc(char const * fn, void huge * p, lsize_t sz)
{
    if (p == 0L)
	p = zhmalloc(fn, sz);
    else if (sz == 0) {
	zhfree(fn, p);
	p = 0L;
    } else {
	unsigned onp, np = paras(sz + 2 * sizeof(unsigned));
	unsigned huge *i = p;
	if (*--i != MEM_MAGIC_BLOCK)
	    memfatal(memfatalcode, "realloc error [%s] corrupted heap?", fn);
	onp = *--i;
	if ((p = halloc(np, 16)) != 0L) {
	    hugememmove(p, i, (lsize_t) (onp < np ? onp : np) * 16);
	    hfree(i);
	    i = p;
	    *i++ = np;
	    *i++ = MEM_MAGIC_BLOCK;
	    p = i;
	}
    }
    return p;
}

void
zhfree(char const * fn, void huge * p)
{
    if (p) {
	unsigned huge *i = p;
	if (*--i != MEM_MAGIC_BLOCK)
	    memfatal(memfatalcode, "free error [%s] corrupted heap?", fn);
	hfree(--i);
    }
}


/* hugememmove()
 * There are far better methods than this, and code generated from
 * this approach is usually pretty slow. An asm version that does
 * fast block moves for segment sections would be better.
 */

void
hugememmove(void huge * _dst, void const huge * _src, lsize_t sz)
{
    register unsigned char huge *dst = _dst;
    register unsigned char huge *src = _src;
    if (dst < src) {
	while (sz--)
	    *dst++ = *src++;
    } else if (dst > src) {
	dst += sz;
	src += sz;
	while (sz--)
	    *--dst = *--src;
    }
}
#endif
