/* $Id: cfile.c,v 1.1.1.1 1996/10/09 11:25:08 davidn Exp $
 * Implements a file with a CRC-16 accumulator
 *
 */

#include <stdarg.h>
#include <string.h>
#include "cfile.h"
#include "mem.h"


/* cfopen() - open a file and return a descriptor
 */

CFILE *
cfopen(char const * filename, char const * modes)
{
    CFILE *cfp;
    FILE *fp = fopen(filename, modes);
    if (fp == NULL)
	return NULL;
    cfp = zmalloc("cfopen", sizeof(CFILE));
    cfp->fp = fp;
    cfp->crc16 = 0;
    return cfp;
}


/* cfclose() - close a CFILE
 */

int
cfclose(CFILE * cfp)
{
    int rc = 0;
    if (cfp) {
	if (cfp->fp)
	    rc = fclose(cfp->fp);
	zfree("cfclose", cfp);
    }
    return rc;
}


/* cfwrite() - Write data to a CFILE
 */

size_t
cfwrite(const void *ptr, size_t size, size_t n, CFILE * cfp)
{
    cfp->crc16 = update_crc16(ptr, size * n, cfp->crc16);
    return fwrite(ptr, size, n, cfp->fp);
}


/* cfseek() - move the file pointer within a CFILE
 */

int
cfseek(CFILE * cfp, long int offset, int whence)
{
    return fseek(cfp->fp, offset, whence);
}


/* cfgets() - Get a string from a CFILE
 */

char *
cfgets(char *s, int n, CFILE * cfp)
{
    return fgets(s, n, cfp->fp);
}


/* cfprintf() - Output a formatted string to a CFILE
 */

int
cfprintf(CFILE * cfp, const char *fmt,...)
{
    int sz;
    va_list argp;
    static char buf[2048];
    va_start(argp, fmt);
    sz = vsprintf(buf, fmt, argp);
    va_end(argp);
    return cfwrite(buf, 1, sz, cfp);
}


/* cfputs() - Write s tring to a CFILE
 */

int
cfputs(const char *s, CFILE * cfp)
{
    return cfwrite(s, 1, strlen(s), cfp);
}


/* cferror() - Return error condition from a CFILE stream
 */

int
cferror(CFILE * cfp)
{
    return ferror(cfp->fp);
}
