/* $Id: filediff.h,v 1.1.1.1 1996/10/09 11:15:09 davidn Exp $
 * Generic interface to file differencing
 *
 */

#ifndef _filediff_h
#define _filediff_h

#include "wfile.h"

#define F_OLD 0
#define F_NEW 1

typedef struct _fdiff {
    WFILE wf[2];		/* File data */
    int len[2];			/* Length of current line(s) */
    char const *sp[2];		/* Current line in each file */
}   FDIFF;

int filediff(char const * outfile, char const * oldfile, char const * newfile);
int diff(FILE *fp, char const * oldfile, char const * newfile);
char *diff_name(char *dest, char const * target_list, char const * diffname);
#endif
