/* $Id: feedback.c,v 1.2 1996/10/12 14:13:16 davidn Exp $
 * Handle feedback/error/receipt messages
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdarg.h>
#include <ctype.h>

#include "nlmaint.h"
#include "osdep.h"
#include "log.h"
#include "version.h"

extern char const *modes[];

static int
fb_sendok(unsigned nfbits, unsigned types, int local)
{
    /*
     * Receipts are handled separately from "all" and "none"
     */
    if ((types & NM_RECEIPT) && !(types & NM_ERROR))
	return (nfbits & NF_RECEIPT) && !local;	/* Receipt to remotes */
    /*
     * If "none", then we can quit now
     */
    if (nfbits & NF_NONE)
	return 0;
    /*
     * If "all", then do it anyway
     */
    if (nfbits & NF_ALL)
	return 1;
    /*
     * It is a warning
     */
    if (types & NM_WARNING)
	return !(nfbits & NF_ERRORSONLY) || (nfbits & NF_WARNONLY);
    /*
     * It is an error
     */
    if (types & NM_ERROR)
	return 1;
    /*
     * Neither warning nor an error
     */
    return !!(nfbits & (NF_ERRORSONLY | NF_WARNONLY));
}

static char *
fb_name(NLCONFIG * nlc, subfile * sf)
{
    char const *base = sf ? nlstr(nlc, sf->name) : nlstring(nlc, V_OUTFILE);
    char *p = build_path(NULL, nlstring(nlc, V_MASTER), base, NULL);
    add_ext(p, ".fbm");
    return p;
}

static int
fb_write(NLCONFIG * nlc, subfile * sf, FILE **fp, char const * buf, int len)
{
    /*
     * We must open the file if it is not already open
     */
    if (*fp == NULL) {
	char ldate[64];
	struct tm *t;
	char *p = fb_name(nlc, sf);
	remove(p);
	if ((*fp = fopen(p, "a")) == NULL)
	    return 0;
	t = localtime(&nlc->now);
	strftime(ldate, sizeof ldate - 1, "%H:%M on %A, %d %B %Y", t);
	fprintf(*fp, "%s %s in %s mode at %s\n", progname, version, modes[nlc->mode], ldate);
    }
    return fwrite(buf, len, 1, *fp);
}


/* This outputs data to a temp file used for feedback
 */

int
fb_printf(NLCONFIG * nlc, subfile * sf, unsigned types, char const * fmt,...)
{
    int isfeedback = (types & NM_FEEDBACK);
    int writelog = (types & NM_LOG);
    int writeremote = (sf && isfeedback) ? fb_sendok(sf->notify, types, 1) : 0;
    int writelocal = fb_sendok(nlc->notify, types, 0);
    int rc = 0;
    if ((writeremote || writelocal || writelog) && fmt && *fmt) {
	va_list argp;
	char cbuf[1024];
	cbuf[0] = ' ';
	va_start(argp, fmt);
	rc = vsprintf(cbuf + 1, fmt, argp) + 1;
	va_end(argp);
	if (writelocal)
	    fb_write(nlc, NULL, &nlc->fbfp, cbuf, rc);
	if (writeremote)
	    fb_write(nlc, sf, &sf->fbfp, cbuf, rc);
	if (writelog) {
	    char *p = strchr(cbuf, '\n');
	    int loglev = (types & NM_ERROR) ? LOG_ERROR : ((types & NM_WARNING) ? LOG_WARN : LOG_TRANX);
	    if (p)
		*p = '\0';
	    logent(loglev, cbuf + 1);
	}
    }
    return rc;
}

static FILE *
feedback(NLCONFIG * nlc, FILE *fbfp, subfile * sf, int nosend)
{
    if (fbfp) {
	char fbfile[_MAX_PATH];

	static int done = 0;
	fclose(fbfp);		/* Close the feedback file */
	strcpy(fbfile, fb_name(nlc, sf));	/* Get its name */
	if (nosend)
	    remove(fbfile);
	else {
	    if (!nlsnull(nlc, V_EXECPOST)) {
		if (exec_cmd(nlc, nlstring(nlc, V_EXECPOST), NULL, NULL, fbfile, sf) == 0)
		    remove(fbfile);	/* Posted, so we can safely remove it */
		else
		    logit(LOG_RESULT, "Feedback file \"%s\" retained", fbfile);
	    } else if (!done++)	/* Only log warning once */
		logit(LOG_RESULT, "No EXECPOST cmd - feedback mail left in \"%s\"", build_path(NULL, nlstring(nlc, V_MASTER), "*.fbm", NULL));
	}
    }
    return NULL;
}

void
send_feedback(NLCONFIG * nlc, int nosend)
{
    subfile *sf;
    ArrayIter iter;
    nlc->fbfp = feedback(nlc, nlc->fbfp, NULL, 0);
    arrayIter_init(&iter, &nlc->Files);
    while ((sf = arrayIter_get(&iter, NEXT)) != NULL)
	sf->fbfp = feedback(nlc, sf->fbfp, sf, nosend);
}
