/* $Id: wildmat.c,v 1.1.1.1 1996/10/09 11:25:36 davidn Exp $
 * Implements a simple "wildcard" string matching algorithm
 *
 */

#include <ctype.h>
#include "osdep.h"


/* escape() - Simple C/UNIX type character escape sequences
 */

int
escape(register int c)
{
    switch (c) {
	case 't':c = '\t';
	break;
    case 'r':
	c = '\r';
	break;
    case 'n':
	c = '\n';
	break;
    case 'a':
	c = '\a';
	break;
    case 'b':
	c = '\b';
	break;
    case 'f':
	c = '\f';
	break;
    case 'v':
	c = '\v';
	break;
    }
    return c;
}
/* wildmatch() - Determine whether string 's' patches pattern 'p'
 * 'icase' determines case sensitivity.
 */

int
wildmatch(register char const * s, register char const * p, int icase)
{
    for (; *p; ++s, ++p) {
	register int a = *p;
	switch (a) {
	case '#':		/* Numeric */
	    if (!*s || !isdigit(*s))
		return 0;
	    break;
	case '?':		/* Any character */
	    if (!*s)
		return 0;
	    break;
	case '*':		/* Any series of characters */
	    if (*++p) {
		while (wildmatch(s, p, icase) == 0)
		    if (*++s == '\0')
			return 0;
	    }
	    return 1;
	case '[':		/* Character class */
	    {
		register int last = 0400;
		register int matched = 0;
		register int reverse = 0;
		register int s1 = icase ? tolower(*s) : *s;
		if (p[1] == '^') {
		    ++reverse;
		    if (!*++p)
			break;
		}
		for (; *++p && *p != ']'; last = icase ? tolower(*p) : *p) {
		    a = icase ? tolower(*p) : *p;
		    if (a != '-') {
			if (a == '\\') {
			    a = escape(*++p);
			    if (icase)
				a = tolower(a);
			}
			if (a == s1)	/* Character match */
			    matched = 1;
		    } else {	/* Is a range */
			a = *++p;	/* Look for end of range */
			if (icase)
			    a = tolower(a);
			if ((s1 <= a) && (s1 >= last))	/* is it in range? */
			    matched = 1;
		    }
		}
		if (matched == reverse)
		    return 0;
	    }
	    break;
	case '\\':		/* Escaped character */
	    if (!*++p)
		break;
	    a = escape(*p);
	    /* Fallthru */
	default:		/* Literal match */
	    if (icase) {
		if (tolower(*s) == tolower(a))
		    break;
	    } else {
		if (*s == a)
		    break;
	    }
	    return 0;
	}
	if (!*p)
	    break;
    }
    return (*s == '\0') ? 1 : 0;
}
