/* $Id: fcopy.c,v 1.1.1.1 1996/10/09 11:25:18 davidn Exp $
 * Copy/move a file
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>
#include "posix.h"
#include "mem.h"


/* fcopy() - Copy or move a file
 */

int
fcopy(char const * dest, char const * src, int moveit)
{
    static char const fn[] = "fcopy";
    char *dpath = get_path(NULL, dest);
    int rc = makesubdir(dpath);
    struct stat st;
    int sfd, dfd;
    int iserrno = 0;
    if (rc != 0 || stat(src, &st) != 0 || (sfd = open(src, O_RDONLY | O_BINARY, 0)) == -1)
	iserrno = errno;
    else {
	rc = -1;
	if ((dfd = open(dest, O_RDWR | O_CREAT | O_TRUNC | O_BINARY, S_IREAD | S_IWRITE)) == -1)
	    iserrno = errno;
	else {
#define XFERBUFSZ   4096
	    char *buf = zmalloc(fn, XFERBUFSZ);
	    if (buf != NULL) {
		int rdcount;
		for (rc = 0; rc == 0 && (rdcount = read(sfd, buf, XFERBUFSZ)) != 0;) {
		    int wrcount;
		    if ((rdcount == -1) ||
			(wrcount = write(dfd, buf, rdcount)) == -1 ||
			(wrcount != rdcount)) {	/* Short write */
			rc = -1;
			iserrno = errno;
		    }
		}
		zfree(fn, buf);
	    }
	    if (close(dfd) == EOF && rc == 0) {
		iserrno = errno;
		rc = -1;
	    } else
		chmod(dest, st.st_mode);
	}
	close(sfd);
	if (rc != 0)
	    remove(dest);
	else if (moveit) {
	    remove(src);
	    setfiletimes(dest, &st);
	}
    }
    errno = iserrno;
    return rc;
}


/* fmove() - Move a file
 */

int
fmove(char const * dest, char const * src)
{
    return fcopy(dest, src, 1);
}
