/* $Id: dirs.c,v 1.1.1.1 1996/10/09 11:25:18 davidn Exp $
 * Directory handling functions
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "posix.h"

#ifdef DOSISH

#if defined(__OS2__) || defined(__EMX__)
#include "os2.h"
#elif defined(WIN32) || defined(_WIN32)
#include "windows.h"
#else
#include <dos.h>
#endif
#if !defined(__EMX__)
#include <direct.h>
#endif

static int
setdisk(int drive)
{
#ifdef __OS2__
#if defined(__FLAT__) || defined(__EMX__)
    return DosSetDefaultDisk(drive - 'A' + 1);
#else
    return DosSelectDisk(drive - 'A' + 1);      /* in OS/2, drive 1=A, 2=B etc */
#endif
#elif defined(__MSDOS__)
    union REGS regs;
    regs.h.ah = 0x0E;		/* dos select disk */
    regs.h.dl = (unsigned char) drive - 'A';    /* 0=A, 1=B etc */
    intdos(&regs, &regs);
#if defined(__WATCOMC__)
    return (_getdrive() == drive) ? 0 : -1;
#else
    return (getdisk() == drive) ? 0 : -1;
#endif
#elif defined(_WIN32) || defined(WIN32)
    char szPath[10];
    sprintf(szPath, "%c:.", drive + 'A');
    return SetCurrentDirectory(szPath) ? 0 : -1;
#endif
}
#endif

int
makedir(char const * s)
{
#if defined(DOSISH) && !defined(__EMX__)
    return mkdir(s);
#else
    return mkdir(s, 0777);
#endif
}

int
removedir(char const * dir)
{
    return rmdir(dir);
}

int
changedir(char const * dir)
{
    int rc = chdir(dir);
#ifdef DOSISH
    if (rc == 0 && dir[1] == ':')
	setdisk(toupper(*dir));
#endif
    return rc;
}
