/* $Id: txtbuf.h,v 1.1.1.1 1996/10/09 11:17:42 davidn Exp $
 * Generic text buffer handling
 *
 */

#ifndef _txtbuf_h
#define _txtbuf_h

typedef unsigned bofs_t;
typedef unsigned char *bufptr_t;

typedef struct _txtbuf {
    bofs_t bufSize,		/* Actual size of buffer */
        gapOfs,			/* Offset of 'gap' cursor */
        gapSize;		/* Size of 'gap' */
    bufptr_t buffer;		/* Buffer memory */
}   txtbuf;

txtbuf *tb_new(bofs_t sz);
void tb_delete(txtbuf * tb);

txtbuf *tb_init(txtbuf * tb, bofs_t sz);	/* Init a text buffer */
void tb_destroy(txtbuf * tb);	/* Destroy a text buffer */

void tb_reset(txtbuf * tb);	/* Remove all text */

bofs_t tb_seek(txtbuf * tb, bofs_t pos, int whence);	/* Move gap offset */
int tb_write(txtbuf * tb, void const * data, int count);	/* Write data */
int tb_puts(txtbuf * tb, char const * str);	/* Write string */
int tb_putc(txtbuf * tb, char ch);	/* Write character */
int tb_printf(txtbuf * tb, char const * fmt,...);	/* Formatted output */
int tb_remove(txtbuf * tb, int count);	/* Remove/delete text */
int tb_read(txtbuf * tb, char *buf, int count);	/* Read data */
char *tb_gets(txtbuf * tb, char *buf, int max);	/* Get string */

bofs_t tb_size(txtbuf * tb);	/* Return size of text */
#define tb_size(tb)       ((tb)->bufSize - (tb)->gapSize)
#define tb_bufsize(tb)    ((tb)->bufSize)
#define tb_freesize(tb)   ((tb)->gapSize)

#endif
