/* $Id: osdep.c,v 1.1.1.1 1996/10/09 11:25:29 davidn Exp $
 * Operating system dependant functions
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "osdep.h"

static char __local_path_buf[_MAX_PATH];
#ifdef DOSISH

/* fixpath() - fix up path separators
 */

char *
fixpath(char *path)
{
    char *p = path;
    while ((p = strchr(p, '/')) != NULL)
	*p++ = DIRCH;
    return path;
}
#endif


/* build_path() - build and return a path from several
 * components, inserting path separators etc.
 */

char *
build_path(char *dest, char const * path,...)
{
    char *p;
    va_list argp;
    if (dest == NULL)
	dest = __local_path_buf;
    p = dest;
    va_start(argp, path);
    *p = '\0';
    while (path != NULL) {
	if (p > dest)
	    if (*(p - 1) != DIRCH)
		*p++ = DIRCH;
	strcpy(p, path);
	p += strlen(fixpath(p));
	path = va_arg(argp, char const *);
    }
    va_end(argp);
    return dest;
}


/* last_component() - return the "base" portion of a file
 * name, dicarding the directory/volume/drive/path
 */

char *
last_component(char const * path)
{
    char *p = strrchr(fixpath((char *) path), DIRCH);
#ifdef DOSISH
    if (p == NULL && (p = strrchr(path, ':')) == NULL)
#else
    if (p == NULL)
#endif
	p = (char *) path;
    else
	++p;
    return p;
}


/* get_path() - return the directory portion of a full path
 */

char *
get_path(char *dest, char const * path)
{
    int l = last_component((char *) path) - path;
    if (dest == NULL)
	dest = __local_path_buf;
    strncpy(dest, path, l);
    dest[l ? l - 1 : 0] = '\0';
    return dest;
}


/* path_ext() - return a pointer to a file extension, if any
 */

char *
path_ext(char *path)
{
    char *last = last_component(path);
    char *p = strrchr(last, '.');
    if (p == NULL)
	p = last + strlen(last);
    return p;
}


/* add_ext() - Add or replace a file extension
 */

char *
add_ext(char *path, char const * ext)
{
    char *eptr = path_ext(path);
    if (*ext != '.')
	*eptr++ = '.';
    strcpy(eptr, ext);
    return path;
}


/* add_extn() - Add or replace a numeric file extension
 */

char *
add_extn(char *path, unsigned numbr)
{
    char eext[16];
    sprintf(eext, "%03u", numbr);
    return add_ext(path, eext);
}
