/* $Id: filetrun.c,v 1.1.1.1 1996/10/09 11:25:21 davidn Exp $
 * File truncation
 *
 */

#include <stdlib.h>
#include "osdep.h"
#include "posix.h"

#if defined(DOSISH) && !defined(__EMX__)
#ifdef __OS2__
#define INCL_DOS
#include <os2.h>
#else
#include <dos.h>
#endif
#endif

int
file_truncate(int fd, unsigned long atofs)
{
#if defined(__EMX__) || !defined(DOSISH)
    return ftruncate(fd, atofs);
#elif defined(__OS2__)
#ifdef __FLAT__
    return DosSetFileSize(fd, atofs) == 0 ? 0 : -1;
#else
    return DosNewSize(fd, atofs) == 0 ? 0 : -1;
#endif
#elif defined(DOSISH)
    if (lseek(fd, atofs, SEEK_SET) == atofs) {	/* Need raw write to force 0
						 * byte write */
	unsigned x;
	return _dos_write(fd, NULL, 0, &x) == 0 ? 0 : -1;
    }
    return -1;
#endif
}
