/* $Id: cmdtpl.h,v 1.1.1.1 1996/10/09 11:14:23 davidn Exp $
 * Template substitution interface
 * Includes running a command template
 *
 */

#ifndef _cmdtpl_h
#define _cmdtpl_h

#define TPLPFX  '%'		/* Prefix for template strings */

typedef struct _cmdtpl {	/* -- defines a template character -- */
    char key;			/* Key character, the one following the prefix */
#define TC_STD    0x00		/* Standard substitution */
#define TC_WORD   0x01		/* Break up string into words, individually
				 * substitute */
#define TC_TEMP   0x02		/* Break up string, place in a temporary file,
				 * subst tempfilename */
#define TC_DIR    0x03		/* Get directory part of arg path */
#define TC_NAME   0x04		/* Get name part of arg path */
#define TC_BASE   0x05		/* Name part of arg without extension */
#define TC_EXT    0x06		/* Get file extension name of arg path */
#define TC_LAST   0xff		/* Array terminator */
    unsigned char flags;	/* Template flags */
    short len;
    char const *arg;		/* Arg string */
    char *work;			/* Work buffer */
}   cmdtpl;

char *tpl_make(char const * tpl, cmdtpl * substinfo, int maxbuf);
void tpl_dealloc(char *buf, cmdtpl * substinfo);
int tpl_exec(char const * tpl, cmdtpl * substinfo);
#endif
