/* $Id: checknl.h,v 1.1.1.1 1996/10/09 11:14:13 davidn Exp $
 * check_nodeent()
 * Checks a nodelist entry and returns possible error codes
 *
 */

#ifndef _checknl_h
#define _checknl_h

#include "fidoaddr.h"
#include "array.h"
#include "txtbuf.h"

#define MAXLINE 2048		/* Maximum length of a nodelist line */

#define NE_OK        0x00000000L/* Entry is OK */

#define NE_SPACE     (0x00000001L|NE_ERRORENT)	/* Contains spaces (illegal) */
#define NE_8BITCTRL  (0x00000002L|NE_SKIPENT)	/* Contains 8bit or ctrl chrs */
#define NE_LONG      (0x00000004L|NE_SKIPENT)	/* Field is too long? */
#define NE_NOFIELDS  (0x00000008L|NE_ERRORENT)	/* Not enough fields */
#define NE_NODENUM   (0x00000010L|NE_ERRORENT)	/* Illegal node number */
#define NE_PHONECHR  (0x00000020L|NE_ERRORENT)	/* Illegal chrs in phone number */
#define NE_PHONEPART (0x00000040L|NE_ERRORENT)	/* Parts in phone number
						 * incorrect */
#define NE_KEYWORD   (0x00000080L|NE_ERRORENT)	/* Unknown leading keyword */
#define NE_BAUDRATE  (0x00000100L|NE_ERRORENT)	/* Illegal baud rate */
#define NE_DUPEFLAG  (0x00000200L|NE_ERRORENT)	/* Duplicated flag */
#define NE_UREPEAT   (0x00000400L)	/* Redundant 'U' repeated */
#define NE_ILLFLAG   (0x00000800L)	/* Illegal/unknown flag */
#define NE_NODEDUPE  (0x00001000L|NE_ERRORENT)	/* Duplicate node number */
#define NE_NETDUPE   (0x00002000L|NE_ERRORENT)	/* Duplicated network */
#define NE_PVTERR    (0x00010000L|NE_ERRORENT)	/* Private is invalid here */
#define NE_PVTALLW   (0x00020000L|NE_ERRORENT)	/* Pvt nodes are not allowed */
#define NE_TRCOMMA   (0x00040000L)	/* Entry has trailing comma */
#define NE_NOTRED    (0x00080000L)	/* Non-redundant admin */
 /* --- Node Status --- */
#define NE_ISHOLD    0x00100000L/* Node is currently Held */
#define NE_ISDOWN    0x00200000L/* Node is currently 'down' */
#define NE_ISPVT     0x00400000L/* Node is a Pvt system */
#define NE_OGATE     0x00800000L/* Node is an OGate */
#define NE_HUB       0x01000000L/* Node is a hub entry */
#define NE_NET       0x02000000L/* Start of a new network */
#define NE_REGION    0x04000000L/* Start of a new region */
#define NE_ZONE      0x08000000L/* Start of a new zone */
 /* --- Error actions --- */
#define NE_NOACTION  0x0fffffffL
#define NE_SKIPENT   0x10000000L/* DON'T generate output */
#define NE_ERRORENT  0x20000000L/* Flag as error in output */

/*
 * Enumerator for fields in a nodelist entry
 */

enum _nlfields {
    N_KWD,			/* Keyword */
    N_NUMBER,			/* Number */
    N_SYSNAME,			/* System Name */
    N_LOCATION,			/* System location */
    N_SYSOP,			/* Name of system operator */
    N_PHONE,			/* Phone number */
    N_BAUDRATE,			/* Nominal baud rate */
    N_FLAGS,			/* Flags */
    N_max
};
/* Defines the type of nodelist processing, and
 * the type of nodelist to produce
 */

enum _nltype {
    NL_NONE = -1,
    NL_HUB = 0,
    NL_NET,
    NL_REGION,
    NL_ZONE,
    NL_COMPOSITE
};
/* Disposition of pvt nodes
 */

enum _pvt {
    PVT_OK,			/* Pvt nodes allowed within next */
    PVT_NONE,			/* Pvt nodes not allowed, assume error */
    PVT_HUB,			/* Pvt nodes made open, phone number from ZC */
    PVT_NET,			/* Pvt nodes made open, phone number from RC */
    PVT_REGION,			/* Pvt nodes made open, phone number from NC */
    PVT_ZONE			/* Pvt nodes made open, phone number from HUB
				 * or NC */
};
/* Disposition of unknown flags
 */

enum _flagact {
    FLAG_IGNORE = 0x00,		/* Ignore errors completely */
    FLAG_REMOVE = 0x01,		/* Remove invalid flags (default) */
    FLAG_ERROR = 0x02,		/* Mark error in output file */
    FLAG_DELIST = 0x10,		/* Comment out in output file */
    FLAG_SKLIST = 0x20		/* Remove node entirely from output file */
};
/* Message prefixes used in error reporting */

#define NM_BASE     ' '
 /* Msg type */
#define NM_ERROR    0x01	/* Error status */
#define NM_WARNING  0x02	/* Warning status */
#define NM_RECEIPT  0x04	/* Receipt */
#define NM_NOLINE   0x08	/* Not error line */
 /* Msg disposition */
#define NM_LOG      0x10	/* Write msg to log */
#define NM_LIST     0x20	/* Output to nodelist */
#define NM_FEEDBACK 0x40	/* Feedback to origin */

#define nm_error(disp)      (NM_ERROR|(disp))
#define nm_warning(disp)    (NM_WARNING|(disp))
#define nm_receipt(disp)    (NM_RECEIPT|NM_FEEDBACK|(disp))

#define nm_type(f)          (NM_BASE | (f))
#define nm_flag(f)          ((f) - NM_BASE)
#define nm_isset(f,v)       (((f) - NM_BASE) & (v))
#define nm_notset(f,v)      (!(((f) - NM_BASE) & (v)))

int add_flag(char const * flag);/* Add a 'legal' flag */
int add_uflag(char const * flag);	/* Add a 'U' flag (U is assumed) */

void 
init_nlinfo(int pmin,		/* Min parts in phone # */
	    int pmax,		/* Max parts in phone # */
	    int pdisp,		/* Pvt node disposition */
	    char const * bauds,	/* Valid baud rates */
	    node_t zone,	/* Starting zone # */
	    node_t net,		/* Starting net # */
	    unsigned char flagh,/* Flag disposition */
	    unsigned char uflagh,	/* Userflag disposition */
	    unsigned char phoneh);	/* Phone # tracking */

unsigned long check_nodeent(txtbuf * errs, char *txtaddr, char **line, int *plen, ZNNP * addr);

int valid_nl_line(char const * line, enum _nltype listcontext, enum _nltype * context);
#endif
