/* $Id: array.h,v 1.1.1.1 1996/10/09 11:13:50 davidn Exp $
 * Array manager implementation
 *
 */

#ifndef _array_h
#define _array_h

#include "mem.h"

#define NOELEMENT ((arrindex)-1)

typedef unsigned arrindex;

enum {
    LAST = 0,
    FIRST = 1,
    PREV = 2,
    NEXT = 3,
    CURR = 4
};

typedef struct _array {
    char *base;			/* Base of array */
    unsigned elsize;		/* Size of one element */
    arrindex asize,		/* Current size of array (in elements) */
        aused;			/* Number of elements used */
}   Array;
/* Allocate/delete arrays from the heap */
Array *array_new(unsigned elsize, arrindex isize);	/* Allocate a new array */
void array_delete(Array * A);	/* Free an array */
/* Initialise/deinitialise static/local arrays */
Array *array_init(Array * A, unsigned elsize, arrindex isize);
void array_destroy(Array * A);
/* Add element to array */
arrindex array_add(Array * A, arrindex where, unsigned elems);
arrindex array_del(Array * A, arrindex where, unsigned elems);
void *array_ptr(Array * A, arrindex idx);	/* Get pointer to an element */
void array_reset(Array * A);
void array_setsize(Array * A, arrindex idx);
#define array_items(A)    ((A)->aused)

typedef struct _array_iter {
    Array *A;
    arrindex index;
}   ArrayIter;

void arrayIter_init(ArrayIter * I, Array * A);	/* Array iterator */
void *arrayIter_get(ArrayIter * I, int which);	/* Get an element */
#define arrayIter_at(I)     ((I)->index)
#define arrayIter_reset(I)  ((I)->index = NOELEMENT)


#ifdef __16BITSEGMENTED__

/* _harray: 'huge' array (multisegment)
 * This is only necessary for memory impoverished 16-bit environments
 */

typedef struct _harray {
    char huge *base;		/* Base of array */
    unsigned elsize;		/* Size of one element */
    arrindex asize,		/* Current size of array (in elements) */
        aused;			/* Number of elements used */
    unsigned cellsize,		/* Size of one cell */
        cellsps;		/* Number of cells in one segment */
}   HArray;
HArray *harray_new(unsigned elsize, unsigned isize);
HArray *harray_init(HArray * A, unsigned elsize, arrindex isize);
void harray_delete(HArray * A);
void harray_destroy(HArray * A);
arrindex harray_add(HArray * A, arrindex where, unsigned elems);
arrindex harray_del(HArray * A, arrindex where, unsigned elems);
void far *harray_ptr(HArray * A, arrindex index);
#define harray_items(A)   ((A)->aused)

typedef struct _harray_iter {
    HArray *A;
    arrindex index;
}   HArrayIter;
void harrayIter_init(HArrayIter * I, HArray * A);	/* Array iterator */
void far *harrayIter_get(HArrayIter * I, int which);	/* Get an element */
#define harrayIter_at(I)      ((I)->index)
#define harrayIter_reset(I)   ((I)->index = NOELEMENT)

#else

typedef Array HArray;
#define harray_new(e,i)       array_new(e,i)
#define harray_init(A,e,i)    array_init(A,e,i)
#define harray_delete(A)      array_delete(A)
#define harray_destroy(A)     array_destroy(A)
#define harray_add(A,w,e)     array_add(A,w,e)
#define harray_del(A,w,e)     array_del(A,w,e)
#define harray_ptr(A,i)       array_ptr(A,i)
#define harray_items(A)       array_items(A)
typedef ArrayIter HArrayIter;
#define harrayIter_init(I,A)  arrayIter_init(I, A)
#define harrayIter_get(I,w)   arrayIter_get(I, w)
#define harrayIter_at(I)      ((I)->index)
#define harrayIter_reset(I)   ((I)->index = NOELEMENT)
#ifndef far
#define far
#endif
#endif

#endif
