/*    AHATCH.CMD - REXX Automatic Hatch procedure, will release uploaded     */
/*                 files (via FILES.BBS) into a Tick area.                   */
/*                 Version: 2.2, date: 12-22-1992                            */
/*                              Ŀ                           */
/*                              V                                           */
/*    Usage: AHATCH  area Ĵ      */
/*                    /A     /Ccfg Ĵ    drive   path         */
/*                                 /Ttmp Ĵ                             */
/*                                 /Bfbbs Ĵ                             */
/*                                 /Ddup Ĵ                             */
/*                                 /R Ĵ                             */
/*                                 /Ffile                              */
/*     where  : area    - Tick area name                                     */
/*              /A      - Hatch the file in an alternate area, check for     */
/*                        [A:area] at the beginning of the description (must */
/*                        precede [R:file] if used), when not used [A:area]  */
/*                        will remain in the description                     */
/*              /Ccfg   - the name and location of the Tick/Hatch config     */
/*                        file default will be that of Hatch itself          */
/*              /Ttmp   - the name and location of the temporary ahatch file */
/*                        default will be AHATCH.TMP in the current dir      */
/*              /Bfbbs  - the name of FILES.BBS, located in drive/path       */
/*              /Ddup   - file containing already released filenames;        */
/*                        dupcheck will not include file extension unless    */
/*                        the extension contains a (sequence-)number         */
/*              /R      - use the Hatch replace file function, check for     */
/*                        [R:file] at the beginning of the description (but  */
/*                        after [A:area] part), when not used [R:file] will  */
/*                        remain in the description                          */
/*              /Ffile  - one file to hatch from FILES.BBS (no path)         */
/*              drive   - drive where file and FILES.BBS resides (default    */
/*                        current drive)                                     */
/*              path    - directory path where file and FILES.BBS resides    */
/*                        (default current path)                             */
/*     example: AHATCH OS2NEW C:\FILE\FERNUP                                 */
/*              will release all files in C:\FILE\FERNUP into area OS2NEW    */
/*                                                                           */
/* Author:      Marcel Stikkelman                                            */
/*              PC-Square, the BBS of the IBM PCPC, the Netherlands          */
/*              FidoNet node 2:512/4                                         */
/*              Data +31-79-424107                                           */

ver_no    = "2.2"            /* AHATCH version number */
ver_date  = "12-21-1992"     /* AHATCH version date */
progname  = "AHATCH"         /* AHATCH program name for display purposes */
hatchname = "HATCHP.EXE"     /* hatch program to be started for hatching */
hatchopt  = "/r0"            /* hatch command line option (release now) */
filebbs   = "FILES.BBS"      /* name of file-list file */
confdef   = "TIC.CFG"        /* Hatch default config file */
rdirfile  = "AHATCH.TMP"     /* Startup: Hatch < rdirfile instead of /d */
/*rdirfile  = "" */          /* parameter, set to "" for full parameter use */

TRUE = 1==1
FALSE = 1==2

PARSE ARG arg.1 arg.2 arg.3 arg.4 arg.5 arg.6 arg.7 arg.8 arg.9 .
lastarg = 9

/* check command line parameters */
IF arg.1 == '' | arg.1 == '-?' | arg.1 == '?' | arg.1 == '/?' | arg.1 == '-H' THEN
  SIGNAL HELP

/* default values */
config    = confdef
dupfile   = ''
onefile   = ''
path      = ''
replace   = FALSE
alterarea = FALSE

area = arg.1       /* tick area name */
/* check if alternate area */
IF TRANSLATE(area) == '/A' THEN
DO
  alterarea = TRUE
  area = ''
END

DO cnt = 2 TO lastarg while LEFT(arg.cnt,1) == '/'
  cmd = TRANSLATE(LEFT(arg.cnt,2))
  IF cmd == '/C' THEN             /* check if config */
    config    = STRIP(SUBSTR(arg.cnt,3,LENGTH(arg.cnt)-2))
  ELSE IF cmd == '/T' THEN        /* check if rdirfile */
    rdirfile  = STRIP(SUBSTR(arg.cnt,3,LENGTH(arg.cnt)-2))
  ELSE IF cmd == '/B' THEN        /* check if filebbs */
    filebbs   = STRIP(SUBSTR(arg.cnt,3,LENGTH(arg.cnt)-2))
  ELSE IF cmd == '/D' THEN        /* check if one file hatch */
    dupfile   = STRIP(SUBSTR(arg.cnt,3,LENGTH(arg.cnt)-2))
  ELSE IF cmd == '/R' THEN        /* check if use replace option */
    replace   = TRUE
  ELSE IF cmd == '/F' THEN        /* check if one file hatch */
    onefile   = STRIP(SUBSTR(arg.cnt,3,LENGTH(arg.cnt)-2))
  ELSE
  DO
    SAY "-> Parse error:" arg.cnt
    SIGNAL HELP
  END
END
if cnt <= lastarg THEN
  path = STRIP(arg.cnt)      /* remove blanks from path (last argument) */

IF path == '' | RIGHT(path,1) == ':' THEN   /* add . if no path or drive */
  path = path || "."
IF LENGTH(path) > 0 & SUBSTR(path,LENGTH(path),1) \== '\' THEN
  path = path || "\"                        /* add \ if needed */

filesbbs = path || filebbs
IF STREAM(filesbbs, 'C', 'QUERY EXISTS') == '' THEN  /* check for FILES.BBS */
DO
  IF path == '.\' THEN
    path = 'the current directory'
  SAY "No" filebbs "found in" path"."
  SAY progname "aborted."
  EXIT 1
END

IF (STREAM(config, 'C', 'QUERY EXISTS') == '') THEN  /* check for config */
DO
  SAY "Tick configuration file" config "not found."
  SAY progname "aborted."
  EXIT 1
END

IF (dupfile \== '') THEN
  IF (STREAM(dupfile, 'C', 'QUERY EXISTS') == '') THEN  /* check for dupfile */
  DO
    SAY "No duplicate file" dupfile "found."
    SAY progname "aborted."
    EXIT 1
  END

IF \alterarea THEN
DO
  /* get area path of Tick area from config file */
  areapath = ''
  searchfor = TRANSLATE(area)
  DO WHILE areapath == '' & LINES(config)
    PARSE UPPER VALUE LINEIN(config) WITH "AREA" dir tickarea .
    IF tickarea == searchfor THEN
      areapath = dir
  END
  IF areapath == '' THEN       /* if no path was found */
  DO
    SAY "Tick area" area "not found in" config"."
    SAY progname "aborted."
    EXIT 1
  END
END

numhatched = 0
IF \alterarea THEN
  SAY "Hatching into area" area":"
ELSE
  prevarea = '_$_'
/* scan through FILES.BBS */
DO WHILE LINES(filesbbs)
  inline = LINEIN(filesbbs)
  /* skip comment and empty lines */
  DO WHILE LINES(filesbbs) & (LEFT(inline,1) == ' ' | LEFT(inline,1) == '')
    inline = LINEIN(filesbbs)
  END
  DO
    /* get filename and description from parseline */
    PARSE VAR inline filename description
    filename = STRIP(filename)
    /* skip empty filenames */
    IF filename \== '' & (onefile == '' | TRANSLATE(onefile) == TRANSLATE(filename)) THEN
    DO
      /* add path to original filename */
      hatchfile = path || filename
      /* check if file exists in path (if not: probably hatched previously) */
      IF STREAM(hatchfile, 'C', 'QUERY EXISTS') \== '' THEN
      DO
        IF alterarea THEN
        DO
          PARSE VAR description WITH '[A:' area ']' altdesc
          IF area == '' THEN
            PARSE VAR description WITH '[a:' area ']' altdesc
          IF area \== '' THEN
          DO
            area = STRIP(area)
            description = STRIP(altdesc)
            IF TRANSLATE(area) \== prevarea THEN
            DO
              /* get area path of Tick area from config file */
              areapath = ''
              searchfor = TRANSLATE(area)
              DO WHILE areapath == '' & LINES(config)
                PARSE UPPER VALUE LINEIN(config) WITH "AREA" dir tickarea .
                IF tickarea == searchfor THEN
                  areapath = dir
              END
              prevarea = TRANSLATE(area)
              IF STREAM(config, 'C', 'CLOSE') \== 'READY:' THEN
              DO
                SAY "Error closing Tick configuration file" config"."
                SAY progname "aborted."
                EXIT 1
              END
            END
            IF areapath == '' THEN       /* if no path was found */
            DO
              SAY "Tick area" area "not found in" config" for" filename"."
              area = ''
            END
          END
          ELSE
            SAY filename "has no area assigned."
        END
        IF area \== '' THEN
        DO
          /* add path to hatch (target) filename */
          tofile = areapath || "\" || filename
          dotpos = POS('.',filename)
          IF dotpos > 0 THEN
          DO
            /* check if extension has sequence# in it, then do full namecheck */
            dupname = ''
            tpos = dotpos + 1
            DO WHILE dupname = '' & tpos <= LENGTH(filename)
              IF POS(SUBSTR(filename,tpos,1),"0123456789") > 0 THEN
              DO
                dupname  = filename
                globname = dupname
              END
              tpos = tpos + 1
            END
            IF dupname = '' THEN
            DO
              dupname  = LEFT(filename,dotpos)
              globname = dupname || "*"
            END
          END
          ELSE
          DO
            dupname  = filename || "."
            globname = dupname || "*"
          END
          globfile = areapath || "\" || globname
          /* check if no duplicate filename in hatch area exists */
          IF STREAM(globfile, 'C', 'QUERY EXISTS') == '' THEN
          DO
            /* check if no duplicate filename in dupfile exists */
            found = 'N'
            IF dupfile \== '' THEN
            DO
              searchfor = TRANSLATE(dupname)
              dupline = LINEIN(dupfile,1,0)
              IF searchfor == TRANSLATE(LEFT(dupline, LENGTH(searchfor))) THEN
                found = 'Y'
              DO WHILE LINES(dupfile) & (found == 'N')
                dupline = LINEIN(dupfile)
                IF searchfor == TRANSLATE(LEFT(dupline, LENGTH(searchfor))) THEN
                  found = 'Y'
              END
            END
            IF found == 'N' THEN
            DO
              description = STRIP(description)
              /* check for replace filename */
              IF replace THEN
              DO
                PARSE VAR description WITH '[R:' repfile ']' repdesc
                IF repfile == '' THEN
                  PARSE VAR description WITH '[r:' repfile ']' repdesc
                IF repfile \== '' THEN
                DO
                  repfile = STRIP(repfile)
                  description = STRIP(repdesc)
                END
                ELSE
                  repfile = filename
              END
              ELSE
                repfile = filename
              /* skip file entries with no descriptions */
              IF description \== '' THEN
              DO
                /* copy file to be hatched */
                "@COPY" hatchfile tofile "> NUL:"
                /* hatch /o<no input asked> /r<release now> /f<filename> /x<repfile> /d<desr> */
                /* pity hatch isn't silent (I don't show off while running) */
                IF rdirfile == '' THEN
                  "@"hatchname hatchopt "/c"config "/a"area "/f"filename "/x"repfile "/d"description "> NUL:"
                ELSE
                DO
                  /* delete (and be sure) rdirfile */
                  "@IF EXIST" rdirfile "DEL" rdirfile "> NUL:"
                  IF STREAM(rdirfile, 'C', 'QUERY EXISTS') == '' THEN
                  DO
                    /* write description into rdirfile */
                    IF LINEOUT(rdirfile, STRIP(LEFT(description,255))) \== '' THEN
                    DO
                      IF STREAM(rdirfile, 'C', 'CLOSE') == 'READY:' THEN
                        "@"hatchname hatchopt "/c"config "/a"area "/f"filename "/x"repfile "<" rdirfile "> NUL:"
                      ELSE
                        rc = 999
                    END
                    ELSE
                      rc = 999
                  END
                  ELSE
                    rc = 999
                END
                IF rc == 0 THEN    /* check errorlevel of hatch */
                DO    /* delete orignal file from upload area */
                  "@IF EXIST" tofile "DEL" hatchfile "> NUL:"
                  IF alterarea THEN
                    SAY filename "into area" area
                  ELSE
                    SAY filename
                  numhatched = numhatched + 1
                END
                ELSE
                DO                 /* report hatch error */
                  IF rc == 1 THEN
                    hatcherror = "Error reading a file"
                  ELSE IF rc == 2 THEN
                    hatcherror = "Error writing a file"
                  ELSE IF rc == 3 THEN
                    hatcherror = "Out of Memory"
                  ELSE IF rc == 4 THEN
                    hatcherror = "Invalid CFG file"
                  ELSE IF rc == 5 THEN
                    hatcherror = "Invalid PATH or filespec"
                  ELSE IF rc == 6 THEN
                    hatcherror = "Processing Error"
                  ELSE
                    hatcherror = "errorlevel" rc
                  IF rc == 999 THEN
                    SAY "Error accessing" rdirfile "for hatching description of" filename"."
                  ELSE
                    SAY "Hatch" '"'hatcherror'"' "while hatching" filename "into area" area"."
                  /* restore situtation by deleting hatchfile (so the
                     file will be hatched again next time if possible) */
                  "@IF EXIST" hatchfile "DEL" tofile "> NUL:"
                END
              END
              ELSE
                SAY filename "has no description."
            END
            ELSE
              SAY dupname"* found in" dupfile"."
          END
          ELSE
            SAY globname "already exists in" areapath"."
        END
      END
    END
  END
END
SAY "Number of files hatched:" numhatched

IF rdirfile \== '' THEN
  "@IF EXIST" rdirfile "DEL" rdirfile "> NUL:"

EXIT 0


HELP:
  SAY "   AHATCH.CMD - Automatic Hatch procedure, will release uploaded"
  SAY "                files (via" filebbs") into a Tick area."
  SAY "                Version:" ver_no", date:" ver_date"."
  SAY "                              Ŀ"
  SAY "                                              "
  SAY "    Usage: AHATCH  area Ĵ"
  SAY "                    /A     /Ccfg Ĵ    drive   path "
  SAY "                                 /Ttmp Ĵ"
  SAY "                                 /Bfbbs Ĵ"
  SAY "                                 /Ddup Ĵ"
  SAY "                                 /R Ĵ"
  SAY "                                 /Ffile "
  SAY "    where  : area    - Tick area name"
  SAY "             /A      - Hatch the file in an alternate area, check for"
  SAY "                       [A:area] at the beginning of the description (must"
  SAY "                       precede [R:file] if used), when not used [A:area]"
  SAY "                       will remain in the description"
  SAY "             /Ccfg   - the name and location of the Tick/Hatch config file"
  SAY "             /Ttmp   - the name and location of the temporary ahatch file"
  SAY "             /Bfbbs  - the name of FILES.BBS, located in drive/path"
  SAY "             /Ddup   - dupfile containing already released filenames"
  SAY "             /R      - use the Hatch replace file function, check for"
  SAY "                       [R:file] at the beginning of the description (but"
  SAY "                       after [A:area] part), when not used [R:file] will"
  SAY "                       remain in the description"
  SAY "             /Ffile  - one file to hatch from" filebbs "(no path)"
  SAY "             drive   - drive where file and" filebbs "resides (default"
  SAY "                       current drive)"
  SAY "             path    - directory path where file and" filebbs "resides"
  SAY "                       (default current path)"
EXIT 1
