;; ************************************************************************
;; LL_KBD (tm) Lord Logics' Key ASCII/SCAN Conversions Data Tables
;; Copyright (C) 1994 - Logics Inc. [J.P.K.]  All rights reserved.
;; ************************************************************************
;; NOTE:    For SYSTEM Keys, a "system" prefix is attatched to the keyboard
;;          buffer of 0xC0.  This follows the same idea of the 0xE0 of the
;;          extended keystrokes.  There was no convention for buffering the
;;          system control keys, so I made this one.
;; **  D A T A	***********************************************************
DGROUP	group	_DATA
_DATA   segment 'DATA'
                ;; Control Keystroke Table [for CONVERT mode]   (9)
                ;; NOTE:    These are listed in SCAN Code
Control         db 038h     ;; L_ALT
                db 01dh     ;; L_CTRL
                db 02ah     ;; L_SHIFT
                db 036h     ;; R_SHIFT
                db 03ah     ;; CAPS
                db 045h     ;; NUMLOCK
                db 046h     ;; SCRLOCK
                db 05ch     ;; R_ALT
                db 05ah     ;; R_CTRL

                ;; Extended Two-Byte Keystroke Table        	(16)
                ;; NOTE:    Most of these are from the Cursor/Control
                ;;      	cluster
Extended        db 057h     ;; F11      (EXTENDED)
                db 058h     ;; F12      (EXTENDED)
                db 01ch     ;; ENTER    (CLUSTER)
                db 01dh     ;; CTRL     (RIGHT)
                db 035h     ;; GRAY /   (CLUSTER)
                db 038h     ;; ALT      (RIGHT)
                db 047h     ;; HOME     (CLUSTER)
                db 048h     ;; UP       (CLUSTER)
                db 049h     ;; PGUP     (CLUSTER)
                db 04bh     ;; LEFT     (CLUSTER)
                db 04dh     ;; RIGHT    (CLUSTER)
                db 04fh     ;; END      (CLUSTER)
                db 050h     ;; DOWN     (CLUSTER)
                db 051h     ;; PGDN     (CLUSTER)
                db 052h     ;; INS      (CLUSTER)
                db 053h     ;; DEL      (CLUSTER)

                ;; ASCII in SCAN order
FromSCAN_NON    dw 00000h     ;; NULL     00
                dw 0001Bh     ;; ESC      01
                dw 00031h     ;; 1        02
                dw 00032h     ;; 2        03
                dw 00033h     ;; 3        04
                dw 00034h     ;; 4        05
                dw 00035h     ;; 5        06
                dw 00036h     ;; 6        07
                dw 00037h     ;; 7        08
                dw 00038h     ;; 8        09
                dw 00039h     ;; 9        0A
                dw 00030h     ;; 0        0B
                dw 0002dh     ;; -        0C
                dw 0003dh     ;; =        0D
                dw 00008h     ;; BKSP     0E
                dw 00009h     ;; TAB      0F
                dw 00071h     ;; q        10
                dw 00077h     ;; w        11
                dw 00065h     ;; e        12
                dw 00072h     ;; r        13
                dw 00074h     ;; t        14
                dw 00079h     ;; y        15
                dw 00075h     ;; u        16
                dw 00069h     ;; i        17
                dw 0006Fh     ;; o        18
                dw 00070h     ;; p        19
                dw 0005bh     ;; [        1A
                dw 0005dh     ;; ]        1B
                dw 0000dh     ;; ENTER    1C
                dw 001f0h     ;; CTRL     1D
                dw 00061h     ;; a        1E
                dw 00073h     ;; s        1F
                dw 00064h     ;; d        20
                dw 00066h     ;; f        21
                dw 00067h     ;; g        22
                dw 00068h     ;; h        23
                dw 0006ah     ;; j        24
                dw 0006bh     ;; k        25
                dw 0006ch     ;; l        26
                dw 0003bh     ;; ;        27
                dw 00027h     ;; '        28
                dw 00060h     ;; `        29
                dw 003f0h     ;; L_SHIFT  2A
                dw 0005ch     ;; \        2B
                dw 0007ah     ;; z        2C
                dw 00078h     ;; x        2D
                dw 00063h     ;; c        2E
                dw 00076h     ;; v        2F
                dw 00062h     ;; b        30
                dw 0006eh     ;; n        31
                dw 0006dh     ;; m        32
                dw 0002ch     ;; ,        33
                dw 0002eh     ;; .        34
                dw 0002fh     ;; /        35
                dw 004f0h     ;; R_SHIFT  36
                dw 0002ah     ;; PRTSC    37
                dw 005f0h     ;; ALT      38
                dw 00020h     ;; SPC      39
                dw 007f0h     ;; CAPS     3A
                dw 03b00h     ;; F1       3B
                dw 03c00h     ;; F2       3C
                dw 03d00h     ;; F3       3D
                dw 03e00h     ;; F4       3E
                dw 03f00h     ;; F5       3F
                dw 04000h     ;; F6       40
                dw 04100h     ;; F7       41
                dw 04200h     ;; F8       42
                dw 04300h     ;; F9       43
                dw 04400h     ;; F10      44
                dw 008f0h     ;; NUMLCK   45
                dw 009f0h     ;; SCRLOCK  46
                dw 04700h     ;; HOME     47
                dw 04800h     ;; UP       48
                dw 04900h     ;; PGUP     49
                dw 00af0h     ;; GRAY-    4A
                dw 04b00h     ;; LEFT     4B
                dw 04c00h     ;; CENTER   4C
                dw 04d00h     ;; RIGHT    4D
                dw 00bf0h     ;; GRAY+    4E
                dw 04f00h     ;; END      4F
                dw 05000h     ;; DOWN     50
                dw 05100h     ;; PGDN     51
                dw 05200h     ;; INS      52
                dw 05300h     ;; DEL      53
                dw 00000h     ;; NOTHING  54
                dw 00000h     ;; NOTHING  55
                dw 00000h     ;; NOTHING  56
                dw 085e0h     ;; F11      57
                dw 086e0h     ;; F12      58
                dw 00de0h     ;; C ENTER  1C 59
                dw 002f0h     ;; R CTRL   1D 5A
                dw 02fe0h     ;; C /      35 5B
                dw 006f0h     ;; R ALT    38 5C
                dw 047e0h     ;; C HOME   47 5D
                dw 048e0h     ;; C UP     48 5E
                dw 049e0h     ;; C PGUP   49 5F
                dw 04be0h     ;; C LEFT   4B 60
                dw 04de0h     ;; C RIGHT  4D 61
                dw 04fe0h     ;; C END    4F 62
                dw 050e0h     ;; C DOWN   50 63
                dw 051e0h     ;; C PGDN   51 64
                dw 052e0h     ;; C INS    52 65
                dw 053e0h     ;; C DEL    53 66

                ;; ALT+Keystroke SCAN/ASCII Conversion
FromSCAN_ALT    dw 00100h     ;; NULL     00
                dw 07800h     ;; ESC      01
                dw 07900h     ;; !        02
                dw 07a00h     ;; @        03
                dw 07b00h     ;; #        04
                dw 07c00h     ;; $        05
                dw 07d00h     ;; %        06
                dw 07e00h     ;; ^        07
                dw 07f00h     ;; &        08
                dw 08000h     ;; *        09
                dw 08100h     ;; (        0A
                dw 08200h     ;; )        0B
                dw 08300h     ;; _        0C
                dw 00e00h     ;; +        0D
                dw 0a500h     ;; BKSP     0E
                dw 01000h     ;; BAKTAB   0F
                dw 01100h     ;; Q        10
                dw 01200h     ;; W        11
                dw 01300h     ;; E        12
                dw 01400h     ;; R        13
                dw 01500h     ;; T        14
                dw 01600h     ;; Y        15
                dw 01700h     ;; U        16
                dw 01800h     ;; I        17
                dw 01900h     ;; O        18
                dw 01a00h     ;; P        19
                dw 01b00h     ;; {        1A
                dw 01c00h     ;; }        1B
                dw 0a600h     ;; ENTER    1C
                dw 001f0h     ;; CTRL     1D
                dw 01e00h     ;; A        1E
                dw 01f00h     ;; S        1F
                dw 02000h     ;; D        20
                dw 02100h     ;; F        21
                dw 02200h     ;; G        22
                dw 02300h     ;; H        23
                dw 02400h     ;; J        24
                dw 02500h     ;; K        25
                dw 02600h     ;; L        26
                dw 02700h     ;; :        27
                dw 02800h     ;; "        28
                dw 02900h     ;; ~        29
                dw 003f0h     ;; L_SHIFT  2A
                dw 00000h     ;; |        2B
                dw 02c00h     ;; Z        2C
                dw 02d00h     ;; X        2D
                dw 02e00h     ;; C        2E
                dw 02f00h     ;; V        2F
                dw 03000h     ;; B        30
                dw 03100h     ;; N        31
                dw 03200h     ;; M        32
                dw 03300h     ;; <        33
                dw 03400h     ;; >        34
                dw 03400h     ;; ?        35
                dw 004f0h     ;; R_SHIFT  36
                dw 00000h     ;; PRTSC    37
                dw 005f0h     ;; ALT      38
                dw 02000h     ;; SPC      39
                dw 007f0h     ;; CAPS     3A
                dw 06800h     ;; F1       3B
                dw 06900h     ;; F2       3C
                dw 06a00h     ;; F3       3D
                dw 06b00h     ;; F4       3E
                dw 06c00h     ;; F5       3F
                dw 06d00h     ;; F6       40
                dw 06e00h     ;; F7       41
                dw 06f00h     ;; F8       42
                dw 07000h     ;; F9       43
                dw 07100h     ;; F10      44
                dw 008f0h     ;; NUMLCK   45
                dw 009f0h     ;; SCRLOCK  46
                dw 09700h     ;; HOME     47
                dw 09800h     ;; UP       48
                dw 09900h     ;; PGUP     49
                dw 00af0h     ;; GRAY-    4A
                dw 09b00h     ;; LEFT     4B
                dw 00000h     ;; CENTER   4C
                dw 09d00h     ;; RIGHT    4D
                dw 00bf0h     ;; GRAY+    4E
                dw 09f00h     ;; END      4F
                dw 0a000h     ;; DOWN     50
                dw 0a100h     ;; PGDN     51
                dw 0a200h     ;; INS      52
                dw 0a300h     ;; DEL      53
                dw 00000h     ;; NOTHING  54
                dw 00000h     ;; NOTHING  55
                dw 00000h     ;; NOTHING  56
                dw 08be0h     ;; F11      57
                dw 08ce0h     ;; F12      58
                dw 0a6e0h     ;; ENTER L  1C
                dw 002f0h     ;; R CTRL L 1D
                dw 0a5e0h     ;; GRAY/ L  35
                dw 006f0h     ;; R ALT L  38
                dw 097e0h     ;; HOME  L  47
                dw 098e0h     ;; UP    L  48
                dw 099e0h     ;; PGUP  L  49
                dw 09be0h     ;; LEFT  L  4B
                dw 09de0h     ;; RIGHT L  4D
                dw 09fe0h     ;; END   L  4F
                dw 0a0e0h     ;; DOWN  L  50
                dw 0a1e0h     ;; PGDN  L  51
                dw 0a2e0h     ;; INS   L  52
                dw 0a3e0h     ;; DEL   L  53

                ;; CTRL+Keystroke SCAN/ASCII Conversion
FromSCAN_CTRL   dw 00000h     ;; NULL     00
                dw 0001Bh     ;; ESC      01
                dw 00000h     ;; 1        02
                dw 00300h     ;; 2        03
                dw 00000h     ;; 3        04
                dw 00000h     ;; 4        05
                dw 00000h     ;; 5        06
                dw 0001eh     ;; 6        07
                dw 00000h     ;; 7        08
                dw 00000h     ;; 8        09
                dw 00000h     ;; 9        0A
                dw 00000h     ;; 0        0B
                dw 0001fh     ;; -        0C
                dw 00000h     ;; =        0D
                dw 0007fh     ;; BKSP     0E
                dw 09400h     ;; TAB      0F
                dw 00011h     ;; q        10
                dw 00017h     ;; w        11
                dw 00005h     ;; e        12
                dw 00012h     ;; r        13
                dw 00014h     ;; t        14
                dw 00019h     ;; y        15
                dw 00015h     ;; u        16
                dw 00009h     ;; i        17
                dw 0000fh     ;; o        18
                dw 00010h     ;; p        19
                dw 0001bh     ;; [        1A
                dw 0001ch     ;; ]        1B
                dw 0000ah     ;; ENTER    1C
                dw 001f0h     ;; CTRL     1D
                dw 00001h     ;; a        1E
                dw 00013h     ;; s        1F
                dw 00004h     ;; d        20
                dw 00006h     ;; f        21
                dw 00007h     ;; g        22
                dw 00008h     ;; h        23
                dw 0000ah     ;; j        24
                dw 0000bh     ;; k        25
                dw 0000ch     ;; l        26
                dw 00000h     ;; ;        27
                dw 00000h     ;; '        28
                dw 00000h     ;; `        29
                dw 003f0h     ;; L_SHIFT  2A
                dw 0001ch     ;; \        2B
                dw 0001ah     ;; z        2C
                dw 00018h     ;; x        2D
                dw 00003h     ;; c        2E
                dw 00016h     ;; v        2F
                dw 00002h     ;; b        30
                dw 0000eh     ;; n        31
                dw 0000dh     ;; m        32
                dw 00000h     ;; ,        33
                dw 00000h     ;; .        34
                dw 00000h     ;; /        35
                dw 004f0h     ;; R_SHIFT  36
                dw 00010h     ;; PRTSC    37
                dw 005f0h     ;; ALT      38
                dw 00020h     ;; SPC      39
                dw 007f0h     ;; CAPS     3A
                dw 05e00h     ;; F1       3B
                dw 05f00h     ;; F2       3C
                dw 06000h     ;; F3       3D
                dw 06100h     ;; F4       3E
                dw 06200h     ;; F5       3F
                dw 06300h     ;; F6       40
                dw 06400h     ;; F7       41
                dw 06500h     ;; F8       42
                dw 06600h     ;; F9       43
                dw 06700h     ;; F10      44
                dw 008f0h     ;; NUMLCK   45
                dw 009f0h     ;; SCRLOCK  46
                dw 07700h     ;; HOME     47
                dw 08d00h     ;; UP       48
                dw 08400h     ;; PGUP     49
                dw 00af0h     ;; GRAY-    4A
                dw 07300h     ;; LEFT     4B
                dw 00000h     ;; CENTER   4C
                dw 07400h     ;; RIGHT    4D
                dw 00bf0h     ;; GRAY+    4E
                dw 07500h     ;; END      4F
                dw 09100h     ;; DOWN     50
                dw 07600h     ;; PGDN     51
                dw 09200h     ;; INS      52
                dw 09300h     ;; DEL      53
                dw 00000h     ;; NOTHING  54
                dw 00000h     ;; NOTHING  55
                dw 00000h     ;; NOTHING  56
                dw 089e0h     ;; F11      57
                dw 08ae0h     ;; F12      58
                dw 0a6e0h     ;; ENTER L  1C
                dw 002f0h     ;; R CTRL L 1D
                dw 095e0h     ;; GRAY/ L  35
                dw 006f0h     ;; R ALT L  38
                dw 077e0h     ;; HOME  L  47
                dw 08de0h     ;; UP    L  48
                dw 084e0h     ;; PGUP  L  49
                dw 073e0h     ;; LEFT  L  4B
                dw 074e0h     ;; RIGHT L  4D
                dw 075e0h     ;; END   L  4F
                dw 091e0h     ;; DOWN  L  50
                dw 076e0h     ;; PGDN  L  51
                dw 092e0h     ;; INS   L  52
                dw 093e0h     ;; DEL   L  53


                ;; SHIFT+Keystroke SCAN/ASCII Conversion
FromSCAN_SHIFT  dw 00000h     ;; NULL     00
                dw 0001Bh     ;; ESC      01
                dw 00021h     ;; !        02
                dw 00040h     ;; @        03
                dw 00023h     ;; #        04
                dw 00024h     ;; $        05
                dw 00025h     ;; %        06
                dw 0005eh     ;; ^        07
                dw 00026h     ;; &        08
                dw 0002ah     ;; *        09
                dw 00028h     ;; (        0A
                dw 00029h     ;; )        0B
                dw 0005fh     ;; _        0C
                dw 0002bh     ;; +        0D
                dw 00008h     ;; BKSP     0E
                dw 00f00h     ;; BAKTAB   0F
                dw 00051h     ;; Q        10
                dw 00057h     ;; W        11
                dw 00045h     ;; E        12
                dw 00052h     ;; R        13
                dw 00054h     ;; T        14
                dw 00059h     ;; Y        15
                dw 00055h     ;; U        16
                dw 00049h     ;; I        17
                dw 0004Fh     ;; O        18
                dw 00050h     ;; P        19
                dw 0007bh     ;; {        1A
                dw 0007dh     ;; }        1B
                dw 0000dh     ;; ENTER    1C
                dw 001f0h     ;; CTRL     1D
                dw 00041h     ;; A        1E
                dw 00053h     ;; S        1F
                dw 00044h     ;; D        20
                dw 00046h     ;; F        21
                dw 00047h     ;; G        22
                dw 00048h     ;; H        23
                dw 0004ah     ;; J        24
                dw 0004bh     ;; K        25
                dw 0004ch     ;; L        26
                dw 0003ah     ;; :        27
                dw 00022h     ;; "        28
                dw 0007eh     ;; ~        29
                dw 003f0h     ;; L_SHIFT  2A
                dw 0007ch     ;; |        2B
                dw 0005ah     ;; Z        2C
                dw 00058h     ;; X        2D
                dw 00043h     ;; C        2E
                dw 00056h     ;; V        2F
                dw 00042h     ;; B        30
                dw 0004eh     ;; N        31
                dw 0004dh     ;; M        32
                dw 0003ch     ;; <        33
                dw 0003eh     ;; >        34
                dw 0003fh     ;; ?        35
                dw 004f0h     ;; R_SHIFT  36
                dw 0002ah     ;; PRTSC    37
                dw 005f0h     ;; ALT      38
                dw 00020h     ;; SPC      39
                dw 007f0h     ;; CAPS     3A
                dw 05400h     ;; F1       3B
                dw 05500h     ;; F2       3C
                dw 05600h     ;; F3       3D
                dw 05700h     ;; F4       3E
                dw 05800h     ;; F5       3F
                dw 05900h     ;; F6       40
                dw 05a00h     ;; F7       41
                dw 05b00h     ;; F8       42
                dw 05c00h     ;; F9       43
                dw 05d00h     ;; F10      44
                dw 008f0h     ;; NUMLCK   45
                dw 009f0h     ;; SCRLOCK  46
                dw 00037h     ;; 7        47
                dw 00038h     ;; 8        48
                dw 00039h     ;; 9        49
                dw 0002dh     ;; -        4A
                dw 00034h     ;; 4        4B
                dw 00035h     ;; 5        4C
                dw 00036h     ;; 6        4D
                dw 0002bh     ;; +        4E
                dw 00031h     ;; 1        4F
                dw 00032h     ;; 2        50
                dw 00033h     ;; 3        51
                dw 00030h     ;; 0        52
                dw 0002eh     ;; .        53
                dw 00000h     ;; NOTHING  54
                dw 00000h     ;; NOTHING  55
                dw 00000h     ;; NOTHING  56
                dw 087e0h     ;; F11      57
                dw 088e0h     ;; F12      58
                dw 00de0h     ;; ENTER L  1C
                dw 002f0h     ;; R CTRL L 1D
                dw 03fe0h     ;; GRAY/ L  35
                dw 006f0h     ;; R ALT L  38
                dw 047e0h     ;; HOME  L  47
                dw 048e0h     ;; UP    L  48
                dw 049e0h     ;; PGUP  L  49
                dw 04be0h     ;; LEFT  L  4B
                dw 04de0h     ;; RIGHT L  4D
                dw 04fe0h     ;; END   L  4F
                dw 050e0h     ;; DOWN  L  50
                dw 051e0h     ;; PGDN  L  51
                dw 052e0h     ;; INS   L  52
                dw 053e0h     ;; DEL   L  53
_DATA   ends
;; ************************************************************************
