
DIM Buf$(11,40)       'each param = 10 bytes + 1 terminator byte

z$=Command$

Tokens = Parse (z$,Buf$(),40)

IF Tokens = 0 THEN
  PRINT "You did not pass any command line parameters"
ELSE
  FOR A = 1 TO Tokens
    A$ = Buf$(a)
    Print A$
  NEXT
END IF

PRINT "Params:";Tokens





Function Parse (arg$,ParseStack$(),StackSize)
'----------------------------------------------------------------
LOCAL Tmp,Ndx,A$,B$,Quote$,Arglen,IsQuote,Lin$,Tmp$
'---------------------------------------------------------------------------
Lin$=Arg$
Quote$=CHR$(34)
Arglen=LEN(Lin$)

FOR a=1 TO Arglen
  A$=MID$(Lin$,a,1)

  IF A$=Quote$ THEN
    IsQuote = NOT IsQuote
  END IF

  IF A$=" " THEN
    IF IsQuote THEN
      A$=CHR$(255)         'preserve white space
      GOTO ParseMore
    END IF
  END IF


  IF A$=";" THEN
    IF Not IsQuote THEN
      A$=" "              'change non-quoted semicolon to white
      GOTO ParseMore
    END IF
  END IF


  IF A$="," THEN
    IF Not IsQuote THEN
      A$=" "              'change non-quoted comma to white
      GOTO ParseMore
    END IF
  END IF


  IF A$="(" THEN
    IF Not IsQuote THEN
      A$=" "              'change non-quoted left parenth to white
      GOTO ParseMore
    END IF
  END IF


  IF A$=")" THEN
    IF Not IsQuote THEN
      A$=" "              'change non-quoted right parenth to white
      GOTO ParseMore
    END IF
  END IF


  IF A$="+" THEN
    IF Not IsQuote THEN
      A$=" + "              'separate non-quoted plus chars
      GOTO ParseMore
    END IF
  END IF


  IF A$="-" THEN
    IF Not IsQuote THEN
      A$=" - "              'separate non-quoted minus chars
      GOTO ParseMore
    END IF
  END IF


  IF A$="*" THEN
    IF Not IsQuote THEN
      A$=" * "              'separate non-quoted multiply chars
      GOTO ParseMore
    END IF
  END IF


  IF A$="/" THEN
    IF Not IsQuote THEN
      A$=" / "              'separate non-quoted divide chars
      GOTO ParseMore
    END IF
  END IF


  IF A$="<" THEN
    IF Not IsQuote THEN
      A$=" < "              'separate non-quoted < char
      GOTO ParseMore
    END IF
  END IF


  IF A$=">" THEN
    IF Not IsQuote THEN
      A$=" > "              'separate non-quoted > char
      GOTO ParseMore
    END IF
  END IF


  IF A$="=" THEN
    IF Not IsQuote THEN
      A$=" = "              'separate non-quoted = char
      GOTO ParseMore
    END IF
  END IF


  ParseMore:
  B$=B$+A$
NEXT

Lin$=B$

'-------------------------------------------------------------------------
FOR Tmp=1 TO StackSize
   ParseStack$(Tmp) = ""
NEXT                                 'START WITH A FRESH STACK
'-------------------------------------------------------------------------

Lin$ = TRIM$(Lin$)
Tmp  = LEN(Lin$)

IF Tmp=0 THEN
  Tokens=0               'QUICK EXIT IF NULL
  GOTO ParseQuit
END IF



DO
  Tmp$=EXTRACT$(Lin$," ")
  INCR Ndx
   ParseStack$(Ndx) = Tmp$
  Tmp=LEN(Tmp$)
  IF Tmp > 0 THEN
    INCR Tmp
    Lin$=MID$(Lin$,Tmp)
    Lin$=LTRIM$(Lin$)
  ELSE
    DECR Ndx
    EXIT LOOP
  END IF
LOOP
B$=CHR$(255)
FOR a = 1 TO Ndx
  A$ = ParseStack$(a)
  REPLACE B$ WITH " " IN A$
   ParseStack$((a) = A$
NEXT
Parse=Ndx
ParseQuit:
END FUNCTION
