; this file contain int handlers, the stack, some variables, cst & macro

MAKECODE1 EQU 42 ; SHIFT_LEFT ; scan-code for the 2 hot-key
MAKECODE2 EQU 54 ; SHIFT_RIGHT
RELEASECODE1 EQU MAKECODE1+128
RELEASECODE2 EQU MAKECODE2+128

TimeScanCode EQU 70     ; Make-code for Scroll-Lock
Color EQU 1Fh           ; white on blue
VideoBaseAdr EQU 0B800h ; warning hercule adaptater must be 0B000h !!!
Row EQU 1               ; can be 1 to 25
Col EQU 73              ; can be 1 to 80
SwitchChar EQU ':'

FALSE EQU 0 ; = 00000000b
TRUE  EQU 0FFh ; = -1 = 11111111b

; ------------------------------------------------------------------------------
; Variables pour les gestionnaires d'int !!!
; ------------------------------------------------------------------------------

WakeUp             DB FALSE ; mit a true dans int 9 handler et checker dans Check !, a false dans InitRes
Active             DB FALSE ; mit a true dans InitRes, a false dans CloseRes
Make1              DB 0
Make2              DB 0
Int13              DB 0
ShowTime           DB TRUE

ErrorCode          DB ? ; Cnf ResInt24
OldStackSize       DB ?

IndosPtrOfs        DW ?
IndosPtrSeg        DW ?

ResInt1BOfs        DW ?
ResInt1BSeg        DW ?
ResInt23Ofs        DW ?
ResInt23Seg        DW ?
ResInt24Ofs        DW ?
ResInt24Seg        DW ?

OldPsp             DW ?
OldDtaOfs          DW ?
OldDtaSeg          DW ?

OldSP              DW ?
OldSS              DW ?

Cursx              DB ?
Cursy              DB ?
CursHigh           DB ?
CursLow            DB ?
ScreenFileName     DB 'c:\screen.sav',0

; ------------------------------------------------------------------------------
; Interuption Handler : 8h, 9h, 13h, 28h allways active
; ------------------------------------------------------------------------------

NewInt8 PROC
                   PUSHF ; sera depile lors du iret de l'ancien gestionnaire
                   DB 9Ah ; CALL FAR attention int 1C fini par IRET !!!
OldInt8Ofs         WORD ?
OldInt8Seg         WORD ?

                   CALL Time ; tiens tiens je connais ce prg !!!

                   CLI ; may be desactived in the old handler

                   CALL Check
                   JC GotoIRET_8

                   CALL MainPart ; Contient l'appel a l'init, le main et le close !!! + sauvetzge des reg et du stack

GotoIRET_8:       IRET
NewInt8 ENDP


NewInt9 PROC ; check le flag Active !!!

                   PUSH AX
                   PUSH DS ; save

                   PUSH CS
                   POP DS

                   IN AL,60h
                   CMP AL,TimeScanCode
                   JNE TestIfActive
                   NOT ShowTime ; Cnf Addam's Family

TestIfActive:      CMP Active,TRUE ; destroy les flag !!! pas grave int 9 finit par IRET
                   JE CallOldInt9

; Hot-key Detection Part

                   CMP AL,MAKECODE1
                   JNE TestMakeCode2
                   MOV Make1,TRUE
                   CMP Make2,TRUE
                   JE SetWakeUpFlag
                   JMP CallOldInt9

TestMakeCode2:     CMP AL,MAKECODE2
                   JNE TestReleaseCode1
                   MOV Make2,TRUE
                   CMP Make1,TRUE
                   JE SetWakeUpFlag
                   JMP CallOldInt9

SetWakeUpFlag:     MOV WakeUp,TRUE ; il l'or de se reveiller !!!
                   MOV Make1,FALSE
                   MOV Make2,FALSE ; becoze quand actif = vrai => on ne rentre plus dans ce bout de code
                   JMP CallOldInt9 ; le Flag active sera mis a true dans InitRes

TestReleaseCode1:  CMP AL,RELEASECODE1
                   JNE TestReleaseCode2
                   MOV Make1,FALSE
                   JMP CallOldInt9

TestReleaseCode2:  CMP AL,RELEASECODE2
                   JNE CallOldInt9
                   MOV Make2,FALSE

CallOldInt9:       POP DS
                   POP AX

                   DB 0EAh ; JUMP FAR ... goto old int 9 handler
OldInt9Ofs         WORD ?
OldInt9Seg         WORD ?

NewInt9 ENDP


NewInt13 PROC
                   INC BYTE PTR CS:int13
                   PUSHF ; on pourrait faire push ax !!! car RETF 2 apres !!!
                   DB 9Ah ; CALL FAR attention int 13 fini par RETF 2 !!!
OldInt13Ofs        WORD ?
OldInt13Seg        WORD ?
                   PUSHF
                   DEC BYTE PTR CS:int13
                   POPF
                   RETF 2
NewInt13 ENDP


NewInt28 PROC
                   PUSHF 
                   DB 9Ah ; CALL FAR attention int 28 fini par IRET !!!
OldInt28Ofs        WORD ?
OldInt28Seg        WORD ?

                   CLI ; may be desactived in the old handler

                   CALL Check
                   JC GotoIRET_28

                   CALL MainPart ; Contient l'appel a l'init, le main et le close !!! + sauvetage des reg et du stack

GotoIRET_28:       IRET
NewInt28 ENDP


Check PROC ; doit preserver tous les regs !!! (sauf les flags !) appele par int 1C et int 28
           ; met carry a 1 si impossible d'activer !!!
                   CMP CS:Active,TRUE
                   JE NotNow ;  prg res deja actif !!!

                   CMP CS:WakeUp,TRUE
                   JNE NotNow

                   PUSH AX
                   PUSH BX
                   MOV AH,0Fh
                   INT 10h
                   CMP AL,3 ; 80x25 16 couleurs
                   POP BX ; ne destroye pas les flags !!!
                   POP AX
                   JNE NotNow

                   CMP BYTE PTR CS:Int13,0 ; pas d'interruption disque en cours ?
                   JNE NotNow

                   PUSH ES
                   PUSH BX
                   MOV BX,CS:IndosPtrOfs
                   MOV ES,CS:IndosPtrSeg
                   CMP BYTE PTR ES:[BX],0
                   POP BX
                   POP ES
                   JNE NotNow

                   CLC
                   RET

NotNow:            STC
                   RET
Check ENDP


MainPart PROC ; sauve le stack et les reg !!! appel : InitRes,MainRes et ClosRes

                   MOV CS:Active,TRUE ; warning !!! maintenant ca va chier
                   MOV CS:WakeUp,FALSE ; pour la prochaine fois !!!

                   MOV CS:OldSP,SP
                   MOV CS:OldSS,SS
                                                    
                   PUSH CS
                   POP SS ; le stack est en fin de prg dans notre seg
                   MOV SP,(OFFSET MyStack) + SIZEOFSTACK

                   PUSH AX
                   PUSH BX
                   PUSH CX
                   PUSH DX
                   PUSH SI
                   PUSH DI
                   PUSH BP
                   PUSH DS
                   PUSH ES

; copie du stack courant

                   MOV DS,CS:OldSS
                   MOV SI,CS:OldSP
                   XOR CX,CX
                   CLD
                
SaveIt:            CMP SI,0FFFEh ; limite max du stack !!!
                   JE StackSaved   
                   LODSW
                   PUSH AX ; push sur notre stack !!!
                   INC CX
                   CMP CX,64
                   JE StackSaved
                   JMP SaveIt

StackSaved:        PUSH CS
                   POP DS
                   MOV OldStackSize,CL

ActivateNow:       CALL InitRes ; attention sauve les interruptions, PSP , DTA, ...

                   STI
                   CALL MainRes ; notre prog !!!
                   CLI

                   CALL ClosRes ; restore les interruptions, ... , en sortie DS=CS

                   MOV CL,OldStackSize
                   XOR CH,CH

                   OR CX,CX
                   JZ RestoreReg

                   MOV ES,OldSS
                   MOV DI,OldSP
                   ADD DI,CX
                   ADD DI,CX
                   SUB DI,2
                   STD

RestoreIt:         POP AX
                   STOSW
                   LOOP RestoreIt

RestoreReg:        POP ES
                   POP DS
                   POP BP
                   POP DI
                   POP SI
                   POP DX
                   POP CX
                   POP BX
                   POP AX

                   MOV SP,CS:OldSP
                   MOV SS,CS:OldSS

                   MOV CS:Active,FALSE

                   RET                   
MainPart ENDP

; ------------------------------------------------------------------------------
; Init + Clos(e) Routine (hook int 1B,23,24)
; ------------------------------------------------------------------------------

InitRes PROC ; attention en entree DS=CS !!! voir CheckReg (on est sous CLI)

                   MOV AX,351Bh
                   INT 21h
                   MOV ResInt1BOfs,BX
                   MOV ResInt1BSeg,ES
                   MOV AX,251Bh
                   MOV DX,OFFSET ResInt1B
                   INT 21h ; put new handler

                   MOV AX,3523h
                   INT 21h
                   MOV ResInt23Ofs,BX
                   MOV ResInt23Seg,ES
                   MOV AX,2523h
                   MOV DX,OFFSET ResInt23
                   INT 21h ; put new handler

                   MOV AX,3524h
                   INT 21h
                   MOV ResInt24Ofs,BX
                   MOV ResInt24Seg,ES
                   MOV AX,2524h
                   MOV DX,OFFSET ResInt24
                   INT 21h ; put new handler

                   MOV AH,2Fh
                   INT 21h
                   MOV OldDtaOfs,BX
                   MOV OldDtaSeg,ES ; save DTA

                   MOV DX,80h ; 100h/2d
                   MOV AH,1Ah
                   INT 21h ; set DTA adr in middle of my PSP

                   MOV AH,51h
                   INT 21h
                   MOV OldPsp,BX ; save PSP

                   MOV AH,50h
                   MOV BX,DS ; debut de notre PSP
                   INT 21h ; set PSP

; save screen context !!!
                   MOV AH,3
                   XOR BH,BH
                   INT 10h ; get cursor POS. AND ASPECT
                   MOV Cursx,DL
                   MOV Cursy,DH
                   MOV CursHigh,CH
                   MOV CursLow,CL

                   MOV AH,3Ch
                   MOV CX,0022h ; hidden + archive
                   MOV DX,OFFSET ScreenFileName
                   INT 21h ; creat new file (c:\screen.sav)
                   MOV BX,AX ; Handle

                   MOV AH,40h
                   MOV CX,80*25*2
                   MOV DX,0B800h ; page 0
                   MOV DS,DX
                   XOR DX,DX
                   INT 21h ; write the screen to the file

                   MOV AH,3Eh
                   INT 21h ; close the file

                   PUSH CS
                   POP DS 

                   RETN
InitRes ENDP ; CS=DS ok pour MainRes


ClosRes PROC ; on est sous CLI !!! en entree : DS = on s'en fout !!! , en sortie DS=CS !!!!!
                   MOV DX,WORD PTR CS:ResInt1BOfs
                   MOV DS,WORD PTR CS:ResInt1BSeg
                   MOV AX,251Bh
                   INT 21h ; put old handler

                   MOV DX,WORD PTR CS:ResInt23Ofs
                   MOV DS,WORD PTR CS:ResInt23Seg
                   MOV AX,2523h
                   INT 21h ; put old handler

                   MOV DX,WORD PTR CS:ResInt24Ofs
                   MOV DS,WORD PTR CS:ResInt24Seg
                   MOV AX,2524h
                   INT 21h ; put old handler

                   MOV DX,WORD PTR CS:OldDtaOfs
                   MOV DS,WORD PTR CS:OldDtaSeg
                   MOV AH,1Ah
                   INT 21h ; set old DTA adr

                   PUSH CS
                   POP DS

                   MOV BX,OldPsp
                   MOV AH,50h
                   INT 21h ; set PSP

; restore screen Context

                   MOV AH,2
                   XOR BX,BX
                   MOV DH,Cursy
                   MOV DL,Cursx
                   INT 10h ; restore curs pos

                   MOV AH,1
                   MOV CH,CursHigh
                   MOV CL,CursLow
                   INT 10h

                   MOV AX,3D00h ; read only
                   MOV DX,OFFSET ScreenFileName
                   INT 21h ; open
                   MOV BX,AX ; Handle

                   MOV AH,3Fh
                   MOV CX,80*25*2
                   MOV DX,0B800h
                   MOV DS,DX
                   XOR DX,DX
                   INT 21h ; restore the screen

                   MOV AH,3Eh
                   INT 21h ; close

                   PUSH CS
                   POP DS
 
                   MOV AH,41h
                   MOV DX,OFFSET ScreenFileName
                   INT 21h ; delete
                   
                   RETN
ClosRes ENDP

; ------------------------------------------------------------------------------
; Time32! Routine (optimized (int 1A) called by int 8)
; ------------------------------------------------------------------------------

Time PROC
                   CMP BYTE PTR CS:ShowTime,TRUE ; bousille les flag ... pas graves int 1C finis par IRET
                   JNE DontShow

                   PUSH AX
                   PUSH BX
                   PUSH CX
                   PUSH DX
                   PUSH DI
                   PUSH ES

                   CLD ; on affiche par addr video croissante (cnf CST)
                   MOV AX,VideoBaseAdr ; Cst.
                   MOV ES,AX
                   MOV DI,(Row-1)*160+(Col-1)*2 ; adr video !!!

                   MOV AH,2
                   INT 1Ah ; get RTC value (HH-MM-SS in BCD !!!)
                   MOV BX,CX ; CX = compteurs

                   MOV AL,BH ; heures
                   MOV AH,Color ; attention reste pendant tout le programme !
                   MOV CL,4 ; attention : il est utilise 3 fois !!!
                   SHR AL,CL ; clear lower nibble
                   OR AL,30h
                   STOSW
                   MOV AL,BH
                   AND AL,0Fh ; conserve lower nibble
                   OR AL,30h
                   STOSW

                   MOV AL,SwitchChar
                   STOSW

                   MOV AL,BL ; minutes
                   SHR AL,CL
                   OR AL,30h
                   STOSW 
                   MOV AL,BL
                   AND AL,0Fh
                   OR AL,30h
                   STOSW

                   MOV AL,SwitchChar
                   STOSW

                   MOV AL,DH
                   SHR AL,CL
                   OR AL,30h
                   STOSW
                   MOV AL,DH
                   AND AL,0Fh
                   OR AL,30h
                   STOSW

                   POP ES
                   POP DI
                   POP DX
                   POP CX
                   POP BX
                   POP AX

DontShow:          RETN

Time ENDP ; End Of Time 8-)

; ------------------------------------------------------------------------------
; Interrupt active when Prg Res Active (c-a-d 1B,23,24) ; ne pas chainer vers ancien gestionnaire !!!
; ------------------------------------------------------------------------------

ResInt1B PROC ; CTRL-C ROUTINE
                   IRET ; CTRL-C FUCK !!!
ResInt1B ENDP 


ResInt23 PROC ; CTRL-BREAK ROUTINE
                   IRET ; CTRL BREAK FUCK !!!
ResInt23 ENDP 


ResInt24 PROC ; Critical Error
                   MOV AX,DI ; lower byte of DI = error code
                   MOV BYTE PTR CS:ErrorCode,AL ; save error code
                   MOV AL,3 ; Dos Call Fail (DOS >= 3.x)
                   IRET ; return !!!
ResInt24 ENDP

; ------------------------------------------------------------------------------
; copie du stack du prg interrompu + notre stack !!!
; ------------------------------------------------------------------------------

EVEN ; alignement pair !!!

SIZEOFSTACK EQU (128+64)*2 ; 128 mots pour moi (d'abord) & 64 pour sauvegarder le contexte !!! + les reg !!!
MyStack DB SIZEOFSTACK DUP (?) ; fin du prg res apres le stack
