        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc
include argc.inc
include vrt.inc
include sc.inc
include grfx.inc
include v.inc

public  _l0_setup, _l0start

;
; DATA
;
align 4
routtbl         dd      m00,p00,m01,p10,m02,waitpals
ROUTTBLSTART=($-routtbl)/4
                dd      m03,p20,m04,waitpals,m05
                dd      delay,p30,m06,p30,m07,p30,m08,waitpals,p40,delay,m09
                dd      m0a,p30,delay,p50,m0b,delay,m0c,waitpals,p60,m0d,p70
                dd      delay,m0e,p30,delay,m0f,p80,delay,m10,p30,m11,p30,p90
                dd      delay,m12,p70,m13,p20,m14,waitpals,p60,m15,p30,delay
                dd      m16,p30,delay
ROUTTBLLEN=($-routtbl)/4

palptrtbl       dd      pal02, pal00,pal01,pal06,pal09,pal01,pal07,pal04,pal03
                dd      pal05,pal0e,pal0d,pal0c,pal0b,pal03
                dd      pal01,pal0f,pal10,pal04,pal08,pal0b
PALTBLLEN=($-palptrtbl)/4

pal0aptr        dd      pal0a

delaycntr       dw      ?

palindex        db      0
routtblindex    db      0

;
; CODE
;

@set_palso      macro   index, len, ptr
        cmp _ending,0
        jne _ret
        mov _pals_ptr,offset &ptr
        mov _pals_index,&index
        mov _pals_len,&len
        mov _vrt_rout,offset _pals
endm

@set_pals       macro   index, len, ptr
        cmp _ending,0
        jne _ret
        mov _pals_ptr,&ptr
        mov _pals_index,&index
        mov _pals_len,&len
        mov _vrt_rout,offset _pals
endm

@set_palo       macro   index, len, ptr
        cmp _ending,0
        jne _ret
        mov esi,offset &ptr
        mov _vrt_palptr,esi
        mov ecx,&index
        mov _vrt_palindex,cl
        lea edi,[ecx*2+ecx+offset _cpal]
        mov ecx,&len
        mov _vrt_pallen,cx
        lea ecx,[ecx*2+ecx]
        rep movsb
endm

@palnext        macro   cb
        mov al,&cb
        call nextpal
endm

@palnexts       macro   cb
        mov al,&cb
        call nextpals
endm

include l0p0.m
include l0p1.m
include l0p2.m
include l0p3.m
include l0p4.m
include l0p5.m
include l0p6.m
include l0p7.m
include l0p8.m
include l0p9.m

;
; Check for no jerky switch
; Out:
;   EAX,EBX,ECX,EDX,ESI,EDI,EBP - ?
;
_l0_setup:
        mov al,'j'
        call _cchekswitchnc
        jc _ret
        mov word ptr d3sizetbl[6],505h
        ret

;
delay:                                  ; wait a specified number of ticks
        dec delaycntr
        jnz _ret
        jmp setnext
;
waitpals:                               ; wait for end of palette slide
        cmp _vrt_rout,offset _ret
        jne _ret
        jmp setnext
;
waitpal:                                ; wait for palette to be set
        cmp _vrt_pallen,0
        jne _ret
        jmp setnext

;
setnext:
        movzx eax,routtblindex
        inc eax
        cmp al,ROUTTBLLEN
        jb short setnextf0
        mov ebx,_loop
        sub ebx,1
        jc short setnextf1
        jnz short setnextf2
        mov dword ptr [esp],offset _done
setnextf2:
        mov _loop,ebx
setnextf1:
        mov eax,pal0aptr
        add eax,64*3
        cmp eax,offset pal0a+64*3*6
        jb short setnextf3
        mov eax,offset pal0a
setnextf3:
        mov pal0aptr,eax
        mov eax,ROUTTBLSTART
setnextf0:
        mov ebx,routtbl[eax*4]
        mov _l0rout,ebx
        mov routtblindex,al
        ret

;
nextpal:
        cmp _ending,0
        jne short nextpalf0

        movzx edx,palindex
        inc edx
        cmp dl,PALTBLLEN
        jb short nextpalf1
        xor dl,dl
nextpalf1:
        mov palindex,dl

        mov esi,palptrtbl[edx*4]
        shl al,6

        mov _vrt_palptr,esi
        mov _vrt_pallen,64
        mov _vrt_palindex,al

        movzx edi,al
        lea edi,[edi*2+edi+offset _cpal]
        mov ecx,64*3
        rep movsb

        ret
nextpalf0:
        add esp,4
        ret

;
nextpals:
        cmp _ending,0
        jne short nextpalsf0

        movzx edx,palindex
        inc edx
        cmp dl,PALTBLLEN
        jb short nextpalsf1
        xor dl,dl
nextpalsf1:
        mov palindex,dl

        mov esi,palptrtbl[edx*4]
        shl al,6

        mov _pals_ptr,esi
        mov _pals_len,64
        mov _pals_index,al
        mov _vrt_rout,offset _pals

        ret
nextpalsf0:
        add esp,4
        ret

;
_l0start:
m00:
        @palnexts 0
        jmp setnext
m01:
        @palnexts 1
        jmp setnext
m02:
        @set_palso 0,64,_bpal
        jmp setnext
m03:
        @palnexts 2
        jmp setnext
m04:
        mov eax,pal0aptr
        @set_pals 192,64,eax
        @palnext 1
        jmp setnext
m05:
        @palnexts 2
        mov d3tile[0],offset tile00
        mov d3tile[4],offset tile01
        mov d3tile[8],offset tile02
        mov d3tile[12],offset tile03
        mov d3counter,10h
        mov delaycntr,2
        jmp setnext
m06:
        mov _l1on,1
        @set_palso 128,64,_bpal
        mov d3counter,20h
        jmp setnext
m07:
        mov d3tile[0],offset tile04
        mov d3tile[4],offset tile05
        mov d3tile[8],offset tile06
        mov d3tile[12],offset tile07
        mov d3counter,40h
        jmp setnext
m08:
        @palnexts 1
        mov delaycntr,80h
        jmp setnext
m09:
        mov _l2on,1
        @palnext 2
        @palnexts 1
        jmp setnext
m0a:
        mov d3tile[0],offset tile08
        mov d3tile[4],offset tile09
        mov d3tile[8],offset tile0a
        mov d3tile[12],offset tile0b
        mov d3counter,10h
        mov delaycntr,40h
        jmp setnext
m0b:
        mov delaycntr,40h
        jmp setnext
m0c:
        @set_palso 0,192,_bpal
        jmp setnext
m0d:
        @palnext 0
        mov delaycntr,40h
        jmp setnext
m0e:
        @palnext 1
        mov d3tile[0],offset tile0c
        mov d3tile[4],offset tile0d
        mov d3tile[8],offset tile0e
        mov d3tile[12],offset tile0f
        mov d3counter,10h
        mov delaycntr,40h
        jmp setnext
m0f:
        @palnext 2
        mov d8tile,offset tile10
        mov delaycntr,40h
        jmp setnext
m10:
        mov d3tile[0],offset tile11
        mov d3tile[4],offset tile12
        mov d3tile[8],offset tile13
        mov d3tile[12],offset tile14
        mov d3counter,10h
        jmp setnext
m11:
        @palnext 0
        @set_palso 128,64,_bpal
        mov d3counter,40h
        mov delaycntr,40h
        jmp setnext
m12:
        movzx edx,palindex
        mov ebx,palptrtbl[edx*4]
        add ebx,63*3
        @set_pals 64,64,ebx
        jmp setnext
m13:
        @palnext 2
        jmp setnext
m14:
        @set_palo 0,64,_bpal
        @set_palso 128,64,_bpal
        jmp setnext
m15:
        @palnexts 0
        mov d3tile[0],offset tile15
        mov d3tile[4],offset tile16
        mov d3tile[8],offset tile17
        mov d3tile[12],offset tile18
        mov d3counter,20h
        mov delaycntr,80h
        jmp setnext
m16:
        mov d3tile[0],offset tile19
        mov d3tile[4],offset tile1a
        mov d3tile[8],offset tile1b
        mov d3tile[12],offset tile1c
        mov d3counter,10h
        mov delaycntr,40h
        jmp setnext

code32  ends
        end

