

_TEXT   segment byte public 'CODE'
_TEXT   ends
_DATA   segment word public 'DATA'

_DATA   ends
CONST  segment word public 'CONST'
CONST  ends
_BSS    segment word public 'BSS'
_BSS    ends
DGROUP  GROUP CONST, _BSS, _DATA
        ASSUME CS:_TEXT, DS:DGROUP, SS:DGROUP, ES:DGROUP


;=============================================================================
;       CLOAD         cload(font_data);
;=============================================================================
        assume cs:_text
_text   segment public byte 'code'
public _cload

cloads  struc
        dw      3 dup (?)    ; bp and far return
fdata   dd      ?            ; font data to load
bpc     dw      ?
cloads  ends

_cload  proc far
        push bp
        mov bp,sp
        push si
        push di
        push ds
        push es

        les si,[bp].fdata
        push bp
        mov al,0
        mov cx,256
        mov dx,01
        mov bx,[bp].bpc
        xchg bl,bh
        push bx
        push bx
        mov bl,0
        mov ah,011h
        mov bp,si
        int 10h
        pop bx
        mov ax,256
        xchg bl,bh
        mul bx
        add si,ax
        mov al,0
        mov cx,256
        mov dx,01
        pop bx
        mov bl,01
        mov ah,011h
        mov bp,si
        int 10h
        mov ah,011h
        mov al,03
        mov bl,00000100B
        int 10h
        pop bp

        pop es
        pop ds
        pop di
        pop si
        mov sp,bp
        pop bp
        ret
_cload  endp

_reset  proc far
        public _reset
        mov ah,0
        mov al,3
        int 10h
        ret
_reset  endp

_setcrt proc far
        public _setcrt
        mov cl,014h
        mov bl,012
        mov dx,03d4h
        mov al,cl
        out dx,al
        inc dx
        mov al,bl
        out dx,al
        ret
_setcrt endp

pios    struc
        dw      3 dup (?)    ; bp and far return
pchar   dw      ?
pios    ends

_pio    proc    far
        public _pio
        push bp
        mov bp,sp
        push si
        push di
        push ds
        push es
        mov ax,[bp].pchar
iowait:
        mov ah,0
        mov dx,0
        int 017h
        cmp ah,01
        je iowait
        pop es
        pop ds
        pop di
        pop si
        mov sp,bp
        pop bp
        ret
_pio    endp

gcs     struc
        dw      3 dup (?)    ; bp and far return
fonts   dd      ?            ; fonts
attr    dw      ?            ; attribute
xval    dw      ?            ; x location
yval    dw      ?            ; y location
char1   dw      ?            ; char1
char2   dw      ?            ; char2
bpch    dw      ?            ; bytes per character
gcs     ends

v_reset proc far
        mov dx,03ceh
        mov al,08
        out dx,al
        inc dx
        mov al,00ffh
        out dx,al
        mov dx,03ceh
        mov al,05
        out dx,al
        inc dx
        mov al,0
        out dx,al
        ret
v_reset endp

_gchara proc    far
        public _gchara
        push bp
        mov bp,sp
        push si
        push di
        push ds
        push es

        mov dx,03ceh
        mov al,05
        out dx,al
        inc dx
        mov al,02
        out dx,al
        mov dx,03c4h
        mov al,02
        out dx,al
        inc dx
        mov al,0fh
        out dx,al

        mov ax,14            ;19 to 14
        mov bx,[bp].char1
        dec bx
        mul bx
        les si,[bp].fonts
        mov di,si
        add si,ax               ; es:si has char1 lib location

        mov bx,[bp].char2
        cmp bx,255
        je noac
        mov ax,14
        dec bx
        mul bx
        add di,ax               ; es:di has char2 lib location
        add di,256*14
        jmp short acc
noac:   add di,14*31
acc:    mov bx,[bp].yval

        mov ax,80
        mul bx
        mov bx,ax
        mov ax,[bp].bpch
;       mov ax,14
        mul bx

        add ax,[bp].xval
        push ax               ; ds:bx has video location

        mov bx,[bp].attr
        test bx,01000b
        jz notupper
;       add si,256*14
notupper:
        mov bh,bl
        mov cx,4
        shr bh,cl
        and bl,00001111b
        and bx,0000011100000111b
        mov ch,bl
        mov ah,bh
        mov dx,0a000h
        mov ds,dx
        mov bx,[bp].bpch
;       mov bx,14
        mov cl,bl
        pop bx
oneb:

        mov dx,03ceh
        mov al,08
        out dx,al
        inc dx
        mov al,es:[si]
        or al,es:[di]
        cmp cx,0000000100000001B
        jne noundf
        mov al,0ffh
noundf:
        out dx,al
        mov al,ds:[bx]
        mov ds:[bx],ch

        mov dx,03ceh
        mov al,08
        out dx,al
        inc dx
        mov al,es:[si]
;       or al,es:[di]
        cmp cx,0000000100000001B
        jne noundb
        mov al,0ffh
noundb:
        not al
        out dx,al
        mov al,ds:[bx]
        mov ds:[bx],ah

        inc di
        inc si
        add bx,080
        dec cl
        cmp cl,0
        jne oneb
        call v_reset
        pop es
        pop ds
        pop di
        pop si
        mov sp,bp
        pop bp
        ret
_gchara endp

gln     struc
        dw      3 dup (?)    ; bp and far return
lloc    dd      ?            ; line to put
video   dd      ?            ;
lattr   dw      ?            ; attribute
llen    dw      ?            ; length
gln     ends

_gline  proc    far
        public _gline
        push bp
        mov bp,sp
        push si
        push di
        push ds
        push es

        mov dx,03ceh
        mov al,05
        out dx,al
        inc dx
        mov al,02
        out dx,al        ;write mode 2 (fast color fill)

        mov dx,03c4h
        mov al,02
        out dx,al
        inc dx
        mov al,0fh
        out dx,al        ;map mask (all planes enabled)

        les si,[bp].lloc    ; es:si has line location

        mov bx,[bp].lattr
        mov bh,bl
        mov cx,4
        shr bh,cl
        and bl,00001111b
        and bx,0000011100000111b
        mov cx,[bp].llen
        lds di,[bp].video

onel:

        mov dx,03ceh
        mov al,08
        out dx,al
        inc dx
        mov al,es:[si]
        out dx,al
        mov al,ds:[di]
        mov ds:[di],bl

        mov dx,03ceh
        mov al,08
        out dx,al
        inc dx
        mov al,es:[si]
        not al
        out dx,al
        mov al,ds:[di]
        mov ds:[di],bh

        inc di
        inc si
        loop onel
        call v_reset

        pop es
        pop ds
        pop di
        pop si
        mov sp,bp
        pop bp
        ret
_gline  endp

latch proc near
        push dx
        mov dx,03c4h
        mov al,02
        out dx,al
        inc dx
        mov al,0ffh
        out dx,al
        mov dx,03ceh
        mov al,05
        out dx,al
        inc dx
        mov al,ah
        out dx,al
        pop dx
        ret
latch endp

scrl    struc
        dw      3 dup (?)    ; bp and far return
dir     dw      ?            ; direction - 0 is down, 1 is up
y1      dw      ?            ; ytop
y2      dw      ?            ; ybot
scrl    ends

_uscroll proc far
        public _uscroll
        push bp
        mov bp,sp
        push si
        push di
        push ds
        push es
        mov ah,00000001B
        call latch
        cli
        mov si, 0A000h
        mov es,si
        mov cx,[bp].y2
        mov ax,[bp].y1
        cmp ax,cx
        je scrx2
        cmp [bp].dir,word ptr 0
        je down
        mov bx,80*19
        mul bx
        mov di,ax
        mov si,ax
        add si,80*19
        mov ax,[bp].y2
        mov bx,[bp].y1
        sub ax,bx
        mov bx,80*19
        mul bx
        mov cx,ax
        cld
        jmp doscroll
down:
        xchg cx,ax
        mov bx,80*19
        mul bx
        dec ax
        mov di,ax
        mov si,ax
        add di,80*19
        mov ax,[bp].y2
        mov bx,[bp].y1
        sub ax,bx
        mov bx,80*19
        mul bx
        mov cx,ax
        std
doscroll:
        rep movs es:byte ptr[di],es:[si]
scrx2:
        mov ah,00000000B
        call latch
        pop es
        pop ds
        pop di
        pop si
        mov sp,bp
        pop bp
        ret
_uscroll endp


_text ends
end
