
#include <stdio.h>
#include <graph.h>
#include <dos.h>
#include <malloc.h>
#include "sedit.h"
#define VBUFSIZE 2048
struct videoconfig vc; struct rccoord xy;
char *cmat; int sx,sy,matcol=23,curcol,xc,yc,xm,ym,smode,bpc=14;
int col1=23,col2=79,col3=79,col4=7;
char *fontdata, *videobuf; char fontfile[80],outfile[80]; FILE *fin,*fout,*f2;
char tbuf[20][14],font2[80]; int ctbuf[20];
main(argc,argv)
int argc; char **argv;
{
        int i,j,k,x,y,start,marked,n; char *gg;
        strcpy(fontfile,argv[1]);
        strcpy(outfile,argv[3]);
        strcpy(font2,argv[2]);
        if (argc < 3) { printf(" Useage:   SEDIT font1 font2 outfile\n");
                exit(-1); }
        fontdata = malloc(2*14*256); cmat = malloc(14*8);
        matcol = col1;
        if ((fin = fopen(fontfile,"rb")) == 0) {
                printf("Cannot find font file #1"); exit(-1); }
        if ((fout = fopen(outfile,"wb")) == 0) {
                printf("Cannot Open Output file."); exit(-1); }
        fread(fontdata,1,14*256,fin); fclose(fin);
        if ((f2 = fopen(font2,"rb")) == 0) {
                printf("Cannot find font file #2"); exit(-1); }
        fread(fontdata+14*256,1,14*256,f2); fclose(f2);
        _getvideoconfig(&vc); videobuf = (char *)0xA0000000;
        if (vc.adapter == _EGA) _setvideomode(_ERESCOLOR);
        if (vc.adapter == _VGA) _setvideomode(_VRES16COLOR);
        for (i = 0; i < 10; ++i) ctbuf[i] = 32;
        memset(tbuf,0,14*10);
        start = 0; marked = 0; showbuf();
        while(1) {
        window(start,marked);
        if ((k = getkey()) == K_ESC) break;
                if (k <= (K_F10) && k >= (K_F1)) {
                        n =  k - (K_F1); ctbuf[n] = start+marked+1;
                        gg = fontdata + (start+marked)*14;
                        memcpy(tbuf[n],gg,14); showbuf();
                }
                if (k <= (K_SF10) && k >= (K_SF1)) {
                        n =  k - (K_SF1); ctbuf[n] = start+marked+1;
                        gg = fontdata + (start+marked)*14;
                        memcpy(gg,tbuf[n],14); showbuf();
                }

                switch (k) {
                case K_LEFT : if (start == 0 && marked == 0) break;
                        if (marked == 0) { --start; break; }
                        --marked; break;
                case K_RIGHT : if ((start+20) == 512 && marked == 19) break;
                        if (marked == 19) { ++start; break; }
                        ++marked; break;
                case K_UP : start -= 20; if (start < 0) start = 0;
                         break;
                case K_DOWN: start += 20; if ((start+20) >= 512) start = 512-20;
                        break;
                case K_RETURN : cedit(marked+start); break;
                default: break; }}
        fwrite(fontdata,1,14*256,fout); fclose(fout);
        _setvideomode(_DEFAULTMODE); free(fontdata); free(cmat);
}

void
locprint(width,attr,x,y,s,cadd)
int width,x,y; unsigned int attr,cadd; unsigned char *s;
{
        unsigned char c; int i;
        char *l,fg,bg;
        l = videobuf + 160*y+(x<<1);
        if (smode == ALPHA) {
                while (width-- >0) { if (*s != '\0')
                *l++ = *s++; else *l++ = 32;
                        *l++ = attr; }}
         else { i=47;
                while (width-- >0) { ++i; if (*s != '\0') {
                gchara(fontdata+cadd*14,attr,x++,y,*s++,ACEND,bpc); }
                else gchara(fontdata+cadd*14,attr,x++,y,' ',ACEND,bpc); }
                }
}

window(start,marked)
int start,marked;
{       int k,i,y,cadd; unsigned char c,dum[10]; y = 7; yc = 0;
        if (vc.adapter == _EGA) yc = 1;
        for (i = 0; i < 20; ++i) {
        fillmat(i+start); matcol = col1; if ((i)==marked) matcol = col2;
        showmat(i*4,y); _settextposition(y+yc+3,i*4+1); _settextcolor(15);
        sprintf(dum,"%3u",i+start); _outtext(dum);
        sx = marked*4; sy = y; cadd = 0;
        k = i + start + 1; if (k > 256) { k -= 256; cadd = 257; }
        dum[0] = k-1;
        locprint(1,7,i*4+1,y+5,&dum[0],cadd);
        }
}

waiting() { }

int
getkey()
{
        int ch;
        while ((bdos(0x0b,0,0) & 0x00FF) == 0) waiting();
        if ((ch = bdos(8,0,0) & 0x00FF) != '\0') return (ch);
        ch = (bdos(8,0,0) & 0x00FF) | 0x100; return(ch);
}

fillmat(cnum)
int cnum;
{
        int i,j; unsigned char *matt,c; unsigned char *cdat;
        matt = cmat; memset(matt,0,14*8);
        cdat = fontdata + cnum*14 ;
        for (i = 0; i < 14; ++i) { c = *cdat++;
                for (j = 0; j < 8; ++j) {
                if (c >= 128) *matt = 1; ++matt; c = (c<<1); }}
}

storemat(cnum)
int cnum;
{
        int i,j; unsigned char *matt,c,d; unsigned char *cdat;
        matt = cmat;
        cdat = fontdata + cnum*14;
        for (i = 0; i < 14; ++i) {
                d = 128; c = 0; for (j = 0; j < 8; ++j) {
                if (*matt++ == 1) c = c | d; d = d >> 1; }
                *cdat++ = c;
        }
}

unsigned char lbuf[4];
loadlin(i)
int i;
{
        int j,k,m,n;
        memset(lbuf,0,4); k = i*8; m = 0;
        for (j = 0; j < 8; ++j) {
                if (cmat[j+k]) { for (n = 0; n < 2; ++n) {
                        lbuf[m/8] |= (128 >> (m % 8)); ++m; } ++m; }
                else { m += 3; } }
}

showline(i)
int i;
{
        char *l; int j,k,at; unsigned char c;
        loadlin(i);
        l = videobuf + i*80*3+sx + sy*14*80;
        at = matcol;
        for (j = 0; j < 2; ++j) { gline(lbuf,l,at,3); l += 80; }
        memset(lbuf,0,3); gline(lbuf,l,at,3);
}

showmat(x,y)
int x,y;
{
        int i; sx = x; sy = y;
        for (i = 0; i < 14; ++i) { showline(i); }
}


char buff[4];
getim(x,y)
int x,y;
{
        char *s; int xx,yy,i; s = buff;
        xx = (x-sx)*3+sx*8; yy = (y-sy+1)*3-1+sy*14;
        for (i = 0; i < 3; ++i) { *s++ = getdot(xx,yy); ++xx; }
}

putim(x,y)
int x,y;
{
        char *s; int xx,yy,i; s = buff;
        xx = (x-sx)*3+sx*8; yy = (y-sy+1)*3-1+sy*14;
        for (i = 0; i < 3; ++i) { egadot(xx,yy,*s++); ++xx; }
        ega_reset();
}

ega_reset()
{
        outp(0x3ce,0); outp(0x3cf,0);
        outp(0x3ce,1); outp(0x3cf,0);
        outp(0x3ce,3); outp(0x3cf,0);
        outp(0x3ce,8); outp(0x3cf,0xFF);
}

egadot(xx1,yy1,col)
int xx1,yy1,col;
{
        char *vbase; unsigned char mask; mask = 0x80; mask >>= xx1 % 8;
        vbase = (char *)(videobuf+((long)yy1*80L+((long)xx1/8L)));
        curcol = *vbase;
        outp(0x3ce,0); outp(0x3cf,col);
        outp(0x3ce,1); outp(0x3cf,0x0F);
        outp(0x3ce,8); outp(0x3cf,mask);
        mask = *vbase; *vbase = mask;
}

int
getdot(xx1,yy1)
int xx1,yy1;
{
        union REGS inregs, outregs;
        inregs.h.ah = READ_DOT;
        inregs.x.cx = xx1;
        inregs.x.dx = yy1;
        inregs.h.bh = 0;
        int86(VIDEO_IO, &inregs, &outregs);
        return(outregs.h.al);
}

char mask[] = { 0,1,2,4,8 };

enable_read(n)
unsigned int n;
{
        outp(0x3ce,4); outp(0x3cf,n);
}

enable_write(n)
unsigned int n;
{
        outp(0x3c4,2); outp(0x3c5,mask[n+1]);
}

graph_cur()
{
        int xp1,yp1,i;
        xp1 = (xm-sx)*3+sx*8; yp1 = (ym-sy+1)*3-1+sy*14;
        for (i = 0; i < 3; ++i) { egadot(xp1,yp1,col3); ++xp1; }
        ega_reset();
}

insvmat(j)
int j;
{       char *s; int i;
        for (i = 0; i < (ym-sy)+1; ++i) {
        s = cmat + i*8 + j; memmove(s+1,s,8-j-1);
        *s = 0; } showmat(sx,sy);
}

inlvmat(j)
int j;
{       char *s; int i;
        for (i = 0; i < (ym-sy)+1; ++i) {
        s = cmat + i*8 + j; memmove(s,s+1,8-1-j);
        *(cmat + (i + 1)*8 - 1) = 0; } showmat(sx,sy);
}

insert_up(y)
int y;
{
        int j;
        j = 8; memmove(cmat,cmat+j,y*j);
        memset(cmat+y*j,0,j); showmat(sx,sy);
}

delete_down(y)
int y;
{
        int j;
        j = 8; memmove(cmat+j,cmat,y*j);
        memset(cmat,0,j); showmat(sx,sy);
}

mxy(px,py)
int px,py;
{       int i,j;
        xm += px; ym += py;
        if (xm < sx) { xm = sx; insvmat(0); }
        if (xm > sx - 1 + 8) { inlvmat(0); xm = sx - 1 + 8; }
        if (ym < sy) { ym = sy; delete_down(14-1); }
        if (ym > sy + 14 - 1)
                { ym = sy + 14 - 1; insert_up(14-1); }
}

sholoc(t)
int t;
{
        char nbuf[30];
        if (t == 1) sprintf(nbuf, "%-1u,%-2u ",ym-sy+1,xm-sx+1);
        else strcpy(nbuf,"         ");
        _settextposition(sy-1,sx+1); _settextcolor(15);
        _outtext(nbuf);
}

cedit(ct)
int ct;
{
        FILE *tfp; char tdum[40]; unsigned char *vbuf,c;
        int k,cur,i,j,lastym,lastxm; char *l,*s; int vsum,inf,cbye;
        int xx1,yy1,xx2,yy2,penflag; tfp = (FILE *)NULL;
        vbuf = calloc(VBUFSIZE,1); c = 0;
        memset(vbuf,0,512);
        matcol = col3;
        ym = sy; xm = sx; fillmat(ct); showmat(sx,sy);
        lastym = ym; vsum = 0; lastxm = xm;
        inf = 0; getim(lastxm,lastym); sholoc(1);
        penflag = 0; cbye = 0;
        while (1) {
                if (cbye == 1) break; putim(lastxm,lastym); getim(xm,ym);
                graph_cur();
                sholoc(1); lastym = ym; lastxm = xm;
                if ((k = getkey()) == K_RETURN) {
                        showline(ym-sy); storemat(ct); break; }
                if (k == K_ESC) break;
                        i = (ym-sy)*8+xm-sx; cbye = 0;
                switch (k) {
                case K_LEFT : mxy(-1,0); break;
                case K_RIGHT : mxy(1,0); break;
                case K_UP : mxy(0,-1); break;
                case K_DOWN : mxy(0,1); break;
                case K_PGUP : insert_up(ym-sy); break;
                case K_INS : insvmat(xm-sx); break;
                case K_DEL : inlvmat(xm-sx); break;
                case K_PGDN : delete_down(ym-sy); break;
                case K_HOME : xm = sx; ym = sy; showmat(); break;
                case 'e': case 'E' : xm = sx; ym = sy + 14 - 1;
                        showmat(); break;
                case K_SPACE :
                        cmat[i] = 0; showline(ym-sy);
                        break;
                default:
                        cmat[i] = 1;
                        showline(ym-sy);
                        break; }}

                free (vbuf); sholoc(0);
}


showbuf()
{
        int i,j,k,m; char dum[20];
        strcpy(dum,"Temporary  ");
        _settextposition(2,1); _settextcolor(15); _outtext(dum);
        m = strlen(dum);
        strcpy(dum,"  Buffers  ");
        _settextposition(3,1); _outtext(dum);
        for (i = 0; i < 10; ++i) {
        fillmat(ctbuf[i]-1); matcol = col1;
        showmat(m+i*4,1);
        _settextposition(5,m+i*4+1); _settextcolor(15);
        sprintf(dum,"F%-2u",i+1); _outtext(dum);
        }
}

