PAGE	60,132
TITLE	EMSFIX.ASM Version 1.0

;****************************************************************************
;
;	EMSFIX.ASM Version 1.0
;
;	Intercepts the Int 67h vector, traps EMS function call 45h (Get
;	Version), and returns 3.2 for the EMS version number.  This has
;	the effect of forcing WordPerfect 5.1 to use LIM 3.2 functions
;	instead of LIM 4.0 functions, and solves problems caused by faulty
;	LIM 4.0 drivers.
;
;	Run EMSFIX prior to loading WP 5.1.
;	
;	Written on 11/25/89 by:
;	   Bill Gordon, Vericomp
;	   CIS ID Number 76010,3466
;

	cseg	segment

	org	100h

	assume	cs:cseg, ds:cseg, es:cseg

Start:
	jmp	Init

if ($-Start) mod 10h
	org	($-Start)-(($-Start)mod 10h)+110h
endif						;align on paragraph

NewInt67Vector:
	jmp	short NewCode

		db	0,0,0,0
OrigInt67	dd	0	
		db	'EMMXXXX0'

NewCode:
	cmp	ah,46h				;see if "get version" function call
	je	Have46h				;branch if so

	jmp	dword ptr cs:6			;if not, give control to
						;original EMS driver

Have46h:
	mov	ax,32h				;return version 3.2
	iret

Init:
	mov	ax,3567h
	int	21h				;get original Int 67h vector

	mov	word ptr cs:OrigInt67,bx
	mov	word ptr cs:OrigInt67 [2],es	;store original Int 67h vector

	mov	bx,offset NewInt67Vector
	mov	cl,4
	ror	bx,cl
	and	bx,0FFFh
	mov	ax,cs
	add	ax,bx
	mov	ds,ax
	mov	dx,0
	mov	ax,2567h
	int	21h				;store new Int 67h vector

EndCode:
	mov	ax,word ptr cs:2ch
	mov	es,ax
	mov	ah,49h
	int	21h				;free memory used by environment

	mov	dx,offset Init
	mov	cl,4
	ror	dx,cl
	and	dx,0FFFh
	mov	ah,31h
	int	21h				;terminate & remain resident

cseg	ends

	end	Start
