/*  Acronym Macro Maker for WordPerfect 5.0  Version 1.1
 *
 *  (c) Copyright 1989 MasonWare.  All Rights Reserved.
 *  See the DISTRIBUTION NOTICE below.
 *
 *  This program will create a WP macro using a user supplied file
 *  of abbreviations and their normal, spelled out form.  The program
 *  requires two parameters, 1) the filename of the input acronym 
 *  definition file and 2) the output WP macro name.  The input
 *  acronym definition file must be an ASCII comma delimited file where
 *  each record ends with a CR/LF combo, each record has 2 fields that
 *  are separated by a comma and each field is surrounded with double
 *  quotes.  
 *
 *  DISTRIBUTION NOTICE
 *
 *  Permission is granted to distribute this program, source code 
 *  and other attached files as long as the fee for distribution is
 *  $10 or less per copy.  This program and its source code cannot
 *  be distributed as part of another commerically offered product
 *  whose distribution fee is $10 or greater.  If you use this program
 *  and/or source code in another product, you must acknowledge the
 *  copyright of this program/source code in your product.
 *
 *  No fee is solicated, but feel free to send something if you like.
 *  
 *  Send any correspondence regarding this program to:
 * 
 *      MasonWare
 *      4050 Jay Em Circle
 *      Ellicott City, MD  21043
 *
 *  Version History
 *
 *  v1.0 - a prototype that was never distributed.
 *  v1.1 - first release to public
 *
 */

#include <stdio.h>
#include "amm.h"

char label_code[3]	= "\x16\xFC";	/* 2 bytes long */
char abbrev[11] 	= "";
char tilde_code[5]	= "~\0\x0A\0";	/* 4 bytes long */
char longform[81]	= "";
char ret_code[9]	= "\x0A\0\x22\xFC\x0A\0\x0A\0";   /* 8 bytes long */

FILE *fn[2] = {(FILE *)NULL, (FILE *)NULL};
#define INPUT_ABBREV_FILE	fn[0]
#define OUTPUT_MACRO_FILE	fn[1]

/*
   Order of arguments: *argv[1] -> input abbreviation source file name
                       *argv[2] -> output macro name
*/

main (int argc, char *argv[])
{
	print_byline();
	if (argc < 2 || argc > 3)
		print_help();
	open_files(argc,argv);
	copy_header();
	make_macro();
	exit(0);
}


print_byline()
{
	printf("\nAcronym Macro Maker for WP 5.0, v1.1 %s %s\n",__DATE__,__TIME__);
	printf("  (c) 1989 MasonWare, All Rights Reserved.\n");
}


open_files(argc,argv)
int   argc;
char *argv[];
{
	void close_files();
	char fname[80];

	atexit(close_files);   /* setup auto file close upon exit */

	fn[0] = fopen(argv[1],"rb");   /* open input abbrev source file */
	if (!fn[0])
	{
		printf("\nERROR - Could not open %s\n",argv[1]);
		exit(1);
	}

	if (argc == 2)      /* if no output arg present, assume ALTZ.WPM */
		strcpy(fname,"ALTZ.WPM");
	else
	{
		strcpy(fname,argv[2]);    /* should check length, but what the heck */
		if (!strrchr(fname,'.'))  /* if no extension, assume WPM */
			strcat(fname,".WPM"); /* not particularily robust either */
	}
	fn[1] = fopen(fname,"wb");  /* open output macro file */
	if (!fn[1])
	{
		printf("\nERROR - Could not open %s\n",fname);
		exit(1);
	}
}

void
close_files()
{
	fclose(fn[0]);
	fclose(fn[1]);
}


copy_header()
{
	int e, len;
	int macro_hdr_len();

	len = macro_hdr_len();

	e = fwrite(macro_hdr, 1, len, OUTPUT_MACRO_FILE);
	if (e != len)
	{
		printf("\nERROR - Could not create the new macro header\n");
		exit(1);
	}
}


make_macro()
{
	int len, e;
	char macroln[220];
	void put_endcode();

	atexit(put_endcode);
	while (get_abbrev())
	{
		memcpy(macroln,label_code,2);
		len = 2;
		make_macro_str(&macroln[len],abbrev);
		len += (strlen(abbrev)*2);
		memcpy(&macroln[len],tilde_code,4);
		len += 4;
		make_macro_str(&macroln[len],longform);
		len += (strlen(longform)*2);
		memcpy(&macroln[len],ret_code,8);
		len += 8;
		append_macro(macroln,len);
	}
}


make_macro_str(m,a)	/* build a WP macro string (ie every other byte is null) */
char m[], a[];
{
	int i, j;

	i = j = 0;
	while (a[j])
	{
		m[i++] = a[j++];
		m[i++] = '\0';
	}
}



get_abbrev()
{
	char buffer[100], *bp, *e;
	int x;
	static recnum = 0;
												/* get chars up to CR LF (\n), */
	e = fgets(buffer,95,INPUT_ABBREV_FILE);		/* assumes \n is not converted to \0 or dropped */
	if (!e)
		return NULL;
	recnum++;
	buffer[95] = '\0';
	if (strlen(buffer) >= 95 && buffer[94] != '\n')
	{
		printf("\nERROR - Input abbreviation file record too large @ line # %i\n",recnum);
		exit(1);
	}

	bp = buffer;
	if (*bp++ != '\"')	/* look for starting quote char */
	{
		printf("\nERROR - Input abbreviation file missing starting dbl quote @ line # %i\n",recnum);
		exit(1);
	}
	x = 0;
	while (*bp != '\"' && x < 10)
		abbrev[x++] = *bp++;
	abbrev[x] = '\0';

	*bp++;
	if (*bp++ != ',')	/* look for comma */
	{
		printf("\nERROR - Input abbreviation file not formatted correctly @ line # %i\n",recnum);
		exit(1);
	}

	if (*bp++ != '\"')	/* look for starting quote char */
	{
		printf("\nERROR - Input abbreviation file not formatted correctly @ line # %i\n",recnum);
		exit(1);
	}
	x = 0;
	while (*bp != '\"' && x < 80)
		longform[x++] = *bp++;
	longform[x] = '\0';

	return 1;
}


append_macro(buf,len)
char *buf;
int len;
{
	int e;

	e = fwrite(buf, 1, len, OUTPUT_MACRO_FILE);
	if (e != len)
	{
		printf("\nERROR - Could not write to new macro file\n");
		exit(1);
	}
}

void
put_endcode()			/* Write ending pair of null bytes */
{
	int e;

	e = fwrite("\0\0", 1, 2, OUTPUT_MACRO_FILE);
	if (e != 2)
	{
		printf("\nERROR - Could not write end codes to new macro file\n");
		exit(1);
	}
}


print_help()
{
	printf("\n\nUsage:  amm   input_list  output_macro\n");
	printf("\n        Where    input_list    is the file name of the input acronym list");
	printf("\n                 output_macro  is the file name of the output WP macro\n");
	printf("\n        All parameters must be present and valid file names.");
	printf("\n        input_list must be a comma delimited ASCII file.\n\n\n");
	exit(1);
}


macro_hdr_len()
{
	unsigned char *p;

    p = macro_hdr + 1;
	while (*p != 0xFF)
		while (*p++ != 0xFF)
			;
	return (int) (--p - macro_hdr);
}
