/*
 *  Pundit.h
 *      Header File for Pundit
 *          Defines useful constants
 *
 *  Author:         Jeff Bienstadt
 *
 *  Environment:
 *
 *      Run-Time:   Microsoft Windows 3.0
 *
 *      Compilers/Tools:
 *                  Microsoft C 6.0
 *                  Microsoft Windows SDK 3.0
 *
 */

//#define MAX_STRING     208      // maximum string resource number

#define QUOTES_START     1
#define QUOTES_COUNT    71

#define LAWS_START      72
#define LAWS_COUNT     231

#define SNIGS_START    303
#define SNIGS_COUNT    147

#define MISC_START     450
#define MISC_COUNT      90

#define PATH_SIZE      128      // max length of a DOS path/filename

#define MAX_IN          60      // max seconds for window to show (1 minute)
#define MAX_OUT       3600      // max seconds for window to hide (1 hour)

#define ID_TIMER        1       // ID for our timer

//  Menu Choice IDs
#define IDM_QUOTES       1      // "Quotes"            menu choice ID
#define IDM_LAWS         2      // "Laws"              menu choice ID
#define IDM_SNIGS        3      // "Snigs"             menu choice ID
#define IDM_MISC         4      // "Misc"              menu choice ID
#define IDM_RANDOM       5      // "Random"            menu choice ID
#define IDM_SETTINGS    10      // "Settings..."       menu choice ID
#define IDM_ABOUT       20      // "About Pundit..."   menu choice ID
#define IDM_EXIT        30      // "Exit"              menu choice ID
#define IDM_COPY        40
#define IDM_HIDE        50
#define IDM_ICON        51
#define IDM_HELP_INDEX  90
#define IDM_HELP_HELP   91

//#define HELP_INDEX                      101


// Dialog Box Control IDs
#define IDC_INSCROLL    100     // IN time scroll bar
#define IDC_OUTSCROLL   101     // OUT time scroll bar
#define IDC_RSCROLL     102     // RED color scroll bar
#define IDC_GSCROLL     103     // GREEN color scroll bar
#define IDC_BSCROLL     104     // BLUE color scroll bar

#define IDC_INSECS      200     // IN seconds display box
#define IDC_OUTSECS     201     // OUT seconds display box
#define IDC_RED         202     // RED color display box
#define IDC_GREEN       202     // GREEN color display box
#define IDC_BLUE        202     // BLUE color display box

#define IDC_FORE        300     // FOREGROUND color radio button
#define IDC_BACK        301     // BACKGROUND color radio button

#define IDC_DEMO        400     // Text for DEMONSTRATION of color

#define IDC_SAVE        500     // "Save Settings" button



//  Private Messages
#define PM_START        (WM_USER+0x100) // Message to start timer
#define PM_PAUSE        (WM_USER+0x101) // Message to suspend timer
#define PM_DLGPAINT     (WM_USER+0x102) // Message to paint Dialog Box


//  The structure for all the settings
typedef struct _settings {
    int         insecs,     // time window is shown (in seconds)
                outsecs,    // time window is gone  (in seconds)
                cat,        // text category
                hide,       // hide mode (hidden or iconized)
                x,          // X position of window (in device units)
                y,          // Y position of window (in device units)
                width,      // width of window      (in device units)
                height;     // height of window     (in device units)
    DWORD       fore,       // color of foreground
                back;       // color of background
} SETTINGS;


//  Function Prototypes
long FAR PASCAL     WndProc(HWND, WORD, WORD, LONG);
BOOL FAR PASCAL     Settings(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL     About(HWND, unsigned, WORD, LONG);
void                FetchSettings(void);
void                InitGlobals(HANDLE);
void                BuildHelpPath(HANDLE, char *);
void                NewQuote(HWND, BOOL);
void                NewTitle(void);

