/*
 *  extras.c
 *      Source for more Windows-type functions
 *
 *  Author:         Jeff Bienstadt
 *
 *  Environment:
 *
 *      Run-Time:   Microsoft Windows 3.0
 *
 *      Compilers/Tools:
 *                  Microsoft C 6.0
 *                  Microsoft Windows SDK 3.0
 *
 */


#include    <windows.h>     // for the Windows goodies
#include    <stdlib.h>      // for itoa()
#include    "extras.h"      // function prototypes

// Write an integer value to a specified .INI file
BOOL FAR PASCAL WritePrivateProfileInt(App, Key, Value, File)
LPSTR   App,
        Key,
        File;
int     Value;
{
    char    str[17];

    return WritePrivateProfileString(App, Key,
                                     (LPSTR)itoa(Value, str, 10), File);
}


// Write an integer value to the Windows WIN.INI file
BOOL FAR PASCAL WriteProfileInt(App, Key, Value)
LPSTR   App,
        Key;
int     Value;
{
    char    str[17];

    return WriteProfileString(App, Key,
                              (LPSTR)itoa(Value, str, 10));
}

