// Virus Scan frontend - (C) Copyright 1992 by Nick Payne

#include    <owl.h>
#include    <dialog.h>
#include    <button.h>
#include    <combobox.h>
#include    <radiobut.h>
#include    <edit.h>

#include    <string.h>
#include    <ctype.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <dir.h>

#include    "vscandlg.h"

#define     APPNAME "VScan"

char const  *scan  = "SCAN ";
char const  *parm1 = "/M /BELL /CHKHI ";
char const  *parm2 = "/A";

////////////////////////////////////////////////////////////////////////
// transfer buffer structure to hold the state of the
// main window controls
////////////////////////////////////////////////////////////////////////
struct TTransferStruct
{
	WORD Dummy1;            // solves bug in transfer buffer mechanism
    WORD DriveASelected;    // radio button state
    WORD DriveBSelected;
    WORD DriveCSelected;
    WORD DriveDSelected;
	WORD Dummy2;
};


////////////////////////////////////////////////////////////////////////
// function to center a window on the screen
////////////////////////////////////////////////////////////////////////
void CenterWindow(HANDLE hWindow)
{
    int Left,   // left pos to centre on screen
        Top,    // top pos to centre on screen
        xSize,
        ySize;
    RECT Rect;  // dialog box dimensions
        
    GetWindowRect(hWindow, &Rect);
    xSize = (Rect.right - Rect.left);
    ySize = (Rect.bottom - Rect.top);
    Left = GetSystemMetrics(SM_CXSCREEN)/2 - xSize/2;
    Top  = GetSystemMetrics(SM_CYSCREEN)/2 - ySize/2;
    MoveWindow(hWindow, Left, Top, xSize, ySize, TRUE);
}


////////////////////////////////////////////////////////////////////////
// CLASS DECLARATIONS START HERE
////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////
// VScan dialog window class
// the app's main window is a dialog box
////////////////////////////////////////////////////////////////////////
class TVScan : public TDialog
{
public:
    TTransferStruct TransStruct;    // Dialog control transfer buffer
    TCheckBox *ScanAll;             // Scan all files checkbox

    TVScan();
    virtual void  SetupWindow();
    virtual LPSTR GetClassName();
    virtual void  GetWindowClass(WNDCLASS&);
    virtual void  Ok(RTMessage Msg)
        = [ID_FIRST + IDOK];
    virtual void  About(RTMessage Msg)
        = [ID_FIRST + IDB_ABOUT];
    virtual void  HandleCheckBoxMsg(RTMessage Msg)
        = [ID_FIRST + SCAN_ALL];
};


////////////////////////////////////////////////////////////////////////
// VScan application object
////////////////////////////////////////////////////////////////////////
class TVScanApp : public TApplication
{
public:
    TVScanApp(LPSTR aName, 
                HANDLE hInstance,
                HANDLE hPrevInstance, 
                LPSTR lpCmd,
                int nCmdShow) : TApplication(aName, 
                                             hInstance,
                                             hPrevInstance, 
                                             lpCmd, 
                                             nCmdShow) {};
    virtual void InitMainWindow();
};


////////////////////////////////////////////////////////////////////////
// About... dialog box
////////////////////////////////////////////////////////////////////////
class TAboutDialog : public TDialog
{
public:
    TAboutDialog(PTWindowsObject aParent,
                 LPSTR aName) : TDialog(aParent, aName) {};
    virtual void SetupWindow();
};

////////////////////////////////////////////////////////////////////////
// CLASS DECLARATIONS END HERE
////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////
// MEMBER FUNCTION DEFINITIONS START HERE
////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////
// VScan constructor
////////////////////////////////////////////////////////////////////////
TVScan::TVScan() : TDialog(NULL, APPNAME)
{
    memset(&TransStruct, 0x0, sizeof(TransStruct));  // zero fill transfer buffer
    new TRadioButton(this,
                     A_DRIVE,
                     NULL);
    new TRadioButton(this,
                     B_DRIVE,
                     NULL);
    new TRadioButton(this,
                     C_DRIVE,
                     NULL);
    new TRadioButton(this,
                     D_DRIVE,
                     NULL);
    ScanAll = new TCheckBox(this,
                            SCAN_ALL,
                            NULL);
}


////////////////////////////////////////////////////////////////////////
// set up the dialog box control values
////////////////////////////////////////////////////////////////////////
void TVScan::SetupWindow()
{
    TransStruct.DriveASelected = TRUE;
    TransStruct.DriveBSelected = FALSE;
    TransStruct.DriveCSelected = FALSE;
    TransStruct.DriveDSelected = FALSE;
    TransferBuffer = &TransStruct;
    TDialog::SetupWindow();
    ScanAll->SetCheck(BF_UNCHECKED);
    CenterWindow(HWindow);
}


////////////////////////////////////////////////////////////////////////
// We're changing the window class so we must supply a new class name
////////////////////////////////////////////////////////////////////////
LPSTR TVScan::GetClassName()
{
    return APPNAME;
}


////////////////////////////////////////////////////////////////////////
// install the application's icon
////////////////////////////////////////////////////////////////////////
void TVScan::GetWindowClass(WNDCLASS& aWndClass)
{
    TDialog::GetWindowClass(aWndClass);
    aWndClass.hIcon = LoadIcon(GetApplication()->hInstance, APPNAME);
}


////////////////////////////////////////////////////////////////////////
// proceed with processing
////////////////////////////////////////////////////////////////////////
void TVScan::Ok(RTMessage)
{
    char ScanCmd[80];
    
    strcpy(ScanCmd, scan);
    TransferData(TF_GETDATA);   // retrieve selection
    if (TransStruct.DriveASelected == TRUE)
        strcat(ScanCmd, "A: ");
    else if (TransStruct.DriveBSelected == TRUE)
        strcat(ScanCmd, "B: ");
    else if (TransStruct.DriveCSelected == TRUE)
        strcat(ScanCmd, "C: ");
    else
        strcat(ScanCmd, "D: ");
    strcat(ScanCmd, parm1);
    if (ScanAll->GetCheck() == BF_CHECKED)
        strcat(ScanCmd, parm2);
	MessageBox(0, ScanCmd, "Scan Command Line", MB_ICONINFORMATION | MB_OK);
//  WinExec(ScanCmd, SW_NORMAL);
}


////////////////////////////////////////////////////////////////////////
// toggle check box state
////////////////////////////////////////////////////////////////////////
void  TVScan::HandleCheckBoxMsg(RTMessage)
{
    ScanAll->Toggle();
}


////////////////////////////////////////////////////////////////////////
// popup the about dialog box if About... button is clicked
////////////////////////////////////////////////////////////////////////
void TVScan::About(RTMessage)
{
    GetApplication()->ExecDialog(new TAboutDialog(this, "ABOUTBOX"));
}


////////////////////////////////////////////////////////////////////////
// centre About... box on screen
////////////////////////////////////////////////////////////////////////
void TAboutDialog::SetupWindow()
{
    TDialog::SetupWindow();
    CenterWindow(HWindow);
}


////////////////////////////////////////////////////////////////////////
// create dialog box as the application's main window
////////////////////////////////////////////////////////////////////////
void TVScanApp::InitMainWindow()
{
    MainWindow = new TVScan();
}


////////////////////////////////////////////////////////////////////////
// main window module
////////////////////////////////////////////////////////////////////////
int PASCAL WinMain(HANDLE hInstance,
                   HANDLE hPrevInstance,
                   LPSTR lpCmd,
                   int nCmdShow)
{
    TVScanApp VScanApp(APPNAME,
                           hInstance,
                           hPrevInstance,
                           lpCmd,
                           nCmdShow);
    VScanApp.Run();
    return VScanApp.Status;
}

