#include "io.h"
#include "stdio.h"
#include "fcntl.h"
#include "string.h"
#include "memory.h"
#include "sys\types.h"

#define S_IFMT          0170000         /* file type mask */
#define S_IFDIR         0040000         /* directory */
#define S_IFCHR         0020000         /* character special */
#define S_IFREG         0100000         /* regular */
#define S_IREAD         0000400         /* read permission, owner */
#define S_IWRITE        0000200         /* write permission, owner */
#define S_IEXEC         0000100         /* execute/search permission, owner */

#define FILENAME           13
#define TITLE              27
#define PORTSTR            15
#define TIMESTR            10
#define PHONE              26
#define INITSTR            26
#define PROFILE            20
#define LISTSTR            20
#define MAXBUFF            128
#define MINBUFF            32
#define RECBUFLEN          4096
#define XMITBUFLEN         4096
#define OLDFILENAME        13
#define OLDTITLE           27
#define OLDPHONE           26
#define OLDLISTSTR         20


typedef struct tagSESSION
{
    char      szTitle[TITLE];
    char      szPhone[PHONE];
    int       iProtocol;
    char      szScript[FILENAME];
    int       bSessRsvd[10];
} SESSION;

typedef struct tagPORT
{
    int       iComPort;
    int       iBaudRate;
    int       iFlowCtl;
    int       iParity;
    int       iDataBits;
    int       iStopBits;
    int       bCarrier;
    int       bLockBaud;
    int       iParityCheck;
    int       bPortRsvd[10];
} PORT;

typedef struct tagTERMINAL
{
    int       iTerminal;
    int       iFontSize;
    int       iCaret;
    int       iBufLines;
    int       iRows;
    int       iCols;
    long      crFore;
    long      crBack;
    int       bCRLF;
    int       bAutoWrap;
    int       bEcho;
    int       bColors;
    char      szFont[LISTSTR];
    int       bTermRsvd[10];
} TERMINAL;

typedef struct tagZMODEMOPT
{
    int    bAutoDown;
    int    bUseCRC32;
    int    bResume;
    int    iSendMgtOpt;
    int    iRecvMgtOpt;
} ZMODEMOPT;

typedef struct tagDIR
{
    SESSION     Session;
    PORT        Port;
    TERMINAL    Terminal;
    ZMODEMOPT   ZModemOpt;
} DIR;

typedef struct tagOLDSESSION
{
    char     szTitle[OLDTITLE];
    char     szPhone[OLDPHONE];
    int      iProtocol;
    char     szScript[OLDFILENAME];
} OLDSESSION;

typedef struct tagOLDPORT
{
    int      iComPort;
    int      iBaudRate;
    int      iFlowCtl;
    int      iParity;
    int      iDataBits;
    int      iStopBits;
} OLDPORT;

typedef struct tagOLDTERMINAL
{
    int      iTerminal;
    int      iFontSize;
    int      iCaret;
    int      iBufLines;
    int      iRows;
    int      iCols;
    long     crFore;
    long     crBack;
    int      bCRLF;
    int      bEcho;
    int      bColors;
    char     szFont[OLDLISTSTR];
} OLDTERMINAL;

typedef struct tagOLDDIR
{
    OLDSESSION     OldSession;
    OLDPORT        OldPort;
    OLDTERMINAL    OldTerminal;
    ZMODEMOPT      ZModemOpt;
} OLDDIR;


main (int argc, char *argv[])
{
   int i;
   DIR Dir;
   int hDest;
   int hSource;
   OLDDIR OldDir;
   char szSource[30];
   char szDest[30];

   if (argc < 3)
   {
      printf ("Syntax is DR12DR1 SOURCE DEST\n");
      printf ("where SOURCE is the orginal dir file\n");
      printf ("and DEST is the new dir file\n");
      printf ("example CONVERT MLINK.DIR NEW.DR1\n");
      printf ("You do not need to provide the file extensions\n");

      return 1;
   }
   
   strcpy (szSource, argv[1]);
   if (!strchr (argv[1], '.'))
      strcat (szSource, ".dr1");

   strcpy (szDest, argv[2]);
   if (!strchr (argv[2], '.'))
      strcat (szDest, ".dr1");

   hDest   = creat (szDest, S_IWRITE);
   hSource = open (szSource, O_RDWR | O_BINARY);

   memset (&Dir, '\0', sizeof (DIR));
   memset (&OldDir, '\0', sizeof (OLDDIR));

   i = sizeof (OLDDIR);
   while (read (hSource, &OldDir, sizeof (OLDDIR)))
   {
	memcpy (&Dir.Session,   &OldDir.OldSession, sizeof (OLDSESSION));
	memcpy (&Dir.ZModemOpt, &OldDir.ZModemOpt,  sizeof (ZMODEMOPT));

	Dir.Port.iComPort     = OldDir.OldPort.iComPort;
	Dir.Port.iBaudRate    = OldDir.OldPort.iBaudRate;
	Dir.Port.iFlowCtl     = OldDir.OldPort.iFlowCtl;
	Dir.Port.iParity      = OldDir.OldPort.iParity;
	Dir.Port.iDataBits    = OldDir.OldPort.iDataBits;
	Dir.Port.iStopBits    = OldDir.OldPort.iStopBits;

	Dir.Port.bCarrier     = 1;
	Dir.Port.bLockBaud    = 1;
	Dir.Port.iParityCheck = 0;

	strcpy (Dir.Terminal.szFont, OldDir.OldTerminal.szFont);
	Dir.Terminal.iTerminal  = OldDir.OldTerminal.iTerminal;
	Dir.Terminal.iBufLines  = OldDir.OldTerminal.iBufLines;
	Dir.Terminal.iRows      = OldDir.OldTerminal.iRows;
	Dir.Terminal.iCols      = OldDir.OldTerminal.iCols;
	Dir.Terminal.bCRLF      = OldDir.OldTerminal.bCRLF;
	Dir.Terminal.bEcho      = OldDir.OldTerminal.bEcho;
	Dir.Terminal.iFontSize  = OldDir.OldTerminal.iFontSize;
	Dir.Terminal.iCaret     = OldDir.OldTerminal.iCaret;
	Dir.Terminal.crFore     = OldDir.OldTerminal.crFore;
	Dir.Terminal.crBack     = OldDir.OldTerminal.crBack;
	Dir.Terminal.bColors    = OldDir.OldTerminal.bColors;

	Dir.Terminal.bAutoWrap  = 1;

        write (hDest, &Dir, sizeof (DIR));
   } 
   close (hDest);
   close (hSource);
}



