
{ --------------------------------------------------------------------------
                                   EQDEMO.PAS

  ---> A sample that shows how to use the EQUATION unit to solve polynomial
       equations.

       (C) 1990, 1992 by Lenimar N. Andrade (CCENDM03@BRUFPB.BITNET)

  -------------------------------------------------------------------------- }

program EqDemo;

{$E+,N+,F+}

uses
  Equation;

var
  p: polynomial;
  roots: solutions;
  i, option: byte;

begin
  option := 0; { quick resolution }

  Writeln;
  Write('Equation''s degree (from 2 to ', MaxDegree, ' )  = ');
  Readln(p.degree);
  Writeln;

  Writeln('Coefficients following the decreasing powers of ''x'' : ');
  for i := p.degree downto 0 do
    Read(p.coef[i]);

  SolveEquation(p, option, roots);

  Writeln;
  if (not roots.solved) then
    Writeln('The resolution can''t be completed. I''m sorry.')
  else
  begin
    Writeln(' #root       real part        imaginary part      used method');
    Writeln('---------------------------------------------------------------');
    for i := 1 to p.degree do
      Writeln(i:4, roots.x[i].Re:20:10, roots.x[i].Im:20:10,
                                                         roots.x[i].method:14);
  end
end.
