/*
 *  SAMSTRAT...The Sampling Startegy Evaluator
 */

#include <stdio.h>
#include <math.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <esiprot1.h>
#include <culproto.h>

/*------------------------------------------------------------------------*/
/*  SAMSTRAT uses graphics/windowing functions from the South Mountain    */
/*  Software (Essential) Graphics ver.2 and Utilities ver.5 libraries     */
/*  (zero run-time royalty) to draw high-resolution plots on IBM-         */
/*  Compatible VGA (640x480 pixel) display screens and text-mode menus.   */
/*------------------------------------------------------------------------*/


#define K_ESC   0x01 /* get1key scan code */
#define XKEY    0x2d /* get1key scan code */
#define SKEY    0x1f /* get1key scan code */
#define DKEY    0x20 /* get1key scan code */
#define GKEY    0x22 /* get1key scan code */
#define HKEY    0x23 /* get1key scan code */
#define VKEY    0x2f /* get1key scan code */
#define WKEY    0x11 /* get1key scan code */
#define QKEY    0x10 /* get1key scan code */
#define LKEY    0x26 /* get1key scan code */
#define EKEY    0x12 /* get1key scan code */
#define F08KEY  0x42 /* get1key scan code */
#define F09KEY  0x43 /* get1key scan code */
#define F10KEY  0x44 /* get1key scan code */
#define BS      0x08   /* backspace */
#define NUL     '\0'   /* NUL char */
#define CR      0x0d   /* carriage return */
#define LF      0x0a   /* linefeed */
#define DELSC   0x53   /* Del key scan code */
#define DEL     0x5300 /* delete key */
#define NAK     0x15   /* ^U */
#define ETX     0x03   /* ^C */
#define CAN     0x18   /* ^X */
#define BEL     0x07   /* beep */
#define ESC     0x07   /* escape */

char    buf[256], yesno, outnam[13], scrbuf[4000];
double  sortcost[500], zerocost[500], sampcost[500];
double  sortmin, sortmax, sortavg, sortexpc;
double  zeromin, zeromax, zeroavg, zeroexpc;
double  sampmin, sampmax, sampavg, sampexpc;
double  samprate[500], restrate[500], truerate[500];
double  sr1, sr2, rr1, rr2, srr;
double  Pmin, Pmax, Pnow, Qnow, K1, K2, accprob, samprmax, restrmax;
FILE    *outfile;
int     kb, windo, cursrow, idum, turn;
int     cycle, lotsiz, samsiz, accept, extrain, extraout, takesize[500];
int     foundin, foundout, replics;
struct  tm *curtime;
time_t  *ltime, timex;
WIN_PTR w0, w1, w2, w3, w4;  /* some windows */

int    x, y, x2, y2;   /* Graphics cursor coordinates */
int    base[2];        /* Base Position...for Line Drawing */
int    xmin, ymin;     /* Mimimum x and y world or clip coordinates */
int    xmax, ymax;     /* Maximum x and y world or clip coordinates */
char   scrbuf[4000];

char    *winlgets( WIN_PTR wn, char *str, int va, char *vcl, int lmax );
char    *winhgets( WIN_PTR wn, char *str, int va, char *vcl, int lmax );
float   bucket( int *idum );
float   uniran16( int *idum );
float   uniran32( int *idum );
int     intget( int maxlen, int *val, int mode, int bell, int autr );
int     initseed( void );
long    found( long take );
time_t  exptime( time_t *ltime );
void    main( void );
void    handler( int sig );
void    setparms( void );
void    help( void );
void    sdump( void );
void    simulate( void );
int     nonconf( int size );
int     nonconf2( int size );
double  logcomb( int n, int k );
double  cumprob( int accnum, int samsiz );
void    histog( double data[], double dmin, double dmax, double mean );

extern  int  isalpha( int );
extern  int  get1key( void );
extern  int  kbhit( void );
extern  int  grtext( int row, int col, int att, char *string );
extern  void exit( int code );

void histog( double data[], double dmin, double dmax, double mean ) {

        int idx, ifreq, maxf, freq[13];
        double stddev, cut[13];

        for( idx = 0; idx < 13; idx++ ) {
            freq[idx] = 0;
            if( dmax > dmin )
                cut[idx] = dmin + (double)idx*(dmax-dmin)/12.0;
            else
                cut[idx] = dmin;
            }

        stddev = 0.0;
        for( idx = 0; idx < replics; idx++ ) {
            if( dmax > dmin )
                ifreq = (int)( 12.0*(data[idx]-dmin)/(dmax-dmin) );
            else
                ifreq = 0;
            freq[ifreq]++;
            }

        for( idx = 0; idx < replics; idx++ )
            stddev += ( data[idx] - mean ) * ( data[idx] - mean );
        stddev = sqrt( stddev / (double)replics );

        maxf = 0;
        for( idx = 0; idx < 13; idx++ ) {
            if( maxf < freq[idx] )
                maxf = freq[idx];
            }

        if( dmax > dmin ) {
            win_prtf( w3, 1, "\n\n\t LowLimit Freq" );
            win_prtf( w3, 1, "\n\t -------- --- --------------------------------------------------" );
            fprintf( outfile, "\n\n LowLimit Freq" );
            fprintf( outfile, "\n -------- --- --------------------------------------------------" );
            for( idx = 12; idx >= 0; idx-- ) {
                win_prtf( w3, 1, "\n\t%9.2lf %3d ", cut[idx], freq[idx] );
                fprintf( outfile, "\n%9.2lf %3d ", cut[idx], freq[idx] );
                for( ifreq = 0; ifreq < 50; ifreq++ ) {
                    if( ifreq < 50*freq[idx]/maxf ) {
                        win_prtf( w3, 0, "*" );
                        fprintf( outfile, "*" );
                        }
                    }
                }
            win_prtf( w3, 1, "\n\t -------- --- --------------------------------------------------" );
            win_prtf( w3, 1, "\n\t LowLimit Freq       Press a Key..." );
            fprintf( outfile, "\n -------- --- --------------------------------------------------" );
            fprintf( outfile, "\n LowLimit Freq" );
            }
        win_prtf( w3, 1, "\n\t Observed Standard Deviation = %9.2lf", stddev );
        fprintf( outfile, "\n Observed Standard Deviation = %9.2lf", stddev );
        }

/* Logarithm of the Combinatorial Coefficient */

double logcomb( int n, int k ) {

        int i;
        double  dk, dn, index, logc, log();

        logc = 0;
        if( k >= n || k <= 0 ) return( logc );

        if( n - k < k ) k = n - k;

        dk = (double)k;
        dn = (double)n;

        for( i=0; i<k; i++ ) {
                index = (double)i;
                logc += log( dn - index ) - log( dk - index );
                }

        return( logc );

        }  /* end logcomb */


/* Acceptance Probability Calculation for Single Stage Sampling */

double cumprob( int accnum, int samsiz ) {

        int    index;
        double sprob, cprob;
        double exp(), logcomb();
        double lp, lq;

        /* CUMPROB will be set equal to the probability that a BINOMIAL */
        /* random variable with success probability p in each of samsiz */
        /* independent Bernoulli trials will be less than or equal to accnum */

        lp = log( Pnow );
        lq = log( Qnow );
        cprob = 0;

        if( accnum < 0 || samsiz < 0 || accnum > samsiz ) return( cprob );

        for( index=0; index<=accnum; index++) {

                sprob = exp( logcomb( samsiz, index ) +
                             (double)index * lp +
                             (double)(samsiz-index) * lq );

                if( sprob > 1 )
                        sprob = 1;
                else if( sprob < 0 )
                        sprob = 0;

                cprob += sprob;
                }

        if( cprob > 1 )
               cprob = 1;
        else if( cprob < 0 )
               cprob = 0;

        return( cprob );
        }

/*
 * Use a bucket to guard against time-series structure in the 32-bit
 * L'Ecuyer pseudo-random number generator; withdraw from the bucket
 * using the 16-bit L'Ecuyer pseudo-random number generator.
 */

float bucket( int *idum ) {

        static int iff=0;
        static float rand[100];
        int j;
        float temp;

        if( iff == 0 ) {
            iff = 1;
            for( j = 0; j < 100; j++ )
                rand[j] = uniran32( idum );
            }

        j = (int)( 100.0 * (double)uniran16( idum ) - 0.5 );
        if( j < 0 )
            j = 0;
        if( j > 99 )
            j = 99;

        temp = rand[j];
        rand[j] = uniran32( idum );
        return temp;
        }

/*
 * Portable 16 and 32-bit random number generators proposed by Pierre
 * L'Ecuyer(1988), Communications of the ACM 31, 742-749 and 774.
 */

/*
 * UNIRAN16: Static integer seed values s1, s2, and s3 must not only be
 * >= 1 but also s1 <= 32362, s2 <= 31726, and s3 <= 31656, respectively.
 */

float uniran16( int *idum ) {

        static int s1, s2, s3, ldum, iff=0;

        if( *idum < 0 || iff == 0 ) {
                ldum = abs(*idum);
                if( ldum < 1 )
                    ldum = 1;
                if( ldum > 31656 )
                    ldum = 31656;
                s1 = s2 = s3 = ldum;
                *idum = iff = 1;
                }

        ldum = s1 / 206;
        s1 =  157 * ( s1 - ldum * 206 ) - ldum * 21;
        if( s1 < 0 )
            s1 += 32363;

        ldum = s2 / 217;
        s2 =  146 * ( s2 - ldum * 217 ) - ldum * 45;
        if( s2 < 0 )
            s2 += 31727;

        ldum = s3 / 222;
        s3 =  142 * ( s3 - ldum * 222 ) - ldum * 133;
        if( s3 < 0 )
            s3 += 31657;

        ldum = s1 - s2;
        if( ldum > 706 )
            ldum -= 32362;
        ldum += s3;
        if( ldum < 1 )
            ldum += 32362;

        return (float)( (double)ldum * 3.0899e-5 );
        }

/*
 * UNIRAN32: Static long seed values s1 and s2 must not only be >= 1
 * but also s1 <= 2,147,483,562 and s2 <= 2,147,483,398, respectively.
 * Here, the initial seed is a 16-bit integer; s1 = s2 <= 32767.
 */

float uniran32( int *idum ) {

        static long s1, s2, ldum;
        static int iff=0;

        if( *idum < 0 || iff == 0 ) {
                ldum = (long)abs(*idum);
                if( ldum < (long)1 )
                    ldum = (long)1;
                s1 = s2 = ldum;
                *idum = iff = 1;
                }

        ldum = s1 / (long)53668;
        s1 =  (long)40014 * ( s1 - ldum * (long)53668 ) - ldum * (long)12211;
        if( s1 < 0 )
            s1 += (long)2147483563;

        ldum = s2 / (long)52774;
        s2 =  (long)40692 * ( s2 - ldum * (long)52774 ) - ldum * (long)3791;
        if( s2 < 0 )
            s2 += (long)2147483399;

        ldum = s1 - s2;
        if( ldum < (long)1 )
            ldum += (long)2147483562;

        return (float)( (double)ldum * 4.656613e-10 );
        }

/*
 * nonconf( N ) = number of nonconformances observed in a sequence of N
 *                independent Bernoulli trials with nonconformance
 *                probability stored in the global variable Pnow.
 */

int nonconf( int size ) {

        extern double Pnow;
        float rand;
        int idx, find;

        if( size <= 0 )
            return( 0 );

        find = 0;
        for( idx = 0; idx < size; idx++ ) {

            rand = bucket( &idum );
            if( rand <= Pnow )
                find++;
            }
        return( find );
        }

/*
 * nonconf2( N ) = number of independent Bernoulli trials with
 *                 nonconformance probability stored in the global
 *                 variable Pnow needed to find N conforming items.
 */

int nonconf2( int size ) {

        extern double Pnow;
        float rand;
        int idx, find;

        if( size <= 0 )
            return( 0 );

        find = idx = 0;
        while( 1 ) {

            idx++;
            rand = bucket( &idum );
            if( rand > Pnow )
                find++;
            if( find >= size )
                break;
            }
        return( idx );
        }

/*
 *      exptime()...time expired running SamStrat (using the Microsoft
 *                  long time() function to read system clock.)
 */

time_t exptime( ltime )
time_t *ltime; {

    time_t etime;
    static time_t begin = (long)0;

    time( &etime );
    *ltime = etime ;
    if( begin == (long)0 ) {
            begin = etime ;
            return (long)0;
            }
    else {
            etime -= begin;
            begin = *ltime;
            return etime;
            }
    }

void handler( int sig ) {     /* Interrupt Handler */
      /* ^C Break Disabled */
      signal( SIGINT, handler );
      }

/*
 *      initseed()...initialize pseudo-random sequence using the Microsoft
 *                   long time() function to read system clock.
 */

int initseed() {
      long ltime;
      int seed;

      time( &ltime );
      seed = (int)ltime ;
      if( seed > 0 )
          return -seed;
      else if( seed == 0 )
          return -13;
      else
          return seed;
      }

/*
**  winhgets  ...like winlgets but characters entered are HIDDEN
*/

char *winhgets( wn, buf, va, cl, l )    /* get string from window */
WIN_PTR wn;                             /* Window pointer */
char buf[];                             /* user buffer */
int va;                                 /* validation type */
char *cl;                               /* user validation string */
int l; {                                /* maximum number of chars */

  char *p;                              /* local pointer */
  int c;                                /* local character */
  int cc;                               /* character count */

  win_totop(wn);                        /* make sure window is on top */
  p = buf;                              /* init local pointer */
  cc = 0;                               /* init char count */
  *p = NUL;                             /* set up for abort */

  while( cc < l ) {                     /* while string length below max */
    c = get1key();                      /* keyboard Input */
    if( !(c & 0xff) ) {                 /* scan code ?? */
      switch( c >> 8 ) {                /* remapping goes here */
        case DELSC:                     /* Del key */
          c = DEL;                      /* map to delete */
        default:                        /* all others to NOP */
          break;
        }
      }
    c &= 0x7f;                          /* keyboard input */
    if( !c )
      continue;                         /* NUL */
    if( c == ESC || c == CR ) {         /* treat <CR> and ESC the same */
      win_prtf( wn, 1, "%c", CR );
      win_prtf( wn, 1, "%c", LF );      /* print them */
      return( p );                      /* and return */
      }
    if( c == BS || c == DEL ) {         /* check for RUBOUT */
      if( cc <= 0 ) continue;           /* nothing to rub out */
      win_prtf( wn, 1, "\b \b" );       /* delete a char */
      cc--;                             /* decrement char count */
      p--;                              /* decrement pointer */
      *p = NUL;                         /* terminate string */
      continue;                         /* and continue */
      }
    if( c == CAN || c == NAK ||         /* ^X or ^U */
        c == ETX ) {                    /*  or ^C */
      while( cc > 0 ) {                 /* do it till cc is zip */
        win_prtf( wn, 1, "\b \b" );     /* delete a char */
        cc--;                           /* decrement cc */
        p--;                            /* decrement pointer */
        *p = NUL;                       /* terminate string */
        continue;                       /* and continue */
        }
      }
    if( c < ' ' )
      continue;                         /* not printable !! */

    switch( va ) {
      case 1:                           /* no vaidation */
        break;                          /* dont do anything */
      case 2:                           /* integer */
        if( c >= '0' && c <= '9' )      /* valid digit ?? */
          break;                        /* ok.. */
        if( c == '-' || c == '+' )      /* sign ?? */
          break;                        /* ok.. */
        c = NUL;                        /* say ng */
        break;
      case 3:                           /* floating pt */
        if( c >= '0' && c <= '9' )      /* valid digit */
          break;                        /* ok */
        if( c == '-' || c == '+' || c == '.' )
          break;                        /* sign or decimal point */
        c = NUL;                        /* say ng */
        break;
      case 4:                           /* alpha only */
        if( isalpha( c ) )              /* alpha ?? */
          break;                        /* ok */
        c = NUL;                        /* something else */
        break;
      case 5:                           /* upper case only */
        if( isalpha( c ) ) {            /* alpha ?? */
          c = toupper( c );             /* force upper case */
          break;
          }
        c = NUL;                        /* no cigars */
        break;
      case 6:                           /* user supplied list */
        if( strchr( cl, c ) )           /* in the list ?? */
          break;                        /* ok */
        c = NUL;                        /* no cigars */
        break;
      default:                          /* ?? */
        c = NUL;                        /* all others get eaten!! */
        break;
      }
    if( c == NUL ) {                    /* NUL sez validation is ng! */
      win_prtf( wn, 1, "%c", BEL );     /* beep */
      continue;                         /* and continue */
      }
    *p++ = (char)c;                     /* char is ok */
    *p = NUL;                           /* terminate string */
    cc++;                               /* bump count of displayed chars */
    }
  return( p );                          /* return ptr to buffer */
  }

void setparms() {

      win_totop( w0 );
      win_cls( w0 );
      win_prtf( w0, 1, "\n\n\tAt colon Prompts : ...simply press ENTER to get the [default]." );

      if( outfile == NULL ) {

          strcpy( outnam, "SAMSTRAT" );
          strcat( outnam, ".OUT" );
          win_prtf( w0, 1, "\n\n\tSpecify filename to save Output [%s] : ", outnam );
          winlgets( w0, buf, 1, 0, 9 );
          if( buf[0] != '\0' && buf[0] != '\r' && buf[0] != '\n' )
                  sscanf( buf, "%s", outnam );
          outnam[ min( 8, (int)strcspn( outnam, ". " ) ) ] = '\0';
          if( outnam[0] == '\0' )
                  strcpy( outnam, "SAMSTRAT" );
          strcat( outnam, ".out" );
          win_prtf( w0, 1, "\n\tThe SamStrat Output file is to be: %s\n",
                  outnam );
          if( ( outfile = fopen( outnam, "w" ) ) == NULL ) {
                  win_prtf( w0, 1, "\tCannot write to Output filename : %s\n", outnam );
                  if( ( outfile = fopen( "samstrat.out", "w" ) ) == NULL )
                          win_prtf( w0, 1, "\tCannot write to Output filename : samstrat.out\n" );
                  else {
                          win_prtf( w0, 1, "\t...using default Outfile name : samstrat.out\n" );
                          strcpy( outnam, "samstrat.out" );
                          }
                  }
          }

      win_prtf( w0, 1, "\n\n\tWhat will be the MINIMUM Fraction Nonconforming for" );
      win_prtf( w0, 1,   "\n\tany LOT ? (min=0.01;max=0.50) [%4.2lf] : ", Pmin );
      winlgets( w0, buf, 6, ".1234567890", 4 );  /* at most 3 digits & enter key */
      if( buf[0] != '\0' && buf[0] != '\r' && buf[0] != '\n' )
          sscanf( buf, "%lf", &Pmin );
      if( Pmin < 0.01 )
          Pmin = 0.01;
      if( Pmin > 0.50 )
          Pmin = 0.50;
      win_prtf( w0, 1, "\n\n\tMinimum Fraction Nonconforming = %4.2lf.", Pmin );

      win_prtf( w0, 1, "\n\n\tWhat will be the MAXIMUM Fraction Nonconforming for" );
      win_prtf( w0, 1,   "\n\tany LOT ? (min=0.01;max=0.50) [%4.2lf] : ", Pmax );
      winlgets( w0, buf, 6, ".1234567890", 4 );  /* at most 3 digits & enter key */
      if( buf[0] != '\0' && buf[0] != '\r' && buf[0] != '\n' )
          sscanf( buf, "%lf", &Pmax );
      if( Pmax < Pmin )
          Pmax = Pmin;
      if( Pmax > 0.50 )
          Pmax = 0.50;
      win_prtf( w0, 1, "\n\n\tMaximum Fraction Nonconforming = %4.2lf.", Pmax );

      if( Pmax == Pmin )
          cycle = 0;
      else {
          win_prtf( w0, 1, "\n\n\tFraction Nonconforming will cycle UP and DOWN between" );
          win_prtf( w0, 1,   "\n\tPmax = %4.2lf", Pmax );
          win_prtf( w0, 0,   " and Pmin = %4.2lf", Pmin );
          win_prtf( w0, 0,   " following a regular," );
          win_prtf( w0, 1,   "\n\tsinusoidal pattern.  How many LOTS will be produced between" );
          win_prtf( w0, 1,   "\n\tsuccessive Pmin and Pmax rates ? (min=0;max=49) [%d] : ", cycle );
          winlgets( w0, buf, 6, "1234567890", 3 );  /* at most 2 digits & enter key */
          if( buf[0] != '\0' && buf[0] != '\r' && buf[0] != '\n' )
              sscanf( buf, "%d", &cycle );
          if( cycle < 0 )
              cycle = 0;
          if( cycle > 49 )
              cycle = 49;
          win_prtf( w0, 1, "\n\n\tLots per Sinusoidal Cycle = %d.", cycle + 1 );
          }

      win_prtf( w0, 1, "\n\n\tWhat will be the cost, K1, of inspecting one" );
      win_prtf( w0, 1,   "\n\tunit ? (min=0.01;max=50) [%5.2lf] : ", K1 );
      winlgets( w0, buf, 6, ".1234567890", 6 );
      if( buf[0] != '\0' && buf[0] != '\r' && buf[0] != '\n' )
          sscanf( buf, "%lf", &K1 );
      if( K1 < 0.01 )
          K1 = 0.01;
      if( K1 > 50.0 )
          K1 = 50.0;
      win_prtf( w0, 1, "\n\n\tUnit Cost of Inspection, K1 = %5.2lf.", K1 );

      win_prtf( w0, 1, "\n\n\tWhat will be the cost, K2, of reworking one" );
      win_prtf( w0, 1,   "\n\tnonconforming unit ? (min=0.01;max=500) [%6.2lf] : ", K2 );
      winlgets( w0, buf, 6, ".1234567890", 7 );
      if( buf[0] != '\0' && buf[0] != '\r' && buf[0] != '\n' )
          sscanf( buf, "%lf", &K2 );
      if( K2 < 0.01 )
          K2 = 0.01;
      if( K2 > 500.0 )
          K2 = 500.0;
      win_prtf( w0, 1, "\n\n\tUnit Cost of Rework, K2 = %6.2lf.", K2 );

      win_prtf( w0, 1, "\n\n\tWhat will be the lot size, N ?" );
      win_prtf( w0, 1,   "\n\t(min=10;max=5000) [%4d] : ", lotsiz );
      winlgets( w0, buf, 6, "1234567890", 5 );
      if( buf[0] != '\0' && buf[0] != '\r' && buf[0] != '\n' )
          sscanf( buf, "%d", &lotsiz );
      if( lotsiz < 10 )
          lotsiz = 10;
      if( lotsiz > 5000 )
          lotsiz = 5000;
      win_prtf( w0, 1, "\n\n\tNumber of items in a lot, N = %6d.", lotsiz );

      win_prtf( w0, 1, "\n\n\tWhat will be the sample size, n ?" );
      win_prtf( w0, 1,   "\n\t(min=1;max=N-1) [%4d] : ", samsiz );
      winlgets( w0, buf, 6, "1234567890", 5 );
      if( buf[0] != '\0' && buf[0] != '\r' && buf[0] != '\n' )
          sscanf( buf, "%d", &samsiz );
      if( samsiz < 1 )
          samsiz = 1;
      if( samsiz > lotsiz - 1 )
          samsiz = lotsiz - 1;
      win_prtf( w0, 1, "\n\n\tNumber of items in a sample, n = %4d.", samsiz );

      win_prtf( w0, 1, "\n\n\tWhat will be the accept number, c ?" );
      win_prtf( w0, 1,   "\n\t(min=0;max=n-1) [%4d] : ", accept );
      winlgets( w0, buf, 6, "1234567890", 5 );
      if( buf[0] != '\0' && buf[0] != '\r' && buf[0] != '\n' )
          sscanf( buf, "%d", &accept );
      if( accept < 0 )
          accept = 0;
      if( accept > samsiz - 1 )
          accept = samsiz - 1;
      win_prtf( w0, 1, "\n\n\tSampling acceptance number, c = %4d.", accept );

      idum = 0;
      win_prtf( w0, 1, "\n\n\tInput Simulation Start-up Seed ( 0 means use your Clock ): " );
      winlgets( w0, buf, 6, "1234567890", 6 );  /* at most 5 digits & enter key */
      sscanf( buf, "%d", &idum );
      if( idum == 0 )
              idum = initseed();
      else if( idum > 0 )
              idum = -idum ;
      win_prtf( w0, 1, "\n\n\tEquivalent Start-Up Seed = %d.", idum );

      if( outfile != NULL ) {
          fprintf( outfile, "\n*********************************************" );
          fprintf( outfile, "\nSampling Strategy Simulator..." );
          timex = exptime( ltime );
          curtime = localtime( ltime );
          fprintf( outfile, "\nDate/Time Stamp : %s", asctime( curtime ) );
          fprintf( outfile, "Equivalent Start-Up Seed = %d.", idum );
          fprintf( outfile, "\nMinimum Fraction Nonconforming = %4.2lf.", Pmin );
          fprintf( outfile, "\nMaximum Fraction Nonconforming = %4.2lf.", Pmax );
          fprintf( outfile, "\nLots per Sinusoidal Cycle = %d.", cycle + 1 );
          fprintf( outfile, "\nUnit Cost of Inspection, K1 = %5.2lf.", K1 );
          fprintf( outfile, "\nUnit Cost of Rework, K2 = %6.2lf.", K2 );
          fprintf( outfile, "\nNumber of items in a lot, N = %6d.", lotsiz );
          fprintf( outfile, "\nNumber of items in a sample, n = %4d.", samsiz );
          fprintf( outfile, "\nSampling acceptance number, c = %4d.", accept );
          }

      win_prtf( w0, 1, "\n\n\t\tPress a Key to Continue..." );
      get1key();
      win_cls( w0 );
      }

void simulate() {

      w2 = win_open(1,1,20,74,0,2,2,0,2," Sampling Simulation ",0,2,"",0,2);

      turn++;
      win_prtf( w2, 1, "\n\n\tWelcome to the SAMSTRAT Simulation..." );
      win_prtf( w2, 1, "\n\n\tPlease respond to the following prompts for Information.\n" );

      win_prtf( w2, 1, "\n\n\tHow many Monte-Carlo Replications do you wish" );
      win_prtf( w2, 1,   "\n\tto evaluate ? (nin=50,max=500) [%d] : ", replics );
      winlgets( w2, buf, 6, "1234567890", 4 );  /* at most 3 digits & enter key */
      if( buf[0] != '\0' && buf[0] != '\r' && buf[0] != '\n' )
          sscanf( buf, "%d", &replics );
      if( replics < (long)50 )
          replics = (long)50;
      if( replics > (long)500 )
          replics = (long)500;
      win_prtf( w2, 1, "\n\n\tNow performing %d replications...", replics );
      win_prtf( w2, 1, "\n\n\tPress a Key to Stop Simulating." );
      win_prtf( w2, 1, "\n\n\tReplication Number = 0" );
      cursrow = w2->cur_row;

      sampavg  = sortavg  = zeroavg  = 0.0;
      sampexpc = sortexpc = zeroexpc = 0.0;
      samprmax = restrmax = 0.0;
      fprintf( outfile, "\n\n TrueP Sample  RestP TakenT SortCost ZeroCost SampCost" );

      for( turn = 0; turn < replics; turn++ ) {

          if( Pmax == Pmin )
              Pnow =  Pmin;
          else {
              Pnow = 3.1415929 * (double)turn / (double)( cycle + 1 );
              Pnow = Pmin + 0.5 * ( Pmax - Pmin ) *
                     ( 1.0 - cos( Pnow ) );
              }
          truerate[turn] = Pnow;

          Qnow = 1.0 - Pnow;
          accprob = cumprob( accept, samsiz );

          foundin = nonconf( samsiz );
          samprate[turn] = (double)foundin / (double)samsiz;
          if( samprmax < samprate[turn] )
              samprmax = samprate[turn];

          foundout = nonconf( lotsiz - samsiz );
          restrate[turn] = (double)foundout / (double)( lotsiz - samsiz );
          if( restrmax < restrate[turn] )
              restrmax = restrate[turn];

          extrain  = nonconf2( foundin );
          extraout = nonconf2( foundout );
          takesize[turn] = lotsiz + extrain + extraout;

          sortcost[turn] = K1 * takesize[turn];

          zerocost[turn] = K2 * ( extrain + extraout );

          sampcost[turn] = K1 * ( samsiz + extrain );
          if( foundin <= accept )
              sampcost[turn] += K2 * extraout;
          else
              sampcost[turn] = sortcost[turn];

          sampavg += sampcost[turn];
          sortavg += sortcost[turn];
          zeroavg += zerocost[turn];

          zeroexpc += (double)lotsiz * Pnow * K2 / ( 1.0 - Pnow );
          sortexpc += (double)lotsiz * K1 / ( 1.0 - Pnow );
          sampexpc += (double)lotsiz * K1 / ( 1.0 - Pnow ) -
              (double)( lotsiz -samsiz ) * ( K1 - K2 * Pnow ) * accprob;

          if( turn > 0 ) {
              if( sampmin > sampcost[turn] )
                  sampmin = sampcost[turn];
              if( sampmax < sampcost[turn] )
                  sampmax = sampcost[turn];
              if( sortmin > sortcost[turn] )
                  sortmin = sortcost[turn];
              if( sortmax < sortcost[turn] )
                  sortmax = sortcost[turn];
              if( zeromin > zerocost[turn] )
                  zeromin = zerocost[turn];
              if( zeromax < zerocost[turn] )
                  zeromax = zerocost[turn];
              }
          else {
              sampmin = sampmax = sampcost[0];
              sortmin = sortmax = sortcost[0];
              zeromin = zeromax = zerocost[0];
              }

          win_curset( cursrow, 0 );
          win_prtf( w2, 1, "\tReplication Number = %d", turn + 1 );

          fprintf( outfile, "\n%6.4lf %6.4lf %6.4lf %6d %8.2lf %8.2lf %8.2lf",
              truerate[turn], samprate[turn], restrate[turn],
              takesize[turn],
              sortcost[turn], zerocost[turn], sampcost[turn] );

          if( kbhit() ) {
              replics = turn + 1;
              break;
              }
          }
      win_prtf( w2, 1, "\n\n\tReplications Performed = %d.", replics );
      fprintf( outfile, "\nReplications Performed = %d.", replics );
      sampavg /= (double)replics;
      sortavg /= (double)replics;
      zeroavg /= (double)replics;
      sampexpc /= (double)replics;
      sortexpc /= (double)replics;
      zeroexpc /= (double)replics;

      w3 = win_open(2,3,20,74,0,7,7,0,7," SamStrat Results ",0,7,"",0,7);

      win_prtf( w3, 1, "\n\n\tFor the 100%% Sorting Strategy..." );
      win_prtf( w3, 1,   "\n\t\tMaximum Observed Cost = %8.2lf", sortmax );
      win_prtf( w3, 1,   "\n\t\tAverage Observed Cost = %8.2lf", sortavg );
      win_prtf( w3, 1,   "\n\t\tMinimum Observed Cost = %8.2lf", sortmin );
      win_prtf( w3, 1,   "\n\t\tAverage Expected Cost = %8.2lf", sortexpc );
      win_prtf( w3, 1,   "\n\tFor the Sampling Strategy..." );
      win_prtf( w3, 1,   "\n\t\tMaximum Observed Cost = %8.2lf", sampmax );
      win_prtf( w3, 1,   "\n\t\tAverage Observed Cost = %8.2lf", sampavg );
      win_prtf( w3, 1,   "\n\t\tMinimum Observed Cost = %8.2lf", sampmin );
      win_prtf( w3, 1,   "\n\t\tAverage Expected Cost = %8.2lf", sampexpc );
      win_prtf( w3, 1,   "\n\tFor the Zero Inspection Strategy..." );
      win_prtf( w3, 1,   "\n\t\tMaximum Observed Cost = %8.2lf", zeromax );
      win_prtf( w3, 1,   "\n\t\tAverage Observed Cost = %8.2lf", zeroavg );
      win_prtf( w3, 1,   "\n\t\tMinimum Observed Cost = %8.2lf", zeromin );
      win_prtf( w3, 1,   "\n\t\tAverage Expected Cost = %8.2lf", zeroexpc );

      fprintf( outfile,  "\nFor the 100%% Sorting Strategy..." );
      fprintf( outfile,  "\nMaximum Observed Cost = %8.2lf", sortmax );
      fprintf( outfile,  "\nAverage Observed Cost = %8.2lf", sortavg );
      fprintf( outfile,  "\nMinimum Observed Cost = %8.2lf", sortmin );
      fprintf( outfile,  "\nAverage Expected Cost = %8.2lf", sortexpc );
      fprintf( outfile,  "\nFor the Sampling Strategy..." );
      fprintf( outfile,  "\nMaximum Observed Cost = %8.2lf", sampmax );
      fprintf( outfile,  "\nAverage Observed Cost = %8.2lf", sampavg );
      fprintf( outfile,  "\nMinimum Observed Cost = %8.2lf", sampmin );
      fprintf( outfile,  "\nAverage Expected Cost = %8.2lf", sampexpc );
      fprintf( outfile,  "\nFor the Zero Inspection Strategy..." );
      fprintf( outfile,  "\nMaximum Observed Cost = %8.2lf", zeromax );
      fprintf( outfile,  "\nAverage Observed Cost = %8.2lf", zeroavg );
      fprintf( outfile,  "\nMinimum Observed Cost = %8.2lf", zeromin );
      fprintf( outfile,  "\nAverage Expected Cost = %8.2lf", zeroexpc );

      while( kbhit() != 0 )
          get1key();
      win_prtf( w3, 1, "\n\n\t\tPress a Key to Display Histograms..." );
      get1key();

      histog( sortcost, sortmin, sortmax, sortavg );
      win_prtf( w3, 1, "\n\t Costs of 100%% Sort..." );
      fprintf( outfile, "\n Costs of 100%% Sort..." );
      get1key();

      histog( zerocost, zeromin, zeromax, zeroavg );
      win_prtf( w3, 1, "\n\t Costs of Zero Inspection..." );
      fprintf( outfile, "\n Costs of Zero Inspection..." );
      get1key();

      histog( sampcost, sampmin, sampmax, sampavg );
      win_prtf( w3, 1, "\n\t Costs of Acceptance Sampling..." );
      fprintf( outfile, "\n Costs of Acceptance Sampling..." );
      get1key();

      win_prtf( w3, 1, "\n\n\tThe VGA screens will show charts of nonconformance" );
      win_prtf( w3, 1,   "\n\trates in the sample or in the remainder of the lot," );
      win_prtf( w3, 1,   "\n\talong with the true nonconformance rate.  And the" );
      win_prtf( w3, 1,   "\n\tlast plot shows the sample rate on the horizontal" );
      win_prtf( w3, 1,   "\n\taxis versus the remainder rate on the vertical axis." );

      win_prtf( w3, 1, "\n\n\tSCREEN DUMPS to slave parallel PRINTERS on LPT1:" );
      win_prtf( w3, 1,   "\n\t  Press the L key or F10 for HP Laser/Desk Jet." );
      win_prtf( w3, 1,   "\n\t  Press the G key or F09 for IBM graphics dot matrix." );
      win_prtf( w3, 1,   "\n\t  Press the E key or F08 for Epson FX, JX or LQ." );

      while( kbhit() != 0 )
          get1key();
      win_prtf( w3, 1, "\n\n\tPress a Key to initiate Graphics..." );
      get1key();

      curtype(1,0,0);
      scrtomem( 2000, 0, scrbuf  );

      setvga();     /* assume IBM-compatible graphics adapter */
      initgraf( 18, 2, 0 );    /* Initialize vga graphics mode */
      fontinit();
      fontld( 0, "VGA8X16" ); /* Std. 8x16 Font from IBM ReadOnlyMemory */

      while( 1 ) {

          /* Clear out KeyBoard Buffer */
          while( kbhit() != 0 )
              get1key();

          grxlab( "    Chart of Sample and True Nonconformance Rates...", 7, 0, 0 );

          setview( 0, 16, 639, 479 );
          ymax = (int)( 1000.0 * samprmax );
          if( Pmax > samprmax )
              ymax = (int)( 1000.0 * Pmax );
          xmax =  replics;
          xmin = -1;
          ymin =  0;
          setworld( xmin, ymax, xmax, ymin );
          worldon( 1 );

          set_base( xmin, ymin );        /* base[0] = xmin; base[1] = ymin; */
          grmove( xmin, ymax, 3 );       /* 3 => cyan */
          grmove( xmax, ymax, 3 );
          grmove( xmax, ymin, 3 );
          grmove( xmin, ymin, 3 );

          for( x = 0; x < replics; x++ ) {
              y = (int)( 1000.0 * samprate[x] );
              if( x == 0 )
                  set_base( x, y );
              else
                  grmove( x, y, 7 );           /* 7 => white */
              }

          for( x = 0; x < replics; x++ ) {
              y = (int)( 1000.0 * truerate[x] );
              if( x == 0 )
                  set_base( x, y );
              else
                  grmove( x, y, 2 );           /* 2 => green */
              }

          sdump();

          initgraf( 18, 2, 0 );    /* Initialize vga graphics mode */

          grxlab( "    Chart of Remainder and True Nonconformance Rates...", 7, 0, 0 );

          setview( 0, 16, 639, 479 );
          ymax = (int)( 1000.0 * restrmax );
          if( Pmax > restrmax )
              ymax = (int)( 1000.0 * Pmax );
          xmax =  replics;
          xmin = -1;
          ymin =  0;
          setworld( xmin, ymax, xmax, ymin );
          worldon( 1 );

          set_base( xmin, ymin );        /* base[0] = xmin; base[1] = ymin; */
          grmove( xmin, ymax, 3 );       /* 3 => cyan */
          grmove( xmax, ymax, 3 );
          grmove( xmax, ymin, 3 );
          grmove( xmin, ymin, 3 );

          for( x = 0; x < replics; x++ ) {
              y = (int)( 1000.0 * restrate[x] );
              if( x == 0 )
                  set_base( x, y );
              else
                  grmove( x, y, 7 );           /* 7 => white */
              }

          for( x = 0; x < replics; x++ ) {
              y = (int)( 1000.0 * truerate[x] );
              if( x == 0 )
                  set_base( x, y );
              else
                  grmove( x, y, 2 );           /* 2 => green */
              }

          sdump();

          initgraf( 18, 2, 0 );    /* Initialize vga graphics mode */

          grxlab( "    Sample and Remainder of Lot Nonconformance Rates...", 7, 0, 0 );

          setview( 0, 16, 450, 479 );
          xmax = (int)( 1000.0 * samprmax );
          ymax = (int)( 1000.0 * restrmax );
          if( xmax < ymax )
              xmax = ymax;
          if( ymax < xmax )
              ymax = xmax;
          xmin =  0;
          ymin =  0;
          setworld( xmin, ymax, xmax, ymin );
          worldon( 1 );

          set_base( xmin, ymin );        /* base[0] = xmin; base[1] = ymin; */
          grmove( xmin, ymax, 3 );       /* 3 => cyan */
          grmove( xmax, ymax, 3 );
          grmove( xmax, ymin, 3 );
          grmove( xmin, ymin, 3 );

          sr1 = sr2 = rr1 = rr2 = srr = 0.0;
          for( turn = 0; turn < replics; turn++ ) {

              x = (int)( 1000.0 * samprate[turn] );
              y = (int)( 1000.0 * restrate[turn] );

              sr1 += samprate[turn];
              rr1 += restrate[turn];
              sr2 += samprate[turn] * samprate[turn];
              rr2 += restrate[turn] * restrate[turn];
              srr += samprate[turn] * restrate[turn];

              if( turn == 0 )
                  set_base( x, y );
              else
                  grmove( x, y, 7 );           /* 7 => white */
              }

          sr1 /= (double)replics;
          rr1 /= (double)replics;
          sr2 -= replics * sr1 * sr1;
          rr2 -= replics * rr1 * rr1;
          srr -= replics * sr1 * rr1;
          srr /= sqrt( sr2 * rr2 );

          sdump();

          break;
          }

      initgraf( 3, 0, 0 );  /* 80 col. color text */
      memtoscr( 2000, 0, scrbuf );
      curtype(1,0,0);

      win_prtf( w3, 1,  "\n\n\t Average Sample Nonconformance Rate = %6.4lf", sr1 );
      fprintf( outfile, "\n Average Sample Nonconformance Rate = %6.4lf", sr1 );
      win_prtf( w3, 1,  "\n\t Average Remainder Nonconformance Rate = %6.4lf", rr1 );
      fprintf( outfile, "\n Average Remainder Nonconformance Rate = %6.4lf", rr1 );
      win_prtf( w3, 1,  "\n\t Sample/Remainder Nonconformance Correlation = %6.4lf", srr );
      fprintf( outfile, "\n Sample/Remainder Nonconformance Correlation = %6.4lf", srr );

      win_prtf( w3, 1, "\n\n\t\tPress a Key to Continue..." );
      get1key();
      win_close( w3 );
      win_close( w2 );
      }

void sdump() {

      kb = get1key() >> 8;       /* Wait for user to press any key. */
      
      if( kb == LKEY || kb == F10KEY ) {
            setlasrv();  /* laser vertical */
            devcdump( 3, 3, 80, 20, 1, 1, 0 );
            /* devcdump( 3 => LaserJet printer,
                         3 => size of graph...half-page, 1-shade, 100 dpi
                        80 => left size margin (graph is 640 of 800),
                        20 => top margin (graph is 480 of 1050),
                         1 => FormFeed YES,
                         1 => Copies,
                         0 => Color ); */
            /*  Dump Graph to HP LaserJet connected to LPT1.  */
            }
      if( kb == GKEY || kb == F09KEY ) {
            setprnth();  /* IBM or Epsom horizontal */
            devcdump( 1, 1, 0, 0, 1, 1, 0 );
            /*  Dump to IBM Graphics DotMatrix Printer on LPT1.  */
            }
      if( kb == EKEY || kb == F08KEY ) {
            setprnth();  /* IBM or Epsom horizontal */
            devcdump( 0, 1, 0, 0, 1, 1, 0 );
            /*  Dump to Epson FX, JX-80, LQ1500 on LPT1.  */
            }

      /* Clear out KeyBoard Buffer After (possible) Screen Dump */
      while( kbhit() != 0 )
              get1key();
      }

void help() {

      w4 = win_open(1,1,21,76,0,2,2,0,2," SamStrat HELP ",0,2,"",0,2);

      win_prtf( w4, 1,   "\n\tWelcome to the SamStrat Simulation..." );

      win_prtf( w4, 1, "\n\n\tThe object of the simulation is to determine which of" );
      win_prtf( w4, 1,   "\n\tthree strategies (NO inspection, 100%% inspection," );
      win_prtf( w4, 1,   "\n\tor SAMPLING inspection) yields minimum average cost" );
      win_prtf( w4, 1,   "\n\tfor a given set of quality scenario parameters." );

      win_prtf( w4, 1, "\n\n\tYou must first specify maximum and minimum values for the" );
      win_prtf( w4, 1,   "\n\tfor fraction nonconforming, P.  When Pmax = Pmin, fraction" );
      win_prtf( w4, 1,   "\n\tnonconforming is then STABLE.  In this situation, Deming has" );
      win_prtf( w4, 1,   "\n\tshown that either NO inspection or 100%% inspection is best." );
      win_prtf( w4, 1,   "\n\tWhen Pmax > Pmin, SamStrat will allow P to vary up and down" );
      win_prtf( w4, 1,   "\n\tfollowing a sinusoidal pattern for consecutive lots." );

      win_prtf( w4, 1, "\n\n\tAmong the other parameter settings you must specify are: the cost," );
      win_prtf( w4, 1,   "\n\tK1, of inspecting a single unit and the cost, K2, of reworking" );
      win_prtf( w4, 1,   "\n\ta nonconforming unit that had already been assembled or shipped." );

      get1key();
      win_close( w4 );
      }

void main() {
      
      extern char wrap_flg; /* declare the text wrapping flag */
      wrap_flg = TRUE;
      if( signal( SIGINT, handler ) == SIG_ERR ) {
              perror( "Couldn't set SIGINT...Abort!\n\n" );
              exit( 1 );
              }

      win_init();
      curtype(1,0,0);
      
      w0 = win_open(0,0,23,78,7,1,1,7,1," SamStrat Simulator ",7,1,"",7,1);
      
      win_prtf( w0, 1, "\n\n\t                 SAMSTRAT.EXE...Version 9304" );
      win_prtf( w0, 1, "\n\n\t      ****  Determine Optimal Sampling Strategies  ****\n");
      win_prtf( w0, 1, "\n\n\t              A Quality Assurance Training Tool:" );
      win_prtf( w0, 1,   "\n\t      Statistics Committee of the QA Section of the PMA" );
      win_prtf( w0, 1, "\n\n\t         Bob Obenchain, CompuServe User [72007,467]\n\n" );
      
      /* set up light source direction */
      curtype(1,0,0);
      set_shadow(1,8,0,0);
      
      w1 = win_open(15,3,3,72,1,7,7,1,7,"",1,7,"",1,7);
      win_prtf( w1, 1, "\n\tPress a key to SET Simulation Scenario Parameters..." );
      get1key();
      win_close( w1 );
      win_cls( w0 );

      Pmin = 0.10;
      Pmax = 0.40;
      cycle = 24;
      K1 = 2.0;
      K2 = 8.0;
      lotsiz = 20;
      samsiz = 5;
      accept = 1;
      replics = 500;
      setparms();

      w1 = win_open(4,22,12,36,1,7,7,1,7,"",1,7,"",1,7);
      while( 1 ) {
      
              while( kbhit() != 0 )
                  get1key();

              win_totop( w1 );
              win_cls( w1 );
              curtype(1,0,0);
              win_prtf( w1, 0, "             Main Menu" );
              win_prtf( w1, 1, "\n\n   H = display HELP screen" );
              win_prtf( w1, 1, "\n\n   D = Define Sampling Scenario" );
              win_prtf( w1, 1, "\n\n   S = Simulate Strategy Costs" );
              win_prtf( w1, 1, "\n\n   X = eXit SamStrat" );

              win_prtf( w1, 1, "\n\n   choice --> " );
              cursrow = w1->cur_row;
              while( 1 ) {
                  if( ( kb = get1key() >> 8 ) == DKEY
                     || kb == HKEY || kb == SKEY || kb == XKEY )
                        break;
                  win_curset( cursrow, 0 );
                  win_prtf( w1, 1, "   Press D H S or X --> " );
                  }
      
              if( kb == DKEY ) {
                      win_prtf( w1, 0, "D" );
                      setparms();
                      }
              else if( kb == HKEY ) {
                      win_prtf( w1, 0, "H" );
                      help();
                      }
              else if( kb == SKEY ) {
                      win_prtf( w1, 0, "S" );
                      simulate();
                      }
              else {
                      win_prtf( w1, 0, "X" );
                      break;
                      }
              }
      
      fcloseall();
      curlocat(24,0);
      printf( "\n" );
      coloreos( 2, 0 );
      printf( "\n\nREMINDER(S) :\n" );
      
      if( outfile != NULL ) {
              printf( "\nSAMSTRAT created an output file named: %s\n", outnam );
              printf( "\n\tUse the DOS invocation... TYPE %s | MORE", outnam );
              printf( "\n\tto review detailed information about this" );
              printf( "\n\trun of the SAMSTRAT simulator.\n\n" );
              }
      
      exit( 0 );
      }
