#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "bounc.inc"

#declare Ball1_Texture = texture {
   color Red
   phong .8  phong_size 60
   ambient 0.15
   diffuse 0.8
}

camera {
	location <.5 1 -22>
	direction <0 0 1.5>
	up <0 1 0>
	right <1.33 0 0>
	look_at <0 4 0>
}

object {
	light_source { <6 15 -4> color White}
}

object {
	light_source { <0 0 -18> color White}
}

object {
	light_source { <-6 15 -4> color White}
}

//  A ramp for the ball to roll down
object {
	box {<-4 -.2 -1> <0 0 1>}
	texture { color green .7 blue .3 ambient .6}
	rotate <0 0 -30>
	translate <-6 7 0>
}

//  Here is the ball
object {
	sphere { <xpos ypos 0> .5}
	texture { Ball1_Texture
		color red .9 green 0 blue .1 ambient .8
	}
}

//  Cylinder to catch the ball
object {
	intersection { Disk_Y
		scale <.8 1 1>
		translate <8 -.4 0>
	}
	texture {Metal color blue .8 green .2 ambient .4}
}


// floor
object {
   plane { <0 1 0> -.5 }
   texture { color red .7 green .7 blue .7}
}

// Back wall
object {
   plane { <0 0 1> 100 }
   texture { color red 0 green 0.1 blue 0.6
		ambient .65 diffuse 0 reflection 0 specular 0}
}

