'
'

' MRESISTOR.BAS  converted from HiSOFT BASIC and GFA BASIC form the
'   ATARI ST series computers.  Written in Microsoft QuickBASIC 4.5
'   using the extensions of Advanced BASIC by Peter Norton computing.
'   must use QB.QLB and QB.LIB for interrupt services
'
'   Code written by G. Rennie , KC8BN, April 1991, February 1992

'***************************************************************************
' QB.BI - Assembly Support Include File
'
'       Copyright <C> 1987 Microsoft Corporation
'
' Purpose:
'      This include file defines the types and gives the DECLARE
'       statements for the assembly language routines ABSOLUTE,
'       INTERRUPT, INTERRUPTX, INT86OLD, and INT86XOLD.
'
'***************************************************************************
'
' Define the type needed for INTERRUPT
'
TYPE RegType
	ax    AS INTEGER
	bx    AS INTEGER
	cx    AS INTEGER
	dx    AS INTEGER
	bp    AS INTEGER
	si    AS INTEGER
	di    AS INTEGER
	flags AS INTEGER
END TYPE
'
' Define the type needed for INTERUPTX
'
TYPE RegTypeX
	ax    AS INTEGER
	bx    AS INTEGER
	cx    AS INTEGER
	dx    AS INTEGER
	bp    AS INTEGER
	si    AS INTEGER
	di    AS INTEGER
	flags AS INTEGER
	ds    AS INTEGER
	es    AS INTEGER
END TYPE
'
'                 DECLARE statements for the 5 routines
'                 -------------------------------------
'
' Generate a software interrupt, loading all but the segment registers
'
DECLARE SUB INTERRUPT (intnum AS INTEGER, inreg AS RegType, outreg AS RegType)
'
' Generate a software interrupt, loading all registers
'
DECLARE SUB INTERRUPTX (intnum AS INTEGER, inreg AS RegTypeX, outreg AS RegTypeX)
'
' Call a routine at an absolute address.
' NOTE: If the routine called takes parameters, then they will have to
'       be added to this declare statement before the parameter given.
'
DECLARE SUB ABSOLUTE (address AS INTEGER)
'
' Generate a software interrupt, loading all but the segment registers
'       (old version)
'
DECLARE SUB INT86OLD (intnum AS INTEGER, inarray() AS INTEGER, outarray() AS INTEGER)
'
' Gemerate a software interrupt, loading all the registers
'       (old version)
'
DECLARE SUB INT86XOLD (intnum AS INTEGER, inarray() AS INTEGER, outarray() AS INTEGER)

DIM SHARED HiPos1(2), HiPos2(2, 12), MaxSize(2), MaxItems(2), item$(2, 15), valid(2, 15), toggle(2, 15)
DIM reg AS RegType

DECLARE FUNCTION MouseInitialize% ()
DECLARE FUNCTION MenuInitialize% (MenuNames() AS STRING, MenuChoices() AS STRING, BarAttrib%, MenuAttrbs() AS INTEGER)
DECLARE SUB MouseShowCursor ()
DECLARE SUB MenuShow ()
DECLARE SUB MouseHideCursor ()
DECLARE SUB MouseInformation (Right%, Left%, Row%, Col%)
DECLARE SUB MouseMoveCursor (Row%, Col%)
DECLARE SUB MouseTimesPressed (Button%, NumberTimes%, Row%, Col%)
DECLARE SUB MouseTimesReleased (Button%, NumberTimes%, Row%, Col%)
DECLARE SUB MouseHorizontalRange (Right%, Left%)
DECLARE SUB MouseVerticleRange (top%, bottom%)
DECLARE SUB TurnOffMenu (MNumber%)
DECLARE SUB TurnOnMenu (MNumber%)
DECLARE FUNCTION MenuGetEvent$ (MenuNo%, ChoiceNo%, Button%, ScRow%, ScCol%)
DECLARE FUNCTION MenuCheckEvent$ (MenuNo%, ChoiceNo%, Button%, ScRow%, ScCol%)
DECLARE FUNCTION MenuInitialize% (MenuNames() AS STRING, MenuChoices() AS STRING, BarAttrib%, MenuAttrbs() AS INTEGER)
DECLARE SUB MenuShow ()
DECLARE SUB MenuHide ()
DECLARE FUNCTION MenuReadChoice$ (MenuNo%, ChoiceNo%)
DECLARE SUB MenuMarkChoice (MenuNumber%, ChoiceNumber%)
DECLARE SUB MenuUnMarkChoice (MenuNumber%, ChoiceNumber%)
DECLARE SUB BandInfo ()
DECLARE SUB TopMenuBar ()
DECLARE SUB OhmsIn ()
DECLARE SUB DrawResistor ()
DECLARE SUB PlaceText ()
DECLARE SUB DrawRMenu ()
DECLARE SUB BandHandler ()
DECLARE SUB ColorBands ()
DECLARE SUB BandOne ()
DECLARE SUB BandTwo ()
DECLARE SUB BandThree ()
DECLARE SUB TolBand ()
DECLARE SUB ChangeValues ()
DECLARE SUB QuitBox ()
DECLARE SUB DispValues ()
DECLARE SUB InfoBox ()
DECLARE SUB AboutBox ()
DECLARE SUB PowerBox ()
DECLARE SUB MainDisplay ()
DECLARE SUB CheckVid ()

CONST MaxMenus = 2
DIM Rows(1 TO MaxMenus) AS INTEGER
DIM Cols(1 TO MaxMenus) AS INTEGER
DIM TopRow(1 TO MaxMenus) AS INTEGER
DIM TopCol(1 TO MaxMenus) AS INTEGER
DIM BotRow(1 TO MaxMenus) AS INTEGER
DIM BotCol(1 TO MaxMenus) AS INTEGER
DIM Attribute(1 TO MaxMenus) AS INTEGER
DIM text(1 TO MaxMenus, 25) AS STRING
DIM OldText(1 TO MaxMenus, 25) AS STRING
DIM OldAttrb(1 TO MaxMenus, 25) AS STRING
COMMON SHARED /MenuA/ Rows() AS INTEGER, Cols() AS INTEGER, TopRow() AS INTEGER, TopCol() AS INTEGER, BotRow() AS INTEGER, BotCol() AS INTEGER
COMMON SHARED /MenuB/ Attribute() AS INTEGER, text() AS STRING, OldText() AS STRING, OldAttrb() AS STRING
COMMON SHARED /MenuC/ Bar$, BarAttrib, MenusOnFlag%, NumMenus%, OldBar$, OldBarAttrb$

'----------------------------------------

DIM MenuNames(1 TO 2) AS STRING
DIM MenuChoices(1 TO 2, 1 TO 4) AS STRING
DIM MenuAttrbs(1 TO 3) AS INTEGER

DEFINT A-Z

DIM SHARED band1$(11, 3, 2)
DIM SHARED band2$(11, 3, 2)
DIM SHARED band3$(11, 3, 2)
DIM SHARED band4$(5, 3, 2)

COMMON SHARED QuitKey$
COMMON SHARED ohm$, tempohm$, aresistance$, r1$, r2$, tohm$, DisplayOhm$
COMMON SHARED m%, ml%, x1%, x2%, x3%, bnd1, bnd2, bnd3, temp, Right%, Left%
COMMON SHARED index1%, index2%, index3%, index4%, p1%, p2%, p3%, p4%, p5%
COMMON SHARED col4%, col3%, col2%, col1%, r1%, r2%, r3%, ar%, Row%, Col%
COMMON SHARED totalohms!, ohms!, ar!, NoVga%

MenuNames(1) = "Desk"
MenuChoices(1, 1) = "About"
MenuNames(2) = "Options"
MenuChoices(2, 1) = "Info"
MenuChoices(2, 2) = "Power Rating"
MenuChoices(2, 3) = "Quit"

Check% = MouseInitialize%
IF Check% = 0 THEN
  CLS
  PRINT " Mouse driver must be installed, sorry..."
  END
END IF
CALL CheckVid
IF NoVga% = 1 THEN
  CLS
  PRINT " Must have VGA graphics hardware for Mr. Resistor, sorry ..."
  END
END IF

SCREEN 12
PALETTE 0, (65536 * 0 + 256 * 0 + 0)         'black
PALETTE 1, (65536 * 63 + 256 * 63 + 63)      'white
PALETTE 2, (65536 * 0 + 256 * 0 + 63)        'red
PALETTE 4, (65536 * 63 + 256 * 0 + 0)        'blue
PALETTE 3, (65536 * 0 + 256 * 63 + 0)        'green
PALETTE 5, (65536 * 3 + 256 * 22 + 37)       'brown
PALETTE 6, (65536 * 12 + 256 * 30 + 63)      'orange
PALETTE 7, (65536 * 0 + 256 * 63 + 63)       'yellow
PALETTE 8, (65536 * 24 + 256 * 23 + 20)      'dark grey
PALETTE 9, (65536 * 36 + 256 * 37 + 34)      'silver -ish
PALETTE 10, (65536 * 0 + 256 * 43 + 63)      'gold
PALETTE 11, (65536 * 18 + 256 * 57 + 40)     'light green
PALETTE 12, (65536 * 7 + 256 * 22 + 2)       'dark olive
PALETTE 13, (65536 * 61 + 256 * 51 + 23)     'light blue
PALETTE 14, (65536 * 5 + 256 * 30 + 47)      'light tan
PALETTE 15, (65536 * 57 + 256 * 11 + 62)     'violet

ohm$ = "290"
tohm$ = " 290"
blank$ = "      "

index1% = 2
index2% = 9
index3% = 1

FOR i = 1 TO 2
  MenuAttrbs(i) = &H61
NEXT i
BarAttrbs% = &H24

Check% = MenuInitialize%(MenuNames(), MenuChoices(), BarAttrb%, MenuAttrbs())



CLS
CALL MainDisplay
PRINT Olbaresistance$

DO
 
  CALL BandHandler
  Check$ = MenuCheckEvent$(MenuNo%, ChoiceNo%, Button%, Row%, Col%)
	'  check$ = MenuGetEvent$(MenuNo%, ChoiceNo%, Button%, Row%, Col%)
  CALL BandHandler
	LOCATE 3, 1
	' PRINT "Row% = "; Row%; "  "; "Col% = "; Col%
	 'LOOP UNTIL check$ = "menuchoice"
   IF Check$ = "menuchoice" THEN
     IF MenuChoices(MenuNo%, ChoiceNo%) = "Info" THEN
	CALL InfoBox
     END IF
     IF MenuChoices(MenuNo%, ChoiceNo%) = "Quit" THEN
	CALL QuitBox
     END IF
     IF MenuChoices(MenuNo%, ChoiceNo%) = "About" THEN
	CALL AboutBox
     END IF
     IF MenuChoices(MenuNo%, ChoiceNo%) = "Power Rating" THEN
	CALL PowerBox
     END IF
    


     'LOCATE 5, 5
     'PRINT "                                        ";
     'LOCATE 5, 5
     'PRINT " That selection was ", MenuChoices(MenuNo%, ChoiceNo%)
   END IF
LOOP
'------------------------------------------------------

DEFSNG A-Z
SUB AboutBox
  
  CALL MouseHideCursor
  COLOR 4
  LINE (177, 2)-(444, 2)
  LINE (177, 75)-(444, 75)
  LINE (177, 2)-(177, 75)
  LINE (444, 2)-(444, 75)
  PAINT (200, 50), 9, 4
  COLOR 1
  LOCATE 2, 24
  PRINT "MR. RESISTOR  by G.Rennie  KC8BN";
  LOCATE 3, 35
  PRINT CHR$(201); CHR$(205); CHR$(205); CHR$(205); CHR$(205); CHR$(205); CHR$(205); CHR$(187);
  LOCATE 4, 35
  PRINT CHR$(186); "GO ohm"; CHR$(186)
  COLOR 7
  LOCATE 4, 36
  PRINT "GO ohm";
  COLOR 1
  LOCATE 5, 35
  PRINT CHR$(200); CHR$(205); CHR$(205); CHR$(205); CHR$(205); CHR$(205); CHR$(205); CHR$(188);
  COLOR 4
  LINE (177, 75)-(444, 75)
  CALL MouseShowCursor
    DO
       CALL MouseInformation(Right%, Left%, Row%, Col%)
       IF Left% <> 0 OR Right% <> 0 OR INKEY$ <> "" THEN
	 COLOR 0
	 CALL MouseHideCursor
	 FOR l = 1 TO 5
	    LOCATE l, 22
	    PRINT "                                     ";
	 NEXT l
	 EXIT DO
       END IF
    LOOP

CALL MouseShowCursor

END SUB

SUB BandHandler
 
  CALL MouseInformation(Right%, Left%, Row%, Col%)
 
  IF Right% = 1 OR Left% = 1 THEN
    IF Col% >= 26 AND Col% <= 30 AND Row% >= 10 AND Row% <= 14 THEN
       CALL BandOne
    END IF
    IF Col% >= 10 AND Col% <= 27 AND Row% >= 25 AND Row% <= 28 THEN
       CALL BandOne
    END IF
    IF Col% >= 33 AND Col% <= 37 AND Row% >= 10 AND Row% <= 14 THEN
       CALL BandTwo
    END IF
    IF Col% >= 30 AND Col% <= 47 AND Row% >= 25 AND Row% <= 28 THEN
       CALL BandTwo
    END IF
    IF Col% >= 42 AND Col% <= 45 AND Row% >= 10 AND Row% <= 14 THEN
       CALL BandThree
    END IF
    IF Col% >= 50 AND Col% <= 65 AND Row% >= 25 AND Row% <= 28 THEN
       CALL BandThree
    END IF
    IF Col% >= 56 AND Col% <= 60 AND Row% >= 10 AND Row% <= 14 THEN
       CALL TolBand
    END IF
    IF Col% >= 67 AND Col% <= 79 AND Row% >= 25 AND Row% <= 28 THEN
       CALL TolBand
    END IF

  END IF

END SUB

SUB BandInfo
 
  '----- band 1 ---------------
  band1$(0, 0, 0) = "0"           ' actual numeric value
  band1$(0, 1, 0) = "BLACK"       ' display color name
  band1$(0, 1, 1) = "0"           ' color number index
  band1$(1, 0, 0) = "1"
  band1$(1, 1, 0) = "BROWN"
  band1$(1, 1, 1) = "5"
  band1$(2, 0, 0) = "2"
  band1$(2, 1, 0) = " RED"
  band1$(2, 1, 1) = "2"
  band1$(3, 0, 0) = "3"
  band1$(3, 1, 0) = "ORANGE"
  band1$(3, 1, 1) = "6"
  band1$(4, 0, 0) = "4"
  band1$(4, 1, 0) = "YELLOW"
  band1$(4, 1, 1) = "7"
  band1$(5, 0, 0) = "5"
  band1$(5, 1, 0) = "GREEN"
  band1$(5, 1, 1) = "3"
  band1$(6, 0, 0) = "6"
  band1$(6, 1, 0) = " BLUE"
  band1$(6, 1, 1) = "4"
  band1$(7, 0, 0) = "7"
  band1$(7, 1, 0) = "VIOLET"
  band1$(7, 1, 1) = "15"
  band1$(8, 0, 0) = "8"
  band1$(8, 1, 0) = " GREY"
  band1$(8, 1, 1) = "8"
  band1$(9, 0, 0) = "9"
  band1$(9, 1, 0) = "WHITE"
  band1$(9, 1, 1) = "1"
  '----- band 2 ---------------
  band2$(0, 0, 0) = "0"           ' actual numeric value
  band2$(0, 1, 0) = "BLACK"       ' display color name
  band2$(0, 1, 1) = "0"           ' palette index
  band2$(1, 0, 0) = "1"
  band2$(1, 1, 0) = "BROWN"
  band2$(1, 1, 1) = "5"
  band2$(2, 0, 0) = "2"
  band2$(2, 1, 0) = " RED"
  band2$(2, 1, 1) = "2"
  band2$(3, 0, 0) = "3"
  band2$(3, 1, 0) = "ORANGE"
  band2$(3, 1, 1) = "6"
  band2$(4, 0, 0) = "4"
  band2$(4, 1, 0) = "YELLOW"
  band2$(4, 1, 1) = "7"
  band2$(5, 0, 0) = "5"
  band2$(5, 1, 0) = "GREEN"
  band2$(5, 1, 1) = "3"
  band2$(6, 0, 0) = "6"
  band2$(6, 1, 0) = "BLUE"
  band2$(6, 1, 1) = "4"
  band2$(7, 0, 0) = "7"
  band2$(7, 1, 0) = "VIOLET"
  band2$(7, 1, 1) = "15"
  band2$(8, 0, 0) = "8"
  band2$(8, 1, 0) = " GREY"
  band2$(8, 1, 1) = "8"
  band2$(9, 0, 0) = "9"
  band2$(9, 1, 0) = "WHITE"
  band2$(9, 1, 1) = "1"
  '----- band 3 --------------- multpliers
  band3$(0, 0, 0) = "   .0   "
  band3$(0, 1, 0) = " BLACK "
  band3$(0, 1, 1) = "0"
  band3$(1, 0, 0) = "   0   "
  band3$(1, 1, 0) = " BROWN "
  band3$(1, 1, 1) = "5"
  band3$(2, 0, 0) = "  00   "
  band3$(2, 1, 0) = "  RED  "
  band3$(2, 1, 1) = "2"
  band3$(3, 0, 0) = "  000  "
  band3$(3, 1, 0) = " ORANGE "
  band3$(3, 1, 1) = "6"
  band3$(4, 0, 0) = " 0000   "
  band3$(4, 1, 0) = " YELLOW "
  band3$(4, 1, 1) = "7"
  band3$(5, 0, 0) = " 00000  "
  band3$(5, 1, 0) = " GREEN  "
  band3$(5, 1, 1) = "3"
  band3$(6, 0, 0) = "000000  "
  band3$(6, 1, 0) = "  BLUE  "
  band3$(6, 1, 1) = "4"
  band3$(7, 0, 0) = "  x.01  "
  band3$(7, 1, 0) = " SILVER "
  band3$(7, 1, 1) = "9"
  band3$(8, 0, 0) = "  x.1   "
  band3$(8, 1, 0) = "  GOLD  "
  band3$(8, 1, 1) = "10"
'----- band 4 --------------- tolerance
  band4$(0, 0, 0) = "+/- 20%"
  band4$(0, 1, 0) = " NONE  "
  band4$(0, 1, 1) = "0"
  band4$(1, 0, 0) = "+/- 10%"
  band4$(1, 1, 0) = "SILVER "
  band4$(1, 1, 1) = "9"
  band4$(2, 0, 0) = "+/- 5% "
  band4$(2, 1, 0) = " GOLD  "
  band4$(2, 1, 1) = "10"
  band4$(3, 0, 0) = "+/- 2% "
  band4$(3, 1, 0) = " RED   "
  band4$(3, 1, 1) = "2"

END SUB

SUB BandOne


  IF Right% <> 0 OR Left% <> 0 THEN
    CALL MouseHideCursor
    IF Left% = 1 THEN
      index1% = index1% + 1
      IF index1% > 9 THEN
	index1% = 0
      END IF
    END IF
    IF Right% = 1 THEN
      IF index1% = 0 THEN
	index1% = 9
      ELSE
	 index1% = index1% - 1
      END IF
    END IF
    CALL ColorBands
    CALL ChangeValues
    
    CALL DispValues
    CALL MouseShowCursor
  END IF


END SUB

SUB BandThree

  IF Left% <> 0 OR Right% <> 0 THEN
   CALL MouseHideCursor
    IF Left% = 1 THEN
      index3% = index3% + 1
      IF index3% > 8 THEN
	index3% = 0
      END IF
    END IF
    IF Right% = 1 THEN
      IF index3% = 0 THEN
	index3% = 8
      ELSE
	index3% = index3% - 1
      END IF
    END IF
    CALL ColorBands
    CALL ChangeValues
    CALL DispValues
    CALL MouseShowCursor
  END IF


END SUB

SUB BandTwo


  IF Left% <> 0 OR Right% <> 0 THEN
   CALL MouseHideCursor
   IF Left% = 1 THEN
      index2% = index2% + 1
      IF index2% > 9 THEN
	index2% = 0
      END IF
    END IF
    IF Right% = 1 THEN
      IF index2% = 0 THEN
	index2% = 9
      ELSE
	index2% = index2% - 1
      END IF
    END IF
    CALL ColorBands
    CALL ChangeValues
    CALL DispValues
    CALL MouseShowCursor
  END IF

END SUB

SUB ChangeValues

 r1% = VAL(band1$(index1%, 0, 0))
 r2% = VAL(band2$(index2%, 0, 0))
 r1$ = STR$(r1%)
 r2$ = STR$(r2%)
 aresistance$ = r1$ + r2$
 ar! = VAL(aresistance$)
 IF band3$(index3%, 0, 0) = "  x.1   " THEN
   totalohms! = ar! * .1
 END IF
 IF band3$(index3%, 0, 0) = "  x.01  " THEN
   totalohms! = ar! * .01
 END IF
 IF band3$(index3%, 0, 0) = "   .0   " THEN
   totalohms! = ar!
 END IF
 IF band3$(index3%, 0, 0) = "   0   " THEN
   totalohms! = ar! * 10
 END IF
 IF band3$(index3%, 0, 0) = "  00   " THEN
   totalohms! = ar! * 100
 END IF
 IF band3$(index3%, 0, 0) = "  000  " THEN
   totalohms! = ar! * 1000
 END IF
 IF band3$(index3%, 0, 0) = " 0000   " THEN
   totalohms! = ar! * 10000
 END IF
 IF band3$(index3%, 0, 0) = " 00000  " THEN
   totalohms! = ar! * 100000
 END IF
 IF band3$(index3%, 0, 0) = "000000  " THEN
   totalohms! = ar! * 1000000
 END IF
 tohm$ = STR$(totalohms!)

END SUB

SUB CheckVid

  DIM InRegs AS RegType, OutRegs AS RegType
  InRegs.ax = &H1A00
  CALL INTERRUPT(&H10, InRegs, OutRegs)
 
  IF (OutRegs.ax AND 255) <> &H1A THEN
    NoVga% = 1
    EXIT SUB
  END IF
 
  IF (OutRegs.ax AND 255) = &H1A THEN
     SELECT CASE OutRegs.bx
       CASE 7, 8
	 NoVga% = 0
       CASE ELSE
	 NoVga% = 1
       END SELECT
  END IF



END SUB

SUB ColorBands
  
   col1% = VAL(band1$(index1%, 1, 1))
   col2% = VAL(band2$(index2%, 1, 1))
   col3% = VAL(band3$(index3%, 1, 1))
   col4% = VAL(band4$(index4%, 1, 1))

'------- band 1 fill -----------------
   PAINT (235, 206), col1%, 12
'------- band 2 fill -----------------
   PAINT (295, 206), col2%, 12
'------- band 3 fill -----------------
   PAINT (355, 206), col3%, 12
'------- band 4 fill -----------------
   PAINT (475, 206), col4%, 12


END SUB

SUB DispValues
 
  DisplayOhm$ = tohm$
  COLOR 15
  LOCATE 21, 27
  PRINT USING " ###,###,###,###.##"; VAL(DisplayOhm$)
  LOCATE 21, 47
  PRINT CHR$(234)
  LOCATE 26, 19
  COLOR 1
  PRINT band1$(index1%, 0, 0)
  COLOR 6
  LOCATE 28, 17
  PRINT band1$(index1%, 1, 0); "  ";
 
  LOCATE 26, 39
  COLOR 1
  PRINT band2$(index2%, 0, 0)
  COLOR 6
  LOCATE 28, 37
  PRINT band2$(index2%, 1, 0); "   ";

  LOCATE 26, 54
  COLOR 1
  PRINT band3$(index3%, 0, 0)
  COLOR 6
  LOCATE 28, 54
  PRINT band3$(index3%, 1, 0); "   ";


  LOCATE 26, 70
  COLOR 1
  PRINT band4$(index4%, 0, 0)
  COLOR 6
  LOCATE 28, 70
  PRINT band4$(index4%, 1, 0); "   ";

END SUB

SUB DrawResistor
 
  COLOR 12
  CIRCLE (160, 205), 80, , , , 4
  CIRCLE (430, 205), 80, , 4.7, 1.5, 4
  CIRCLE (470, 205), 80, , 4.7, 1.5, 4
  CIRCLE (500, 205), 80, , 4.7, 1.5, 4
  CIRCLE (190, 205), 80, , 4.7, 1.5, 4
  CIRCLE (230, 205), 80, , 4.7, 1.5, 4
  CIRCLE (250, 205), 80, , 4.7, 1.5, 4
  CIRCLE (290, 205), 80, , 4.7, 1.5, 4
  CIRCLE (310, 205), 80, , 4.7, 1.5, 4
  CIRCLE (350, 205), 80, , 4.7, 1.5, 4
  LINE (159, 125)-(500, 125)
  LINE (159, 285)-(500, 285)
  LINE (100, 205)-(160, 205)
  LINE (520, 205)-(550, 205)
 
  CALL ColorBands
 
  COLOR 13
  LOCATE 7, 26
  PRINT " 1"
  LOCATE 7, 34
  PRINT "2"
  LOCATE 7, 42
  PRINT "M"
  LOCATE 7, 56
  PRINT "T"

END SUB

DEFINT A-Z
'
SUB DrawRMenu
 
  COLOR 4
  LINE (2, 360)-(638, 360)
  LINE (2, 390)-(638, 390)
  LINE (2, 425)-(638, 425)
  LINE (2, 455)-(638, 455)
  LINE (2, 360)-(2, 455)
  LINE (638, 360)-(638, 455)
  LINE (70, 360)-(70, 455)
  LINE (225, 360)-(225, 455)
  LINE (385, 360)-(385, 455)
  LINE (520, 360)-(520, 455)

END SUB

DEFSNG A-Z
SUB InfoBox
   
    CLS
    CALL MouseHideCursor
    COLOR 7
    PRINT "MR. RESISTOR";
    COLOR 6
    LOCATE 1, 14
    PRINT "Is an easy to use point-and-click resistor color wheel guide."
    LOCATE 2, 14
    PRINT "Click the mouse buttons on the color band or in the text color box."
    LOCATE 3, 1
    PRINT "The left button cycles in ascending and the right button in decending values."
    LOCATE 4, 1
    PRINT "The value of the first significant figure of ohms resistance of band one with"
    LOCATE 5, 1
    PRINT "the second significant figure of band two times the multiplier band gives the"
    LOCATE 6, 1
    PRINT "represented value in ohms.  The fourth band is the tolerance which is what +/-"
    LOCATE 7, 1
    PRINT "percentage of that value the actual ohms resistance may be.  A 100 ohm resistor"
    LOCATE 8, 1
    PRINT "with +/- 10% could actually be 90 to 110 ohms.";
    LOCATE 10, 9
    PRINT "Some resistors have a fourth band (not displayed) which is the relative";
    LOCATE 11, 1
    PRINT "percent of change over 1000 hours of usage.  Brown would be 1%,  Red is .1%"
    LOCATE 12, 1
    PRINT "Orange is .01% and Yellow is .001%  Color bands are read left to right with the"
    LOCATE 13, 1
    PRINT "largest non-banded space on the right.  Power rating of composition resistors is"
    LOCATE 14, 1
    PRINT "is coded by size as shown where the actual dimensions are smaller than the"
    LOCATE 15, 1
    PRINT "relative displayed resistors."
    LOCATE 22, 33
    COLOR 9
    PRINT "press ANY KEY"
    dum$ = INPUT$(1)
    CALL MainDisplay

END SUB

SUB MainDisplay

    CLS
    COLOR 0
    CALL MenuShow
    CALL BandInfo
    CALL DrawResistor
    CALL DrawRMenu
    CALL PlaceText
    CALL DispValues
    CALL MouseShowCursor
    CALL TopMenuBar




END SUB

FUNCTION MenuCheckEvent$ (MenuNo%, ChoiceNo%, Button%, ScRow%, ScCol%) STATIC


  DIM InRegs AS RegType, OutRegs AS RegType
 
  MenuCheckEvent$ = ""
 
  InChar$ = INKEY$

  IF InChar$ <> "" THEN
    MenuCheckEvent$ = InChar$
    IF MenusOnFlag% = 0 THEN EXIT FUNCTION
    IF ASC(InChar$) = 27 THEN
      IF MenuNowOpen% = 0 THEN
	EXIT FUNCTION
      ELSE
	CALL TurnOffMenu(MenuNowOpen%)
	MenuNo% = MenuNowOpen%
	MenuNowOpen% = 0
	MenuCheckEvent$ = "menuclose"
	EXIT FUNCTION
      END IF
   END IF
  
   IF LEN(InChar$) = 1 THEN
     EXIT FUNCTION
   ELSE
     sc = ASC(RIGHT$(InChar$, 1))
     AltKey$ = ""
     IF sc >= 16 AND sc <= 25 THEN AltKey$ = MID$("QWERTYUIOP", sc - 15, 1)
     IF sc > 25 AND sc <= 38 THEN AltKey$ = MID$("ASDFGHJKL", sc - 29, 1)
     IF sc > 38 AND sc <= 50 THEN AltKey$ = MID$("ZXCVBNM", sc - 43, 1)
     IF AltKey$ = "" THEN EXIT FUNCTION
     IF MenuNowOpen% <> 0 THEN
       FOR i% = 1 TO Rows(MenuNowOpen%)
	 IF AltKey$ = UCASE$(MID$(text(MenuNowOpen%, i%), 2, 1)) THEN
	   MenuNo% = MenuNowOpen%
	   ChoiceNo% = i%
	   CALL TurnOffMenu(MenuNowOpen%)
	   MenuNowOpen% = 0
	   MenuCheckEvent$ = "menuchoice"
	   EXIT FUNCTION
	 END IF
       NEXT i%
     END IF

     FOR i% = 1 TO NumMenus%
	IF AltKey$ = UCASE$(MID$(Bar$, 10 * (i% - 1) + 2, 1)) THEN
	  IF MenuNowOpen% = i% THEN
	    MenuNo% = i%
	    CALL TurnOffMenu(i%)
	    MenuNowOpen% = 0
	    MenuCheckEvent$ = "menuclose"
	    EXIT FUNCTION
	  END IF
	  IF MenuNowOpen% <> 0 THEN CALL TurnOffMenu(MenuNowOpen%)
	  MenuNo% = i%
	  ChoiceNo% = 0
	  MenuNowOpen% = i%
	  CALL TurnOnMenu(i%)
	  MenuCheckEvent$ = "menuopen"
	END IF
      NEXT i%
    END IF
    EXIT FUNCTION
  END IF

     Button% = 0                         'check left mouse button
     InRegs.bx = 0
     InRegs.ax = 5
     CALL INTERRUPT(&H33, InRegs, OutRegs)
     NumberTimes% = OutRegs.bx
     ScRow% = OutRegs.dx \ 16 + 1
     ScCol% = OutRegs.cx \ 8 + 1

     IF NumberTimes% <> 0 THEN
       IF MenusOnFlag% AND (ScRow% = 1) THEN
	 MenubarCandidate% = ScCol% \ 10 + 1
	 IF MenubarCandidate% <= NumMenus% THEN
	   MenuNo% = MenubarCandidate%
	   ChoiceNo% = 0
	   MenuNowOpen% = MenubarCandidate%
	   CALL TurnOnMenu(MenubarCandidate%)
	   MenuCheckEvent$ = "menuopen"
	   EXIT FUNCTION
	 END IF
       ELSE
	 MenuCheckEvent$ = "mousedown"
	 EXIT FUNCTION
       END IF
     END IF


     InRegs.bx = 0                       'check left button released
     InRegs.ax = 6
     CALL INTERRUPT(&H33, InRegs, OutRegs)
     NumberTimes% = OutRegs.bx
     ScRow% = OutRegs.dx \ 16 + 1
     ScCol% = OutRegs.cx \ 8 + 1
     IF NumberTimes% <> 0 THEN
       IF MenusOnFlag% AND (MenuNowOpen% <> 0) THEN
	 IF ScRow% >= 2 AND ScRow% <= 2 + Rows(MenuNowOpen%) THEN
	   IF ScCol% >= 1 + 10 * (MenuNowOpen% - 1) AND ScCol% <= 10 * (MenuNowOpen%) THEN
	     ChoiceNo% = ScRow% - 1
	     CALL TurnOffMenu(MenuNowOpen%)
	     MenuNo% = MenuNowOpen%
	     MenuNowOpen% = 0
	     MenuCheckEvent$ = "menuchoice"
	     EXIT FUNCTION
	   ELSE
	     MenuNo% = MenuNowOpen%
	     CALL TurnOffMenu(MenuNowOpen%)
	     MenuNowOpen% = 0
	     MenuCheckEvent$ = "menuclose"
	     EXIT FUNCTION
	   END IF
	 ELSE
	   MenuNo% = MenuNowOpen%
	   CALL TurnOffMenu(MenuNowOpen%)
	   MenuNowOpen% = 0
	   MenuCheckEvent$ = "menuclose"
	   EXIT FUNCTION
	 END IF
       ELSE
	 MenuCheckEvent$ = "mouseup"
	 EXIT FUNCTION
       END IF
    END IF

    Button% = 1
    InRegs.bx = 1
    InRegs.ax = 5
    CALL INTERRUPT(&H33, InRegs, OutRegs)
    NumberTimes% = OutRegs.bx
    ScRow% = OutRegs.dx \ 16 + 1
    ScCol% = OutRegs.cx \ 8 + 1
    IF NumberTimes% <> 0 THEN
      MenuCheckEvent$ = "mousedown"
      EXIT FUNCTION
    END IF
END FUNCTION

FUNCTION MenuGetEvent$ (MenuNo%, ChoiceNo%, Button%, ScRow%, ScCol%) STATIC
  DIM InRegs AS RegType, OutRegs AS RegType
  MenuGetEvent$ = ""
 
  DO
    InChar$ = INKEY$
   
    IF InChar$ <> "" THEN
      MenuGetEvent$ = InChar$
      IF MenusOnFlag% = 0 THEN EXIT FUNCTION
      IF ASC(InChar$) = 27 THEN
	IF MenuOpen% = 0 THEN
	  EXIT FUNCTION
	ELSE
       '   CALL TurnOffMenu(MenuNowOpen%)
	  MenuNo% = MenuNowOpen%
  '        MenuNowOpen% = 0
  '        MenuGetEvent$ = "menuclose"
	  EXIT FUNCTION
	END IF
      END IF
      IF LEN(InChar$) = 1 THEN
	 EXIT FUNCTION
      ELSE
	 sc = ASC(RIGHT$(InChar$, 1))
	 AltKey$ = ""
	 IF sc >= 16 AND sc <= 25 THEN AltKey$ = MID$("QWERTYUIOP", sc - 15, 1)
	 IF sc >= 30 AND sc <= 38 THEN AltKey$ = MID$("ASDFGHJKL", sc - 29, 1)
	 IF sc >= 44 AND sc <= 50 THEN AltKey$ = MID$("ZXCVBNM", sc - 43, 1)
	 IF AltKey$ = "" THEN EXIT FUNCTION
	 IF MenuNowOpen% <> 0 THEN
	   FOR i% = 1 TO Rows(MenuNowOpen%)
	     IF AltKey$ = UCASE$(MID$(text(MenuNowOpen%, i%), 2, 1)) THEN
	       MenuNo% = MenuNowOpen%
	       ChoiceNo% = i%
	       CALL TurnOffMenu(MenuNowOpen%)
	       MenuNowOpen% = 0
	       MenuGetEvent$ = "menuchoice"
	       EXIT FUNCTION
	     END IF
	   NEXT i%
	 END IF

	 FOR i% = 1 TO NumMenus%
	   IF AltKey$ = UCASE$(MID$(Bar$, 10 * (i% - 1) + 2, 1)) THEN
	     IF MenuNowOpen% = i% THEN
	       MenuNo% = i%
	       CALL TurnOffMenu(i%)
	       MenuNowOpen% = 0
	       MenuGetEvent$ = "menuclose"
	       EXIT FUNCTION
	     END IF
	     IF MenuNowOpen% <> 0 THEN CALL TurnOffMenu(MenuNowOpen%)
	     MenuNo% = 0
	     ChoiceNo% = 0
	     MenuNowOpen% = i%
	     CALL TurnOnMenu(i%)
	     MenuGetEvent$ = "menuopen"
	   END IF
	 NEXT i%
       END IF
       EXIT FUNCTION
     END IF

     Button% = 0
     InRegs.bx = 0
     InRegs.ax = 5
     CALL INTERRUPT(&H33, InRegs, OutRegs)
     NumberTimes% = OutRegs.bx
     ScRow% = OutRegs.dx \ 16 + 1
     ScCol% = OutRegs.cx \ 8 + 1
    
     IF NumberTimes% <> 0 THEN
       IF MenusOnFlag% AND (ScRow% = 1) THEN
	 MenubarCandidate% = ScCol% \ 10 + 1
	 IF MenubarCandidate% <= NumMenus% THEN
	   MenuNo% = MenubarCandidate%
	   ChoiceNo% = 0
	   MenuNowOpen% = MenubarCandidate%
	   CALL TurnOnMenu(MenubarCandidate%)
	   MenuGetEvent$ = "menuopen"
	   EXIT FUNCTION
	 END IF
       ELSE
	 MenuGetEvent$ = "mousedown"
	 EXIT FUNCTION
       END IF
     END IF
     
     InRegs.bx = 0
     InRegs.ax = 6
     CALL INTERRUPT(&H33, InRegs, OutRegs)
     NumberTimes% = OutRegs.bx
     ScRow% = OutRegs.dx \ 16 + 1
     ScCol% = OutRegs.cx \ 8 + 1

     IF NumberTimes% <> 0 THEN
       IF MenusOnFlag% AND (MenuNowOpen% <> 0) THEN
	 IF ScRow% >= 2 AND ScRow% <= 2 + Rows(MenuNowOpen%) THEN
	   IF ScCol% >= 1 + 10 * (MenuNowOpen% - 1) AND ScCol% <= 10 * (MenuNowOpen%) THEN
	     ChoiceNo% = ScRow% - 1
	     CALL TurnOffMenu(MenuNowOpen%)
	     MenuNo% = MenuNowOpen%
	     MenuNowOpen% = 0
	     MenuGetEvent$ = "menuchoice"
	     EXIT FUNCTION
	   ELSE
	     MenuNo% = MenuNowOpen%
	     CALL TurnOffMenu(MenuNowOpen%)
	     MenuNowOpen% = 0
	     MenuGetEvent$ = "menuclose"
	     EXIT FUNCTION
	   END IF
	 ELSE
	   MenuNo% = MenuNowOpen%
	   CALL TurnOffMenu(MenuNowOpen%)
	   MenuNowOpen% = 0
	   MenuGetEvent$ = "menuclose"
	   EXIT FUNCTION
	 END IF
       ELSE
	 MenuGetEvent$ = "mouseup"
	 EXIT FUNCTION
       END IF
     END IF

     Button% = 1
     InRegs.bx = 1
     InRegs.ax = 5
     CALL INTERRUPT(&H33, InRegs, OutRegs)
    
     NumberTimes% = OutRegs.bx
     ScRow% = OutRegs.dx \ 16 + 1
     ScCol% = OutRegs.cx \ 8 + 1
    
     IF NumberTimes% = 0 THEN
       MenuGetEvent$ = "mousedown"
       EXIT FUNCTION
     END IF

     InRegs.bx = 1
     InRegs.ax = 6
     CALL INTERRUPT(&H33, InRegs, OutRegs)
     NumberTimes% = OutRegs.bx
     ScRow% = OutRegs.dx \ 16 + 1
     ScCol% = OutRegs.cx \ 8 + 1
    
     IF NumberTimes% <> 0 THEN
       MenuGetEvent$ = "mousedown"
       'IF NOT MenuGetEvent$ THEN
	  CALL TurnOffMenu(MenuNowOpen%)
      ' END IF
       EXIT FUNCTION
     END IF

     LOOP WHILE 1

END FUNCTION

SUB MenuHide

  DIM InRegs AS RegType, OutRegs AS RegType
  CurRow% = 16 * (CSRLIN - 1)
  CurCol% = 8 * (POS(0) - 1)
  InRegs.ax = 2
  CALL INTERRUPT(&H33, InRegs, OutRegs)
  InRegs.cx = 1
  FOR j = 1 TO 80
    LOCATE 1, j
    InRegs.ax = &H900 + ASC(MID$(OldBar$, j, 1))
    InRegs.bx = ASC(MID$(OldBarAttrb$, j, 1))
    CALL INTERRUPT(&H10, InRegs, OutRegs)
  NEXT j
  InRegs.ax = 1
  CALL INTERRUPT(&H33, InRegs, OutRegs)
  MenusOnFlag% = 0
  LOCATE CurRow%, CurCol%
END SUB

FUNCTION MenuInitialize% (MenuNames() AS STRING, MenuChoices() AS STRING, BarAttrib%, MenuAttrbs() AS INTEGER)

  MenuInitialize% = 0
  NumMenus% = UBOUND(MenuNames, 1)
  IF NumMenus% > 7 THEN EXIT FUNCTION
  IF UBOUND(MenuChoices, 2) > 24 THEN EXIT FUNCTION

  ERASE Rows
  ERASE Cols
  ERASE TopRow
  ERASE TopCol
  ERASE BotRow
  ERASE BotCol
  ERASE Attribute
 ' ERASE OnFlag
  ERASE text
  ERASE OldText
  ERASE OldAttrb
  Bar$ = ""
  MenusOnFlag% = 0
  BarAttrb = BarAttrb%
 
  FOR i = 1 TO NumMenus%
    Bar$ = Bar$ + " " + MenuNames(i) + SPACE$(8 - LEN(MenuNames(i))) + CHR$(179)
    FOR j = 1 TO UBOUND(MenuChoices, 2)
      temp$ = MenuChoices(i, j)
      IF temp$ <> "" THEN
	IF LEN(temp$) > 15 THEN EXIT FUNCTION
	  Rows(i) = Rows(i) + 1
	  text(i, j) = " " + temp$ + SPACE$(15 - LEN(temp$))
	END IF
    NEXT j
    Cols(i) = 16
    TopRow(i) = 2
    TopCol(i) = 1 + 10 * (i - 1)
    BotRow(i) = 1 + Rows(i)
    BotCol(i) = TopCol(i) + 16
    Attribute(i) = MenuAttrbs(i)
 NEXT i

 Bar$ = Bar$ + SPACE$(80 - LEN(Bar$))
 MenuInitialize% = 1
END FUNCTION

SUB MenuMarkChoice (MenuNumber%, ChoiceNumber%)
  
  MID$(text(MenuNumber%, ChoiceNumber%), 1, 1) = CHR$(251)


END SUB

FUNCTION MenuReadChoice$ (MenuNo%, ChoiceNo%)

  IF MenuNo% = 0 THEN
    MenuReadChoice$ = RTRIM$(MID$(Bar$, (ChoiceNo% - 1) * 10 + 2, 8))
  ELSE
    MenuReadChoice$ = RTRIM$(LTRIM$(text(MenuNo%, ChoiceNo%)))
  END IF

END FUNCTION

SUB MenuShow
  
  DIM InRegs AS RegType, OutRegs AS RegType
  CurRow% = 16 * (CSRLIN - 1)
  CurCol% = 8 * (POS(0) - 1)
  InRegs.ax = 2
  CALL INTERRUPT(&H33, InRegs, OutRegs)     'turn off mouse cursor
  temp1$ = ""
  temp2$ = ""
  FOR j = 1 TO 80                            'save old top bar
    temp1$ = temp1$ + CHR$(SCREEN(1, j))
    temp2$ = temp2$ + CHR$(SCREEN(1, j, 1))
  NEXT j
  OldBar$ = temp1$
  OldBarAttrb$ = temp2$
  InRegs.cx = 1                              'print menu bar
  FOR j = 1 TO 80
    LOCATE 1, j
    InRegs.ax = &H900 + ASC(MID$(Bar$, j, 1))
    InRegs.bx = BarAttrb
    CALL INTERRUPT(&H10, InRegs, OutRegs)
  NEXT j
  InRegs.ax = 1                             'mouse cursor back on
  CALL INTERRUPT(&H33, InRegs, OutRegs)
  MenusOnFlag% = 1                          'show menu bar is on
  CurRow% = CurRow% \ 16 + 1
  CurCol% = CurCol% \ 8 + 1
  LOCATE CurRow%, CurCol%
  InRegs.bx = 0
  InRegs.ax = 5
  CALL INTERRUPT(&H33, InRegs, OutRegs)
  InRegs.bx = 1
  InRegs.ax = 5
  CALL INTERRUPT(&H33, InRegs, OutRegs)
  InRegs.bx = 0
  InRegs.ax = 6
  CALL INTERRUPT(&H33, InRegs, OutRegs)
  InRegs.bx = 1
  InRegs.ax = 6
  CALL INTERRUPT(&H33, InRegs, OutRegs)
END SUB

SUB MenuUnMarkChoice (MenuNumber%, ChoiceNumber%)

  MID$(text(MenuNumber%, ChoiceNumber%), 1, 1) = " "

END SUB

SUB MouseHideCursor
 
  DIM InRegs AS RegType, OutRegs AS RegType
  InRegs.ax = 2
  CALL INTERRUPT(&H33, InRegs, OutRegs)

END SUB

SUB MouseHorizontalRange (Right%, Left%)

  DIM InRegs AS RegType, OutRegs AS RegType
  InRegs.cx = 8 * (Right% - 1)
  InRegs.dx = 8 * (Left% - 1)
  InRegs.ax = 7
  CALL INTERRUPT(&H33, InRegs, OutRegs)

END SUB

SUB MouseInformation (Right%, Left%, Row%, Col%)

  DIM InRegs AS RegType, OutRegs AS RegType
  InRegs.ax = 3
  CALL INTERRUPT(&H33, InRegs, OutRegs)
  Right% = 0
  Left% = 0
  SELECT CASE OutRegs.bx
     CASE 1
	Left% = 1
     CASE 2
	Right% = 1
     CASE 3
	Left% = 1
	Right% = 1
  END SELECT
  Row% = OutRegs.dx \ 16 + 1
  Col% = OutRegs.cx \ 8 + 1


END SUB

FUNCTION MouseInitialize%
 DIM InRegs AS RegType, OutRegs AS RegType
 InRegs.ax = 0
 CALL INTERRUPT(&H33, InRegs, OutRegs)           'ah = 0 to init. mouse
 MouseInitialize% = OutRegs.ax
END FUNCTION

SUB MouseMoveCursor (Row%, Col%)

  DIM InRegs AS RegType, OutRegs AS RegType
  InRegs.dx = 16 * (Row% - 1)
  InRegs.cx = 8 * (Col% - 1)
  InRegs.ax = 4
  CALL INTERRUPT(&H33, InRegs, OutRegs)
END SUB

SUB MouseShowCursor
  DIM InRegs AS RegType, OutRegs AS RegType
  InRegs.ax = 1
  CALL INTERRUPT(&H33, InRegs, OutRegs)         'service 1 shows mouse
END SUB

SUB MouseTimesPressed (Button%, NumberTimes%, Row%, Col%)

  DIM InRegs AS RegType, OutRegs AS RegType
  InRegs.bx = Button%
  InRegs.ax = 5
  CALL INTERRUPT(&H33, InRegs, OutRegs)
  NumberTimes% = OutRegs.bx
  Row% = OutRegs.dx / 16 + 1
  Col% = OutRegs.cx / 8 + 1
END SUB

SUB MouseTimesReleased (Button%, NumberTimes%, Row%, Col%)

  DIM InRegs AS RegType, OutRegs AS RegType
  InRegs.bx = Button%
  InRegs.ax = 6
  CALL INTERRUPT(&H33, InRegs, OutRegs)
  Row% = OutRegs.dx / 16 + 1
  Col% = OutRegs.cx / 8 + 1
END SUB

SUB MouseVerticleRange (top%, bottom%)

  DIM InRegs AS RegType, OutRegs AS RegType
  InRegs.cx = 16 * (top% - 1)
  InRegs.dx = 16 * (bottom% - 1)
  InRegs.ax = 16
  CALL INTERRUPT(&H33, InRegs, OutRegs)
END SUB

SUB OhmsIn

  m% = 0
  ml% = 0
  ohms = VAL(ohm$)
  m% = INSTR(ohm$, "K")
  ml% = INSTR(ohm$, "k")
  IF m% <> 0 OR ml% <> 0 THEN
    ohms! = ohms! * 1000
  END IF
  x1% = 0
  x2% = 0
  x3% = 0
  bnd1 = VAL(LEFT$(ohm$, 1))
  bnd2 = VAL(MID$(ohm$, 2, 1))
  DO
    temp = VAL(band1$(x1%, 0, 0))
    x1% = x1% + 1
  LOOP UNTIL temp = bnd1
  index1% = x1% - 1
  DO
    temp = VAL(band2$(x2%, 0, 0))
    x2% = x2% + 1
  LOOP UNTIL temp = bnd2
  index2% = x2% - 1
  tempohm$ = STR$(ohms)
  IF LEN(tempohm$) >= 3 THEN
    p6% = INSTR(tempohm$, "000000")
    IF p6% <> 0 AND LEN(tempohm$) >= 7 THEN
      index3% = 6
    END IF
    p5% = INSTR(tempohm$, "00000")
    IF p5% <> 0 AND LEN(tempohm$) >= 6 THEN
      index3% = 5
    END IF
    p4% = INSTR(tempohm$, "0000")
    IF p4% <> 0 AND LEN(tempohm$) >= 5 THEN
      index3% = 4
    END IF
    p3% = INSTR(tempohm$, "000")
    IF p3% <> 0 AND LEN(tempohm$) >= 4 THEN
      index3% = 3
    END IF
    p2% = INSTR(tempohm$, "00")
    IF p2% <> 0 AND LEN(tempohm$) >= 3 THEN
      index3% = 4
    END IF
    IF RIGHT$(tempohm$, 1) = "0" AND LEN(tempohm$) >= 2 THEN
      index3% = 1
    END IF
  END IF
  IF LEN(tempohm$) = 2 THEN
    index3% = 0
  END IF


END SUB

SUB PlaceText
  LOCATE 24, 3
  COLOR 13
  PRINT "Band"
  LOCATE 26, 3
  PRINT "Value"
  LOCATE 28, 3
  PRINT "Color";
  LOCATE 24, 18
  COLOR 7
  PRINT "1st"
  LOCATE 24, 38
  PRINT "2nd"
  LOCATE 24, 52
  PRINT "Multiplier"
  LOCATE 24, 69
  PRINT "Tolerance"
END SUB

SUB PowerBox
  
   CALL MouseHideCursor
   CLS
   PALETTE 0, (65536 * 53 + 256 * 38 + 46)      'white
   LOCATE 2, 45
   COLOR 1
   PRINT "Length"
   LOCATE 2, 65
   PRINT "Diameter"
  
   COLOR 12
   '------ 1/4 watt ------
   LINE (85, 60)-(125, 60)
   LINE (85, 60)-(85, 80)
   LINE (125, 60)-(125, 80)
   LINE (85, 80)-(125, 80)
   LINE (65, 70)-(85, 70)
   LINE (125, 70)-(145, 70)
   '------ 1/2 watt ------
   LINE (85, 120)-(142, 120)
   LINE (85, 120)-(85, 150)
   LINE (85, 150)-(142, 150)
   LINE (142, 120)-(142, 150)
   LINE (142, 135)-(162, 135)
   LINE (65, 135)-(85, 135)
   '------- 1 watt --------
   LINE (85, 200)-(155, 200)
   LINE (85, 200)-(85, 236)
   LINE (85, 236)-(155, 236)
   LINE (155, 236)-(155, 200)
   LINE (65, 218)-(85, 218)
   LINE (155, 218)-(172, 218)
   '------- 2 watt ---------
   LINE (85, 290)-(185, 290)
   LINE (85, 290)-(85, 326)
   LINE (85, 326)-(185, 326)
   LINE (185, 326)-(185, 290)
   LINE (65, 308)-(85, 308)
   LINE (185, 308)-(205, 308)
   COLOR 9
   PAINT (90, 65), 9, 12
   PAINT (90, 125), 9, 12
   PAINT (90, 225), 9, 12
   PAINT (90, 300), 9, 12
   COLOR 8
   LOCATE 5, 30
   PRINT "1/4 WATT"
   LOCATE 5, 44
   PRINT ".250 inch"
   LOCATE 5, 64
   PRINT ".100 inch"
   LOCATE 9, 30
   PRINT "1/2 WATT"
   LOCATE 9, 44
   PRINT ".390 inch"
   LOCATE 9, 64
   PRINT ".125 inch"
   LOCATE 14, 30
   PRINT " 1  WATT"
   LOCATE 14, 44
   PRINT ".575 inch"
   LOCATE 14, 64
   PRINT ".250 inch"
   LOCATE 20, 30
   PRINT " 2  WATT"
   LOCATE 20, 44
   PRINT ".708 inch"
   LOCATE 20, 64
   PRINT ".310 inch"
  
   COLOR 1

   LOCATE 27, 35
   PRINT "Press ANY KEY";
   dum$ = INPUT$(1)
   CLS
   PALETTE 0, (65536 * 0 + 256 * 0 + 0)       'black
   COLOR 0
   CALL MainDisplay

END SUB

SUB QuitBox
 
  CALL MouseHideCursor
  COLOR 4
  LINE (177, 2)-(444, 2)
  LINE (177, 75)-(444, 75)
  LINE (177, 2)-(177, 75)
  LINE (444, 2)-(444, 75)
  LINE (177, 75)-(444, 75)
  PAINT (200, 50), 9, 4
 
  COLOR 1
  LOCATE 2, 24
  PRINT " Are you sure you want to Quit ?";
 
  LOCATE 3, 28
  PRINT CHR$(201); CHR$(205); CHR$(205); CHR$(205); CHR$(205); CHR$(205); CHR$(187);
  LOCATE 4, 28
  PRINT CHR$(186); "[Y]es"; CHR$(186)
  LOCATE 4, 30
  COLOR 7
  PRINT "Y";
  COLOR 1
  LOCATE 5, 28
  PRINT CHR$(200); CHR$(205); CHR$(205); CHR$(205); CHR$(205); CHR$(205); CHR$(188);
 
  LOCATE 3, 44
  PRINT CHR$(201); CHR$(205); CHR$(205); CHR$(205); CHR$(205); CHR$(187);
  LOCATE 4, 44
  PRINT CHR$(186); "[N]o"; CHR$(186)
  LOCATE 4, 46
  COLOR 7
  PRINT "N";
  COLOR 1
  LOCATE 5, 44
  PRINT CHR$(200); CHR$(205); CHR$(205); CHR$(205); CHR$(205); CHR$(188);
  COLOR 4
  LINE (177, 75)-(444, 75)
  CALL MouseShowCursor

    DO
       CALL MouseInformation(Right%, Left%, Row%, Col%)
       QuitKey$ = UCASE$(INKEY$)

       IF Left% <> 0 OR Right% <> 0 OR QuitKey$ <> "" THEN
	   COLOR 0
	   CALL MouseHideCursor
	   'QuitKey$ = UCASE$(INKEY$)
	   FOR l = 1 TO 5
	      LOCATE l, 22
	      PRINT "                                     ";
	   NEXT l
	 EXIT DO
       END IF
    LOOP

CALL MouseShowCursor

IF QuitKey$ = "Y" THEN
   SCREEN 0
   CLS
   END
END IF

IF Col% >= 27 AND Col% <= 32 AND Row% >= 3 AND Row% <= 5 AND Left% = 1 THEN
   SCREEN 0
   CLS
   END
END IF

END SUB

SUB TolBand
 
  IF Left% <> 0 OR Right% <> 0 THEN
    CALL MouseHideCursor
    IF Left% = 1 THEN
      index4% = index4% + 1
      IF index4% > 3 THEN
	index4% = 0
      END IF
    END IF
    IF Right% = 1 THEN
      IF index4% = 0 THEN
	index4% = 3
      ELSE
	index4% = index4% - 1
      END IF
    END IF
    IF band4$(index4%, 1, 0) = " NONE " THEN
      COLOR 0
      CIRCLE (430, 205), 80, , 4.7, 1.5, 4
      CIRCLE (470, 205), 80, , 4.7, 1.5, 4
      COLOR 12
      LINE (159, 125)-(500, 125)
      LINE (159, 285)-(500, 285)
      PAINT (475, 206), 0, 12
    ELSE
      COLOR 12
      CIRCLE (430, 205), 80, , 4.7, 1.5, 4
      CIRCLE (470, 205), 80, , 4.7, 1.5, 4
    END IF
   
    CALL ColorBands
    CALL DispValues
    CALL MouseShowCursor
  END IF

END SUB

SUB TopMenuBar
 
  CALL MouseHideCursor
  LOCATE 1, 1
  COLOR 1
  PRINT SPACE$(80);
  LOCATE 1, 1
  COLOR 13
  PRINT "Desk";
  LOCATE 1, 11
  PRINT "Options"
  CALL MouseShowCursor



END SUB

SUB TurnOffMenu (MNumber%)
 
  DIM InRegs AS RegType, OutRegs AS RegType
  CurRow% = 16 * (CSRLIN - 1)
  CurCol% = 8 * (POS(0) - 1)
  InRegs.ax = 2
  CALL INTERRUPT(&H33, InRegs, OutRegs)
  tr = TopRow(MNumber%)
  tc = TopCol(MNumber%)
  LOCATE tr, tc
  InRegs.cx = 1
  FOR i = 1 TO Rows(MNumber%)
    or$ = OldText(MNumber%, i)
    oc$ = OldAttrb(MNumber%, i)
    FOR j = 1 TO Cols(MNumber%)
      InRegs.ax = &H900 + ASC(MID$(or$, j, 1))
      InRegs.bx = ASC(MID$(oc$, j, 1))
      CALL INTERRUPT(&H10, InRegs, OutRegs)
      LOCATE tr + i - 1, tc + j
    NEXT j
    LOCATE tr + i, tc
  NEXT i
  InRegs.ax = 1
  CALL INTERRUPT(&H33, InRegs, OutRegs)
'  LOCATE CurRow%, CurCol%
END SUB

SUB TurnOnMenu (MNumber%)
 

  DIM InRegs AS RegType, OutRegs AS RegType
  CurRow% = 16 * (CSRLIN - 1)
  CurCol% = 8 * (POS(0) - 1)
  InRegs.ax = 2
  CALL INTERRUPT(&H33, InRegs, OutRegs)
  rr = TopRow(MNumber%)
  cc = TopCol(MNumber%)
  rt = Rows(MNumber%)
  ct = Cols(MNumber%)
  FOR i = 1 TO rt
    temp1$ = ""
    temp2$ = ""
    FOR j = 1 TO ct
      temp1$ = temp1$ + CHR$(SCREEN(rr + i - 1, cc + j - 1))
      temp2$ = temp2$ + CHR$(SCREEN(rr + i - 1, cc + j - 1, 1))
    NEXT j
    OldText(MNumber%, i) = temp1$
    OldAttrb(MNumber%, i) = temp2$
  NEXT i
  tr = TopRow(MNumber%)
  tc = TopCol(MNumber%)
  LOCATE tr, tc
  InRegs.cx = 1
  FOR i = 1 TO Rows(MNumber%)
    or$ = text(MNumber%, i)
    FOR j = 1 TO Cols(MNumber%)
      InRegs.ax = &H900 + ASC(MID$(or$, j, 1))
      InRegs.bx = Attribute(MNumber%)
      CALL INTERRUPT(&H10, InRegs, OutRegs)
      LOCATE tr + i - 1, tc + j
    NEXT j
    LOCATE tr + i, tc
  NEXT i
  InRegs.ax = 1
  CALL INTERRUPT(&H33, InRegs, OutRegs)
  CurRow% = CurRow% \ 16 + 1
  CurCol% = CurCol% \ 8 + 1
  LOCATE CurRow%, CurCol%
END SUB

