Program MathPad;

{$N+,E+,Q+,S+,R+,I-,O-,F+,P+,T-,X-,V-,B+,A-,G-,D-,L-,Y-}

(* compiled in Borland Turbo Pascal 7.0 for DOS *)

uses crt,drivers,math1,mp3_doc;

label tryagain, next, oops, dec, done;

Type
RealArray = Array[1..15] of extended;

Var
M,X,Difference,Sum,Entry,Average,SumEntries,a,b,c,Quotient,Exponent,
Result,Coefficient,Product,Radicand,Base,Root,Celsius,Fahrenheit,Kelvin,
x1,y1,x2,y2,distance,Volume,Diameter,Radius,Area,Circum,VolSphr,SurfSphr,
Height,VolCyl,VolCone,surfcyl,surfcon,MyPi: extended;

NumEntries,count,I,countcyl,countcon,Exp_Int,Index,
Count_Check_Quad,Count_Quad_Not_Zero,Count_Slope_Intercept: Integer;

decimal:shortint;

dummy,reply : char;

answer, bool : boolean;

filename : string;

logfile : text;

Mult,Add : RealArray;


procedure ComputeCylinder;

begin
VolCyl := MyPi * Sqr(Radius) * Height;
surfcyl:=(2*mypi*sqr(radius))+(2*mypi*radius*height);
end;

procedure ComputeCone;

begin
VolCone := 1 / 3 * MyPi * Sqr(Radius) * Height;
surfcon:=(mypi*sqr(radius))+(mypi*radius*sqrt((radius*radius)+(height*height)));
end;

Procedure radius_;

Label Start, Oops_1, Oops_2;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: RADIUS  (you enter a radius of a circle,');
writeln(logfile, '                  and its other measurements are found).');
writeln(logfile);
end;
Count := 0;
countcyl := 0;
countcon := 0;
WriteLn;
writeln ('  To exit, just press Enter.');
writeln ('  This short routine does a few calculations based on your number entry.');
Start:
Reset (Input);
WriteLn;
write ('  Enter radius of a circle > ');
While Not EOLN(Input) do
Begin
Read (radius);
if ioresult = 106 then
begin
typo;
goto start;
end
else
If radius < 0 then
Begin
negative_radius;
Goto Start;
End;
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Enter radius of a circle > ',radius :1:decimal);
end;
Diameter := Radius * 2;
Circum := MyPi * Diameter;
Area := MyPi * Sqr(Radius);
VolSphr := (4 / 3) * MyPi * Radius * Radius * Radius;
SurfSphr := 4 * MyPi * Sqr(Radius);
WriteLn;
writeln ('  The diameter of this circle is');
writeln ('  ',Diameter :1:decimal, ' linear units.');
writeln ('  The circumference of this circle is');
writeln ('  ',Circum :1:decimal, ' "linear" units.');
writeln ('  The area of this circle is');
writeln ('  ',Area :1:decimal, ' square units.');
writeln ('  The volume of a sphere with this radius is');
writeln ('  ',VolSphr :1:decimal, ' cubic units.');
writeln ('  The surface area of a sphere with this radius is');
writeln ('  ',SurfSphr :1:decimal, ' "square" units.');
if answer = true then
begin
WriteLn(logfile);
writeln (logfile, 'The diameter of this circle is');
writeln (logfile,Diameter :1:decimal, ' linear units.');
writeln (logfile,'The circumference of this circle is');
writeln (logfile,Circum :1:decimal, ' "linear" units.');
writeln (logfile,'The area of this circle is');
writeln (logfile,Area :1:decimal, ' square units.');
writeln (logfile,'The volume of a sphere with this radius is');
writeln (logfile,VolSphr :1:decimal, ' cubic units.');
writeln (logfile,'The surface area of a sphere with this radius is');
writeln (logfile,SurfSphr :1:decimal, ' "square" units.');
end;
Count := Count + 1;
WriteLn;
writeln ('  To skip, just press Enter.');
writeln('  We can now compute the volume and surface area of a right circular cylinder.');
Oops_1:
reset (input);
WriteLn;
write ('  Height > ');
If Not EOLN(Input) then
Begin
Read (Height);
if ioresult = 106 then
begin
typo;
goto oops_1;
end
else
If Height < 0 then
Begin
negative_height;
Goto Oops_1;
End;
ComputeCylinder;
if answer = true then
begin
writeln(logfile, 'Height, right circular cylinder: ',Height :1:decimal);
writeln(logfile, 'Volume: ',volcyl :1:decimal);
writeln(logfile, 'Surface area: ',surfcyl:1:decimal);
end;
WriteLn;
writeln ('  The volume is ', VolCyl :1:decimal, ' cubic units.');
writeln('  The surface area is ',surfcyl:1:decimal,' "square" units.');
countcyl := countcyl + 1;
End;
WriteLn;
writeln ('  To go to the top, just press Enter.');
writeln ('  We can now compute the volume of a right circular cone.');
oops_2:
reset (input);
Writeln;
write ('  Height > ');
If Not EOLN(Input) then
Begin
Read (Height);
if ioresult = 106 then
begin
typo;
goto oops_2;
end
else
If Height < 0 then
Begin
negative_height;
Goto Oops_2;
End;
ComputeCone;
if answer = true then
begin
writeln(logfile, 'Height, right circular cone: ',Height :1:decimal);
writeln(logfile, 'Volume: ',volcone :1:decimal);
writeln(logfile, 'Surface area: ',surfcon:1:decimal);
end;
WriteLn;
writeln ('  The volume is ', VolCone :1:decimal, ' cubic units.');
writeln('  The surface area is ',surfcon:1:decimal,' "square" units.');
countcon := countcon + 1;
Goto Start;
End
Else
Goto Start;
End;
if answer = true then
begin
writeln(logfile);
if count = 1 then
begin
writeln (logfile,'You made ', count, ' radius entry.')
end
else
writeln (logfile,'You made ', Count, ' radius entries.');
if CountCyl = 1 then
writeln (logfile,'You made ', CountCyl, ' cylinder entry.')
else
writeln (logfile,'You made ', CountCyl, ' cylinder entries.');
if countcon = 1 then
writeln (logfile,'You made ', countcon, ' cone entry.')
else
writeln (logfile,'You made ', countcon, ' cone entries.');
WriteLn(logfile,'___________________________________________________________________________');
end;
End;

Procedure Diameter_;

Const
MyPi = 3.1415926535;

Label Start, Oops_1, Oops_2;

begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: DIAMETER  (you enter a diameter of a circle,');
writeln(logfile, '                    and its other measurements are found).');
writeln(logfile);
end;
Count := 0;
countcyl := 0;
countcon := 0;
WriteLn;
writeln ('  To exit, just press Enter.');
writeln ('  This short routine does a few calculations based on your number entry.');
Start:
Reset (Input);
WriteLn;
write ('  Enter diameter of a circle > ');
While Not EOLN(Input) do
Begin
Read (Diameter);
If IOResult = 106 then
begin
typo;
goto start;
end
else
If Diameter < 0 then
Begin
negative_diameter;
Goto Start;
End;
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Enter diameter of a circle > ',diameter :1:decimal);
end;
Radius := Diameter / 2;
Circum := MyPi * Diameter;
Area := MyPi * Sqr(Radius);
VolSphr := 4 / 3 * MyPi * Radius * Radius * Radius;
SurfSphr := 4 * MyPi * Sqr(Radius);
WriteLn;
writeln ('  The radius of this circle is');
writeln ('  ',Radius :1:decimal, ' linear units.');
writeln ('  The circumference of this circle is');
writeln ('  ',Circum :1:decimal, ' "linear" units.');
writeln ('  The area of this circle is');
writeln ('  ',Area :1:decimal, ' square units.');
writeln ('  The volume of a sphere with this radius is');
writeln ('  ',VolSphr :1:decimal, ' cubic units.');
writeln ('  The surface area of a sphere with this radius is');
writeln ('  ',SurfSphr :1:decimal, ' "square" units.');
if answer = true then
begin
WriteLn(logfile);
writeln (logfile, 'The radius of this circle is');
writeln (logfile,radius :1:decimal, ' linear units.');
writeln (logfile,'The circumference of this circle is');
writeln (logfile,Circum :1:decimal, ' "linear" units.');
writeln (logfile,'The area of this circle is');
writeln (logfile,Area :1:decimal, ' square units.');
writeln (logfile,'The volume of a sphere with this radius is');
writeln (logfile,VolSphr :1:decimal, ' cubic units.');
writeln (logfile,'The surface area of a sphere with this radius is');
writeln (logfile,SurfSphr :1:decimal, ' "square" units.');
end;
Count := Count + 1;
WriteLn;
writeln ('  To skip, just press Enter.');
writeln ('  We can now compute the volume of a right circular cylinder.');
Oops_1:
reset (input);
WriteLn;
write ('  Height > ');
If Not EOLN(Input) then
Begin
Read (Height);
if ioresult = 106 then
begin
typo;
goto oops_1;
end
else
If Height < 0 then
Begin
negative_height;
Goto Oops_1;
End;
ComputeCylinder;
if answer = true then
begin
writeln(logfile, 'Height, right circular cylinder: ',Height :1:decimal);
writeln(logfile, 'Volume: ',volcyl :1:decimal);
writeln(logfile, 'Surface area: ',surfcyl:1:decimal);
end;
WriteLn;
writeln ('  The volume is ', VolCyl :1:decimal, ' cubic units.');
writeln('  The surface area is ',surfcyl:1:decimal,' "square" units.');
countcyl := countcyl + 1;
End;
WriteLn;
writeln ('  To go to the top, just press Enter.');
writeln ('  We can now compute the volume of a right circular cone.');
oops_2:
reset (input);
WriteLn;
write ('  Height > ');
If Not EOLN(Input) then
Begin
Read (Height);
if ioresult = 106 then
begin
typo;
goto oops_2;
end
else
If Height < 0 then
begin
negative_height;
Goto Oops_2;
End;
ComputeCone;
if answer = true then
begin
writeln(logfile, 'Height, right circular cone: ',Height :1:decimal);
writeln(logfile, 'Volume: ',volcone :1:decimal);
writeln(logfile, 'Surface area: ',surfcon:1:decimal);
end;
WriteLn;
writeln ('  The volume is ', VolCone :1:decimal, ' cubic units.');
writeln('  The surface area is ',surfcon:1:decimal,' "square" units.');
countcon := countcon + 1;
Goto Start;
End
Else
Goto Start;
End;
if answer = true then
begin
writeln(logfile);
if count = 1 then
begin
writeln (logfile,'You made ', count, ' diameter entry.')
end
else
writeln (logfile,'You made ', Count, ' diameter entries.');
if CountCyl = 1 then
writeln (logfile,'You made ', CountCyl, ' cylinder entry.')
else
writeln (logfile,'You made ', CountCyl, ' cylinder entries.');
if countcon = 1 then
writeln (logfile,'You made ', countcon, ' cone entry.')
else
writeln (logfile,'You made ', countcon, ' cone entries.');
WriteLn(logfile,'___________________________________________________________________________');
end;
End;

Procedure Circum_;

Label Start, Oops_1, Oops_2;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: CIRCUM  (you enter a circumference of a circle,');
writeln(logfile, '                  and its other measurements are found).');
writeln(logfile);
end;
Count := 0;
countcyl := 0;
countcon := 0;
WriteLn;
writeln ('  To exit, just press Enter.');
writeln ('  This short routine does a few calculations based on your number entry.');
Start:
Reset (Input);
WriteLn;
write ('  Enter circumference of a circle > ');
While Not EOLN(Input) do
Begin
Read (Circum);
If IOResult = 106 then
begin
typo;
goto start;
end
else
If Circum < 0 then
Begin
negative_circum;
Goto Start;
End;
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Enter circumference of a circle > ',circum :1:decimal);
end;
Diameter := Circum / MyPi;
Radius := Diameter / 2;
Area := MyPi * Sqr(Radius);
VolSphr := 4 / 3 * MyPi * Radius * Radius * Radius;
SurfSphr := 4 * MyPi * Sqr(Radius);
WriteLn;
writeln ('  The radius of this circle is');
writeln ('  ',Radius :1:decimal, ' linear units.');
writeln ('  The diameter of this circle is');
writeln ('  ',Diameter :1:decimal, ' linear units.');
writeln ('  The area of this circle is');
writeln ('  ',Area :1:decimal, ' square units.');
writeln ('  The volume of a sphere with this radius is');
writeln ('  ',VolSphr :1:decimal, ' cubic units.');
writeln ('  The surface area of a sphere with this radius is');
writeln ('  ',SurfSphr :1:decimal, ' "square" units.');
if answer = true then
begin
WriteLn(logfile);
writeln (logfile, 'The radius of this circle is');
writeln (logfile,radius :1:decimal, ' linear units.');
writeln (logfile,'The diameter of this circle is');
writeln (logfile,diameter :1:decimal, ' "linear" units.');
writeln (logfile,'The area of this circle is');
writeln (logfile,Area :1:decimal, ' square units.');
writeln (logfile,'The volume of a sphere with this radius is');
writeln (logfile,VolSphr :1:decimal, ' cubic units.');
writeln (logfile,'The surface area of a sphere with this radius is');
writeln (logfile,SurfSphr :1:decimal, ' "square" units.');
end;
Count := Count + 1;
WriteLn;
writeln ('  To skip, just press Enter.');
writeln ('  We can now compute the volume of a right circular cylinder.');
Oops_1:
reset (input);
WriteLn;
write ('  Height > ');
If Not EOLN(Input) then
Begin
Read (Height);
If IOResult = 106 then
begin
typo;
goto oops_1;
end
else
If Height < 0 then
Begin
negative_height;
Goto Oops_1;
End;
ComputeCylinder;
if answer = true then
begin
writeln(logfile, 'Height, right circular cylinder: ',Height :1:decimal);
writeln(logfile, 'Volume: ',volcyl :1:decimal);
writeln(logfile, 'Surface area: ',surfcyl:1:decimal);
end;
WriteLn;
writeln ('  The volume is ', VolCyl :1:decimal, ' cubic units.');
writeln('  The surface area is ',surfcyl:1:decimal,' "square" units.');
countcyl := countcyl + 1;
End;
WriteLn;
writeln ('  To go to the top, just press Enter.');
writeln ('  We can now compute the volume of a right circular cone.');
oops_2:
reset (input);
WriteLn;
write ('  Height > ');
If Not EOLN(Input) then
Begin
Read (Height);
If IOResult = 106 then
begin
typo;
goto oops_2;
end
else
If Height < 0 then
Begin
negative_height;
Goto Oops_2;
End;
ComputeCone;
if answer = true then
begin
writeln(logfile, 'Height, right circular cone: ',Height :1:decimal);
writeln(logfile, 'Volume: ',volcone :1:decimal);
writeln(logfile, 'Surface area: ',surfcon:1:decimal);
end;
WriteLn;
writeln ('  The volume is ', VolCone :1:decimal, ' cubic units.');
writeln('  The surface area is ',surfcon:1:decimal,' "square" units.');
countcon := countcon + 1;
Goto Start;
End
Else
Goto Start;
End;
if answer = true then
begin
writeln(logfile);
if count = 1 then
begin
writeln (logfile,'You made ', count, ' circumference entry.')
end
else
writeln (logfile,'You made ', Count, ' circumference entries.');
if CountCyl = 1 then
writeln (logfile,'You made ', CountCyl, ' cylinder entry.')
else
writeln (logfile,'You made ', CountCyl, ' cylinder entries.');
if countcon = 1 then
writeln (logfile,'You made ', countcon, ' cone entry.')
else
writeln (logfile,'You made ', countcon, ' cone entries.');
WriteLn(logfile,'___________________________________________________________________________');
end;
End;

Procedure Area_;

Label Start, Oops_1, Oops_2;

begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: AREA  (you enter an area of a circle,');
writeln(logfile, '                and its other measurements are found).');
writeln(logfile);
end;
Count := 0;
CountCyl := 0;
CountCon := 0;
WriteLn;
writeln ('  To exit, just press Enter.');
writeln ('  This short routine does a few calculations based on your number entry.');
Start:
Reset (Input);
WriteLn;
write ('  Enter area of a circle > ');
While Not EOLN(Input) do
Begin
Read (Area);
If IOResult = 106 then
begin
typo;
goto start;
end
else
If Area < 0 then
Begin
negative_area;
Goto Start
end;
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Enter area of a circle > ',area :1:decimal);
end;
radius := Area / MyPi;
Radius := Sqrt(radius);
Diameter := Radius * 2;
Circum := 2.0 * MyPi * Radius;
VolSphr := 4 / 3 * MyPi * Radius * Radius * Radius;
SurfSphr := 4 * MyPi * Sqr(Radius);
WriteLn;
writeln ('  The radius of this circle is');
writeln ('  ',Radius :1:decimal, ' linear units.');
writeln ('  The diameter of this circle is');
writeln ('  ',Diameter :1:decimal, ' linear units.');
writeln ('  The circumference of this circle is');
writeln ('  ',Circum :1:decimal, ' "linear" units.');
writeln ('  The volume of a sphere with this radius is');
writeln ('  ',VolSphr :1:decimal, ' cubic units.');
writeln ('  The surface area of a sphere with this radius is');
writeln ('  ',SurfSphr :1:decimal, ' "square" units.');
if answer = true then
begin
WriteLn(logfile);
writeln (logfile, 'The radius of this circle is');
writeln (logfile,radius :1:decimal, ' linear units.');
writeln(logfile, 'The diameter of this circle is');
writeln(logfile, diameter :1:decimal, ' linear units.');
writeln (logfile,'The circumference of this circle is');
writeln (logfile,Circum :1:decimal, ' "linear" units.');
writeln (logfile,'The volume of a sphere with this radius is');
writeln (logfile,VolSphr :1:decimal, ' cubic units.');
writeln (logfile,'The surface area of a sphere with this radius is');
writeln (logfile,SurfSphr :1:decimal, ' "square" units.');
end;
Count := Count + 1;
WriteLn;
writeln ('  To skip, just press Enter.');
writeln ('  We can now compute the volume of a right circular cylinder.');
Oops_1:
reset (input);
WriteLn;
write ('  Height > ');
If Not EOLN(Input) then
Begin
Read (Height);
If IOResult = 106 then
begin
typo;
goto oops_1;
end
else
If Height < 0 then
Begin
negative_height;
Goto Oops_1;
End;
ComputeCylinder;
if answer = true then
begin
writeln(logfile, 'Height, right circular cylinder: ',Height :1:decimal);
writeln(logfile, 'Volume: ',volcyl :1:decimal);
writeln(logfile, 'Surface area: ',surfcyl:1:decimal);
end;
WriteLn;
writeln ('  The volume is ', VolCyl :1:decimal, ' cubic units.');
writeln('  The surface area is ',surfcyl:1:decimal,' "square" units.');
CountCyl := CountCyl + 1;
End;
WriteLn;
writeln ('  To go to the top, just press Enter.');
writeln ('  We can now compute the volume of a right circular cone.');
oops_2:
reset (input);
WriteLn;
write ('  Height > ');
If Not EOLN(Input) then
Begin
Read (Height);
If IOResult = 106 then
begin
typo;
goto oops_2;
end
else
If Height < 0 then
Begin
negative_height;
Goto Oops_2;
End;
ComputeCone;
if answer = true then
begin
writeln(logfile, 'Height, right circular cone: ',Height :1:decimal);
writeln(logfile, 'Volume: ',volcone :1:decimal);
writeln(logfile, 'Surface area: ',surfcon:1:decimal);
end;
WriteLn;
writeln ('  The volume is ', VolCone :1:decimal, ' cubic units.');
writeln('  The surface area is ',surfcon:1:decimal,' "square" units.');
CountCon := CountCon + 1;
Goto Start;
End
Else
Goto Start;
End;
if answer = true then
begin
writeln(logfile);
if count = 1 then
begin
writeln (logfile,'You made ', count, ' area entry.')
end
else
writeln (logfile,'You made ', Count, ' area entries.');
if CountCyl = 1 then
writeln (logfile,'You made ', CountCyl, ' cylinder entry.')
else
writeln (logfile,'You made ', CountCyl, ' cylinder entries.');
if countcon = 1 then
writeln (logfile,'You made ', countcon, ' cone entry.')
else
writeln (logfile,'You made ', countcon, ' cone entries.');
WriteLn(logfile,'___________________________________________________________________________');
end;
End;

Procedure Volume_;

Label Start, Oops_1, Oops_2;

begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: VOLUME    (you enter a volume of a sphere,');
writeln(logfile, '                    and its other measurements are found).');
writeln(logfile);
end;
Count := 0;
countcyl := 0;
countcon := 0;
WriteLn;
writeln ('  To exit, just press Enter.');
writeln ('  This short routine does a few calculations based on your number entry.');
Start:
Reset (Input);
WriteLn;
write ('  Enter volume of a sphere > ');
While Not EOLN(Input) do
Begin
Read (Volume);
if ioresult = 106 then
begin
typo;
goto start;
end
else
if Volume < 0 then
begin
negative_volume;
goto Start;
end;
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Enter volume of a sphere > ',volume :1:decimal);
end;
radius := Volume / (4 / 3 * MyPi);
if volume = 0 then
radius := 0
else
Radius := Exp(1 / 3 * Ln(radius));
Diameter := Radius * 2;
Circum := MyPi * 2 * Radius;
Area := MyPi * Sqr(Radius);
Volume := 4 / 3 * MyPi * Radius * Radius * Radius;
SurfSphr := 4 * MyPi * Sqr(Radius);
WriteLn;
writeln ('  The radius of this sphere is');
writeln ('  ',Radius :1:decimal, ' linear units.');
writeln ('  The diameter of this sphere is');
writeln ('  ',Diameter :1:decimal, ' linear units.');
writeln ('  The circumference of this sphere is');
writeln ('  ',Circum :1:decimal, ' "linear" units.');
writeln ('  The area of a circle with this radius is');
writeln ('  ',Area :1:decimal, ' square units.');
writeln ('  The surface area of a sphere with this radius is');
writeln ('  ',SurfSphr :1:decimal, ' "square" units.');
if answer = true then
begin
WriteLn(logfile);
writeln (logfile,'The radius of this sphere is');
writeln (logfile,radius :1:decimal, ' linear units.');
writeln (logfile, 'The diameter of this circle is');
writeln (logfile,Diameter :1:decimal, ' linear units.');
writeln (logfile,'The circumference of this circle is');
writeln (logfile,Circum :1:decimal, ' "linear" units.');
writeln (logfile,'The area of this circle is');
writeln (logfile,Area :1:decimal, ' square units.');
writeln (logfile,'The surface area of a sphere with this radius is');
writeln (logfile,SurfSphr :1:decimal, ' "square" units.');
end;
Count := Count + 1;
WriteLn;
writeln ('  To skip, just press Enter.');
writeln ('  We can now compute the volume of a right circular cylinder.');
Oops_1:
reset (input);
WriteLn;
write ('  Height > ');
If Not EOLN(Input) then
Begin
Read (Height);
if ioresult = 106 then
begin
typo;
goto oops_1;
end
else
If Height < 0 then
Begin
negative_height;
Goto Oops_1;
End;
ComputeCylinder;
if answer = true then
begin
writeln(logfile, 'Height, right circular cylinder: ',Height :1:decimal);
writeln(logfile, 'Volume: ',volcyl :1:decimal);
writeln(logfile, 'Surface area: ',surfcyl:1:decimal);
end;
WriteLn;
writeln ('  The volume is ', VolCyl :1:decimal, ' cubic units.');
writeln('  The surface area is ',surfcyl:1:decimal,' "square" units.');
countcyl := countcyl + 1;
End;
WriteLn;
writeln ('  To go to the top, just press Enter.');
writeln ('  We can now compute the volume of a right circular cone.');
oops_2:
reset (input);
WriteLn;
write ('  Height > ');
If Not EOLN(Input) then
Begin
Read (Height);
if ioresult = 106 then
begin
typo;
goto oops_2;
end
else
If Height < 0 then
Begin
negative_height;
Goto Oops_2;
End;
ComputeCone;
if answer = true then
begin
writeln(logfile, 'Height, right circular cone: ',Height :1:decimal);
writeln(logfile, 'Volume: ',volcone :1:decimal);
writeln(logfile, 'Surface area: ',surfcon:1:decimal);
end;
WriteLn;
writeln ('  The volume is ', VolCone :1:decimal, ' cubic units.');
writeln('  The surface area is ',surfcon:1:decimal,' "square" units.');
countcon := countcon + 1;
Goto Start;
End
Else
Goto Start;
End;
if answer = true then
begin
writeln(logfile);
if count = 1 then
begin
writeln (logfile,'You made ', count, ' volume entry.')
end
else
writeln (logfile,'You made ', Count, ' volume entries.');
if CountCyl = 1 then
writeln (logfile,'You made ', CountCyl, ' cylinder entry.')
else
writeln (logfile,'You made ', CountCyl, ' cylinder entries.');
if countcon = 1 then
writeln (logfile,'You made ', countcon, ' cone entry.')
else
writeln (logfile,'You made ', countcon, ' cone entries.');
WriteLn(logfile,'___________________________________________________________________________');
end;
End;

Procedure SurfSphr_;

Label Start, Oops_1, Oops_2;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: SURF SPHR (you enter a surface area of a sphere,');
writeln(logfile, '                    and its other measurements are found).');
writeln(logfile);
end;
Count := 0;
countcyl := 0;
countcon := 0;
WriteLn;
writeln ('  To exit, just press Enter.');
writeln ('  This short routine does a few calculations based on your number entry.');
Start:
Reset (Input);
WriteLn;
write ('  Enter surface area of a sphere > ');
While Not EOLN(Input) do
Begin
read (SurfSphr);
if ioresult = 106 then
begin
typo;
goto start;
end
else
if SurfSphr < 0 then
begin
negative_SurfArea;
goto Start;
end;
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Enter surface area of a sphere > ',surfsphr :1:decimal);
end;
radius := SurfSphr / (4 * MyPi);
Radius := SqRt(radius);
Diameter := Radius * 2;
Circum := MyPi * 2 * Radius;
Area := MyPi * Sqr(Radius);
Volume := 4 / 3 * MyPi * Radius * Radius * Radius;
WriteLn;
writeln ('  The radius of this sphere is');
writeln ('  ',Radius :1:decimal, ' linear units.');
writeln ('  The diameter of this sphere is');
writeln ('  ',Diameter :1:decimal, ' linear units.');
writeln ('  The circumference of this sphere is');
writeln ('  ',Circum :1:decimal, ' "linear" units.');
writeln ('  The area of a circle with this radius is');
writeln ('  ',Area :1:decimal, ' square units.');
writeln ('  The volume of a sphere with this radius is');
writeln ('  ',Volume :1:decimal, ' cubic units.');
if answer = true then
begin
WriteLn(logfile);
writeln (logfile,'The radius of this sphere is');
writeln (logfile,radius :1:decimal, ' linear units.');
writeln (logfile, 'The diameter of this circle is');
writeln (logfile,Diameter :1:decimal, ' linear units.');
writeln (logfile,'The circumference of this circle is');
writeln (logfile,Circum :1:decimal, ' "linear" units.');
writeln (logfile,'The area of this circle is');
writeln (logfile,Area :1:decimal, ' square units.');
writeln (logfile,'The volume of a sphere with this radius is');
writeln (logfile,volume :1:decimal, ' "square" units.');
end;
Count := Count + 1;
WriteLn;
writeln ('  To skip, just press Enter.');
writeln ('  We can now compute the volume of a right circular cylinder.');
Oops_1:
reset (input);
WriteLn;
write ('  Height > ');
If Not EOLN(Input) then
Begin
Read (Height);
if ioresult = 106 then
begin
typo;
goto oops_1;
end
else
If Height < 0 then
Begin
negative_height;
Goto Oops_1;
End;
ComputeCylinder;
if answer = true then
begin
writeln(logfile, 'Height, right circular cylinder: ',Height :1:decimal);
writeln(logfile, 'Volume: ',volcyl :1:decimal);
writeln(logfile, 'Surface area: ',surfcyl:1:decimal);
end;
WriteLn;
writeln ('  The volume is ', VolCyl :1:decimal, ' cubic units.');
writeln('  The surface area is ',surfcyl:1:decimal,' "square" units.');
countcyl := countcyl + 1;
End;
WriteLn;
writeln ('  To go to the top, just press Enter.');
writeln ('  We can now compute the volume of a right circular cone.');
oops_2:
reset (input);
WriteLn;
write ('  Height > ');
If Not EOLN(Input) then
Begin
Read (Height);
if ioresult = 106 then
begin
typo;
goto oops_2;
end
else
If Height < 0 then
Begin
negative_height;
Goto Oops_2;
End;
computecone;
if answer = true then
begin
writeln(logfile, 'Height, right circular cone: ',Height :1:decimal);
writeln(logfile, 'Volume: ',volcone :1:decimal);
writeln(logfile, 'Surface area: ',surfcon:1:decimal);
end;
WriteLn;
writeln ('  The volume is ', VolCone :1:decimal, ' cubic units.');
writeln('  The surface area is ',surfcon:1:decimal,' "square" units.');
countcon := countcon + 1;
Goto Start;
End
Else
Goto Start;
End;
if answer = true then
begin
writeln(logfile);
if count = 1 then
begin
writeln (logfile,'You made ', count, ' surface area entry.')
end
else
writeln (logfile,'You made ', Count, ' surface area entries.');
if CountCyl = 1 then
writeln (logfile,'You made ', CountCyl, ' cylinder entry.')
else
writeln (logfile,'You made ', CountCyl, ' cylinder entries.');
if countcon = 1 then
writeln (logfile,'You made ', countcon, ' cone entry.')
else
writeln (logfile,'You made ', countcon, ' cone entries.');
WriteLn(logfile,'___________________________________________________________________________');
end;
End;

Procedure Cylinder1;

label TryAgain, oops;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: RAD-CYL  (you enter a volume and height of a right');
writeln(logfile,'                   circular cylinder, and its radius is found).');
writeln(logfile);
end;
NumEntries := 0;
WriteLn;
writeln ('  This routine takes your entries for volume and height');
writeln ('  of a right circular cylinder, and finds the radius of');
writeln ('  the cylinder. To exit, just press Enter.');
reset (input);
WriteLn;
write ('  Enter volume > ');
While Not EOLN (Input) do
Begin
Read (Volume);
if ioresult = 106 then
begin
typo;
goto tryagain;
end
else
if Volume < 0 then
begin
negative_volume;
goto TryAgain;
end;
oops:
reset (input);
WriteLn;
write ('  Enter height > ');
if not EOLN (input) then
Read (Height)
else
goto oops;
if ioresult = 106 then
begin
typo;
goto oops;
end
else
if Height < 0 then
begin
negative_height;
goto oops;
end;
if height = 0 then
begin
undefined1;
goto tryagain;
end;
radius := Volume / (MyPi * Height);
Radius := SqRt(radius);
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Volume, right circular cylinder: ',Volume :1:decimal);
writeln(logfile, 'Height, right circular cylinder: ',Height :1:decimal);
writeln(logfile, 'Radius: ',Radius :1:decimal);
end;
WriteLn;
writeln ('  The radius is ', Radius :1:decimal, ' linear units.');
Reset (Input);
NumEntries := NumEntries + 1;
TryAgain:
reset(input);
WriteLn;
writeln ('  To exit, just press Enter.');
write ('  Enter volume > ');
End;
if answer = true then
finish(logfile,numentries);
End;

Procedure Cylinder2;

label TryAgain, oops;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: HEIGHT-CYL  (you enter a volume and radius of a right');
writeln(logfile,'                      circular cylinder, and its height is found).');
writeln(logfile);
end;
NumEntries := 0;
WriteLn;
writeln ('  This routine takes your entries for volume and radius');
writeln ('  of a right circular cylinder, and finds the height of');
writeln ('  the cylinder. To exit, just press Enter.');
reset (input);
WriteLn;
write ('  Enter volume > ');
While Not EOLN (Input) do
Begin
Read (Volume);
if ioresult = 106 then
begin
typo;
goto tryagain;
end
else
if Volume < 0 then
begin
negative_volume;
goto TryAgain;
end;
oops:
reset (input);
WriteLn;
write ('  Enter radius > ');
if not EOLN (input) then
Read (Radius)
else
goto oops;
if ioresult = 106 then
begin
typo;
goto oops;
end
else
if Radius < 0 then
begin
negative_radius;
goto oops;
end;
if radius = 0 then
begin
undefined2;
goto tryagain;
end
else
Height := Volume / (MyPi * Sqr(Radius));
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Volume, right circular cylinder: ',Volume :1:decimal);
writeln(logfile, 'Radius, right circular cylinder: ',Radius :1:decimal);
writeln(logfile, 'Height: ',Height :1:decimal);
end;
WriteLn;
writeln ('  The height is ', Height :1:decimal, ' linear units.');
Reset (Input);
NumEntries := NumEntries + 1;
tryagain:
reset(input);
WriteLn;
writeln ('  To exit, just press Enter.');
write ('  Enter volume > ');
End;
if answer = true then
finish(logfile,numentries);
End;

Procedure Cone1;

label TryAgain, oops;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: RAD-CON  (you enter a volume and height of a right');
writeln(logfile,'                   circular cone, and its radius is found).');
writeln(logfile);
end;
NumEntries := 0;
WriteLn;
writeln ('  This routine takes your entries for volume and height of');
writeln ('  a right circular cone, and finds the radius of the cone.');
writeln ('  To exit, just press Enter.');
WriteLn;
reset (input);
write ('  Enter volume > ');
While Not EOLN (Input) do
Begin
Read (Volume);
if ioresult = 106 then
begin
typo;
goto tryagain;
end
else
if Volume < 0 then
begin
negative_volume;
goto TryAgain;
end;
oops:
reset (input);
WriteLn;
write ('  Enter height > ');
if not EOLN (input) then
Read (height)
else
goto oops;
if ioresult = 106 then
begin
typo;
goto oops;
end
else
if height < 0 then
begin
negative_height;
goto oops;
end;
if height = 0 then
begin
undefined1;
goto tryagain;
end
else
radius := Volume / (1 / 3 * MyPi * Height);
Radius := SqRt(radius);
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Volume, right circular cone: ',Volume :1:decimal);
writeln(logfile, 'Height, right circular cone: ',Height :1:decimal);
writeln(logfile, 'Radius: ',Radius :1:decimal);
end;
WriteLn;
writeln ('  The radius is ', Radius :1:decimal, ' linear units.');
NumEntries := NumEntries + 1;
tryagain:
Reset (Input);
WriteLn;
writeln ('  To exit, just press Enter.');
write ('  Enter volume > ');
End;
if answer = true then
finish(logfile,numentries);
End;

Procedure Cone2;

label TryAgain, oops;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: HEIGHT-CONE  (you enter a volume and radius of a right');
writeln(logfile,'                       circular cone, and its height is found).');
writeln(logfile);
end;
NumEntries := 0;
WriteLn;
writeln ('  This routine takes your entries for volume of a right circular');
writeln ('  cone, along with the radius of the base circle of the right');
writeln ('  circular cone, and finds the height of the cone.');
WriteLn;
reset(input);
write ('  Enter volume > ');
While Not EOLN (Input) do
Begin
Read (Volume);
if ioresult = 106 then
begin
typo;
goto TryAgain;
end
else
if Volume < 0 then
begin
negative_volume;
goto TryAgain;
end;
oops:
reset (input);
WriteLn;
write ('  Enter radius > ');
if not EOLN (input) then
Read (Radius)
else
goto oops;
if ioresult = 106 then
begin
typo;
goto oops;
end
else
if Radius < 0 then
begin
negative_radius;
goto oops;
end;
if radius = 0 then
begin
undefined2;
goto tryagain;
end
else
Height := Volume / (1 / 3 * MyPi * Sqr(Radius));
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Volume, right circular cone: ',Volume :1:decimal);
writeln(logfile, 'Radius, right circular cone: ',Radius :1:decimal);
writeln(logfile, 'Height: ',Height :1:decimal);
end;
WriteLn;
writeln ('  The height is ', Height :1:decimal, ' linear units.');
NumEntries := NumEntries + 1;
TryAgain:
Reset (Input);
WriteLn;
writeln ('  To exit, just press Enter.');
write ('  Enter volume > ');
End;
if answer = true then
finish(logfile,numentries);
End;

procedure dist;

label oops1,oops2,done;

begin
clrscr;
if answer = true then
begin
writeln(logfile);
writeln(logfile,'ROUTINE: DISTANCE FORMULA');
writeln(logfile);
end;
numentries:=0;
writeln;
writeln('  This routine uses the distance formula:');
textcolor(14);
writeln('       __________________________');
writeln('  D = \ (x2  x1) + (y2  y1)');
textcolor(15);
writeln;
writeln('  in a 2-dimensional XY cartesian coordinate system.');
writeln('  You may use negative and/or decimal numbers.');
oops1:
reset(input);
writeln;
writeln('  Enter your values separated by a space.');
writeln;
writeln('  To exit, just press Enter.');
write('  What are x1 and y1 ?  >  ');
if not eoln(input) then
readln(x1,y1)
else goto done;
begin
if ioresult=106 then
begin
typo;
goto oops1;
end;
end;
oops2:
reset(input);
writeln;
write('  What are x2 and y2 ?  >  ');
if not eoln(input) then
begin
readln(x2,y2);
if ioresult=106 then
begin
typo;
goto oops2;
end;
end
else goto oops2;
distance := sqrt((sqr(x2-x1)+(sqr(y2-y1))));
writeln;
writeln('  The distance is:  ',distance:1:decimal);
numentries := numentries+1;
if answer = true then
begin
writeln(logfile);
writeln(logfile,'(x1, y1) = (',x1:1:decimal,', ',y1:1:decimal,')');
writeln(logfile,'(x2, y2) = (',x2:1:decimal,', ',y2:1:decimal,')');
writeln(logfile,'D = ',distance:1:decimal);
end;
goto oops1;
done:
if answer = true then
finish(logfile,numentries);
end;


Procedure Celsius_to_Fahrenheit;

Label Loop,done1;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: C  to   F and K');
writeln(logfile);
end;
numentries := 0;
WriteLn;
writeln ('  This routine converts celsius to fahrenheit and kelvin.');
writeln ('  You may enter decimal and negative numbers.');
Loop:
Reset (Input);
WriteLn;
writeln ('  To exit, just press Enter.');
write ('  Enter degrees celsius > ');
if Not EOLN(Input) then
Readln (Celsius)
else goto done1;
If IOResult = 106 then
begin
typo;
goto loop;
end;
If Celsius < -273.15 then
Begin
too_low;
Goto Loop;
End;
Fahrenheit := 9 / 5 * Celsius + 32;
WriteLn;
writeln ('  That equals');
writeln ('  ',Fahrenheit :1:decimal, ' fahrenheit,');
Kelvin := Celsius + 273.15;
WriteLn;
writeln ('  and that equals');
writeln ('  ',Kelvin :1:decimal, ' kelvin.');
numentries := numentries + 1;
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Celsius: ',Celsius :1:decimal);
writeln(logfile, 'Fahrenheit: ',Fahrenheit :1:decimal);
writeln(logfile, 'Kelvin: ',Kelvin :1:decimal);
end;
Goto Loop;
done1:
if answer = true then
finish(logfile,numentries);
end;

Procedure Fahrenheit_to_Celsius;

Label Loop,done1;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: F  to   C and K');
writeln(logfile);
end;
numentries := 0;
WriteLn;
writeln ('  This routine converts fahrenheit to celsius and kelvin.');
writeln ('  You may enter decimal and negative numbers.');
Loop:
Reset (Input);
WriteLn;
writeln ('  To exit, just press Enter.');
write ('  Enter degrees fahrenheit > ');
if Not EOLN(Input) then
Readln (Fahrenheit)
else goto done1;
if ioresult = 106 then
begin
typo;
goto loop;
end
else If Fahrenheit < -459.67 then
Begin
too_low;
Goto Loop;
End;
Celsius := 5 / 9 * (Fahrenheit - 32);
kelvin := Celsius + 273.15;
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Fahrenheit: ',Fahrenheit :1:decimal);
writeln(logfile, 'Celsius: ',Celsius :1:decimal);
writeln(logfile, 'Kelvin: ',Kelvin :1:decimal);
end;
WriteLn;
writeln ('  That equals');
writeln ('  ',Celsius :1:decimal, ' celsius,');
WriteLn;
writeln ('  and that equals');
writeln ('  ',Kelvin :1:decimal, ' kelvin.');
numentries := numentries + 1;
Reset (Input);
Goto Loop;
done1:
if answer = true then
finish(logfile,numentries);
End;

Procedure Kelvin_to_Celsius;

Label Loop,done1;

Begin
numentries := 0;
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: K  to   C and F');
writeln(logfile);
end;
WriteLn;
writeln ('  This routine converts kelvin to celcius and fahrenheit.');
writeln ('  You may enter decimal and negative numbers.');
Loop:
Reset (Input);
WriteLn;
writeln ('  To exit, just press Enter.');
write ('  Enter degrees kelvin > ');
if Not EOLN(Input) then
Readln(Kelvin)
else goto done1;
if ioresult = 106 then
begin
typo;
goto loop;
end
else If kelvin < 0 then
Begin
too_low;
Goto Loop;
End;
Celsius := Kelvin - 273.15;
Fahrenheit := 9 / 5 * Celsius + 32;
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Kelvin: ',Kelvin :1:decimal);
writeln(logfile, 'Celsius: ',Celsius :1:decimal);
writeln(logfile, 'Fahrenheit: ',Fahrenheit :1:decimal);
end;
WriteLn;
writeln ('  That equals');
writeln ('  ',Celsius :1:decimal, ' celsius,');
WriteLn;
writeln ('  and that equals');
writeln ('  ',Fahrenheit :1:decimal, ' fahrenheit.');
numentries := numentries + 1;
Reset (Input);
Goto Loop;
done1:
if answer = true then
finish(logfile,numentries);
End;

Procedure Root_;

procedure lowindex;

begin
textcolor(12);
WriteLn;
writeln ('  You entered an index less than 2.');
beep;
textcolor(15);
end;

Label Re_Enter, non_number;

procedure Positive;

Label TryAgain, Next;

Begin
TryAgain:
reset (input);
WriteLn;
write ('  Enter the index > ');
if not EOLN (input) then
Read (Index)
else goto tryagain;
if ioresult = 106 then
begin
typo_or_decimal;
bool := true;
exit;
end
else
Reset (Input);
If Index < 2 then
Begin
lowindex;
bool := true;
exit;
End;
If Radicand = 0.0 then
Begin
Root := 0.0;
Goto Next;
End;
Root := Exp(1 / Index * Ln(Radicand));
Next:
WriteLn;
writeln ('  The root is ', Root :1:decimal);
NumEntries := NumEntries + 1;
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Radicand: ',Radicand :1:decimal);
writeln(logfile, 'Index: ',Index :1);
writeln(logfile, 'Root: ',Root :1:decimal);
end;
End;

Procedure Negative;

procedure imaginary;

begin
textcolor(12);
WriteLn;
writeln ('  You have attempted to take an even root of a negative radicand.');
writeln ('  This routine is not able to evaluate this non-real number.');
textcolor(15);
beep;
end;

Label Invalid, Finished, oops;

Begin
oops:
reset (input);
WriteLn;
write ('  Enter the odd index > ');
if not EOLN (input) then
Read (Index)
else goto oops;
if ioresult = 106 then
begin
typo_Or_decimal;
bool := true;
exit;
end
else
If Index < 2 then
Begin
lowindex;
bool := true;
exit;
End;
If Index Mod 2 = 0 Then
Goto Invalid;
Root := Exp(1 / Index * Ln(Abs(Radicand))) * (-1);
WriteLn;
writeln ('  The root is ', Root :1:decimal);
NumEntries := NumEntries + 1;
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Radicand: ',Radicand :1:decimal);
writeln(logfile, 'Index: ',Index :1);
writeln(logfile, 'Root: ',Root :1:decimal);
end;
Goto Finished;
Invalid:
imaginary;
goto finished;
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Radicand: ',Radicand :1:decimal);
writeln(logfile, 'Index: ',Index :1);
writeln(logfile, 'Root: ',Root :1:decimal);
end;
Finished:
End;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: ROOT');
writeln(logfile);
end;
  NumEntries := 0;
  WriteLn;
  writeln ('  This routine evaluates radicals. You enter a radicand,');
  writeln ('  then you enter an index, and the root is computed. For');
  writeln ('  example, to take the cube root of 27, first you enter 27,');
  writeln ('  the radicand, then you enter 3, the index. To take the');
  writeln ('  square root of a number, the index is 2. You may enter');
  writeln ('  negative and/or decimal numbers for radicand, but you may');
  writeln ('  enter only positive integers for the index (natural numbers).');
  writeln ('  New in this version is the ability to enter a coefficient of');
  writeln ('  the radical other than the default coefficient of 1. You may');
  writeln ('  enter negative and decimal coefficients.');
  WriteLn;
  writeln ('  All odd indexes allow negative radicands, but even indexes do not.');
  Reset (Input);
  WriteLn;
  writeln ('  To exit, just press Enter.');
  write ('  Enter the radicand > ');
  While Not EOLN (Input) do
Begin
  Read (Radicand);
  if ioresult = 106 then
begin
typo;
goto re_enter;
end
  else
  If Radicand < 0.0 Then
  Negative
  Else If Radicand >= 0.0 Then
  Positive;
  if (Radicand < 0.0) and (Index Mod 2 = 0) then
  Goto Re_Enter;
  if bool = true then
  goto re_enter;
  non_number:
  reset(input);
  WriteLn;
  writeln ('  The coefficient is 1. Enter a new coefficient or press enter to skip.');
  WriteLn;
  write ('  Coefficient > ');
  coefficient := 1;
  While Not EOLN (Input) do
Begin
  Read (Coefficient);
  if ioresult = 106 then
begin
typo;
goto non_number;
end
  else
  If Radicand = 0.0 then
  Product := 0.0
  Else
  Product := Root * Coefficient;
  WriteLn;
  writeln ('  The product is ', Product :1:decimal);
End;
  if answer = true then
  begin
  writeln(logfile, 'Coefficient: ',Coefficient :1:decimal);
  product := root * coefficient;
  writeln(logfile, 'Product: ',Product :1:decimal);
  end;
  Re_Enter:
  bool := false;
  reset(input);
  WriteLn;
  writeln ('  To exit, just press Enter.');
  write ('  Enter the radicand > ');
End;
if answer = true then
finish(logfile,numentries);
End;

Procedure Exponent_;

Label Oops, Oops1;

Procedure Positive;

Label TryAgain, Next;

procedure undefined;

begin
textcolor(12);
WriteLn;
writeln ('  Zero to the zero power is undefined.');
beep;
textcolor(15);
end;

Begin
TryAgain:
reset (input);
WriteLn;
write ('  Enter the exponent > ');
if not EOLN (input) then
Read (Exponent)
else goto tryagain;
if ioresult = 106 then
begin
typo;
goto TryAgain;
end
else
Reset (Input);
While (Base = 0.0) and (Exponent = 0.0) do
begin
undefined;
exit;
End;
While (Base = 0.0) and (Exponent > 0.0) do
Begin
Result := 0.0;
Goto Next;
End;
Result := Exp(Exponent * Ln(Base));
Next:
WriteLn;
writeln ('  The result is ', Result :1:decimal);
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Base: ', Base :1:decimal);
writeln(logfile, 'Exponent: ',Exponent :1:decimal);
writeln(logfile, 'Result: ',Result :1:decimal);
end;
End;

Procedure Negative;

Label Even, Finished, oops2;

Begin
  oops2:
  reset (input);
  WriteLn;
  write ('  Enter the integer exponent > ');
  if not EOLN (input) then
  Read (Exp_Int)
  else goto oops2;
  if ioresult = 106 then
begin
typo_or_decimal;
bool := true;
exit;
end
  else If Exp_Int Mod 2 = 0 Then
  Goto Even;
  Result := Exp(Exp_Int * Ln(Abs(Base))) * (-1);
  WriteLn;
  writeln ('  The result is ', Result :1:decimal);
  Goto Finished;
  Even:
  Result := Exp(Exp_Int * Ln(Abs(Base)));
  WriteLn;
  writeln ('  The result is ', Result :1:decimal);
  Finished:
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'Base: ', Base :1:decimal);
writeln(logfile, 'Exponent: ',Exponent :1:decimal);
writeln(logfile, 'Result: ',Result :1:decimal);
end;
End;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: EXPONENT');
writeln(logfile);
end;
  NumEntries := 0;
  WriteLn;
  writeln ('  This routine takes a number you specify (the base), and a power');
  writeln ('  you wish to raise it to (the exponent), and computes the result.');
  writeln ('  You may enter negative and decimal bases and exponents, but if you');
  writeln ('  enter a negative base, your exponent must be an integer. Be careful, if');
  writeln ('  you enter a negative base, the routine assumes parentheses, so that');
  writeln ('  (-6) = 36. But  -6 = -36  in algebra. The computer assumes parentheses.');
  writeln ('  Certain very small exponents may cause your answer to read as zero,');
  writeln ('  erroneously, as I could put in only 11 decimal places. New in this');
  writeln ('  version is the ability to enter a coefficient of the exponential number');
  writeln ('  other than the default coefficient of 1. You may enter negative and');
  writeln ('  decimal coefficients. To exit, just press Enter.');
  Reset (Input);
  WriteLn;
  write ('  Enter the base > ');
  While Not EOLN (Input) do
Begin
Read (Base);
if ioresult = 106 then
begin
typo;
goto oops;
end
else If Base < 0.0 Then
Negative;
If Base >= 0.0 Then
Positive;
While (Base = 0.0) and (Exponent = 0.0) do
Goto oops;
if bool = true then
goto oops;
NumEntries := NumEntries + 1;
coefficient := 1;
oops1:
reset (Input);
WriteLn;
writeln ('  The coefficient is 1. Enter a new coefficient or press Enter to skip.');
WriteLn;
write ('  Coefficient > ');
While Not EOLN (Input) do
Begin
Read (Coefficient);
If ioresult = 106 then
begin
typo;
goto oops1;
end
else If Base = 0.0 then
Product := 0.0
Else
Product := Result * Coefficient;
WriteLn;
writeln ('  The product is ', Product :1:decimal);
End;
if answer = true then
begin
writeln(logfile, 'Coefficient: ',Coefficient :1:decimal);
product := Result * Coefficient;
writeln(logfile, 'Product: ',Product :1:decimal);
end;
oops:
Reset (Input);
bool := false;
WriteLn;
writeln ('  To exit, just press Enter.');
write ('  Enter the base > ');
End;
if answer = true then
finish(logfile,numentries);
End;

Procedure Quadratic_Formula;

Label loop, oops1, oops2, done;

procedure undefined;

begin
textcolor(12);
WriteLn;
writeln ('  You cannot enter zero for A. The quotient is undefined.');
beep;
textcolor(15);
end;

procedure empty;

begin
WriteLn;
writeln ('  The solution set of this quadratic equation is empty.');
writeln ('  However, the entry has been counted.');
beep;
end;


Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: QUADRATIC FORMULA');
writeln(logfile);
end;
  NumEntries := 0;
  WriteLn;
  writeln ('  This routine uses the quadratic formula to find');
  writeln ('  a solution set with two values for X. It would help');
  writeln ('  the user to be familiar with quadratic equations.');
  writeln ('  Sometimes both values of X are the same, but often they are');
  writeln ('  different. You may use decimal and negative numbers.');
  WriteLn;
  writeln ('  The general form of the quadratic equation is: ax + bx + c = 0.');
  writeln ('  The quadratic formula is:');
  textcolor(14);
  writeln ('                                 ___________');
  writeln ('                           -b  \ b - 4ac');
  writeln ('                          ');
  writeln ('                                   2a');
  textcolor(15);
  WriteLn;
  writeln ('  If the answer is a non-real number (the square root of a negative');
  writeln ('  number), you will get a message that says so. This means the');
  writeln ('  solution set is empty. However, these entries will be tallied.');
  loop:
  Reset (Input);
  WriteLn;
  writeln ('  To exit, just press Enter.');
  write ('  Enter A > ');
  if Not EOLN(Input) then
  Read (a)
  else goto done;
  if ioresult = 106 then
begin
  typo;
  goto loop;
end
  else
  If a = 0 then
Begin
  undefined;
  Goto loop;
End;
  oops1:
  reset (input);
  writeln;
  write ('  Enter B > ');
  if not EOLN (input) then
  Read (b)
  else goto oops1;
  if ioresult = 106 then
begin
  typo;
  goto oops1;
end
  else
  oops2:
  reset (input);
  writeln;
  write ('  Enter C > ');
  if not EOLN (input) then
  Read (c)
  else goto oops2;
  if ioresult = 106 then
begin
  typo;
  goto oops2;
end
  else
  x1 := (b * b - 4 * a * c);
  x2 := (b * b - 4 * a * c);
If x1 < 0.0 then
Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile,'A: ',A :1:decimal);
writeln(logfile,'B: ',B :1:decimal);
writeln(logfile,'C: ',C :1:decimal);
writeln (logfile,'The solution set of the above quadratic equation is empty.');
writeln (logfile,'However, the entry has been counted.');
end;
empty;
NumEntries := NumEntries + 1;
Goto loop;
End;
x1 := (-b + Sqrt(x1)) / (2 * a);
x2 := (-b - Sqrt(x2)) / (2 * a);
NumEntries := NumEntries + 1;
WriteLn;
writeln ('  X = ', x1 :1:decimal);
writeln ('  and');
writeln ('  X = ', x2 :1:decimal);
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'A: ',A :1:decimal);
writeln(logfile, 'B: ',B :1:decimal);
writeln(logfile, 'C: ',C :1:decimal);
writeln(logfile, 'X = ',X1 :1:decimal);
writeln(logfile, 'X = ',X2 :1:decimal);
end;
goto loop;
done:
if answer = true then
finish(logfile,numentries);
End;

Procedure CheckQuad;

Label Loop, Next, arrgghh1, arrgghh2, arrgghh3, arrgghh4, done;

Procedure A_is_Zero;

label oops1, oops2, oops3;

Begin
  oops1:
  reset (input);
  writeln;
  write ('  Enter M > ');
  if not EOLN (input) then
  Read (M)
  else goto oops1;
  if ioresult = 106 then
begin
  typo;
  goto oops1;
end;
  oops2:
  reset (input);
  writeln;
  write ('  Enter X > ');
  if not EOLN (input) then
  Read (X)
  else goto oops2;
  if ioresult = 106 then
begin
  typo;
  goto oops2;
end;
  oops3:
  reset (input);
  writeln;
  write ('  Enter B > ');
  if not EOLN (input) then
  Read (B)
  else goto oops3;
  if ioresult = 106 then
begin
  typo;
  goto oops3;
end
  else
  Result := (M * X) + B;
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'M: ',M :1:decimal);
writeln(logfile, 'X: ',X :1:decimal);
writeln(logfile, 'B: ',B :1:decimal);
writeln(logfile, 'MX + B = ',Result :1:decimal);
end;
WriteLn;
writeln ('  Y = ', Result :1:decimal);
Count_Slope_Intercept := Count_Slope_Intercept + 1;
End;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: QUAD  OR LINEAR');
writeln(logfile);
end;
Count_Check_Quad := 0;
Count_Quad_Not_Zero := 0;
Count_Slope_Intercept := 0;
WriteLn;
writeln ('  This routine is capable of three different computations:');
writeln;
writeln ('  First, this routine can check the two X answers per equation');
writeln ('  you got using the quadratic formula routine ("quad"). First you');
writeln ('  enter the values for A, B, and C. Then you enter the two');
writeln ('  values for X, one at a time. Both answers you get should');
writeln ('  be zero. Remember the quadratic equation:  ax + bx + c = 0');
writeln ('  You may enter negative and decimal numbers.');
WriteLn;
writeln ('  Second, you can also use it for your own quadratic equations,');
writeln ('  where zero need not be the initial answer, such as:  ax + bx + c = d.');
writeln ('  Then subtract the non-zero D from both sides, or go on to complete');
writeln ('  the square, or whatever. Some of it you''ll do by hand.');
WriteLn;
writeln ('  Third, if you enter zero for A, you can do linear');
writeln ('  equations of the slope-intercept form:  y = mx + b.');
loop:
Reset (Input);
WriteLn;
writeln ('  To exit, just press Enter.');
write ('  Enter A > ');
if Not EOLN (Input) then
Read (A)
  else goto done;
  if ioresult = 106 then
begin
  typo;
  goto loop;
end
  else
  If A = 0.0 then
Begin
  A_is_Zero;
  Goto Loop;
End;
  arrgghh1:
  reset (input);
  writeln;
  write ('  Enter B > ');
  if not EOLN (input) then
  Read (B)
  else goto arrgghh1;
  if ioresult = 106 then
begin
  typo;
  goto arrgghh1;
end
  else
  arrgghh2:
  reset (input);
  writeln;
  write ('  Enter C > ');
  if not EOLN (input) then
  Read (C)
  else goto arrgghh2;
  if ioresult = 106 then
begin
  typo;
  goto arrgghh2;
end
  else
  arrgghh3:
  reset (input);
  writeln;
  write ('  Enter the first X > ');
  if not EOLN (input) then
  Read (X1)
  else goto arrgghh3;
  if ioresult = 106 then
begin
  typo;
  goto arrgghh3;
end
  else
  Result := (A * Sqr(X1)) + (B * X1) + C;
  WriteLn;
  writeln ('  The result is ', Result :1:decimal);
  If Result <> 0.0 then
Begin
  Count_Quad_Not_Zero := Count_Quad_Not_Zero + 1;
  if answer = true then
  begin
  writeln(logfile);
  writeln(logfile, 'A: ',A :1:decimal);
  writeln(logfile, 'B: ',B :1:decimal);
  writeln(logfile, 'C: ',C :1:decimal);
  writeln(logfile, 'X1: ',X1 :1:decimal);
writeln(logfile, 'D = ',Result :1:decimal,', not zero. The first X fails. No need to try a 2nd X.');
  end;
  Goto Loop;
End;
  arrgghh4:
  reset (input);
  WriteLn;
  write ('  Enter the second X > ');
  if not EOLN (input) then
  Read (X2)
  else goto arrgghh4;
  if ioresult = 106 then
begin
  typo;
  goto arrgghh4;
end
  else
  Result := (A * Sqr(X2)) + (B * X2) + C;
  WriteLn;
  writeln ('  The result is ', Result :1:decimal);
  if result = 0 then
  begin
  Count_Check_Quad := Count_Check_Quad + 1;
  if answer = true then
  begin
  writeln(logfile);
  writeln(logfile, 'A: ',A :1:decimal);
  writeln(logfile, 'B: ',B :1:decimal);
  writeln(logfile, 'C: ',C :1:decimal);
  writeln(logfile, 'X1: ',X1 :1:decimal);
  writeln(logfile, 'X2: ',X2 :1:decimal);
  writeln(logfile, 'D = zero in both instances.');
  end;
  goto loop;
end;
if result <> 0 then
begin
count_quad_not_zero := count_quad_not_zero + 1;
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'A: ',A :1:decimal);
writeln(logfile, 'B: ',B :1:decimal);
writeln(logfile, 'C: ',C :1:decimal);
writeln(logfile, 'X1: ',X1 :1:decimal);
writeln(logfile, 'X2: ',X2 :1:decimal);
writeln(logfile, 'D = ',Result :1:decimal, ', not zero. It''s the 2nd X above that''s wrong.');
end;
goto loop;
end;
done:
  WriteLn;
  WriteLn ('  ',Count_Check_Quad, ' of your quadratic equations equaled zero.');
  WriteLn ('  ',Count_Quad_Not_Zero, ' of your quadratic equations did not equal zero.');
  if count_slope_intercept = 1 then
  writeln ('  You made ', count_slope_intercept, ' slope-intercept entry.')
  else
  writeln ('  You made ', Count_Slope_Intercept, ' slope-intercept entries.');
if answer = true then
begin
WriteLn(logfile);
WriteLn (logfile, Count_Check_Quad, ' of your quadratic equations equaled zero.');
WriteLn (logfile,Count_Quad_Not_Zero, ' of your quadratic equations did not equal zero.');
if count_slope_intercept = 1 then
writeln (logfile,'You made ', count_slope_intercept, ' slope-intercept entry.')
else
writeln (logfile,'You made ', Count_Slope_Intercept, ' slope-intercept entries.');
writeln(logfile,'___________________________________________________________________________');
end;
End;

Procedure Addition;

Label Loop, Next;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: ADD');
writeln(logfile);
end;
numentries := 0;
  WriteLn;
  writeln ('  This routine adds up to 15 numbers at a time. You may use');
  writeln ('  decimal numbers, and negative numbers. You enter your');
  writeln ('  numbers, separated by spaces, and the computer adds them.');
  writeln ('  Any numbers past the 15th will not be added. If you must delete');
  writeln ('  the last number on the line by backspacing over it, back up all');
  writeln ('  the way to the right edge of the last number.');
Loop:
if answer = true then
writeln(logfile);
Count := 0;
Sum := 0.0;
Reset (Input);
WriteLn;
WriteLn ('  To exit, just press enter.');
WriteLn ('  Enter up to 15 numbers, separated by spaces.');
WriteLn;
Write ('  > ');
While (Not EOLN (Input)) and (Count < 15) do
Begin
Count := Count + 1;
Read (Input, Add[Count]);
If IOResult = 106 then
begin
typo;
Goto Loop;
end
else
End;
For I := 1 to Count do
begin
Sum := Sum + Add[I];
if answer = true then
writeln(logfile,Add[I] :1:decimal);
end;
If Count = 0 then
Goto Next;
WriteLn;
WriteLn ('  Sum of above ',count,' numbers is ', Sum :1:decimal);
if answer = true then
writeln(logfile,'Sum of above ',count, ' numbers: ',Sum :1:decimal);
NumEntries := NumEntries + Count;
Next:
While Count <> 0 do
Goto Loop;
if answer = true then
begin
WriteLn(logfile);
if numentries = 1 then
writeln (logfile,'You added ', Numentries, ' number.')
else
writeln (logfile,'You added ', NumEntries, ' numbers.');
writeln(Logfile,'___________________________________________________________________________');
end;
end;

Procedure Subtract;

Label loop, oops, done;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: SUBTRACT');
writeln(logfile);
end;
WriteLn;
writeln ('  This routine subtracts any 2 numbers you specify.');
writeln ('  You enter 2 numbers. The number getting subtracted');
writeln ('  goes below. You may enter negative and decimal numbers.');
writeln ('  To exit, just press Enter.');
NumEntries := 0;
loop:
Reset (Input);
WriteLn;
writeln ('  To exit, just press Enter.');
write ('  Enter first number > ');
if Not EOLN (Input) then
Begin
Read (A);
If ioresult = 106 then
begin
typo;
goto loop;
end;
end
else
goto done;
if answer = true then
begin
writeln(logfile);
writeln(logfile,A :1:decimal);
end;
oops:
reset (input);
writeln;
write ('  Enter second number > ');
if not EOLN (input) then
read (B)
else
goto oops;
if ioresult = 106 then
begin
typo;
goto oops;
end;
if answer = true then
writeln(logfile,B :1:decimal);
Difference := A - B;
WriteLn;
writeln ('  The difference is ', Difference :1:decimal);
NumEntries := NumEntries + 1;
if answer = true then
writeln(logfile,'Difference of above two numbers: ',Difference :1:decimal);
goto loop;
done:
if answer = true then
finish(logfile,numentries);
End;

Procedure Multiply;

Label Loop, Next;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: MULTIPLY');
writeln(logfile);
end;
WriteLn;
writeln ('  This routine multiplies up to 15 numbers at a time. You may');
writeln ('  use decimal numbers, and negative numbers. You enter your');
writeln ('  numbers, separated by spaces, and the computer multiplies them.');
writeln ('  Any numbers past the 15th will not be multiplied. If you must');
writeln ('  delete the last number on the line by backspacing over it,');
writeln ('  back up all the way to the right edge of the last number.');
NumEntries := 0;
Loop:
if answer = true then
writeln(logfile);
Count := 0;
product := 1;
Reset (Input);
WriteLn;
WriteLn ('  To exit, just press enter.');
WriteLn ('  Enter up to 15 numbers, separated by spaces.');
WriteLn;
Write ('  > ');
While (Not EOLN (Input)) and (Count < 15) do
Begin
Count := Count + 1;
Read (Input, mult[Count]);
If IOResult = 106 then
begin
typo;
Goto Loop;
end
else
End;
For I := 1 to Count do
begin
product := product * mult[I];
if answer = true then
writeln(logfile,mult[I] :1:decimal);
end;
If Count = 0 then
Goto Next;
WriteLn;
WriteLn ('  Product of above ',count,' numbers is ', Product :1:decimal);
if answer = true then
writeln(logfile,'Product of above ',count, ' numbers: ',product :1:decimal);
NumEntries := NumEntries + Count;
Next:
While Count <> 0 do
Goto Loop;
if answer = true then
begin
WriteLn(logfile);
if numentries = 1 then
writeln (logfile,'You multiplied ', Numentries, ' number.')
else
writeln (logfile,'You multiplied ', NumEntries, ' numbers.');
writeln(Logfile,'___________________________________________________________________________');
end;
End;

Procedure Divide;

Label TryAgain, oops,oops2;

procedure divide_by_zero;

begin
textcolor(12);
WriteLn;
writeln ('  You have tried to divide by zero. This is undefined.');
textcolor(15);
beep;
end;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: DIVISION');
writeln(logfile);
end;
  WriteLn;
  writeln ('  This routine divides any two numbers you enter.');
  writeln ('  Enter your numerator first, then enter your denominator');
  writeln ('  below. You may enter negative numbers, and decimal numbers.');
  writeln ('  If you enter zero as a denominator, then the quotient');
  writeln ('  is undefined. To exit, just press Enter.');
  NumEntries := 0;
  oops2:
  Reset (Input);
  WriteLn;
  write ('  Enter the numerator > ');
while Not EOLN (Input) do
Begin
Read (A);
if ioresult = 106 then
begin
typo;
goto TryAgain;
end
else
oops:
reset (input);
WriteLn;
write ('  Enter the denominator > ');
if not EOLN (input) then
Read (B)
else
goto oops;
if ioresult = 106 then
begin
typo;
goto oops;
end
else
If B = 0 then
begin
divide_by_zero;
Goto oops2;
End
else
Quotient := A / B;
WriteLn;
writeln ('  The quotient is ', Quotient :1:decimal);
NumEntries := NumEntries + 1;
if answer = true then
begin
writeln(logfile);
writeln(logfile,A :1:decimal);
writeln(logfile,B :1:decimal);
writeln(logfile,'Quotient of above two numbers: ',Quotient :1:decimal);
end;
TryAgain:
Reset (Input);
WriteLn;
writeln ('  To exit, just press Enter.');
write ('  Enter the numerator > ');
End;
if answer = true then
finish(logfile,numentries);
End;

Procedure Average_;

Label Loop, No_Entries, oops, Ask, Done;

Begin
if answer = true then
begin
writeln(logfile);
writeln(logfile, 'ROUTINE: AVERAGE');
writeln(logfile);
end;
  Count := 0;
  WriteLn;
  writeln ('  This routine takes the average of the numbers');
  writeln ('  you enter, one per line. You may enter decimal');
  writeln ('  and negative numbers. You may enter zeroes.');
  writeln ('  To see the average, just press Enter.');
  Loop:
  if answer = true then
  writeln(logfile);
  Reset (Input);
SumEntries := 0;
NumEntries := 0;
WriteLn;
write ('  Enter one number > ');
While Not EOLN(Input) do
Begin
Read (Entry);
If IOResult = 106 then
begin
typo;
goto oops;
end
else
SumEntries := SumEntries + Entry;
NumEntries := NumEntries + 1;
if answer = true then
writeln(logfile,Entry :1:decimal);
oops:
WriteLn;
reset (input);
writeln ('  To see the average, just press Enter.');
write ('  Enter one number > ');
end;
If NumEntries = 0 then
Goto No_Entries;
Average := SumEntries / NumEntries;
Count := Count + NumEntries;
WriteLn;
writeln ('  Average of above ',numentries,' numbers is ', Average :1:decimal);
if answer = true then
writeln(logfile,'Average of above ',numentries,' numbers: ',Average :1:decimal);
No_Entries:
WriteLn;
ask:
Reset (Input);
WriteLn;
write ('  Find another average?  (Y/N)  ');
If Not EOLN(Input) then
ReadLn (reply)
else goto ask;
Case reply of
'Y', 'y' : Goto Loop;
'N', 'n' : Goto Done;
Else Goto Ask;
End;
Done:
if answer = true then
begin
WriteLn(logfile);
if count = 1 then
writeln (logfile,'You entered a total of ', count, ' number.')
else
writeln (logfile,'You entered a total of ', Count, ' numbers.');
end;
End;


begin
MyPi := 3.1415926535897932385;
bool := false;
initsyserror;
oops:
textbackground (0);
textcolor(7);
reset (input);
clrscr;
writeln;
writeln;
writeln;
write ('  Want to keep a log file?  (Y/N)  ');
textcolor(14);
if not eoln (input) then
readln (reply)
else goto oops;
case reply of
'y', 'Y' : goto next;
'n', 'N' : goto dec;
else goto oops;
end;
next:
reset(input);
clrscr;
textcolor(7);
writeln;
writeln;
writeln;
writeln('  Name your log file (use a path too if needed)');
writeln;
write('  > ');
textcolor(14);
if not eoln(input) then
begin
donesyserror;
readln (filename);
assign(logfile, filename);
rewrite(logfile);
if ioresult <> 0 then
begin
initsyserror;
textcolor(7);
clrscr;
reset(input);
gotoxy(2,12);
write('I can''t use this file: "');
textcolor(14);
write(filename);
textcolor(7);
writeln('"');
write(' ...Try naming it something else. Press Enter... ');
beep;
if not eoln(input) then
readln(dummy)
else goto next;
goto next;
end;
end
else goto next;
case reply of
'y', 'Y' : answer := true;
else answer := false;
end;
initsyserror;
Dec:
reset(input);
textcolor(7);
textbackground(0);
clrscr;
writeln;
writeln;
writeln;
writeln('  How many decimal places do you want?');
write('  (2 through 18)  >  ');
textcolor(14);
if not eoln(input) then
readln(decimal)
else goto dec;
if ioresult = 106 then
goto dec;
if decimal < 2 then
goto dec;
if decimal > 18 then
goto dec;

textbackground(0);
textcolor(0);
clrscr;

delay(100);

textbackground(1);
textcolor(1);
gotoxy(1,25);
writeln('                                                                              ');
delay(40);
gotoxy(1,1);
writeln('                                                                                ');
delay(40);
gotoxy(1,24);
writeln('                                                                                ');
delay(40);
gotoxy(1,2);
writeln('                                                                                 ');
gotoxy(1,23);
writeln('                                                                               ');
delay(40);
gotoxy(1,3);
writeln('                                                                                ');
delay(40);
gotoxy(1,22);
writeln('                                                                                ');
delay(40);
gotoxy(1,4);
writeln('                                                                                ');
delay(40);
gotoxy(1,21);
writeln('                                                                                ');
delay(40);
gotoxy(1,5);
writeln('                                                                                ');
delay(40);
gotoxy(1,20);
writeln('                                                                                ');
delay(40);
gotoxy(1,6);
writeln('                                                                                ');
delay(40);
gotoxy(1,19);
writeln('                                                                                ');
delay(40);
gotoxy(1,7);
writeln('                                                                                ');
delay(40);
gotoxy(1,18);
writeln('                                                                                ');
delay(40);
gotoxy(1,8);
writeln('                                                                                ');
delay(40);
gotoxy(1,17);
writeln('                                                                                ');
delay(40);
gotoxy(1,9);
writeln('                                                                                ');
delay(40);
gotoxy(1,16);
writeln('                                                                                ');
delay(40);
gotoxy(1,10);
writeln('                                                                                ');
delay(40);
gotoxy(1,15);
writeln('                                                                                ');
delay(40);
gotoxy(1,11);
writeln('                                                                                ');
delay(40);
gotoxy(1,14);
writeln('                                                                                ');
delay(40);
gotoxy(1,12);
writeln('                                                                                ');
delay(40);
gotoxy(1,13);
textcolor(9);
writeln('                            Mission Control was here                                 ');
delay(70);

tryagain:
reset(input);
textcolor(15);
textbackground(0);
clrscr;
textbackground(1);
textcolor(15);
write('');
textcolor(14);
write('  MathPad 1.4, Copyright (C) 1993 by Duane Bailey');
textcolor(15);
writeln('                            ');
writeln('  A)  Radius     (calculations based on the radius of a circle)              ');
writeln('  B)  Diameter   (calculations based on the diameter of a circle)            ');
writeln('  C)  Circum     (calculations based on the circumference of a circle)       ');
writeln('  D)  Area       (calculations based on the area of a circle)                ');
writeln('  E)  Volume     (calculations based on the volume of a sphere)              ');
writeln('  F)  SurfSphr   (calculations based on the surface area of a sphere)        ');
writeln('  G)  RadCyl     (finds radius based on the volume and height of a cylinder) ');
writeln('  H)  HeightCyl  (finds height based on the volume and radius of a cylinder) ');
writeln('  I)  RadCone    (finds radius based on the volume and height of a cone)     ');
writeln('  J)  HeightCone (finds height based on the volume and radius of a cone)     ');
writeln('  K)  Distance   (uses the distance formula for a twodimensional XY plane  ');
writeln('  L)  C-to-F     (celsius to fahrenheit and kelvin conversion)               ');
writeln('  M)  F-to-C     (fahrenheit to celsius and kelvin conversion)               ');
writeln('  N)  K-to-C     (kelvin to celsius and fahrenheit conversion)               ');
writeln('  O)  Root       (evaluates radicals)                                        ');
writeln('  P)  Exponent   (evaluates exponential numbers)                             ');
writeln('  Q)  Quadratic  (uses the quadratic formula on quadratic equations)         ');
writeln('  R)  Q-or-L     (quadratic or linear equations)                             ');
writeln('  S)  Add        (simple addition)                                           ');
writeln('  T)  Subtract   (subtraction)                                               ');
writeln('  U)  Multiply   (multiplication)                                            ');
write('  V)  Divide     (division)      ');
textcolor(13);
write('X) Generate users manual if it''s been lost  ');
textcolor(15);
writeln('');
write('  W)  Average    (do averages)   ');
textcolor(13);
write('Y) EXIT (ends this program)');
textcolor(15);
writeln('                 ');
textbackground(0);
textcolor(14);
Write('To run one of these subroutines, enter the letter');
textcolor(142);
write(':  ');
textcolor(14);
write('>  ');
textcolor(15);
textbackground(0);
if not eoln(input) then
readln (reply)
else
begin
textbackground(1);
clrscr;
beep;
goto tryagain;
end;
textcolor(15);
textbackground(1);
clrscr;
case reply of
'a', 'A' : radius_;
'b', 'B' : diameter_;
'c', 'C' : circum_;
'd', 'D' : area_;
'e', 'E' : volume_;
'f', 'F' : surfsphr_;
'g', 'G' : cylinder1;
'h', 'H' : cylinder2;
'i', 'I' : cone1;
'j', 'J' : cone2;
'k', 'K' : dist;
'l', 'L' : celsius_to_fahrenheit;
'm', 'M' : fahrenheit_to_celsius;
'n', 'N' : kelvin_to_celsius;
'o', 'O' : root_;
'p', 'P' : exponent_;
'q', 'Q' : quadratic_formula;
'r', 'R' : checkquad;
's', 'S' : addition;
't', 'T' : subtract;
'u', 'U' : multiply;
'v', 'V' : divide;
'w', 'W' : average_;
'x', 'X' : WriteToDisk;
'y', 'Y' : goto done;
else
begin
beep;
goto tryagain;
end;
end;
goto tryagain;
done:
donesyserror;
textcolor(7);
textbackground(0);
clrscr;
if answer = true then
begin
textcolor(15);
writeln;
writeln;
write('  Your log file is: "');
textcolor(14);
write(filename);
textcolor(15);
write('"');
textcolor(143);
writeln('.');
writeln(logfile);
writeln(logfile);
writeln(logfile,'Don''t forget to register if you haven''t already...it''s only  $10.00!');
writeln(logfile);
writeln(logfile,'Duane Bailey');
writeln(logfile,'2059 Bethabara Rd, Apt. 28');
writeln(logfile,'Winston-Salem, NC 27106');
writeln(logfile);
close (logfile);
beep;
end;
textcolor(9);
writeln;
writeln;
writeln('  I''m glad you used MathPad.......');
write('  It''s only $10.00, so hurry and register if you haven''t already');
textcolor(137);
writeln('!');
textcolor(1);
write('  ');
textbackground(7);
write(' MathPad ');
textcolor(9);
textbackground(0);
writeln(' Copyright (C) 1993 by Duane Bailey  (my handle: "Mission Control")');
textcolor(11);
writeln;
writeln('  Duane Bailey');
writeln('  2059 Bethabara Rd, Apt. 28');
writeln('  Winston-Salem, NC 27106');
writeln;
writeln('  (910) 922-3827');
writeln
end.
