10 REM Main HELP file to describe use of MECHAN programs
20 REM HELP - Last modified January 1, 1994"
30 PRINT"The latest version of MECHAN is version 94-1 January 1, 1994 "
40 PRINT
50 PRINT"MECHAN is a general purpose INTERACTIVE program for the kinematic"
60 PRINT"and dynamic analysis of single degree-of-freedom MULTI-LOOP"
70 PRINT"planar mechanisms which can be assembled from combinations of "
80 PRINT"linkages, sliders, spur gears, springs and dampers."
90 PRINT
100 PRINT"MECHAN was developed by Professor Charles Radcliffe at the "
110 PRINT"University of California at Berkeley for use by his students"
120 PRINT"in classes on Kinematics and Dynamics of Machinery." : PRINT
130 PRINT"The set of programs has also been useful to design engineers"
140 PRINT"in industry who need to verify their models of linkages and gears."
150 PRINT"The author has checked the accuracy of the calculations by"
160 PRINT"comparison, where possible, with results from graphical or other"
170 PRINT"textbook solutions."
180 PRINT
190 PRINT"No guarantee is given or implied for the accuracy of calculations"
200 PRINT"related to actual machinery and the results obtained using MECHAN"
210 PRINT"should always be checked against other solutions or test data"
220 PRINT"as appropriate."
230 PRINT
240 GOSUB 4330
250 PRINT"The MECHAN programs are distributed as user-supported shareware."
260 PRINT"The programs are copywrited and are NOT in the public domain."
270 PRINT
280 PRINT"A voluntary contribution of $25 from individuals or $50 from"
290 PRINT"corporations or educational institutions will register you as"
300 PRINT"a user.  If you find the programs useful you are expected to"
310 PRINT"make a contribution.  Students need not register until after"
320 PRINT"graduation."
330 PRINT
340 PRINT"Mail your contribution to:  Prof. C. W. Radcliffe"
350 PRINT"                            571 Silverado Drive"
360 PRINT"                            Lafayette, CA  94549"
370 PRINT
380 PRINT"You may make copies and distribute to students and other"
390 PRINT"potential users.  Please make a copy of the distriution disk"
400 PRINT"or the self-extracting file MECHAN94.EXE.  When MECHAN94.EXE "
410 PRINT"is executed at the DOS prompt all files for the complete MECHAN "
420 PRINT"system will be created in the current directory." 
430 PRINT
440 GOSUB 4330
450 PRINT"The MECHAN programs are distributed as BASIC source code"
460 PRINT"and run in INTERPRETER mode under GW-BASIC version 3.2."
470 PRINT"The programs make extensive use of the CHAIN command to"
480 PRINT"share data between programs.  The MECHAN programs were"
490 PRINT"developed many years before BASIC compilers or QUICK BASIC"
500 PRINT"became available.  The author has considered converting to"
510 PRINT"QUICK BASIC but has decided to go by the old advice ... If it"
520 PRINT"ain't broke don't fix it.  We are aware that the code is"
530 PRINT"an excellent example of 'spaghetti code' but it works."
540 PRINT
550 PRINT"GW-BASIC 3.2 does not know about VGA displays but a VGA display"
560 PRINT"should support the EGA mode (screen 9) without problems."
570 PRINT
580 PRINT"To get hardcopy of a SCREEN display you must run GRAPHICS.COM"
590 PRINT"before using the PRINT SCREEN key to print the SCREEN display."
600 PRINT"The hard copy may be a bit distorted depending upon your"
610 PRINT"SCREEN/PRINTER combination. See instructions under GRAPHICS"
620 PRINT"in the MS-DOS ver 5.0 User's Guide.  With VGA/EGA color displays"
630 PRINT"a screen capture program may give better results."
640 PRINT:GOSUB 4330
650 PRINT"      The INIT file FORMAT " : PRINT
660 PRINT"Before using MECHAN check the INIT file. This file contains a single"
670 PRINT"line in the format 'D:','1',20,1. Where 'D:' is the disk drive where"
680 PRINT"you wish to have data files stored.  The '1' selects the default"
690 PRINT"for the display resolution.  "
700 PRINT
710 PRINT"      1= screen 9 ... EGA (640x350) color display"
720 PRINT"      2= screen 2 ... CGA (600x200) mono display."
730 PRINT
740 PRINT"The number 20 is the maximum number of positions allowed."
750 PRINT"This number sets the dimensions of the many data arrays used"
760 PRINT"and shared by all of the programs. Reduce it if you get an"
770 PRINT"OUT OF MEMORY message. Try 20 for kinematics only data."
780 PRINT
790 PRINT"     15= maximum for DYNAMICS problems."
800 PRINT"     20= maximum for KINEMATICS problems."
810 PRINT
820 PRINT"The last number suppresses the information displays if set = 0"
830 PRINT
840 PRINT "To create or change the INIT file enter INIT at the DOS prompt."
850 PRINT
860 GOSUB 4330
870 PRINT"The program does all calculations in closed-form and relies"
880 PRINT"on the concept of KINEMATIC GROUPS."
890 PRINT
900 PRINT"A kinematic group is a combination of links, sliders, or gears"
910 PRINT"which forms an independent component of multiloop planar mechanisms."
920 PRINT
930 PRINT"Each of the groups can be analyzed for accelerations and/or"
940 PRINT"forces and torques as an independent problem solved in closed-form."
950 PRINT"The analysis of many complicated mechanisms can be subdivided into"
960 PRINT"a series of simple problems where the results of the analysis of"
970 PRINT"previous groups are available as input data for the analysis of the"
980 PRINT"next group in the kinematic chain."
990 PRINT
1000 PRINT"It should be noted that only single degree-of-freedom mechanisms"
1010 PRINT"can be analyzed by MECHAN.  However, a large majority of the"
1020 PRINT"mechanisms used in machinery fall in this category and MECHAN has"
1030 PRINT"been designed to be a fast and reliable method for the dynamic"
1040 PRINT"analysis of such mechanisms.  If you suspect an error in the program"
1050 PRINT"please send me the problem statement and printout of your results"
1060 PRINT"and we will resolve the problem."
1070 PRINT : GOSUB 4330
1080 PRINT"In MECHAN the terms GROUP and COMPONENT are synonymous."
1090 PRINT
1100 PRINT"A mechanism will be assembled and analyzed as a series of components"
1110 PRINT"with the kinematic analysis proceeding in sequence from the input to"
1120 PRINT"the output component of the mechanism."
1130 PRINT
1140 PRINT"Dynamic analysis begins with the output member and proceeds"
1150 PRINT"in reverse sequence from output to input component."
1160 PRINT
1170 PRINT"A named data file is created for each problem to be solved."
1180 PRINT"This data file is created interactively with the user prompted"
1190 PRINT"for each data item to be entered."
1200 PRINT
1210 PRINT"Each problem may have three associated data files with the same "
1220 PRINT"primary file name:"
1230 PRINT
1240 PRINT"  filename.DAT  ... contains geometric, mass, and input data."
1250 PRINT"  filename.PLT  ... a copy of the RESULTS file from a previous"
1260 PRINT"                    run.  Used by graphics postprocessors."
1270 PRINT"  filename.XLD  ... data file with external loads acting on each"
1280 PRINT"                    member for each position of the mechanism."
1290 PRINT : GOSUB 4330
1300 PRINT : PRINT"DATA ENTRY IS A FOUR STEP PROCEDURE:"
1310 PRINT
1320 PRINT"1 - Define fixed points and their location."
1330 PRINT
1340 PRINT"     A 'precision point' is a fixed point drawn as a small circle"
1350 PRINT"     on the display screen without the base structure. "
1360 PRINT"     May be useful for checking synthesis problems."
1370 PRINT
1380 PRINT"2 - Define the sequence of components to be assembled."
1390 PRINT
1400 PRINT"3 - Define the geometric parameters which describe each component."
1410 PRINT
1420 PRINT"4 - Define the inital input motion parameters and the range"
1430 PRINT"    of the input motion."
1440 PRINT
1450 PRINT"   A FILENAME.XLD data file can be created with any ASCII editor."
1460 PRINT"   Don't forget to use a comma between data items on each line."
1470 PRINT
1480 PRINT"    See next page."
1490 PRINT : GOSUB 4330
1500 PRINT
1510 PRINT"     USER-DEFINED EXTERNAL LOADS" : PRINT
1520 PRINT"     The user must define the system of external loads in an *.XLD"
1530 PRINT"     file.  Each line describes a load F and pure couple Torque"
1540 PRINT"     in position J acting on member L at point N in comma-separated"
1550 PRINT"     format:     J, L, N, Fx, Fy, Torque"
1560 PRINT
1570 PRINT"     The Q-array used in DYNAN contains all external loads "
1580 PRINT"     force-torque information." : PRINT
1590 PRINT"     All elements of the Q-array are initialized = 0 at the start."
1600 PRINT"     The *.XLD file contains data for non-zero forces or torques."
1610 PRINT
1620 PRINT"     Joint forces are internal forces and are calculated in DYNAN."
1630 PRINT
1640 GOSUB 4330
1650 PRINT
1660 PRINT"COMPONENTS AVAILABLE FOR KINEMATIC OR DYNAMIC ANALYSIS"
1670 PRINT
1680 PRINT" 1 - Input crank (link rotating about a fixed point)"
1690 PRINT" 2 - Input slider (straight-line motion in an arbitrary direction)"
1700 PRINT" 3 - Input cylinder (pivoted cylinder driving an input crank)"
1710 PRINT" 4 - Point on a rigid body (several points on same body allowed)"
1720 PRINT" 5 - Two-link dyad"
1730 PRINT" 6 - Oscillating slider (turning block)"
1740 PRINT" 7 - Rotating (or fixed) guide with slider"
1750 PRINT" 8 - Two spur gears with connecting arm and driven point on 2nd gear"
1760 PRINT" 9 - Linear spring between any two points"
1770 PRINT"10 - Viscous damper between any two points"
1780 PRINT : GOSUB 4330
1790 PRINT
1800 PRINT"LIMITATIONS" : PRINT
1810 PRINT"1. Kinematic Analysis " : PRINT
1820 PRINT"   The mechanism must be assembled from components which"
1830 PRINT"   can be analyzed sequentially. Kinematically complex mechanisms"
1840 PRINT"   which require the solution of a set of nonlinear equations"
1850 PRINT"   cannot be analyzed by this version of MECHAN."
1860 PRINT
1870 PRINT"2. Dynamic Analysis " : PRINT
1880 PRINT"   The program does not solve for the 'time response' due to"
1890 PRINT"   the application of a set of external loads.  It is limited "
1900 PRINT"   to the so-called 'kineto-static' problem where the"
1910 PRINT"   accelerations are known and the driving force or torque and"
1920 PRINT"   the unknown internal joint forces are calculated."
1930 PRINT
1940 PRINT : GOSUB 4330
1950 PRINT
1960 PRINT"SYMBOLIC NOTATION"
1970 PRINT
1980 PRINT"Before you use MECHAN you must have some familiarity with the"
1990 PRINT"notation used.  Each point (or joint) in the mechanism is "
2000 PRINT"given a 'point number'.  Each member (rigid body) is given a"
2010 PRINT"'member number'.  Before you start YOU MUST HAVE A SKETCH of"
2020 PRINT"of the mechanism to be analyzed with all point numbers shown"
2030 PRINT"and all members numbers circled so as not to be confused with the"
2040 PRINT"point numbers."
2050 PRINT
2060 PRINT"A typical component has three points which must be identified."
2070 PRINT"Points numbered N1 and N2 are points with specified motion."
2080 PRINT
2090 PRINT"The motion is typically 'specified' as the result of the analysis"
2100 PRINT"of a component (group) which occurs earlier in the sequence of"
2110 PRINT"components which determine the geometry of the complete mechanism."
2120 PRINT
2130 PRINT"Point N3 is a point (or joint) whose motion is calculated"
2140 PRINT"by the code associated with the component in subroutines"
2150 PRINT"KINAN or DYNAN."
2160 PRINT : GOSUB 4330
2170 PRINT"Each member (rigid body L) has a reference R-vector, R(L), extending"
2180 PRINT"from point N1 to N2.  Additional points N3 on the member L are des-"
2190 PRINT"cribed by S-vectors which locate points N3 relative to the R-vector."
2200 PRINT"The angle B(N3), measured counterclockwise from R(L), locates the"
2210 PRINT"point N3 at a distance S(N3) from point N1."
2220 PRINT 
2230 PRINT"In dynamics problems the members which are external to the"
2240 PRINT"current component (group) at joints N1  and N2 are described"
2250 PRINT"as EXTERNAL MEMBERS.  This implies that the joint forces are"
2260 PRINT"external to the current component and must be accounted for"
2270 PRINT"in the same manner as the forces described in the *.XLD file"
2280 PRINT"for the current mechanism.  This is all done automatically"
2290 PRINT"by MECHAN once the structure of the mechanism has been described."
2300 PRINT : GOSUB 4330
2310 PRINT"EDITING DATA FILES" : PRINT
2320 PRINT"When running MECHAN the user has the option of checking and"
2330 PRINT"changing fixed point locations, component geometric parameters"
2340 PRINT"and/or input data stored in the current .DAT file."
2350 PRINT
2360 PRINT"Run any of the sample *.DAT files and study the data items"
2370 PRINT"as one means of getting familiar with the notation.  Note"
2380 PRINT"that any parameter you change is saved in the current *.DAT" 
2390 PRINT"file.  This is new for version 94-1 and is more convenient when"
2400 PRINT"using MECHAN as a design tool where you wish to see the effect"
2410 PRINT"of a series of changes in the geometric parameters."
2420 PRINT : PRINT"Work with a copy of the original *.DAT file with a different"
2430 PRINT"filename if it is important to have the original data saved."
2440 PRINT : GOSUB 4330
2450 PRINT " EXAMPLE PROBLEM: Kinematic analysis of a four-bar linkage."
2460 PRINT
2470 PRINT"STEP 1: Specify the location of the two fixed points."
2480 PRINT : PRINT" Points 1 and 4 are arbitrarily defined as fixed points."
2490 PRINT" You will be prompted to enter point number followed by"
2500 PRINT" the X and Y coordinate of each fixed point."
2510 PRINT : PRINT"Try Point 1 at 0,0 and Point 4 at 3,0"
2520 PRINT
2530 PRINT" A 'precision point' is a fixed point which will be displayed"
2540 PRINT" as a double circle without a fixed base symbol.  It is used"
2550 PRINT" when checking the results of a synthesis problem."
2560 PRINT
2570 GOSUB 4330
2580 PRINT"STEP 2: Define the sequence of components to be used."
2590 PRINT
2600 PRINT"Sequence number  Component number  Component name"
2610 PRINT
2620 PRINT"      1                1            Input crank"
2630 PRINT"      2                5            Two-link dyad"
2640 PRINT
2650 GOSUB 4330
2660 PRINT "STEP 3: Define the geometry for each component. "
2670 PRINT
2680 PRINT"     INPUT CRANK GEOMETRY" : PRINT
2690 PRINT"The geometry of the input crank is defined by:"
2700 PRINT
2710 PRINT"N1 - the point number for the input crank fixed pivot = 1"
2720 PRINT"N2 - the point number for the input crank moving pivot= 2"
2730 PRINT" L - the member number for the input crank            = 2"
2740 PRINT" R - the length of the input crank                    = 1 unit"
2750 PRINT
2760 PRINT"Note that the location of point 1 was defined earlier and"
2770 PRINT"the units for length are arbitrary but must be consistent."
2780 PRINT
2790 PRINT"Member number 1 is ALWAYS the fixed reference member or base."
2800 PRINT
2810 GOSUB 4330
2820 PRINT
2830 PRINT "     TWO-LINK DYAD GEOMETRY" : PRINT
2840 PRINT"The geometry of the two-link dyad is defined by:"
2850 PRINT
2860 PRINT"N1 - the point number for the first reference point    = 2
2870 PRINT"     The motion of point 2 will be calculated during"
2880 PRINT"     the kinematic analysis of the input crank."
2890 PRINT"N2 - the point number for the second reference point   = 4"
2900 PRINT"     The motion of point 4 was defined earlier when"
2910 PRINT"     it was declared a fixed point (vel and acc = 0)"
2920 PRINT"N3 - The point number for the common point of interest = 3"
2930 PRINT" M - Mode of assembly (+1 or -1)                       = 1"
2940 PRINT"     Positive mode describes assembly of point N3 at a"
2950 PRINT"     location defined by a positive (counterclockwise)"
2960 PRINT"     rotation of the vector N1-N2 toward N1-N3."
2970 PRINT"L1 - The member number connecting N1 to N3             = 3"
2980 PRINT"L2 - The member number connecting N2 to N3             = 4"
2990 PRINT"R(L1) - The length of member L1                        = 2.828"
3000 PRINT"R(L2) - The length of member L2                        = 2"
3010 PRINT : GOSUB 4330
3020 PRINT
3030 PRINT "     INPUT CRANK MOTION PARAMETERS" : PRINT
3040 PRINT"The input crank motion parameters are defined as:"
3050 PRINT
3060 PRINT"Initial input crank angle in degrees      = 0 (deg)"
3070 PRINT"Initial input crank angular velocity      = 628 (rad/sec)"
3080 PRINT"Input crank angular acceleration          = 0 (rad/sec/sec)"
3090 PRINT"Number of times to increment the input crank angle     = 13"
3100 PRINT"Increment for the input crank angle in degrees         = 30"
3110 PRINT
3120 PRINT"The value of 13 insures a complete revolution."
3130 PRINT
3140 PRINT
3150 GOSUB 4330
3160 PRINT
3170 PRINT"     DATA FILE NAMES" : PRINT
3180 PRINT"The named input data file is saved with a .DAT extension.  "
3190 PRINT
3200 PRINT"For example the data file for kinematic analysis of our"
3210 PRINT"four-bar linkage might be named FRBR or FOURBAR or FOUR, etc."
3220 PRINT
3230 PRINT"The .DAT extension will be added automatically by the program."
3240 PRINT
3250 PRINT"The data file would be saved as FOUR.DAT"
3260 PRINT : GOSUB 4330
3270 PRINT
3280 PRINT"RESULTS GENERATED AND DISPLAYED"
3290 PRINT
3300 PRINT"The program will calculate and display angular position,"
3310 PRINT"velocity, and acceleration for each moving member and the"
3320 PRINT"linear x-y motion components for each point in the mechanism."
3330 PRINT"The normal response is N (NO) to the question DO YOU WANT PAUSES ? "
3340 PRINT"in the display of output.  All of the output"
3350 PRINT"is automatically written to a file named RESULTS.  If you"
3360 PRINT"wish to examine each table of results as it is being"
3370 PRINT"generated answer Y (YES) but be prepared to press RETURN after"
3380 PRINT"each table is displayed."
3390 PRINT
3400 PRINT"Beginning with Version 90-3 you have the option of suppressing"
3410 PRINT"the display of tables of results.  The information continues"
3420 PRINT"to be written to the file RESULTS and can be viewed later using"
3430 PRINT"program SUMMARY.  This option will reduce the calculation time"
3440 PRINT"by almost 50%."
3450 PRINT : GOSUB 4330
3460 PRINT
3470 PRINT"GRAPHICS OUTPUT"
3480 PRINT
3490 PRINT"Program MECHDR is a graphics postprocessor which will read"
3500 PRINT"coordinate information from either the current RESULTS file"
3510 PRINT"or a file with a .PLT extension.  If you wish to save the "
3520 PRINT"current RESULTS file as a .PLT file you must exit to DOS"
3530 PRINT"and use the DOS command  COPY RESULTS FILENAME.PLT."
3540 PRINT
3550 PRINT"MECHDR will display the mechanism in either the first or the"
3560 PRINT"sequence of positions.  You can single-step through the sequence"
3570 PRINT"or display all positions overlayed in a repeating pattern."
3580 PRINT
3590 PRINT"MECHPL will create x-y plots of any variable versus any "
3600 PRINT"second variable.  This allows the user to make plots with"
3610 PRINT"axis labels such as:"
3620 PRINT
3630 PRINT"   ANG ACC OF MEMBER 3 vs ANG POS OF MEMBER 2 , or"
3640 PRINT"  X-POSITION OF POINT 5 vs Y-POSITION OF POINT 5 , etc."
3650 PRINT
3660 PRINT"Use the PRTSC key to get hard copy of tables or graphs."
3670 PRINT : GOSUB 4330
3680 PRINT"DATA FOR DYNAMICS PROBLEMS" : PRINT
3690 PRINT"Data entry for a DYNAMICS problem is essentially the same"
3700 PRINT"as for a KINEMATICS problem with added specification of the"
3710 PRINT"mass and centroidal moment of inertia for each moving member."
3720 PRINT
3730 PRINT"Beginning with version 1988-4 (November 1988) the SPUR GEARS"
3740 PRINT"analysis has been improved so that either the input gear or"
3750 PRINT"the arm can be moving members. This allows the analysis of"
3760 PRINT"both gear trains and geared linkages.  See, for example,"
3770 PRINT"GEAR4BAR, GEAR5BAR, PLANET, or CARDAN."
3780 PRINT 
3790 PRINT"Examine the first line of any .PLT or RESULTS file and you"
3800 PRINT"will note that the RESULTS file has data which indicates whether"
3810 PRINT"the file was generated by either kinematic or dynamic"
3820 PRINT"analysis. The input data is stored in a file with the .DAT"
3830 PRINT"extension.  The .PLT and .DAT files should have the same prefix."
3840 PRINT : GOSUB 4330
3850 PRINT"FREQUENT QUESTIONS and ANSWERS"
3860 PRINT
3870 PRINT"One frequently asked question is 'How do I analyze a simple"
3880 PRINT"Slider-Crank mechanism?'. The most common error is an attempt"
3890 PRINT"to use the oscillating slider in the analysis.  The Slider-Crank"
3900 PRINT"mechanism is an INPUT CRANK driving a ROTATING GUIDE.  The"
3910 PRINT"guide just happens to have zero angular velocity and acceleration."
3920 PRINT"This is easily arranged by giving the guide a member number= 1."
3930 PRINT"Member number 1 is ALWAYS the fixed member."
3940 PRINT
3950 PRINT"The reference point on the guide must have been previously"
3960 PRINT"defined as a fixed point.  This point must not fall on the"
3970 PRINT"same position occupied by the input crank fixed pivot."
3980 PRINT
3990 GOSUB 4330
4000 PRINT"Another question is 'How can I analyze an oscillating slider"
4010 PRINT"where the pivot point for the slider is offset from the centerline"
4020 PRINT"of the guide path?'  The answer is 'Use an equivalent mechanism" 
4030 PRINT"with the guide path passing through the pivot point.'  The data"
4040 PRINT"file SU3-24.DAT will solve problem 3-24 in Shigley and Uicker"
4050 PRINT"using this approach.  Note that the point B becomes point 5 in"
4060 PRINT"in the MECHAN solution."
4070 PRINT : GOSUB 4330
4080 PRINT
4090 PRINT"I hope you find the program useful.  If you find a bug"
4100 PRINT"let me know and I will check it out and correct the code if"
4110 PRINT"necessary.  Please do not make corrections to the code."
4120 PRINT"These programs have grown through three separate operating"
4130 PRINT"systems and are difficult to decipher.  Some day I will convert"
4140 PRINT"to a more readable version.  In the meantime I hope"
4150 PRINT"you find the programs useful."
4160 PRINT
4170 PRINT"You may make as many copies of the distribution disk as you"
4180 PRINT"wish and distribute them to students or colleagues."
4190 PRINT
4200 PRINT"Students need not register until after graduation."
4210 PRINT
4220 PRINT"Charles W. Radcliffe"
4230 PRINT"Professor of Mechanical Engineering (Emeritus)"
4240 PRINT"University of California at Berkeley"
4250 PRINT"571 Silverado Drive"
4260 PRINT"Lafayette, CA  94549"
4270 PRINT
4280 PRINT"Telephone: (510) 283-1528 ... Leave message if no answer"
4290 PRINT"      FAX: (510) 283-1528 ... Call first to allow setup"
4300 PRINT "Press SPACE-BAR to restart MECHAN
4310 Q$=INKEY$ : IF LEN(Q$)=0 THEN 4310
4320 RUN"MECHAN"
4330 PRINT"Press <ANY-KEY> to continue ... <ESC> to quit help"
4340 Q$=INKEY$ : IF LEN(Q$)=0 THEN 4340
4350 CLS
4360 IF ASC(Q$)=27 THEN CLS : RUN "mechan"
4370 RETURN
