#pragma strings( readonly )

#define INCL_NOCOMMON
#define INCL_DOSPROCESS
#define INCL_DOSSEMAPHORES
#define INCL_DOSERRORS
#define INCL_WINWINDOWMGR
#define INCL_WINMESSAGEMGR
#define INCL_WINFRAMEMGR
#define INCL_WINDIALOGS
#define INCL_WININPUT
#define INCL_WINSWITCHLIST
#define INCL_WINPROGRAMLIST
#define INCL_GPICONTROL
#define INCL_GPIPRIMITIVES
#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "fitplot.h"

/*+--------------------------------------------------------------------------+*/
/*| Internal function prototypes.                                            |*/
/*+--------------------------------------------------------------------------+*/

static MRESULT EXPENTRY ClientWindowProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
void DrawingThread();
static void DisplayMessage( HAB, ULONG );
static void plot(HPS hps, int ndata, int num_v, int redraw);
void line(long x1, long y1, long x2, long y2);
void lineto(long x2, long y2);
void draw_axes();
int get_data(char *command, int autorange_flag);
void moveto(long x1, long y1);
void marker(long x2, long y2);
int range(char *command);
void sy(char *command);
void cmdfile(char *command);
void do_command(char *command);

/*+--------------------------------------------------------------------------+*/
/*| Static global variables and local constants.                             |*/
/*+--------------------------------------------------------------------------+*/

#define WINDOW_CLASS   "My_Window"          /* window class name              */
#define COLOUR_TBL_LEN 16                   /* number of colour table entries */
#define MSG_BOX_ID     256                  /* error message box id           */
#define STRING_LENGTH  128                  /* size of buffer used for strings*/
#define STACK_SIZE     8192UL               /* stack size for second thread   */
#define NUM_POINTS 8192
#define NUM_Y 2

static HWND   hwndClient = NULLHANDLE;      /* client window handle           */
static POINTL ptl1;                         /* line start point               */
static POINTL ptl2;                         /* line end point                 */
static HMQ    hmqThread2 = NULLHANDLE;      /* message queue handle for thread*/
static TID    tidDrawing = 0UL;             /* drawing thread identifier      */
static LONG   lFcolour[10] = {CLR_PINK, CLR_BLUE};          /* foreground (line) colour       */
static LONG   lBcolour = CLR_WHITE;         /* background colour              */
static LONG   cxClient, cyClient;           /* client window X and Y size     */
static LONG   fcolourcounter = 1L;          /* wait time to change line colour*/
static char   szAppName[ MAXNAMEL + 1 ];    /* application name string        */
HPS   hps = NULLHANDLE;                  /* presentation Space handle      */
HMQ   hmq = NULLHANDLE;                  /* message queue handle           */
HWND  hwndFrame = NULLHANDLE;            /* frame window handle            */
double u[NUM_POINTS], v[NUM_Y][NUM_POINTS], umin, umax, vmin, vmax;
int ndata, num_v;
int ymin, ymax, xmin, xmax;
FILE *destream;
int line_type[10];
int marker_type[10];
int sy_line_flag[10] = {1,1,1,1,1,1,1,1,1,1};
int autorange = 1;


/*+--------------------------------------------------------------------------+*/
/*| Main control procedure.                                                  |*/
/*+--------------------------------------------------------------------------+*/

int main(int argc, char *argv[]){
HAB   hab = NULLHANDLE;                  /* PM anchor block handle         */
ULONG flCreate = 0UL;                    /* window creation control flags  */
QMSG  qmsg;                              /* message from message queue     */
int   rc = 1;
FILE *stream;
char inbuf[82];
SWP swp;
long llx, lly, wx, wy;
int save_flag = 1;

DosSetPriority( PRTYS_PROCESS, PRTYC_TIMECRITICAL, 0L, 0UL );
if(argc > 1) save_flag = 0;
do{
	/* Initialize PM and create a message queue of default size.            */

	if ( ( hab = WinInitialize( 0UL ) ) == NULLHANDLE )
		break;

	if ( ( hmq = WinCreateMsgQueue( hab, 0UL ) ) == NULLHANDLE )
		break;

	/* Register client window class.                                        */

	if ( !WinRegisterClass( hab,          /* PM anchor block handle         */
						WINDOW_CLASS, /* window class name              */
						ClientWindowProc, /* address of window procedure    */
						CS_SIZEREDRAW,/* size changes cause redrawing   */
						0UL ) )       /* window data                    */
		{
		DisplayMessage( hab, IDS_NOREGISTER );
		break;
		}

	flCreate = FCF_TITLEBAR | FCF_TASKLIST | FCF_SYSMENU | FCF_SIZEBORDER | FCF_MINMAX;

	hwndFrame =
		WinCreateStdWindow( HWND_DESKTOP,  /* make desktop window the parent */
                             WS_VISIBLE,    /* frame window class style       */
                             &flCreate,     /* frame control flags            */
                             WINDOW_CLASS,  /* client window class name       */
                             "",            /* title bar text                 */
                             CS_SIZEREDRAW, /* client window class style      */
                             0UL,           /* resource file handle - in EXE  */
                             ID_WINDOW,     /* resources identifier           */
                             &hwndClient ); /* client window handle           */
	if ( hwndFrame == NULLHANDLE ){
		DisplayMessage( hab, IDS_NOSTDWINDOWS );
		break;
	}

	if( ((stream = fopen("fitplot.ini","r")) != NULL) &&
		 (fgets(inbuf, 80,stream) != NULL) &&
		 (sscanf(inbuf,"%ld %ld %ld %ld", &llx, &lly, &wx, &wy) >3) )
		fclose(stream);
	else{
		WinGetMaxPosition(hwndFrame, (PSWP)&swp);
		llx = 0;
		lly = swp.cy/2;
		wx = swp.cx/3;
		wy = swp.cy/2 - 10;
	}

	WinSetWindowPos(hwndFrame, 0L, llx, lly, wx, wy, SWP_MOVE | SWP_SIZE);

	/* Get a presentation space.                                               */
	hps = WinGetPS( hwndClient );

      /* Create the thread that will draw the lines.                          */
      /* NOTE: _beginthread MUST be used if the thread contains CRT calls     */


      if ( _beginthread(DrawingThread, NULL, 8192, NULL) == -1 )
      {
         DisplayMessage( hab, IDS_NOTHREAD );
         break;
      }
/*
      if ( DosCreateThread( &tidDrawing, DrawingThread, 0UL, 0UL, STACK_SIZE ) )
*/
	/* While the WM_QUIT message is not received, dispatch the message.     */
	/* When the WM_QUIT message is received, WinGetMsg will return FALSE.   */
	while( WinGetMsg( hab, &qmsg, 0UL, 0UL, 0UL ) )
		WinDispatchMsg( hab,               /* PM anchor block handle         */
                        &qmsg );           /* pointer to message             */
	rc = 0;

}  while ( FALSE );

if(save_flag){
    if( (stream = fopen("fitplot.ini","w")) != NULL){
    	WinQueryWindowPos(hwndFrame, (PSWP)&swp);
    	fprintf(stream,"%ld %ld %ld %ld",swp.x, swp.y, swp.cx, swp.cy);
    	fclose(stream);
    }
}
   /* Destroy the standard windows if they were created.                      */
WinReleasePS( hps );
if ( hwndFrame != NULLHANDLE )
	WinDestroyWindow( hwndFrame );        /* frame window handle            */

/* Destroy the message queue and release the anchor block.                 */

if ( hmq != NULLHANDLE )
	WinDestroyMsgQueue( hmq );

if ( hab != NULLHANDLE )
	WinTerminate( hab );

return rc;
}

/*+--------------------------------------------------------------------------+*/
/*| ClientWindowProc - Client window procedure.                              |*/
/*+--------------------------------------------------------------------------+*/

static MRESULT EXPENTRY ClientWindowProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ){

HPS   hps1 = NULLHANDLE;                  /* presentation space handle      */

/* Process the message.                                                    */

switch( msg ){

	case WM_CREATE:
		/* The client window has been created but is not visible yet.        */
		/* Initialize the window here.                                       */
	 break;

	case WM_CLOSE:
		/* Tell the main procedure to terminate the message loop.            */
		WinPostMsg( hwnd, WM_QUIT, NULL, NULL );
	break;

	case WM_PAINT:
		hps1 = WinBeginPaint( hwnd, NULLHANDLE, NULL );
		plot(hps, ndata, num_v,1);
		WinEndPaint( hps1 );
	break;

/*
	case WM_COMMAND:
		switch ( SHORT1FROMMP( mp1 ) ){
			case IDM_EXITPROG:
				WinPostMsg( hwnd, WM_CLOSE, NULL, NULL );
			break;
		}
*/
	case WM_SIZE:
		/* Window is being resized so get new client window size and         */
		/* recompute the end points for the lines.                           */
			cxClient = SHORT1FROMMP( mp2 );    /* Get new client window size     */
			cyClient = SHORT2FROMMP( mp2 );
			xmin = 1*cxClient/20;
			xmax = 19*cxClient/20;
			ymin = cyClient/20;
			ymax = 19*cyClient;
	break;

      case WM_DESTROY:
         /* The client window is being destroyed so tell the second thread to */
         /* stop running.                                                     */

         WinPostQueueMsg( hmqThread2, WM_USER_END_THREAD, 0UL, 0UL );

         /* Wait for the drawing thread to terminate before returning.        */

         DosWaitThread( &tidDrawing, DCWW_WAIT );

         break;

	default:
		/* For all other messages, let the default window procedure          */
		/* process them.                                                     */
	return ( WinDefWindowProc( hwnd, msg, mp1, mp2 ) );
	}
return NULL;
}

/*+--------------------------------------------------------------------------+*/
/*| DisplayMessage - display an error message in a message box.              |*/
/*+--------------------------------------------------------------------------+*/

static void DisplayMessage( HAB hab, ULONG ulStringNum )
{
   char szTemp[ STRING_LENGTH ];

   WinLoadString( hab, 0UL, ulStringNum, STRING_LENGTH, szTemp );

   WinAlarm( HWND_DESKTOP,                  /* desktop window handle          */
             WA_ERROR );                    /* type of alarm                  */

   WinMessageBox( HWND_DESKTOP,             /* parent window handle           */
                  HWND_DESKTOP,             /* owner window handle            */
                  szTemp,                   /* pointer to message text        */
                  szAppName,                /* pointer to title text          */
                  MSG_BOX_ID,               /* message box identifier         */
                  MB_OK | MB_ERROR |        /* message box style              */
                  MB_SYSTEMMODAL );

   return;
}

static void plot(HPS hps, int ndata, int num_v, int redraw){

RECTL rclClient;                         /* rectangle for client window    */
int i, j, k = 0;
long x1, y1;
double u_factor, v_factor;

if(redraw){
	/* draw the background */
	WinQueryWindowRect( hwndClient, &rclClient );
	WinFillRect( hps, &rclClient, lBcolour );
	if(ndata == 0) return;
	xmin = 1*cxClient/20;
	xmax = 19*cxClient/20;
	ymin = cyClient/20;
	ymax = 19*cyClient;
	draw_axes();
}

u_factor = (double)(xmax-xmin)/(umax - umin);
v_factor = (double)(ymax-ymin)/(vmax - vmin);

for(j=0;j<num_v;j++){

	GpiSetColor( hps, lFcolour[j] );
	x1 = xmin + (long int)( (u[0] - umin)*u_factor );
	y1 = ymin + (long int)( (v[j][0] - vmin)*v_factor );

	if(sy_line_flag[j] == 1)
		GpiSetLineType(hps, line_type[j]);
	else
		GpiSetMarker(hps, marker_type[j]);

	for(i = 0; i < ndata; i++){
		if(u[i] <= umax && u[i] >= umin && v[j][i] >= vmin && v[j][i] <= vmax){
			x1 = xmin + (long int)( (u[i] - umin)*u_factor );
			y1 = ymin + (long int)( (v[j][i] - vmin)*v_factor );
			if(sy_line_flag[j] == 1){
				if(k > 0) lineto(x1,y1);
				else{ moveto(x1, y1); 	k++; }
			}
			else marker(x1, y1);
		}
	}
}

}

void line(long x1, long y1, long x2, long y2){

ptl1.x = x1;
ptl1.y = y1;
ptl2.x = x2;
ptl2.y = y2;

GpiMove( hps, &ptl1 );                /* Move to start point         */
GpiLine( hps, &ptl2 );                /* Draw new line               */
}

void moveto(long x1, long y1){

ptl1.x = x1;
ptl1.y = y1;

GpiMove( hps, &ptl1 );                /* Move to start point         */
}

void lineto(long x2, long y2){

ptl2.x = x2;
ptl2.y = y2;

GpiLine( hps, &ptl2 );                /* Draw new line               */
}

void marker(long x2, long y2){

ptl2.x = x2;
ptl2.y = y2;

GpiMarker( hps, &ptl2 );                
}


void draw_axes(){
long i, lxmin, lxmax, lymin, lymax, hits;
char cxmin[20], cxmax[20], cymin[20], cymax[20];

GpiSetLineType(hps, LINETYPE_SOLID);
GpiSetColor( hps, CLR_BLACK );

sprintf(cxmin,"%g", umin);
lxmin = strlen(cxmin);
sprintf(cxmax,"%g", umax);
lxmax = strlen(cxmax);
sprintf(cymin,"%g", vmin);
lymin = strlen(cymin);
sprintf(cymax,"%g", vmax);
lymax = strlen(cymax);

if(xmin < 10*lymin) xmin = 10 * lymin + 10;
if(xmin < 10*lymax) xmin = 10 * lymax + 10;
if(xmax > (cxClient - 5*lxmax) ) xmax = cxClient - 5 * lxmax - 10;
if(ymin < 35) ymin = 35;
if(ymax > (cyClient - 20) ) ymax = cyClient - 20;

moveto(xmin - 5*lxmin, ymin - 25);
hits = GpiCharString(hps, lxmin, cxmin);

moveto(xmax - 5*lxmax, ymin - 25);
hits = GpiCharString(hps, lxmax, cxmax);
 
moveto(xmin - 10*lymin, ymin - 5);
hits = GpiCharString(hps, lymin, cymin);

moveto(xmin - 10*lymax, ymax - 5);
hits = GpiCharString(hps, lymax, cymax);

line(xmin,ymin,xmin,ymax);
line(xmin,ymin,xmax,ymin);
line(xmin,ymax,xmax,ymax);
line(xmax,ymin,xmax,ymax);

for(i = 1; i < 10; i++)	{
	line(xmin, ymin+i*(ymax-ymin)/10, xmin+10, ymin+i*(ymax-ymin)/10);
	line(xmax-10, ymin+i*(ymax-ymin)/10, xmax, ymin+i*(ymax-ymin)/10);
	line(xmin+i*(xmax-xmin)/10, ymin, xmin+i*(xmax-xmin)/10, ymin+10);
	line(xmin+i*(xmax-xmin)/10, ymax-10, xmin+i*(xmax-xmin)/10, ymax);
}

}

static void DrawingThread(){
/* Declare local variables.                                                */

HAB   habThread2 = NULLHANDLE;           /* anchor block handle for thread */
QMSG  qmsgThread2;                       /* message queue structure        */
char command[100];

/* Initialize thread to PM.                                                */

habThread2 = WinInitialize( 0UL );
hmqThread2 = WinCreateMsgQueue( habThread2, 0UL );

while ( qmsgThread2.msg != WM_USER_END_THREAD ){
	gets(command);
	do_command(command);
	if( strncmp(command,"quit",4) == 0 ) break;
	WinPeekMsg( habThread2, &qmsgThread2, NULLHANDLE, 0UL, 0UL, PM_REMOVE );
}

WinPostMsg( hwndFrame, WM_QUIT, NULL, NULL );
/* Clean up and terminate drawing thread.                                  */
WinDestroyMsgQueue( hmqThread2 );
WinTerminate( habThread2 );
_endthread();
}

int get_data(char *command, int autorange_flag){
char str[20][30];
char inbuf[512];
char filename[100];
FILE *stream;
int j, i, num_points = 0, jmax;
int lnum_v;

i = sscanf(command,"%s %s %s", str[0], filename, str[1]);
if( i > 2)lnum_v = atoi(str[1]);
else lnum_v = 1;

stream = fopen(filename,"r");

if(stream == NULL) return 0;

num_points = 0;

while( (fgets(inbuf,512,stream) != NULL) && num_points < NUM_POINTS ){
	jmax=sscanf(inbuf,"%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s",
			str[0],str[1],str[2],str[3],str[4],str[5],str[6],str[7],str[8],str[9],
			str[10],str[11],str[12],str[13],str[14],str[15],str[16],str[17],str[18],str[19]);
	if(jmax > 1) u[num_points] = atof(str[0]);
	for( j = 1; (j < jmax) && (j <= lnum_v); j++)
		v[j-1][num_points] = atof(str[j]);
 	if(jmax > lnum_v) num_points++;
}
fclose(stream);

if( autorange_flag == 1 ){
	umax = vmax = -1e200;
	umin = vmin = 1e200;
	for( i = 0; i < num_points; i++){
		if(umin >  u[i]) umin = u[i];
		if(umax < u[i]) umax = u[i];
		for( j = 0; j < lnum_v; j++){
			if(vmax < v[j][i]) vmax = v[j][i];
			if(vmin >  v[j][i]) vmin = v[j][i];
		}
	}
}

num_v = lnum_v;
return num_points;
}

int range(char *command){

char str[4][30];
int autorange, i;

i = sscanf(command,"%*s %s %s %s %s",str[0], str[1], str[2], str[3]);

if(i == 1) return( atoi(str[0]) );
else if (i == 4){
	umin = atof(str[0]);
	umax = atof(str[1]);
	vmin = atof(str[2]);
	vmax = atof(str[3]);
	return 0;
}
else return 1;
}

void sy(char *command){

char sy[10][10];
int i;
int num;

num = sscanf(command,"%*s %s %s %s %s %s %s %s %s %s %s", 
				sy[0], sy[1], sy[2], sy[3], sy[4], sy[5],
				sy[6], sy[7], sy[8], sy[9]);

for( i = 0; i < num; i++){
	if(strncmp(sy[i],"0", 1) == 0){
		sy_line_flag[i] = 0;
		marker_type[i] = MARKSYM_SMALLCIRCLE;
	}
	else if(strncmp(sy[i],"L", 1) == 0){
		sy_line_flag[i] = 1;
		line_type[i] = LINETYPE_SOLID;
	}
	else if(strncmp(sy[i],"1", 1) == 0){
		sy_line_flag[i] = 0;
		marker_type[i] = MARKSYM_SQUARE;
	}
	else if(strncmp(sy[i],"2", 1) == 0){
		sy_line_flag[i] = 0;
		marker_type[i] = MARKSYM_SIXPOINTSTAR;
	}
	else if(strncmp(sy[i],"3", 1) == 0){
		sy_line_flag[i] = 0;
		marker_type[i] = MARKSYM_EIGHTPOINTSTAR;
	}
	else if(strncmp(sy[i],"4", 1) == 0){
		sy_line_flag[i] = 0;
		marker_type[i] = MARKSYM_CROSS;
	}
	else if(strncmp(sy[i],"5", 1) == 0){
		sy_line_flag[i] = 0;
		marker_type[i] = MARKSYM_SOLIDSQUARE;
	}
	else if(strncmp(sy[i],"6", 1) == 0){
		sy_line_flag[i] = 0;
		marker_type[i] = MARKSYM_PLUS;
	}
	else if(strncmp(sy[i],"7", 1) == 0){
		sy_line_flag[i] = 0;
		marker_type[i] = MARKSYM_SOLIDDIAMOND;
	}
	else if(strncmp(sy[i],"8", 1) == 0){
		sy_line_flag[i] = 0;
		marker_type[i] = MARKSYM_DIAMOND;
	}
	else if(strncmp(sy[i],"9", 1) == 0){
		sy_line_flag[i] = 0;
		marker_type[i] = MARKSYM_DOT;
	}
	else if(strncmp(sy[i],"A", 1) == 0){
		sy_line_flag[i] = 1;
		line_type[i] = LINETYPE_DOT;
	}
	else if(strncmp(sy[i],"B", 1) == 0){
		sy_line_flag[i] = 1;
		line_type[i] = LINETYPE_SHORTDASH;
	}
	else if(strncmp(sy[i],"C", 1) == 0){
		sy_line_flag[i] = 1;
		line_type[i] = LINETYPE_LONGDASH;
	}
	else if(strncmp(sy[i],"D", 1) == 0){
		sy_line_flag[i] = 1;
		line_type[i] = LINETYPE_DASHDOT;
	}
	else if(strncmp(sy[i],"E", 1) == 0){
		sy_line_flag[i] = 1;
		line_type[i] = LINETYPE_DOUBLEDOT;
	}
	else if(strncmp(sy[i],"F", 1) == 0){
		sy_line_flag[i] = 1;
		line_type[i] = LINETYPE_DASHDOUBLEDOT;
	}
}

}

void do_command(char *command){

int iopt1;

	if( strncmp(command,"axes",2) == 0 )
		draw_axes(xmin, xmax, ymin, ymax);
	else if( strncmp(command,"gd",2) == 0 )
		ndata = get_data(command, autorange);
	else if( strncmp(command,"pl",2) == 0 )
		plot(hps, ndata, num_v, 1);
	else if( strncmp(command,"ra",2) == 0 )
		autorange = range(command);
	else if( strncmp(command,"z",1) == 0 )
		plot(hps, ndata, num_v, 0);
	else if( strncmp(command,"sy",2) == 0 )
		sy(command);
	else if( strncmp(command,"do",2) == 0 )
		cmdfile(command);
	else if(strncmp(command,"pause",2) == 0)
		if(sscanf(command,"%*s %d",&iopt1) > 0 && ( iopt1 > 0)){
			DosSleep(1000L*iopt1);
		}

}

void cmdfile(char *cmd){

char command[100];
char filename[100];
FILE *instream;

sscanf(cmd,"%*s %s", filename);

if( (instream = fopen(filename,"r")) == NULL) return;

while( (fgets(command, 80, instream)) != NULL)
	do_command(command);

fclose(instream);
}


