/* Shape of Distribution: 1 <= shape <= 4 */

switch( shape ) {

  case 1:   // Uniform on [-5,+5].

      svalue = 10.0 * (double)uniran(&idum) - 5.0;
      break;

  case 2:  // Right Triangle on [-5,+5] with Mode at +5.
  
      svalue = 10.0 * sqrt( (double)uniran(&idum) ) - 5.0;
      break;
  
  case 3:  // Right Triangles on [-5,0] & [0,+5] ...with Modes at -5 & +5.
  
      svalue = (double)uniran(&idum) - 0.5;
      if( svalue >=  0.0 )
          svalue  =  5.0 * sqrt( 2.0 * svalue );
      else {
          svalue *= -1.0;
          svalue  = -5.0 * sqrt( 2.0 * svalue );
          }
      break;
  
  case 4:  // Normal with Standard Deviation = 4.
  
      svalue = 4.0 * box_mull(&idum);
      break;
  }
  
/*
 * Brute Force Box-Muller Transformation.
 */
double box_mull( idum )
int *idum; {

    static int iset=0;
    static double next;
    double rad,ang;
    
    if( iset == 0 ) {
        rad = sqrt( -2.0 * log( (double)uniran( idum ) ) );
        ang = 2.0 * 3.1415926536 * (double)uniran( idum );
        next = rad * cos( ang );
        iset = 1;
        return( rad * sin( ang ) );
        }
    else {
        iset=0;
        return next;
        }
    }
    
/*
 * Portable 32-bit random number generator proposed by Pierre
 * L'Ecuyer(1988), Communications of the ACM 31, 742-749 and 774.
 * Static integer seed values s1 and s2 must not only be >= 1
 * but also s1 <= 2,147,483,562 and s2 <= 2,147,483,398, respectively.
 */

float uniran( int *idum ) {

   static long s1, s2, ldum;
   static int iff=0;
   
   if( *idum < 0 || iff == 0 ) {
       ldum = (long)abs(*idum);
       if( ldum < 1L )
           ldum = 1L;
       s1 = s2 = ldum;
       *idum = iff = 1;
       }
   
   ldum = s1 / 53668L;
   s1 =  40014L * ( s1 - ldum * 53668L ) - ldum * 12211L;
   if( s1 < 0 )
       s1 += 2147483563L;
   
   ldum = s2 / 52774L;
   s2 =  40692L * ( s2 - ldum * 52774L ) - ldum * 3791L;
   if( s2 < 0 )
       s2 += 2147483399L;
   
   ldum = s1 - s2;
   if( ldum < 1L )
       ldum += 2147483562L;
   
   return (float)( (double)ldum * 4.656613e-10 );
   }
   
   
   
   
   
   
   
   
   
   
   
