                                  SwimBase
      
      
      
                             General Description
      
         SwimBase is designed to simplify and automate the records and
      reports required for a Swim Team. SwimBase will keep the swimmer
      rosters and results for each meet. Roster reports, mailing labels,
      telephone lists, events results, swim team ladder and time in water
      are some of the reports that can be generated by SwimBase. The data
      entered can be reviewed, modified or deleted at any time. All
      reports can be directed to the computer screen for review, printed,
      sent to a disk file for storage, transfer or modification with a
      word processing program. 
      
         SwimBase is an easy to use, menu driven program. Most menus and
      prompts are self-explanatory with little or no use of the manual
      required. All data is entered into forms with context sensitive
      help available at any time for each field. These help prompts will
      give an explanation of the required data and, where appropriate,
      the allowable input range. Any out of range data input will result
      in error requestors explaining the problem and the opportunity to
      correct the offending field.
      
         SwimBase can be configured by the user to support teams using
      USS, NF or USMS rules. The user can set up any combination of
      events, event groups, names, swimmer ages, groups and points.
      SwimBase will record the results of the meet and allow numerous
      reports to be generated on any set of data entered.
      
         This new version of SwimBase now includes meet management
      functions which will allow you to use SwimBase to simplify the
      management for your meets. It can help you prepare for the meet by
      helping select the swimmers for each event, preparing meet entry
      cards and printing a meet entry sheet. It can help you run your
      meet dual by allowing the input of the other teams' swimmers and
      the keeping track of finish times and scoring the individual events
      and the meet as it progresses. After the meet is complete you can
      print ribbons for either or both teams. Optionally, the results of
      the meet can automatically update the SwimBase data files. 
      
         The design of SwimBase will allow the results of multiple
      seasons to be stored and the team roster from previous years to be
      moved forward each year with automatic updates to the swimmers' age
      and group. The data from previous years can be reviewed at any time
      for comparison to the current years results. 
      
         The standardized reports from SwimBase will allow simplified
      comparisons of the results between different teams within the same
      division or league or even teams in different leagues. 
      
         The reports from SwimBase can be set to include just a single
      meet, all meets of a particular type or all meets. The results can
      be sorted by sex, age or name. The results for swimmers can be
      generated for individual swimmers, for all swimmers or selected by
      sex. 
                                  Page 2
         Results are kept of all event entries so not only are the
      results of swimmers that finish in the top, point scoring, spots
      available but all other finishes along with all disqualifications,
      no shows, exhibitions and substitutes. It is possible at any time
      to summarize all the results of all the events any swimmer was
      scheduled for at any time.
      
                             Manual Organization
      
         This manual is organized in the order that the menus, screens
      and requestors are most likely to be displayed by the first time
      user. Each Menu, Form or Requestor is displayed and then followed
      with a brief explanation of each of the elements within it. If you
      are trying to locate a particular menu or requestor then use the
      index with the menu or requestor heading as input.
      
      
      
      
      
                       System Requirements
      
      
         The recommended hardware and system requirements
      for SwimBase are:
      
             IBM PC/XT/AT or compatible with at least 512K available RAM
              Memory.
      
             Any monitor capable of a 80 column text display.
      
             Any floppy drive with a hard disk drive. It is possible to
              run on a system with 2 720K or larger floppy drives but
              this is not a recommended configuration.
      
             MS/PC DOS 3.0 or later, IBM OS/2 2.0/1 or MS Windows 3.0/1.
      
             80 or greater column text printer (optional for reports)
      
                             Program Limitations
      
         The program limitations for SwimBase are:
      
             Maximum Seasons on a disk: 50
      
             Maximum Meets in a season: 50
      
             Maximum Swimmers in a Season: 511
      
             Maximum Entries in an Event: 99
      
             Longest time for an event: 59:59:99 (mins:secs:huns)
      
             Maximum Events in a meet: 256
      
      
                                  Page 3
      Installing SwimBase
      
      
      1. Check the disk where you will be installing SwimBase to be sure
      that there is at least 720K free memory. This can be checked by
      using the DOS CHKDSK command ('CHKDSK C:' as an example to check
      the C: drive).
      
      2. In order to start the installation you will need the SwimBase
      distribution disk in a floppy drive or the SwimBase distribution
      files 'UNZIPPED' into a directory. See the files SETUP.DOC and
      PACKING.LST for more information about what files to expect and
      what purpose each file serves. Start the INSTALL program by
      entering the full path and install program name:
      
           (If in the A: floppy drive)             A:\INSTALL
      
           (If in the C:\DOWNLOAD directory)       C:\DOWNLOAD\INSTALL
      
      3. You will be prompted for an INSTALL FROM directory, this should
      in all normal circumstances be the same location as the INSTALL
      program and default to the proper location. If the SwimBase files
      are in a location different from the INSTALL program you should
      enter that directory now.
      
      4. You will be prompted for an INSTALL TO directory. You can select
      the default by pressing enter or you can edit the directory as
      required. Some suggestions for legitimate directories:
      
                          C:\SWIMDATA
                          C:\PROGRAMS\SWIMDATA
                          D:\SWIMDATA
                          C:\SWIM1993
                          B:\SWIMDATA
      
      If the directory does not exist it will be created. Note that the
      INSTALL program will not create multiple levels of the directory.
      For the second example to work the directory C:\PROGRAMS must
      already exist.
      
      If you are upgrading an existing version of SwimBase that is at
      least version 1.60 then you should follow steps 1 through 5 for
      upgrading SwimBase versions 1.60 or later (see Upgrading SwimBase)
      and then specify the same directory as the SwimBase version 1.6x
      directory. 
      
      If you are upgrading a SwimBase version 1.40 or earlier you will
      need to specify a new directory. SwimBase 2.00 cannot read the
      version 1.40 or earlier files.
      
      5. You will now press ENTER to start the installation of the
      SwimBase program files. You can skip this step by entering 'N'.
      
      6. You will now press ENTER to start the installation of the
      SwimBase Manual files. You can skip this step by entering 'N'.
      
      7. You will now press ENTER to start the installation of the
      SwimBase Document files. You can skip this step by entering 'N'.
                                  Page 4

      8. You will now press ENTER to start the installation of the
      SwimBase README files. You can skip this step by entering 'N'.
      
      9. You will now press ENTER to start the installation of the
      SwimBase File Viewer files. You can skip this step by entering 'N'.
      
           The SwimBase installation is now complete. You can start the
      program by typing (assuming that you installed to C:\SWIMDATA):
      
                     C:
                     CD C:\SWIMDATA
                     SWIM
      
           To view the program manual enter:
      
                          FVIEW SWIMBASE.MAN   for the manual.
      
                          FVIEW SWIMBASE.TOC   for the Table of Contents.
      
                          FVIEW SWIMBASE.IDX   for the index.
      
           To view the readme file enter:
      
                          FVIEW READ.1ST
      
           To print the program manual, index or table of contents enter:
      
                          TYPE SWIMBASE.MAN >PRN:
                                    or
                          TYPE SWIMBASE.IDX >PRN:
                                    or
                          TYPE SWIMBASE.TOC >PRN:
      
           To print the program ordering information and ordering form:
      
                          TYPE REGISTER.DOC >PRN:
      
      
                             Upgrading SwimBase
         
                     From SwimBase version 1.60 or later
      
         If you are updating from SwimBase version 1.60 then follow
      these steps if you want your current Season, Meet and Swimmer files
      to be updates to version 2.00. Note that once this is complete
      these files will not be accessable with the version 1.60 program.
      
      1. Make a backup copy of all your existing SwimBase files.
      
      2. Start the old version 1.60 program by typing SWIM.
      
      3. Select 'Set or Change Defaults' from the Main Menu and be sure
      that 'SKIP DB Audit' is set to 'N'.
      
      4. Select ALT/A or the 'About SwimBase" menu selection and be sure
      the Data Disk Free Memory has at least 100,000 bytes. If it is less
      than this than you cannot update your old files. You can Import the
                                  Page 5
      swimmer information.
      
      5. Quit from SwimBase.
      
      6. Copy the new version SWIM.EXE file to the location of the old
      version.
      
      7. Start the program by typing SWIM.
      
      8. Enter 'y' to convert events requestor.
      
      9. Select 'Set or Change Defaults' from the Main Menu and be sure
      that 'SKIP DB Audit' is set to 'N'.
      
      10. Use 'Select Active Season' to select each season you have
      defined in order to convert the files to the new format.
      
                    From SwimBase version 1.40 or earlier
      
         SwimBase Version 2.00 can not read the data base files from
      versions prior to 1.60. If you need to update your files then you
      must load version 1.6x as a intermediate step before loading 2.00.
      Version 1.65 is available from the author for a moderate shipping
      and handling fee.
         
                           Setup Technical Review
      
         The SWIM.EXE file is the main program file for SwimBase. This
      program file contains the main program and the program overlay
      files. When SwimBase is started the main program is loaded and then
      is run from RAM memory until the program is exited. As different
      program options are selected the SWIM.EXE file will be
      automatically accessed to load the necessary overlays into memory.
      For this reason the SWIM.EXE file must stay accessible. While this
      is not a problem for hard drive users it does mean that if you
      start SwimBase from a floppy drive that floppy must remain loaded.
      
         As soon as SWIM.EXE loads it will search the same directory
      that SWIM.EXE is in to find the system defaults which are contained
      in the file DEFAULT.DTA. If DEFAULT.DTA is not found then it will
      be created in that directory.
      
         After this is loaded then the event data files, EVENT.DTA and
      EVENT.ORD are loaded. These files must be located in the program
      directory (the same directory SWIM.EXE is in). If EVENT.DTA is not
      located then it will be created. You can use the 'Modify Event
      Definitions' menu to define your events. If you have modified the
      default age group setting then an additional setup file,
      AGEGRPS.DTA, will be located in the program directory and loaded to
      define your age groups. 

                          Hard Disk Setup

             The program, SWIM.EXE, should be loaded in a subdirectory,
        recommended name, C:\SWIMDATA, and then the Season and data files
        kept in this same directory. Using the defauls from the INSTALL
        program will result in this configuration.
                                  Page 6
                      Dual Floppy Disk Setup

             To use this setup you must have at least 2 floppy drives
        each with a capacity of 720K or more.

        1. Use the INSTALL program to install the program on a floppy.
        See INSTALL.DOC for floppy installation.

        2. Put the Program files disk in  drive A: and a blank, formatted
        floppy in drive B:.

        3. Start the program by typing A:\SWIM.

        4. Answer N to 'Directory Open Failure' requestor.

        5.  Enter directory for the data disk, 'B:\SWIMDATA' is recommended

        6. Be sure the data disk is in drive B: and press return.

        7. Press Y to create directory.

        8. When program starts select 'Set or Change Defaults'  and enter the
        directory from step 5 as the data PATH default.

        9. Each time you are  ready to use the program place the program disk
        in drive A: and the data disk in drive B: and then type A:\SWIM.

                                 Menu Usage
      
         The basic use of all menus is the same. The up and down arrow
      keys are used to move within the menu or by pressing the first
      letter of a menu item it can be jumped to. The selection is picked
      by pressing the ENTER key. On the menus that can span more than one
      screen full of data such as the swimmer requestor the Page Up and
      Page Down keys move a page at a time rather than a item at a time.
      The ESC key will return to the previous menu or selection or exit
      the program from the opening menu. The ESC key is consistent
      throughout the program to cancel the current selection.
      
         There are 3 special keys that are active in any menu. ALT/C
      (holding down the ALT key and pressing C) will open a time
      calculator window. This calculator will allow you to add, subtract
      and divide time in minutes:seconds:hundreds format. See the manual
      section on the Time Calculator for details. ALT/A (holding down the
      ALT key and pressing A) will open the 'About SwimBase' window with
      memory usage statistics. ALT/D will shell out (exit) to DOS. This
      DOS shell will allow any DOS commands or actions to be taken. You
      can return to SwimBase at the point you left by entering 'EXIT' at
      the DOS prompt.
                                  Page 7
                              Menus and Screens
      
      
      
                      /= F1 HELP = 08/22  15:57:05 \
                      |                            |
                      |          SwimBase          |
                      |        Opening Menu        |
                      |============================|
                      |  Select Active Season      |
                      |  Define New Season         |
                      |  Remove Existing Season    |
                      |  Archive Season Data       |
                      |  Set or Change Defaults    |
                      |  Change Data Disk          |
                      |  Modify Event or Age Grps  |
                      |  Import Season DataBase    |
                      |  About Swim Data System    |
                      |============================|
                      |    Exit Swim Data Base     |
                      \============================/
      
                                Opening Menu
      
         This is the initial menu presented when SwimBase is started.
      All functions of SwimBase are accessed through this menu. Exiting
      this menu quits SwimBase and returns control back to the operating
      system.
      
      1. Select Active Season
      
              This selection will present the Season Select Requestor
         with a list of all defined seasons. Pick the season that will
         contain the data to be used for this session. Most operations
         within SwimBase are done to the data in a particular season.
      
      2. Define New Season
      
              This item is used to define a new season. Before any
         operations can be done on meets, swimmers or events the season
         in which they are to exist must be built. When this is selected
         you will be presented 2 forms. The first will allow you to
         choose a name for the season and the second will build the
         information about the season. These forms are discussed in
         greater detail elsewhere.
      
      3. Remove Existing Season
      
              This selection will delete a season. Note that all data
         associated with this season will be deleted. The swimmers,
         meets and events will be gone. In normal usage there will be no
         reason to delete a season. Old seasons should be retained for
         review in the future.
      
                                  Page 8
      4. Archive Season Data
      
              This selection will allow you to make a backup copy of a
         season or restore a previously created backup. Regular backups
         should be made to avoid data loss in case of a system failure.
         A full description of these options is contained within the
         description of the Archive menus and forms.
      
      5. Set or Change Defaults
      
              This selection will present a form that allows several
         configuration parameters to be set. These parameters are fully
         explained in the Default Data form description.
      
      6. Change Data Disk
      
              If the program is kept on a separate disk from the data
         then after starting the program use this selection to tell the
         program where to look for the data. A Drive/Path Selection Form
         will be presented into which you will enter the drive letter to
         locate the disk. If you will be using the same disks and
         directories each time then you can set the data path in the Set
         Defaults form.
      
              This selection can also be used to change the directory
         that contains the Seasons you wish to work with. This would be
         used if you kept different directories for different Seasons or
         teams.
      
      7. Modify Event or Age Grps
      
              This selection can be used to create, modify, view or print
         the Event or Age Group definition files. See the manual
         sections on Event Definitions or Age Group Definitions for
         further details. 
      
      8. Import Season DataBase
      
              This selection is used to copy the swimmer data base from
         one season to another. The swimmer roster records will be
         transferred to the new season and the age and group fields
         updated according to the date of the new Season. This selection
         will only import the swimmer records, no meet or event data is
         imported. The data in the old season is not modified.
      
      9. About Swim Data Base
      
              This selection presents a short description and copyright
         notice along with the version number and date and the unique
         serial number for this program. Also included are details on
         active program and data paths, free Disk, Ram and Stack memory
         and Ram Heap integrity. This selection can be used to determine
         the amount of free disk space on your data disks.
      
      10. Exit Swim Data Base
      
         Return to DOS, quit program.
                                  Page 9
                           Season Menus and Forms
      
      
              /==============Create New season=============\
              |                                            |
              | Enter new Season Name (4 to 8 characters)  |
              | Press ESC to QUIT                          |
              |                                            |
              | Season Name : ________                     |
              |                                            |
              |                                            |
              |                                            |
              \============================================/
      
                              Season Name Form
      
         This form will appear when Define New Season is selected. You
      will enter the name for the new season. The name must be at least
      4 characters long and no longer than 8 characters. Some examples
      would be: MGC1990, SEASON1, OLNEY or TEAM90.
      
          /=== Enter Default Data for Season == Press F1 for Help ===\
          | Team Name : __________________                           |
          |                                                          |
          | Other Info, Division : ____________________________      |
          |                                                          |
          | Start date : __/__/__   End date : __/__/__              |
          |                                                          |
          | Number of Meets : ___   Age Basis (M,J,C,F) : _          |
          |                                                          |
          | Age Up Date : __/__/__  (Valid if Age Basis if 'F')      |
          |                                                          |
          \==========================================================/
      
                              Season Entry Form
      
         This is the form used to enter season data. The field
      descriptions are as follows:
      
      1. Team Name
      
              This is the name or base location of the team. This
         information will appear on any reports generated from data in
         this season.
      
      2. Other Info, Division
      
              This field contains additional information about the team
         or season to be entered. It also will become part of the header
         of any reports about this season.
      
      3. Start Date
      
              This is the date of the first meet of the season in
         Month/Day/Year (MM/DD/YY) format. The year from this field is
         used to calculate the swimmers' age and group information.
      
                                  Page 10
      4. End Date
      
              This is the date of the last meet in the season. This is
         for informational purposes only.
      
      5. Number of Meets
      
              This is the number of meets in the season. It is also for
         informational purposes only. If you define more meets than you
         specified here it will not cause any problems.
      
      6. Age Basis (M,J,C,F)
      
              This entry will set the date that is used for the basis of
         calculating the age and age group for each swimmer. When 'M'
         (Meet) is used the swimmers' age and age group will be set
         relative to the selected meet start date. 'C' (Current) will
         set the age relative to the current date. 'J' (July 1) will set
         the age relative to July 1st of the year the Season starts. If
         the Age Basis is set to 'F' (Fixed) then the date that the
         swimmer's age will be set relative to is taken from the Age Up
         Date field.
      
      7. Age Up date
      
              If the Age Basis is set to 'F' then the swimmer's age will
         be set relative to this date. If the Age Basis is anything else
         this date will be ignored.
      
              See the 'Age Up Swimmer Data' selection in the 'Swimmer
      Setup Menu' to reset the swimmers' age and age group as the
      season progresses.
      
                 /========= Delete SEASON Warning ========\
                 |                                        |
                 |   Delete this SEASON Y/N [N] ? _       |
                 |                                        |
                 |  MYSEASON                              |
                 |                                        |
                 | This SEASON and all SWIMMER data, MEET |
                 | data and EVENT data for this SEASON    |
                 | will be DELETED. !!! FOREVER !!!       |
                 \========= *** FINAL WARNING *** ========/

                 /========= Delete SEASON Warning ========\
                 |                                        |
                 |   Delete SEASON Name:                  |
                 |                                        |
                 |  MYSEASON                              |
                 |                                        |
                 | Enter Season NAME to VERIFY DELETE     |
                 | Press ESC to QUIT and abort DELETE     |
                 | Season Name to DELETE: ________        |
                 \========= *** FINAL WARNING *** ========/
      
                       Delete Season (Meet) Requestors
      
         Any time you try to delete either a season or a meet this pair
                                  Page 11
      of requestors will appear. The first requestor will sound a buzzer
      and ask for a Yes/No confirmation that you really intend to delete
      this season or meet. If anything other than Y is entered the
      process is canceled and you are returned to the menu.
      
         If Y is entered the second requestor will appear and you will
      need to enter the season or meet name to complete the deletion. If
      this name isn't entered correctly then the process is canceled. If
      the correct name is entered then the season or meet will be
      removed. 
      
      
      PLEASE NOTE
      
         Once deleted there is no way to 
         recover the deleted data.
      
      
      
                             /===============\
                             | Select Season |
                             |===============|
                             |   MGC1991     |
                             |   OMSC1990    |
                             |   TEST0123    |
                             |===============|
                             | Cancel Select |
                             \===============/
      
                           Season Select Requestor
      
         This requestor is used by several other menu items to allow the
      choice of a particular season. A list of all seasons is presented
      and you can chose any season or cancel the operation by either
      selecting Cancel Select or pressing the ESC key. The action taken
      after selecting a season will depend on what menu you were in when
      this menu appeared. The list of seasons will be sorted
      alphabetically and if more than 12 seasons exist then selections
      for next page and last page will be included.
      
                         Database Maintenance Menus
      
      
                          /======================\
                          |       DataBase       |
                          |     Maintenance      |
                          |======================|
                          | Archive Swimmer Data |
                          | Archive Meet Data    |
                          | Archive Event Defs   |
                          | Restore Data         |
                          |======================|
                          \======================/
      
      
      
                                  Page 12
                         DataBase Maintenance Menu
      
      
         This menu is used to determine if the data is to be archived
      (saved from the active files to a backup copy) or restored (moved
      from the backup copy to the active copy). The Archive data
      selection should be used as a matter of routine. The Restore Data
      selection should only be used in times of data base corruption or
      to share a data base among different systems.
      
         You can choose to archive the Swimmer, Meet or Event data to
      the same destination or use separate floppy disks for each. As your
      data grows you may need to use different disks for each. When you
      restore the data the program will restore whatever data is present
      on the floppy to the program disk. If you archived all 3 to the
      same disk then all 3 will be restored. If you only did 1 then that
      is all that will be restored.
      
         If you are planning to use the Import/Export Meet Data
      functions then you may want to use just the Archive Swimmer Data
      selection to insure that the Swimmer data files are identical on
      the 2 systems that will be sharing data. See the manual section
      describing the Import and Export functions for further details.
      
      /============== *** Overwrite DataBase Warning *** ==============\
      |                                                                |
      |        The process you have selected will overwrite            |
      |        the existing DataBase for the Season you are            |
      |        about to select. This should only be done to            |
      |        recover from data corruption.                           |
      |        If improperly used this process could destroy           |
      |        your swimmer and meet data bases. BE CAREFUL!!!         |
      |                                                                |
      \================================================================/
      
                              /============\
                              | Overwrite  |
                              |  DataBase  |
                              |============|
                              |    Yes     |
                              |    No!     |
                              |============|
                              \============/
      
                         Overwrite Database Warning
      
         This pair of windows will appear if you have selected to
      restore a previously archived database. The restoral process will
      replace the current data with the old data.         
      
      
                                  Page 13
        /== Enter Default Data for SDB == Press F1 for Help =\
        |                                                    |
        | AutoDetect Monitor : Y      Color Monitor :        |
        | Quick Start : Y             SKIP DB Audit : Y      |
        | Startup Password : __________  Foreground : 0      |
        | Delete Password  : __________  Background : 9      |
        | Print Extended Graphics : Y    View Color : 1      |
        | Printer Port : PRN      Carriage returns ? : N     |
        | Printer Setup  : ____________________________      |
        | Enter PATH name for SwimBase Data Files:           |
        | PATH = C:\SWIMDATA_______________________________  |
        | Use No Age Groups : N  Use 7 Age Groups : N        |
        | Each Meet has Event File : N  Keep Records : Y     |
        | Yard Factor : __.___   Meter Factor : __.___       |
        |                                                    |
        |                                                    |
        |   Press ENTER to Accept, Any other key to edit     |
        \====================================================/
      
      
                          Default Data Form
      
         This form enters default data about your system, printer and
      preferences. This data is entered once and then will remain in
      effect unless changed.
      
      1. AutoDetect Monitor
      
              If this is set to Y then the program will automatically
         detect the presence of a color monitor and use color. In some
         cases it is possible that the monitor type indicated by the
         system does not match what is actually installed, this is a
         common problem with portable Pcs. If this occurs then set this
         to N and set the proper monitor type in the next field. You can
         also force a color monitor to display in black and white by
         setting this field to N and the next field to N.
      
      2. Color Monitor
      
              If you are using a color monitor then select Y for this
         field otherwise set it to N. This field will not appear if
         AutoDetect Monitor is set to Y. 
      
      3. Quick Start
      
              The program will display an opening banner for a few
         seconds if this is set to N. To go directly to the opening
         menus set it to Y.
      
      4. SKIP DB Audit
      
              The program will run a check on the integrity of the
         database structures each time a season is selected if this is
         set to N. This step can be skipped by setting this to Y. The
         few seconds lost while the data base check (audit) is run is a
         small price to pay for insurance that your data is not
         corrupted.
      
                                  Page 14
      5. Startup Password
      
              If you wish to require a password to access any of the data
         then enter that password here. The password can be any string
         of characters up to 10 in length. To remove a password once one
         is entered use 'NOPASSWORD' (uppercase) as the password. Note
         that you will need to know the old password to remove it.
      
      6. Foreground
      
              You can use this selection to select any one of ten
         different color combinations for the menus, screens and
         messages by entering a number between 0 and 9. The changes are
         effective as soon as the default data form is accepted.
      
      7. Delete Password
      
              If you wish to require a password to delete data but not
         one for access then set a password here. The same requirements
         for removing this password apply.
      
      8. Background
      
              This selection acts the same as for Foreground selection
         except it controls the window background and shading. These
         colors are a subset of the Foreground colors so changing
         Foreground will effect the Background.
      
      9. Print Extended Graphics
      
              Set this to Y if your printer supports the Extended or IBM
         line drawing character set. The best looking reports can be
         obtained with this set to Y. If the reports generated with this
         set to Y have garbage in the borders and through them then you
         will need to set this to N or use the Printer Setup the enter
         the proper printer codes to print Extended or IBM characters.
      
      10. View Color
      
              This selection acts the same as Foreground and Background
         but it controls the colors for any reports that are viewed on
         screen.
      
      11. Printer Port
      
              When you reach this selection a secondary selection
         requestor will open that will allow you to select which printer
         port your printer is attached to. The possible selections are:
         PRN for the DOS default printer port, LPT1, LPT2 and LPT3 for
         the possible parallel ports and COM1 through COM4 for the
         possible serial ports. If you select one of the COM ports you
         will need to define the port parameters (Baud, bits etc.)
         before starting SwimBase. See the DOS MODE command for details.
      
      12. Carriage returns
      
              SwimBase sends a linefeed (new line or LF or 0A) at the end
         of each line when it generates any printed reports. Most
                                  Page 15
         printers will convert this linefeed to a linefeed/carriage
         return pair. If your reports run off the right edge of the
         paper it is probably because your printer does not follow this
         convention. Changing this field to Y will send both a linefeed
         and a carriage return to the printer.
      
              On a HP Laserjet the appearance of this problem is the
         first line of the report will print and then the rest of the
         page will be blank. Changing this field to Y will cure this
         problem.
      
              Alternatively, Using '1b 26 6b 32 47' as the printer setup
         for a HP Laserjet will cause the printer to follow the standard
         LF to LF/CR conversion.
      
      13. Printer Setup
      
              This is the string that will be sent to the printer before
         any thing is printed. The string needs to be entered as
         hexadecimal characters with each character separated by a
         space. An example would be '1b 7 1'. Most printer manuals use
         hexadecimal in the reference section. 
      
      14. PATH =
      
              If the data files are going to be kept in a directory
         different from the directory with the program file 'SWIM.EXE'
         then set the directory PATH here and the program will
         automatically use those files. The path can be entered as
         either a full or relative path name. Some examples of
         legitimate full pathnames would be:
         C:\SWIMDATA
         C:\DATA\SWIMDATA
            Examples of relative pathnames:
         SWIMDATA
         MYDATA
              Please note that changes entered here are not immediately
         active. To start using the new PATH you must either select
         'Change Data Disk or Path' for the Opening Menu or Exit and
         restart SwimBase.
      
      15. Use NO Age Groups
      
              If your league does not differentiate swimmers by their
         ages then set this selection to 'N'. With this set to 'N' then
         all reports and selections will be made without reference to
         the swimmers' age or age group.
      
      
      16. Use 7 Age Groups
      
              SwimBase has two sets of default age groups available if
         you don't use the Modify Events or Age Grps selection from the
         Opening Menu to custom define your age groups. These defaults
         are to use either 5 age groups or 7 age groups. If this field
         is set to N then the available age groups are: 8 & U, 9 - 10,
         11 - 12, 13 - 14 and 15 - 18. If set to Y then the groups are:
         6 & U, 8 & U, 9 - 10, 11 - 12, 13 - 14, 15 - 16 and 17 - 18. A
                                  Page 16
         'SENIOR' group is also available.
      
              This selection will not appear if you have defined your own
         age groups or you have selected to use no age groups.
      
      17. Each Meet has Event File
         
              This selection when set to 'Y' will allow each meet to have
         different numbers of finishers scoring points and different
         points assigned to each place. When selected the 'Main Menu'
         will include a 'Modify Event Definitions' selection where the
         Meet specific values are defined. Refer to the Main Menu for
         details.
          
      18. Keep Records
      
              You can keep details of both league and team records,
         including the swimmer name, date and location, for all events.
         Set this to 'Y' if you wish to keep this level of detail. See
         the 'Record Detail Form' for a more complete description of the
         data retained.
      
      
      19. Yard Factor
      20. Meter Factor
      
              If your league swims some meets in pools measured in meters
         and others in pools measured in yards and you want to normalize
         the reports to show all times as meters or yards then you can
         enter the Yard to Meter and Meter to Yard multiplier factors
         here. A suggested yard to meter factor would be 1.11 and a
         meter to yard factor would be 0.901. If there is any entry in
         these fields then any reports will allow an option of reporting
         in Yards, Meters or As Entered.
      
                                  Page 17

      
                            Event Menus and Forms
                                      
      
                            Understanding Events
      
         The initial setup of your event definitions can have a large
      impact on how well SwimBase will fulfill your requirements so
      before starting to define your events you should take some time to
      understand how events are handled by SwimBase.
      
         As an example let's say that there are 4 events used in your
      league. These are:
      
         Event        Event
         Number   Description
      
         5        Boys 8 and Under 50M Freestyle
         5a       Boys 6 and Under 50M Freestyle
         6        Girls 8 and Under 50M Freestyle
         6a       Girls 6 and Under 50M Freestyle
      
         Now what we need to do is number these events starting at 1 so
      now what we have is:
      
         Event        Event
         Number   Description
      1  5        Boys 8 and Under 50M Freestyle
      2  5a       Boys 6 and Under 50M Freestyle
      3  6        Girls 8 and Under 50M Freestyle
      4  6a       Girls 6 and Under 50M Freestyle
      
         The numbers 1 through 4 can be thought of as the SwimBase
      internal event numbers. You can skip numbers if you wish and add
      more events later but once data is entered for a meet the internal
      number for that event can't be changed.
      
         When you are entering event results you will enter the Event
      Number (IE: 5 or 6a) and SwimBase will store the data under the
      internal event number.
      
         The order that the events will appear in reports or if the
      event will appear in the report at all is determined by the
      internal event numbers. 
      
         The steps that we would follow to setup the events for this
      example are:
      
      1. Select 'Modify Event Definitions' from the 'Opening Menu'.
      
      2. Select 'Modify Globals' from the 'Modify Events' menu.
      
      3. Enter '1' as the 'Lowest Event' and '4' as the 'Highest Event'.
      The value for 'Lanes Scoring Points' will come from your league
      rules. It is the number of places that are awarded points. If the
      first 4 finishers are awarded points then enter 4 for this field.
      
                                  Page 18
      4. Now select 'Modify Events' from the 'Modify Events' menu and
      enter the internal number of the first event we are defining ('1')
      into the 'Enter Event to Update' requestor. 
      
      5. Enter the Event Number for this event ('5') into the 'Event
      Definition #001 Details' form and complete the rest of the form
      using the 'Event Input Form' for details of each of the fields in
      the form.
      
      6. Repeat steps 4 and 5 for each of the remaining events.
      
         Please refer to this simple 4 event example to better
      understand the Event Setup Description that follows.
      
      Event Setup Description
      
         When 'Change Event Definitions' is selected two data files,
      EVENT.DTA and EVENT.ORD, will be created or modified if they exist.
      The information contained in these files are the names, points per
      place, maximum points for the event, age group, event type, point
      basis, team or individual, output order and the start and end event
      numbers. There can be up to 256 events defined. This file is used
      by the SWIM main program and needs to be in the SWIM program
      directory. 
      
                         Event Definition Requestors
      
      
                           /================\
                           | Modify Events  |
                           |================|
                           | Review Events  |
                           | Modify Events  |
                           | Modify Globals |
                           | Review Order   |
                           | Modify Order   |
                           | Record Detail  |
                           | Set Age Groups |
                           |================|
                           |     Cancel     |
                           \================/
      
      
                     Opening Menu Modify Event Requestor
      
      
                                  Page 19
                            /================\
                            | Modify Events  |
                            |================|
                            | Review Events  |
                            | Modify Events  |
                            | Modify Globals |
                            | Review Order   |
                            | PreSet Points  |
                            |================|
                            |     Cancel     |
                            \================/
      
      
                      Main Menu Modify Event Requestor
      
         The first of these menus will appear when 'Modify Events or Age
      Grps' is selected from the Opening Menu. The second will appear
      when 'Modify Event Definitions' is selected from the Main Menu.
      When selected from the Main Menu you will also need to select which
      meet the Event File is for. From this menu you can change the
      definitions of the individual events, the number of events and
      output order of the events, the team and league record details, the
      swimmer age groups and the event points. The selections within the
      two menus will be described together.
      
      1. Review Events
      
              This selection will produce the Event Definitions report.
         This report will provide details of how your events are
         currently defined. Refer to the 'Event Definitions' report for
         details.
      
      2. Modify Events
      
              This selection is used to modify the details of a single
         event. When selected you will first be asked for which event
         you want to modify (use the internal event number to select)
         and then will complete an event definition form. See the
         'Modify Event Form' for details of the fields within this form.
         If this is the individual meet event form selected from the
         Main Menu then you will only be able to modify the points for
         the events. All other changes are done from the Opening Menu
         Modify Events.
      
      3. Modify Globals
      
              This selection is used to change the high and low event
         number and the number of places scoring points. See the 'Modify
         Globals Form' for details of the fields within this form.
      
      4. Modify Order
      
              This selection is used to set the order of events in any
         reports or to build reports that exclude certain events for the
         report. See the 'New Event Order' form for details on the
         fields in this form. 
      
                                  Page 20
      5. Review Order
      
              This selection will produce a report of the values that you
         have defined in the previous selection.
      
      6. Record Detail
      
              This selection will allow you the add, change or report on
         the record detail information for your team and league. 
      
      7. Set Age Groups
      
              If the 2 predefined age groups do not fit your needs this
         selection can be used to define the specific age groups for
         your team. See the Age Groups form for more detail on the use
         of this selection.
      
      8. PreSet Points
      
              If you use different points and scoring values for each
         meet it is possible to build a file that will simplify the
         setup of each of your meets. See Preset Points in the manual
         for further details on the use of this function.
      
      
      
                        Event Definitions                               
      |Low ev = 1,High ev = 50,Finishers = 5,YtoM = 0.0, MtoY =  0.0 
      |1992    Test team                DG                    Page  1
      |====================================================================
      | I# ENum    Event Name              ET G   AGP   EGRP TYP  MX MN LNG
      | p01 p02 p03 p04 p05
      |--------------------------------------------------------------------
      | 1 1     Boys 12 & U 100M Ind. Med  S B 11 - 12 IMed BOTH 10  0 100M
      |  6   4   3   2   1 
      |
      | 2 2     Girls 12 & U 100M Ind. Med S G 11 - 12 IMed BOTH 10  0 100M
      |  6   4   3   2   1
      
      
                           Event Definition Report
      
         This is a partial event definition report. The field
      definitions are as follows:
      
      1. Low event number (Low ev)
      
              This is the lowest definable event number as entered in the
         event definition requestor for lowest event.
      
      2. High event number (High ev)
      
              This is the highest definable event number.
      
      3. Finishers
      
              This is the number of finishers (places) that can generate
         points for the swimmers. In the example the 4 means that places
                                  Page 21
         1 through 4 will receive points while the rest will be
         classified as DNP - Did not Place. The allowable range is 3 to
         16.
      
      4. YtoM
      5. MtoY
      
              This is the Yards to Meters and Meters to Yards conversion
         factors. These values are entered in the Set or Change Defaults
         selection. See that selection for an explanation for the usage
         of YtoM and MtoY.
      
      6. I#
      
              This is the internal number for this event. It will not
         always be the same as the event number you assign to the event.
      
      7. ENum
      
              This is the event number that you have assigned for this
         event. This is the number (it can be alpha, numeric or mixed)
         that you will enter when referencing this event.
      
      8. Event Name
      
              This is the name of the event. Note that because of the
         amount of information in this report the event name is limited
         to 30 characters. In the reports and event forms the full 36
         characters of the event name are retained.
      
      9. ET
      
              This is the Event Time, either S for short (9:59:99 or
         less) or L for up to 59:59:99.
      
      10. G
      
              This the gender for this particular event. G is for Girls
         and B is for Boys.
      
      11. AGRP
      
              This is the age group for this event. If you select to not
         use age groups then this field will not appear in the event
         reports.
      
      12. EGRP
      
              This is the event group for this event. This field is used
         for selecting this event in reports. The possible choices are
         freestyle, backstroke, breaststroke, butterfly, individual
         medley, free relay, medley relay or don't care.
      
      13. TYP
      
              This field determines the point accumulation type to be
         used for this event. 
      
                                  Page 22
      14. MX
      
              This is the maximum number of points that the team can
         accumulate from the event.
      
      15. MN
      
              This is the minimum number of points a team can accumulate
         from an event. This value only comes into play for scoring a
         meet in the Swim Meet Management selection. If either team has
         a swimmer entered in an event and no swimmer finishes in the
         points then this value is applied.
      
      16. LNG
      
              This is the distance for this event. This selection is used
         to select particular events for reporting purposes.
      
      11. p01, p02, p03, p0n .......
      
              This is the number of points awarded for each finishing
         place, 1st through nth. The number of places that will appear
         here depends on the setting of the Finishers Scoring value.
      
      
           /========== Enter Event Data == Press F1 for Help =========\
           |                                                          |
           |   Lowest Event : 1__  Highest Event : 46_                |
           |                                                          |
           |   Finishers Scoring Points : 5                           |
           |                                                          |
           \==========================================================/
      
                         Modify Globals Form
      
         This form is used to set the lowest and highest event number
      and the number of Finishers Scoring. The range for the event
      numbers must be between 0 and 255 with the lowest event being at
      least 1 less than the highest. The range for Finishers Scoring is
      3 to 16. 
      
      1. Lowest Event
      
              This is the internal event number of the lowest event used.
         This number can range from 0 to 254 and must be at least 1 less
         than the Highest Event number. From the setup example this
         would be a '1'.
      
      2. Highest Event
      
              This is the internal event number of the highest event
         used. This number can range from 1 to 255 and must be at least
         1 more than the lowest event number. From the setup example
         this would be a '4'.
      
      3. Finishers Scoring Points
      
              This is the number of finishers that can be awarded points
                                  Page 23
         in each event. This number can range from 3 to 16. This number
         should be the highest applicable to any event. If the
         individual events allow 5 scorers and the relays only 3 then 5
         should be entered here. During the relay event setup you will
         be able to set the extra places to 0 points to avoid scoring
         errors.
      
                       /=== Enter Event to Update ==\
                       |                            |
                       |   Event (1 - 150) : ___    |
                       |                            |
                       \=== ESC to Save and Exit ===/
      
                               Event Requestor
      
         This requestor is used to select an individual event for input
      or update. The number entered is the internal event number. The
      range of numbers that can be selected is set by the high and low
      numbers entered on the global setup.
      
         After you have made your event changes press the ESC key and
      your changes will be saved and the program will return to the menu.
      
    /=================== Event Definition #001 Details ==================\
    |                                                                    |
    | Event Number : 1___                                                |
    |                                                                    |
    | Decription : _1_-_Boys__12_&_U__100M_Ind._Medley_ Active (Y/N) : Y |
    |                                                                    |
    | 6=15 - 16 7=17 - 18                                                |
    | 0= 6 & U  1= 8 & U  2= 9 - 10 3=11 - 12 4=13 - 14                  |
    | Age Group (0 - 15): 3_       Event Gender (B/G) : B                |
    |                                                                    |
    | Event Group : 4    Time for Event : S  Event Distance : 25M__      |
    |                                                                    |
    | Select points for each finishing place (0 - 99)                    |
    | 1st : 6_  2nd : 4_   3rd : 3_    4th : 2_   5th : 1_               |
    |                                                                    |
    |                                                                    |
    |                                                                    |
    |                                                                    |
    |                                                                    |
    | Enter basis for point accumulation, [I]ndividual, [T]eam or [B]oth |
    | Scoring basis : B  Maximum Points : 10  Minimum Points : 0_        |
    |                                                                    |
    | Team Rec. __:__:__ League Rec. __:__:__ AllStar Time __:__:__      |
    \====================================================================/
      
      
                              Event Input Form
      
         This form is used to input the details of a single event. The
      field definitions are as follows:
      
      1. Event Number
      
              This is the event number that you will use to identify this
         event. This is the number that you will input to enter results
                                  Page 24
         for this event and the number that will appear on any reports.
         It can be up to 4 characters, either numbers or letters. Some
         valid numbers would be 1, 2, 3a, 44b or a.
      
      2. Description
      
              This is a narrative description of this event. The
         description can be up to 36 characters in length. This the way
         this event's description will appear in all reports.
      
      3. Active
      
              The field selects if this event is active. If this is set
         to N then this event will be ignored for all reports. Any used
         event definition should be set to Y.
      
      4. Age Group
      
              This is the age group that will compete in this event. IF
         you use the 5 or 7 age groups setting available in the default
         setup the age group selections are:
      
                  0 -  6 & U
                  1 -  8 & U
                  2 -  9 - 10
                  3 - 11 - 12
                  4 - 13 - 14
                  5 - 15 - 18
                  6 - 15 - 16
                  7 - 17 - 18
                  8 - SENIOR
                  9 - Do Not Care
      
      If you decide to define your own set of age groups then you will
      pick from the list that you built in age group setup.
      
      5. Gender
      
              Select B for Boys or G for Girls.
      
      6. Event Group
      
              This is the event group selection for this event. The event
         group selections are:
      
                  0 - Freestyle
                  1 - Backstroke
                  2 - Breaststroke
                  3 - Butterfly
                  4 - Individual Medley
                  5 - Free Relay
                  6 - Medley Relay
                  9 - Do Not Care
      
              Event groups 5 and 6 are the relay events and when event
         results are entered for these events a subform will open that
         will allow the entry of the relay leg results (stroke and time)
         for each of the 4 swimmers in the relay event. If you do not
                                  Page 25
         want to keep track of the relay legs then set these events to
         type 9.
      
      7. Time for Event (L or S)
      
              This entry will select if the maximum time for the event
         is 9:59:99 or 59:59:99. Using 'S' will limit the input for this
         event to 9:59:99. The major effect of this selection is during
         data input the time can be input with 1 character for the
         minutes and some reports will report only a single character
         for the minutes value.
      
      8. Event Distance
      
              This entry is for the length of the event. You will enter
         the distance and either a 'Y' or a 'M' for yards or meters. The
         line above this selection will show the allowable input
         distance number as you input this field. A proper entry would
         be 100M with no space between the distance and the M.
      
      9. 1st place (2nd, 3rd, 4th, 5th ... 16th)
      
              This is the number of points accumulated for each finishing
         place. Depending on your setup anywhere from 3 to 16 places may
         appear here. 
      
              If you are changing the event definition file for an
         individual meet (accessed through the Main Menu) this will be
         the first field that you will enter. This field and the next 3
         will be the only ones available for modification.
      
      10. Scoring basis
      
              This determines how this event is handled for individual
         and team point accumulation. If the event is considered a TEAM
         event then no points will be shown for the individual swimmers
         on the swimmer reports. The possible selections are 'I' for an
         Individual event, 'B' for an event that will accumulate points
         for both the individual and the team and 'T' for team only
         points. 
      
      11. Maximum Team Points
      
              This is the maximum points that the team can earn in this
         event.
      
      11. Minimum Team Points
      
              This is the minimum points that the team can earn in this
         event. This is only used in the Swim Meet Management, Score
         meet selection.
      
      11. Team Rec., League Rec. and AllStar Time
      
              By entering values in these 3 fields you can be alerted to
         any swimmer that equals or betters a event 'record' or
         'allstar' time. A alert requestor will appear during event
         results input if either time is met and certain reports will
                                  Page 26
         have a '*R', '*T' or '*A' to indicate that this time is a
         League, Team or Allstar time. If you have selected to keep
         record details in the Default setup you will have the option of
         adding the record detail information.
      
         /==================== Enter New Event Order ===================\
         |                                                              |
         | Output Number : 2__                                          |
         |                                                              |
         | Event Number : 5a__                                          |
         |                                                              |
         | Active (Y/N) : Y                                             |
         |                                                              |
         \==============================================================/
      
                              Event Order Form
      
         This form is used to define the order that the events will
      appear in the reports or if the event will appear in the reports at
      all. 
      
      1. Output Number
      
              This is the position in the report that this event will
         appear. Number 1 will be first, 2 second and so on. Note that
         if 1 is set to Active = N then 2 will be first.
      
      2. Event Number
      
              This is the Event number that will be output in this output
         number. This is not the internal event number but the event
         number that you assigned in the event definition form.
      
      3. Active
      
              This field will determine if the event will appear in the
         report. If it is set to N that the event will not be output in
         the report. Note that setting this to N will not effect any
         data already entered for this event.
      
      
      
         |                  Event Report Output Order                   |
         |==============================================================|
         |Out  Report       Out  Report             Out  Report         |
         |Ord Event Num  ACT  Ord Event Num  ACT                        |
         |--------------------------------------------------------------|
         |  1   1      INACT    2     5      ACT                        |
         |  4   4      ACT      5     2      ACT                        |
         |  7   7      ACT      8     8      ACT                        |
         | 10   10     ACT     11     11     ACT                        |
         | 13   13     ACT     14     14     ACT                        |
         | 16   16     ACT     17     17     ACT                        |
      
      
                             Event Order Report
      
         This report shows the event output order and status of each
                                  Page 27
         defined event. Out Ord is the output order. Report Event Num is
         the Event number that will appear in the order shown. ACT or
         INACT decides if this event will appear in the reports.
      
      
         /==================== Enter Data for Record ===================\
         |                                                              |
         | Event Number : ____                                          |
         |                                                              |
         | Record Time : __:__:__  Record Time Date : __/__/__          |
         |                                                              |
         | Swimmer Name : _______________________________               |
         | Swimmer Team : __________________                            |
         | Pool Location : __________________                           |
         | Opponent : __________________                                |
         |                                                              |
         |                                                              |
         |                                                              |
         \==============================================================/
      
                             Record Detail Form
      
         This form is used to keep a detailed record of league or team
      records. You can keep one or the other or both. It can be accessed
      in several ways. The first is from the Event and Age Grp menu,
      Record Detail selection. The others are during entry of event
      information or event results. If you have populated the league
      and/or team record fields in the event setup and have Keep Records
      default set to 'Y' then anytime a swimmer exceeds either record you
      will have the option of completing this record. The record will be
      prepopulated with all the information available from the swimmer's
      record.
      
  / Enter or Update Swimmer Age Groups ====================================\
  |                                                                        |
  | Group  0 Description _6_&_U_  Low Age 1_  High Age 6_ Gender B  Act N  |
  | Group  1 Description _8_&_U_  Low Age 1_  High Age 8_ Gender B  Act Y  |
  | Group  2 Description _9_-_10  Low Age 9_  High Age 10 Gender B  Act Y  |
  | Group  3 Description 11_-_12  Low Age 11  High Age 12 Gender B  Act Y  |
  | Group  4 Description 13_-_14  Low Age 13  High Age 14 Gender B  Act Y  |
  | Group  5 Description 15_-_18  Low Age 15  High Age 18 Gender B  Act Y  |
  | Group  6 Description 15_-_16  Low Age 15  High Age 16 Gender B  Act N  |
  | Group  7 Description 17_-_18  Low Age 17  High Age 18 Gender B  Act N  |
  | Group  8 Description SENIOR_  Low Age 99  High Age 99 Gender B  Act N  |
  | Group  9 Description __DNC__  Low Age 99  High Age 99 Gender B  Act N  |
  | Group 10 Description _______  Low Age 0_  High Age 0_ Gender B  Act N  |
  | Group 11 Description _______  Low Age 0_  High Age 0_ Gender B  Act N  |
  | Group 12 Description _______  Low Age 0_  High Age 0_ Gender B  Act N  |
  | Group 13 Description _______  Low Age 0_  High Age 0_ Gender B  Act N  |
  | Group 14 Description _______  Low Age 0_  High Age 0_ Gender B  Act N  |
  | Group 15 Description _______  Low Age 0_  High Age 0_ Gender B  Act N  |
  |                                                                        |
  \========================================================================/
      
                                  Page 28
                           Swimmer Age Group Form
      
         This form is used to define the age groups for your team if you
      can't use the 2 predefined sets. The groups are numbered from 0
      through 15. The description is the text that will appear on any
      reports that are age group specific. You can use any characters
      that you like but you are limited to 7 characters. The low age and
      high age fields give the range of ages that will be swimming in
      this group. The gender can be 'B' for both or 'F' for female or 'M'
      for male. Act determined if this group is active, 'Y' for yes and
      'N' for no. In actual usage the age groups are searched from the
      top (group 0) looking for a group that meets the age range, gender
      and is active. In cases of an overlap the first age group will be
      selected.
      
         As is the case with the event definitions, each age group has
      an internal number that is used in other records referring back to
      a particular age group. If you have entered data with the first age
      group as '8 and Under' and then change the first age group to '6
      and Under' you have in effect changed all records that were 8 and
      U to 6 and U. It is important to set the age groups up properly
      before you start entering meet results.
      
      1. Group n Description
      
              This is the textual description that will appear any time
         that this age group is referred to in any forms or reports. You
         are limited to 7 characters.
      
      2. Low Age
      
              This is the lowest age that will be in this age group. The
         value can be anywhere from 1 to 99.
      
      3. High Age
      
              This is the highest age that will be in this age group. The
         value can be anywhere from 1 to 99.
      
      4. Gender
      
              This is the gender of this age group. It can be 'B' for
         both, 'F' for female or 'M' for male.
      
      5. Act
      
              This determines if this group is active, 'Y' for active and
         'N' for inactive. It is possible by having this on for some
         meets and off for others to combine age groups for certain
         meets. 
      
              If some meets use both a 6 and under and a 8 and under you
         could define both groups and if you do an 'Age Up' with them
         both active then swimmers would be placed in 6 and U or 8 and
         U. For a meet that combines these two groups by setting
         Active=N for the 6 and Under and doing another 'Age Up' the
         swimmer would be all placed in the 8 and Under group.
      
                                  Page 29

      Preset Points
      
         This selection will set the points awarded for each event to
      the values entered in the SCORES.DTA file. The SCORES.DTA file must
      be located in the same directory as the SWIM.EXE file and it is
      built as follows:
      
         LANES RELAY_FACTOR MAX_POINTS MIN_POINTS 1STPLACE 2NDPLACE
         3RDPLACE 4THPLACE ETC.
      
         EX:
      
         6 2 10 0 6 5 4 3 2 1
      
         This line would translate to, 6 places scoring, relays score
      double points per place, maximum 10 points for a team in the event,
      no minimum points, 6 for 1st, 5 for 2nd etc. The SCORES.DTA file
      can be built with any plain text editor. (EDLIN or DOS 5.0 EDIT or
      Wordperfect using DOS TEXT IN/OUT).
      
         When PreSet Points is selected you will enter a number that
      represents the number of places scoring and SCORES.DTA will be
      searched for a matching line. If found then all events will be set
      accordingly. If not found then a error will appear and no action
      will occur. This selection is only available if you have selected
      Each Meet has Event file in Set Defaults.
      
      
      
      /================= Enter PATH For SwimBase data =================\
      |                                                                |
      | Enter Path name for Data Files                                 |
      | Enter ESC to return to Opening Menu                            |
      |                                                                |
      | PATH = C:\SWIMDATA_______________________________              |
      |                                                                |
      | EX: C:\SWIMBASE\SWIMDATA or B:\SWIMDATA or SWIMDATA            |
      |                                                                |
      \================================================================/
      
                      Drive or Path Selection Requestor
      
         This form is used to enter the new disk drive and/or path for
      the swim data files. If you need to change from one data disk
      (floppy) to another or need to load the program and then change the
      floppy this selection should be used. This can also be used to keep
      multiple database files on your disk. If you are using one single
      path on the hard disk then the path entry in the Default setup
      should be used.
                                  Page 30

                     /= F1 HELP === 03/06  07:41:58 \
                     |                              |
                     |          SwimBase            |
                     |         Main  Menu           |
                     |        Active season         |
                     |       --> OMSC1990 <--       |
                     |                              |
                     |==============================|
                     | Meet Data, Add or Modify     |
                     | Swimmer Data, Add or Modify  |
                     | Event Results, Add or Modify |
                     | Swim Meet Management         |
                     | Reports, View or Print       |
                     | Audit DataBase Structures    |
                     | Change Season Information    |
                     | Display Season Information   |
                     | Modify Event Definitions     |
                     |==============================|
                     |    Return to Opening Menu    |
                     \==============================/
      
      
      
                                  Main Menu
      
         This menu will appear after a season is selected from the
      Opening Menu. It is divided into 9 parts. 6 selections will present
      submenus and the other 3 will result in actions as defined below.
      
      1. Add or Modify Meet Data
      
              This selection is used to create, change, delete or view
         meet data. Note that this is the meet definition itself, not
         the event results within that meet. The meet must be defined
         before any event data is entered.
      
      2. Add of Modify Swimmer Data
      
              This selection is for the creation and maintenance of the
         swimmer roster. All swimmer specific information is entered and
         maintained here.
      
      3. Add or Modify Event Results
      
              This entry is for the event data within a meet. The meet
         and the swimmers must be defined before the events can be
         entered.
      
      4. Swim Meet Management
      
              This selection will present a secondary menu which accesses
         the various meet management functions. These functions are
         detailed under the Swim Meet Management heading.
      
      
                                  Page 31
      5. View or Print Reports
      
              This item displays the report menu which allows the
         selection of several different reports concerning the data
         entered in the previous menu items.
      
      6. Audit DataBase Structures
      
              This selection will preform an integrity check on the
         database for the currently active season. This is the same
         check that is run when the season is first selected if the
         'SKIP DB Audit' default is set to N.
      
      7. Change Season Information
      
              This selection will allow any of the information that is
         entered when the season was created to be changed with the
         exception of the season name. Once created the season name
         cannot be changed. Note that if you are trying to move from one
         year to the next you shouldn't change the last year's season
         data but create a new season and then import the previous
         year's swimmer data.
      
      8. View Season Information
      
              This selection will display the data entered when the
         season was created along with 2 additional fields, Number of
         Meets defined and Number of Swimmers. These 2 fields represent
         the actual number of meets that have been defined in the Meet
         SetUp Menu and the number of swimmers entered in the Swimmer
         SetUp Menu.
      
      9. Modify Event Definitions
      
              This selection will present a subset of the 'Opening Menu',
         'Modify Events and Age Grps' menu with one additional
         selection, 'Preset Points'.
      
      
                                  Page 32

      
                            Meet Menus and Forms
      
      
      
                        /==== 08/22  15:57:25 ===\
                        |                        |
                        |        SwimBase        |
                        |    Meet SetUp Menu     |
                        |     Active Season      |
                        |    --> TEST0123 <--    |
                        |                        |
                        |========================|
                        |  Add Data for New Meet |
                        |  Change Existing Meet  |
                        |  Delete Existing Meet  |
                        |  View Existing Meet    |
                        |  Export Meet Data      |
                        |  Import Meet Data      |
                        |========================|
                        |  Return to Main Menu   |
                        \========================/
        
                               Meet Setup Menu
      
         This menu is accessed from the Main Menu and controls the entry
      of Meet data. The Meet data refers to the basic meet itself, not
      the results of the events within the meet. There are 6 selections
      available. 
      
      1. Add Data for New Meet
      
              This item will allow the definition of a new meet. When
         this is selected a form will appear in which you will enter the
         pertinent data about the meet. That form and the required
         entries are described in the Meet Entry Form.
      
      2. Change Existing Meet
      
              This selection will allow changes to be made to an existing
         meet. You will be presented a Meet Select Requester from which
         you will select which meet to change and then a prefilled meet
         entry form will appear. Make the desired changes in this form. 
      
      3. Delete Existing Meet
      
         This entry is used to remove a meet. The Meet Select Requester
         will allow you to choose which meet to remove. When this is
         done all event data for that meet will also be removed.
      
      4. View Existing Meet
      
              The item will allow you to review the previously defined
         meets. See the View Meet Data Form for details about the fields
         displayed.
      
                                  Page 33
      5. Export Meet Data
      
              This item is used to copy the results of a single meet to
         a floppy disk in preparation for transferring the data to a
         SwimBase database residing on another PC.
      
      6. Import Meet Data
      
              This item is the companion to the preceding entry and will
         read the files created by the Export process to update a
         SwimBase database residing on another PC.
      
      
           /========== Enter Meet Data == Press F1 for Help ==========\
           |                                                          |
           | Meet date : __/__/__    Meet type (A, B, or T) : _       |
           |                                                          |
           | Location : __________________                            |
           |                                                          |
           | Opponent Name : __________________                       |
           |                                                          |
           | Pool Measured in Meters? : N                             |
           |                                                          |
           |                                                          |
           \==========================================================/
      
                               Meet Entry Form
      
         This is the form used to enter or change meet data. The field
      descriptions are as follows:
      
      1. Meet date
      
              The date of the meet in Month/Day/Year (MM/DD/YY) form.
         This date will become part of the Meet Select Requester and
         will appear on any reports about this meet.  If you select an
         Age Basis of 'M' then this is the date that the swimmers' ages
         and age groups will be based on.
      
      2. Meet type (A, B, or T)
      
              Determines if this meet is a 'A' team meet, 'B' team or 'T'
         for time trial. These entries are used during report generation
         for point generation and separation. This also appears on the
         Meet Select Requestor.
      
      3. Location
      
              This is the location of the meet. This is informational
         only and will appear on any reports about this meet.
      
      4. Opponent
      
              This is the name of the opposing team in a meet. This entry
         will also become part of the Meet Select Requestor.
      
                                  Page 34
      5. Pool Measured in Meters?
      
              This field is used to indicate rather this meet is held in
         a pool that is measured in meters or yards. Enter Y if the pool
         is meters.
      
         After all the fields are completed a requestor will appear
      asking that you verify your desire to enter this meet. Answer Y to
      confirm or N or press ESC to cancel the addition.
      
                         /==== 08/23  10:01:34 ===\
                         |                        |
                         |   Select Active Meet   |
                         | Type  Opponent   Date  |
                         |                        |
                         | A HILLANDALE  06/16/90 |
                         | B TANTERA     06/20/90 |
                         | A CEDARBROOK  07/14/90 |
                         | Cancel Select Meet     |
                         |                        |
                         \========================/
      
                            Meet Select Requestor
      
         This requestor is used by several other menu items to allow the
      choice of a particular meet. A list of all meets is presented and
      you can select any meet or cancel the operation by either selecting
      Cancel Select Meet or pressing the ESC key. The action taken after
      selecting a meet will depend on what menu you were in when this
      menu appeared. The list of meets will be sorted by date and if more
      than 12 meets exist then selections for next page and last page
      will be included.
      
           /=================== Swim Meet Data =======================\
           |                                                          |
           | Meet date : 06/16/90    Meet type (A, B, or T) : A       |
           |                                                          |
           | Location : HILLANDALE________                            |
           |                                                          |
           | Opponent Name : HILLANDALE________                       |
           |                                                          |
           | Swimmers Competing : _63     Events Entered : 152        |
           | Times 1st : _21   2nd : _28     3rd : _36     4th : _24  |
           | Times DNP : _43              Total Points : _285         |
           | Points per Event : 1.875_    Time per Event : 0:57:64    |
           |                                                          |
           |                     Press Any Key                        |
           \==========================================================/
      
                             View Meet Data Form
      
         This form will summarize the information for a single meet. The
      data contained here is duplicated in the Meet Summary Report. Refer
      to the reports section of this manual for definitions of the fields
      contained in this form.
      
                                  Page 35
      /======= *** Export Meet for DataBase Merge Operation *** =======\
      |                                                                |
      |        The process you have selected will copy the Meet        |
      |        information for one Meet from the Database on this PC   |
      |        to a floppy to merge with the Database on another PC.   |
      |                                                                |
      |        Please see the Users Manual for complete details.       |
      |                                                                |
      |                      /============\                            |
      \======================|  Continue  |  ==========================/
                             |with Export |                             
                             |============|                             
                             |     Yes    |                             
                             |     No!    |                             
                             \============/                             
      
                            Export Meet Requestor
      
                             /================\
                             |  Export Drive  |
                             |======Select====|
                             |       A:       |
                             |       B:       |
                             |       C:       |
                             |       D:       |
                             |       E:       |
                             |================|
                             |     Cancel     |
                             \================/
      
                         Export Meet Drive Selector
                         Import Meet Drive Selector
      
      
      /======= *** Import Meet for DataBase Merge Operation *** =======\
      |                                                                |
      |        The process you have selected will copy the Meet        |
      |        information for one Meet into the Database on this PC   |
      |        from a floppy generated on another PC.                  |
      |                                                                |
      |        Please see the Users Manual for complete details.       |
      |                                                                |
      |                      /============\                            |
      \======================|  Continue  |  ==========================/
                             |with Import |                             
                             |============|                             
                             |     Yes    |                             
                             |     No!    |                             
                             \============/                             
      
                            Import Meet Requestor
      
      
         These menus are used to control the Import and Export
      processes. These can be used when it is necessary or useful to
      enter meet results on more that one PC and then combine the results
      into a single data base.
      
                                  Page 36
         This could be used when the Team may split into separate groups
      or by gender for the actual meets and the data keepers for each
      group have their own PC either at the meets or input the data
      afterwards.
      
         While it is possible to use these functions to combine multiple
      meets into one meet on the same PC the process flow will describe
      the steps necessary to enter data on 2 PCs and then move the data
      from PC 'B' to PC 'A' inorder to have a complete database on PC
      'A'.
      
                         Import/Export Process Flow
      
         The first step is to install the SwimBase program on 2 PCs. For
      simplicity, the program should be installed in the same directories
      and drives on both PCs. Please observe the program license
      restrictions when using SwimBase on multiple computers.
      
         One PC should be considered the 'Primary' , the other the
      'Secondary' for this process. The individual swimmer data should be
      entered and kept updated on the primary PC. When it is time to use
      the secondary PC this swimmer database must be copied from the
      primary. There are 2 simple ways to accomplish this task. If you
      are familiar with the DOS XCOPY command you can copy the SEASON
      subdirectory from the primary PC to the secondary PC (be sure to
      use the XCOPY /s option). The other method is to use the SwimBase
      ARCHIVE process to archive the swimmer data to a floppy and then
      use the ARCHIVE process on the secondary PC to restore this data.
      The swimmer data (files SWIMMER.DTA and SSWIMMER.DTA) must be
      identical for the import and export processes to work.
      
         When the swimmer data is properly loaded onto the secondary PC
      you can then define the meet that you will be using. If you use the
      XCOPY command it is possible to copy all the meet data along with
      the swimmer data.
      
         Enter the data onto the secondary PC as you normally would,
      either directly through the event data entry screens or through the
      meet management functions. When you are complete then use the
      EXPORT selection to copy the data to a floppy disk. Select EXPORT,
      then select the floppy that you will be using to transport the
      data, now select the meet to EXPORT. At this point the meet data
      will be copied to your floppy disk.
      
         Transport the EXPORT floppy to the primary PC and select
      IMPORT, select the IMPORT floppy drive, select the name of the meet
      that was exported from the secondary PC, then the meet on the
      primary PC to receive the exported data. You can decide to import
      only selected genders or age groups. The data will now be moved
      into the meet selected.
      
      
      
                                  Page 37
                 /=======Database Audit In Progress=======\
                 |                                        |
                 |              Please Wait               |
                 |                                        |
                 \========================================/
      
                               DataBase Audit
      
         This window will appear whenever a Season is selected. While
      this window is present the system is checking the integrity of the
      database. The Meets and Swimmer Databases are checked for range and
      reasonableness. If no errors are found then the window will close
      after a few seconds. If a Swimmer error is encountered you will be
      given an opportunity to edit the swimmer record.
      
         Generally, Meet errors are not correctable and Swimmer errors
      are correctable. The best course of action in response to any error
      is to restore the archived season data. (You did archive your data
      didn't you?)
      
                                  Page 38

      
                           Swimmer Menus and Forms
      
                       /===== 08/22  15:57:32 ====\
                       |                          |
                       |         SwimBase         |
                       |    Swimmer SetUp Menu    |
                       |      Active season       |
                       |     --> TEST0123 <--     |
                       |                          |
                       |==========================|
                       | Add Data for New Swimmer |
                       | Change Data for Swimmer  |
                       | Delete Data for Swimmer  |
                       | Display Data for Swimmer |
                       | Age Up Swimmer Data      |
                       |==========================|
                       |   Return to Main Menu    |
                       \==========================/
                                  
                             Swimmer Setup Menu
      
         This menu is accessed from the main menu and controls the entry
      of swimmer data. All data specific to an individual swimmer is
      entered or modified through this menu.
      
      1. Add Data for New Swimmer
      
              This selection is used to add a new swimmer to the data
         base. See the Swimmer Entry Form for an explanation of each
         field. The program keeps track of each swimmer by assigning a
         number to the swimmer upon entry into the program. This number
         is selected by the program and will be used during other entry
         processes to refer back to this swimmer. The program is limited
         to 511 swimmers in any given season.
      
      2. Change Data for Swimmer
      
              This selection is used to change any data about a swimmer.
         You will select which swimmer to change from the swimmer
         selection requestor.
      
      3. Delete Data for Swimmer
      
              This selection will delete a swimmer from the data base. 
         You will select which swimmer to delete from the swimmer
         selection requestor. If any event results have been entered for
         the swimmer then they will be deleted along with the swimmer.
      
      4. Display Data for Swimmer
      
              This selection allows you to review the swimmer data. One
         swimmer at a time will be displayed in the data entry form. You
         can not edit the data in this form.
      
                                  Page 39
      5. Age Up Swimmer Data
      
              This selection will recalculate the age and age group for
         each swimmer. The date used as the basis for this recalculation
         will be determined by what value was entered in the 'Age Basis'
         field in the Season Data requestor. If 'M' was selected then
         you will select a Meet and the swimmers' age will be set to the
         start date of that meet. If 'C' was selected then the age will
         be set relative to the current system date. If 'J' was selected
         then the age will be relative to July 1st of the year set in
         the Season Start date. If 'F' was selected then the age will be
         set relative to the date set for the AgeUp Date.
      
      
      /===== Enter Data for Swimmer == Press F1 for Help ===========\
      |                                                             |
      | Last : ____________    First : _____________   MI : _       |
      |Birth date: __/__/__ Sex(M/F): _ Age: 0_ Group: 0 Team: _    |
      |ID Info ________________                                     |
      |                                                             |
      | Telephone Numbers :                                         |
      |Home: (___) ___-____ Altn: (___) ___-____ Emer: (___)___-____|
      |                                                             |
      | Mother's Name :                           Work Phone        |
      |Last: ________________First: ________________ (___) ___-____ |
      |                                                             |
      | Father's Name :                           Work Phone        |
      |Last: ________________First: ________________ (___) ___-____ |
      |                                                             |
      | Address : _________________________________                 |
      | City : _____________ State : __  Zip Code : __________      |
      |                                                             |
      | Fee Paid :  $______          Swimmer Number : ___           |
      |                                                             |
      |                                                             |
      |                                                             |
      \=============================================================/
                                                                        
        
                             Swimmer Entry Form
      
         This form is used to enter or modify swimmer data. The field
      definitions are as follows:
      
      1. Last
      
         This is the swimmer's last name.
      
      2. First
      
         This is the swimmer's first name.
      
      3. MI
      
         This is the swimmer's middle initial.
      
                                  Page 40
      4. Birth Date
      
         This is the swimmer's date of birth.
      
      5. Sex (M/F)
      
         This is the swimmer's sex. F for female or M for male.
      
      
      6. Age
      
              This is the swimmer's age relative to the date selected by
         the Age Basis field in the season setup.  If this field is left
         blank during data entry then it will be calculated by the
         program. If data is entered that conflicts with the calculated
         value then a requestor will ask confirmation of the entered
         data. The date for the first meet used in this calculation is
         the First Meet Date field entered on the Season Definition
         Form.
      
      7. Group
      
              This is the swimmer's age group. This field will be
         calculated by the program if left empty during data entry. If
         the data entered conflicts with the calculated data then a
         requestor will ask confirmation of the entered data.
      
      8. Team
      
              This is the team that this swimmer will be competing on.
         The available selections are A, B, T or leave the entry blank.
         This field is used for several reports to allow just the
         swimmers for a particular meet (team) to be printed. 
      
      9. ID Info
      
              This is any additional information about the swimmer that
         you would like to retain. A student id number or SS number are
         some possibilities.
      
      10. Telephone Numbers
      
              These are the home, alternate and emergency telephone
         numbers for the swimmer.
      
      11. Mother's Name and work phone
      
         These are the mother's last and first names and work telephone
         number.
      
      12. Father's Name and work phone
      
         These are the father's last and first names and work telephone.
      
      13. Address
      
         This is the swimmer's street address.
      
                                  Page 41
      14. City
      
         This is the swimmer's city.
      
      15. State
      
         This is the swimmer's state.
      
      16. Zip Code
      
         This is the swimmer's zip code.
      
      17. Fee Paid
      
         This is the fee paid by this swimmer.
      
      18. Swimmer Number
      
              This is the swimmer number as assigned by the program. This
         number can not be changed by the user and will remain
         permanently assigned to this swimmer. A Listing of the assigned
         numbers can be obtained in the Swimmer List report.
      
      
                      /= F1 HELP === 08/22  15:58:36 \
                      |  Select Swimmer Name     No. |
                      |==============================|
                      | Anderson, Betsy            1 |
                      | Anderson, Dan              2 |
                      | Bolt, Laura                3 |
                      | Bolt, Lindsay              4 |
                      | Bostill, Catherine (P7)    5 |
                      | Bostill, Maura            45 |
                      | Bost, Chistopher          67 |
                      | Bost, Matthew             68 |
                      | Pullough, Jimmy           69 |
                      | Pullough, Mandi           70 |
                      |==============================|
                      |        View Last Page        |
                      |        View Next Page        |
                      |     Cancel Select swimmer    |
                      \==============================/
      
                          Swimmer Select Requestor
      
         This requestor will appear any time it is necessary to select
      a single swimmer by the swimmer's name. Both the swimmers name and
      number are displayed. There are cases where the swimmers number is
      used to identify the swimmer. The Swimmer List report can be used
      for a full listing of each swimmers' number.
      
                   /========== Time Calculator ==========\
                   |                                     |
                   |  Time : 01:23:14 Operation : +      |
                   |  Divisor : __                       |
                   |                                     |
                   |  Last Result : 02:46:28             |
                   \=====================================/
                                  Page 42

                               Time Calculator
      
         The time calculator can be accessed from any menu by pressing
      ATL/C (press the letter C while holding down the ALT key). You can
      use it to do simple time addition, subtraction and division.
      Pressing ESC when no times have been entered or when the calculator
      has been cleared will return to the menu that you entered the
      calculator from. Pressing ESC when there is data in the calculator
      will clear the calculator. Pressing the up arrow key will move the
      Last Result to the Time field. Leave the Operation field blank to
      move the Time to the Last Result field. The range of times that can
      be used are 00:00:00 to 59:59:99 Minutes:Seconds:Hundreds.
      
         To ADD you will enter the first time into the Time field and +
      into the Operation field. The first time will be moved to the Last
      Result field, you will now enter the next time into the Time field
      and press Enter on the Operation field to add the two times.
      
         To SUBTRACT enter the time to be subtracted from into the Time
      field and press Enter on the Operation field. This will move the
      first number to the Last Result field. Now enter the number to be
      subtracted into the Time field and - into the Operator. The Last
      Result field will now have your result.
      
         To DIVIDE enter the time to be divided into the Time field and
      enter / into the operator. You will be prompted for a divisor.
      Enter any number from 2 to 99. The Last Result field will now have
      your result.
      
         
      
                                  Page 43

      
                      Meet Results Menus and Requestors
      
                      /= F1 HELP === 08/22  15:57:37 \
                      |                              |
                      |           SwimBase           |
                      |      Meet Results Menu       |
                      |        Active season         |
                      |       --> TEST0123 <--       |
                      |                              |
                      |==============================|
                      | Add Individual Event Results |
                      | Change Individual Results    |
                      | Delete Individual Result     |
                      | Review Individual Results    |
                      | Calculate Best Times         |
                      |==============================|
                      |     Return To Main Menu      |
                      \==============================/
                                      
                              Meet Results Menu
      
         This menu is used to enter or modify the meet event results.
      All the meet event results are entered through this menu. The first
      step in using any selection within the menu will be to select a
      meet from the Meet Select Requestor.
      
      1. Add Individual Event Results
      
              This selection is used to enter new data for the results
         of an event. The Event Entry Form will be used for the input of
         the event data. See the Event Entry Form for details.
      
      2. Change Individual Results
      
              This selection is used to change the results of an event
         that has already been entered.
      
      3. Delete Individual Result
      
         This will delete an event result.
      
      4. Review Individual Results
      
         This selection will display the event results individually.
      
      5. Calculate Best Times
      
              This selection will compute what a swimmer's best time was
         for each event they have competed in and what date it was swam
         and also what the most recent time was and the date it
         occurred. See the 'Best Time Report Menu' for a more
         comprehensive explanation of the Best Time calculations and
         reports.
      
      
                                  Page 44
      /======== Enter New Data for Event == Press ESC to EXIT =======\
      |                                                              |
      | Swimmer Number : ________                                    |
      |                                                              |
      | Event Number : 15                                            |
      |                                                              |
      | Time : _:__:__  Status : F   Finishing Place : __            |
      |                                                              |
      |                                                              |
      |                                                              |
      \==============================================================/
      
                              Event Entry Form
      
         This form is used to enter the results for a single event
      within a single meet.
      
      1. Swimmer Number
      
              This is either the number of the swimmer or a partial name.
         Use the 'Swimmer List' report from the Swimmer Roster Reports
         to get an alphabetical listing of the swimmer's with their
         numbers. The swimmer's name will be displayed after entry for
         verification. 
      
              Data entry into this field can consist of either the
         swimmer's number, up to the first 8 characters of the swimmer's
         last name or the swimmer's last and first initial separated by
         a space. If enough characters are entered to select only a
         single swimmer then the swimmer's name will be selected. If
         more than one matches then a selector is presented with each
         possibility. If you enter nothing then a requestor with all
         swimmers will be presented.
      
              As an example, for a swimmer named Harry Johmson who is
         swimmer number 86 you could enter the number '86', 'johm' from
         Harry's last name or 'J H' for Harry's initials.
      
      2. Event Number
      
              This is the Event number as defined during event
         definition. See 'Modify Event Definitions' in the Opening Menu
         for a listing of the events. This will default to the last
         event entered. If you do not wish to change it then just press
         enter. The event name will be displayed after the event number
         is entered for verification.
      
      3. Time
      
              This is the time for the event in minutes, seconds and
         hundredths of seconds. If the time you are entering is less
         that 1 minute you must enter 0 or 00 for the minutes field
         depending on the course time selection.
      
      4. Status
      
              There are 6 different statuses allowed. 'F' is used for a
         successful finish with no qualifiers. 'S' is a successful
                                  Page 45
         finish for a Substitute swimmer. 'E' is a successful finish by
         a swimmer in the event for 'Exhibition'. 'T' is for a Tie. The
         points are awarded for a tie based on the point total of 2
         places divided in half, as an example a 1st place tie would be
         the 1st and 2nd place points divided by 2 . Only 2 way ties are
         allowed. 'N' is for a No show and 'D' is for a
         disqualification.
      
      5. Finishing Place
      
              This is the swimmer's actual finishing place. Places 0
         through 99 are tracked. A place of 0 is used for cases where
         there was no finish (a disqualification for example) or when
         the swimmer wasn't actually a competitor against the other
         swimmer (swimming exhibition). Places 1 through 16 can be used
         to calculate points. The number that actually calculate points
         is set during the Event Definition Setup. The remaining places
         are kept for informational purposes only. The true place
         numbers (0 - 99) will appear on certain reports. The point
         calculations would be the same if 0 was used for all cases that
         the swimmer finished out of the points.
      
      /============= Enter New Relay Leg Results ====================\
      |                                                              |
      | Sw1 : 2____ Brittany Prety Stroke : Free___ Time : _:__:__   |
      | Sw2 : _____                Stroke : _______ Time : _:__:__   |
      | Sw3 : _____                Stroke : _______ Time : _:__:__   |
      | Sw4 : _____                Stroke : _______ Time : _:__:__   |
      |                                                              |
      \==============================================================/
      
      
                            Relay Leg Entry Form
      
         If the event entered in the Event Entry Form is either of the
      relay type events then this form will open to allow entry of the
      four relay split times. You will enter the swimmer for each leg and
      the stroke and time for the leg. A submenu will appear for the
      stroke selection so you can pick from a list of the strokes. This
      data will be retained and included in the various reports.
      
      
                                  Page 46
                  Swim Meet Management Menus and Requestors
      
      
      
                        / F1 HELP  12/29  13:30:54 =\
                        |   Swim Meet Entry Menu    |
                        |                           |
                        |===========================|
                        | Add or Edit Meet Entries  |
                        | Enter Times and Results   |
                        | Delete Meet Entry Sheet   |
                        | Score Meet Entry Sheet    |
                        | Swimmer Entry Report      |
                        | Event Entry Report        |
                        | Print Meet Entry Sheet    |
                        | Prepare Event Entry Cards |
                        | Prepare Meet Ribbons      |
                        | Save Entries to Database  |
                        | Audit Meet Entry Sheet    |
                        |===========================|
                        | Exit Meet Entry Menu      |
                        \===========================/
      
                          Swim Meet Management Menu
      
         This menu is used to access the meet management functions of
      SwimBase. The functions preformed here differ in several ways from
      the rest of the SwimBase program. The most important difference to
      keep in mind is that data and results entered in a Meet Entry Sheet
      are not updated into the main SwimBase Event and Swimmer databases
      until the 'Save Entries to DataBase' selection is picked.
      
         The data in the meet entry sheet can be added to, changed or
      deleted with no effect on the main database until that selection is
      used. Once it is selected then any changes in the meet entry sheet
      are not reflected in the main database unless 'Save Entries to
      Database' is selected again. Note that certain changes and
      deletions in the Meet Entry Sheet will not be correctly posted on
      the second or subsequent saves. Be sure the data in the Meet Entry
      Sheet is final before saving.
      
         Another significant difference is that data from the other team
      competing in a dual meet can be entered and their scores calculated
      or reports generated. 
      
      
      1. Add or Edit Meet Entries
      
              This selection is used to begin or continue the process of 
         setting up a individual Meet Entry Sheet. The first step is the
         calculation of a swim team ladder. If one does not exist the
         program will generate one and save it to disk. If it does
         exist, you will have the option of recalculating it. If you
         have added meet results since the last time an Meet Entry Sheet
         was defined then you should recalculate.
      
              The second step is to produce a Swimmer Best Times report.
         This will follow the same steps as the swim team ladder. After
                                  Page 47
         this is completed you will select the meet for which you are
         building the Entry Sheet. The meet must be defined before the
         Entry Sheet can be completed.
      
              The next step involves completing the Meet Entry
         Information sheet. If the information sheet exists you will
         have the option to edit it or continue to the individual event
         sheets. See the Entry Information Sheet Form for details on the
         required and optional data.
      
              The final step in preparing the entry sheet is to select
         the swimmers for each event and, optionally, heat. Each event
         can have up to 4 heats. You will select each event and schedule
         the swimmers. You can input just your teams' members or if you
         have the information you can also enter the other teams' names.
         See the Schedule Swimmers Entry Form for details.
      
      
      2. Enter Times and Results
      
              This selection is used during or after the meet to enter
         the results of each event. The swimmers' time, status and,
         optionally, place and points are entered. See the Update
         Swimmers Entry Form for details.
      
      
      3. Delete Meet Entry Sheet
      
              This selection will remove all the files associated with
         a single meets' entry sheet. If the Save Entries to Database
         selection has been used then the swimmers' data will remain in
         the main database but the Entry Sheet for this meet will no
         longer be available. Each entry sheet will consist of multiple
         files named ENTRYmm.eeh where mm is the meet number, ee is the
         event number is hexadecimal and h is the heat number and one
         file named ENRTYmm.SES. You can leave these files in the
         database or archive them off to floppy disk if you prefer to
         retain them.
      
      4. Score Meet Entry Sheet 
      
              This selection will recalculate the place and points for
         each swimmer in an event based on their finishing time and
         status in the entry sheet and the points and scoring lanes in
         the event definition file for this season or meet. It will
         calculate across multiple heats for the same event. Note that
         whatever place or points you entered will be overwritten.
      
              This selection will only generate the proper results if you
         have entered the information for both teams in a meet.
      
      5. Swimmer Entry Report
      
              This will print a detailed report for either an individual
         swimmer or all swimmers showing what events with heat and lane
         they are entered in and totaling the individual and team events
         they will swim in for this meet. See the report itself for
         details.
                                  Page 48

      
      6. Event Entry Report
      
              This selection will print a detailed report for 1 or more
         events showing all data currently available, including swimmers
         scheduled, lane assignments, time and finishing place. It is
         similar to the Meet Entry Sheet report but does not include the
         point calculations and cover sheet with officials and point
         totaling. See the report itself for details.
      
      
      7. Print Meet Entry Sheet
      
              This selection will produce a complete report of the meet
         entry information. It can be used as the premeet entry sheet,
         to run the actual meet with swimmer names and spaces to time
         and score the meets and as a final record of the meet results
         after the event times are entered. See the report itself for
         details.
      
        
      8. Prepare Event Entry Cards
      
              This selection will prepare mailing labels with the
         information necessary for each swimmer to know what event, heat
         and lane they will be competing in for each meet. If their best
         time exists it will also appear on the label to allow the
         swimmer to quickly tell if their time has improved. See the
         description of the label itself for complete details.
      
      9. Prepare Meet Ribbons
      
              This selection will prepare mailing labels with the
         information necessary to prepare meet ribbons. Ribbons can be
         prepared for either team and for any range of events or numbers
         of finishing places. These labels differ from those available
         from the 'Label Format Reports' selection in that these are
         generated from the Meet Entry Sheet data.
      
      10. Save Entries to Database
      
              This selection will update the SwimBase swimmer and event
         databases with the results entered into the Meet Entry Sheet.
         Using this option is the equivalent of entering each
         individuals results in the 'Event Results, Add or Modify' menu.
      
              Before this selection is used you should insure that the
         data in the Entry Sheet is final and that all names, places and
         points are correct. If finishing times or places are changed
         then you can use this selection a second time to update the
         main databases but if a swimmer changes then the old swimmers'
         results will need to be deleted from the Event menu.
      
      11. Audit Meet Entry Sheet
      
              This selection will verify and if necessary correct the
         meet entry sheet files. When selected you will pick the meet
                                  Page 49
         that you which to validate and then each event will be
         recalculated for the proper swimmer assignments, lanes and
         number of events entered and the master entry file will be
         updated as appropriate.
      
              If you receive a message that says "Swimmer already
         entered" for an event and this is not the case use this
         selection to resolve the problem.  
                                                                        
                   
                  /======= Swimmer Ladder Results ========\
                  |                                       |
                  |  Swimmer Ladder Results File          |
                  |  already exists.                      |
                  |  Recalculate Ladder Results? Y/N [N]  |
                  |                                       |
                  |                                       |
                  \=======================================/
                                      
                             Swim Ladder Request
      
         Select 'Y' if swimmer results have been entered since the last
      time you created a new Meet Entry sheet. This will not produce any
      output to the screen or printer but will save multiple files named
      LADDER.nnn on the data disk which will be accessed by other
      processes during the development of the meet entry sheets and
      information.
      
                                                                        
         
                   /======= Swimmer Best Times ========\
                   |                                   |
                   |  Swimmer Best Times File          |
                   |  already exists.                  |
                   |  Recalculate Best Times? Y/N [N]  |
                   |                                   |
                   |                                   |
                   \===================================/
                                                                        
      
                             Best Times Request
      
         Select 'Y' if swimmer results have been entered since the last
      time you created a new Meet Entry sheet. This will not produce any
      output to the screen or printer but will save a file named
      SWIMMER.BST on the data disk which will be accessed by other
      processes during the development of the meet entry sheets and
      information.          
                   
                                                                        
                   
                                  Page 50
             /== Update or Change Entry Sheet Parameters ? ==\
             |                                               |
             |  Change Number of lanes, or                   |
             |  other meet parameters?                       |
             |  Change Current Entry Parameters Y/N [N]      |
             |                                               |
             |                                               |
             \===============================================/
                                                                        
                       Entry Sheet Parameters Request
      
         Select 'Y' if you wish to change the parameters and global data
      for a meet such as the number of lanes or names of meet officials. 
                 
      
      
      
/================= Enter or Update Information for Entry Sheet ===============\
| Heading : Test_Swim_Meet_Management_______________                          |
| Home Name : Calverton _____________ Visitor Name : Silver Spring_________   |
| Home Team (Y/N) ? : Y   Number of Lanes (6,8,10) : 6_                       |
| Ind Events (1-16) : 3_  Team Events (1-16) : 3_  Pool Length : 25_Meters_   |
| Home Lanes : 4_  : 6_ : 2_ : __: __ Visitor : 3_ : 5_ : 1_ : __ : __        |
|     Official Title          Name                      Name                  |
| : Referee_________________ : Joe_Hilel_____________ : Tom Ducan____________ |
| : Starter_________________ : Bob Bailey____________ : _____________________ |
| : Time_Recorder___________ : Mary Fernandez________ : Beth Daily___________ |
|                            : ______________________ : _____________________ |
| : Chief_Timer_____________ : Sally Sart____________ : Jonny Johnson________ |
|                            : ______________________ : _____________________ |
| : Stroke_and_Turn_Judges__ : Tom Tully_____________ : John Tully___________ |
|                            : Sam Sutter____________ : Jim Gibbs____________ |
| : Team_Representatives____ : ______________________ : _____________________ |
|                            : ______________________ : _____________________ |
| : Relay_Take_Off_Judges___ : ______________________ : _____________________ |
|                            : ______________________ : _____________________ |
| : Clerk_of_Course_________ : ______________________ : _____________________ |
| : Asst._Clerk_of_Course___ : ______________________ : _____________________ |
| : Coaches_________________ : ______________________ : _____________________ |
|                            : ______________________ : _____________________ |
|                            : ______________________ : _____________________ |
\=============================================================================/
      
                          Meet Entry Parameter Form
      
         This form is used to enter the global data for a meet entry
      sheet. The field descriptions follow.
      
      1. Heading
      
              The text enter here will appear at the top of each page of
         the Meet Entry Sheet. Optional field.
      
      2. Home Name 
      
              This is the name of the home team as it will appear in all
         meet entry reports. Note that this is the home team, not
         necessarily your team. Required field.
                                  Page 51
      3. Visitor Name
      
              This is the name of the visiting team as it will appear in
         all meet entry reports. Required field.
      
      4. Home Team (Y/N)
      
              Select Y if you are the home team at this meet, N if you
         are the visitor. This is used to determine which lanes your
         team will be swimming in. Required field.
      
      5. Number of lanes
      
              This is the number of lanes in the pool that can be
         assigned for this swim meet. The available options are 6, 8 or
         10. Required field.
      
      6. Ind Events
      
              This is the number of individual events that any single
         swimmer can be entered in. This is not strictly enforced but
         some warning messages will appear if this value is exceeded.
         Required field.
      
      7. Team Events
      
              This is the number of team (relay) events that any single
         swimmer can be entered in. This is not strictly enforced but
         some warning messages will appear if this value is exceeded.
         Required field.
      
      8. Pool Length
      
              This the length of the pool. This data will appear on the
         Meet Entry from but is not used for any calculations. Optional
         field.
      
      9. Home Lanes
      
              This is the numbers of the lanes that the home team will
         swim in the seeded order. If the home team gets lanes 1, 3 and
         5 and the top seed swims in lane 3 then enter 3, 5, 1. Required
         field.
      
      10. Visitor
      
              This is the numbers of the lanes that the visiting team
         will swim in the seeded order. If the visiting team gets lanes
         1, 3 and 5 and the top seed swims in lane 3 then enter 3, 5, 1.
         Required field.
      
      11. Official Title : Name : Name
      
              These 3 columns are used to list the meet officials. The
         first column is the title and the next 2 are the names. The
         titles have default values but can be changed or blanked out.
         This information is printed on the cover sheet of the meet
         entry sheet. Optional fields.
                                  Page 52

      
/LN SW#  Swimmer Name ====================    Home Team Lane   Calverton     \
| 1      Roberta_Dunn___________________                                     |
| 2 _20  Michelle_Chambliss_____________                                     |
| 3      Nancy_Quinn____________________                                     |
| 4 _18  Stephanie_Casper_______________                                     |
| 5      Renee_Roland___________________                                     |
| 6 _23  Kristin_Clanton________________                                     |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
\=========== Event 17   17 - Girls  8 & U   25M Backstroke   Heat #1 ========/
/LD# SW#  Swimmer Name              Time     Date   PL Age IE TE Scd=========\
| 1  20 Michelle Chambliss        00:23:45 05/25/92  1  7   1  0  Y          |
| 2  18 Stephanie Casper          00:23:45 06/12/92  1  7   1  0  Y          |
| 3  19 B.  Chambliss             00:24:45 06/12/92  2  8   1  0  Y          |
| 4  21 Stephenie Chan            00:26:45 06/12/92  4  7   0  0  N          |
| 5  22 S. Chan                   00:27:45 06/12/92  5  7   1  0  N          |
| 6  23 Kristin Clanton           00:28:45 06/12/92  6  8   0  0  N          |
| 7  24 Becky Conover             00:29:45 06/12/92  7  7   0  0  N          |
| 8  25 Jerri Conover             00:30:45 06/12/92  8  7   0  0  N          |
| 9  26 Michel Conover            00:31:45 06/12/92  9  8   0  0  N          |
|10  27 Chris Curry               00:32:45 06/12/92 10  8   0  0  N          |
\========== Swim Team Ladder for 17 - Girls  8 & U   25M Backstroke   =======/
      
                        Schedule Swimmers Entry Form
      
         This pair of forms will appear as each event and heat is
      scheduled from the Create Entry Sheet menu. The top window is where
      you will enter the swimmer information. The bottom is the data from
      the swim team ladder that will help you in your selection. 
      
         The top border of the top window shows the field headers (lane
      (LN), swimmers number (SW#) and Swimmers Name) on the left and
      which teams' lane the cursor is on to the right. The bottom border
      shows which event and heat is being scheduled.
      
         During input you will use the swimmers number if the swimmer
      being scheduled is from your team or just a return or 0 if the
      swimmer is from the other team. The swimmer's name will be
      automatically populated for your team and you must enter it for the
      other team. If the swimmers age is not correct for the event you
      will receive a warning window. To make this most useful you should
      run a Swimmer AgeUp before scheduling the meet.
      
         The bottom window shows the swim team ladder for this event.
      The first 30 entries are available by pressing the down or up arrow
      key to scroll forward or back 10 at a time. The top border shows
      the field descriptions. They are:
      
      1. LD#
      
              This is the swimmers relative position in the ladder.
      
                                  Page 53
      2. SW#
      
              This is the swimmer number to be used to schedule the
         swimmer. This field will only appear for the lanes that the
         swimmers from your team will be in, it will be blank for the
         other team. You can enter the swimmer by entering the swimmers'
         number, the first 1 to 3 characters of the swimmers' last name
         or the swimmers' last initial a space and the first initial. If
         the swimmers' partial last name or initials are shared by
         another member of the team then a swimmer pick list will be
         presented.
      
      3. Swimmer Name
      
              The swimmers name.
      
      4. Date
      
              This is the date that the swimmer set the time that is in
         the ladder.
      
      5. Time
      
              This is the swimmers top time in this event.
      
      6. PL
      
              This is the finishing place that the swimmer received for
         this time.
      
      7. Age
      
              This is the swimmers age as determined by the most recent
         Swimmer AgeUp.
      
      8. IE
      
              This is the number of individual events that this swimmer
         is scheduled for in this meet. The Scoring Basis (TYP in
         reports) field in the Event definition determines if an event
         is considered individual or team. TYP of 'I' or 'B' will
         increment this field. a TYP of 'T' will increment the 'TE'
         field.
      
      9. TE
      
              This is the number of team events that this swimmer is
         scheduled for in this meet. This is incremented if the event
         scoring basis (TYP) is 'T'.
      
      10. Sch
      
              This will be set to Y if this swimmer is already scheduled
         for this event. It is useful when scheduling multiple heats to
         see if this swimmer is already in this event.
      
                                  Page 54

                               /============\
                               |AutoSchedule|
                               |Entry  Sheet|
                               |============|
                               |     Yes    |
                               |     No!    |
                               \============/
      
                            Auto Schedule Request
      
         This requestor will appear the first time a Event/heat
      combination is entered. If Yes is selected the program will attempt
      to schedule the swimmers for your team in this event. It will use
      the seeded lane order and pick the first 3, 4 or 5 swimmers
      depending on the number of lanes available from the swim team
      ladder.
      
         It will take into account the maximum number of events each
      swimmer is allowed and their current age group. If a swimmer is in
      the ladder but has aged out of the age group they will not be
      scheduled. It schedules one event and heat at a time and the events
      can be done in any order.
      
         If there are no swimmer in the ladder that qualify for this
      event then no action will be taken.
      
      
/LN SW#  Swimmer Name                       Time   Status Place Points=======\
| 1 12   Chris Blick                       0:42:13    F    _2    _6.0        |
| 2 0    Joe Lane2                         0:44:12    F    _4    _2.0        |
| 3 34   Christine French                  0:43:11    F    _3    _4.0        |
| 4 0    Joe Lane4                         _:__:__    _    __    __._        |
| 5 42   Meghan Hampton                    _:__:__    _    __    __._        |
| 6 0    Joe Lane6                         _:__:__    _    __    __._        |
      
                         Update Swimmers Entry Form
      
         This form is used to enter the results for the swimmers entered
      in a event. It is accessed through the Update Meet Entry Sheet menu
      selection. The field descriptions are as follows:
      
      
      1. LN
      
              This is the lane that this swimmer was in.
      
      2. SW#
      
              This is the swimmer's number if the swimmer is from your
         team or 0 for the other team.
      
      
      3. Swimmer Name
      
              This is the swimmer's name.
      
      4. Time 
                                  Page 55

              This is the time for this swimmer.
      
      5. Status
      
              This is the finishing status for this swimmer. These values
         are the same as those used in the event data input form. 
      
      6. Place
      
              This is the finishing status for this swimmer. This field
         will be calculated by the program if you select the 'Score Meet
         Entry Sheet' selection.
      
      7. Points
      
              This is the points for this finishing place as calculated
         from the event definition file.
      
              The first time a finishing place is input this field will
         be automatically calculated. After it is calculated the program
         will only change it if you select 'Score Meet Entry Sheet' or
         manually override the point value. If the place is later
         changed the point value will not be automatically updated.
      
      
           /==================Note for Event 6   ==================\
           |                                                       |
           |   Card Note : ___________                             |
           |                                                       |
           \=======================================================/
            /=================== Review Label ====================\
            |        Barbara A. Wahl                              |
            |         6 - Girls  8 & U   25M FreeStyle            |
            |        Ev: 6    Ht: 1 Ln:  1 AT 6pm                 |
            |        BestTime BestDate LastTime Date              |
            |        00:43:21 05/25/92 03:54:05 07/07             |
            |                                                     |
            |                                                     |
            |       Print Label ? <Y>es, <N>o, <D>on't ask.       |
            \=====================================================/
      
                            Meet Entry Card Forms
      
         These 2 forms are used during the preparation of meet entry
      cards. The first form allows the entry of a short note that will
      appear on each entry card. If the note is used you will be prompted
      for a new note for each event. You can disable the note by blanking
      it out on the first event.
      
         The second form shows the entry card. It contains the swimmers
      name, the event, the heat number, if required, the lane, the note
      and the swimmer best and last time and date. You can select Y to
      print this label, N to skip it or D to stop asking and print all
      the labels. This label can be sent to either your printer or to a
      comma delimited file named 'ENTRYCRD.CDF".
      
      
                                  Page 56

              /=================== Review Label ====================\
              |        Barbara A. Wahl       Placed  2nd            |
              |        Ev: 6   in 00:23:51 on 05/25/92              |
              |         6 - Girls  8 & U   25M FreeStyle            |
              |        Swimming for: Calverton                      |
              |        Against: Silver Spring                       |
              |                                                     |
              |                                                     |
              |       Print Label ? <Y>es, <N>o, <D>on't ask.       |
              \=====================================================/
      
                              Meet Ribbon Forms
      
         This form shows the meet ribbon and allows the same printing
      selections as the previous label. The swimming for and against
      fields will be set according to which team the labels are for. 
      This label can be sent to either your printer or the a comma
      delimited file named 'EVENTRBN.CDF".
      
      
      /============ *** Delete Meet Entry Sheet Request *** ===========\
      |                                                                |
      |        The process you have selected will delete the Meet      |
      |        Entry Sheet information for the individual MEET         |
      |        you will select next from the Meet Selector.            |
      |                                                                |
      |        Please see the Users Manual for complete details.       |
      |                                                                |
      |                      /============\                            |
      \======================|  Continue  |  ==========================/
                             |Entry Delete|                             
                             |============|                             
                             |     Yes    |                             
                             |     No!    |                             
                             \============/                             
             
                            Entry Delete Request
      
         This requestor will appear when Delete Entry sheet is selected.
      If Yes is selected you will select which meet to remove the entry
      sheet information from.
      
      
      
                                  Page 57
/==    1 of    41, ESC,       Up Dn Home End <G>o <P>rint <S>earch <R>epeat =\
|                         Swimmer Entry Report             12/30/92 19:33:48 |
|              05/25/92 Dunkirk            Dunkirk                           |
|  1992     Test team                DG                            Page  1   |
|============================================================================|
| Swimmer                      Ind Events  Team Events                       |
| Evnum    Event                          Heat    Lane                       |
|----------------------------------------------------------------------------|
|Eric Attay                         1          1                             |
|5     5 - Boys   8 & U   25M FreeStyle    1       2                         |
|3     3 - Boys   Open   200M Med. Relay   1       2                         |
|Lauren Austin                      1          1                             |
|6     6 - Girls  8 & U   25M FreeStyle    1       4                         |
|4     4 - Girls  Open   200M Med. Relay   1       4                         |
|Meagan Austin                      0          1                             |
|4     4 - Girls  Open   200M Med. Relay   1       3                         |
|Chris Blick                        1          0                             |
|19   19 - Boys   9 - 10  25M Backstroke   1       3                         |
|Stephen Brinks                     1          0                             |
|19   19 - Boys   9 - 10  25M Backstroke   1       5                         |
|Stephanie Casper                   1          0                             |
|17   17 - Girls  8 & U   25M Backstroke   1       3                         |
|Bob Chambliss                      1          0                             |
|18   18 - Boys   8 & U   25M Backstroke   1       5                         |
\============================================================================/
      
                            Swimmer Entry Report
      
         This report will list all the events that a swimmer is entered
      in for this meet. It can be generated for a single swimmer or
      selected by Age Group and Gender.
      
      
/==    1 of    21, ESC,       Up Dn Home End <G>o <P>rint <S>earch <R>epeat =\
|                            Entry Event Report            12/30/92 19:34:22 |
|              05/25/92 Dunkirk          Dunkirk                             |
|  1992     Test team                DG                            Page  1   |
|============================================================================|
|   Event                          Heat                                      |
| Lane    Swimmer                                                            |
|----------------------------------------------------------------------------|
|===>  6 - Girls  8 & U   25M FreeStyle    1                                 |
|  1 Barbara A. Wahl                0:23:51 F  2                             |
|  2 Dana Halls                     0:33:41 F  4                             |
|  3 Erin Attlis                    0:43:12 F  6                             |
|  4                                                                         |
|  5 Lauren Aston                   0:53:24 F  7                             |
|  6 Tam Tall                       0:55:44 F  8                             |
|===>  6 - Girls  8 & U   25M FreeStyle    2                                 |
|  1 Tam Small                      0:23:62 F  3                             |
|  2 Ashley Brady                   0:22:76 F  1                             |
|  3 Jan Peters                     0:31:11 D  0                             |
|  4 Charline Beet                  0:42:13 F  5                             |
|  5 Ann Sharp                      0:00:00 N  0                             |
|  6 Nishe Krinski                  0:23:14 E  0                             |
|                                                                            |
|                                                                            |
      \============================================================================/
                                  Page 58

                             Event Entry Report
      
         This report will show the current details of one or more events
      in the meet. It will print just the lane numbers and names if
      requested before event results are entered or the complete event
      detail if requested afterwards.
      
      
      
/==   89 of   167, ESC,       Up Dn Home End <G>o <P>rint <S>earch <R>epeat =\
|                     Northern Clavert  Swimming League             Page  3  |
|Home Team:   Calverton               Visiting Team:   Silver Spring         |
|Meet Date: 05/25/92   Cumulative Score:  Home   42.0  Visitor   38.0        |
|----------------------------------------------------------------------------|
| Lane     Swimmer                      Time    Place   Home   Visitor       |
|============================================================================|
|Event 6      Heat 2    6 - Girls  8 & U   25M FreeStyle                     |
|----------------------------------------------------------------------------|
|  1  TOM SMALL                       00:23:62    3      3.0                 |
|  2  Ashley Brady                    00:22:76    1              6.0         |
|  3  JOE PETERS                      00:31:11   DQ      0.0                 |
|  4  Charlie Beet                    00:42:13    5              1.0         |
|  5  AL SHARP                                   NS      0.0                 |
|  6  Nishe Krinski                   00:23:14   EX              0.0         |
|----------------------------------------------------------------------------|
|Cumulative : Home   45.0 Visitor   45.0      Event:     3.0     7.0         |
\============================================================================/
      
                              Meet Entry Sheet
      
         This is a part of the Meet Entry Sheet. The report will have a
      cover page with the parameters and other information entered in the
      Create Entry form and then as many pages as required to detail each
      event that has been scheduled.
      
         The header of each page will show the competing team names, the
      date and the cumulative team scores. Each event will contain the
      cumulative score and the score for that event. The HOME TEAM
      swimmer names will be capitalized. 
      
         If the sheet is printed before the event data is entered it
      will allow places to enter the swimmers times and finish.
      
         If the Maximum and Minimum values are set in the event
      definitions then the points will be adjusted to reflect these
      values.
      
                                  Page 59

                         Report Menus and Requestors
      
      
                      /= F1 HELP === 08/22  15:57:43 \
                      |                              |
                      |           SwimBase           |
                      |         Reports Menu         |
                      |        Active season         |
                      |       --> TEST0123 <--       |
                      |                              |
                      |==============================|
                      |  Swim Team Roster            |
                      |  Event and Swimmer Times     |
                      |  Swimmer Places and Points   |
                      |  Label Format Reports        |
                      |  Swimmer Best Times          |
                      |  Meet Summary Report         |
                      |  Season Summary Report       |
                      |==============================|
                      |  Return To Season Main Menu  |
                      \==============================/
               
                                Reports Menu
      
         This menu accesses the reports section of the program. There
      are 5 sub-menus and 2 reports available from this menu. 
      
      The 5 sub-menus are:
      
       Swim Team Roster
      
       Event and Swimmer Times
      
       Swimmer Places and Points
      
       Label Format Reports
      
       Swimmer Best Times
      
      And the 2 reports are:
      
       Meet Summary Report
      
       Season Summary Report
      
         See the sub-menus for a description of the general
      classification of each report class. The reports that are included
      within each section are described with the reports themselves.
      
      
                                  Page 60
                          /=====================\
                          |                     |
                          | Select Roster Type  |
                          |                     |
                          |=====================|
                          | Full Roster         |
                          | Name and Address    |
                          | Home Telephone List |
                          | Full Telephone List |
                          | Swimmer List        |
                          | IF Info List        |
                          | Mailing Labels      |
                          | Swim Meet Roster    |
                          | Fee Status Report   |
                          |=====================|
                          | Exit Roster Reports |
                          \=====================/
      
                              Roster Type Menu
      
         This menu contains all the reports that are based on the
      swimmer data entered in the Swimmer entry menu. These reports have
      nothing to do with the results of the meets. See the reports
      themselves for greater detail.
      
                       /===== 08/22  15:57:51 ====\
                       |                          |
                       | Select Time Report Type  |
                       |                          |
                       |==========================|
                       | Swim Ladder, by Event    |
                       | Swim Ladder, by Swimmer  |
                       | Relay Leg Ladder, Event  |
                       | Stroke / Distance Ladder |
                       | Meet Results, by Event   |
                       | Meet Results, by Swimmer |
                       | Time In Water            |
                       | Swimmer Best Times       |
                       |==========================|
                       |    Exit Time Reports     |
                       \==========================/
               
                              Time Report Menu
      
         This report menu is based on the time results of the various
      events. See the actual reports for greater detail on each report.
      
      
                                  Page 61

                      /= F1 HELP = 08/22  15:57:54 \
                      |                            |
                      |  Select Place Report Type  |
                      |                            |
                      |============================|
                      | Team Summary               |
                      | Swimmer Summary, 1 Swimmer |
                      | Swimmer Summary, Full Team |
                      | Swimmer Detail, 1 Swimmer  |
                      | Swimmer Detail, Full Team  |
                      | Relay Detail, 1 Swimmer    |
                      | Relay Detail, Full Team    |
                      |============================|
                      | Exit Place Reports         |
                      \============================/
      
                              Place Report Menu
      
         This report menu is based on the place and points finish of the
      events. See the actual reports for greater detail.
      
                          /=====================\
                          |  Select Label Type  |
                          |=====================|
                          | Mailing Labels      |
                          | Meet Ribbons        |
                          | Meet Ribbons - Blank|
                          | Print Test Label    |
                          |=====================|
                          | Exit Label Reports  |
                          \=====================/
      
                          Label Format Report Menu
      
              These reports are designed to print on 1 up, 3 1/2 by 15/16
         mailing labels (Avery 4145 or equivalent) or to produce a comma
         delimited file (CDF) format report.
      
              The CDF files are intended to be imported to a user
         provided database or word processing program and then
         reformatted and printed. These CDF files will be left in the
         season data directory and can't be accessed or used from within
         SwimBase. The CDF file names are fixed and each new report will
         be appended to the old unless the old is deleted first.
      
              The file names are RIBBON.CDF for event ribbons and
         MAILLBL.CDF for swimmer data. The MAILLBL.CDF file contains
         almost all of the swimmers' data, not just the data that would
         normally appear on a mailing label.
      
              *** NOTE ***
      
              The Meet Ribbons selected and generated here will differ
         from those available in the Swim Meet Management menus in that
         these will come from the SwimBase Meet databases whereas the
         Meet Management Ribbons will come from the Meet Entry Sheets
         which may or may not have been updated into the Meet database. 
                                  Page 62

              The first label format report is a simple mailing label.
         You have the option of entering a fixed first line of text and
         then the next 3 lines will be the address information for each
         swimmer.
      
              The next 2 reports are meet ribbons. The first is used
         after the meet data is input and will generate labels with the
         swimmer, event, time, place and opponent. The second will
         generate blank labels that will simplify the manual preparation
         of ribbons during a meet.
      
              The last selection will print a test label in order to test
         and align your printer.
      
                              CDF file formats
      
              These are the data elements that comprise the CDF file
         formats. Note that these CDF files define the files generated
         from the Label Report Menu, not those defined in the Swim Meet
         Management Menu. 
      
         MAILLBL.CDF
      
              FIRSTNAME,MIDDLEINIT,LASTNAME,ADDRESS,CITY,STATE,ZIP,DOB
              ,SEX,IDINFO,MOTHERFIRSTNAME,MOTHERLASTNAME,FATHERFN
              ,FATHERLN,HOMEPHONE,ALTNPHONE,EMERPHONE,MOTHERWORKPHONE
              ,FATHERWORKPHONE,FEE
      
         RIBBON.CDF
      
              FIRSTNAME,MIDDLEINIT,LASTNAME,PLACE,EVENTNUMBER,TIME,DATE,
              RECORDFLAGS,EVENTNAME,TEAMNAME,OPPONENTNAME
      
         Any fields that are empty will be properly comma delimited, IE:
      a swimmer with no middle name would appear as: FIRST,,LAST.
      
              See the examples of the actual reports for greater detail
         on the labels.
      
                        / F1 HELP  02/16  23:38:15 =\
                        |                           |
                        | Select Best Time Report   |
                        |                           |
                        |===========================|
                        | Calculate Best Times      |
                        | Clear Best Time, All      |
                        | Clear Best Time, Swimmer  |
                        | Set Best Time, Swimmer    |
                        | Best Time Report, All     |
                        | Best Time Report, Swimmer |
                        | Best Time Report, Ladder  |
                        |===========================|
                        | Exit Best Time Reports    |
                        \===========================/
      
                             Best Time Report Menu
      
                                  Page 63
         This report menu is used to calculate, individually set or
      report the best time that a swimmer has obtained in any event. It
      differs from the other report menus in several ways.
      
      These differences are:
      
        The data to be reported can be entered or changed in this menu.
      
        Data from past seasons can be included. If you use 'Import
         Season DataBase' to bring the swimmers' data forward into this
         season then the Best Times for these swimmers will be retained.
      
        In all other reports the report data is updated as new event
         results are entered. That is not the case here. After entering
         event results the 'Calculate Best Times' selection will have to
         be used to update the best time data.
      
         The first four entries in this menu will be covered here, the
      last 2 are in the reports section.
      
      1. Calculate Best Times
      
              This selection will compute what a swimmer's best time was
         for each event they have competed in and what date it was swam
         and also what the most recent time was and the date it
         occurred. When selected you will have the choice of selecting
         all meets, a single meet or a single meet type.
      
              Once the data is calculated it is stored on disk and will
         be available for later review. It is only necessary to use this
         selection the first time the best time data is generated or
         when new data is entered. If data is entered for a single meet
         then only that meet needs to be selected when 'Calculate Best
         Times' is used.
      
      2. Clear Best Times, All
      
              This selection will delete the best times data for all
         swimmers on the team. The best time data for past seasons and
         this season will be removed. This WILL NOT delete any event
         results or meet data. If you are only keeping the data from a
         single season then clearing the data and then recalculating for
         all meets will restore the data. If you were keeping data from
         past seasons then that data will be lost.
      
              The primary use of this selection is to recreate the best
         time data if there have been changes made in previously entered
         event results. Remember, updating the event results does not
         automatically update the best times data.
      
      3. Clear Best Times, Swimmer
      
              This selection has the same impact on your data as the
         previous selection with the exception that it only will delete
         the data for the single swimmer that you will select from the
         swimmer select requestor.
      
                                  Page 64
      4. Set Best Time, Swimmer
      
              This selection will allow you the set the best and last
         time and date for a single swimmer. Its major use will be to
         input best times that were swum in previous seasons or in meets
         that are not being kept in this data base. See the 'Set Best
         Times Requestor' for field descriptions.
      
         /=================== Enter Data for BestTime ==================\
         |                                                              |
         | Swimmer Number : ________                                    |
         |                                                              |
         | Event Number : ____                                          |
         |                                                              |
         | BestTime : __:__:__     Best Time Date : __/__/__            |
         |                                                              |
         | LastTime : __:__:__     Last Time Date : __/__/__            |
         |                                                              |
         |                                                              |
         \==============================================================/
      
                          Set Best Times Requestor
       
      
      1. Swimmer Number
      
              This is the swimmer number. See the 'Event Entry Form' for
         details of the type entries allowed.
      
      2. Event Number
      
              This is the event number. See the 'Event Entry Form' for
         details of the type entries allowed.
      
      3. Best Time
      
              This is the best time that this swimmer has obtained in
         this event in mm:ss:hh format.
      
      4. Best Time Date
      
              This is the date that the swimmer swam his or her best
         time.
      
      5. Last Time
      
              This is the time for this swimmer the last time they swam
         this event. If this field is left empty then the Last Time and
         Last Date will be set to match the Best Time and Best Date.
      
      6. Last Time Date
      
              This is the date the last time occurred.
                                  Page 65

                              /============\
                              | Output DEV |
                              |============|
                              |   Screen   |
                              |  Printer   |
                              | Disk File  |
                              |============|
                              |   Cancel   |
                              |============|
                              \============/
      
                           Output Device Requestor
      
         This requestor is used whenever a report is generated to
      determine its destination. If Screen is selected then the report
      will be displayed on the screen and you can scroll or page through
      it or search for data. For a full description of what can be done
      here see the description of the Screen Viewer. The next selection
      is Printer and this will send the full report to the printer. The
      final selection is to send the report to a file. You will be
      prompted for a file name with an absolute or relative path name. If
      you select Cancel then no report will be generated.
      
             /====================================================\
             |                                                    |
             |      Enter Full or Relative Path and Filename      |
             |                                                    |
             | Report Filename : ________________________________ |
             |                                                    |
             \====================================================/
      
                             File Name Requestor
      
         This requestor will appear in response to the selection of
      'File' as the destination device for a report. You will need to
      enter either a file name or a file name with a relative or absolute
      path name. Some examples would be:
      
                  MYREPORT.RPT
                  SWIMDATA\REPORT.102
                  C:\TEMPDATA\SINKREPT
      
                               /============\
                               |   Gender   |
                               |============|
                               |    Both    |
                               |    Male    |
                               |   Female   |
                               |============|
                               |   Cancel   |
                               |============|
                               \============/
      
                              Gender Requestor
      
         This requestor will appear in response to the request for
      several different reports. The selection used will determine if the
                                  Page 66
      report will contain only male swimmers, female swimmers or all
      swimmers. If Cancel is selected or ESC is pressed then you will be
      returned to the report menu and no report will be generated.
      
                             /================\
                             |  Select Group  |
                             |=Group==LA=HA=G=|
                             |   All Groups   |
                             | 8 & U   1  8 B |
                             | 9 - 10  9 10 B |
                             |11 - 12 11 12 B |
                             |13 - 14 13 14 B |
                             |15 - 18 15 18 B |
                             |================|
                             |     Cancel     |
                             \================/
      
                         Swimmer Age Group Selector
      
         This selector will appear in any case that a Age Group needs to
      be selected. The first selection, All Groups, will select without
      regard to age group. The remaining selections will contain all
      active groups (0 to 15), the group description, low age (LA), high
      age (HA) and gender (G) which can be either 'B' for both, 'M' for
      male or 'F' for female.
      
         This is an example of the Group selector with the Preference
      selector for 7 age groups set to N.  
      
      
                               /============\
                               | Sort Order |
                               |============|
                               |    Name    |
                               |    Age     |
                               |    Sex     |
                               |============|
                               |   Cancel   |
                               |============|
                               \============/
      
                               Sort Requestor
      
         This requestor will appear in response to the request for most
      reports. The selection here will determine the order that the
      report is sorted. If name is selected then the report will be in
      Last name, First name order. Age will sort by age and sex will
      provide female and then male order. Like all requestors, this one
      can be canceled by selecting Cancel or pressing ESC.
                                  Page 67

                               /=============\
                               | Meet Select |
                               |=============|
                               |  All Meets  |
                               |  Meet Type  |
                               | Single Meet |
                               |=============|
                               |   Cancel    |
                               |=============|
                               \=============/
      
                            Meet Select Requestor
      
         This requestor will appear during the generation of certain
      reports to select if the report should include all meets, a
      particular meet type or a single meet. If Meet Type or Single Meet
      is selected then another requestor will be used to obtain your
      selection of type meet or specific meet.
      
                               /===========\
                               | Meet Type |
                               |===========|
                               |  A Meets  |
                               |  B Meets  |
                               |  T Meets  |
                               |===========|
                               |  Cancel   |
                               |===========|
                               \===========/
      
                             Meet Type Requestor
      
         This requestor will appear during the generation of certain
      reports to select the type of meet to be included in the report.
      The type letter is the meet type selected when the meet was
      defined.
      
                  /= F1 HELP ========= 03/06  15:00:53 \
                  |      Swimmer Select Criteria       |
                  |====================================|
                  |  All Swimmers on Team Included     |
                  |  Only Swimmers with Event Results  |
                  |====================================|
                  |               Cancel               |
                  |====================================|
                  \====================================/
      
                      Swimmer Select Criteria Requestor
      
         Some reports can consist of all swimmers or only swimmers that
      have results in the meet or meets selected. Use this selector to
      choose between all swimmers or swimmers with event results.
      
                           Event Names and Numbers
      
         All event names and numbers are user changeable with the
      'Modify Event Definitions' selection in the Opening Menu. Use the
                                  Page 68
      'Modify Event Definitions' selection to view or print a list of
      your event definitions.
         
                         Age Group Names and Numbers
      
         This is a list of the predefined age groups and their
      definitions. If you have elected to define your own age groups then
      when you need to select a particular age group a requestor will be
      generated that contains only the active age groups you have
      defined.
      
          No.          Age Group
      
         0             6 & Under*
         1             8 & Under 
         2             9 - 10       
         3            11 - 12
         4            13 - 14
         5            15 - 18
         6            15 - 16*
         7            17 - 18*
         8            SENIOR*
      
      * = Only available if 'Use 7 Age Groups' in the preference setup is
      set to Y.
      
      
      Event Group Names and Numbers
      
         This is a list of the assignable event groups and their
      definitions.
      
          No.          Event Group
      
         0            Freestyle
         1            Backstroke
         2            Breaststroke
         3            Butterfly
         4            Individual Medley
         5            Free Relay
         6            Medley Relay
         9            Do Not Care
      
                                  Page 69

      
                                   Reports
      
      
         The following pages contain examples of some of the reports
      available. To save space these are all partial reports. The actual
      report length will vary depending on the number of swimmers, meets
      and events entered.
      
         Each time a report is requested you will be prompted for the
      output device to send the report to. Some notes for each device:
      
                                   Screen
      
         When a report is to be displayed on the screen an internal file
      viewer is used to display the report. Once the report appears on
      the screen you can move through the report by using the cursor
      control keys or jumping to a line or by searching for data. The top
      line always contains a list of the keys that can be used to move
      around and status of what line is displayed at the top of the
      screen and the total lines in the file. If the beginning of the
      line is '1 of 239' then this means that line 1 is at the top of the
      screen and the file is 239 lines long. If the second field is ????
      then the file is over 400 lines long and the entire file has not
      been read yet.
      
         The arrow keys, Page Down and Page Up , Home and End work as
      their names imply. To search for data press 'S' and then enter the
      data to be searched for. To repeat the last search press 'R'. To
      print the current page press 'P'. When 'P' is pressed then you
      enter a concurrent printing mode that will print each new page or
      line displayed until 'P' is pressed again. To print a single page
      you would press 'P' twice. Press ESC at any time to exit.
      
         One additional note about viewing reports on the screen is
      necessary. The report is built in the SWIMDATA directory and could
      use up to 100,000 bytes for a large report. For this reason you
      should avoid using a data disk that is nearly full.
      
                                   Printer
      
         The report will be sent to the printer port or device as
      selected in the default setup. The port can be changed through the
      'Set or Change Defaults' selection in the opening menu. See that
      selection for further details on the printer port and setup
      parameters.
      
         The report will be formatted for a 80 column, 66 line page.
      This is a 8 1/2 by 11 inch page with a standard size font. A
      formfeed will be sent to the printer after each page. 
      
         There are 2 selections in the Default Setup that can effect the
      printing. The first is the printer setup string and the second is
      the selection of the extended character set. See the Default Setup
      selections for more information about these 2 fields.
      
                                  Page 70
                                  Disk File
      
         You will be prompted for a file name for the report. See the
      Output Device Requestor for file naming conventions. No facilities
      are provided within SwimBase to view or modify a report once it is
      sent to a file. You can use FVIEW.EXE to view the report after
      exiting SwimBase or by 'shelling' to DOS by entering ALT/A from any
      menu.
      
      
                                   Scoring
      
         The following rules are used to calculate the point totals on
      the reports. 
      
          The point totals for each place are defined when the events
         were setup with the 'Event Definition Setup'.  
      
          The number of finishers that earn points in an event are
         defined with the 'Event Definition Setup'.
      
          The points can be defined as 'Individual', 'Team' or 'Both'
         which determines how the points are accumulated for reports.
         Team points will not appear on individual reports.
      
          Ties are scored by splitting the point total for the 2 tied
         places between the swimmers. This is reflected in both the
         swimmer and team reports. Since the tie can be with a swimmer
         from the competing team fractional points are possible. 3 way
         ties are not supported.
      
          The Meet Summary and Season Summary report scoring is limited
         to a maximum of points for a given event as setup with 'Event
         Definitions'. If more than the maximum points are scored, such
         as a 1st, 2nd and 3rd place finish, then any points above the
         maximum are discarded. The full points are reflected in the
         individual swimmer reports.
      
      
      
                                  Page 71
      /================================================================\
      |              Meet Summary Report             03/16/91 09:18:44 |
      |  1990  OLNEY MILL            DIVISION F               Page  1  |
      |================================================================|
      |Loc. : HILLANDALE   Opp. : HILLANDALE Date : 06/16/90 Type : A  |
      |Report Includes : All Swimmers         All Groups               |
      |----------------------------------------------------------------|
      |Swimmers Competing :  63                                        |
      |Times in Water     : 152                                        |
      |Times 1st    :  21                                              |
      |Times 2nd    :  28                                              |
      |Times 3rd    :  36                                              |
      |Times 4th    :  24                                              |
      |Times DNP    :  43                                              |
      |Total Points     :  285                                         |
      |Points per Event : 1.875                                        |
      |Time per Event   : 0:57:64                                      |
      |Points per Swimmer : 4.524                                      |
      |Events per Swimmer : 2.413                                      |
      |----------------------------------------------------------------|
      \================================================================/
      
                             Meet Summary Report
      
         This report will summarize the results of a single Meet. The
      report can be generated for all swimmers and all groups or by
      selected gender and/or group. 
      
      
      1. Swimmers Competing 
      
              The number of swimmers included in the report that were
         entered in one or more events. Each swimmer will only be
         counted once, regardless of the number of events they
         entered. All four swimmers in a relay are counted.
      
      2. Times in Water 
      
              This is the total number of times a swimmer was entered
         in an event. The relay events as well as the individual
         events count as one.
      
      3. Times 1st 
      
              Number of first place finishes by this team. Both an
         individual and relay event will count as 1.
      
      4. Times 2nd, 3rd, 4th, nth
      
              Number of times a swimmers finished in these places.
      
      5. Times DNP 
      
              Times a swimmer finished in any place above those
         defined as scoring places in the global event definitions
         or was disqualified or no-showed.
      
                                  Page 72
      6. Total Points 
      
              Points earned by all team swimmers in this meet. 
      
      7. Points per Event 
      
              Total points divided by Events Entered.
      
      8. Time per Event 
      
              Average Time in Water for each event entered.
      
      9. Points per Swimmer 
      
              Total points divided by Swimmers Competing.
      
      10. Events per Swimmer  
      
              Events entered divided by Swimmers Competing.
      
      
      /=================================================================\
      |                    Season Summary Report      03/16/91 09:18:50 |
      |  1990     OLNEY MILL               DIVISION F         Page  1   |
      |=================================================================|
      |Report Includes : All Swimmers  All Groups  All Meets            |
      |-----------------------------------------------------------------|
      |Meets Summarized   :   3                                         |
      |Swimmers Competing :  94                                         |
      |Times in Water     : 380                                         |
      |Times 1st    :  62                                               |
      |Times 2nd    :  57                                               |
      |Times 3rd    :  67                                               |
      |Times 4th    :  50                                               |
      |Times DNP    : 144                                               |
      |Total Points     :  665                                          |
      |Points per Event : 1.750                                         |
      |Time per Event   : 0:50:63                                       |
      |Points per Swimmer : 7.074                                       |
      |Events per Swimmer : 4.043                                       |
      |-----------------------------------------------------------------|
      \=================================================================/
      
                            Season Summary Report
      
         This report will summarize the results of a season. The
      individual field definitions are the same as those used for the
      Meet Summary Report with one addition. The Meets Summarized field
      is the number of meets that this report includes data from, not the
      total number of meets in the season. As with the Meet Summary
      report you will be allowed to specify which age group and gender to
      include in the report. You can also select all meet types or just
      A, B or T meets.
      
      
                                  Page 73
      /================================================================\
      |                       Full Roster            08/26/90 08:43:19 |
      |  1990     OLNEY MILL       DIVISION F                Page  1   |
      |================================================================|
      |First Name   MI Last Name   Age    Group Sex         DOB        |
      |     Father's Name                 Mother's Name                |
      |   H Phone   W Phone         E Phone                            |
      |Address                                                         |
      |City            St.   Zip   Fee                                 |
      |================================================================|
      |Betsy       Anderson          7      8 & U      F  11/23/82     |
      |Dan                            Mary                             |
      |(301) 750-3411 (000) 000-0000 (000) 000-0000                    |
      |12313 Benesfield Rd.                                            |
      |Olney           MD   20832  0.00                                |
      |----------------------------------------------------------------|
      |Dan        Anderson         11     11 - 12      M  08/09/78     |
      |Dan                           Mary                              |
      |(301) 750-3411 (000) 000-0000 (000) 000-0000                    |
      |12313 Benesfield Rd.                                            |
      |Olney           MD   20832  0.00                                |
      
      Full Roster Report
      
         This report will show all the data entered about each swimmer.
      The first report block will contain the various field definitions
      and each following block will be the information for one swimmer.
      
      
      
      
      /================================================================\
      |               Swim Meet Roster               08/26/90 08:44:51 |
      |  1990  OLNEY MILL          DIVISION F                Page  1   |
      |================================================================|
      |  Swimmer Name \ Address         \ City     \ST\S\Ag\  DOB   \  |
      |================================================================|
      |Anderson, Betsy\12313 Blenefield \Olney     \MD\F\ 7\11/23/82\  |
      |Anderson, Dan  \12313 Blenefield \Olney     \MD\M\11\08/09/78\  |
      |Dane, Laura    \6312 Rundown Rd. \Olney     \MD\F\13\06/11/77\  |
      |Dane, Lindsay  \6312 Rundown Rd. \Olney     \MD\F\ 9\02/23/81\  |
      
                              Swim Meet Roster
      
         This report shows a single line of information for each
      swimmer. Requestors will allow selection of all swimmers, swimmers
      on a particular team (A, B or T), one or both genders or only a
      single age group. By combining the available options almost any
      group of the team can be printed as a single list.
      
                                  Page 74
      /=================================================================\
      |                         Swimmer List          08/26/90 08:44:27 |
      |  1990     OLNEY MILL         DIVISION F               Page  1   |
      |=================================================================|
      |Swimmer No.    Swimmer Name         Age   Group  Sex   DOB       |
      |=================================================================|
      |    1       Anderson, Betsy          7    8 & U   F  11/23/82    |
      |    2       Anderson, Dan           11   11 - 12  M  08/09/78    |
      |    3       Dane, Laura             13   13 - 14  F  06/11/77    |
      |    4       Dane, Lindsay            9    9 - 10  F  02/23/81    |
      |   99       Giswell, Cathe           7    8 & U   F  08/29/82    |
      
                                Swimmer List
      
         This report shows each swimmer's number, age, group, sex and
      DOB. This list is used to identify each swimmer's number for event
      data entry. This list is obtained by answering NO to the Show Names
      Only requestor.
      
      /=================================================================\
      |                         Swimmer List          03/17/91 13:23:08 |
      |  1990     OLNEY MILL         DIVISION F               Page  1   |
      |=================================================================|
      | No.  Swimmer Name   No.  Swimmer Name  No.  Swimmer Name        |
      |=================================================================|
      |  1 Anderson, Betsy   2 Anderson, Dan    3 Balt, Laura           |
      |  4 Balt, Lindsay    99 Bosnett, Cathe   5 Bosnett, Maura        |
      |  6 Bolt, Chistopher  7 Bolt, Matthew    8 Bullroll, James       |
      |  9 Bullroll, Mary   10 Bullroll, Timm  11 Bunit, Matthew        |
      
                          Swimmer List (Names Only)
      
         This report shows each swimmer's number. This list is used to
      identify each swimmer's number for event data entry. This list is
      obtained by answering YES to the Show Names Only requestor.
      
            /=================== Review Label ====================\
            |                                                     |
            |  To the parents of:                                 |
            |  Betsy Anderson                                     |
            |  12313 Blenefield Rd.                               |
            |  Olney, MD. 20832                                   |
            |                                                     |
            |                                                     |
            |       Print Label ? <Y>es, <N>o, <D>on't ask.       |
            \=====================================================/
      
                         Mailing Label Review Window
      
         This window will appear when the Mailing Labels report is
      selected. Each label will be displayed and you can choose to print
      it by pressing 'Y', to skip it by pressing 'N' or to print them all
      by pressing 'D'.
      
         Each label will consist of a user input line of text which
      defaults to "To the parents of:" on the first line and then the
      swimmer's name, address, city, state and zip.
         The printout is set for 1 up, 3 1/2 by 15/16 inch address
                                  Page 75
      labels. Avery Label stock number 4145 or equivalent.
      
      
      /=================================================================\
      |                        Telephone List         08/26/90 08:44:18 |
      |  1990     OLNEY MILL         DIVISION F               Page  1   |
      |=================================================================|
      |Swimmer Name            Parent's Names  Age   Home Phone         |
      |=================================================================|
      |Anderson, Betsy         Dan         Mary  7 (301) 570-4311       |
      |Anderson, Dan           Dan         Mary 11 (301) 570-4311       |
      |Dane, Laura             Timothy     Dian 13 (301) 774-4935       |
      |Dane, Lindsay           Timothy     Dian  9 (301) 774-4935       |
      
      
                               Telephone List
      
         This report will list each swimmer and the swimmer's parents'
      first names along with their home telephone numbers.
      
      
      /=================================================================\
      |                    Name and Address List      08/26/90 08:44:00 |
      |  1990     OLNEY MILL         DIVISION F               Page  1   |
      |=================================================================|
      |First Name       MI Last Name Age    Group    Sex   DOB          |
      |Address                                                          |
      |City                    St.   Zip   Fee                          |
      |=================================================================|
      |Betsy              Anderson    7      8 & U    F  11/23/82       |
      |12313 Blenefield Rd.                                             |
      |Olney                   MD   20832  0.00                         |
      |-----------------------------------------------------------------|
      |Dan                Anderson   11     11 - 12   M  08/09/78       |
      |18813 Blenefield Rd.                                             |
      |Olney                   MD   20832  0.00                         |
      
                            Name and Address List
      
         This report shows the name, address, sex, DOB and fee paid by
      each swimmer.
      
      
      /=================================================================\
      |                            Fee Status Report  08/26/90 08:45:02 |
      |  1990     OLNEY MILL               DIVISION F         Page  1   |
      |=================================================================|
      |Swimmer Name                                  Fee Paid           |
      |=================================================================|
      |Anderson, Betsy                                  10.00           |
      |Anderson, Dan                                     5.00           |
      |Dane, Laura                                      10.00           |
      
      Fee Status Report
      
         This report will show the total fee paid by each swimmer and
      the total fee collected by the team.
      
                                  Page 76

      
      /=================================================================\
      |               Individual Swimmer, Full Report 08/26/90 08:50:01 |
      |             Brown, Jimmy           Age Group 11 - 12            |
      |  1990     OLNEY MILL         DIVISION F               Page  1   |
      |=================================================================|
      |     Event Name        Status   Time     Place   Points          |
      |-----------------------------------------------------------------|
      |Meet -> 06/16/90 HILLANDALE   HILLANDALE  Type = A               |
      |-----------------------------------------------------------------|
      |23 - Boys 11 - 12 50M Backstroke    F   0:50:77   3    2         |
      |31 - Boys 11 - 12 50M Breaststroke  F   0:49:22   2    3         |
      
                       Individual Swimmer, Full Report
      
         This report will show a detailed list of all the events that a
      swimmer entered with their finishing place and points and a total
      summary line.
      
      
      /=================================================================\
      |       Individual Swimmer, Summary Report      08/26/90 08:47:21 |
      |      Brown, Jimmy                  Age Group 11 - 12            |
      |  1990     OLNEY MILL         DIVISION F               Page  1   |
      |=================================================================|
      |-----------------------------------------------------------------|
      | A Meet points = 8, B Meet points = 13, T Meet points = 0        |
      | 1st =  1, 2nd =  4, 3rd =  2, 4th =  0, DNP =  0                |
      |-----------------------------------------------------------------|
      
                     Individual Swimmer, Summary Report
      
         This report will show a summary of the number of events entered
      and the total points accumulated.
      
      /=================================================================\
      |                    Swimmer Relay Report       02/02/92 16:31:41 |
      |             Prety, Brittany                                     |
      |  1991     OLNEY MILL               DIVISION F         Page  1   |
      |=================================================================|
      |Enum      Event Name                Stroke      Time             |
      |-----------------------------------------------------------------|
      |Meet -> 06/22/91 Olney Mill   Rockville          Type = A        |
      |-----------------------------------------------------------------|
      |3     Boys   Open   200M Med. Relay  Back      1:21:22           |
      \=================================================================/
      
                      Individual Swimmer, Relay Report
      
         This report will show the relay leg details for an individual
      swimmer. The meet date, meet name, event details, stroke and split
      time are included. It does not contain details for the finishing
      place for this relay event or the status of the other swimmers in
      this event.
                                  Page 77

      /=================================================================\
      |       Swim Team Finish and Point Summary      08/26/90 08:46:03 |
      |              Summary for All Meets                              |
      |  1990     OLNEY MILL         DIVISION F               Page  1   |
      |=================================================================|
      |  Swimmer Name         Age   Meets 1st  2nd  3rd 4th DNP  Pts    |
      |-----------------------------------------------------------------|
      |Bolt, Chistopher        11    2     0    0    2   1   3     5    |
      |Bolt, Matthew           10    3     0    0    0   1   1     1    |
      |Brown, Jimmy            11    5     1    4    2   0   0    21    |
      
                     Swim Team Finish and Point Summary
      
         This report will show the times placing and points for the
      team. It can be generated for the full season or a type of meets or
      for a single meet. The 'Meets' column is the number of meets this
      swimmer was entered in. A single swimmer's results can span
      multiple lines depending on the number of places generate points.
      
      
      /=================================================================\
      |                 Time In Water                 08/26/90 08:45:52 |
      |  1990     OLNEY MILL         DIVISION F               Page  1   |
      |=================================================================|
      | Meet Date -> 06/16/90  07/14/90                      Average    |
      |-----------------------------------------------------------------|
      |EVENT #1  - Boys  12 & U  100M Ind. Medley                       |
      |Swimmer 1      1:38:38   1:35:60     NS     NS       1:36:99     |
      |Swimmer 2      1:45:67   1:43:70     NS     NS       1:44:68     |
      |Swimmer 3      1:47:49   1:46:62     NS     NS       1:47:05     |
      |Average        1:43:84   1:41:97     NS     NS       1:42:90     |
      
      
                                Time in Water
      
         The Time in Water report takes the times of the first 3
      finishers in each event and calculates the averages for each event,
      each meet and for the entire set of selected meets. The meets to be
      summarized in this report can be selected in three different
      fashions by using the Select Meets requestor. The first selection
      will do all meets in the season or the first ten meets if more that
      10 meets are defined. The second will select the first 5 type 'A'
      meets and the last will allow you to select which meets to
      summarize but again with a limit of 10 meets.
      
         NS in any field indicates that there was no result for a
      swimmer in that event and place. If only 1 swimmer from this team
      had a time then Swimmer's 2 and 3 will be NS. If there were 2
      Swimmers then 3 will be NS. Swimmers 1, 2 and 3 aren't the swimmers
      that finished in places 1, 2 and 3 but are the first 3 finishers
      from this team.
      
                                  Page 78
                        /=====================\
                        |    Select Meets     |
                        |=====================|
                        | All Meets (10 Max.) |
                        | First 5 A Meets     |
                        | Custom Select Meets |
                        |=====================|
                        |       Cancel        |
                        |=====================|
                        \=====================/

                     Time in Water Select Requestor

                        /=== Meets Selected ====\
                        |A Rockville   06/22/91 |
                        |B Quail Valle 06/26/91 |
                        |A Stonegate   06/29/91 |
                        |T Time trial- 06/17/91 |
                        |T ALL-STAR TI 06/14/91 |
                        |B Upper Count 07/03/91 |
                        \=======================/

                        Meets selected requestors.
      
      
      
      
      /=================================================================\
      |        Single Meet Results, by Swimmer        08/26/90 08:45:39 |
      |   06/16/90 HILLANDALE         HILLANDALE   Type = A             |
      |  1990     OLNEY MILL        DIVISION F                Page  1   |
      |=================================================================|
      |Swimmer        \ Free   \ Back   \Breast  \   Fly    \    IM    \|
      |-----------------------------------------------------------------|
      |Bolt, Chris    0:40:15 5\ NE     \ NE     \0:21:56  3\   NE     \|
      |Bolt, Matt     \ NE     0:23:62 4\ NE     \   NE     \   NE     \|
      
                       Single Meet Results, by Swimmer
      
         This report shows the time and finish place for each swimmer in
      a meet in the 5 event groups listed. If the swimmer has competed in
      more than one event of a particular group, (EX: 2 freestyle
      events), then only the highest numbered event will appear in this
      report. The report is laid out by swimmer. NE stands for Not
      Entered.
      
                                  Page 79
      /=================================================================\
      |         Single Meet Result, by Event          08/26/90 08:45:30 |
      |   06/16/90 HILLANDALE         HILLANDALE         Type = A       |
      |  1990     OLNEY MILL        DIVISION F                Page  1   |
      |=================================================================|
      |   Swimmer Name                  Time    Place   Points          |
      |-----------------------------------------------------------------|
      |Event # 1 - Boys  12 & U  100M Ind. Medley                       |
      |  Lester, Michael               1:38:38     2       3            |
      |  Brown, Matthew                1:45:67     E       0            |
      |  Leshards, Raymond             1:47:49     3       2            |
      |  Pulman, Kevin                 1:51:99     4       1            |
      
                        Single Meet Result, by Event
      
         This report shows the results of a single meet laid out by
      event order.
      
      
      /=================================================================\
      |                       Swim Team Ladder        08/26/90 08:45:13 |
      |  1990     OLNEY MILL               DIVISION F         Page  1   |
      |=================================================================|
      |      Swimmer Name                  Time     Meet    Place       |
      |-----------------------------------------------------------------|
      |EVENT # 1 - Boys  12 & U  100M Ind. Medley                       |
      | 1.  Lester, Michael               1:35:60  07/14/90   1  *R*A   |
      | 2.  Rampbelt, Chris               1:39:35  06/20/90   S  *A     |
      | 3.  Pulman, Brian                 1:40:34  06/20/90   0         |
      | 4.  Bolt, Chistopher              1:43:70  07/14/90   5         |
      | 5.  Newlmeyer, John               1:44:81  06/20/90   1         |
      | 6.  Browm, Matthew                1:45:67  06/16/90   E         |
      | 7.  Richards, Jimmy               1:47:02  06/20/90   3         |
      | 8.  Richmond, Raymond             1:47:49  06/16/90   3         |
      | 9.  Pulman, Kevin                 1:51:99  06/16/90   4         |
      |10.  Franlin, Neal                 1:58:14  06/20/90   6         |
      |11.  James, Gregory                1:58:72  06/20/90   0         |
      |EVENT # 2 - Girls 12 & U  100M Ind. Medley                       |
      | 1.  Hammonds, Kari                1:39:84  07/14/90   3         |
      | 2.  Stratizartsi, Jackie          1:45:72  07/14/90   5         |
      | 3.  Flesheman, Katie              1:46:80  07/14/90   6         |
      | 4.  Columbi, Michelle             1:49:88  06/16/90   6         |
      
                            Swim Ladder, by Event
      
         This report shows the best finishing time of each swimmer in an
      event sorted by event and finishing time. This report includes the
      results of all meets in a season with the top 64 finishers.
      
         If the swimmers result ends in *R then this time has met or
      bettered the Record Time entered in the Event Definition. If it
      contains *A then the AllStar time has been met or bettered.
      
                                  Page 80
      /=================================================================\
      |                     Swimmer Event Ladder, Individual 06/17/91   |
      |  1990     ROLLING HILLS            DIVISION F         Page  1   |
      |=================================================================|
      |   Swimmer Name                                                  |
      |Enum                     Event        Meet     Time     Place    |
      |-----------------------------------------------------------------|
      |Anderson, Betsy                                                  |
      | 2       Girls 12 & U  100M Ind. Medley 06/16/90 1:11:11 T1 *R*A |
      | 2       Girls 12 & U  100M Ind. Medley 06/16/90  2:12:12 3      |
      | 3       Girls  Open   200M Med. Relay  LEG 2 Back   01:21:22    |
      | 8       Girls  9 - 10  50M Med. Relay  06/16/90  0:13:10 2      |
      | 8       Girls  9 - 10  50M FreeStyle   06/16/90  1:11:11 4      |
      | 34      Girls 13 - 14  50M Breaststroke06/16/90  1:23:11 1      |
      
                           Swim Ladder, by Swimmer
      
         This report shows the 2 top finishes for either an individual
      swimmer or for the entire team. The report is sorted by swimmer
      with all meets checked and the best 2 finishes for each event the
      swimmer entered listed.
      
         Note that the results for event 3 are not from the overall
      result of that event but are a relay leg split time. This indicates
      that Betsy swam leg 2 using the backstroke and her split time was
      01:21:22.
      
      
      |                       Relay Leg Ladder               02/01/93 20:09:19
      |  1992     Test team          DG                              Page  1
      |========================================================================
      |      Swimmer Name                      Split Time Meet Date
      |------------------------------------------------------------------------
      |EVENT #3     3 - Boys   Open   200M Med. Relay   Freestyle
      | 1.  Wahl, Bobbie T.                     00:12:34  02/02/93
      | 2.  Austin, Larry                       00:23:45  02/02/93
      | 3.  Teel, Charlie                       00:23:45  02/02/93
      | 4.  Rradshaw, Cayce                     00:23:45  02/02/93
      | 5.  Buckfelder, Robert                  00:23:45  02/02/93
      |EVENT #3     3 - Boys   Open   200M Med. Relay   Backstroke
      | 1.  Cailley, Elliott                    00:12:34  02/02/93
      | 2.  Teel, Daniel                        00:12:34  02/02/93
      | 3.  Rrinks, Stephen                     00:12:34  02/02/93
      | 4.  Casper, Stephen                     00:12:34  02/02/93
      | 5.  Wataya, K.C.                        01:11:11  02/04/93
      |EVENT #3     3 - Boys   Open   200M Med. Relay   Breaststroke
      | 1.  Austin, Morgan                      00:10:11  02/02/93
      | 2.  Cailley, Elliott                    00:23:44  02/02/93
      | 3.  Bortun, Nishe                       00:23:44  02/02/93
      | 4.  Yrock, Laurel                       00:23:44  02/02/93
      | 5.  Phambliss, Bob                      00:23:44  02/02/93
      
      
                              Relay Leg Ladder
      
         This report will include the split times for each relay event
      sorted by stroke and time. For each medley relay there will be four
      sections, one for each stroke. For a free relay there will be just
                                  Page 81
      a single section. The teams finishing time and place are not
      considered during the generation of this report, just the
      individual split times.
      
      
      
      |                  Stroke and Distance Ladder          02/02/93 04:00:52
      |            Distance: 25M      Stroke: Freestyle
      |  1992     Test team                DG                        Page  1
      |========================================================================|
      |      Swimmer Name                 Age  Event    Time      Date
      |------------------------------------------------------------------------|
      | 1.  Glick, Chris                   10   20    00:24:45  01/09/93
      | 2.  Than, Stanley                  10   19    00:25:45  01/09/93
      | 3.  Grinks, Stephen                 9   20    00:26:45  01/09/93
      | 4.  Conway , Brian                  9   19    00:27:45  01/09/93
      | 5.  Conway , Jason                  9   19    00:28:45  01/09/93
      | 6.  Tonover, Michael                9   19    00:29:45  01/09/93
      | 7.  Ginkel, Mary                    9   19    00:35:45  01/09/93
      
                         Stroke and Distance Ladder
      
         This ladder is generated not by any particular event but by the
      gender, swimmer and event age group, distance and stroke. 
      
         The major purpose of the report is to allow the generation of
      reports that combine various events and age groups. It is possible
      to generate a report that will show you who are the best 100M
      freestyle swimmers without having to search each individual event
      and combine the results manually. 
      
         In order to generate the report you will need to select values
      from 6 selection menus. The first 2, output device and gender, are
      the same ones you have seen in many other reports.
      
         The next 2 allow you to select the age groups for this report.
      The first is the swimmers' age group at the time the report is
      generated. If Billy swum in a 10 and Under event and then aged up
      to 12 and Under a report with the Swimmer Age Group set to 10 and
      Under would not include Billy. The next is the age group of the
      event as set in the event definitions. In the same case with Billy
      he would appear if the 10 and Under event was selected because he
      did swim in it.
      
         The last 2 select the distance and stroke for the event as set
      in the event definitions. 
      
                                  Page 82
         The relay events are not considered during the generation of
      this report.
      
      
      
      
      | Swimmer Best Times, All Age Groups      02/16/92 23:41:13       |
      |  1991     HILLY MILL               DIVISION F         Page  2   |
      |=================================================================|
      |   Swimmer Name                                                  |
      |Enum            Event         BestTime BestDate LastTime LastDate|
      |=================================================================|
      |Anderson, Robert                                                 |
      |17 Boys 8 & U 25M Backstroke 00:34:40 07/17/91 00:34:40 07/17/91 |
      |Boswell, Charleen                                                |
      |6- Girls 8 & U 25M FreeStyle 00:32:12 07/03/91 00:35:49 07/10/91 |
      |18- Girls 8 & U 25M Backstk  00:31:29 07/10/91 00:31:29 07/10/91 |
      |Boswell, Michael                                                 |
      |8- Girls 9 - 10 50M FreeSty  00:53:93 07/03/91 00:53:93 07/03/91 |
      \=================================================================/
      
                          Swimmer Best Times Report
      
         This report is the best time and date and last time and date
      for each swimmer on the team. The report will include every event
      for every swimmer that has event results with 2 exceptions. It will
      not include any events where the swimmer does not have a finishing
      time, IE: a disqualification, and it will not include data for the
      relay events if these events are setup as relays in the event
      setup.
      
         When this report is selected you will have to option of several
      different sort methods and which genders and groups to include in
      the report.
      
         This same report is available for an individual swimmer also.
      
                    Custom Requirements and Enhancements
      
         Words to Go would like to hear of any requirements that your
      team or league has that are not supported by SwimBase. Depending on
      the nature of the changes they may be added into the next release.
      
         Requests for custom programming to tailor SwimBase to your
      particular needs will also be evaluated.
      
      
                               Error Handling
      
         The three most likely sources of errors when using SwimBase are
      insufficient free disk space, insufficient free ram space and disk
      hardware errors. Depending on when and where the error occurs will
      determine how the error will be handled by the program. In some
      cases a warning will appear that will allow you to correct the
      error before continuing. When more serious errors occur the program
      will forbid the offending action or force the program to exit. Some
      examples with suggested corrective action follows.
      
                                  Page 83
                   /== Insufficient Free Disk Space ==\
                   |                                  |
                   |  Disk Space Available LESS       |
                   |  than space required (143,000)   |
                   |                                  |
                   |                                  |
                   |           Press Return           |
                   \==================================/
      
                           Disk Free Space Warning
      
         This warning occurs if an attempt is made to create a new
      season or meet on a disk with less than the required space. The
      space required varies with the number of meets planned. The
      corrective action is to erase some files off the disk or use a new
      disk. The 'ABOUT SWIMBASE' selection can be used to gain more
      information about the disk free space.
      
      
      Program Directory    :   C:\BC\SRC\SWIM\ 
      Data Directory       :   C:\SWIMDATA     
      Data Disk Memory Free:   3,133,440 bytes
      Ram Memory Free      :   249,680 bytes
      Stack Memory Free    :   11,898 bytes
      Ram Heap Check       :   HEAP OK  DOS Version 5.00
      
                          About Swimbase Statistics
      
         This is a partial screen from the About SwimBase screen. The
      last 4 items are of interest when trying to correct error
      conditions. The disk free required to create a season or view a
      large report on the screen is around 150,000 bytes. Ram memory
      should remain above 100,000 bytes to view reports. Stack free
      should stay above 4,000 bytes and the Heap check should always be
      HEAP OK. The disk space can be corrected by erasing files off the
      disk. If the last 3 fail to meet requirements then there is most
      likely a conflict with a memory resident program that was loaded
      before SwimBase was started.
      
      
      
            /============= Database Audit found Errors ============\
            |                                                      |
            |  Record #3 contains 8 errors                         |
            |  ACTIVE,LNAME,FNAME,MINIT,AGE,SEX,PSRECNO,PSSRECNO,  |
            |  Continue running Audit or EDIT Y/N/E [N]            |
            |                                                      |
            |                                                      |
            \======================================================/
      
                            DataBase Audit Errors
      
         This requestor will appear if the database audit finds a
      problem with the database. It is bad news, the worst, oh horror of
      horrors, but seriously folks here's what we do. This could have
      been caused by a disk drive error or a bad spot on your disk or a
      wild write caused by a power surge. You have three possible ways to
      proceed. Select N and the audit will stop here. Select Y and the
                                  Page 84
      audit will continue to the next error or until complete. Select E
      and you can edit and update the offending record.
      
         The best course of action would be to restore a previously
      archived season data file. If one error is found it is possible
      that others are there and the accuracy of the data could be
      compromised.
      
      
              /============= DISK ACCESS FAILURE ============\
              |                                              |
              |  Error: drive not ready on Drive A:          |
              |  Insert Proper Disk                          |
              |  Select: <A>bort, <R>etry or <I>gnore [R]    |
              |                                              |
              |                                              |
              \==============================================/
      
                             Disk Access Failure
      
         This requestor will appear if there is a problem with the disk
      drives or disks themselves. The first line will indicate what the
      error was and which drive was involved. The error shown is caused
      by changing the data path to the A: drive when no disk is in the
      drive. The proper course of action is to either correct the error
      and select R or select I and then pick another drive or path.
      Selection A will almost certainly cause the program to crash.
      
                             Can't View Reports
      
         The most likely cause of this failure is insufficient free
      space on the data disk. Be sure that the data directory has at
      least 100,000 bytes of free disk space. This can be checked in the
      About SwimBase screen.
                                  Page 85

      
                                  Warranty
      
      
         Words to Go warrants the physical diskette(s) and physical
      documentation provided with registered versions to be free of
      defects in materials and workmanship for a period of ninety days
      from the date of registration.  If Words to Go receives
      notification within the warranty period of defects in materials or
      workmanship, and such notification is determined by Words to Go to
      be correct, Words to Go will replace the defective diskette(s) or
      documentation. 
      
         The entire and exclusive liability and remedy for breach of
      this Limited Warranty shall be limited to replacement of defective
      diskette(s) or documentation and shall not include or extend to any
      claim for or right to recover any other damages, including but not
      limited to, loss of profit, data, or use of the software, or
      special, incidental, or consequential damages or other similar
      claims, even if Words to Go has been specifically advised of the
      possibility of such damages.
      
         In no event will Words to Go's liability for any damages to you
      or any other person ever exceed the lower of suggested list price
      or actual price paid for the license to use the software,
      regardless of any form of the claim. 
      
         Words to Go specifically disclaims all other warranties,
      express or implied, including but not limited to, any implied
      warranty of merchantability and/or fitness for a particular
      purpose.
      
                                  Page 86

      
                                   Support
      
         Support will be provided for a period of 90 days from the date
      of purchase. This support can be obtained by phone (301-855-6427,
      45 minute connect time limit), by US Mail (see address inside front
      cover) or by EMail (Compuserve, 76515,1510, or Prodigy, MXVN00A). 
         
      
                                  Copyright
      
         This software is protected by United States copyright law. This
      software can only be used on ONE computer at any given time. It can
      be moved from one computer to another so long as it cannot be used
      on more than one computer at any given time. Backup copies can be
      made for archival purposes. Refer to the included document file
      'LICENSE.DOC' for further information.
      
                                ASP Ombudsman
      
         This program is produced by a member of the Association of
      Shareware Professionals (ASP).  ASP wants to make sure that the
      shareware principle works for you. If you are unable to resolve a
      shareware-related problem with an ASP member by contacting the
      member directly, ASP may be able to help. The ASP Ombudsman can
      help you resolve a dispute or problem with an ASP member, but does
      not provide technical support for members' products. Please write
      to the ASP Ombudsman at 545 Grover Road, Muskegon, MI 49442 or send
      a CompuServe message via CompuServe Mail to ASP Ombudsman
      70007,3536.
      
                           Definition of Shareware
      
         This program is distributed as Shareware. Shareware
      distribution gives users a chance to try software before buying it.
      If you try a Shareware program and continue using it, you are
      expected to register. Individual programs differ on details -- some
      request registration while others require it, some specify a
      maximum trial period. With registration, you get anything from the
      simple right to continue using the software to an updated program
      with printed manual.
      
         Copyright laws apply to both Shareware and commercial software,
      and the copyright holder retains all rights, with a few specific
      exceptions as stated below. Shareware authors are accomplished
      programmers, just like commercial authors, and the programs are of
      comparable quality. (In both cases, there are good programs and bad
      ones!) The main difference is in the method of distribution. The
      author specifically grants the right to copy and distribute the
      software, either to all and sundry or to a specific group. For
      example, some authors require written permission before a
      commercial disk vendor may copy their Shareware.
      
         Shareware is a distribution method, not a type of software. You
      should find software that suits your needs and pocketbook, whether
      it's commercial or Shareware. The Shareware system makes fitting
      your needs easier, because you can try before you buy. And because
                                  Page 87
      the overhead is low, prices are low also. Shareware has the
      ultimate money-back guarantee -- if you don't use the product, you
      don't pay for it.
      
      Disclaimer - Agreement 
      
         Users of SwimBase must accept this disclaimer of warranty:
      "SwimBase is supplied as is.  The author disclaims all warranties,
      expressed or implied, including, without limitation, the warranties
      of merchantability and of fitness for any purpose. The author
      assumes no liability for damages, direct or consequential, which
      may result from the use of SwimBase."
      
         SwimBase is a "shareware program" and is provided at no charge
      to the user for evaluation.  Feel free to share it with your
      friends, but please do not give it away altered or as part of
      another system.  The essence of "user-supported" software is to
      provide personal computer users with quality software without high
      prices, and yet to provide incentive for programmers to continue to
      develop new products.
      
         If you find this program useful and find that you are using
      SwimBase and continue to use SwimBase after a reasonable trial
      period, you must make a registration payment of $49.00 to Donald L.
      Wahl.  The $49.00 registration fee will license one copy for use on
      any one computer at any one time.
      
         You must treat this software just like a book. An example is
      that this software may be used by any number of people and may be
      freely moved from one computer location to another, so long as
      there is no possibility of it being used at one location while it's
      being used at another. Just as a book cannot be read by two
      different persons at the same time.
      
         Commercial users of SwimBase must register and pay for their
      copies of SwimBase within 60 days of first use or their license is
      withdrawn.  Site-License arrangements may be made by contacting
      Words to Go. 
      
         Anyone distributing SwimBase for any kind of remuneration must
      first contact Words to Go at the address below for authorization.
      This authorization will be automatically granted to distributors
      recognized by the (ASP) as adhering to its guidelines for shareware
      distributors, and such distributors may begin offering SwimBase
      immediately (However Words to Go must still be advised so that the
      distributor can be kept up-to-date with the latest version of
      SwimBase.).  You are encouraged to pass a copy of SwimBase along to
      your friends for evaluation.  Please encourage them to register
      their copy if they find that they can use it.  All registered users
      will receive a copy of the latest version of the SwimBase system.
      
                                  Page 88

      
                                   Pricing
      
      
      Single use license . . . . . . . . . . . . . . . . . . . . $49.00
      
         Software can be used on only 1 computer at any time.
         Includes latest disks and printed manual.
      
      
      Team use license . . . . . . . . . . . . . . . . . . . . . $80.00
      
         Software can be used on any number of computers for the
         SAME TEAM. Includes one copy of latest disks and one
         printed manual.
      
      
      League license (per team in league [Min. 30]). . . . . .$30.00 ea
      
         Equivalent to Single use license in usage rights for each
         team. Includes 1 copy of disks and manual per team
         licensed.
      
      
                                  Page 89

