;*************************************************************************
;* HQSTOCK.ASP     1991 RazorLogic Systems                               *
;*                                                                       *
;* A  Procomm script file for downloading historical quotes for the      *
;* most recent year of daily stock data.                                 *
;*************************************************************************
;
; In setting THE_SYMBOL use the following prefixes before the stock
; symbol to get the quote from a specific exchange:
;                1       New York
;                2       American
;                3       Pacific
;                4       MidWest
;                7       Nasdaq
;                8       Nasdaq NMS bid/ask format (don't use this one
;                           if you want HQCON to work)                  
;************************************************************************



DEFINE HISTQUOTE ";"       ; Use the semicolon instead of //HQ
STRING THE_SYMBOL            ; Stock Symbol for Historical Quotes
STRING THE_FILE              ; File name for screen capture file
INTEGER I

PROC MAIN
CLEAR
LOCATE 0 0
BOX 0 0 4 25 14
ATSAY 2 2 14 "HQ on a stock......"

ATSAY 7 10 5 "ENTER STOCK SYMBOL (e.g. 1IBM): "
ATGET 7 44 15 5 THE_SYMBOL 
ATSAY 8 10 5 "ENTER LOG FILE NAME (e.g. IBM.DMP): "
ATGET 8 48 15 8 THE_FILE 

LOCATE 10 0

LOG OPEN THE_FILE

PAUSE 2
TRANSMIT HISTQUOTE       ; Only need semicolon for the first time for //hq
TRANSMIT THE_SYMBOL      ; then just a return for each previous 12 trading
TRANSMIT " P1^M"         ; days.

I == 1
  WHILE I < 22
    INC I 
     WAITFOR "^^" 10       ; waits for DJNS record separator or 10 secs.
     TRANSMIT "^M" 
  ENDWHILE

LOG CLOSE

ENDPROC