{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}
{ This program creates calendars to be used in Ventura Publisher. The
  file is created in ASCII format, but may be imported to VP as if it
  were in Wordstar format. Parts of this program were written by Bob
  White. The part of the program that actually generates the calendar
  were written by an unknown author. That part of the program was
  gotten as public domain.

  This program is actually a program within a program. I found a small
  (1024 byte program) that would generate a calendar for a specified
  month and year. This program wrote its output to the screen, so I
  initially just redirected the program's output to a file, then
  wrote a program that read that file and modified it as needed. That
  process was a bit slow, so I investigated other ways of accomplishing
  the same thing.

  The procedure I eventually settled on was to incorporate the program
  into the program that created the final output. The original
  CALENDAR.COM program is below in the data statement and could be
  recreated in its entirity by writing it out to disk byte by byte.
  I figured out how to redirect output from standard output (i.e.,
  the console) to a disk file and back to the console again. So,
  basically, what the program does is to load Calendar.Com into
  memory, making the few changes it needs to run properly, stuff
  the desired month and year into the places Calendar.Com expects
  to find it, redirects output to a file, then call the program as if
  it were a subroutine. After Calendar.Com finishes, the program
  continues and opens the file, reads the calendar data, reformats it
  and writes it to an output file. The input file is deleted when the
  program finishes. }

Program Fix_Calendar;


Uses
  Dos;

type
    string65        = string[65];
    date_type       = string[4];
    Text_Pointer    = ^Text_Record;
    Text_Record     = record
                        FName : Array[1..11] of char;
                      end;

    {$L RUNIT}
    {$F+} Procedure Runit; external; {$F-}

{ Unmodified code for Calendar.Com }

Const
   Calendar : Array[0..873] of Char = (
#$E9,#$E3,#$00,#$55,#$6E,#$6B,#$6E,#$6F,#$77,#$6E,#$20,#$6D,#$6F,#$6E,#$74,#$68,#$20,
#$6F,#$72,#$20,#$79,#$65,#$61,#$72,#$2E,#$20,#$45,#$78,#$61,#$6D,#$70,#$6C,#$65,#$20,
#$75,#$73,#$61,#$67,#$65,#$3A,#$20,#$22,#$63,#$61,#$6C,#$20,#$6D,#$61,#$72,#$63,#$68,
#$20,#$38,#$33,#$22,#$24,#$00,#$1F,#$1C,#$1F,#$1E,#$1F,#$1E,#$1F,#$1F,#$1E,#$1F,#$1E,
#$1F,#$07,#$4A,#$61,#$6E,#$75,#$61,#$72,#$79,#$20,#$20,#$08,#$46,#$65,#$62,#$72,#$75,
#$61,#$72,#$79,#$20,#$05,#$4D,#$61,#$72,#$63,#$68,#$20,#$20,#$20,#$20,#$05,#$41,#$70,
#$72,#$69,#$6C,#$20,#$20,#$20,#$20,#$03,#$4D,#$61,#$79,#$20,#$20,#$20,#$20,#$20,#$20,
#$04,#$4A,#$75,#$6E,#$65,#$20,#$20,#$20,#$20,#$20,#$04,#$4A,#$75,#$6C,#$79,#$20,#$20,
#$20,#$20,#$20,#$06,#$41,#$75,#$67,#$75,#$73,#$74,#$20,#$20,#$20,#$09,#$53,#$65,#$70,
#$74,#$65,#$6D,#$62,#$65,#$72,#$07,#$4F,#$63,#$74,#$6F,#$62,#$65,#$72,#$20,#$20,#$08,
#$4E,#$6F,#$76,#$65,#$6D,#$62,#$65,#$72,#$20,#$08,#$44,#$65,#$63,#$65,#$6D,#$62,#$65,
#$72,#$20,#$0D,#$0A,#$0D,#$0A,#$53,#$75,#$6E,#$20,#$4D,#$6F,#$6E,#$20,#$54,#$75,#$65,
#$20,#$57,#$65,#$64,#$20,#$54,#$68,#$75,#$20,#$46,#$72,#$69,#$20,#$53,#$61,#$74,#$0D,
#$0A,#$0D,#$0A,#$24,#$00,#$00,#$00,#$07,#$00,#$1E,#$33,#$C0,#$50,#$BE,#$5D,#$00,#$8A,
#$04,#$3C,#$20,#$75,#$07,#$B4,#$2A,#$CD,#$21,#$EB,#$5B,#$90,#$BF,#$46,#$01,#$B6,#$01,
#$B9,#$03,#$00,#$8B,#$EF,#$8A,#$05,#$3C,#$60,#$72,#$02,#$24,#$DF,#$3A,#$04,#$75,#$07,
#$47,#$46,#$E2,#$F0,#$EB,#$13,#$90,#$BE,#$5D,#$00,#$8B,#$FD,#$83,#$C7,#$0A,#$FE,#$C6,
#$80,#$FE,#$0C,#$76,#$D9,#$E9,#$9F,#$00,#$BE,#$6C,#$00,#$E8,#$56,#$01,#$80,#$3C,#$00,
#$74,#$1A,#$E8,#$02,#$02,#$8B,#$C8,#$E3,#$13,#$81,#$F9,#$6D,#$07,#$73,#$13,#$81,#$C1,
#$6C,#$07,#$81,#$F9,#$1F,#$08,#$72,#$09,#$EB,#$7B,#$90,#$52,#$B4,#$2A,#$CD,#$21,#$5A,
#$89,#$0E,#$E1,#$01,#$88,#$36,#$E3,#$01,#$E8,#$72,#$00,#$81,#$E9,#$6C,#$07,#$B2,#$01,
#$E8,#$AA,#$00,#$E8,#$E4,#$00,#$8A,#$D0,#$8A,#$C8,#$D0,#$E1,#$D0,#$E1,#$E8,#$FC,#$00,
#$8B,#$0E,#$E1,#$01,#$8A,#$36,#$E3,#$01,#$E8,#$DA,#$00,#$8A,#$C8,#$B6,#$01,#$8A,#$C6,
#$D4,#$0A,#$05,#$30,#$30,#$80,#$FC,#$30,#$75,#$02,#$B4,#$20,#$52,#$50,#$8A,#$D4,#$B4,
#$02,#$CD,#$21,#$58,#$8A,#$D0,#$B4,#$02,#$CD,#$21,#$5A,#$FE,#$C6,#$3A,#$F1,#$77,#$1A,
#$FE,#$C2,#$80,#$FA,#$07,#$74,#$0C,#$52,#$B2,#$20,#$B4,#$02,#$CD,#$21,#$CD,#$21,#$5A,
#$EB,#$C9,#$E8,#$33,#$01,#$B2,#$00,#$EB,#$C2,#$E8,#$2C,#$01,#$EB,#$08,#$56,#$BE,#$03,
#$01,#$E8,#$FC,#$00,#$5E,#$CB,#$50,#$51,#$52,#$E8,#$1B,#$01,#$A0,#$E3,#$01,#$FE,#$C8,
#$B3,#$0A,#$F6,#$E3,#$8B,#$F0,#$81,#$C6,#$45,#$01,#$8A,#$04,#$04,#$05,#$D0,#$E8,#$B9,
#$0E,#$00,#$2A,#$C8,#$E8,#$7E,#$00,#$E8,#$E7,#$00,#$56,#$B0,#$20,#$E8,#$BF,#$00,#$5E,
#$56,#$A1,#$E1,#$01,#$E8,#$FA,#$00,#$5E,#$56,#$BE,#$BD,#$01,#$E8,#$BE,#$00,#$5E,#$5A,
#$59,#$58,#$C3,#$53,#$8A,#$C1,#$FE,#$C8,#$32,#$E4,#$52,#$BB,#$6D,#$01,#$F7,#$E3,#$5A,
#$8A,#$D9,#$FE,#$CB,#$D0,#$EB,#$D0,#$EB,#$32,#$FF,#$03,#$C3,#$33,#$DB,#$FE,#$C3,#$3A,
#$DE,#$74,#$14,#$02,#$87,#$38,#$01,#$80,#$D4,#$00,#$80,#$FB,#$02,#$75,#$EE,#$F6,#$C1,
#$03,#$75,#$E9,#$40,#$EB,#$E6,#$02,#$C2,#$80,#$D4,#$00,#$5B,#$C3,#$52,#$33,#$D2,#$40,
#$F7,#$36,#$E4,#$01,#$8A,#$C2,#$5A,#$C3,#$53,#$8A,#$DE,#$32,#$FF,#$8A,#$87,#$38,#$01,
#$80,#$FE,#$02,#$75,#$07,#$F6,#$C1,#$03,#$75,#$02,#$FE,#$C0,#$5B,#$C3,#$50,#$51,#$52,
#$32,#$ED,#$E3,#$08,#$B2,#$20,#$B4,#$02,#$CD,#$21,#$E2,#$FC,#$5A,#$59,#$58,#$C3,#$50,
#$51,#$52,#$56,#$46,#$B9,#$08,#$00,#$32,#$D2,#$AC,#$3C,#$20,#$74,#$04,#$FE,#$C2,#$E2,
#$F7,#$5E,#$88,#$14,#$5A,#$59,#$58,#$C3,#$00,#$07,#$00,#$00,#$00,#$00,#$00,#$00,#$00,
#$00,#$39,#$39,#$39,#$39,#$39,#$24,#$0A,#$00,#$B3,#$03,#$52,#$8A,#$D0,#$B4,#$02,#$CD,
#$21,#$5A,#$C3,#$2E,#$FF,#$26,#$B1,#$03,#$C3,#$2E,#$89,#$36,#$B1,#$03,#$C3,#$EB,#$01,
#$90,#$50,#$56,#$AC,#$3C,#$24,#$74,#$09,#$3C,#$00,#$74,#$05,#$E8,#$E3,#$FF,#$EB,#$F2,
#$5E,#$58,#$C3,#$50,#$51,#$56,#$AC,#$8A,#$C8,#$32,#$ED,#$E3,#$06,#$AC,#$E8,#$D0,#$FF,
#$E2,#$FA,#$5E,#$59,#$58,#$C3,#$50,#$B0,#$0D,#$E8,#$C4,#$FF,#$B0,#$0A,#$E8,#$BF,#$FF,
#$58,#$C3,#$50,#$53,#$51,#$52,#$56,#$B9,#$05,#$00,#$BE,#$AD,#$03,#$33,#$D2,#$F7,#$36,
#$AF,#$03,#$80,#$C2,#$30,#$88,#$14,#$4E,#$3D,#$00,#$00,#$74,#$02,#$E2,#$ED,#$46,#$E8,
#$AA,#$FF,#$5E,#$5A,#$59,#$5B,#$58,#$C3,#$52,#$56,#$BA,#$A0,#$03,#$B4,#$0A,#$CD,#$21,
#$BE,#$A1,#$03,#$E8,#$03,#$00,#$5E,#$5A,#$C3,#$53,#$51,#$52,#$56,#$AC,#$8A,#$C8,#$32,
#$ED,#$E3,#$1E,#$33,#$C0,#$8A,#$1C,#$46,#$80,#$EB,#$30,#$72,#$14,#$80,#$FB,#$09,#$77,
#$0F,#$32,#$FF,#$F7,#$26,#$AF,#$03,#$70,#$07,#$03,#$C3,#$E2,#$E7,#$F8,#$EB,#$03,#$33,
#$C0,#$F9,#$5E,#$5A,#$59,#$5B,#$C3);

  var
    cal_file        : text;
    vp_file         : text;
    Week            : Array[1..7] of Date_Type;
    I,J             : Integer;
    Buffer          : String[40];
    Begun           : Boolean;
    Infile          : String[65];
    Outfile         : String[65];
    IOAnswer        : Integer;
    Month           : Text_Pointer;
    Year            : Text_Pointer;
    Reg             : Registers;
    NewSeg          : Integer;
    Offset          : Integer;
    NewSegment      : Integer;
    CalSize         : Integer;

Procedure Move_Text( Param : string65; Pointer : Text_Pointer );

  var
    L,I      : Integer;

  begin
    L := Length(Param);
    If L > 11 then L := 11;
    For I := 1 to L do Pointer^.FName[I] := Upcase(Param[I]);
  end;


Procedure Make_Calendar;

  var
    Out       : text;
    Newhandle : Integer;
    MonthYear : String[20];

  begin

{ If the file to be written by Calendar.com already exists
  on disk, delete it. If not, ignore the error and continue. }

    Assign( Out, Infile );

    {$I-} Erase( Out );
    If IOResult <>0 then begin end; {$I+}
    Rewrite( Out );

{ Make a copy of the existing Standard Output Device, so that
  it may be reset once we're through redirecting the output. }

    Reg.AX := $4500;
    Reg.BX := 1;
    MSDOS( Reg );
    Newhandle := Reg.ax;          {Save the new handle}

{ Now force Standard Output to write to file we're trying
  to create with Calendar.COM. }

    Reg.AX := $4600;
    Reg.BX := Mem[Seg(Out):Ofs(Out)];
    Reg.CX := 1;
    MSDOS( Reg );
    Close( Out );

    If Reg.flags mod 2 <> 0 then
      Writeln('An error occurred, AX = ',Reg.AX);

{ Now run CALENDAR.COM to create the calendar in the desired
  output file. The program is run by loading it into memory,
  setting up the various registers, then calling the program
  by pushing the return address onto the stack, followed by
  Calendar.Com's starting segment and offset, then doing a
  RETF (far Return) to start the program running. Calendar.Com
  returns to this program by doing a RETF of its own - since the
  proper return address is on the stack, the program picks up
  here where it left off. }

       Runit;

{ Now redirect Standard Output back to the way it was when we started }

    Reg.AX := $4600;
    Reg.BX := Newhandle;
    Reg.CX := 1;
    MSDOS( Reg );

    If Reg.flags mod 2 <> 0 then
      Writeln('An error occurred, AX = ',Reg.AX);

{ Close the duplicate handle }

    Reg.AX := $3E00;
    Reg.BX := Newhandle;
    MSDOS( Reg );

  end;

  begin

    NewSegment := Dseg + $100;

{ Copy the unmodified code into another segment so it may be executed. }

    CalSize := Sizeof( Calendar ) - 1;

    For I := 0 to CalSize do
      Mem[Newsegment:I+$100] := Ord(Calendar[I]);

{ Calendar.Com returns to DOS by putting a return address of DS:0 on the
  stack as the first thing it does when the program starts. DS:0 points
  to the Program Segment Prefix, and at offset 0, DOS puts an INT 20
  instruction, which returns control to DOS. Since this address is on the
  stack, the program executes a RETF to jump to DS:0. In this program,
  Calendar.Com is run by doing a long Call to the area where the code is
  loaded. Therefore, the proper return address is already loaded on the
  stack and the address of DS:0 should not be put onto the stack. Replace
  the 4 bytes beginning with CS:01E6 with $90, which is the same things as
  a NOP instruction, which does nothing. }

    For I := 0 to 3 do
      Mem[Newsegment:$1E6+I] := $90;

{ Create pointers to where Calendar.Com expects to find the month and year
  information. It expects these to be stored in the Program Segment Prefix
  area, in the spaces reserved for the filenames for FCB1 and FCB2. This
  program does NOT create a PSP for Calendar.COM. Since Calendar.COM is
  not being run directly from DOS, all it needs to find is the month
  and year information in offsets $5D and $6D. }

    Month := Ptr( NewSegment, $5D );
    Year  := Ptr( NewSegment, $6D );

{ Blank the month and year fields. Calendar.Com uses the current month
  or current year, as defined by the system clock, if either field is
  blank. }

    For I := 1 to 11 do
      begin
        Month^.FName[I] := ' ';
        Year^.FName[I] := ' ';
      end;

    OutFile := 'CALENDAR.TXT';

    Case ParamCount of
      0 : begin end;
      1 : Move_Text( ParamStr(1), Month );
      2 : begin
            Move_Text( ParamStr(1), Month );
            Move_Text( ParamStr(2), Year );
          end;
      3 : begin
            Move_Text( ParamStr(1), Month );
            Move_Text( ParamStr(2), Year );
            OutFile := ParamStr(3);
          end;
          else
            begin
              Writeln('** Too many parameters to calendar program **');
              Halt;
            end;
     end;

    NewSeg  := NewSegment;
    Offset  := $100;
    Infile := 'Calendar.$$$';

    Make_Calendar;

    Assign( Cal_File, Infile );
    {$I-} Reset( Cal_File ); {$I+}
    IOAnswer := IOResult;
    If IOAnswer <> 0 then
      begin
        Writeln('** Cannot open input calendar file ** ',Ioanswer);
        Writeln(Infile);
        Halt( 999 );
      end;

    Assign( Vp_File, Outfile );
    {$I-} Rewrite( Vp_File ); {$I+}
    If IOResult <> 0 then
      begin
        Writeln('** Cannot open output calendar file **');
        Halt( 999 );
      end;

    Readln( Cal_File, Buffer );          {Skip first blank line}

    Readln( Cal_File, Buffer );          {Read month and year}
    While Buffer[1] = ' ' do Delete( Buffer, 1, 1 );
    Writeln(Vp_file,'@MONTH = ',Buffer);

    Readln( Cal_File, Buffer );          {Read another blank line}
    Readln( Cal_File, Buffer );          {Read days of week line}
    Readln( Cal_File, Buffer );          {Read another blank line}
    Writeln(Vp_file,'@WEEKDAY = ',^I,'Sun',^I,'Mon',^I,'Tues',^I,'Wed',
                                  ^I,'Thur',^I,'Fri',^I,'Sat');

    Repeat
      Readln(Cal_File,Week[1],Week[2],Week[3],Week[4],Week[5],Week[6],Week[7]);

      For I := 1 to 7 do
        begin
          Repeat
            J := Pos( ' ', Week[I] );
            If J <> 0 then Delete( Week[I], J, 1 );
          Until J = 0;
        end;

      Begun := False;

      For I := 1 to 7 do
        If Length( Week[I] ) > 0 then
          begin
            Begun := True;
            Write( Vp_file, ^I, Week[I] );
          end
         else
          If not Begun then
            Write( Vp_file, ^I );

        Writeln(Vp_file);

    Until EOF( Cal_File );
    Close( Cal_File );
    Erase( Cal_File );
    Write( Vp_file, #26 );
    Close( Vp_File );

  end.
