;ͻ
;  PROGRAM = MAC2IMG.ASM  
;ͼ
CSEG	       SEGMENT PUBLIC BYTE
	       ASSUME  CS:CSEG,DS:CSEG

CR	       EQU     0DH
LF	       EQU     0AH

IMG	       DB      'IMG',0
MAC	       DB      'MAC'
FILENAME       DB      128 DUP(0)
HANDLE_IN      DW      0
HANDLE_OUT     DW      0
TYPE_FROM      DW      0

LINES_PER_READ DW      0
READS_PER_FILE DW      0
BYTES_PER_READ DW      0

DISK_BUFFER    DD      0
IMG_BUFFER     DD      0

IMG_HDR_SIZE   DW      44
IMG_NAME       DB      'FILE GENERATED FROM MACPAINT  '
IMG_HEIGHT     DW      720
IMG_WIDTH      DW      576
IMG_WIDTH_BYTE DW      72
IMG_PIX_SIZE   DW      1
IMG_PIX_FMT    DW      0
IMG_COLOR      DW      0
IMG_COMPRESS   DW      0

MAC_HDR_SIZE   DW      280H
MAC_VERSION    DB      0
MAC_LEN_FN     DB      0
MAC_FILE_NAME  DB      63 DUP(0)
MAC_FILE_TYPE  DB      'PNTG'
MAC_FILE_CREAT DB      'MPNT'
MAC_FLAGS      DB      0
MAC_FILL1      DB      0
MAC_VERT       DW      0
MAC_HORIZ      DW      0
MAC_FOLDER     DW      0
MAC_PROT       DB      0
MAC_FILL2      DB      0
MAC_FORK       DD      0
MAC_R_FORK     DD      0
MAC_CRT_DATE   DD      0
MAC_LST_MOD    DD      0
MAC_FILL3      DB      27 DUP(0)
MAC_OS	       DW      0
MAC_REV        DB      0,0,0,2
MAC_PAT        DB      304 DUP(0)
MAC_FILL4      DB      204 DUP(0)


EIGHT	       DW      8

TELL_HOW       DB      'Ŀ',cr,lf
	       DB      ' MAC2IMG filename.typ                         ',cr,lf
	       DB      'Ĵ',cr,lf
	       DB      ' filename = MACBINARY filename                ',cr,lf
	       DB      ' typ      = must end in MAC                   ',cr,lf
	       DB      'Ĵ',cr,lf
	       DB      ' Converts MAC file to IMG file                ',cr,lf
	       DB      '',cr,lf
	       DB      7,'$'
OPEN_ERROR     DB      'file not found...must end in MAC',cr,lf,'$'
CREATE_ERROR   DB      'create error on output file',cr,lf,'$'
;ͻ
;  MAIN.ASM  
;ͼ
MAIN	       PROC    FAR
;Ŀ
;	       RETURN SETUP						       
;
	       CLI
	       MOV     AX,CS		       ;TEMP STACK
	       MOV     SS,AX		       ;
	       MOV     ES,AX		       ;
	       MOV     SP,OFFSET STACK	       ;
	       STI
	       PUSH    DS		       ;
	       XOR     AX,AX		       ;
	       PUSH    AX		       ;
	       CLD
;Ŀ
;	       GET FILENAME FROM COMMAND LINE				       
;
	       MOV     SI,82H		       ;START OF FILENAME
	       XOR     CH,CH		       ;
	       MOV     CL,DS:[SI-2]	       ;SIZE OF FILENAME
	       CMP     CX,0		       ;NO COMMANDS
	       JE      GFN800		       ;ERROR
	       MOV     DI,OFFSET FILENAME      ;STORE FILENAME HERE
GFN100:
	       LODSB			       ;GET CHARACTER
	       CMP     AL,20H		       ;END OF FILENAME?
	       JE      GFN900		       ;YES....BRANCH
	       CMP     AL,CR		       ;END OF COMMAND LINE?
	       JE      GFN900		       ;YES....ERROR
	       STOSB			       ;SAVE CHARACTER
	       CMP     AL,'.'                  ;START OF TYPE
	       JNE     GFN200		       ;
	       MOV     CS:TYPE_FROM,DI	       ;START OF TYPE
GFN200:
	       LOOP    GFN100		       ;GET ANOTHER CHARACTER
	       JMP     SHORT GFN800	       ;ERROR IF DONE ALREADY
GFN800:
	       MOV     DX,OFFSET TELL_HOW      ;
	       JMP     ERROR		       ;
GFN900:
	       MOV     AL,0		       ;PUT NULL AT END OF STRING
	       STOSB			       ;
	       CMP     WORD PTR CS:TYPE_FROM,0 ;
	       JNE     SET_BREAK
	       DEC     DI
	       MOV     CS:TYPE_FROM,DI
;Ŀ
;	       TURN BREAK KEY ON					       
;
SET_BREAK:
	       MOV     AX,CS		       ;SET DATA SEGMENT
	       MOV     DS,AX		       ;
	       CALL    BREAK_ON 	       ;SET UP CONTROL BREAK
;Ŀ
;	       FIND DISK MEMORY 					       
;
	       MOV     AX,OFFSET PROG_END      ;
	       MOV     BX,CS		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       ADD     BX,AX		       ;
	       ADD     BX,8		       ;
	       MOV     WORD PTR DISK_BUFFER+2,BX	  ;
	       ADD     BX,1000H
	       MOV     WORD PTR IMG_BUFFER+2,BX
;Ŀ
;	       CHECK  FILENAME						       
;
	       MOV     SI,OFFSET MAC	       ;CHANGE TYPE ON FILENAME
	       MOV     DI,TYPE_FROM	       ;
	       MOV     CX,3		       ;
	       AND     BYTE PTR [DI],0DFH		;MAKE CAPITOL LETTER
	       AND     BYTE PTR [DI+1],0DFH		;MAKE CAPITOL LETTER
	       AND     BYTE PTR [DI+2],0DFH		;MAKE CAPITOL LETTER
	       REP     CMPSB		       ;
	       JNE     OIF050
;Ŀ
;	       OPEN INPUT FILE						       
;
	       MOV     AH,3DH		       ;OPEN FILE FOR READ
	       MOV     AL,0H		       ;
	       MOV     DX,OFFSET FILENAME      ;
	       INT     21H		       ;
	       JNC     OIF100
OIF050:
	       MOV     DX,OFFSET OPEN_ERROR    ;
	       JMP     ERROR
OIF100:
	       MOV     HANDLE_IN,AX
;Ŀ
;	       CHANGE FILENAME						       
;
	       MOV     SI,OFFSET IMG	       ;CHANGE TYPE ON FILENAME
	       MOV     DI,TYPE_FROM	       ;
	       MOV     CX,3		       ;
	       REP     MOVSB		       ;
;Ŀ
;	       CREATE OUTPUT TEMP FILE					       
;
	       MOV     AH,3CH		       ;
	       MOV     CX,20H		       ;
	       MOV     DX,OFFSET FILENAME      ;
	       INT     21H		       ;
	       JNC     COF100
	       MOV     DX,OFFSET CREATE_ERROR  ;
	       JMP     ERROR
COF100:
	       MOV     HANDLE_OUT,AX
;Ŀ
;	       READ MAC HEADER						       
;
	       MOV     AH,3FH
	       MOV     BX,HANDLE_IN
	       MOV     CX,MAC_HDR_SIZE
	       MOV     DX,OFFSET MAC_VERSION
	       INT     21H
;Ŀ
;	       WRITE IMG HEADER 					       
;
	       MOV     AH,40H
	       MOV     BX,HANDLE_OUT
	       MOV     CX,IMG_HDR_SIZE
	       MOV     DX,OFFSET IMG_NAME
	       INT     21H
;Ŀ
;	       MOVE PICTURE DATA BETWEEN FILES				       
;
READ_BLOCK:
	       PUSH    DS
	       MOV     AH,3FH		       ;
	       MOV     BX,HANDLE_IN	       ;
	       MOV     CX,0FFFFH	       ;
	       LDS     DX,DISK_BUFFER	       ;
	       INT     21H		       ;
	       POP     DS
;Ŀ
;	       EXPAND DATA						       
;
	       PUSH    DS

	       MOV     BX,AX		       ;COUNT
	       LDS     SI,CS:DISK_BUFFER
	       LES     DI,CS:IMG_BUFFER

ED100:
	       XOR     CH,CH
	       LODSB
	       TEST    AL,80H
	       JZ      ED200
	       NEG     AL
	       MOV     CL,AL
	       INC     CX
	       LODSB
	       REP     STOSB
	       DEC     BX
	       JZ      ED400
	       JMP     SHORT ED300
ED200:
	       MOV     CL,AL
	       INC     CX
	       PUSH    CX
	       REP     MOVSB
	       POP     CX
	       SUB     BX,CX
	       JB      ED400
ED300:
	       DEC     BX
	       JNZ     ED100
ED400:

	       POP     DS
;Ŀ
;	       WRITE DATA						       
;
	       PUSH    DS
	       MOV     AH,40H		       ;
	       MOV     BX,HANDLE_OUT	       ;
	       MOV     CX,51840 	       ;
	       LDS     DX,IMG_BUFFER	      ;
	       INT     21H		       ;
	       POP     DS
;Ŀ
;	       CLOSE FILES						       
;
CLOSE_FILE:
	       MOV     BX,HANDLE_IN	       ;CLOSE FILE
	       MOV     AH,3EH		       ;
	       INT     21H		       ;
	       MOV     BX,HANDLE_OUT	       ;CLOSE FILE
	       MOV     AH,3EH		       ;
	       INT     21H		       ;

	       JMP     EXIT
ERROR:
	       MOV     AX,CS
	       MOV     DS,AX
	       MOV     AH,9
	       INT     21H
EXIT:
	       CALL    BREAK_OFF	       ;BREAK KEY RESET
	       RET			       ;
MAIN	       ENDP
;ͻ
;ͼ
EOI	      EQU      20H		      ;END OF INTERRUPT
BRKINT	      EQU      1BH		      ;BREAK INTERRUPT
SAV_BRK       DW       ?
;ͻ
;  BREAK_ON  
;ͼ
	      PUBLIC   BREAK_ON
BREAK_ON      PROC     NEAR
	      PUSH     AX
	      PUSH     BX		       ;SAVE REGISTERS
	      PUSH     CX		       ;
	      PUSH     DX		       ;
	      PUSH     SI		       ;
	      PUSH     ES		       ;

	      XOR      BX,BX		       ;SEGMENT 0
	      MOV      ES,BX		       ;
	      MOV      SI,BRKINT*4	       ;OFFSET OF INTERUPT VECTOR

	      MOV      CX,ES:WORD PTR[SI]      ;OFFSET OF CURRENT VECT
	      MOV      DX,ES:WORD PTR[SI+2]    ;SEGMENT OF CURRENT VECT
	      MOV      CS:SAV_BRK,CX	       ;SAVE OFFSET
	      MOV      CS:SAV_BRK+2,DX	       ;SAVE SEGMENT

	      MOV      AX,OFFSET BREAK	       ;
	      CLI			       ;NO INTERRUPTS
	      MOV      ES:WORD PTR[SI],AX      ;SET OFFSET
	      MOV      AX,CS		       ;SET THIS CODE SEGMENT
	      MOV      ES:WORD PTR[SI+2],AX    ;MOVE SEG ADDR TO INT.VECT
	      STI			       ;INTERRUPTS BACK ON

	      POP      ES		       ;RESTORE REGISTERS
	      POP      SI		       ;
	      POP      DX		       ;
	      POP      CX		       ;
	      POP      BX		       ;
	      POP      AX		       ;
	      RET			       ;
BREAK_ON      ENDP
;ͻ
;  BREAK_OFF  
;ͼ
	      PUBLIC   BREAK_OFF
BREAK_OFF     PROC     NEAR

	      PUSH     AX		       ;
	      PUSH     CX		       ;
	      PUSH     DX		       ;
	      PUSH     DI		       ;
	      PUSH     ES		       ;

	      XOR      AX,AX		       ;
	      MOV      ES,AX		       ;SEGMENT 0
	      MOV      CX,CS:SAV_BRK	       ;RESET VECTOR BACK TO OLD RTN
	      MOV      DX,CS:SAV_BRK+2	       ;
	      MOV      DI,BRKINT*4	       ;
	      CLI			       ;NO INTERRUPTS
	      MOV      ES:WORD PTR[DI],CX      ;
	      MOV      ES:WORD PTR[DI+2],DX    ;
	      STI			       ;INTERRUPTS BACK ON

	      POP      ES		       ;
	      POP      DI		       ;
	      POP      DX		       ;
	      POP      CX		       ;
	      POP      AX		       ;
	      RET			       ;
BREAK_OFF     ENDP
;ͻ
;  BREAK   J
;ͼ
	      PUBLIC   BREAK
BREAK	      PROC     FAR

	      MOV      AX,CS
	      MOV      DS,AX
	      MOV      AL,EOI		       ;
	      OUT      020H,AL		       ;
	      CALL     BREAK_OFF
	      MOV      SP,OFFSET STACK-4       ;
	      RET

BREAK	      ENDP
;Ŀ
;
	       DB      64 DUP('STACK')
STACK	       EQU     $
PROG_END       EQU     $
CSEG	       ENDS
	       END     MAIN
