;ͻ
;  PROGRAM = MAC2IMG.ASM  
;ͼ
CSEG	       SEGMENT PUBLIC BYTE
	       ASSUME  CS:CSEG,DS:CSEG

CR	       EQU     0DH
LF	       EQU     0AH

IMG	       DB      'IMG',0
MAC	       DB      'MAC',0
FILENAME       DB      128 DUP(0)
HANDLE_IN      DW      0
HANDLE_OUT     DW      0
TYPE_FROM      DW      0
START_FILE     DW      0

LINES_PER_READ DW      0
READS_PER_FILE DW      0
BYTES_PER_READ DW      0

DISK_BUFFER    DD      0
MAC_BUFFER     DD      0

IMG_HDR_SIZE   DW      44
IMG_NAME       DB      'FILE GENERATED FROM MACPAINT  '
IMG_HEIGHT     DW      720
IMG_WIDTH      DW      576
IMG_WIDTH_BYTE DW      72
IMG_PIX_SIZE   DW      1
IMG_PIX_FMT    DW      0
IMG_COLOR      DW      0
IMG_COMPRESS   DW      0

MAC_HDR_SIZE   DW      280H
MAC_VERSION    DB      0
MAC_LEN_FN     DB      0
MAC_FILE_NAME  DB      63 DUP(0)
MAC_FILE_TYPE  DB      'PNTG'
MAC_FILE_CREAT DB      'MPNT'
MAC_FLAGS      DB      1
MAC_FILL1      DB      0
MAC_VERT       DW      0
MAC_HORIZ      DW      8001H
MAC_FOLDER     DW      0
MAC_PROT       DB      0
MAC_FILL2      DB      0
MAC_FORK       DD      0
MAC_R_FORK     DD      0
MAC_CRT_DATE   DB      9BH,41H,8CH,0FAH
MAC_LST_MOD    DB      9BH,41H,8CH,0FEH
MAC_FILL3      DB      27 DUP(0)
MAC_OS	       DW      0

MAC_REV        DB      0,0,0,2
MAC_PAT_01     DB      0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
MAC_PAT_02     DB      0DDH,0FFH,077H,0FFH,0FFH,077H,0FFH,0DDH
MAC_PAT_03     DB      077H,0DDH,077H,0DDH,077H,0DDH,077H,0AAH
MAC_PAT_04     DB      055H,0AAH,055H,0AAH,055H,0AAH,055H,055H
MAC_PAT_05     DB      0FFH,055H,0FFH,055H,0FFH,055H,0FFH,0AAH
MAC_PAT_06     DB      0AAH,0AAH,0AAH,0AAH,0AAH,0AAH,0AAH,0EEH
MAC_PAT_07     DB      0DDH,0BBH,077H,0EEH,0DDH,0BBH,077H,088H
MAC_PAT_08     DB      088H,088H,088H,088H,088H,088H,088H,0B1H
MAC_PAT_09     DB      030H,003H,01BH,0D8H,0C0H,00CH,08DH,080H
MAC_PAT_10     DB      010H,002H,020H,001H,008H,040H,004H,0FFH
MAC_PAT_11     DB      088H,088H,088H,0FFH,088H,088H,088H,0FFH
MAC_PAT_12     DB      080H,080H,080H,0FFH,008H,008H,008H,080H
MAC_PAT_13     DB      000H,000H,000H,000H,000H,000H,000H,080H
MAC_PAT_14     DB      040H,020H,000H,002H,004H,008H,000H,082H
MAC_PAT_15     DB      044H,039H,044H,082H,001H,001H,001H,0F8H
MAC_PAT_16     DB      074H,022H,047H,08FH,017H,022H,071H,055H
MAC_PAT_17     DB      0A0H,040H,040H,055H,00AH,004H,004H,020H
MAC_PAT_18     DB      050H,088H,088H,088H,088H,005H,002H,0BFH
MAC_PAT_19     DB      000H,0BFH,0BFH,0B0H,0B0H,0B0H,0B0H,000H
MAC_PAT_20     DB      000H,000H,000H,000H,000H,000H,000H,080H
MAC_PAT_21     DB      000H,008H,000H,080H,000H,008H,000H,088H
MAC_PAT_22     DB      000H,022H,000H,088H,000H,022H,000H,088H
MAC_PAT_23     DB      022H,088H,022H,088H,022H,088H,022H,0AAH
MAC_PAT_24     DB      000H,0AAH,000H,0AAH,000H,0AAH,000H,0FFH
MAC_PAT_25     DB      000H,0FFH,000H,0FFH,000H,0FFH,000H,011H
MAC_PAT_26     DB      022H,044H,088H,011H,022H,044H,088H,0FFH
MAC_PAT_27     DB      000H,000H,000H,0FFH,000H,000H,000H,001H
MAC_PAT_28     DB      002H,004H,008H,010H,020H,040H,080H,0AAH
MAC_PAT_29     DB      000H,080H,000H,088H,000H,080H,000H,0FFH
MAC_PAT_30     DB      080H,080H,080H,080H,080H,080H,080H,008H
MAC_PAT_31     DB      01CH,022H,0C1H,080H,001H,002H,004H,088H
MAC_PAT_32     DB      014H,022H,041H,088H,000H,0AAH,000H,040H
MAC_PAT_33     DB      0A0H,000H,000H,004H,00AH,000H,000H,003H
MAC_PAT_34     DB      084H,048H,030H,00CH,002H,001H,001H,080H
MAC_PAT_35     DB      080H,041H,03EH,008H,008H,014H,0E3H,010H
MAC_PAT_36     DB      020H,054H,0AAH,0FFH,002H,004H,008H,077H
MAC_PAT_37     DB      089H,08FH,08FH,077H,098H,0F8H,0F8H,000H
MAC_PAT_38     DB      008H,014H,02AH,055H,02AH,014H,008H,000H
MAC_FILL4      DB      204 DUP(0)

LAST_CHAR      DB      0
COUNT	       DB      0

EIGHT	       DW      8

TELL_HOW       DB      'Ŀ',cr,lf
	       DB      ' IMG2MAC filename.typ                         ',cr,lf
	       DB      'Ĵ',cr,lf
	       DB      ' filename = IMG file                          ',cr,lf
	       DB      ' typ      = must end in IMG                   ',cr,lf
	       DB      'Ĵ',cr,lf
	       DB      ' Converts IMG file to MAC file  576 X 720     ',cr,lf
	       DB      '',cr,lf
	       DB      7,'$'
OPEN_ERROR     DB      'file not found...must end in IMG',cr,lf,'$'
CREATE_ERROR   DB      'create error on output file',cr,lf,'$'
SIZE_ERROR     DB      'MACFILES must be 576 by 720 pixels',cr,lf,'$'
;ͻ
;  MAIN.ASM  
;ͼ
MAIN	       PROC    FAR
;Ŀ
;	       RETURN SETUP						       
;
	       CLI
	       MOV     AX,CS		       ;TEMP STACK
	       MOV     SS,AX		       ;
	       MOV     ES,AX		       ;
	       MOV     SP,OFFSET STACK	       ;
	       STI
	       PUSH    DS		       ;
	       XOR     AX,AX		       ;
	       PUSH    AX		       ;
	       CLD
;Ŀ
;	       GET FILENAME FROM COMMAND LINE				       
;
	       MOV     SI,82H		       ;START OF FILENAME
	       XOR     CH,CH		       ;
	       MOV     CL,DS:[SI-2]	       ;SIZE OF FILENAME
	       CMP     CX,0		       ;NO COMMANDS
	       JE      GFN800		       ;ERROR
	       MOV     DI,OFFSET FILENAME      ;STORE FILENAME HERE
	       MOV     CS:START_FILE,DI
GFN100:
	       LODSB			       ;GET CHARACTER
	       CMP     AL,20H		       ;END OF FILENAME?
	       JE      GFN900		       ;YES....BRANCH
	       CMP     AL,CR		       ;END OF COMMAND LINE?
	       JE      GFN900		       ;YES....ERROR
	       STOSB			       ;SAVE CHARACTER
	       CMP     AL,'.'                  ;START OF TYPE
	       JNE     GFN200		       ;
	       MOV     CS:TYPE_FROM,DI	       ;START OF TYPE
	       JMP     SHORT GFN700
GFN200:
	       CMP     AL,':'
	       JNE     GFN300
	       MOV     CS:START_FILE,DI
GFN300:
	       CMP     AL,'\'
	       JNE     GFN700
	       MOV     CS:START_FILE,DI
GFN700:
	       LOOP    GFN100		       ;GET ANOTHER CHARACTER
	       JMP     SHORT GFN800	       ;ERROR IF DONE ALREADY
GFN800:
	       MOV     DX,OFFSET TELL_HOW      ;
	       JMP     ERROR		       ;
GFN900:
	       MOV     AL,0		       ;PUT NULL AT END OF STRING
	       STOSB			       ;
	       CMP     WORD PTR CS:TYPE_FROM,0 ;
	       JNE     SET_BREAK
	       DEC     DI
	       MOV     CS:TYPE_FROM,DI
;Ŀ
;	       TURN BREAK KEY ON					       
;
SET_BREAK:
	       MOV     AX,CS		       ;SET DATA SEGMENT
	       MOV     DS,AX		       ;
	       CALL    BREAK_ON 	       ;SET UP CONTROL BREAK
;Ŀ
;	       FIND DISK MEMORY 					       
;
	       MOV     AX,OFFSET PROG_END      ;
	       MOV     BX,CS		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       ADD     BX,AX		       ;
	       ADD     BX,8		       ;
	       MOV     WORD PTR DISK_BUFFER+2,BX	  ;
	       ADD     BX,1000H
	       MOV     WORD PTR MAC_BUFFER+2,BX
;Ŀ
;	       CHECK  FILENAME						       
;
	       MOV     SI,OFFSET IMG	       ;CHANGE TYPE ON FILENAME
	       MOV     DI,TYPE_FROM	       ;
	       MOV     CX,3		       ;
	       AND     BYTE PTR [DI],0DFH		;MAKE CAPITOL LETTER
	       AND     BYTE PTR [DI+1],0DFH		;MAKE CAPITOL LETTER
	       AND     BYTE PTR [DI+2],0DFH		;MAKE CAPITOL LETTER
	       REP     CMPSB		       ;
	       JNE     OIF050
;Ŀ
;	       OPEN INPUT FILE						       
;
	       MOV     AH,3DH		       ;OPEN FILE FOR READ
	       MOV     AL,0H		       ;
	       MOV     DX,OFFSET FILENAME      ;
	       INT     21H		       ;
	       JNC     OIF100
OIF050:
	       MOV     DX,OFFSET OPEN_ERROR    ;
	       JMP     ERROR
OIF100:
	       MOV     HANDLE_IN,AX
;Ŀ
;	       CHANGE FILENAME						       
;
	       MOV     SI,OFFSET MAC	       ;CHANGE TYPE ON FILENAME
	       MOV     DI,TYPE_FROM	       ;
	       MOV     CX,3		       ;
	       REP     MOVSB		       ;
;Ŀ
;	       CREATE OUTPUT TEMP FILE					       
;
	       MOV     AH,3CH		       ;
	       MOV     CX,20H		       ;
	       MOV     DX,OFFSET FILENAME      ;
	       INT     21H		       ;
	       JNC     COF100
	       MOV     DX,OFFSET CREATE_ERROR  ;
	       JMP     ERROR
COF100:
	       MOV     HANDLE_OUT,AX
;Ŀ
;	       READ IMG HEADER						       
;
	       MOV     AH,3FH
	       MOV     BX,HANDLE_IN
	       MOV     CX,IMG_HDR_SIZE
	       MOV     DX,OFFSET IMG_NAME
	       INT     21H
;Ŀ
;	       CHECK SIZE						       
;
	       CMP     IMG_WIDTH,576
	       JNE     CS900
	       CMP     IMG_HEIGHT,720
	       JE      CS999
CS900:
	       MOV     DX,OFFSET SIZE_ERROR
	       JMP     ERROR
CS999:
;Ŀ
;	       MOVE PICTURE DATA BETWEEN FILES				       
;
READ_BLOCK:
	       PUSH    DS
	       MOV     AH,3FH		       ;
	       MOV     BX,HANDLE_IN	       ;
	       MOV     CX,0FFFFH	       ;
	       LDS     DX,DISK_BUFFER	       ;
	       INT     21H		       ;
	       POP     DS
;Ŀ
;	       EXPAND DATA						       
;
	       PUSH    DS
	       MOV     DX,720		       ;COUNT

	       LDS     SI,CS:DISK_BUFFER
	       LES     DI,CS:MAC_BUFFER
ED100:
	       MOV     CX,71		       ;BYTES PER LINE
	       MOV     BX,-1
ED200:
	       LODSB
ED250:
	       MOV     CS:COUNT,0
	       MOV     CS:LAST_CHAR,AL
ED300:
	       LODSB
	       CMP     AL,CS:LAST_CHAR
	       JNE     ED400
	       INC     CS:COUNT
	       MOV     BX,-1
	       JMP     SHORT ED700
ED400:
	       CMP     CS:COUNT,0
	       JE      ED500
	       PUSH    AX
	       MOV     AL,CS:COUNT
	       NEG     AL
	       STOSB
	       MOV     AL,CS:LAST_CHAR
	       STOSB
	       POP     AX
	       MOV     CS:COUNT,0
	       MOV     CS:LAST_CHAR,AL
	       JMP     SHORT ED700
ED500:
	       CMP     BX,-1
	       JNE     ED600
	       MOV     BX,DI
	       PUSH    AX
	       XOR     AL,AL
	       STOSB
	       POP     AX
	       JMP     SHORT ED650
ED600:
	       INC     BYTE PTR ES:[BX]
ED650:
	       PUSH    AX
	       MOV     AL,CS:LAST_CHAR
	       STOSB
	       POP     AX
	       MOV     CS:LAST_CHAR,AL
ED700:
	       LOOP    ED300
	       CMP     CS:COUNT,0
	       JE      ED800
	       MOV     AL,CS:COUNT
	       NEG     AL
	       STOSB
	       JMP     SHORT ED850
ED800:
	       CMP     BX,-1
	       JE      ED900
	       INC     BYTE PTR ES:[BX]
ED850:
	       MOV     AL,CS:LAST_CHAR
	       STOSB
ED900:
	       DEC     DX
	       JZ      ED999
	       JMP     ED100
ED999:
	       POP     DS
;Ŀ
;	       PUT FILENAME IN FILE					       
;
	       MOV     AX,DI
	       ADD     AX,MAC_HDR_SIZE
	       SUB     AX,128
	       XCHG    AH,AL
	       MOV     WORD PTR MAC_FORK+2,AX

	       PUSH    DI
	       MOV     AX,CS
	       MOV     ES,AX
	       MOV     DS,AX
	       MOV     SI,START_FILE
	       MOV     DI,OFFSET MAC_FILE_NAME
	       MOV     BX,OFFSET MAC_LEN_FN
PFN100:
	       LODSB
	       CMP     AL,0
	       JE      PFN900
	       STOSB
	       INC     BYTE PTR [BX]
	       JMP     SHORT PFN100
PFN900:
;Ŀ
;	       WRITE MAC HEADER 					       
;
	       MOV     AH,40H
	       MOV     BX,HANDLE_OUT
	       MOV     CX,MAC_HDR_SIZE
	       MOV     DX,OFFSET MAC_VERSION
	       INT     21H
;Ŀ
;	       WRITE DATA						       
;
	       POP     CX
	       PUSH    DS
	       MOV     AH,40H		       ;
	       MOV     BX,HANDLE_OUT	       ;
	       LDS     DX,MAC_BUFFER	      ;
	       INT     21H		       ;
	       POP     DS
;Ŀ
;	       CLOSE FILES						       
;
CLOSE_FILE:
	       MOV     BX,HANDLE_IN	       ;CLOSE FILE
	       MOV     AH,3EH		       ;
	       INT     21H		       ;
	       MOV     BX,HANDLE_OUT	       ;CLOSE FILE
	       MOV     AH,3EH		       ;
	       INT     21H		       ;

	       JMP     EXIT
ERROR:
	       MOV     AX,CS
	       MOV     DS,AX
	       MOV     AH,9
	       INT     21H
EXIT:
	       CALL    BREAK_OFF	       ;BREAK KEY RESET
	       RET			       ;
MAIN	       ENDP
;ͻ
;ͼ
EOI	      EQU      20H		      ;END OF INTERRUPT
BRKINT	      EQU      1BH		      ;BREAK INTERRUPT
SAV_BRK       DW       ?
;ͻ
;  BREAK_ON  
;ͼ
	      PUBLIC   BREAK_ON
BREAK_ON      PROC     NEAR
	      PUSH     AX
	      PUSH     BX		       ;SAVE REGISTERS
	      PUSH     CX		       ;
	      PUSH     DX		       ;
	      PUSH     SI		       ;
	      PUSH     ES		       ;

	      XOR      BX,BX		       ;SEGMENT 0
	      MOV      ES,BX		       ;
	      MOV      SI,BRKINT*4	       ;OFFSET OF INTERUPT VECTOR

	      MOV      CX,ES:WORD PTR[SI]      ;OFFSET OF CURRENT VECT
	      MOV      DX,ES:WORD PTR[SI+2]    ;SEGMENT OF CURRENT VECT
	      MOV      CS:SAV_BRK,CX	       ;SAVE OFFSET
	      MOV      CS:SAV_BRK+2,DX	       ;SAVE SEGMENT

	      MOV      AX,OFFSET BREAK	       ;
	      CLI			       ;NO INTERRUPTS
	      MOV      ES:WORD PTR[SI],AX      ;SET OFFSET
	      MOV      AX,CS		       ;SET THIS CODE SEGMENT
	      MOV      ES:WORD PTR[SI+2],AX    ;MOVE SEG ADDR TO INT.VECT
	      STI			       ;INTERRUPTS BACK ON

	      POP      ES		       ;RESTORE REGISTERS
	      POP      SI		       ;
	      POP      DX		       ;
	      POP      CX		       ;
	      POP      BX		       ;
	      POP      AX		       ;
	      RET			       ;
BREAK_ON      ENDP
;ͻ
;  BREAK_OFF  
;ͼ
	      PUBLIC   BREAK_OFF
BREAK_OFF     PROC     NEAR

	      PUSH     AX		       ;
	      PUSH     CX		       ;
	      PUSH     DX		       ;
	      PUSH     DI		       ;
	      PUSH     ES		       ;

	      XOR      AX,AX		       ;
	      MOV      ES,AX		       ;SEGMENT 0
	      MOV      CX,CS:SAV_BRK	       ;RESET VECTOR BACK TO OLD RTN
	      MOV      DX,CS:SAV_BRK+2	       ;
	      MOV      DI,BRKINT*4	       ;
	      CLI			       ;NO INTERRUPTS
	      MOV      ES:WORD PTR[DI],CX      ;
	      MOV      ES:WORD PTR[DI+2],DX    ;
	      STI			       ;INTERRUPTS BACK ON

	      POP      ES		       ;
	      POP      DI		       ;
	      POP      DX		       ;
	      POP      CX		       ;
	      POP      AX		       ;
	      RET			       ;
BREAK_OFF     ENDP
;ͻ
;  BREAK   J
;ͼ
	      PUBLIC   BREAK
BREAK	      PROC     FAR

	      MOV      AX,CS
	      MOV      DS,AX
	      MOV      AL,EOI		       ;
	      OUT      020H,AL		       ;
	      CALL     BREAK_OFF
	      MOV      SP,OFFSET STACK-4       ;
	      RET

BREAK	      ENDP
;Ŀ
;
	       DB      64 DUP('STACK')
STACK	       EQU     $
PROG_END       EQU     $
CSEG	       ENDS
	       END     MAIN
