;ͻ
;  PROGRAM = PERCENT.ASM  
;ͼ
CSEG	       SEGMENT PUBLIC BYTE
	       ASSUME  CS:CSEG,DS:CSEG

CR	       EQU     0DH
LF	       EQU     0AH

FILENAME       DB      128 DUP(0)
HANDLE_IN      DW      0

BYTE_CNT_H     DW      0
BYTE_CNT_L     DW      0

PIXEL_COUNT    DW      0
	       DW      0
	       DW      0

LINES_PER_READ DW      0
READS_PER_FILE DW      0
BYTES_PER_READ DW      0

DISK_BUFFER    DD      0

;44 BYTES
IMG_NAME       DB      'FILE GENERATED FROM PCPAINT   '
IMG_HEIGHT     DW      0
IMG_WIDTH      DW      0
IMG_WIDTH_BYTE DW      0
IMG_PIX_SIZE   DW      1
IMG_PIX_FMT    DW      0
IMG_COLOR      DW      0
IMG_COMPRESS   DW      0

CRLF	       DB      CR,LF,'$'
TELL_HOW       DB      'Ŀ',cr,lf
	       DB      ' PERCENT filename.typ                         ',cr,lf
	       DB      'Ĵ',cr,lf
	       DB      ' TELLS PERCENT OF PIXELS ON                   ',cr,lf
	       DB      '',cr,lf
	       DB      7,'$'
OPEN_ERROR     DB      'file not found...must end in GMI',cr,lf,'$'
CREATE_ERROR   DB      'create error on output file',cr,lf,'$'
PROMPT1        DB      CR,LF,'NUMBER OF PIXELS IN FILE (HEX) $'
PROMPT2        DB      CR,LF,'NUMBER OF PIXELS ON (HEX)      $'
PROMPT3        DB      CR,LF,'PERCENT OF PIXELS ON (HEX)     $'


;ͻ
;  MAIN.ASM  
;ͼ
MAIN	       PROC    FAR
;Ŀ
;	       RETURN SETUP						       
;
	       CLI
	       MOV     AX,CS		       ;TEMP STACK
	       MOV     SS,AX		       ;
	       MOV     ES,AX		       ;
	       MOV     SP,OFFSET STACK	       ;
	       STI
	       PUSH    DS		       ;
	       XOR     AX,AX		       ;
	       PUSH    AX		       ;
	       CLD
;Ŀ
;	       GET FILENAME FROM COMMAND LINE				       
;
	       MOV     SI,82H		       ;START OF FILENAME
	       XOR     CH,CH		       ;
	       MOV     CL,DS:[SI-2]	       ;SIZE OF FILENAME
	       CMP     CX,0		       ;NO COMMANDS
	       JE      GFN800		       ;ERROR
	       MOV     DI,OFFSET FILENAME      ;STORE FILENAME HERE
GFN100:
	       LODSB			       ;GET CHARACTER
	       CMP     AL,20H		       ;END OF FILENAME?
	       JE      GFN900		       ;YES....BRANCH
	       CMP     AL,CR		       ;END OF COMMAND LINE?
	       JE      GFN900		       ;YES....ERROR
	       STOSB			       ;SAVE CHARACTER
	       LOOP    GFN100		       ;GET ANOTHER CHARACTER
GFN800:
	       MOV     DX,OFFSET TELL_HOW      ;
	       JMP     ERROR		       ;
GFN900:
	       MOV     AL,0		       ;PUT NULL AT END OF STRING
	       STOSB			       ;
;Ŀ
;	       TURN BREAK KEY ON					       
;
SET_BREAK:
	       MOV     AX,CS		       ;SET DATA SEGMENT
	       MOV     DS,AX		       ;
	       CALL    BREAK_ON 	       ;SET UP CONTROL BREAK
;Ŀ
;	       FIND DISK MEMORY 					       
;
	       MOV     AX,OFFSET PROG_END      ;
	       MOV     BX,CS		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       SHR     AX,1		       ;
	       ADD     BX,AX		       ;
	       ADD     BX,8		       ;
	       MOV     WORD PTR DISK_BUFFER+2,BX	  ;
;Ŀ
;	       OPEN INPUT FILE						       
;
	       MOV     AH,3DH		       ;OPEN FILE FOR READ
	       MOV     AL,0H		       ;
	       MOV     DX,OFFSET FILENAME      ;
	       INT     21H		       ;
	       JNC     OIF100
OIF050:
	       MOV     DX,OFFSET OPEN_ERROR    ;
	       JMP     ERROR
OIF100:
	       MOV     HANDLE_IN,AX
;Ŀ
;	       READ IMG HEADER						       
;
	       MOV     AH,3FH
	       MOV     BX,HANDLE_IN
	       MOV     CX,44
	       MOV     DX,OFFSET IMG_NAME
	       INT     21H
;Ŀ
;	       MOVE PICTURE DATA BETWEEN FILES				       
;
PROCESS_PAC:

	       CALL    READ_IMAGE
	       CMP     AX,0
	       JE      PP200
	       CALL    COUNT_PIX
	       JMP     SHORT PROCESS_PAC
;Ŀ
;	       PRINT FINDINGS						       
;
PP200:
	       MOV     DX,OFFSET PROMPT1       ;TOTAL NUMBER OF PIXELS IN FILE
	       MOV     AH,9
	       INT     21H

	       MOV     AX,IMG_WIDTH_BYTE       ;HEIGHT * WIDTH
	       SHL     AX,1
	       SHL     AX,1
	       SHL     AX,1
	       MUL     IMG_HEIGHT

	       XCHG    DX,AX
	       CALL    BIN2HEX
	       XCHG    DX,AX
	       CALL    BIN2HEX

	       MOV     DX,OFFSET PROMPT2
	       MOV     AH,9
	       INT     21H

;	       MOV     AX,PIXEL_COUNT+4
;	       CALL    BIN2HEX
	       MOV     AX,PIXEL_COUNT+2
	       CALL    BIN2HEX
	       MOV     AX,PIXEL_COUNT
	       CALL    BIN2HEX
;Ŀ
;	       CLOSE FILES						       
;
CLOSE_FILE:
	       MOV     BX,HANDLE_IN	       ;CLOSE FILE
	       MOV     AH,3EH		       ;
	       INT     21H		       ;
	       JMP     EXIT
ERROR:
	       MOV     AX,CS
	       MOV     DS,AX
	       MOV     AH,9
	       INT     21H
EXIT:
	       CALL    BREAK_OFF	       ;BREAK KEY RESET
	       RET			       ;
MAIN	       ENDP

;ͻ
;  COUNT PIX  
;ͼ
;Ŀ
;	       AX= NUMBER OF BYTES TO COUNT PIXELS			       
;

COUNT_PIX      PROC    NEAR

	       PUSH    AX		       ;SAVE REGISTERS
	       PUSH    BX		       ;
	       PUSH    CX		       ;
	       PUSH    DX		       ;
	       PUSH    DI		       ;
	       PUSH    SI		       ;
	       PUSH    DS		       ;
	       PUSH    ES		       ;
	       cld
;Ŀ
;	       CLEAR FLAGS BUFFER					       
;
	       PUSH    AX
	       MOV     AX,CS
	       MOV     ES,AX
	       MOV     DS,AX
	       XOR     AX,AX
	       MOV     DI,OFFSET FLAGS
	       MOV     CX,256
	       REP     STOSW
	       POP     AX

;Ŀ
;	       SORT BYTES IN FILE					      
;
	       MOV     CX,AX		       ;USE AS COUNTER
	       PUSH    DS
	       LDS     SI,DISK_BUFFER	       ;FLAG ANY CHARACTER USED
	       MOV     DI,OFFSET FLAGS	       ;
FC400:
	       LODSB			       ;GET CHARACTER
	       MOV     BL,AL		       ;SETUP OFFSET WITH CHARACTER
	       XOR     BH,BH		       ;
	       SHL     BX,1
	       INC     WORD PTR ES:[DI+BX]     ;SET FLAG FOR CHARACTER
	       LOOP    FC400		       ;DO UNTIL DONE
	       POP     DS

;Ŀ
;	       COUNT ON PIXELS						       
;
FC550:
	       MOV     CX,256
	       XOR     BX,BX
	       MOV     SI,OFFSET BIT_TABLE
	       MOV     DI,OFFSET FLAGS


FC575:
	       PUSH    BX
	       SHL     BX,1
	       MOV     AX,[DI+BX]	       ;GET NUMBER OF BYTES OF SAME
	       POP     BX
	       MOV     DL,[SI+BX]
	       XOR     DH,DH
	       MUL     DX
	       ADD     PIXEL_COUNT,AX
	       JNC     FC600
	       CLC
	       INC     PIXEL_COUNT+2
	       JNC     FC600
	       INC     PIXEL_COUNT+4
FC600:
	       ADD     PIXEL_COUNT+2,DX
	       JNC     FC700
	       INC     PIXEL_COUNT+4
FC700:
	       INC     BX
	       LOOP    FC575
	       POP     ES		       ;RESTORE REGISTERS
	       POP     DS		       ;
	       POP     SI		       ;
	       POP     DI		       ;
	       POP     DX		       ;
	       POP     CX		       ;
	       POP     BX		       ;
	       POP     AX		       ;
	       RET

COUNT_PIX      ENDP
;ͻ
;  READ IMAGE   
;ͼ
READ_IMAGE     PROC    NEAR

	       PUSH    BX		       ;
	       PUSH    CX		       ;
	       PUSH    DX		       ;
	       PUSH    DS

	       MOV     AH,3FH		       ;
	       MOV     BX,HANDLE_IN	       ;
	       MOV     CX,8000H 	       ;
	       LDS     DX,DISK_BUFFER	       ;
	       INT     21H		       ;

	       POP     DS
	       POP     DX		       ;RESTORE REGISTERS
	       POP     CX		       ;
	       POP     BX		       ;
	       RET

READ_IMAGE     ENDP
;Ŀ
;
EOI	      EQU      20H		      ;END OF INTERRUPT
BRKINT	      EQU      1BH		      ;BREAK INTERRUPT
SAV_BRK       DW       ?
;ͻ
;  BREAK_ON  
;ͼ
	      PUBLIC   BREAK_ON
BREAK_ON      PROC     NEAR
	      PUSH     AX
	      PUSH     BX		       ;SAVE REGISTERS
	      PUSH     CX		       ;
	      PUSH     DX		       ;
	      PUSH     SI		       ;
	      PUSH     ES		       ;

	      XOR      BX,BX		       ;SEGMENT 0
	      MOV      ES,BX		       ;
	      MOV      SI,BRKINT*4	       ;OFFSET OF INTERUPT VECTOR

	      MOV      CX,ES:WORD PTR[SI]      ;OFFSET OF CURRENT VECT
	      MOV      DX,ES:WORD PTR[SI+2]    ;SEGMENT OF CURRENT VECT
	      MOV      CS:SAV_BRK,CX	       ;SAVE OFFSET
	      MOV      CS:SAV_BRK+2,DX	       ;SAVE SEGMENT

	      MOV      AX,OFFSET BREAK	       ;
	      CLI			       ;NO INTERRUPTS
	      MOV      ES:WORD PTR[SI],AX      ;SET OFFSET
	      MOV      AX,CS		       ;SET THIS CODE SEGMENT
	      MOV      ES:WORD PTR[SI+2],AX    ;MOVE SEG ADDR TO INT.VECT
	      STI			       ;INTERRUPTS BACK ON

	      POP      ES		       ;RESTORE REGISTERS
	      POP      SI		       ;
	      POP      DX		       ;
	      POP      CX		       ;
	      POP      BX		       ;
	      POP      AX		       ;
	      RET			       ;
BREAK_ON      ENDP
;ͻ
;  BREAK_OFF  
;ͼ
	      PUBLIC   BREAK_OFF
BREAK_OFF     PROC     NEAR

	      PUSH     AX		       ;
	      PUSH     CX		       ;
	      PUSH     DX		       ;
	      PUSH     DI		       ;
	      PUSH     ES		       ;

	      XOR      AX,AX		       ;
	      MOV      ES,AX		       ;SEGMENT 0
	      MOV      CX,CS:SAV_BRK	       ;RESET VECTOR BACK TO OLD RTN
	      MOV      DX,CS:SAV_BRK+2	       ;
	      MOV      DI,BRKINT*4	       ;
	      CLI			       ;NO INTERRUPTS
	      MOV      ES:WORD PTR[DI],CX      ;
	      MOV      ES:WORD PTR[DI+2],DX    ;
	      STI			       ;INTERRUPTS BACK ON

	      POP      ES		       ;
	      POP      DI		       ;
	      POP      DX		       ;
	      POP      CX		       ;
	      POP      AX		       ;
	      RET			       ;
BREAK_OFF     ENDP
;ͻ
;  BREAK   J
;ͼ
	      PUBLIC   BREAK
BREAK	      PROC     FAR

	      MOV      AX,CS
	      MOV      DS,AX
	      MOV      AL,EOI		       ;
	      OUT      020H,AL		       ;
	      CALL     BREAK_OFF
	      MOV      SP,OFFSET STACK-4       ;
	      RET

BREAK	      ENDP

;ͻ
;  BIN2HEX  
;ͼ
;Ŀ
;	       AX = HEX WORD						       
;
BIN2HEX        PROC    NEAR

	       PUSH    AX
	       PUSH    DX
	       MOV     DL,AH
	       CALL    HEX
	       MOV     DL,AL
	       CALL    HEX
	       POP     DX
	       POP     AX
	       RET
BIN2HEX        ENDP
;ͻ
;  HEX OUT 
;ͼ
;Ŀ
;	       DL = CHARACTER						       
;
HEX	       PROC	NEAR

	       PUSH    AX
	       PUSH    DX
	       MOV     DH,DL
	       AND     DL,0F0H
	       SHR     DL,1
	       SHR     DL,1
	       SHR     DL,1
	       SHR     DL,1
	       CMP     DL,10
	       JB      H100
	       ADD     DL,7
H100:
	       ADD     DL,30H
	       MOV     AH,2
	       INT     21H
	       MOV     DL,DH
	       AND     DL,0FH
	       CMP     DL,10
	       JB      H200
	       ADD     DL,7
H200:
	       ADD     DL,30H
	       MOV     AH,2
	       INT     21H
	       POP     DX
	       POP     AX
	       RET

HEX	       ENDP
;Ŀ
;
BIT_TABLE      DB      0,1,1,2,1,2,2,3,1,2,2,3,3,3,3,4
	       DB      1,2,2,3,2,3,3,4,2,3,3,4,4,4,4,5
	       DB      1,2,2,3,2,3,3,4,2,3,3,4,4,4,4,5
	       DB      2,3,3,4,3,4,4,5,3,4,4,5,5,5,5,6
	       DB      1,2,2,3,2,3,3,4,2,3,3,4,4,4,4,5
	       DB      2,3,3,4,3,4,4,5,3,4,4,5,5,5,5,6
	       DB      2,3,3,4,3,4,4,5,3,4,4,5,5,5,5,6
	       DB      3,4,4,5,4,5,5,6,4,5,5,6,6,6,6,7
	       DB      1,2,2,3,2,3,3,4,2,3,3,4,4,4,4,5
	       DB      2,3,3,4,3,4,4,5,3,4,4,5,5,5,5,6
	       DB      2,3,3,4,3,4,4,5,3,4,4,5,5,5,5,6
	       DB      3,4,4,5,4,5,5,6,4,5,5,6,6,6,6,7
	       DB      3,4,4,5,4,5,5,6,4,5,5,6,6,6,6,7
	       DB      3,4,4,5,4,5,5,6,4,5,5,6,6,6,6,7
	       DB      3,4,4,5,4,5,5,6,4,5,5,6,6,6,6,7
	       DB      4,5,5,6,5,6,6,7,5,6,6,7,7,7,7,8
FLAGS	       DW      256 DUP(0)
	       DB      64 DUP('STACK')
STACK	       EQU     $
PROG_END       EQU     $
CSEG	       ENDS
	       END     MAIN
