#include <stdio.h>
#include <fcntl.h>
#include <types.h>
#include <stat.h>
#include <io.h>
#include <dos.h>
#include <math.h>
#include <argparse.h>

static	char * tutorial[] = {
	"\nFormat is:\n\tmac picname <outname> <-m> <-n> <-t> <-c zz> <-p qqq>",
	"<-x x.x> <-y y.y>\n\n",
	"\tpicname is the name of the input readmac file\n",
	"\toutname (optional) is the output file name\n",
	"\t\twith MAC.LST as a default (device name\n",
	"\t\tsuch as LPT2 is ok also)\n",
	"\t-m\tdon\'t eject after printing\n",
	"\t-n\tproduce negative copy of image\n",
	"\t-t\tadd title (if any) after picture\n",
	"\t-c zz\t(optional) produce zz copies, 0 < zz < 100\n",
	"\t\tdefault number of copies is 1\n",
	"\t-p qqq\t(optional) pells/inch, qqq = 100, 150 or 300\n",
	"\t\tdefault pells is 100\n",
	"\t-x x.x\t(optional) x offset in fractional inches\n",
	"\t\tdefault offset is 1.0 inch from left edge\n",
	"\t-y y.y\t(optional) y offset in fractional inches\n",
	"\t\tdefault offset is 0.5 inch from top edge\n",
	NULL };
#define linelen  60  /* was 72 */
static	unsigned char buff[74];
static	unsigned char wline[] = { 0x80, linelen };
static	unsigned char header[] = { 0x00,0x01, 0x00,0x08, 0x00,0x01, 0x00,0x02,
				   0x01,0xA3, 0x01,0xFC, 0x01,0xe0, 0x02,0xd0 };
static	unsigned int  bcnt;
FILE	*f = NULL;
int	c = 0;
int	copies = 1;
int	pells = 100;
int	print = 0;
int	neg = 0;
int	x_offset = 810;
int	y_offset = 360;

void putline()
{
register int i;
	buff[72] = 0x00;
	write(print,wline,2);
	if(neg != 0)
	   for(i=0;i<72;i++)
	      buff[i] = ~buff[i];
	for(i=0;i<linelen;i++)
	   buff[i] = buff[i+6];
	write(print,buff,linelen);
}

int expand(rep)
int rep;
{
	rep = 257 - rep;	/* rep count */
	c = fgetc(f);		/* read count */
	if(c == EOF) {
	   printf("Error - unexpected eof\n");
	   exit(1);
	   }
	for(;rep;rep--,bcnt++) {
	   buff[bcnt] = c;
	   if(bcnt == 72) break;
	   }
}

int getline()
{
int  i,j;
	bcnt = 0;
	while(bcnt < 72) {
	   j = fgetc(f);		/* read count */
	   if(j == EOF) {
	      printf("Warning - unexpected EOF\n");
	      return(1);
	      }
	   if(j > 127) expand(j);
	   else {
	      j++;
	      if((j+bcnt) > 72) j = 71 - bcnt;
	      i = fread(&buff[bcnt],1,j,f);
	      if(i != j) {
		 printf("Warning - unexpected EOF\n");
		 return(1);
		 }
	      bcnt += j;
	      }
	   }
	   return(0);
}

void ioctl(handle)
int  handle;
{
union REGS inregs,outregs;
	inregs.x.ax = 0x4400;
	inregs.x.bx = handle;
	intdos(&inregs,&outregs);

	if(outregs.h.dl & 0x80) {
	   inregs.x.ax = 0x4401;
	   inregs.h.dh = 0;
	   inregs.h.dl |= 0x20;
	   intdos(&inregs,&outregs);
	   }
}

char	*set_copy(ch,st)
char	ch;
char	*st;
{
	copies = atoi(st);
	if((copies < 1) || (copies > 99)) {
		copies = 1;
		fprintf(stderr,"-c parm invalid, set to 1\n");
		}
	return(NULL);
}

char	*set_pells(ch,st)
char	ch;
char	*st;
{
	pells = atoi(st);
	if((pells != 100) && (pells != 150) && ( pells != 300)) {
		pells = 100;
		fprintf(stderr,"-p parm invalid, set to 100\n");
		}
	return(NULL);
}

char	*set_files(ch,st)
char	ch;
char	*st;
{
	if(f == NULL)
		f = fopen(st,"rb");
	else
		print = open(st,O_WRONLY | O_BINARY | O_CREAT | O_TRUNC,S_IWRITE);
	return(NULL);
}

char	*set_xy(ch,st)
char	ch;
char	*st;
{
double	d;
	d = atof(st);
	d *= 720.0;
	if((ch == 'x') || (ch == 'X')) x_offset = d;
	if((ch == 'y') || (ch == 'Y')) y_offset = d;
	return(NULL);
}

void	setseek()
{
char	tmpbuf[132];
int	i;
long	junk;

	fread(tmpbuf,1,132,f);
	tmpbuf[68] = '\0';
	junk = 0l;

	if( (strcmp(&tmpbuf[65],"PNT") == 0) ||
	  ( (tmpbuf[128] == tmpbuf[129] == tmpbuf[130] == '\0') &&
	    ((tmpbuf[131] == '\002') || (tmpbuf[131] == '\003')) ) )
		junk = 640l;
	else
	  if( (tmpbuf[0] == tmpbuf[1] == tmpbuf[2] == '\0') &&
	    ( (tmpbuf[3] == '\002') || (tmpbuf[3] == '\003')) )
		junk = 512l;

	if(junk != 0l) printf("Bypassing %ld bytes ...\n",junk);
	else {
		fprintf(stderr,"Can't determine file type\n");
		exit(1);
		};

	i = fseek(f,junk,0);
	if(i) {
	   perror("Pattern bypass seek failed");
	   exit(1);
	   }

}

void	main(argCount, argVector)
int	argCount;
char	*argVector[];
{
int	i,count;
long	where;
int	f_flag = 0;
int	m_flag = 0;
int	t_flag = 0;
char	*t_text = (char *) 0;

#define ArgCount  argCount
#define ArgVector argVector
#include <argbegin.h>
	ArgMin	      (1)
	ArgMax	      (2)
	ArgDescription(tutorial)
	ArgPosCall(set_files)
#include <argloop.h>
	ArgTextCall ('c', set_copy)
	ArgTextCall ('C', set_copy)
	ArgTextCall ('p', set_pells)
	ArgTextCall ('P', set_pells)
	ArgTextCall ('x', set_xy)
	ArgTextCall ('X', set_xy)
	ArgTextCall ('y', set_xy)
	ArgTextCall ('Y', set_xy)
	ArgFlagSet  ('n', neg)
	ArgFlagSet  ('N', neg)
	ArgFlagSet  ('m', m_flag)
	ArgFlagSet  ('M', m_flag)
	ArgFlagSet  ('t', t_flag)
	ArgFlagSet  ('T', t_flag)
#include <argend.h>


	if(print == 0)
	   print = open("MAC.IMG",O_WRONLY | O_BINARY | O_CREAT | O_TRUNC,S_IWRITE);

	if(f == NULL) {
	   perror("Can\'t open input file");
	   exit(1);
	   }

	if(print == -1) {
	   perror("Can\'t open output file");
	   exit(1);
	   }

	ioctl(print);
	setseek();

	write(print,header,16); /* Write out the header info */

	for(count=0;count < 720;count++) {
	   if(getline()) break;
	   putline();
	   }

	where = ftell(f);
	printf("Complete at %ld\n",where);

	close(print);
	fclose(f);

}
