	title '2mixed -- converts all-uppercase text to mixed case'

;
; (c) 1986 Eric Grunin
;	   240 West 98 Street
;	   New York, New York 10025
;
;
; All rights reserved, including right of distribution for profit.
;
; This may be freely copied, used in your own programs, etc., though
; if you make a million bucks I wouldn't mind if you sent me a couple.
;
; Have fun, EG
;

	page	,132	;
cr	equ	0Dh
lf	equ	0Ah
true	equ	0
false	equ	-1
blksize	equ	0F000h

;;Macro to do multiple compares.
;;Usage:
;;	Mcmp	Al,<10,11,13>,Ignore	;;Would jump to IGNORE if AL=10,11 or 13
Mcmp	Macro	Reg,Val,Addr	;;Macro to do multiple compares,
	Irp	Tmp,<Val>	;;For each value,
	Cmp	Reg,Tmp 	;;Do a compare,
	je	Addr		;;And jump to this addr.
	Endm			;;End IRP
	Endm			;;End Mcmp Macro


Locase  Macro	Reg
	local	dummy
	cmp	reg,'A'
	jl	dummy
	cmp	reg,'Z'
	jg	dummy
	add	reg,'a'-'A'
dummy:
	endm

Type	Macro	Text		;;Macro to type a string.
	Mov	Ah,09H		;;DOS Func. --> print string.
	Mov	Dx,Offset Text	;;Get offset,
	Int	21H		;;And call it.
	Endm

Instr	Macro	Buffer		;;Read string from console.
	Mov	Ah,0AH		;;Function --> Read string.
	Mov	Dx,Offset Buffer;;Use his offset,
	Int	21H		;;And do.
	Endm

Open	Macro	Addr,Handle,Mode;;Addr to get name, handle is place to
				;; put handle.
	Mov	Ah,3DH		;;OPEN function.
				;;Setup mode:
	Ifidn	<Mode>,<READ>
	 Mov	Al,0
	Endif
	Ifidn	<Mode>,<WRITE>
	 Mov	Al,1
	Endif
	Ifidn	<Mode>,<BOTH>
	 Mov	Al,2
	Endif
	Mov	Dx,Offset Addr	;;Addr to look for file name.
	Int	21H		;;And call DOS.
	Mov	Handle,Ax	;;Save handle.
	Endm

Close	Macro	Handle		;;To close a file.
	Mov	Ah,3EH		;;Close it.
	Mov	Bx,Handle	;;Get handle
	Mov	Dx,Offset handle
	Int	21H		;;Call DOS.
	Endm

Read	Macro	Addr,Count,Handle;;Read in from disk.
	Mov	Ah,3FH		;;Function --> read.
	Mov	Bx,Handle	;;Get handle.
	Mov	Cx,Count	;;Get # bytes wants to read.
	Mov	Dx,Offset Addr	;;And get addr of buffer.
	Int	21H		;;And let DOS do that.
	Endm

Create	Macro	Addr,Handle	;;Create file.
	Mov	Ax,3C00H	;;Create file...
	Mov	Cx,0		;;Attribute of 0.
	Mov	Dx,Offset Addr	;;Addr to look for name.
	Int	21H
	Mov	Handle,Ax	;;Save handle.
	Endm

cseg	segment	para public 'CODE'
	assume	cs:cseg,ds:cseg,es:cseg
	org	100h


begin:	jmp	short start

eofsw		db	true

inhandle	dw	0
outhandle	dw	0

titlemsg	db	'2mixed: change uppercase to mixed case$'
infile_msg	db	cr,lf,'Input file (CR to exit): $'
outfile_msg	db	cr,lf,'Output file (CR to exit): $'

openerr_msg	db	cr,lf,'File not found$'

;---------------------------

start:	type	titlemsg

	mov	si,offset buffer

init:	call	init_files		; get filenames, open

mainloop:
 	mov	al,byte ptr [bx+si]	; get char
	inc	bx
	;==========================
	cmp	dh,false		; if cap_flag = true  
	jne	D0
	call	is_symbol		;	if previous char not symbol
	jc	C01
	locase	al			;       	a = locase(a)
C01:	jmp	short 	E0		;	endif
					; else
D0:	cmp	ah,'.' 			;     if prev char was '.',
	jne	D01			;         a = locase(a)
	locase	al			;     endif
					;     
D01:	mov	dh,false		;     cap_flag = false
	cmp	al,32			;     if it's ' ', tab, CRLF, etc.
	jg	E0			; 	  clear cap_flag
	mov	dh,true			;     endif	  	   
					; endif
	;==========================
E0:	mcmp	al,<'.','"','?'>,F0
	jmp	short 	G0		; if sentence terminator or '"'
F0:	mov	dh,true			;       cap_flag = true
G0:	mov	ah,al			; save char in ah
	mov	byte ptr [si+bx-1],al	; put translated char back in buffer

	loop	mainloop		; loop till out of chars
	push	dx
	mov	cx,bx
	mov	bx,outhandle
	mov	dx,offset buffer
	mov	ah,40h
	int	21h			; write it out
	pop	dx
	cmp	dl,true			; did we hit eof on last read?
	je	finish			; if so, finish up
	call 	fillbuff		; else, fill it up again
	jmp	short 	mainloop	; and start over

finish:	close	inhandle		; close files
	close	outhandle

	jmp	short 	init		; start all over again

;---------------------------------------
is_symbol proc
; if char is printable but non-alpha, set carry 
	clc
	cmp	ah,'z'		; mask out a-z
	jg	is_symbol0
	cmp	ah,'a'		; 
	jge	is_symbol2

is_symbol0:
	mcmp	ah,<' ',39,'-'>,is_symbol2	; "'","-" are special cases

	cmp	ah,'Z'		; mask out A-Z
	jg	is_symbol1		;      
	cmp	ah,'A'		;      
	jge	is_symbol2

	cmp	ah,' '		; mask out < 32
	jl	is_symbol2

is_symbol1:
	stc
is_symbol2:
	ret
is_symbol endp

;---------------------------------------

fillbuff proc
	mov	dl,false
	read	buffer,blksize,inhandle
	mov	bx,0
	mov	dh,0			; clear cap_flag
	cmp	ax,cx
	je	fillbuff1
	mov	cx,ax
	mov	dl,true
fillbuff1:
	ret

fillbuff endp

;---------------------------------------

init_files proc
	push	si
	type	infile_msg
	mov	byte ptr inf_name_buff,128
	instr	inf_name_buff
	cmp	byte ptr inf_name_buff+1,0
	jne	getout
	jmp	short 	byebye


getout:	type	outfile_msg
	mov	byte ptr out_name_buff,128
	instr	out_name_buff
	cmp	byte ptr out_name_buff+1,0
	je	byebye

	mov	si,offset inf_name_buff+2
	sub	bx,bx
	mov	bl,byte ptr inf_name_buff+1
	mov	byte ptr [si+bx],0

	mov	dl,false
	open	inf_name_buff+2,inhandle,READ
	jnc	openout
	jmp	short 	openerr

openout:
	mov	si,offset out_name_buff+2
	sub	bx,bx
	mov	bl,byte ptr out_name_buff+1
	mov	byte ptr [si+bx],0

	create	out_name_buff+2,outhandle
	jc	openerr	
	pop	si
	call	fillbuff		; successful open of both files
	ret

openerr:
	type	openerr_msg
	
byebye:	mov	ax,4C00h
	int	21h	


init_files endp

buffer	equ	$

inf_name_buff	equ	$

out_name_buff	equ	inf_name_buff+130

;----------------------------

cseg	ends
	end	begin

