	title '2mixed -- converts all-uppercase text to mixed case'

;
; (c) 1986 Eric Grunin
;	   240 West 98 Street
;	   New York, New York 10025
;
;
; All rights reserved, including right of distribution for profit.
;
; This may be freely copied, used in your own programs, etc., though
; if you make a million bucks I wouldn't mind if you sent me a couple.
;
; Have fun, EG
;


; this version is "filter" style - uses stdin and stdout to read + write

	page	,132	;
cr	equ	0Dh
lf	equ	0Ah
true	equ	0
false	equ	-1
blksize	equ	0F000h

;;Macro to do multiple compares.
;;Usage:
;;	Mcmp	Al,<10,11,13>,Ignore	;;Would jump to IGNORE if AL=10,11 or 13
Mcmp	Macro	Reg,Val,Addr	;;Macro to do multiple compares,
	Irp	Tmp,<Val>	;;For each value,
	Cmp	Reg,Tmp 	;;Do a compare,
	je	Addr		;;And jump to this addr.
	Endm			;;End IRP
	Endm			;;End Mcmp Macro


Locase  Macro	Reg
	local	dummy
	cmp	reg,'A'
	jl	dummy
	cmp	reg,'Z'
	jg	dummy
	add	reg,'a'-'A'
dummy:
	endm

Close	Macro	Handle		;;To close a file.
	Mov	Ah,3EH		;;Close it.
	Mov	Bx,Handle	;;Get handle
	Mov	Dx,Offset handle
	Int	21H		;;Call DOS.
	Endm

Read	Macro	Addr,Count,Handle;;Read in from disk.
	Mov	Ah,3FH		;;Function --> read.
	Mov	Bx,Handle	;;Get handle.
	Mov	Cx,Count	;;Get # bytes wants to read.
	Mov	Dx,Offset Addr	;;And get addr of buffer.
	Int	21H		;;And let DOS do that.
	Endm

cseg	segment	para public 'CODE'
	assume	cs:cseg,ds:cseg,es:cseg
	org	100h


begin:	mov	si,offset buffer
 	call	fillbuff

mainloop:
 	mov	al,byte ptr [bx+si]	; do while not eof
	inc	bx
	cmp	dh,false		
	jne	D0			; if cap_flag = false

	;================		

	clc
	cmp	ah,'z'		; mask out a-z
	jg	is_symbol0
	cmp	ah,'a'		; 
	jge	is_symbol2

is_symbol0:
	mcmp	ah,<' ',39,'-'>,is_symbol2	; "'","-" are special cases

	cmp	ah,'Z'		; mask out A-Z
	jg	is_symbol1		;      
	cmp	ah,'A'		;      
	jge	is_symbol2

	cmp	ah,' '		; mask out < 32
	jl	is_symbol2

is_symbol1:
	stc
is_symbol2:
	jc	C01

	locase	al			;       	a = locase(a)
C01:	jmp	short	E0		;	endif
					; else
D0:	cmp	ah,'.' 			;     if prev char was '.',
	jne	D01			;         locase anyway
	locase	al			;     endif
					;     clear cap_flag
D01:	mov	dh,false		;     if char is ' ',tab,CRLF, etc
	cmp	al,32				  
	jg	E0			;         set cap_flag
	mov	dh,true			;     endif
					; endif
	;================

E0:	mcmp	al,<'.','"','?'>,F0	; if sentence terminator or '"'
	jmp	short	G0		;	cap_flag = true
F0:	mov	dh,true			; endif      
G0:	mov	ah,al			; save char in ah
	mov	byte ptr [si+bx-1],al	; put translated char back in buffer

	;================
	loop	mainloop		; loop till out of chars
	push	dx
	mov	cx,bx
	mov	bx,1
	mov	dx,offset buffer
	mov	ah,40h
	int	21h			; write it out
	pop	dx
	cmp	dl,true			; did we hit eof on last read?
	je	finish			; if so, finish up
	call 	fillbuff		; else, fill it up again
	jmp	mainloop		; and start over

finish:	close	0			; close files
	close	1

	mov	ah,4ch
	int	21h

;---------------------------------------

fillbuff proc
	mov	dl,false
	read	buffer,blksize,0
	mov	bx,0
	mov	dh,0			; clear cap_flag
	cmp	ax,cx
	je	fillbuff1
	mov	cx,ax
	mov	dl,true
fillbuff1:
	ret

fillbuff endp

buffer	equ	$

inf_name_buff	equ	$

out_name_buff	equ	inf_name_buff+130

;----------------------------

cseg	ends
	end	begin

