'This module is used to demonstrate the usage of WinPS. It simulates three
'input streams by using Random numbers. Most of the features of WinPS are included
'in this demonstration, but feel free to experiment further.

'The version of WinPS that accompanies this demo is limited to three input streams,
'three Control break levels and a maximum combined key length of six bytes.
'The full version supports nine input streams, nine control break levels and
'a maximum key length of 127 bytes which should be sufficient for all but the
'worst cases.

Option Explicit
Option Compare Binary
DefInt A-Z
Global LogFile          As Integer

Declare Function GlobalDosAlloc Lib "Kernel" (ByVal cbAlloc As Long) As Long
Declare Sub GlobalDosFree Lib "Kernel" (ByVal uSelector As Integer)

Type Registers                ' For use with DOSInt
     AX     As Integer
     BX     As Integer
     CX     As Integer
     DX     As Integer
     DI     As Integer
     SI     As Integer
     BP     As Integer
     DS     As Integer
     ES     As Integer
     Flags  As Integer
End Type
     Global Reg As Registers

'    Processor Flags
     Global Const CarryFlag = &H1
     Global Const ParityFlag = &H4
     Global Const AuxCarryFlag = &H10
     Global Const ZeroFlag = &H40
     Global Const SignFlag = &H80
     Global Const TrapFlag = &H100
     Global Const InterruptEnableFlag = &H200
     Global Const DirectionFlag = &H400
     Global Const OverflowFlag = &H800

'    WinPS
     Declare Function WinPS Lib "WINPS.DLL" (PSField As Any) As Integer

'    Convert Intel-Format LoHi to Binary HiLo
     Declare Function SwpWord Lib "WINPS.DLL" (ByVal wrd As Integer) As Integer
     Declare Function SwpLong Lib "WINPS.DLL" (ByVal lng As Long) As Long

'    Returns Lo / Hi Byte of Integer
     Declare Function LoByte Lib "WinPS.DLL" (ByVal wrd As Integer) As Integer
     Declare Function HiByte Lib "WinPS.DLL" (ByVal wrd As Integer) As Integer

'    Returns Lo / Hi Word of Long
     Declare Function LoWord Lib "WinPS.DLL" (ByVal lng As Long) As Integer
     Declare Function HiWord Lib "WinPS.DLL" (ByVal lng As Long) As Integer

'    Combines two Integers into a Long (sign of LoWrd is lost, sign of HiWrd is kept)
     Declare Function MakeLong Lib "WinPS.DLL" (ByVal hiwrd As Integer, ByVal lowrd As Integer) As Long

'    Shift Left / Right  Integer / Long  (when places positive shifts left, negative shifts right)
     Declare Function ShiftWord Lib "WinPS.DLL" (ByVal wrd As Integer, ByVal places As Integer) As Integer
     Declare Function ShiftLong Lib "WinPS.DLL" (ByVal lng As Long, ByVal places As Integer) As Long

'    Move any Type of Data  (Strings and Pointers must be ByValue, all others ByReference)
     Declare Sub MoveData Lib "WinPS.DLL" (ByVal length As Integer, source As Any, destination As Any)

'    Get a Pointer to a Variable  HiWord is Selector LoWord is Offset
     Declare Function AddressOf Lib "WinPS.DLL" (variable As Any) As Long

'    Call DOS Interrupt in Real Mode
     Declare Function DOSInt Lib "WinPS.DLL" (ByVal Interrupt As Integer, InRegs As Registers, OutRegs As Registers) As Integer

'    Stop Processor and Lock
     Declare Sub StopProc Lib "WINPS.DLL" ()

Type UserKey                        'User's key structure
     Country         As Integer
     State           As Integer
     City            As Integer
End Type

Type Info
     Status          As String * 1  'Tell WinPS about Stream: "1" = Skip record (default in M2x)
				    '                      "2" = Release record to processing
				    '                      "3" = No more records from stream
				    '                      "4" = Stream is optional and not present
     
     Key             As UserKey     'User's key structure

     number          As String * 1  'Stream Priority: Records from different streams are
				    'processed in priority sequence when they have equal keys
End Type

Type PSField
     Modul           As String * 2  'Module number 00 .. 80
     Switch          As String * 1  'Switch for On .. GoSub
     NumbStreams     As String * 1  'Number of streams normally present
     NumbGroups      As String * 1  'Number of groups to control
     Match(1 To 9)   As String * 1  'Indicates matching Records: S = Selected Stream
				    '                            M = Matching Stream
				    '                            - = Neither
     Group           As Info
     Stream(1 To 3)  As Info
End Type

Type Record
     Country         As Integer
     State           As Integer
     City            As Integer
'    Further Record Fields...
End Type


Dim PS               As PSField

Dim Record1          As Record
Dim Record2          As Record
Dim Record3          As Record

'The following Code Fragment uses some of the other WinPS functions and returns
'a drive media number. I use this sometimes for software copy protection
'
Function GetMediaNum (Disk As String) As Long

  Dim DOSBuff As Long, Selector As Integer, Segment As Integer, d$

    DOSBuff = GlobalDosAlloc(128)           ' Get 128 bytes in Lower Memory
    If DOSBuff <> 0 Then                    ' OK
	Selector = LoWord(DOSBuff)          ' Split into Prot-Selector and Real-Segment
	Segment = HiWord(DOSBuff)
	DOSBuff = 0
	d$ = UCase$(Left$(Disk, 2))         ' Drive

	Reg.AX = &H6900                          ' DOS Int 21 Service 6900 Only in Real Mode
	Reg.BX = IIf(IsNumeric(d$), Val(d$), Asc(d$) - Asc("A") + 1)    'Drive Num
	Reg.DS = Segment                    ' Segment for return
	Reg.DX = 0                              ' Offset for Return

	If DOSInt(&H21, Reg, Reg) Then      ' Call DOS Service in RealMode
	    If (Reg.Flags And CarryFlag) = 0 Then
		MoveData 4, ByVal MakeLong(Selector, 2), DOSBuff    'MediaNum is at Ofs 2
	    End If
	End If
	GlobalDosFree Selector              ' Free Memory !!!
    End If
    GetMediaNum = DOSBuff                   ' Return Result

End Function

Sub TestPS ()

  Dim EoR              As Integer     'signals End of Run when True
  Dim MediaNum         As Long

    
'   Supply the initial paramaters to WinPS.
    PS.Modul = "??"                'internal initialization is required because
				   'WinPS may be reused in several different Subs
    PS.NumbStreams = "3"           'tell it we got three input-streams
    PS.NumbGroups = "3"            'and we want it to trigger three control-break-levels

    PS.Group.Status = "<"          'mark beginning of key structure

    PS.Group.Key.Country = &H3333  'mark Country with all "3"
    PS.Group.Key.State = &H3232    'mark State with all "2"
    PS.Group.Key.City = &H3131     'mark City with all "1"

    PS.Group.number = ">"          'mark end of key structure
    
    
    EoR = False
    
'   The main program loop is executed until something signals End of Run.
    Do
	On WinPS(PS) GoSub M00, M01, M02, M03, M11, M12, M13, M21, M22, M23, M30, M41, M42, M43, M51, M52, M53, M61, M62, M63, M70, M80
	If PS.Modul > "80" Then
'           we have an error in the initial parameters or a runtime error
'           the error number is in PS.Modul
	    MsgBox "WinPS Error " & PS.Modul
	    Print #LogFile, "Error "; PS.Modul; " detected."
	    GoSub M80
	End If
    Loop Until EoR
    Print #LogFile, "Terminating Program"
    MediaNum = GetMediaNum("C")

    Print #LogFile, "Your Fixed Drive C has Media Number "; Hex$(HiWord(MediaNum)); "_"; Hex$(LoWord(MediaNum))
    
Exit Sub

'-----------------------------------------------------------------------
M00:
'   This module is requested once in the beginning and may perform such work
'   as initializing variables, opening output files and input files not controlled by WinPS,
'   gather initial run-parameters or display initial messages.
'   This is also the place to switch optional input streams off.

    Screen.MousePointer = 11

    Print #LogFile, "Initializing Program"
Rem PS.Stream(1).Status = "4"                       'to switch stream 1 off
Rem PS.Stream(2).Status = "4"                       'to switch stream 2 off
Rem PS.Stream(3).Status = "4"                       'to switch stream 3 off
    Print #LogFile, Tab(70); "Initializing Processing"
    Randomize
    Return
'-----------------------------------------------------------------------
M01:
'   This modul is requested once if stream 1 has not been switched off during M00. It
'   must open and if necessary position input stream 1 at it's first record.

    Print #LogFile, "Opening Input Stream 1"
    Record1.Country = 0
    Record1.State = 0
    Record1.City = 0
    Return
'-----------------------------------------------------------------------
M02:
'   This modul is requested once if stream 2 has not been switched off during M00. It
'   must open and if necessary position input stream 2 at it's first record.

    Print #LogFile, "Opening Input Stream 2"
    Record2.Country = 0
    Record2.State = 0
    Record2.City = 0
    Return
'-----------------------------------------------------------------------
M03:
'   This modul is requested once if stream 3 has not been switched off during M00. It
'   must open and if necessary position input stream 3 at it's first record.

    Print #LogFile, "Opening Input Stream 3"
    Record3.Country = 0
    Record3.State = 0
    Record3.City = 0
    Return
'-----------------------------------------------------------------------
M11:
'   This module is requested whenever WinPS determines that the next record is reqired
'   from stream 1. The module either puts the next record in it's buffer or tells WinPS
'   that there is no next record, in which case it also may close stream 1.

    If Record1.Country > 2 Then                  'simulate end of stream
	Print #LogFile, "Closing Input Stream 1"
	PS.Stream(1).Status = "3"                'tell WinPS by setting Stream(1).Status to 3.
      Else
	Print #LogFile, "Reading Input Stream 1"
	Record1.Country = Record1.Country + (Rnd - .3)
	Record1.State = Record1.State + (Rnd - .3)
	Record1.City = Record1.City + (Rnd - .3)
    End If
    Return
'-----------------------------------------------------------------------
M12:
'   This module is requested whenever WinPS determines that the next record is reqired
'   from stream 2. The module either puts the next record in it's buffer or tells WinPS
'   that there is no next record, in which case it also may close stream 2.

    If Record2.Country > 4 Then                   'simulate end of stream
	Print #LogFile, "Closing Input Stream 2"
	PS.Stream(2).Status = "3"                 'tell WinPS by setting Stream(2).Status to 3.
      Else
	Print #LogFile, "Reading Input Stream 2"
	Record2.Country = Record2.Country + (Rnd - .3)
	Record2.State = Record2.State + (Rnd - .3)
	Record2.City = Record2.City + (Rnd - .3)
    End If
    Return
'-----------------------------------------------------------------------
M13:
'   This module is requested whenever WinPS determines that the next record is reqired
'   from stream 3. The module either puts the next record in it's buffer or tells WinPS
'   that there is no next record, in which case it also may close stream 3.

    If Record3.Country > 5 Then                   'simulate end of stream
	Print #LogFile, "Closing Input Stream 3"
	PS.Stream(3).Status = "3"                 'tell WinPS by setting Stream(3).Status to 3.
      Else
	Print #LogFile, "Reading Input Stream 3"
	Record3.Country = Record3.Country + (Rnd - .3)
	Record3.State = Record3.State + (Rnd - .3)
	Record3.City = Record3.City + (Rnd - .3)

    End If
    Return
'-----------------------------------------------------------------------
M21:
'   This module is requested when a new record from stream 1 is available it's buffer.
'   The module may check the record to determine wether it should be released
'   to Processing and if so extract the keys which control the group-changes and tell
'   WinPS about this fact by setting Stream(1).Status to 2.
'   The default is NOT to release a record.
'   This module may also decide that further processing of stream 1 is not required
'   and inform WinPS about this fact by setting Stream(1).Status to 3.

    Print #LogFile, "Filtering Input Stream 1: "; Record1.Country; Record1.State; Record1.City

							  'WinPS is not aware of the format
							  'of the key elements and there-
    PS.Stream(1).Key.Country = SwpWord(Record1.Country)    'fore uses a binary compare.
    PS.Stream(1).Key.State = SwpWord(Record1.State)        'So we have to swap the Intel binary
    PS.Stream(1).Key.City = SwpWord(Record1.City)          'format into the real binary format
    PS.Stream(1).Status = "2"
    Return
'-----------------------------------------------------------------------
M22:
'   This module is requested when a new record from stream 2 is available it's buffer.
'   The module may check the record to determine wether it should be released
'   to Processing and if so extract the keys which control the group-changes and tell
'   WinPS about this fact by setting Stream(2).Status to 2.
'   The default is NOT to release a record.
'   This module may also decide that further processing of stream 2 is not required
'   and inform WinPS about this fact by setting Stream(2).Status to 3.

    Print #LogFile, "Filtering Input Stream 2: "; Record2.Country; Record2.State; Record2.City

Rem If Record2.State And 1 Then                            'as an example to filtering, stream 2
	PS.Stream(2).Key.Country = SwpWord(Record2.Country) 'can be made to release only records
	PS.Stream(2).Key.State = SwpWord(Record2.State)     'with an odd Record2.State
	PS.Stream(2).Key.City = SwpWord(Record2.City)       '(un-Rem If & End If)
	PS.Stream(2).Status = "2"
Rem End If
    Return
'-----------------------------------------------------------------------
M23:
'   This module is requested when a new record from stream 3 is available it's buffer.
'   The module may check the record to determine wether it should be released
'   to Processing and if so extract the keys which control the group-changes and tell
'   WinPS about this fact by setting Stream(3).Status to 2.
'   The default is NOT to release a record.
'   This module may also decide that further processing of stream 3 is not required
'   and inform WinPS about this fact by setting Stream(3).Status to 3.
				  
    Print #LogFile, "Filtering Input Stream 3: "; Record3.Country; Record3.State; Record3.City
    PS.Stream(3).Key.Country = SwpWord(Record3.Country)
    PS.Stream(3).Key.State = SwpWord(Record3.State)
    PS.Stream(3).Key.City = SwpWord(Record3.City)
    PS.Stream(3).Status = "2"
Rem If Record3.Country > 3 Then                         'simulate early end of stream
Rem     Print #LogFile, "Early closing Input Stream 3"  'tell WinPS by setting Stream(3).Status to 3.
Rem     PS.Stream(3).Status = "3"
Rem End If
    Return
'-----------------------------------------------------------------------
M30:
'   When WinPS detects a sequence error in one of the streams then this module is
'   called to handle the exception. If more than one stream is under the control
'   of WinPS then a sequence error is fatal and WinPS will not continue because merging
'   unsorted streams is not meaningful. If WinPS is called after a fatal error then
'   WinPS produces an error

    Print #LogFile, "Sequence Error in Stream: "; PS.Group.number; " at ";

'   Because WinPS supplies the Group-keys as is, we have to swap then back to Intel binary format
    Print #LogFile, SwpWord(PS.Group.Key.Country); SwpWord(PS.Group.Key.State); SwpWord(PS.Group.Key.City)
    
    GoSub M70
    GoSub M80
    
    Return
'-----------------------------------------------------------------------
M43:
'   This module is called when WinPS detects a control-break at level 3 which
'   is the most significant (changes the least often).
'   It is also called at program begin.
'   The module must initialize group 3 specific variables.
'   When a report is being printed, then group-specific headlines may be built
'   but not yet output. Instead an indicator should be set to true indicating
'   that the printing of headlines is due.

    Print #LogFile, Tab(70); "  Initializing Group 3 of " & PS.Group.Status & " :  Group Key  ";

'   Because WinPS supplies the Group-keys as is, we have to swap then back to Intel binary format
    Print #LogFile, SwpWord(PS.Group.Key.Country); PS.Match(1); PS.Match(2); PS.Match(3)
    
    Return
'-----------------------------------------------------------------------
M42:
'   This module is called when WinPS detects a control-break at level 2.
'   It is also called when a more significant control-break was called.
'   The module must initialize group 2 specific variables.
'   When a report is being printed, then group-specific headlines may be built
'   but not yet output. Instead an indicator should be set to true indicating
'   that the printing of headlines is due.

    Print #LogFile, Tab(70); "    Initializing Group 2 of " & PS.Group.Status & " : Group Key  ";
    
'   Because WinPS supplies the Group-keys as is, we have to swap then back to Intel binary format
    Print #LogFile, SwpWord(PS.Group.Key.Country); SwpWord(PS.Group.Key.State); PS.Match(1); PS.Match(2); PS.Match(3)

    Return
'-----------------------------------------------------------------------
M41:
'   This module is called when WinPS detects a control-break at level 1 which
'   is the least significant (changes the most often).
'   It is also called when a more significant control-break was called.
'   The module must initialize group 1 specific variables.
'   When a report is being printed, then group-specific headlines may be built
'   but not yet output. Instead an indicator should be set to true indicating
'   that the printing of headlines is due.

    Print #LogFile, Tab(70); "      Initializing Group 1 of " & PS.Group.Status & " : Group Key  ";

'   Because WinPS supplies the Group-keys as is, we have to swap then back to Intel binary format
    Print #LogFile, SwpWord(PS.Group.Key.Country); SwpWord(PS.Group.Key.State); SwpWord(PS.Group.Key.City); PS.Match(1); PS.Match(2); PS.Match(3)
    
    Return
'-----------------------------------------------------------------------
M51:
'   WinPS requests this module whenever there is a record from stream 1 in it's buffer
'   ready for processing and after any control-breaks have been performed.
'   If there are records in streams of lesser priority (higher PS.Stream().Number) whose
'   keys mach those of stream 1 then the first of these records is also in it's buffer
'   as signalled by PS.Match().
'   When a report is being printed, then if headlines are due they should
'   be printed before the detail-line(s) are output and the indicator reset.
'   The indicator may be set again in this module when the page is full.

    Print #LogFile, Tab(70); "        Processing Stream 1-" & PS.Group.Status & " : Record Key  ";

'   Because WinPS supplies the Group-keys as is, we have to swap then back to Intel binary format
    Print #LogFile, SwpWord(PS.Group.Key.Country); SwpWord(PS.Group.Key.State); SwpWord(PS.Group.Key.City); PS.Match(1); PS.Match(2); PS.Match(3)

    Return
'-----------------------------------------------------------------------
M52:
'   WinPS requests this module whenever there is a record from stream 2 in it's buffer
'   ready for processing and after any control-breaks have been performed.
'   If there are records in streams of lesser priority (higher PS.Stream().Number) whose
'   keys mach those of stream 2 then the first of these records is also in it's buffer
'   as signalled by PS.Match().
'   When a report is being printed, then if headlines are due they should
'   be printed before the detail-line(s) are output and the indicator reset.
'   The indicator may be set again in this module when the page is full.

    Print #LogFile, Tab(70); "        Processing Stream 2-" & PS.Group.Status & " : Record Key  ";

'   Because WinPS supplies the Group-keys as is, we have to swap then back to Intel binary format
    Print #LogFile, SwpWord(PS.Group.Key.Country); SwpWord(PS.Group.Key.State); SwpWord(PS.Group.Key.City); PS.Match(1); PS.Match(2); PS.Match(3)
    
    Return
'-----------------------------------------------------------------------
M53:
'   WinPS requests this module whenever there is a record from stream 3 in it's buffer
'   ready for processing and after any control-breaks have been performed.
'   When a report is being printed, then if headlines are due they should
'   be printed before the detail-line(s) are output and the indicator reset.
'   The indicator may be set again in this module when the page is full.
							      
    Print #LogFile, Tab(70); "        Processing Stream 3-" & PS.Group.Status & " : Record Key  ";

'   Because WinPS supplies the Group-keys as is, we have to swap then back to Intel binary format
    Print #LogFile, SwpWord(PS.Group.Key.Country); SwpWord(PS.Group.Key.State); SwpWord(PS.Group.Key.City); PS.Match(1); PS.Match(2); PS.Match(3)
    
    Return
'-----------------------------------------------------------------------
M61:
'   This module is requested when WinPS detects a control-break (group-change) at
'   level 1. It must terminate the old group, e.g. by outputting accumulated subtotals
'   and by adding them into the next higher group.
'   This module is also requested when a more significant group ends, and at End of Run.
'   When a report is being printed, then before printing subtotals you may
'   want to check PS.Groups.Status to see if higher group-ends follow.

    Print #LogFile, Tab(70); "      Terminating Group 1 of " & PS.Group.Status & " : Group Key  ";

'   Because WinPS supplies the Group-keys as is, we have to swap then back to Intel binary format
    Print #LogFile, SwpWord(PS.Group.Key.Country); SwpWord(PS.Group.Key.State); SwpWord(PS.Group.Key.City)
    
    Return
'-----------------------------------------------------------------------
M62:
'   This module is requested when WinPS detects a control-break (group-change) at
'   level 2. It must terminate the old group, e.g. by outputting accumulated subtotals
'   and by adding them into the next higher group.
'   This module is also requested when a more significant group ends, and at End of Run.
'   When a report is being printed, then before printing subtotals you may
'   want to check PS.Groups.Status to see if higher group-ends follow.

    Print #LogFile, Tab(70); "    Terminating Group 2 of " & PS.Group.Status & " : Group Key  ";

'   Because WinPS supplies the Group-keys as is, we have to swap then back to Intel binary format
    Print #LogFile, SwpWord(PS.Group.Key.Country); SwpWord(PS.Group.Key.State)
    
    Return
'-----------------------------------------------------------------------
M63:
'   This module is requested when WinPS detects a control-break (group-change) at
'   level 1. It must terminate the old group, e.g. by outputting accumulated subtotals
'   and by adding them into the grand total.
'   This module is also requested at End of Run.
'   When a report is being printed, then before printing subtotals you may
'   want to check PS.Groups.Status to see if End of Run is imminent.

    Print #LogFile, Tab(70); "  Terminating Group 3 of " & PS.Group.Status & " : Group Key  ";

'   Because WinPS supplies the Group-keys as is, we have to swap then back to Intel binary format
    Print #LogFile, SwpWord(PS.Group.Key.Country)
    
    Return
'-----------------------------------------------------------------------
M70:
'   Module 70 is called at End of Run after all control-breaks have been performed
'   It may output accumulated grand totals and do other termination work.

    Print #LogFile, Tab(70); "Terminating Processing"
    Return
'-----------------------------------------------------------------------
M80:
'   Module 80 is responsible for physically terminating the run, e.g closing any
'   files not controlled by WinPS and for providing a means to exit the run unit.
'   Alternately, if there is a next program phase which would re-use WinPS then
'   this next phase may be entered with a re-initialized PS-structure or with a
'   different (but initialized) structure. If WinPS is called after M80 and finds
'   a 'used' structure then it produces an error

    EoR = True      'to get out
    
    Screen.MousePointer = 0
    
    Return
'-----------------------------------------------------------------------

End Sub

