/***************************************************************************/
/*                                                                         */
/* SAMPLE.c                                                                */
/*                                                                         */
/*   Sample MS-Windows program which opens a btrieve file and allows a     */
/*   limited number of operations to be performed on the file              */
/*                                                                         */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/
#include <windows.h>
#include "sample.h"
#include "globals.h"

/* main initialization routine   */
extern int initSample (HANDLE, HANDLE, int);

/* Dialog Procedures  */
extern BOOL far pascal AboutBoxWindowProc (HWND,unsigned,WORD,LONG);
extern BOOL far pascal OpenFileBoxWindowProc (HWND,unsigned,WORD,LONG);
extern BOOL far pascal BtrvOpsListBoxWindowProc (HWND,LONG);

/* Btrieve DLL interface functions */
extern int SHELLINIT (char far *);
extern int BTRVINIT (char far *);
extern int BTRVSTOP (void);
extern unsigned BTRV (int, char far *, char far *, unsigned far *, char far *, int);

/* Main message handler procedure */
long far pascal WndProc (HWND, unsigned, WORD, LONG);


/* Starting entry point  */
int PASCAL WinMain (hInstance, hPrevInstance, lpszCmdLine, nCmdShow)
    HANDLE   hInstance, hPrevInstance;
    LPSTR    lpszCmdLine;
    int      nCmdShow;
{
    MSG         msg;
    int      btrInitStat;
    char     errMsg[200];

    if (!initSample (hInstance, hPrevInstance, nCmdShow))
       return (FALSE);

/****** Uncomment if initialization is desired.  Set your parameters in
        the call.  *****/
/*
    if (btrInitStat = BTRVINIT ((char far *) "/m:48 /p:2048 /t:c:\\tmp\\btrieve.trn"))
    {
       sprintf (errMsg, "Error on BTRVINIT : %x", btrInitStat);
       MessageBox (NULL, errMsg, " ERROR ", MB_OK);
       DestroyWindow (parentWnd);
       return (FALSE);
    }
*/

    while (GetMessage (&msg, NULL, 0,0))
    {
       if (hDlgModeless == 0 || !IsDialogMessage (hDlgModeless, &msg))
       {
          TranslateMessage (&msg);
          DispatchMessage (&msg);
       }
    }
    return (msg.wParam);
}


LONG FAR PASCAL WndProc (hWnd, iMessage, wParam, lParam)
     HWND      hWnd;
     unsigned  iMessage;
     WORD      wParam;
     LONG      lParam;
{
     unsigned i, j, k;
     static short xChar, yChar, xClient, yClient;
     static short nVscrollPos, nHscrollPos;
     static short nVscrollMax, nHscrollMax;
     short        nHscrollInc, nVscrollInc;
     short        nPaintBeg, nPaintEnd;
     HDC          hDC;
     PAINTSTRUCT  ps;
     TEXTMETRIC   tm;
     FARPROC      lpprocAddress;
     FARPROC      OpsProcAddress;


     switch (iMessage)
     {
        case WM_COMMAND :            /* All WM_COMMAND messages are internal */
             switch (wParam)         /* to this application                  */
             {
                 case SAMPLE_ABOUT   :
                      lpprocAddress = MakeProcInstance (AboutBoxWindowProc,
                                                        parentInst);
                      DialogBox (parentInst, "ABOUTBOX", parentWnd, lpprocAddress);
                      FreeProcInstance (lpprocAddress);
                      break;

                 case SAMPLE_EXECUTE    :
                      textlines [0][0] = 0;
                      textlines [2][0] = 0;
                      textlines [3][0] = 0;

                      if ((posBlk = GlobalLock (hPosBlk)) == NULL)
                      {
                         MessageBox (NULL, "ERROR - Could not lock POSBLK",
                                    " ERROR ", MB_OK);
                         break;
                      }
                      btrstat = BTRV (op, (char far *) posBlk,
                                      (char far *) dataBuf,
                                      (unsigned far *) &dataLen,
                                      (char far *) keyBuf, keyNum);

                      GlobalUnlock (hPosBlk);
                      sprintf (textlines[0], "Btrieve Status for %s = %d", Operations[opNdx], btrstat);
                      if (((op >= 5) && (op <= 13)) && (btrstat == 0))
                      {
                         strcpy (textlines [2], "Key     Record");
                         sprintf (textlines [3], "%d  : %s", *((int *) dataBuf), &dataBuf[2]);
                      }
                      InvalidateRect (hWnd, NULL, TRUE);
                      break;

                 case SAMPLE_OPENFILE:
                      if (fileIsOpen)
                      {
                         SendMessage (hDlgModeless, WM_COMMAND, SAMPLE_OPCLOSE, 0L);
                         FreeProcInstance (OpsProcAddress);
                      }
                      lpprocAddress = MakeProcInstance (OpenFileBoxWindowProc,
                                                        parentInst);
                      DialogBox (parentInst, "BTROPENBOX", parentWnd, lpprocAddress);
                      FreeProcInstance (lpprocAddress);
                      if (fileIsOpen)
                      {
                         dataLen = 100;
                         OpsProcAddress = MakeProcInstance (
                                          BtrvOpsListBoxWindowProc,
                                          parentInst);
                         hDlgModeless = CreateDialog (parentInst,
                                        "BTRVOPSBOX", parentWnd,
                                         OpsProcAddress);
                      }
                      break;

                 default:
                      break;
              }
              break;

                                        /* All following messages are sent  */
                                        /* to the application by MS-Windows */

        case WM_CREATE  :               /* Sent during CreateWindow ()      */
             hDC = GetDC (hWnd);
             GetTextMetrics (hDC, &tm);
             xChar = tm.tmAveCharWidth;
             yChar = tm.tmHeight + tm.tmExternalLeading;
             ReleaseDC (hWnd, hDC);
             if ((hPosBlk = GlobalAlloc (GHND, (LONG) 128)) == NULL)
                MessageBox (NULL, "ERROR - Could not allocate POSBLK",
                           " ERROR ", MB_OK);
             break;

        case WM_SIZE    :               /* Sent when window is re-sized    */
             yClient = HIWORD (lParam);
             xClient = LOWORD (lParam);

             nVscrollMax = max (0, NUMLINES + 2 - yClient / yChar);
             nVscrollPos = min (nVscrollPos, nVscrollMax);
             nHscrollMax = max (0, MAXWIDTH + 2 - xClient / xChar);
             nHscrollPos = min (nHscrollPos, nHscrollMax);

             SetScrollRange (hWnd, SB_VERT, 0, nVscrollMax, FALSE);
             SetScrollPos   (hWnd, SB_VERT, nVscrollPos, TRUE);
             SetScrollRange (hWnd, SB_HORZ, 0, nHscrollMax, FALSE);
             SetScrollPos   (hWnd, SB_HORZ, nHscrollPos, TRUE);
             break;


        case WM_VSCROLL :               /* Sent when vertical scroll bar  */
             switch (wParam)            /* is clicked up or down          */
             {
                 case SB_TOP      :
                      nVscrollInc = -nVscrollPos;
                      break;

                 case SB_BOTTOM   :
                      nVscrollInc = nVscrollMax - nVscrollPos;
                      break;

                 case SB_LINEUP   :
                      nVscrollInc = -1;
                      break;

                 case SB_LINEDOWN :
                      nVscrollInc = 1;
                      break;

                 case SB_PAGEUP   :
                      nVscrollInc = min (-1, -yClient / yChar);
                      break;

                 case SB_PAGEDOWN :
                      nVscrollInc = max (1, yClient / yChar);
                      break;

                 case SB_THUMBTRACK :
                      nVscrollInc = LOWORD (lParam) - nVscrollPos;
                      break;

                 default :
                      nVscrollInc = 0;
                      break;
             }
             if (nVscrollInc = max (-nVscrollPos,
                               min (nVscrollInc, nVscrollMax - nVscrollPos)))
             {
                nVscrollPos += nVscrollInc;
                ScrollWindow (hWnd, 0, -yChar * nVscrollInc, NULL, NULL);
                SetScrollPos (hWnd, SB_VERT, nVscrollPos, TRUE);
                UpdateWindow (hWnd);
             }
             break;


        case WM_HSCROLL :           /* Sent when horizontal scroll bar is  */
             switch (wParam)        /* clicked right or left               */
             {
                case SB_LINEUP   :
                     nHscrollInc = -1;
                     break;

                case SB_LINEDOWN :
                     nHscrollInc = 1;
                     break;

                case SB_PAGEUP   :
                     nHscrollInc = -8;
                     break;

                case SB_PAGEDOWN  :
                     nHscrollInc = 8;
                     break;

                case SB_THUMBPOSITION :
                     nHscrollInc = LOWORD (lParam) - nHscrollPos;
                     break;

                default :
                     nHscrollInc = 0;
             }
             if (nHscrollInc = max (-nHscrollPos,
                               min (nHscrollInc, nHscrollMax - nHscrollPos)))
             {
                nHscrollPos += nHscrollInc;
                ScrollWindow (hWnd, -xChar * nHscrollInc, 0, NULL, NULL);
                SetScrollPos (hWnd, SB_HORZ, nHscrollPos, TRUE);
             }
             break;


        case WM_KEYDOWN :               /* Sent when a key is pressed     */
             for (i = 0; i < NUMKEYS; i++)
             {
                if (wParam == keyScroll [i].wVirtKey)
                {
                   SendMessage (hWnd, keyScroll [i].iMessage,
                                keyScroll [i].wRequest, 0L);
                   break;
                }
             }
             break;

        case WM_PAINT   :              /* Sent to re-paint the screen    */
             BeginPaint (hWnd, &ps);
             nPaintBeg = max (0, nVscrollPos + ps.rcPaint.top / yChar -1);
             nPaintEnd = min (NUMLINES,
                              nVscrollPos + ps.rcPaint.bottom / yChar);

             for (i = nPaintBeg; i < nPaintEnd; i++)
                TextOut (ps.hdc, xChar * (1 - nHscrollPos),
                         yChar * (1 - nVscrollPos + i),
                         &textlines[i][0], strlen (&textlines[i][0]));

             EndPaint (hWnd, &ps);
             break;

        case WM_CLOSE   :          /* Sent when system menu CLOSE is */
                                   /* selected                       */
             if (fileIsOpen)       /* Close file if left open        */
             {
                posBlk = GlobalLock (hPosBlk);
                BTRV (1, posBlk, dataBuf, &dataLen, keyBuf, 0);
             }
             GlobalFree (hPosBlk);

             BTRVSTOP ();          /* Terminate session with Btrieve */

        case WM_DESTROY :
             PostQuitMessage (0);
             break;

        default:                   /* All other messages handled by the */
                                   /* default Window handler            */
             return (DefWindowProc (hWnd, iMessage, wParam, lParam));
      }
return ((long) 0);
}
